# Contributing to LLaMA Paper List

Anyone interested in LLaMA is welcomed to contribute to this repo:

## Pull Requests

In general, we follow the "fork-and-pull" Git workflow.

1. Fork this repo on your personal GitHub.

2. Clone this repo to your own machine.
    ```
    git clone https://github.com/<your_username>/LLaMA-Paper-List.git
    ```

3. Make necessary changes and commit those changes.
    
-  If you go to this project directory and execute the command `git status`, you'll see there are changes.

- Add those changes to the branch using the `git add` command:
    ```
    git add <your_contributor_files>
    ```
- Now commit those changes using the `git commit` command:
    ```
    git commit -m "add(<your_name>): commit message"
    ```
    * There are some standards of commit message.
    * `Template:` add/feature/polish(committer_name or project_name): commit message
    * `For example:` add(jrn): add one paper about VE on #neurips2021


4. Push your work back up to your fork.
    ```
    git push origin <your_branch_name>
    ```

5. Submit a Pull request so that we can review your changes.

- If you go to your repository on GitHub, you'll see a `Contribute` button. Click on that button. Then click `Open pull request` and `Create pull request` buttons in turn.

- Soon We will be merging all your changes into the main branch of this repo. You will get a notification email once the changes have been merged.
