export function registerTextGroupClass(Zdog) {

  // Zdog.TextGroup class
  class ZdogTextGroup extends Zdog.Group {
    
    constructor(props) {
      // Set missing props to default values
      props = Zdog.extend({
        font: null,
        value: '',
        fontSize: 64,
        textAlign: 'left',
        textBaseline: 'bottom',
        color: '#333',
        fill: false,
        stroke: 1,
      }, props);
      // Split props
      const {
        font,
        value,
        fontSize,
        textAlign,
        textBaseline,
        color,
        fill,
        stroke,
        ...groupProps
      } = props;
      // Create group object
      super({
        ...groupProps,
        visible: false, // hide until font is loaded
      });
      this._font = null;
      this._value = value;
      this._fontSize = fontSize;
      this._textAlign = textAlign;
      this._textBaseline = textBaseline;
      this._color = color;
      this._fill = fill;
      this._stroke = stroke;
      this.font = font;
    }

    updateText() {
      // Remove old children
      while (this.children.length > 0) {
        this.removeChild(this.children[0]);
      }
      // Get text paths for each glyph
      const glyphs = this.font.getTextGlyphs(this.value, this.fontSize, 0, 0, 0, this.textAlign, this.textBaseline);
      // Convert glyphs to new shapes
      glyphs.filter(shape => shape.path.length > 0).forEach(shape => {
        this.addChild(new Zdog.Shape({
          translate: shape.translate,
          path: shape.path,
          color: this.color,
          fill: this.fill,
          stroke: this.stroke,
          closed: true,
        }));
      });
      this.updateFlatGraph();
    }

    set font(newFont) {
      this._font = newFont;
      this._font.waitForLoad().then(() => {
        this.updateText();
        this.visible = true;
        // Find root Zdog.Illustration instance
        let root = this.addTo;
        while (root.addTo !== undefined) {
          root = root.addTo;
        }
        // Update render graph
        if (root && typeof root.updateRenderGraph === 'function') {
          root.updateRenderGraph();
        }
      });
    }

    get font() {
      return this._font;
    }

    set value(newValue) {
      this._value = newValue;
      this.updateText();
    }
    
    get value() {
      return this._value;
    }

    set fontSize(newSize) {
      this._fontSize = newSize;
      this.updateText();
    }

    get fontSize() {
      return this._fontSize;
    }

    set textAlign(newValue) {
      this._textAlign = newValue;
      this.updateText();
    }

    get textAlign() {
      return this._textAlign;
    }

    set textBaseline(newValue) {
      this._textBaseline = newValue;
      this.updateText();
    }

    get textBaseline() {
      return this._textBaseline;
    }

    set color(newColor) {
      this._color = newColor;
      this.children.forEach(child => child.color = newColor);
    }

    get color() {
      return this._color;
    }

    set fill(newFill) {
      this._fill = newFill;
      this.children.forEach(child => child.fill = newFill);
    }

    get fill() {
      return this._fill;
    }

    set stroke(newStroke) {
      this._stroke = newStroke;
      this.children.forEach(child => child.stroke = newStroke);
    }

    get stroke() {
      return this._stroke;
    }
  }

  ZdogTextGroup.optionKeys = ZdogTextGroup.optionKeys.concat(['color', 'fill', 'stroke', 'font', 'fontSize', 'value', 'textAlign', 'textBaseline']);
  Zdog.TextGroup = ZdogTextGroup;
  return Zdog;
}