import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      xmlSpace='preserve'
      enableBackground='new 0 0 24 24'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M16 8.1c-1.5-1.5-3.8-2-5.8-1.2s-3.3 2.8-3.3 4.9c0 1 .3 2 .8 2.8l.1.2-.5 2 2-.5.2.1c.8.5 1.8.7 2.7.8 2.2 0 4.1-1.3 5-3.3.8-2 .3-4.3-1.2-5.8zm-.8 5.8c-.2.4-.6.7-1.1.8-.3.1-.7 0-1-.1-.2-.1-.5-.2-.9-.3-1.1-.6-2.1-1.4-2.8-2.4-.4-.5-.6-1.1-.7-1.7 0-.5.2-1 .6-1.3.1-.1.3-.2.4-.2h.3c.1 0 .2 0 .4.3.1.3.5 1.1.5 1.2v.3c0 .1-.1.2-.2.3-.1.1-.2.2-.2.3-.1.1-.2.2-.1.3.2.4.5.8.9 1.1.4.3.8.6 1.3.8.2.1.3.1.3 0 .1-.1.4-.5.5-.6.1-.2.2-.1.4-.1.1.1.9.4 1.1.5.2.1.3.1.3.2v.6z' />
      <path d='M21 7.1c0-.4 0-.8-.1-1.2-.2-1.1-.9-2-1.9-2.5-.3-.2-.7-.3-1-.3-.3-.1-.7-.1-1.1-.1H7.1c-.4 0-.8 0-1.2.1-1.1.2-2 .9-2.5 1.9-.1.3-.2.7-.3 1-.1.4-.1.7-.1 1.1V17c0 .4 0 .8.1 1.1.2 1.1.9 2 1.9 2.5.3.2.7.3 1 .3.4.1.8.1 1.2.1H17c.4 0 .8 0 1.1-.1 1.1-.2 2-.9 2.5-1.9.2-.3.3-.7.3-1 .1-.4.1-.8.1-1.2V7.1zm-8.8 11.2c-1.1 0-2.1-.3-3.1-.8l-3.4.9.9-3.3c-.6-1-.9-2.1-.9-3.2 0-2.6 1.5-5 4-6s5.2-.4 7 1.5c1.2 1.2 1.9 2.8 1.9 4.5 0 1.7-.7 3.3-1.9 4.6-1.1 1.1-2.8 1.8-4.5 1.8z' />
    </svg>
  );
};
