import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      xmlSpace='preserve'
      enableBackground='new 0 0 24 24'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M19.1 4.6C15.5 1.3 10 1 6.1 4S1 12.4 3.4 16.7L2 21.8l5.3-1.4c1.4.8 3.1 1.2 4.7 1.2 4 0 7.6-2.5 9.1-6.2 1.6-3.6.8-7.9-2-10.8zM12 20c-1.5 0-2.9-.4-4.2-1.2l-.3-.2-3.1.8.8-3.1-.2-.2C3 12.9 3.5 8.7 6.1 6s6.7-3.3 10-1.5 4.9 5.7 4 9.3c-1 3.7-4.3 6.2-8.1 6.2zm4.5-6.2c-.3-.1-1.5-.7-1.7-.8-.2-.1-.4-.1-.6.1-.2.3-.5.7-.8 1-.1.2-.3.2-.5.1-.7-.3-1.4-.7-2-1.2-.5-.5-1-1.1-1.4-1.7-.1-.3 0-.4.1-.5l.4-.4c.1-.1.2-.3.3-.4.1-.1.1-.3 0-.4 0-.2-.5-1.4-.8-1.9s-.4-.6-.5-.6h-.5c-.2 0-.5.1-.7.3-.5.5-.8 1.3-.8 2 .1.9.4 1.8 1 2.6 1.1 1.6 2.5 2.9 4.3 3.8.5.2.9.4 1.4.5.5.2 1 .2 1.6.1.7-.1 1.3-.6 1.7-1.2.2-.4.2-.8.2-1.2-.2-.1-.4-.1-.7-.2z' />
    </svg>
  );
};
