import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M3.56696 1.33333H20.3289C20.9351 1.33333 21.5165 1.57414 21.9451 2.0028C22.3738 2.43145 22.6146 3.01283 22.6146 3.61904V20.3809C22.6146 20.9872 22.3738 21.5685 21.9451 21.9972C21.5165 22.4258 20.9351 22.6667 20.3289 22.6667H3.56696C2.96076 22.6667 2.37937 22.4258 1.95072 21.9972C1.52207 21.5685 1.28125 20.9872 1.28125 20.3809V3.61904C1.28125 3.01283 1.52207 2.43145 1.95072 2.0028C2.37937 1.57414 2.96076 1.33333 3.56696 1.33333ZM5.9 18.4C7.3 20.2 9.4 21.1 12.1 21.1C14.6 21.1 16.3 20.5 17.6 19C19.5 17.2 19.4 15 18.8 13.6C18.4 12.6 17.5 11.8 16.4 11.3C16.4 11.3 16.3 11.2 16.2 11.2C16.1 8.59999 14.6 7.09999 12.2 7.09999C10.8 7.09999 9.5 7.69999 8.8 8.79999L10 9.79999C10.6 8.99999 11.5 8.79999 12.1 8.79999C12.9 8.79999 13.5 9.09999 13.9 9.49999C14.2 9.79999 14.4 10.2 14.5 10.8C13.8 10.7 13 10.7 12.2 10.7C11.1 10.8 10.2 11.1 9.5 11.7C8.8 12.3 8.5 13.1 8.5 14C8.6 14.9 9 15.7 9.9 16.3C10.6 16.7 11.5 16.9 12.4 16.9C13.6 16.8 14.5 16.3 15.2 15.5C15.7 14.9 16.1 14 16.2 13C16.7 13.3 17.2 13.8 17.4 14.3C17.8 15.2 17.9 16.7 16.6 17.9C15.5 19 14.2 19.5 12.2 19.5C10 19.4 8.3 18.8 7.2 17.4C6.1 16.2 5.6 14.3 5.6 12C5.7 9.69999 6.2 7.89999 7.2 6.59999C8.3 5.19999 10 4.49999 12.2 4.49999C15.5 4.59999 17.7 6.09999 18.5 9.09999L20 8.69999C19.5 6.89999 18.6 5.49999 17.3 4.49999C15.9 3.49999 14.2 2.89999 12.1 2.89999C9.4 2.99999 7.3 3.79999 5.9 5.59999C4.7 7.09999 4 9.29999 4 12C4 14.7 4.7 16.9 5.9 18.4ZM12.3 12.2H12.9C13.2303 12.2 13.5606 12.2303 13.8576 12.2575C14.1 12.2798 14.3202 12.3 14.5 12.3C14.3 14.7 13.1 15.1 12.2 15.1C11.2 15.2 10.2 14.8 10.1 13.8C10 12.9 10.9 12.3 12.3 12.2Z'
      />
    </svg>
  );
};
