import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M3.56696 1.33333H20.3289C20.9351 1.33333 21.5165 1.57414 21.9451 2.0028C22.3738 2.43145 22.6146 3.01283 22.6146 3.61904V20.3809C22.6146 20.9872 22.3738 21.5685 21.9451 21.9972C21.5165 22.4258 20.9351 22.6667 20.3289 22.6667H3.56696C2.96076 22.6667 2.37937 22.4258 1.95072 21.9972C1.52207 21.5685 1.28125 20.9872 1.28125 20.3809V3.61904C1.28125 3.01283 1.52207 2.43145 1.95072 2.0028C2.37937 1.57414 2.96076 1.33333 3.56696 1.33333ZM19.3787 14.9271C19.6199 15.0612 19.8316 15.223 19.9428 15.5256C20.0675 15.864 19.991 16.2475 19.6869 16.5729L19.6828 16.5778C19.5601 16.7136 19.4149 16.8273 19.2536 16.9138C18.9335 17.0896 18.593 17.2252 18.2398 17.3177C18.1721 17.3358 18.108 17.3651 18.0501 17.4044C17.9896 17.4579 17.9645 17.5245 17.9331 17.6075C17.9094 17.6703 17.8822 17.7425 17.8334 17.8254C17.7497 17.9714 17.6346 18.0971 17.4966 18.1933C17.1663 18.4215 16.7951 18.4358 16.4018 18.4509L16.4005 18.4509C16.0456 18.4644 15.6433 18.4797 15.184 18.6316C14.9988 18.6929 14.8022 18.8135 14.5745 18.9533L14.5729 18.9543C14.0183 19.2939 13.2594 19.7586 11.9991 19.7586C10.7376 19.7586 9.98374 19.2955 9.4331 18.957C9.20376 18.8147 9.00591 18.6929 8.81541 18.6299C8.35552 18.4783 7.95285 18.4627 7.59761 18.4493C7.20435 18.4341 6.83316 18.4198 6.50286 18.1917C6.38628 18.1108 6.2859 18.0087 6.20689 17.8908C6.13019 17.7797 6.09485 17.6857 6.0651 17.6066C6.0338 17.5234 6.00869 17.4566 5.94812 17.4036C5.88637 17.3623 5.81809 17.3318 5.74618 17.3132C5.3977 17.221 5.06177 17.0866 4.74586 16.913C4.59403 16.8322 4.45604 16.7277 4.33706 16.6035C4.01289 16.2708 3.9295 15.8759 4.05704 15.5288C4.20148 15.1363 4.51446 14.9794 4.84272 14.8147C4.89909 14.7864 4.9559 14.7579 5.01239 14.728C5.74005 14.3327 6.30991 13.8389 6.70807 13.2563C6.82158 13.092 6.92021 12.9178 7.00281 12.7359C7.04165 12.6297 7.04083 12.572 7.01467 12.5185C6.98663 12.4747 6.94955 12.4375 6.90593 12.4093C6.78125 12.3267 6.65411 12.2442 6.56704 12.1877C6.53364 12.1659 6.50166 12.145 6.47122 12.1251C6.35489 12.0491 6.26107 11.9878 6.19626 11.9425C5.88762 11.7266 5.67178 11.4973 5.53647 11.241C5.44253 11.0636 5.38789 10.868 5.37625 10.6676C5.36461 10.4672 5.39625 10.2667 5.46902 10.0796C5.6726 9.54162 6.18155 9.20763 6.7976 9.20763C6.92746 9.20751 7.05696 9.22122 7.18391 9.24851C7.21784 9.25587 7.25136 9.26364 7.28447 9.27222C7.27916 8.90635 7.28734 8.51595 7.32004 8.13373C7.43614 6.79125 7.90666 6.08567 8.39721 5.52399C8.71164 5.17104 9.0824 4.87267 9.49442 4.64099C10.2397 4.21584 11.0797 4 11.9999 4C12.9201 4 13.7643 4.21584 14.5087 4.64099C14.9197 4.8726 15.2897 5.17038 15.6039 5.52235C16.0944 6.08403 16.5649 6.78839 16.681 8.1321C16.7137 8.51432 16.7219 8.90267 16.7162 9.27059C16.7493 9.262 16.7832 9.25424 16.8172 9.24688C16.9441 9.21958 17.0736 9.20588 17.2035 9.206C17.8191 9.206 18.3272 9.53998 18.5316 10.078C18.6041 10.265 18.6354 10.4654 18.6235 10.6656C18.6116 10.8658 18.5567 11.061 18.4626 11.2381C18.3277 11.4944 18.1118 11.7238 17.8032 11.9396C17.721 11.9981 17.5935 12.0806 17.4324 12.1849C17.342 12.2433 17.2088 12.33 17.0796 12.4154C17.041 12.4418 17.0083 12.4759 16.9835 12.5156C16.9586 12.5671 16.957 12.6235 16.9917 12.7229C17.0754 12.9086 17.1757 13.0865 17.2914 13.2543C17.6985 13.8503 18.2855 14.3531 19.0373 14.7517C19.0756 14.7716 19.114 14.7909 19.1522 14.8102C19.187 14.8277 19.2217 14.8452 19.256 14.8629C19.2916 14.8793 19.3333 14.9005 19.3787 14.9271ZM17.8832 16.4851C18.1413 16.4164 18.447 16.3349 18.8215 16.1281C19.2568 15.8857 19.0099 15.7369 18.8636 15.6637C16.3859 14.4664 15.991 12.6145 15.9734 12.4751C15.9727 12.4695 15.972 12.4639 15.9712 12.4583C15.9508 12.2998 15.9342 12.1722 16.1116 12.0087C16.232 11.8972 16.6337 11.6369 16.9469 11.434C17.0943 11.3385 17.2221 11.2557 17.2918 11.207C17.6527 10.9552 17.8105 10.7038 17.6936 10.3948C17.6119 10.1822 17.4136 10.1004 17.2031 10.1004C17.1369 10.1006 17.071 10.108 17.0064 10.1225C16.7732 10.1731 16.5439 10.2628 16.3494 10.3389C16.2139 10.3918 16.0954 10.4382 16.0041 10.4602C15.9773 10.4671 15.9499 10.4708 15.9223 10.4712C15.8038 10.4712 15.7608 10.4185 15.7702 10.2758C15.7712 10.2607 15.7722 10.2452 15.7732 10.2291C15.802 9.78454 15.8545 8.97167 15.7886 8.21059C15.6958 7.12564 15.3459 6.58808 14.9302 6.11265C14.7307 5.88495 13.7908 4.89853 11.9983 4.89853C10.2057 4.89853 9.26835 5.88904 9.06886 6.11756C8.65353 6.59298 8.30401 7.13055 8.21039 8.21549C8.14763 8.94046 8.1944 9.71208 8.22204 10.1682C8.22447 10.2082 8.22675 10.2458 8.22879 10.2807C8.23697 10.4164 8.19527 10.4761 8.07672 10.4761C8.04913 10.4757 8.02169 10.4719 7.99496 10.4651C7.90396 10.4431 7.78569 10.3969 7.65053 10.344C7.456 10.2679 7.22649 10.1781 6.993 10.1274C6.92845 10.113 6.86252 10.1055 6.79637 10.1053C6.58707 10.1053 6.38758 10.1859 6.30582 10.3997C6.1889 10.7087 6.34752 10.9601 6.70807 11.212C6.77786 11.2607 6.90587 11.3436 7.05345 11.4393C7.36663 11.6423 7.76795 11.9025 7.88826 12.0136C8.06551 12.1774 8.04901 12.3052 8.02849 12.4641C8.02781 12.4694 8.02712 12.4747 8.02644 12.48C8.00886 12.6174 7.61355 14.4692 5.13626 15.6686C4.99114 15.7389 4.74422 15.8877 5.17959 16.1281C5.55314 16.3334 5.85832 16.4145 6.11607 16.4829C6.32994 16.5397 6.51115 16.5878 6.67169 16.691C6.83395 16.7956 6.8567 16.9655 6.87784 17.1234C6.89578 17.2574 6.91256 17.3827 7.01263 17.4518C7.12902 17.5321 7.34417 17.5403 7.63379 17.5514C8.01245 17.5659 8.51841 17.5852 9.09748 17.7768C9.38816 17.8726 9.64073 18.0278 9.90666 18.1912C10.4261 18.5104 10.9964 18.8609 12.0011 18.8609C13.0095 18.8609 13.5859 18.5071 14.1066 18.1876C14.3703 18.0258 14.6197 17.8727 14.9036 17.7788C15.4838 17.5873 15.9897 17.5679 16.368 17.5534C16.6574 17.5423 16.8722 17.5341 16.9884 17.4538C17.0887 17.3847 17.1054 17.2594 17.1233 17.1253C17.1443 16.9675 17.1669 16.7976 17.3294 16.6931C17.4894 16.5901 17.67 16.5419 17.8832 16.4851Z'
      />
    </svg>
  );
};
