import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M6.782 14.375c0 1.04-.85 1.89-1.891 1.89-1.04 0-1.891-.85-1.891-1.89 0-1.041.85-1.891 1.89-1.891h1.892v1.89ZM7.735 14.375c0-1.041.85-1.891 1.89-1.891 1.041 0 1.891.85 1.891 1.89v4.735c0 1.04-.85 1.891-1.89 1.891-1.041 0-1.891-.85-1.891-1.89v-4.735ZM9.625 6.782c-1.04 0-1.89-.85-1.89-1.891 0-1.04.85-1.891 1.89-1.891 1.041 0 1.891.85 1.891 1.89v1.892h-1.89ZM9.625 7.735c1.041 0 1.891.85 1.891 1.89 0 1.041-.85 1.891-1.89 1.891H4.89c-1.04 0-1.891-.85-1.891-1.89 0-1.041.85-1.891 1.89-1.891h4.735ZM17.218 9.625c0-1.04.85-1.89 1.891-1.89 1.04 0 1.891.85 1.891 1.89 0 1.041-.85 1.891-1.89 1.891h-1.892v-1.89ZM16.265 9.625c0 1.041-.85 1.891-1.89 1.891-1.041 0-1.891-.85-1.891-1.89V4.89c0-1.04.85-1.891 1.89-1.891 1.041 0 1.891.85 1.891 1.89v4.735ZM14.375 17.218c1.04 0 1.89.85 1.89 1.891 0 1.04-.85 1.891-1.89 1.891-1.041 0-1.891-.85-1.891-1.89v-1.892h1.89ZM14.375 16.265c-1.041 0-1.891-.85-1.891-1.89 0-1.041.85-1.891 1.89-1.891h4.735c1.04 0 1.891.85 1.891 1.89 0 1.041-.85 1.891-1.89 1.891h-4.735Z' />
    </svg>
  );
};
