import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      xmlSpace='preserve'
      enableBackground='new 0 0 24 24'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M12 7.5c-2.5 0-4.5 2-4.5 4.5s2 4.5 4.5 4.5 4.5-2 4.5-4.5-2-4.5-4.5-4.5zm0 8c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5zm9.8-1.6c.1-.6.2-1.3.2-1.9 0-.6-.1-1.3-.2-1.9l-2.1-.3c-.2-.6-.4-1.2-.7-1.7l1.3-1.7c-.7-1.1-1.6-2-2.7-2.7L15.9 5l-1.7-.7-.3-2.1L12 2l-1.9.2-.3 2.1-1.7.7-1.7-1.3c-1.1.7-2 1.6-2.7 2.7L5 8.1c-.3.5-.5 1.1-.7 1.7l-2.1.3c-.1.6-.2 1.3-.2 1.9 0 .6.1 1.3.2 1.9l2.1.3c.2.6.4 1.2.7 1.7l-1.3 1.7c.7 1.1 1.6 2 2.7 2.7L8.1 19l1.7.7.3 2.1 1.9.2 1.9-.2.3-2.1 1.7-.7 1.7 1.3c1.1-.7 2-1.6 2.7-2.7L19 15.9c.3-.5.5-1.1.7-1.7l2.1-.3zm-2.9-.7-.2.7c-.1.5-.3 1-.6 1.5l-.3.6.4.5.8 1.1c-.4.5-.9 1-1.4 1.4l-1.1-.8-.5-.4-.6.3c-.5.3-1 .5-1.5.6l-.7.2v.7l-.2 1.3h-2l-.2-1.3v-.7l-.7-.2c-.5-.1-1-.3-1.5-.6l-.6-.3-.5.4-1.1.8c-.5-.4-1-.9-1.4-1.4l.8-1.1.4-.5-.3-.6c-.3-.5-.5-1-.6-1.5l-.2-.7h-.7L3.1 13c-.1-.3-.1-.7-.1-1 0-.3 0-.7.1-1l1.3-.2h.7l.2-.7c.1-.5.3-1 .6-1.5l.3-.6-.4-.5L5 6.4 6.4 5l1.1.8.5.4.6-.3c.5-.3 1-.5 1.5-.6l.7-.2v-.7l.2-1.3h2l.2 1.3v.7l.7.2c.5.1 1 .3 1.5.6l.6.3.5-.4 1.1-.8c.5.4 1 .9 1.4 1.4l-.8 1.1-.4.5.3.6c.3.5.5 1 .6 1.5l.2.7h.7l1.3.2c.1.3.1.7.1 1 0 .3 0 .7-.1 1l-1.3.2h-.7z' />
    </svg>
  );
};
