import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        clipRule='evenodd'
        d='M3.567 1.333h16.762a2.286 2.286 0 0 1 2.286 2.286v16.762a2.286 2.286 0 0 1-2.286 2.286H3.567a2.286 2.286 0 0 1-2.286-2.286V3.619a2.286 2.286 0 0 1 2.286-2.286Zm6.19 12.95c1.269 0 1.92 1.102 2.474 2.193-.355.104-.74.15-1.167.15-2.68 0-3.839-1.892-3.839-5.596 0-3.724 1.159-5.636 3.84-5.636 2.72 0 3.884 1.912 3.884 5.636 0 1.491-.195 2.694-.606 3.585-.691-1.043-1.562-1.86-3.259-1.86-1.09 0-1.94.356-2.465.807l.431.863c.223-.102.465-.142.707-.142Zm1.307 3.737c.62 0 1.243-.087 1.831-.244.7 1.2 1.634 2.224 3.4 2.224 2.917 0 3.24-2.687 3.18-3.334H18.43c-.054.486-.377 1.105-1.179 1.105-.734 0-1.261-.51-1.773-1.277 1.585-1.228 2.675-3.127 2.675-5.464 0-4.202-3.46-7.03-7.09-7.03C7.494 4 4 6.849 4 11.03c0 4.142 3.495 6.99 7.064 6.99Z'
      />
    </svg>
  );
};
