import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='m14.556 6-6.223.444L3 9.556h1.333v4.095c-.258.214-.444.784-.444 1.46 0 .86.299 1.556.667 1.556.368 0 .666-.475.666-1.334 0-.676-.186-1.382-.444-1.655V9.556h4.889L14.556 6ZM12.11 8.222 9.89 10H6.333c-.043.216-.055.208-.055.436 0 .23.023.457.068.674.124-.004 2.654-.221 3.996.89.26-.788.982-1.8 2.007-2.72.094-.085.112-.09.207-.169 0-.444-.205-.632-.445-.889Zm3.778.445a3.977 3.977 0 0 0-2.667 1.03c-.134-.12-.28-.228-.43-.33-.055.047-.11.094-.165.143-.723.648-1.29 1.342-1.656 1.972.539.244.918.78.918 1.407V18h2.667v-5.111c0-.856.7-1.556 1.555-1.556.856 0 1.556.7 1.556 1.556V18h2.666v-5.333c0-2.2-1.8-4-4-4h-.444ZM6.346 11.34a3.938 3.938 0 0 0-.235 1.327V18h2.667v-5.111c0-.385.148-.732.383-1.003-.685-.315-1.686-.52-2.815-.546Z'
      />
    </svg>
  );
};
