import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      xmlSpace='preserve'
      enableBackground='new 0 0 24 24'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M5 9c-1.7 0-3 1.3-3 3s1.3 3 3 3h.5L7 19.3c.3 1 1.3 1.7 2.3 1.7h.2c.5 0 .9-.2 1.2-.6.3-.4.4-.9.2-1.4l-1.3-4h1.8l8.6 3.8V4.7L11.4 9H5zm5 10.3c0 .2 0 .4-.1.5l-.4.2h-.2c-.6 0-1.2-.4-1.4-1l-1.3-4h1.9l1.5 4.3zM5 14c-1.1 0-2-.9-2-2s.9-2 2-2h6v4H5zm14 3.2-7-3V9.8l7-3.5v10.9zM22 9v6h-1V9h1z' />
    </svg>
  );
};
