import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        clipRule='evenodd'
        d='M14.7 2H6.5A1.5 1.5 0 0 0 5 3.5V16h1V3.5a.5.5 0 0 1 .5-.5H14v2.5A1.5 1.5 0 0 0 15.5 7H18v13.5a.5.5 0 0 1-.5.5H15v1h2.5a1.5 1.5 0 0 0 1.5-1.5V6.3L14.7 2Zm.3 1.7L17.3 6h-1.8a.5.5 0 0 1-.5-.5V3.7Z'
      />
      <path d='M4.825 20.519h-.818v1.445H3V17h1.825c1.178 0 1.767.574 1.767 1.723 0 .579-.151 1.024-.453 1.336-.297.306-.735.46-1.314.46Zm-.818-.862h.81c.502 0 .753-.311.753-.934 0-.307-.061-.526-.183-.657-.122-.136-.311-.205-.57-.205h-.81v1.796ZM9.124 20.519h-.818v1.445H7.3V17h1.825c1.178 0 1.766.574 1.766 1.723 0 .579-.15 1.024-.452 1.336-.297.306-.735.46-1.314.46Zm-.818-.862h.81c.502 0 .752-.311.752-.934 0-.307-.06-.526-.182-.657-.122-.136-.312-.205-.57-.205h-.81v1.796ZM11.152 17.89V17h3.65v.89h-1.314v4.074h-1.007v-4.073h-1.329Z' />
    </svg>
  );
};
