import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <g clipPath='url(#a)'>
        <path
          fillRule='evenodd'
          clipRule='evenodd'
          d='M6.5 2h8.2L19 6.3v14.2a1.5 1.5 0 0 1-1.5 1.5h-11A1.5 1.5 0 0 1 5 20.5v-17A1.5 1.5 0 0 1 6.5 2Zm10.8 4L15 3.7v1.8a.5.5 0 0 0 .5.5h1.8Zm.2 15h-11a.5.5 0 0 1-.5-.5v-17a.5.5 0 0 1 .5-.5H14v2.5A1.5 1.5 0 0 0 15.5 7H18v13.5a.5.5 0 0 1-.5.5Zm-9.384-3.89c.09.18.23.343.439.419.207.076.411.04.58-.029.318-.131.635-.436.926-.787a11.31 11.31 0 0 0 1.02-1.51 11.648 11.648 0 0 1 1.998-.405c.3.382.61.712.91.95.28.22.603.403.934.416a.854.854 0 0 0 .51-.138c.154-.1.27-.247.354-.416.09-.18.145-.37.138-.562a.845.845 0 0 0-.2-.519c-.226-.27-.596-.4-.96-.465-.38-.068-.84-.08-1.335-.05a10.95 10.95 0 0 1-.98-1.686c.25-.66.437-1.284.52-1.794.036-.218.054-.426.047-.613a1.238 1.238 0 0 0-.126-.539.7.7 0 0 0-.477-.365c-.202-.043-.41 0-.602.077-.377.151-.575.47-.65.823-.073.34-.04.736.046 1.137.088.405.238.847.43 1.295a19.71 19.71 0 0 1-1.062 2.227 7.656 7.656 0 0 0-1.483.645c-.37.219-.698.48-.896.786-.21.326-.275.714-.08 1.103Zm1.359-1.243c.139-.083.293-.162.458-.239a7.859 7.859 0 0 1-.45.606c-.28.337-.497.516-.634.573a.266.266 0 0 1-.036.012.285.285 0 0 1-.026-.044c-.055-.111-.053-.217.04-.362.106-.164.32-.353.648-.546Zm2.455-1.647c-.119.024-.238.05-.356.077a21.155 21.155 0 0 0 .499-1.05 11.718 11.718 0 0 0 .51.858c-.217.032-.436.07-.653.115Zm2.524.939a3.892 3.892 0 0 1-.434-.41c.228.004.434.021.612.053.317.058.466.147.518.209a.096.096 0 0 1 .025.064.436.436 0 0 1-.059.2.307.307 0 0 1-.094.124.107.107 0 0 1-.069.016c-.091-.004-.258-.066-.499-.256Zm-2.224-4.746a6.67 6.67 0 0 1-.2.828 4.842 4.842 0 0 1-.089-.346c-.076-.353-.087-.63-.046-.821.037-.178.109-.249.196-.283a.518.518 0 0 1 .145-.04c.012.03.028.091.032.197.005.122-.007.277-.038.465Z'
        />
      </g>
      <defs>
        <clipPath id='a'>
          <path d='M0 0h24v24H0z' />
        </clipPath>
      </defs>
    </svg>
  );
};
