import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      width={24}
      height={24}
      viewBox='0 0 24 24'
      xmlns='http://www.w3.org/2000/svg'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path
        clipRule='evenodd'
        d='M6.5 2h8.2L19 6.3V16h-1V7h-2.5A1.5 1.5 0 0 1 14 5.5V3H6.5a.5.5 0 0 0-.5.5V16H5V3.5A1.5 1.5 0 0 1 6.5 2Zm10.8 4L15 3.7v1.8a.5.5 0 0 0 .5.5h1.8Z'
      />
      <path d='M4.35 22.4v-.85c.19 0 .326-.036.411-.107.085-.07.128-.203.128-.396v-3.962h.97l.008 4.004c0 .515-.116.862-.348 1.042-.226.18-.616.269-1.169.269ZM8.36 17.85c-.516 0-.773.17-.773.51 0 .152.064.268.191.348.128.08.426.196.893.347.473.151.803.324.992.517.19.19.284.482.284.88 0 .505-.154.887-.46 1.147-.308.26-.71.39-1.206.39-.368 0-.82-.057-1.353-.17l-.255-.05.099-.758c.633.085 1.117.128 1.453.128.5 0 .75-.208.75-.624a.412.412 0 0 0-.176-.354c-.114-.085-.343-.178-.688-.277-.548-.156-.935-.34-1.162-.553-.222-.217-.333-.517-.333-.9 0-.481.147-.84.44-1.077.292-.236.694-.354 1.204-.354.35 0 .794.047 1.332.142l.256.05-.078.772c-.666-.076-1.137-.114-1.41-.114ZM11.732 20.77c.142.246.404.369.787.369s.642-.123.78-.369c.141-.25.212-.666.212-1.247 0-.586-.07-1.011-.213-1.276-.141-.264-.401-.397-.78-.397-.377 0-.637.133-.779.397-.141.265-.212.69-.212 1.276 0 .58.068.997.205 1.247Zm2.332.624c-.298.397-.813.595-1.545.595s-1.25-.198-1.552-.595c-.298-.402-.447-1.028-.447-1.878 0-.85.15-1.481.447-1.892.302-.416.82-.624 1.552-.624.732 0 1.247.208 1.545.624.302.41.453 1.041.453 1.892 0 .85-.15 1.476-.453 1.878ZM15.356 21.904v-4.819h1.651l1.162 3.968h.071v-3.968h.978v4.819H17.61l-1.205-3.969h-.071v3.969h-.978Z' />
    </svg>
  );
};
