import * as React from 'react';
import { SVGProps } from 'react';
import { SVGRProps } from '.';
export const component = ({ title, titleId, ...props }: SVGProps<SVGSVGElement> & SVGRProps) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      xmlSpace='preserve'
      enableBackground='new 0 0 24 24'
      aria-labelledby={titleId}
      {...props}
    >
      {title ? <title id={titleId}>{title}</title> : null}
      <path d='M7.8 5.8c.5 0 1.1 0 1.6.2.4.1.9.3 1.2.5.4.1.7.5.9.8.2.5.3 1 .3 1.4 0 .5-.1 1.1-.4 1.5-.3.4-.8.8-1.3 1 .7.2 1.3.6 1.7 1.1.4.6.6 1.3.6 2 0 .5-.1 1.1-.3 1.6-.2.4-.6.8-1 1.1-.4.3-.9.5-1.4.6-.6.4-1.2.4-1.7.4H2V5.8h5.8zm-.3 5c.4 0 .8-.1 1.2-.4.3-.3.5-.7.4-1.1 0-.3 0-.5-.1-.8-.1-.1-.2-.3-.4-.4-.2-.1-.4-.2-.6-.2-.2 0-.5-.1-.7-.1H4.7v2.9l2.8.1zm.1 5.2c.3 0 .5 0 .8-.1l.6-.3c.2-.1.3-.3.4-.5.1-.3.2-.5.2-.8 0-.5-.2-1-.5-1.3-.4-.3-.9-.4-1.4-.4h-3V16h2.9zm8.6-.1c.4.4 1 .6 1.6.5.4 0 .9-.1 1.3-.4.3-.2.5-.5.6-.8h2.1c-.2.9-.8 1.7-1.6 2.3-.8.5-1.7.7-2.6.7-.6 0-1.3-.1-1.9-.3-1.1-.4-2-1.3-2.3-2.4-.2-.6-.3-1.2-.3-1.9 0-.6.1-1.3.3-1.9.2-.6.5-1.1.9-1.5.4-.4.9-.8 1.4-1 .7-.2 1.3-.3 1.9-.3.7 0 1.4.1 2 .4.5.3 1 .7 1.4 1.2.4.5.6 1.1.8 1.7.2.7.2 1.3.2 2h-6.4c0 .6.2 1.2.6 1.7zm2.8-4.7c-.4-.3-.9-.5-1.4-.5-.3 0-.7 0-1 .2-.2.1-.5.3-.6.5-.2.2-.3.4-.3.6-.1.2-.1.4-.1.6h4c-.1-.5-.3-1-.6-1.4zm-3.9-4.6h5v1.2h-5V6.6z' />
    </svg>
  );
};
