# Welcome to the Shopify + Next.js + Tailwind CSS course

<div align="center">
  <img src="https://cdn.shopify.com/s/files/1/0524/4390/6207/files/site-preview.gif?v=1630892895" alt="shopify next.js course preview">
  <p align="center">
    <a href="https://shopify-next-js-tailwind.vercel.app//">Live Demo Store</a> | <a href="https://www.buildnextshop.com/">Course</a>
  </p>
</div>



This is a production ready Headless Shopify storefront using Next.js, Shopify Storefront API (GraphQL), Tailwind CSS, and Vercel. This is a project from the "Learn Shopify + Next.js + Tailwind CSS" course available at [www.BuildNextShop.com](https://buildnextshop.com/)

## Topics Covered

* March 2022 Update: Bonus lectures covering Shopify’s Hydrogen 
* February 2022 Update: Using SWR for automatically updating content on SSG (Static Site Generation) websites.
* Blazing fast storefronts using Next.js for eCommerce.
* Managing Cart data with React Context and localStorage.
* Rapid component development with Tailwind CSS.
* GraphQL query testing using the GraphiQL app.
* Shopify Partners Account and Dashboard.
* Shopify Storefront API (GraphQL).
* Vercel for deployment.


## Performance

<table align="center">
  <thead>
    <tr>
      <td>Overview</td>
      <td>Performance Breakdown</td>
    <tr>
  </thead>
  <tbody>
  <tr>
    <td valign="top"><img width="300" src="https://cdn.shopify.com/s/files/1/0524/4390/6207/files/Screen_Shot_2021-09-05_at_7.01.58_PM.png?v=1630893822"/></td>
    <td valign="top"><img width="300" src="https://cdn.shopify.com/s/files/1/0524/4390/6207/files/Screen_Shot_2021-09-05_at_7.02.38_PM.png?v=1630893822"/></td>
  </tr>
  </tbody>
</table>


## Future Updates:
This is an ongoing project that is currently released in beta. Future updates will include:
* Webhooks triggering for product updates, etc. 
* Additional ecommerce ready sections for Next.js using Tailwind CSS (currently 5 are included with the course assets)
* And much more! 


### Credits
Big thank you to the **Shopify, Vercel, and Tailwind Labs** teams for making it so easy and pleasurable to create incredible storefronts with speed. 
