func.func @pad_test() {
  %input = util.unfoldable_constant dense<[[1, 2, 3], [4, 5, 6]]> : tensor<2x3xi32>
  %c0 = arith.constant dense<0> : tensor<i32>
  %res = "stablehlo.pad"(%input, %c0) {
    edge_padding_low = array<i64: 0, 1>,
    edge_padding_high = array<i64: 1, 5>,
    interior_padding = array<i64: 0, 0>
  } : (tensor<2x3xi32>, tensor<i32>) -> tensor<3x9xi32>
  check.expect_eq_const(%res, dense<[
      [0, 1, 2, 3, 0, 0, 0, 0, 0],
      [0, 4, 5, 6, 0, 0, 0, 0, 0],
      [0, 0, 0, 0, 0, 0, 0, 0, 0]]> : tensor<3x9xi32>) : tensor<3x9xi32>
  return
}

func.func @pad_no_op() {
  %input = util.unfoldable_constant dense<[[1, 2, 3], [4, 5, 6]]> : tensor<2x3xi32>
  %c0 = arith.constant dense<0> : tensor<i32>
  %res = "stablehlo.pad"(%input, %c0) {edge_padding_high = array<i64: 0, 0>, edge_padding_low = array<i64: 0, 0>, interior_padding = array<i64: 0, 0>} : (tensor<2x3xi32>, tensor<i32>) -> tensor<2x3xi32>
  check.expect_eq(%res, %input) : tensor<2x3xi32>
  return
}
