// Copyright 2024 The IREE Authors
//
// Licensed under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

// Ordering matters when multiple lines have the same types and tile shape and
// are supported by the CPU. In that case, the last-enumerated line overrides
// preceding lines. Always go from oldest to shiniest code path.
IREE_UK_MMT4D_TILE(arm_64, f32, f32, f32, 1, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f32, f32, f32, 2, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f32, f32, f32, 4, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f32, f32, f32, 8, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 1, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 2, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 4, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 8, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 1, 8, 1, _fp16fml)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 2, 8, 1, _fp16fml)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 4, 8, 1, _fp16fml)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f32, 8, 8, 1, _fp16fml)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 1, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 2, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 4, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 8, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 1, 8, 1, _fullfp16)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 2, 8, 1, _fullfp16)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 4, 8, 1, _fullfp16)
IREE_UK_MMT4D_TILE(arm_64, f16, f16, f16, 8, 8, 1, _fullfp16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, f32, 1, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, f32, 2, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, f32, 4, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, f32, 8, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, bf16, 1, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, bf16, 2, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, bf16, 4, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, bf16, bf16, bf16, 8, 8, 4, _bf16)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 1, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 2, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 4, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 8, 8, 1, )
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 1, 8, 4, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 2, 8, 4, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 4, 8, 4, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 8, 8, 4, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 1, 8, 8, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 2, 8, 8, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 4, 8, 8, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s8, s32, 8, 8, 8, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 1, 16, 2, )
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 2, 16, 2, )
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 4, 16, 2, )
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 1, 8, 8, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 2, 8, 8, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 4, 8, 8, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 8, 8, 8, _dotprod)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 1, 8, 16, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 2, 8, 16, _i8mm)
IREE_UK_MMT4D_TILE(arm_64, s8, s4, s32, 4, 8, 16, _i8mm)
