# Copyright 2020 The IREE Authors
#
# Licensed under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

from absl import app
from iree.tf.support import tf_test_utils
import numpy as np
import tensorflow.compat.v2 as tf


class FillModule(tf.Module):
    def __init__(self):
        pass

    @tf.function(
        input_signature=[tf.TensorSpec([2], tf.int32), tf.TensorSpec([], tf.float32)]
    )
    def fill(self, dims, value):
        return tf.fill(dims, value)


class FillTest(tf_test_utils.TracedModuleTestCase):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._modules = tf_test_utils.compile_tf_module(FillModule)

    def test_fill(self):
        def fill(module):
            dims = np.array([2, 3], dtype=np.int32)
            value = np.array(9.0, dtype=np.float32)
            module.fill(dims, value)

        self.compare_backends(fill, self._modules)


def main(argv):
    del argv  # Unused
    if hasattr(tf, "enable_v2_behavior"):
        tf.enable_v2_behavior()
    tf.test.main()


if __name__ == "__main__":
    app.run(main)
