# Guides

## ML frameworks

!!! info ""

    Start here: [ML frameworks overview](./ml-frameworks/index.md)

Guides for specific frameworks:

* [:simple-python: JAX](./ml-frameworks/jax.md)
* [:simple-onnx: ONNX](./ml-frameworks/onnx.md)
* [:simple-pytorch: PyTorch](./ml-frameworks/pytorch.md)
* [:simple-tensorflow: TensorFlow](./ml-frameworks/tensorflow.md) and
  [:simple-tensorflow: TensorFlow Lite](./ml-frameworks/tflite.md)

## Deployment configurations

!!! info ""

    Start here: [Deplyment configurations overview](./deployment-configurations/index.md)

Guides for specific configurations:

* [:octicons-cpu-16: CPU](./deployment-configurations/cpu.md) for general
  purpose CPU deployment
* [:octicons-cpu-16: CPU - Bare-Metal](./deployment-configurations/bare-metal.md)
  with minimal platform dependencies
* [:octicons-server-16: GPU - Vulkan](./deployment-configurations/gpu-vulkan.md)
  for cross-platform usage and interop with graphics applications
* [:simple-nvidia: GPU - CUDA](./deployment-configurations/gpu-cuda.md)
  for NVIDIA-specific solutions
* [:simple-amd: GPU - ROCm](./deployment-configurations/gpu-rocm.md)
  for AMD-specific solutions
* [:simple-apple: GPU - Metal](./deployment-configurations/gpu-metal.md)
  for running on Apple hardware

## General topics

* [:octicons-file-symlink-file-16: Parameters](./parameters.md) for managing
  large chunks of program data
