// RUN: iree-opt --split-input-file --pass-pipeline='builtin.module(util.func(iree-hal-repeat-dispatches{count=2}))' %s | FileCheck %s

util.global @executable : !hal.executable

// CHECK-LABEL: @duplicate_dispatches
//  CHECK-SAME: (%[[CMD1:[a-z0-9]+]]: !hal.command_buffer,
//  CHECK-SAME:  %[[CMD2:[a-z0-9]+]]: !hal.command_buffer,
//  CHECK-SAME:  %[[BUFFER:.+]]: !hal.buffer)
util.func public @duplicate_dispatches(%cmd1: !hal.command_buffer, %cmd2: !hal.command_buffer, %buffer: !hal.buffer) {
  // CHECK: %[[EXE:.+]] = util.global.load @executable
  %exe = util.global.load @executable : !hal.executable

  %c0 = arith.constant 0 : index
  %c1 = arith.constant 1 : index
  %c2 = arith.constant 2 : index
  %c3 = arith.constant 3 : index
  hal.command_buffer.dispatch<%cmd1 : !hal.command_buffer> target(%exe : !hal.executable)[%c0] workgroups([%c1, %c1, %c1]) bindings([(%buffer : !hal.buffer)[%c0, %c1]]) flags(None)
  hal.command_buffer.execution_barrier<%cmd1 : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
  hal.command_buffer.dispatch<%cmd1 : !hal.command_buffer> target(%exe : !hal.executable)[%c1] workgroups([%c2, %c2, %c2]) bindings([(%buffer : !hal.buffer)[%c0, %c1]]) flags(None)

  hal.command_buffer.dispatch<%cmd2 : !hal.command_buffer> target(%exe : !hal.executable)[%c2] workgroups([%c1, %c1, %c1]) bindings([(%buffer : !hal.buffer)[%c0, %c1]]) flags(None)
  hal.command_buffer.dispatch<%cmd2 : !hal.command_buffer> target(%exe : !hal.executable)[%c3] workgroups([%c2, %c2, %c2]) bindings([(%buffer : !hal.buffer)[%c0, %c1]]) flags(None)
  hal.command_buffer.execution_barrier<%cmd2 : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")

  util.return
}

// CHECK: hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c0] workgroups([%c1, %c1, %c1])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD1]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
// CHECK: hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c0] workgroups([%c1, %c1, %c1])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD1]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")

// CHECK: hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c1] workgroups([%c2, %c2, %c2])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD1]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
// CHECK: hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c1] workgroups([%c2, %c2, %c2])
// CHECK-NOT: hal.command_buffer.execution_barrier

// CHECK: hal.command_buffer.dispatch<%[[CMD2]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c2] workgroups([%c1, %c1, %c1])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD2]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
// CHECK: hal.command_buffer.dispatch<%[[CMD2]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c2] workgroups([%c1, %c1, %c1])
// CHECK-NOT: hal.command_buffer.execution_barrier

// CHECK: hal.command_buffer.dispatch<%[[CMD2]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c3] workgroups([%c2, %c2, %c2])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD2]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
// CHECK: hal.command_buffer.dispatch<%[[CMD2]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c3] workgroups([%c2, %c2, %c2])
// CHECK: hal.command_buffer.execution_barrier<%[[CMD2]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")

// -----

util.global @executable : !hal.executable

// CHECK-LABEL: @nested_dispatch
//  CHECK-SAME: (%[[CMD1:.+]]: !hal.command_buffer,
//  CHECK-SAME:  %[[BUFFER:.+]]: !hal.buffer,
//  CHECK-SAME:  %[[IDX:.+]]: index)
util.func public @nested_dispatch(%cmd1: !hal.command_buffer, %buffer: !hal.buffer, %idx: index) {
  // CHECK: %[[EXE:.+]] = util.global.load @executable
  %exe = util.global.load @executable : !hal.executable

  %c0 = arith.constant 0 : index
  %c1 = arith.constant 1 : index
  scf.index_switch %idx
  case 0 {
    hal.command_buffer.dispatch<%cmd1 : !hal.command_buffer> target(%exe : !hal.executable)[%c0] workgroups([%c1, %c1, %c1]) bindings([(%buffer : !hal.buffer)[%c0, %c1]]) flags(None)
    scf.yield
  }
  default {
  }

  util.return
}

// CHECK: scf.index_switch
// CHECK: case 0 {
// CHECK:   hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c0] workgroups([%c1, %c1, %c1])
// CHECK:   hal.command_buffer.execution_barrier<%[[CMD1]] : !hal.command_buffer> source("Dispatch|CommandRetire") target("CommandIssue|Dispatch") flags("None")
// CHECK:   hal.command_buffer.dispatch<%[[CMD1]] : !hal.command_buffer> target(%[[EXE]] : !hal.executable)[%c0] workgroups([%c1, %c1, %c1])
