---
title: Code of Conduct
layout: default
page-header: >
  Code of Conduct
---

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

This Code of Conduct applies both within project spaces and in public spaces
when an individual is implicitly or explicitly representing the project or community.

## Standards of behaviour

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members
* Assuming good faith from other participants unless proven otherwise

Examples of unacceptable behavior by participants include:

* Unwelcome sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Making coercive threats to try to force changes through without seeking consensus,
  e.g. "We'll pull out unless you do exactly what we say" / "I will pay others not
  to implement this specification"
* Demanding that your issues be prioritised above others
* Derailing, soapboxing, conspiracy theorising, or other deliberately destructive behaviour
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Moderator responsibilities

Project moderators are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project moderators have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

The current moderation team is:
<table>
    <thead>
        <tr>
            <th>IRC nick</th>
            <th>Github</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>dan-</td>
            <td><a href="https://github.com/DanielOaks">DanielOaks</a></td>
        </tr>
        <tr>
            <td>grawity</td>
            <td><a href="https://github.com/grawity">grawity</a></td>
        </tr>
        <tr>
            <td>jwheare</td>
            <td><a href="https://github.com/jwheare">jwheare</a></td>
        </tr>
    </tbody>
</table>

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project moderators on IRC or at
[ircv3-mods@googlegroups.com](mailto:ircv3-mods@googlegroups.com).
All complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project moderators are
obligated to maintain confidentiality with regard to the reporter of an incident.

Project moderators who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the
[Contributor Covenant version 1.4](https://www.contributor-covenant.org/version/1/4/code-of-conduct/).
