Class opc.ua.rest.masterdata.spec Extends %REST.Spec [ ProcedureBlock ]
{

XData OpenAPI [ MimeType = application/json ]
{
{
  "swagger":"2.0",
  "info":{
    "title":"Master data API",
    "description":"API for requesting Shifts, UoM and OEEBenchmarks",
    "version":"1.0.0"
  },
  "basePath":"/api",
  "schemes":[
    "https",
    "http"
  ],
  "tags":[
    {
      "name":"Shift",
      "description":"Get Shifts"
    },
    {
      "name":"UoM",
      "description":"Get Units of Measurement"
    },
    {
      "name":"OEEBenchMark",
      "description":"Get OEE Benchmarks"
    }
  ],
  "paths":{
    "/shifts":{
      "get":{
        "tags":[
          "Shift"
        ],
        "summary":"Returns all shifts",
        "operationId":"GetShifts",
        "consumes":[
          "application/json"
        ],
        "produces":[
          "application/json"
        ],
        "responses":{
          "200":{
            "description":"OK",
            "schema":{
              "$ref":"#/definitions/Shifts"
            }
          },
          "404":{
            "description":"No shifts found"
          }
        }
      }
    },
    "/uoms":{
      "get":{
        "tags":[
          "UoM"
        ],
        "summary":"Get all units of measurement",
        "operationId":"GetUoM",
        "consumes":[
          "application/json"
        ],
        "produces":[
          "application/json"
        ],
        "responses":{
          "200":{
            "description":"OK",
            "schema":{
              "$ref":"#/definitions/UoM"
            }
          },
          "404":{
            "description":"No UoM found"
          }
        }
      }
    },
    "/uoms/{format}":{
      "get":{
        "tags":[
          "UoM"
        ],
        "summary":"Get full name of UoM format",
        "operationId":"GetUoMFormat",
        "consumes":[
          "application/json"
        ],
        "produces":[
          "application/json"
        ],
        "parameters":[
          {
            "in":"path",
            "name":"format",
            "type":"string",
            "required":true
          }
        ],
        "responses":{
          "200":{
            "description":"OK",
            "schema":{
              "$ref":"#/definitions/UoMs"
            }
          },
          "404":{
            "description":"No UoM found"
          }
        }
      }
    },
    "/oeebenchmarks":{
      "get":{
        "tags":[
          "OEEBenchMark"
        ],
        "summary":"Get OEE Benchmarks",
        "operationId":"GetOEEBenchmarks",
        "consumes":[
          "application/json"
        ],
        "produces":[
          "application/json"
        ],
        "responses":{
          "200":{
            "description":"OK",
            "schema":{
              "$ref":"#/definitions/OEEBenchmarks"
            }
          },
          "404":{
            "description":"No OEE Benchmarks found"
          }
        }
      }
    }
  },
  "definitions":{
    "Shift":{
      "type":"object",
      "properties":{
        "name":{
          "type":"string",
          "maxLength":100
        },
        "description":{
          "type":"string",
          "maxLength":1000
        },
        "valid_from":{
          "type":"string",
          "format":"date"
        },
        "valid_to":{
          "type":"string",
          "format":"date"
        },
        "start_day_of_week":{
          "type":"string"
        },
        "start_time":{
          "type":"string"
        },
        "end_day_of_week":{
          "type":"string"
        },
        "end_time":{
          "type":"string"
        },
        "shift_number":{
          "type":"integer"
        },
        "active":{
          "type":"boolean"
        }
      }
    },
    "Shifts":{
      "type":"array",
      "items":{
        "$ref":"#/definitions/Shift"
      }
    },
    "UoM":{
      "type":"object",
      "properties":{
        "format":{
          "type":"string",
          "maxLength":4
        },
        "description":{
          "type":"string"
        }
      }
    },
    "UoMs":{
      "type":"array",
      "items":{
        "$ref":"#/definitions/UoM"
      }
    },
    "OEEBenchmarks":{
      "type":"array",
      "items":{
        "type":"object",
        "properties":{
          "equipment_id":{
            "type":"integer"
          },
          "object":{
            "type":"string"
          },
          "search":{
            "type":"string"
          },
          "target":{
            "type":"number",
            "format":"float"
          },
          "history":{
            "type":"number",
            "format":"float"
          },
          "ocap_01":{
            "type":"number",
            "format":"float"
          },
          "ocap_01_col":{
            "type":"string"
          },
          "ocap_02":{
            "type":"number",
            "format":"float"
          },
          "ocap_02_col":{
            "type":"string"
          },
          "ocap_03":{
            "type":"number",
            "format":"float"
          },
          "ocap_03_col":{
            "type":"string"
          },
          "ocap_04":{
            "type":"number",
            "format":"float"
          },
          "ocap_04_col":{
            "type":"string"
          },
          "ocap_05":{
            "type":"number",
            "format":"float"
          },
          "ocap_05_col":{
            "type":"string"
          }
        }
      }
    }
  }
}
}

}
