import styles from '@system/layouts/CardHandLayout.module.scss';
import * as React from 'react';

// Source: https://commons.wikimedia.org/wiki/File:Card_back_01.svg
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version. This library is distributed in the hope that it will be useful, but without any warranty; without even the implied warranty of merchantability or fitness for a particular purpose. See version 2.1 and version 3 of the GNU Lesser General Public License for more details.

const CardBack = (props) => {
  return (
    <svg {...props} viewBox="0 0 167.07959 242.66504" xmlns="http://www.w3.org/2000/svg">
      <g fill="currentColor" transform="matrix(1 0 0 1.0029936 0 -.363221)">
        <path
          d="m166.82959 235.5459c0 3.77441-3.08594 6.86914-6.87012 6.86914h-152.8486302c-3.7749023 0-6.8608398-3.09473-6.8608398-6.86914v-228.4257828c0-3.7792969 3.0859375-6.8701172 6.8608398-6.8701172h152.8486302c3.78418 0 6.87012 3.0908203 6.87012 6.8701172z"
          fill="var(--theme-background)"
          strokeWidth=".499253"
        />
        <g fillRule="evenodd">
          <path
            d="m27.634766 32.611816h103.445804c.8125 0 8.62793-.37207 8.62793.293946v11.211426 55.653808 107.999514c0 .25586.17382 1.42383-.14258 1.42383-1.5459 0-3.09082 0-4.63574 0-8.02442 0-16.04786 0-24.07129 0-21.773441 0-43.545902 0-65.318851 0-5.742188 0-11.484375 0-17.226074 0-1.461426 0-.679199-4.0625-.679199-5.22461 0-16.20313 0-32.40625 0-48.60938 0-39.08789 0-78.175291 0-117.263182 0-1.828613 0-3.656738 0-5.485352"
            stroke="currentColor"
            strokeWidth=".026826"
          />
          <path
            d="m61.656738 96.088867c4.471192 0 44.028322-.314453 44.028322.310547v50.271486c0 .5039-44.028322.06055-44.028322.1875 0-16.66309 0-33.32617 0-49.989259 0-.260254 0-.520508 0-.780274"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 91.472168c-4.335938 5.001465-8.672364 10.002442-13.008789 15.003902-2.923828 3.37256-5.847657 6.74463-8.771973 10.11719-.678711.78272-4.236817 3.79883-4.236817 4.88623 0 1 3.273438 3.77539 3.896485 4.49414 3.037598 3.50391 6.075195 7.00586 9.112305 10.50977 4.336425 5.00098 8.672851 10.00195 13.008789 15.0039 4.335937-5.00195 8.671875-10.00292 13.008789-15.0039 2.923828-3.37305 5.847654-6.74512 8.771484-10.11719.67871-.7832 4.2373-3.79883 4.2373-4.88672 0-1-3.27343-3.7749-3.89648-4.49365-3.03711-3.50342-6.075195-7.00635-9.112304-10.50977-4.336914-5.00146-8.672852-10.002437-13.008789-15.003902"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m63.658203 98.396973h24.856934 13.372073c2.30566 0 1.79687.196289 1.79687 2.508787v30.42627 11.91211c0 2.09863-1.21777 1.31836-3.22754 1.31836-8.738278 0-17.476071 0-26.213864 0-3.203125 0-6.406739 0-9.609864 0-1.577148 0-.974609-1.02051-.974609-2.50879 0-14.55273 0-29.10449 0-43.656737"
            stroke="currentColor"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 93.780762c-3.926758 4.528808-7.853028 9.057618-11.779785 13.586428-2.799317 3.22851-5.598633 6.45703-8.39795 9.68554-.614257.70899-3.838379 3.4419-3.838379 4.42676 0 .89844 2.939942 3.39063 3.499512 4.03614 2.760254 3.18359 5.520508 6.36718 8.280762 9.55078 4.078613 4.7041 8.157226 9.4082 12.23584 14.1123 3.926757-4.5293 7.853515-9.05762 11.779297-13.58594 2.799804-3.22851 5.599606-6.45703 8.398436-9.68554.61426-.70899 3.83789-3.44239 3.83789-4.42774 0-.89795-2.93945-3.39062-3.49902-4.03564-2.76074-3.1836-5.52051-6.36719-8.280275-9.55078-4.079102-4.70411-8.158203-9.408207-12.236328-14.112308"
            stroke="currentColor"
            strokeWidth=".026826"
          />
          <path
            d="m67.660645 103.01367h26.074218c1.084961 0 5.946289-.73291 5.946289.5918v11.74707c0 1.72266.021485 24.59375-.019531 24.59375-8.867187 0-17.733398 0-26.600586 0-1.058594 0-5.40039.72266-5.40039-.59277 0-3.91504 0-7.83106 0-11.74707 0-8.19727 0-16.39502 0-24.59278"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 98.396973c-3.335449 3.847167-6.670899 7.694337-10.006348 11.541507-2.23584 2.57861-4.47168 5.15722-6.707519 7.73584-.528321.60937-3.299317 2.95849-3.299317 3.80517 0 .75977 2.485352 2.86719 2.958008 3.41211 2.349609 2.70996 4.699219 5.41992 7.048828 8.12891 3.335449 3.84765 6.670898 7.69531 10.006348 11.54199 3.335937-3.84668 6.670898-7.69434 10.005859-11.54199 2.236328-2.57813 4.472656-5.15625 6.707034-7.73535.52929-.60938 3.2998-2.95899 3.2998-3.80567 0-.75879-2.48535-2.86621-2.95801-3.41162-2.349605-2.70996-4.699215-5.41943-7.048824-8.12939-3.334961-3.84717-6.669922-7.69434-10.005859-11.541507"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m69.662109 105.32178h25.612793c3.083008 0 2.405274.27295 2.405274 3.36084v15.55468 12.72852c0 1.49219-5.239258.67188-6.461914.67188-5.413086 0-10.827149 0-16.240723 0-1.888672 0-5.31543 1.10253-5.31543-1.16993 0-10.38183 0-20.76367 0-31.14599"
            stroke="currentColor"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 100.70508c-2.925293 3.37451-5.851074 6.74902-8.776856 10.12353-2.111328 2.43506-4.222656 4.87061-6.334473 7.30567-.463867.53515-2.90039 2.60107-2.90039 3.34521 0 .65723 2.152344 2.48242 2.561035 2.9541 2.072266 2.38965 4.144043 4.7793 6.21582 7.16895 3.078614 3.55078 6.156739 7.10156 9.234864 10.65137 2.925781-3.37403 5.851562-6.74903 8.777344-10.12305 2.111328-2.43457 4.222656-4.87012 6.333984-7.30566.463867-.53516 2.900395-2.60157 2.900395-3.34571 0-.65625-2.152348-2.48242-2.560551-2.95361-2.072266-2.39014-4.144532-4.77979-6.216797-7.16943-3.078125-3.5503-6.15625-7.10059-9.234375-10.65137"
            stroke="currentColor"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 103.01367c-2.592774 2.99072-5.185547 5.98145-7.778809 8.97168-1.823242 2.10352-3.646973 4.20654-5.470703 6.30957-.441895.50977-2.76123 2.47656-2.76123 3.18457 0 .62012 2.03125 2.34278 2.41748 2.78809 1.787109 2.06152 3.574219 4.12207 5.361328 6.18457 2.744141 3.16406 5.488281 6.3291 8.231934 9.49414 2.592773-2.99121 5.185547-5.98145 7.779297-8.97266 1.822265-2.10254 3.646484-4.20605 5.469726-6.30859.442383-.51074 2.760742-2.47656 2.760742-3.18555 0-.61914-2.03125-2.34277-2.416015-2.7876-1.78711-2.06152-3.575195-4.12255-5.362305-6.18408-2.743164-3.16455-5.487305-6.3291-8.231445-9.49414"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m71.663086 107.62988h23.912598c.208984 0 .103515 22.65723.103515 24.81836 0 .4375.3125 2.53906 0 2.88086-.349609.38184-3.259765 0-3.751953 0-5.326172 0-10.652832 0-15.979004 0-1.393554 0-2.787598 0-4.181152 0-.233887 0-.104004-2.19531-.104004-2.45117 0-5.16602 0-10.33203 0-15.49756 0-3.25 0-6.50049 0-9.75049"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m83.671387 107.62988c-2.001465 2.3086-4.002442 4.6167-6.003907 6.92481-1.375976 1.58691-2.751953 3.17383-4.127929 4.76123-.29834.34424-1.876465 1.68408-1.876465 2.16357 0 .48047 1.578125 1.82031 1.876465 2.16406 1.375976 1.58692 2.751953 3.17383 4.127929 4.76075 2.001465 2.30859 4.002442 4.61621 6.003907 6.9248 2.001953-2.30859 4.001953-4.61621 6.003906-6.9248 1.375977-1.58692 2.751953-3.17383 4.126953-4.76075.298828-.34375 1.876953-1.68359 1.876953-2.16406 0-.47949-1.578125-1.81933-1.876953-2.16357-1.375-1.5874-2.750977-3.17432-4.126953-4.76123-2.001953-2.30811-4.001953-4.61621-6.003906-6.92481"
            stroke="none"
          />
          <path
            d="m113.69092 93.780762c-1.33399 0-2.66797 0-4.00196 0 1.33399 1.538574 2.66797 3.077636 4.00196 4.616211 0-1.538575 0-3.077637 0-4.616211"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m113.69092 100.70508c-1.33399-1.538576-2.66797-3.077639-4.00196-4.616213v4.487303c0 .271 3.48633.12891 4.00196.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m53.651856 93.780762h4.001953c-1.333985 1.538574-2.667969 3.077636-4.001953 4.616211 0-1.538575 0-3.077637 0-4.616211"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m53.651856 100.70508c1.333984-1.538576 2.667968-3.077639 4.001953-4.616213v4.487303c0 .271-3.48584.12891-4.001953.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m57.653809 142.25391c-1.333985 0-2.667969 0-4.001954 0 1.333985 1.53906 2.667969 3.07812 4.001954 4.61621 0-1.53809 0-3.07715 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m57.653809 149.17871c-1.333985-1.53906-2.667969-3.07812-4.001954-4.61621v4.4873c0 .27149 3.486329.12891 4.001954.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m109.68896 142.25391h4.00196c-1.33399 1.53906-2.66797 3.07812-4.00196 4.61621 0-1.53809 0-3.07715 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m109.68896 149.17871c1.33399-1.53906 2.66797-3.07812 4.00196-4.61621v4.4873c0 .27149-3.48633.12891-4.00196.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m57.653809 126.09668c-1.333985 0-2.667969 0-4.001954 0 1.333985 1.53906 2.667969 3.07715 4.001954 4.61621 0-1.53906 0-3.07715 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m57.653809 133.02051c-1.333985-1.53809-2.667969-3.07715-4.001954-4.61621v4.4873c0 .27149 3.486329.12891 4.001954.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m53.651856 109.93848h4.001953c-1.333985 1.53857-2.667969 3.07763-4.001953 4.61621 0-1.53858 0-3.07764 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m53.651856 116.86328c1.333984-1.53906 2.667968-3.07764 4.001953-4.6167v4.48731c0 .27099-3.48584.12939-4.001953.12939"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m113.69092 109.93848c-1.33399 0-2.66797 0-4.00196 0 1.33399 1.53857 2.66797 3.07763 4.00196 4.61621 0-1.53858 0-3.07764 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m113.69092 116.86328c-1.33399-1.53906-2.66797-3.07764-4.00196-4.6167v4.48731c0 .27099 3.48633.12939 4.00196.12939"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m109.68896 126.09668h4.00196c-1.33399 1.53906-2.66797 3.07715-4.00196 4.61621 0-1.53906 0-3.07715 0-4.61621"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m109.68896 133.02051c1.33399-1.53809 2.66797-3.07715 4.00196-4.61621v4.4873c0 .27149-3.48633.12891-4.00196.12891"
            fill="var(--theme-background)"
            stroke="var(--theme-background)"
            strokeWidth=".026826"
          />
          <path
            d="m69.711914 24.821289c-.817871-2.024414-1.683105-4.086426-2.24414-6.20166-.50586-1.90625-.908692-6.560059 1.627441-7.475098 2.433105-.876953 3.317383 3.32959 3.285644 4.982422-.047851 2.48291-1.228027 5.019531-2.116699 7.301758-.180664.464844-.365234.931152-.552246 1.392578"
            stroke="none"
          />
          <path
            d="m69.699219 24.867188c-2.011231-.84668-4.250489-1.67627-6.030762-2.961915-1.580078-1.141601-4.09668-4.524902-2.628418-6.594238 1.481934-2.088867 4.574219.305176 5.573242 1.716309 1.433106 2.022949 2.106446 4.790039 2.858887 7.124511.07666.237793.151855.478516.227051.715332"
            stroke="none"
          />
          <path
            d="m69.705566 24.867188c2.011231-.847168 4.25-1.67627 6.030762-2.961915 1.580078-1.141113 4.096191-4.52539 2.628418-6.594238-1.481934-2.089355-4.574707.305176-5.57373 1.716309-1.460938 2.062988-2.14502 4.899414-2.90918 7.282226-.059082.185059-.118164.373536-.17627.557618"
            stroke="none"
          />
          <path
            d="m64.552246 25.144531c-1.627441-.48291-3.643066-.323242-4.683105 1.184571-.5542.803711-.680176 3.917968 1.083984 3.3125.307617-.105469.559082-1.470703.934082-1.785157.714844-.599609 2.053711-.581054 2.921875-.65039 1.167969-.092285 2.380859.032226 3.528809-.126465.001464-.006836.003418-.013184.006836-.019531-1.087891-.842774-2.47461-1.507813-3.792481-1.915528"
            stroke="none"
          />
          <path
            d="m74.772461 25.144531c1.627441-.483398 3.643066-.323242 4.682617 1.184571.554199.803711.680664 3.918457-1.083984 3.3125-.307617-.105469-.558594-1.470215-.933594-1.785157-.714355-.599609-2.053711-.581054-2.921875-.65039-1.168457-.092285-2.380859.032226-3.529297-.126465-.001465-.006836-.003418-.013184-.006836-.019531 1.088379-.842774 2.47461-1.507813 3.792969-1.915528"
            stroke="none"
          />
          <path d="m68.328125 29.629883c.237793 2.033691 3.76416 1.044922 2.077637-1.753906-1.184571-1.966797-1.863282-.126465-2.077637 1.753906" stroke="none" />
          <path
            d="m97.72998 24.821289c-.818359-2.023926-1.683593-4.086914-2.24414-6.20166-.50586-1.90625-.908203-6.55957 1.626953-7.475098 2.433594-.877929 3.318357 3.330078 3.286137 4.982422-.04786 2.483399-1.227543 5.019531-2.116215 7.301758-.181641.464844-.365235.930664-.552735 1.392578"
            stroke="none"
          />
          <path
            d="m97.717285 24.867188c-2.010742-.84668-4.250976-1.67627-6.030273-2.961915-1.580078-1.141601-4.09668-4.52539-2.628906-6.594238 1.482421-2.088379 4.574218.304688 5.574218 1.716309 1.432618 2.022949 2.105469 4.790527 2.857422 7.124511.077149.237793.152344.478516.227539.715332"
            stroke="none"
          />
          <path
            d="m97.724121 24.867188c2.010742-.847168 4.249999-1.67627 6.030269-2.961915 1.58106-1.141601 4.09668-4.524902 2.62793-6.594238-1.48144-2.088867-4.57421.305176-5.57324 1.716309-1.461912 2.062988-2.143553 4.899414-2.908201 7.282226-.05957.185547-.118164.373047-.176758.557618"
            stroke="none"
          />
          <path
            d="m92.569824 25.144531c-1.626953-.483398-3.642578-.322754-4.68164 1.184571-.554688.804199-.681641 3.918457 1.083984 3.3125.306641-.105469.558594-1.470703.933594-1.785157.713867-.599609 2.053711-.581054 2.921875-.65039 1.167969-.092285 2.380859.032226 3.52832-.126465.000977-.006836.003906-.013184.006836-.019531-1.088867-.842774-2.473633-1.507813-3.792969-1.915528"
            stroke="none"
          />
          <path
            d="m102.79053 25.144531c1.62695-.483398 3.64355-.322754 4.68359 1.184571.55371.803711.67969 3.917968-1.08398 3.3125-.3086-.105469-.55957-1.470703-.93457-1.785157-.71387-.599609-2.05371-.581054-2.92188-.65039-1.16797-.092774-2.38086.032226-3.529296-.126465-.000976-.006836-.002929-.013184-.006835-.019531 1.088871-.842286 2.474611-1.507813 3.792971-1.915528"
            stroke="none"
          />
          <path d="m96.346191 29.629883c.238282 2.033691 3.764649 1.044922 2.078125-1.753906-1.18457-1.967286-1.864257-.125977-2.078125 1.753906" stroke="none" />
          <path
            d="m125.74854 24.821289c-.81739-2.024902-1.6836-4.086426-2.24512-6.20166-.50488-1.90625-.90821-6.560059 1.6289-7.475098 2.43262-.877441 3.31641 3.330078 3.28516 4.982422-.04883 2.483399-1.22851 5.019043-2.11719 7.301758-.17968.464844-.36523.931152-.55175 1.392578"
            stroke="none"
          />
          <path
            d="m125.73584 24.867188c-2.01172-.847168-4.25-1.67627-6.03125-2.961915-1.58008-1.141601-4.0957-4.52539-2.62793-6.594238 1.48145-2.088867 4.57422.305176 5.57324 1.716309 1.46094 2.062988 2.14453 4.898926 2.90821 7.282226.06054.185547.11914.373047.17773.557618"
            stroke="none"
          />
          <path
            d="m125.7417 24.867188c2.01172-.84668 4.25098-1.67627 6.03125-2.961915 1.58008-1.141601 4.0957-4.52539 2.62891-6.594238-1.48243-2.088867-4.5752.305176-5.57422 1.716309-1.46094 2.062988-2.14453 4.899414-2.90821 7.282226-.05957.185059-.11914.373536-.17773.557618"
            stroke="none"
          />
          <path
            d="m120.58936 25.144531c-1.62793-.483398-3.64356-.322754-4.6836 1.184571-.55469.804199-.68066 3.917968 1.08399 3.3125.30761-.105469.55859-1.470703.93359-1.785157.71484-.599609 2.05469-.581054 2.92187-.65039 1.16895-.092285 2.38086.032226 3.5293-.126465.00195-.006836.00391-.013184.00684-.019531-1.08887-.842774-2.47364-1.507813-3.79199-1.915528"
            stroke="none"
          />
          <path
            d="m130.80811 25.144531c1.6289-.48291 3.64453-.323242 4.68359 1.184571.55469.803711.68164 3.91748-1.08399 3.3125-.30664-.105469-.55859-1.470215-.93359-1.785157-.71484-.599609-2.05371-.581054-2.92187-.65039-1.16797-.092285-2.38086.032226-3.5293-.126465-.00195-.006836-.00391-.013184-.00586-.019531 1.08789-.842774 2.47363-1.507813 3.79102-1.915528"
            stroke="none"
          />
          <path d="m124.36475 29.629883c.23828 2.034668 3.76367 1.043945 2.07812-1.753906-1.18555-1.967286-1.86328-.125977-2.07812 1.753906" stroke="none" />
          <path
            d="m41.693848 24.821289c-.81836-2.023926-1.683594-4.086914-2.244629-6.20166-.50586-1.90625-.908203-6.560059 1.627441-7.475098 2.433594-.877929 3.317383 3.330078 3.285645 4.982422-.047852 2.483399-1.228028 5.019043-2.1167 7.301758-.180664.464844-.365234.930664-.551757 1.392578"
            stroke="none"
          />
          <path
            d="m41.680664 24.867188c-2.011719-.847168-4.25-1.67627-6.030762-2.961915-1.580078-1.141601-4.096191-4.524902-2.628418-6.594238 1.481934-2.088867 4.574707.305176 5.573731 1.716309 1.432617 2.022949 2.106445 4.790527 2.858398 7.124511.076661.237793.151856.478516.227051.715332"
            stroke="none"
          />
          <path
            d="m41.687012 24.867188c2.01123-.84668 4.250488-1.67627 6.030761-2.961915 1.580079-1.141601 4.09668-4.524902 2.628418-6.594238-1.482422-2.088867-4.574218.305176-5.57373 1.716309-1.432617 2.022949-2.105957 4.790527-2.858398 7.124511-.076661.237793-.151856.478028-.227051.715332"
            stroke="none"
          />
          <path
            d="m36.533691 25.144531c-1.627441-.483398-3.643066-.322754-4.682617 1.184571-.554199.803711-.680664 3.918457 1.083985 3.3125.307129-.105469.558593-1.470703.933593-1.785157.714356-.599609 2.053711-.581054 2.921875-.65039 1.168457-.092285 2.381348.032226 3.529297-.126465.000977-.006836.003418-.013184.006836-.019531-1.088379-.842286-2.474609-1.508301-3.792969-1.915528"
            stroke="none"
          />
          <path
            d="m46.753418 25.144531c1.62793-.48291 3.643555-.323242 4.683594 1.184571.554199.803711.680664 3.917968-1.083985 3.3125-.307617-.105469-.559082-1.470703-.934082-1.785157-.714355-.599609-2.05371-.581054-2.921875-.65039-1.167968-.092285-2.380859.032226-3.528808-.126465-.001465-.006836-.003906-.013184-.006836-.019531 1.088379-.842774 2.474121-1.507325 3.791992-1.915528"
            stroke="none"
          />
          <path d="m40.30957 29.629883c.238282 2.033691 3.76416 1.044922 2.078125-1.753906-1.18457-1.966797-1.863769-.125977-2.078125 1.753906" stroke="none" />
          <path
            d="m69.461914 216.98438c-.817871 2.02441-1.683594 4.08691-2.244629 6.20117-.505371 1.90527-.908691 6.56152 1.62793 7.47558 2.433594.87696 3.316894-3.33008 3.285156-4.98242-.047851-2.48437-1.228515-5.01953-2.116211-7.30176-.181152-.46484-.365234-.93066-.552246-1.39257"
            stroke="none"
          />
          <path
            d="m69.44873 216.93848c-2.011718.8457-4.25 1.67578-6.030273 2.96191-1.580566 1.1416-4.09668 4.52441-2.628906 6.59375 1.482422 2.08887 4.574707-.30469 5.57373-1.71582 1.433106-2.02344 2.105957-4.79102 2.858399-7.125.07666-.2373.151855-.47852.22705-.71484"
            stroke="none"
          />
          <path
            d="m69.455566 216.93848c2.011719.8457 4.25 1.67578 6.030274 2.96191 1.580566 1.1416 4.096191 4.52441 2.628418 6.59375-1.481934 2.08887-4.574219-.30469-5.573731-1.71582-1.460937-2.06348-2.144531-4.89941-2.908203-7.28223-.05957-.18554-.118164-.37304-.176758-.55761"
            stroke="none"
          />
          <path
            d="m64.301758 216.66113c-1.627442.48242-3.643067.32227-4.682617-1.18554-.5542-.80274-.680664-3.91797 1.083984-3.3125.307129.10546.559082 1.4707.933594 1.78515.714844.59961 2.053711.58203 2.922363.65039 1.167969.09278 2.381836-.03125 3.528809.12696.000976.00781.003418.01367.006836.01953-1.087891.84277-2.47461 1.50781-3.792969 1.91601"
            stroke="none"
          />
          <path
            d="m74.521973 216.66113c1.627441.48242 3.643554.32227 4.683105-1.18554.554199-.80274.680664-3.917-1.083984-3.3125-.307129.10546-.559082 1.4707-.934082 1.78515-.714844.59961-2.053223.58203-2.921875.65039-1.167969.09278-2.381836-.03125-3.528809.12696-.001465.00683-.003906.01367-.006836.01953 1.087403.84277 2.47461 1.50781 3.792481 1.91601"
            stroke="none"
          />
          <path d="m68.077637 212.17578c.237793-2.03418 3.76416-1.0459 2.078125 1.75293-1.184571 1.96777-1.862305.12793-2.078125-1.75293" stroke="none" />
          <path
            d="m97.47998 216.98438c-.818359 2.02441-1.683593 4.08691-2.24414 6.20117-.50586 1.90527-.908203 6.56054 1.626953 7.47558 2.433594.87696 3.318357-3.33008 3.286137-4.98242-.04786-2.48242-1.227543-5.02148-2.116215-7.30176-.181641-.46484-.365235-.93066-.552735-1.39257"
            stroke="none"
          />
          <path
            d="m97.467285 216.93848c-2.011719.8457-4.250976 1.67578-6.030273 2.96191-1.580078 1.1416-4.09668 4.52441-2.628906 6.59375 1.482421 2.08887 4.574218-.30469 5.574218-1.71582 1.460938-2.06348 2.143555-4.89941 2.908203-7.28223.058594-.18457.118165-.37402.176758-.55761"
            stroke="none"
          />
          <path
            d="m97.474121 216.93848c2.011719.8457 4.249999 1.67578 6.030269 2.96191 1.58106 1.1416 4.09668 4.52441 2.62793 6.59375-1.48242 2.08887-4.57421-.30469-5.57324-1.71582-1.460935-2.06348-2.144529-4.89941-2.909178-7.28223-.058593-.18457-.117187-.37402-.175781-.55761"
            stroke="none"
          />
          <path
            d="m92.319824 216.66113c-1.626953.48242-3.642578.32227-4.682617-1.18554-.553711-.80274-.680664-3.91797 1.083984-3.3125.307618.10546.559571 1.4707.934571 1.78515.714844.59961 2.052734.58203 2.921875.65039 1.166992.09278 2.381836-.03125 3.52832.12696.000977.00683.003906.01367.006836.01953-1.087891.84277-2.474609 1.50781-3.792969 1.91601"
            stroke="none"
          />
          <path
            d="m102.54053 216.66113c1.62695.48242 3.64258.32227 4.68359-1.18554.55274-.80274.67969-3.917-1.08398-3.3125-.3086.10546-.55957 1.4707-.93457 1.78515-.71485.59961-2.05371.58203-2.92286.65039-1.16699.09278-2.380855-.03125-3.528316.12696-.000976.00781-.002929.01367-.006835.01953 1.08789.84277 2.474611 1.50781 3.792971 1.91601"
            stroke="none"
          />
          <path d="m96.095215 212.17578c.239258-2.03418 3.764648-1.0459 2.079101 1.75293-1.18457 1.96777-1.862304.12793-2.079101-1.75293" stroke="none" />
          <path
            d="m125.49854 216.98438c-.81836 2.02441-1.6836 4.08691-2.24512 6.20117-.50488 1.90527-.90821 6.56152 1.6289 7.47558 2.4336.87696 3.31641-3.33008 3.28516-4.98242-.04785-2.48242-1.22656-5.02148-2.11719-7.30176-.18066-.46484-.36523-.93066-.55175-1.39257"
            stroke="none"
          />
          <path
            d="m125.48584 216.93848c-2.01172.8457-4.25098 1.67578-6.03125 2.96191-1.58008 1.1416-4.0957 4.52441-2.62891 6.59375 1.48243 2.08887 4.5752-.30469 5.57422-1.71582 1.4336-2.02344 2.10645-4.79102 2.85938-7.125.07617-.2373.15039-.47852.22656-.71484"
            stroke="none"
          />
          <path
            d="m125.4917 216.93848c2.01172.8457 4.25098 1.67578 6.03125 2.96191 1.58008 1.1416 4.0957 4.52441 2.62793 6.59375-1.48145 2.08887-4.57422-.30469-5.57324-1.71582-1.4336-2.02344-2.10547-4.79102-2.85938-7.125-.07617-.2373-.15137-.47852-.22656-.71484"
            stroke="none"
          />
          <path
            d="m120.33838 216.66113c-1.62793.48242-3.64356.32227-4.68262-1.18554-.55469-.80274-.68164-3.917 1.08399-3.3125.30664.10546.55859 1.4707.93359 1.78515.71484.59961 2.05371.58203 2.92187.65039 1.16797.09278 2.38282-.03125 3.5293.12696.00098.00781.00391.01367.00684.01953-1.08887.84277-2.47364 1.50781-3.79297 1.91601"
            stroke="none"
          />
          <path
            d="m130.55811 216.66113c1.62793.48242 3.64453.32227 4.68359-1.18554.55469-.80274.68066-3.917-1.08399-3.3125-.30664.10546-.55859 1.4707-.93359 1.78515-.71484.59961-2.05273.58203-2.92187.65039-1.16797.09278-2.38184-.03125-3.5293.12696-.00195.00781-.00391.01367-.00684.01953 1.08692.84277 2.47461 1.50781 3.792 1.91601"
            stroke="none"
          />
          <path d="m124.11475 212.17578c.2373-2.03418 3.76367-1.0459 2.07812 1.75293-1.18555 1.96777-1.86328.12793-2.07812-1.75293" stroke="none" />
          <path
            d="m41.443848 216.98438c-.818848 2.02343-1.684082 4.08691-2.245118 6.20117-.505371 1.90527-.908203 6.56152 1.62793 7.47558 2.433106.87696 3.317871-3.33008 3.285645-4.98242-.047852-2.48437-1.228516-5.01953-2.1167-7.30176-.180664-.46484-.365234-.93066-.551757-1.39257"
            stroke="none"
          />
          <path
            d="m41.430664 216.93848c-2.012207.8457-4.250488 1.67578-6.030762 2.96191-1.580566 1.1416-4.096191 4.52441-2.628906 6.59375 1.482422 2.08887 4.574707-.30566 5.574219-1.71582 1.432617-2.02344 2.105469-4.79102 2.858398-7.125.076661-.23633.151856-.47852.227051-.71484"
            stroke="none"
          />
          <path
            d="m41.437012 216.93848c2.011718.8457 4.25 1.67675 6.030273 2.96191 1.580567 1.14063 4.09668 4.52441 2.628906 6.59375-1.482422 2.08887-4.574218-.30469-5.57373-1.71582-1.460938-2.06348-2.144531-4.89941-2.908692-7.28223-.05957-.18457-.118164-.37402-.176757-.55761"
            stroke="none"
          />
          <path
            d="m36.283691 216.66113c-1.627929.48242-3.643554.32227-4.683105-1.18554-.554199-.80274-.680664-3.91797 1.083984-3.3125.307129.10546.559571 1.4707.934082 1.78515.714844.59961 2.053223.58203 2.921875.65039 1.167969.09278 2.381836-.03125 3.528809.12696.001465.00781.003906.01367.006836.01953-1.087891.84277-2.474121 1.50781-3.792481 1.91601"
            stroke="none"
          />
          <path
            d="m46.503418 216.66113c1.62793.48242 3.643555.32325 4.683594-1.18554.553711-.80274.680176-3.91797-1.084473-3.3125-.307129.10546-.559082 1.4707-.933594 1.78515-.714843.59961-2.053222.58203-2.921875.65039-1.167968.09278-2.381836-.03125-3.529297.12696-.000976.00781-.003418.01367-.006835.01953 1.08789.84277 2.474609 1.50781 3.79248 1.91601"
            stroke="none"
          />
          <path d="m40.059082 212.17578c.238769-2.03418 3.763672-1.0459 2.078613 1.75293-1.185058 1.96875-1.861816.12793-2.078613-1.75293" stroke="none" />
          <path
            d="m146.52588 218.3584c1.90625 1.02051 3.96777 2.27734 6.07715 2.82226 1.91992.4961 5.55468.01758 5.90429-2.51953.33789-2.44824-3.12597-3.54785-4.99414-3.33105-2.33007.27051-4.77343 1.83887-6.81445 2.93164-.05664.03027-.11621.06543-.17285.09668"
            stroke="none"
          />
          <path
            d="m146.48975 218.37305c.82031 2.59863 3.36523 12.5205 7.94726 10.17578 2.23242-1.1416.43653-4.9209-.73242-6.20606-1.64941-1.81054-4.38477-2.76172-6.5957-3.70703-.20508-.08887-.41407-.17578-.61914-.26269"
            stroke="none"
          />
          <path
            d="m146.48584 218.36523c.82227-2.60058 3.36719-12.52636 7.95117-10.17578 2.23047 1.14356.4375 4.91114-.73242 6.19825-1.65039 1.8125-4.38574 2.76757-6.59766 3.71679-.20703.08789-.41601.17383-.62109.26074"
            stroke="none"
          />
          <path
            d="m146.24561 224.30957c.37109 1.67188.44824 4.17969-1.02735 5.40039-.95996.79492-3.44336.5332-2.87207-1.25.10645-.33008 1.26074-.67578 1.54785-1.08008.59375-.83789.50782-2.40234.56348-3.36718.07715-1.34766-.0459-2.73731.11035-4.07032.00586-.00195.01172-.0039.0166-.00781.77051 1.31055 1.32325 2.89063 1.66114 4.375"
            stroke="none"
          />
          <path
            d="m146.24561 212.52148c.37207-1.67382.45117-4.18066-1.02735-5.40136-.95996-.79297-3.44629-.53516-2.87207 1.25.10547.32812 1.2627.67383 1.54785 1.07812.59375.83692.50782 2.4043.56348 3.36914.07715 1.34864-.0459 2.73731.11035 4.07032.00586.00195.01172.00488.0166.00781.76856-1.3086 1.32715-2.89063 1.66114-4.37403"
            stroke="none"
          />
          <path d="m142.35693 219.9541c-1.82812-.4414-1.04687-4.39453 1.52051-2.39648 1.54395 1.20117.37988 2.07226-1.52051 2.39648" stroke="none" />
          <path
            d="m146.52881 186.04199c1.90625 1.02246 3.96875 2.27735 6.07812 2.82422 1.91602.49609 5.55567.01758 5.90039-2.52051.33204-2.44629-3.125-3.54687-4.99414-3.33105-2.32812.26758-4.77343 1.83789-6.81054 2.93164-.05762.03027-.11719.06543-.17383.0957"
            stroke="none"
          />
          <path
            d="m146.48584 186.05762c.82422 2.59961 3.36719 12.52148 7.95117 10.17578 2.23145-1.14258.4375-4.91797-.73242-6.20215-1.65234-1.81152-4.38672-2.76367-6.59766-3.71191-.20703-.08887-.41601-.17579-.62109-.26172"
            stroke="none"
          />
          <path
            d="m146.48975 186.0498c.82031-2.60156 3.36328-12.52148 7.94726-10.17578 2.23242 1.14258.4375 4.917-.73242 6.20118-1.65039 1.8125-4.38477 2.76464-6.5957 3.71289-.20508.08789-.41407.1748-.61914.26171"
            stroke="none"
          />
          <path
            d="m146.24561 191.98926c.37207 1.67773.45117 4.17676-1.02735 5.40137-.95801.79394-3.44726.54394-2.87207-1.2461.10547-.32715 1.2627-.67383 1.54785-1.07715.59375-.83789.50782-2.40429.56348-3.37011.07715-1.34864-.0459-2.73731.11035-4.07032.00586-.00195.01172-.00488.0166-.00781.76856 1.30664 1.32617 2.8877 1.66114 4.37012"
            stroke="none"
          />
          <path
            d="m146.24561 180.20605c.37109-1.67187.44824-4.17968-1.02735-5.40136-.95898-.79395-3.44922-.53418-2.87207 1.25.10645.32715 1.26172.67285 1.54785 1.07715.59375.83886.50782 2.40429.56348 3.37011.07715 1.34864-.0459 2.73731.11035 4.07032.00586.00195.01172.00488.0166.00781.77051-1.30957 1.32325-2.89063 1.66114-4.37403"
            stroke="none"
          />
          <path d="m142.35693 187.63867c-1.82812-.44043-1.04492-4.39941 1.52051-2.40137 1.5459 1.20508.37988 2.07618-1.52051 2.40137" stroke="none" />
          <path
            d="m146.52588 153.72559c1.9043 1.02441 3.97168 2.28027 6.08105 2.82421 1.91993.4961 5.55078.01758 5.90039-2.51953.33692-2.44726-3.125-3.55175-4.99414-3.33593-2.33105.2705-4.77441 1.84277-6.81445 2.93554-.05664.03125-.11523.06543-.17285.09571"
            stroke="none"
          />
          <path
            d="m146.48584 153.74121c.82422 2.60156 3.36719 12.52246 7.95117 10.17578 2.23145-1.1416.4375-4.91699-.73242-6.20117-1.65234-1.8125-4.38672-2.76465-6.59766-3.71289-.20703-.08789-.41601-.1748-.62109-.26172"
            stroke="none"
          />
          <path
            d="m146.48584 153.7334c.82422-2.59961 3.36719-12.52149 7.95117-10.17578 2.23145 1.14258.4375 4.91797-.73242 6.20215-1.65234 1.81152-4.38672 2.76464-6.59766 3.71191-.20703.08887-.41601.17578-.62109.26172"
            stroke="none"
          />
          <path
            d="m146.24561 159.67773c.37109 1.67286.44824 4.17969-1.02735 5.40137-.95996.79492-3.44629.53418-2.87207-1.25.10547-.32812 1.2627-.67383 1.54785-1.07812.59375-.83789.50782-2.4043.56348-3.36914.07715-1.3418-.06543-2.75977.12012-4.07422.78515 1.27539 1.333 2.89941 1.66797 4.37011"
            stroke="none"
          />
          <path
            d="m146.24561 147.88965c.37109-1.67188.44824-4.17969-1.02735-5.40039-.95996-.7959-3.44629-.53516-2.87207 1.25.10547.32812 1.2627.67383 1.54785 1.07715.59375.83789.50782 2.40429.56348 3.37011.07715 1.3418-.06543 2.75977.12012 4.07422.78515-1.27539 1.333-2.90039 1.66797-4.37109"
            stroke="none"
          />
          <path d="m142.35693 155.32324c-1.8291-.44043-1.04492-4.3916 1.52051-2.40136 1.54785 1.20214.37598 2.07226-1.52051 2.40136" stroke="none" />
          <path
            d="m146.52588 89.094727c1.90527 1.021972 3.96973 2.279785 6.07715 2.82373 1.91992.495606 5.55468.01709 5.90429-2.520019.33789-2.448243-3.12597-3.54834-4.99414-3.331543-2.33105.270996-4.77343 1.839355-6.81445 2.93164-.05664.03125-.11621.06543-.17285.096192"
            stroke="none"
          />
          <path
            d="m146.48975 89.110352c.82031 2.599609 3.36523 12.520018 7.94726 10.175293 2.23242-1.14209.43653-4.920899-.73242-6.205567-1.64844-1.810058-4.38477-2.762207-6.5957-3.708008-.20508-.088378-.41407-.175781-.61914-.261718"
            stroke="none"
          />
          <path
            d="m146.48584 89.102539c.82227-2.601074 3.36816-12.526855 7.95117-10.175781 2.23047 1.143555.4375 4.911621-.73242 6.197754-1.65039 1.812988-4.38672 2.767089-6.59766 3.716308-.20703.088379-.41601.174805-.62109.261719"
            stroke="none"
          />
          <path
            d="m146.24561 95.045898c.37109 1.672364.44824 4.180665-1.02735 5.401852-1.01758.84327-3.41211.48975-2.84863-1.296383.08496-.267578 1.32129-.750488 1.58789-1.166015.55762-.871094.45996-2.441407.51074-3.423828.06445-1.275391-.08105-2.648438.11621-3.889649.77051 1.310059 1.32324 2.890625 1.66114 4.374024"
            stroke="none"
          />
          <path
            d="m146.24561 83.258789c.37207-1.673828.45117-4.179687-1.02735-5.401367-.95898-.793457-3.44726-.535645-2.87207 1.25.10547.328125 1.2627.673828 1.54785 1.077637.59375.837402.50782 2.404785.56348 3.369629.07715 1.348632-.0459 2.737304.11035 4.070312.00586.001953.01172.004395.0166.007813.76953-1.308594 1.32715-2.890625 1.66114-4.374024"
            stroke="none"
          />
          <path d="m142.35693 90.691406c-1.82812-.441406-1.04687-4.394043 1.52051-2.396972 1.54395 1.20166.37988 2.071777-1.52051 2.396972" stroke="none" />
          <path
            d="m146.52881 56.779297c1.90625 1.022949 3.96875 2.276367 6.07812 2.82373 1.917.497071 5.55567.017579 5.90039-2.520019.33204-2.447266-3.125-3.546875-4.99414-3.331543-2.32812.268066-4.77343 1.839355-6.81054 2.931152-.05762.03125-.11719.065918-.17383.09668"
            stroke="none"
          />
          <path
            d="m146.48584 56.794434c.82422 2.600585 3.36719 12.521972 7.95117 10.175781 2.23145-1.141602.4375-4.917481-.73242-6.20166-1.65234-1.812012-4.38672-2.763672-6.59766-3.712403-.20703-.088378-.41601-.175293-.62109-.261718"
            stroke="none"
          />
          <path
            d="m146.48975 56.786621c.82031-2.601074 3.36328-12.521484 7.94726-10.175293 2.23242 1.141602.43653 4.916992-.73242 6.201172-1.65039 1.812012-4.38379 2.764648-6.5957 3.712891-.20508.08789-.41407.174804-.61914.26123"
            stroke="none"
          />
          <path
            d="m146.24561 62.726563c.37207 1.677734.45117 4.177246-1.02735 5.401367-.95801.793945-3.44824.543945-2.87207-1.246094.10547-.328125 1.2627-.673828 1.54785-1.077637.59375-.837402.50782-2.404785.56348-3.369629.07715-1.348632-.0459-2.737304.11035-4.070312.00586-.001953.01172-.004395.0166-.007813.76856 1.307129 1.32617 2.888184 1.66114 4.370118"
            stroke="none"
          />
          <path
            d="m146.24561 50.942871c.37207-1.672363.44824-4.179687-1.02735-5.400879-.95898-.793945-3.44336-.538086-2.87207 1.246094.10645.331055 1.26074.675293 1.54785 1.081055.59375.838867.50782 2.404297.56348 3.370117.07715 1.348633-.0459 2.737305.11035 4.070312.00586.001954.01172.004395.0166.007813.77051-1.30957 1.32325-2.890625 1.66114-4.374512"
            stroke="none"
          />
          <path d="m142.35693 58.375488c-1.82812-.438964-1.04589-4.398925 1.52051-2.40039 1.5459 1.204101.37988 2.075683-1.52051 2.40039" stroke="none" />
          <path
            d="m146.52588 24.463379c1.90332 1.024414 3.97168 2.279785 6.08105 2.82373 1.91993.495606 5.55078.016602 5.90039-2.519531.33692-2.447754-3.125-3.552246-4.99414-3.335937-2.33105.270019-4.77441 1.842773-6.81445 2.935546-.05664.03125-.11523.06543-.17285.096192"
            stroke="none"
          />
          <path
            d="m146.48584 24.478516c.82422 2.600586 3.36719 12.522461 7.95117 10.175781 2.23145-1.141602.4375-4.917481-.73242-6.20166-1.65234-1.812012-4.38672-2.763672-6.59766-3.712403-.20703-.08789-.41601-.174804-.62109-.261718"
            stroke="none"
          />
          <path
            d="m146.48584 24.471191c.82422-2.600585 3.36719-12.521972 7.95117-10.175781 2.23145 1.141602.4375 4.917481-.73242 6.20166-1.65234 1.812012-4.38672 2.763672-6.59766 3.712403-.20703.088378-.41601.175293-.62109.261718"
            stroke="none"
          />
          <path
            d="m146.24561 30.415039c.37109 1.671875.44824 4.179688-1.02735 5.401367-.95996.794922-3.44629.53418-2.87207-1.250488.10547-.327637 1.2627-.673828 1.54785-1.077148.59375-.837891.50782-2.404786.56348-3.370118.07715-1.341796-.06543-2.760253.12012-4.07373.78515 1.274414 1.333 2.899902 1.66797 4.370117"
            stroke="none"
          />
          <path
            d="m146.24561 18.627441c.37109-1.672363.44824-4.179687-1.02735-5.401367-.95996-.794922-3.44629-.534668-2.87207 1.250489.10547.327636 1.2627.673339 1.54785 1.077148.59375.837891.50782 2.404297.56348 3.370117.07715 1.341797-.06543 2.759766.12012 4.073731.78515-1.275391 1.333-2.899903 1.66797-4.370118"
            stroke="none"
          />
          <path d="m142.35693 26.060059c-1.8291-.439942-1.04492-4.391114 1.52051-2.400879 1.54785 1.201172.37598 2.072265-1.52051 2.400879" stroke="none" />
          <path
            d="m146.52588 121.41016c1.90332 1.02441 3.97168 2.28027 6.08105 2.82422 1.91993.49511 5.55078.0166 5.90039-2.52051.33692-2.44824-3.125-3.54785-4.99414-3.33106-2.33105.271-4.77343 1.83887-6.81445 2.93164-.05664.03028-.11523.06543-.17285.09571"
            stroke="none"
          />
          <path
            d="m146.48584 121.42578c.82422 2.60059 3.36719 12.52246 7.95117 10.17578 2.23145-1.1416.4375-4.91699-.73242-6.20215-1.65234-1.81152-4.38672-2.76367-6.59766-3.71191-.20703-.08887-.41601-.1748-.62109-.26172"
            stroke="none"
          />
          <path
            d="m146.48584 121.41797c.82422-2.6001 3.36719-12.52197 7.95117-10.17529 2.23145 1.1416.4375 4.91699-.73242 6.20117-1.65234 1.81201-4.38672 2.76465-6.59766 3.71338-.20703.08789-.41601.17382-.62109.26074"
            stroke="none"
          />
          <path
            d="m146.24561 127.3623c.37109 1.67188.44824 4.17969-1.02735 5.4004-.96094.79687-3.44336.53515-2.87207-1.25.10547-.32813 1.26172-.67774 1.54785-1.08008.59375-.83887.50782-2.40528.56348-3.3711.07715-1.34668-.0459-2.73437.11035-4.0664.00586-.00196.01172-.00391.0166-.00782.77051 1.31055 1.32325 2.89063 1.66114 4.375"
            stroke="none"
          />
          <path
            d="m146.24561 115.57422c.37109-1.67334.44921-4.17871-1.02735-5.40137-.95996-.79492-3.44629-.53467-2.87207 1.25049.10547.32764 1.2627.67432 1.54785 1.07764.59375.83789.50782 2.40429.56348 3.36963.07715 1.34179-.06543 2.75976.12012 4.07421.7832-1.27636 1.333-2.8999 1.66797-4.3706"
            stroke="none"
          />
          <path d="m142.35693 123.00293c-1.82422-.42871-1.04785-4.39551 1.52051-2.39258 1.54004 1.20117.37598 2.07422-1.52051 2.39258" stroke="none" />
          <path
            d="m20.816895 218.3584c-1.905762 1.02051-3.968262 2.27734-6.077149 2.82226-1.919922.4961-5.5541991.01758-5.9038085-2.51953-.3378906-2.44824 3.1250005-3.54785 4.9931645-3.33105 2.331054.27051 4.774414 1.83887 6.814453 2.93164.057617.03027.117187.06543.17334.09668"
            stroke="none"
          />
          <path
            d="m20.853516 218.37305c-.820313 2.59863-3.365723 12.51953-7.948243 10.17578-2.231933-1.1416-.436035-4.9209.733399-6.20606 1.649414-1.81054 4.384277-2.76172 6.594726-3.70703.206055-.08887.414063-.17578.620118-.26269"
            stroke="none"
          />
          <path
            d="m20.856934 218.36523c-.821778-2.60156-3.367676-12.52539-7.951661-10.17578-2.22998 1.14356-.4375 4.91114.733399 6.19825 1.650879 1.81152 4.384765 2.76757 6.597656 3.71679.205567.08789.415039.17383.620606.26074"
            stroke="none"
          />
          <path
            d="m21.097168 224.30957c-.371582 1.67188-.448242 4.17969 1.027344 5.40039.960449.79492 3.443848.5332 2.871582-1.25-.105957-.33008-1.260254-.6748-1.547363-1.08008-.59375-.83789-.508301-2.40234-.563965-3.36718-.077149-1.34766.046386-2.73731-.109864-4.07032-.005859-.00195-.011718-.0039-.017089-.00781-.769043 1.31055-1.322266 2.89063-1.660645 4.375"
            stroke="none"
          />
          <path
            d="m21.097168 212.52148c-.373047-1.67382-.450684-4.18066 1.027344-5.40136.960449-.79297 3.446289-.53516 2.871582 1.25-.105469.32812-1.261231.67383-1.547363 1.07812-.59375.83692-.508301 2.4043-.563965 3.36914-.077149 1.34766.046386 2.73828-.109864 4.07032-.005859.00195-.011718.00488-.017089.00781-.768555-1.3086-1.326661-2.89063-1.660645-4.37403"
            stroke="none"
          />
          <path d="m24.986328 219.9541c1.828613-.44238 1.04541-4.39355-1.520996-2.39648-1.544434 1.20117-.379883 2.07226 1.520996 2.39648" stroke="none" />
          <path
            d="m20.813477 186.04199c-1.907227 1.02246-3.967286 2.27735-6.077149 2.82422-1.91748.49609-5.5556639.01758-5.9003904-2.52051-.3325195-2.44629 3.1245114-3.54687 4.9931644-3.33105 2.329101.26758 4.773926 1.83887 6.811035 2.93164.058105.03027.116699.06543.17334.0957"
            stroke="none"
          />
          <path
            d="m20.856934 186.05762c-.824219 2.60058-3.3667 12.52148-7.951661 10.17578-2.230468-1.1416-.4375-4.91797.733399-6.20215 1.651855-1.81152 4.385254-2.76367 6.597656-3.71191.205567-.08887.415039-.17579.620606-.26172"
            stroke="none"
          />
          <path
            d="m20.853516 186.0498c-.821289-2.60156-3.36377-12.52148-7.948243-10.17578-2.230957 1.14161-.436523 4.91602.733399 6.20118 1.649902 1.81152 4.383301 2.76562 6.594726 3.71289.205567.08789.414551.1748.620118.26171"
            stroke="none"
          />
          <path
            d="m21.097168 191.98926c-.372559 1.67773-.450684 4.17773 1.027344 5.40137.958496.79394 3.447754.54394 2.871582-1.2461-.105469-.32812-1.261231-.67383-1.547363-1.07715-.59375-.83789-.508301-2.40429-.563965-3.37011-.077149-1.34864.046386-2.73731-.109864-4.07032-.005859-.00195-.011718-.00488-.017089-.00781-.767579 1.30762-1.325684 2.8877-1.660645 4.37012"
            stroke="none"
          />
          <path
            d="m21.097168 180.20605c-.371582-1.67285-.448242-4.17968 1.027344-5.40136.959473-.79395 3.449219-.53418 2.871582 1.25-.105957.32715-1.261231.67285-1.547363 1.07715-.594239.83886-.508301 2.40429-.563965 3.37011-.077149 1.34864.046386 2.73731-.109864 4.07032-.005859.00195-.011718.00488-.017089.00781-.769043-1.31055-1.322266-2.88965-1.660645-4.37403"
            stroke="none"
          />
          <path d="m24.986328 187.63867c1.829102-.44043 1.043945-4.39941-1.520996-2.40137-1.546387 1.20508-.379394 2.07618 1.520996 2.40137" stroke="none" />
          <path
            d="m20.816895 153.72559c-1.903809 1.02441-3.972168 2.28027-6.080567 2.82421-1.919922.4961-5.5512694.01758-5.9003905-2.51953-.3369141-2.44726 3.1235355-3.55175 4.9931645-3.33593 2.331543.2705 4.774902 1.84277 6.814453 2.93554.057617.03125.116699.06641.17334.09571"
            stroke="none"
          />
          <path
            d="m20.856934 153.74121c-.824219 2.60156-3.366211 12.52149-7.951661 10.17578-2.230468-1.14062-.4375-4.91699.733399-6.20117 1.651367-1.81152 4.385742-2.76367 6.597656-3.71289.205567-.08789.415039-.1748.620606-.26172"
            stroke="none"
          />
          <path
            d="m20.856934 153.7334c-.824219-2.60059-3.3667-12.52051-7.951661-10.17578-2.230957 1.1416-.437011 4.91797.733399 6.20215 1.651855 1.81152 4.385742 2.76367 6.597656 3.71191.205567.08887.415039.17578.620606.26172"
            stroke="none"
          />
          <path
            d="m21.097168 159.67773c-.371582 1.67286-.448242 4.17969 1.027344 5.40137.960449.79492 3.446289.53418 2.871582-1.25-.105469-.32812-1.261231-.67383-1.547363-1.07812-.594239-.83789-.508301-2.4043-.563965-3.36914-.07666-1.3418.066894-2.76075-.120117-4.07422-.784668 1.27636-1.332032 2.89941-1.667481 4.37011"
            stroke="none"
          />
          <path
            d="m21.097168 147.88965c-.371582-1.67188-.448242-4.17969 1.027344-5.40039.960449-.79492 3.445801-.53516 2.871582 1.25-.105469.32812-1.261719.67383-1.547363 1.07715-.594239.83789-.508301 2.40429-.563965 3.37011-.07666 1.3418.066894 2.76075-.120117 4.07422-.785157-1.27636-1.332032-2.90039-1.667481-4.37109"
            stroke="none"
          />
          <path d="m24.986328 155.32324c1.82959-.4414 1.043457-4.39062-1.520996-2.40136-1.548828 1.20214-.375488 2.07226 1.520996 2.40136" stroke="none" />
          <path
            d="m20.816895 89.094727c-1.904297 1.021972-3.969239 2.279297-6.077149 2.82373-1.919922.495606-5.5541991.01709-5.9038085-2.520019-.3374023-2.448243 3.1250005-3.54834 4.9931645-3.331543 2.331543.270996 4.773925 1.839355 6.814453 2.93164.057617.030762.116699.065918.17334.096192"
            stroke="none"
          />
          <path
            d="m20.853516 89.110352c-.820801 2.599609-3.365723 12.519528-7.948243 10.175293-2.231933-1.141602-.436035-4.920899.733399-6.205567 1.648926-1.810058 4.384277-2.762695 6.594726-3.708008.205567-.088378.414551-.175781.620118-.261718"
            stroke="none"
          />
          <path
            d="m20.856934 89.102539c-.821778-2.601562-3.368164-12.525879-7.951661-10.175781-2.22998 1.143555-.437988 4.911621.733399 6.197754 1.650879 1.812988 4.385254 2.767089 6.597656 3.716308.205567.088379.415527.174805.620606.261719"
            stroke="none"
          />
          <path
            d="m21.097168 95.045898c-.371582 1.672852-.448242 4.180176 1.027344 5.401852 1.018555.84278 3.412598.48975 2.848633-1.296383-.084473-.267578-1.321778-.750488-1.587891-1.166015-.558105-.871094-.460449-2.441407-.510254-3.423828-.064941-1.275391.081055-2.649415-.117187-3.889649-.769532 1.310547-1.322266 2.890625-1.660645 4.374024"
            stroke="none"
          />
          <path
            d="m21.097168 83.258789c-.372559-1.673828-.450684-4.180176 1.027344-5.401367.959961-.792969 3.446777-.535645 2.871582 1.25-.105469.328125-1.261231.673828-1.547363 1.077637-.59375.837402-.508301 2.404785-.563965 3.369629-.077149 1.348632.046386 2.737792-.109864 4.070312-.005859.001953-.011718.004395-.017089.007813-.768555-1.309083-1.326661-2.890625-1.660645-4.374024"
            stroke="none"
          />
          <path d="m24.986328 90.691406c1.828613-.442383 1.04541-4.393554-1.520996-2.396972-1.544922 1.202148-.379394 2.071777 1.520996 2.396972" stroke="none" />
          <path
            d="m20.813477 56.779297c-1.90625 1.022461-3.967774 2.276367-6.077149 2.82373-1.91748.497071-5.5556639.017579-5.9003904-2.520019-.3325195-2.447266 3.1245114-3.546875 4.9931644-3.331543 2.329101.268066 4.773437 1.839844 6.811035 2.931152.058105.03125.116699.065918.17334.09668"
            stroke="none"
          />
          <path
            d="m20.856934 56.794434c-.824219 2.601074-3.3667 12.520996-7.951661 10.175781-2.230468-1.141113-.437011-4.917481.733399-6.20166 1.651855-1.811524 4.385254-2.763672 6.597656-3.712403.205567-.088378.415527-.175293.620606-.261718"
            stroke="none"
          />
          <path
            d="m20.853516 56.786621c-.820801-2.601074-3.36377-12.520996-7.948243-10.175293-2.231445 1.141113-.436523 4.916992.733399 6.201172 1.65039 1.811523 4.383301 2.764648 6.594726 3.712891.205567.08789.414551.174804.620118.26123"
            stroke="none"
          />
          <path
            d="m21.097168 62.726563c-.372559 1.677734-.450684 4.177734 1.027344 5.401367.958496.793457 3.447754.543945 2.871582-1.246094-.105469-.328125-1.261231-.673828-1.547363-1.077637-.59375-.837402-.508301-2.404785-.563965-3.369629-.077149-1.348632.046386-2.737793-.109864-4.070312-.005859-.001953-.011718-.004395-.017089-.007813-.767579 1.307618-1.325684 2.887696-1.660645 4.370118"
            stroke="none"
          />
          <path
            d="m21.097168 50.942871c-.371582-1.672852-.448242-4.179687 1.027344-5.400879.958984-.793945 3.442871-.538086 2.871582 1.246094-.105957.331055-1.259766.675293-1.547363 1.081055-.594239.838867-.508301 2.404297-.563965 3.370117-.077149 1.348144.046386 2.737305-.109864 4.070312-.006347.001954-.011718.004395-.017089.007813-.769043-1.310547-1.322266-2.890625-1.660645-4.374512"
            stroke="none"
          />
          <path d="m24.986328 58.375488c1.828613-.439941 1.044434-4.398925-1.520996-2.40039-1.545898 1.204101-.379394 2.075683 1.520996 2.40039" stroke="none" />
          <path
            d="m20.816895 24.463379c-1.903809 1.024414-3.972168 2.279785-6.080567 2.82373-1.919922.495606-5.5512694.016602-5.9003905-2.519531-.3369141-2.447754 3.1235355-3.552246 4.9931645-3.335937 2.331543.270019 4.774902 1.842773 6.814453 2.935546.057617.03125.116699.06543.17334.096192"
            stroke="none"
          />
          <path
            d="m20.856934 24.478516c-.824219 2.601562-3.3667 12.521484-7.951661 10.175781-2.230468-1.141113-.437011-4.917481.733399-6.20166 1.651855-1.811524 4.385742-2.763184 6.597656-3.712403.205567-.08789.415527-.174804.620606-.261718"
            stroke="none"
          />
          <path
            d="m20.856934 24.471191c-.823731-2.601074-3.3667-12.520996-7.951661-10.175781-2.230957 1.141113-.437011 4.917481.733399 6.20166 1.651855 1.811524 4.385742 2.763672 6.597656 3.712403.205567.088378.415527.175293.620606.261718"
            stroke="none"
          />
          <path
            d="m21.097168 30.415039c-.371582 1.672363-.448242 4.179688 1.027344 5.401367.960449.794922 3.446289.53418 2.871582-1.250488-.105469-.328125-1.261231-.673828-1.547363-1.077148-.594239-.837891-.508301-2.404786-.563965-3.370118-.07666-1.341308.066894-2.760742-.120117-4.07373-.785157 1.275391-1.33252 2.899414-1.667481 4.370117"
            stroke="none"
          />
          <path
            d="m21.097168 18.627441c-.371582-1.672851-.448242-4.179687 1.027344-5.401367.960449-.794922 3.446289-.534668 2.871582 1.250489-.105469.327636-1.261231.673339-1.547363 1.077148-.594239.837891-.508301 2.404297-.563965 3.370117-.07666 1.341309.066894 2.760254-.120117 4.073731-.784668-1.276856-1.332032-2.899414-1.667481-4.370118"
            stroke="none"
          />
          <path d="m24.986328 26.060059c1.829102-.440918 1.043945-4.390625-1.520996-2.400879-1.548828 1.20166-.375488 2.072754 1.520996 2.400879" stroke="none" />
          <path
            d="m20.816895 121.41016c-1.903809 1.02441-3.972657 2.28027-6.080567 2.82422-1.92041.49511-5.5512694.0166-5.9003905-2.52051-.3374023-2.44824 3.1245115-3.54785 4.9931645-3.33106 2.331543.271 4.773925 1.83887 6.814453 2.93164.057617.03028.116699.06543.17334.09571"
            stroke="none"
          />
          <path
            d="m20.856934 121.42578c-.824219 2.60059-3.3667 12.52051-7.951661 10.17578-2.230468-1.1416-.437011-4.91699.733399-6.20215 1.651855-1.81054 4.385742-2.76367 6.597656-3.71191.205567-.08887.415039-.1748.620606-.26172"
            stroke="none"
          />
          <path
            d="m20.856934 121.41797c-.824219-2.60108-3.3667-12.521-7.951661-10.17529-2.230468 1.14111-.437011 4.91699.733399 6.20117 1.651855 1.81152 4.385254 2.76416 6.597656 3.71338.205567.08789.415039.17382.620606.26074"
            stroke="none"
          />
          <path
            d="m21.097168 127.3623c-.371582 1.67286-.448242 4.17969 1.027344 5.4004.961426.79687 3.443359.53515 2.871582-1.25-.105469-.32911-1.261231-.67676-1.547363-1.08008-.594239-.83789-.508301-2.40528-.563965-3.3711-.077149-1.34668.046386-2.73437-.109864-4.0664-.005859-.00196-.011718-.00391-.017089-.00782-.769043 1.31055-1.322266 2.89063-1.660645 4.375"
            stroke="none"
          />
          <path
            d="m21.097168 115.57422c-.370117-1.67383-.449219-4.17871 1.027344-5.40137.960449-.79492 3.446289-.53418 2.871582 1.25049-.105469.32764-1.261719.67383-1.547363 1.07764-.594239.83789-.508301 2.40429-.563965 3.36963-.07666 1.3413.066894 2.76074-.120117 4.07421-.783204-1.27734-1.332032-2.89941-1.667481-4.3706"
            stroke="none"
          />
          <path d="m24.986328 123.00293c1.824219-.42969 1.046387-4.39551-1.520996-2.39258-1.540039 1.20117-.375977 2.07422 1.520996 2.39258" stroke="none" />
        </g>
        <path d="m73.150879 146.58203h.026855" fill="none" strokeWidth=".026826" />
        <path
          d="m75.666016 112.24658c1.648437 0 16.010253-.13623 16.010253.13428v9.79101 5.65528c0 .43262.311524 2.55176 0 2.88574-1.018554 1.09473-16.010253-.64453-16.010253-.13379 0-6.11133 0-12.22168 0-18.33252"
          fillRule="evenodd"
          stroke="currentColor"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 115.70898c.66748-.76953 1.334473-1.53906 2.001465-2.3081.333496 1.15381.666992 2.3081 1.000488 3.4624-1.000488-.38476-2.000977-.76953-3.001953-1.1543"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="none"
        />
        <path
          d="m88.675293 113.40088c.666016.76904 1.333984 1.53857 2 2.3081-1 .38477-2 .76954-3.001953 1.1543.333984-1.1543.667969-2.30859 1.001953-3.4624"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="none"
        />
        <path
          d="m88.737793 129.49316c.666992-.76953 1.333984-1.53906 2.001953-2.30859-1.001953-.38477-2.001953-.76953-3.001953-1.1543.333008 1.1543.666016 2.3086 1 3.46289"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="none"
        />
        <path
          d="m78.667969 129.55859c-.666992-.76953-1.333985-1.53808-2.001465-2.30761 1.000977-.38477 2.001465-.76953 3.001953-1.1543-.333496 1.1543-.666992 2.30762-1.000488 3.46191"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="none"
        />
        <path
          d="m83.671387 112.24658c-.659668 2.28272-1.319336 4.56494-1.979004 6.84717-.245606.84961-5.069824 2.01855-6.026367 2.38574.956543.36817 5.780761 1.53614 6.026367 2.38672.659668 2.28125 1.319336 4.56445 1.979004 6.84668.660156-2.28223 1.319336-4.56543 1.978515-6.84668.246094-.85058 5.070313-2.01855 6.026367-2.38672-.956054-.36719-5.780273-1.53613-6.026367-2.38574-.659179-2.28223-1.318359-4.56445-1.978515-6.84717"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="none"
        />
        <path
          d="m132.70361 115.70898c-.32617 1.50293-.65136 3.00586-.97754 4.50879-.11328.52393-3.41211 1.08496-4.02539 1.26172.61328.17774 3.91211.73828 4.02539 1.26172.32618 1.50293.65137 3.00586.97754 4.50977.3252-1.50391.65137-3.00684.97754-4.50977.11328-.52344 3.41211-1.08398 4.02539-1.26172-.61328-.17676-3.91211-.73779-4.02539-1.26172-.32617-1.50293-.65234-3.00586-.97754-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.69287 99.543457c-.32519 1.502933-.65137 3.005863-.97656 4.509273-.11328.52344-3.41211 1.08448-4.02637 1.26123.61426.17725 3.91309.7378 4.02637 1.26172.32519 1.50293.65137 3.00635.97656 4.50928.32617-1.50293.65234-3.00635.97852-4.50928.11328-.52392 3.41211-1.08447 4.02539-1.26172-.61328-.17675-3.91211-.73779-4.02539-1.26123-.32618-1.50341-.65235-3.00634-.97852-4.509273"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.72021 131.85547c-.32617 1.50293-.65136 3.00586-.97656 4.50879-.11426.52344-3.41211 1.08496-4.02636 1.26172.61328.17675 3.9121.73828 4.02636 1.26172.3252 1.50293.65039 3.00585.97656 4.50976.32618-1.50391.65235-3.00683.97754-4.50976.11426-.52344 3.41309-1.08497 4.02637-1.26172-.61328-.17676-3.91211-.73828-4.02637-1.26172-.32519-1.50293-.65136-3.00586-.97754-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.69385 115.70898c-.3252 1.50293-.65137 3.00586-.97754 4.50879-.11328.52393-3.41211 1.08496-4.02539 1.26172.61328.17774 3.91211.73828 4.02539 1.26172.32617 1.50293.65234 3.00586.97754 4.50977.32617-1.50391.65136-3.00684.97754-4.50977.11328-.52344 3.41211-1.08398 4.02539-1.26172-.61328-.17676-3.91211-.73779-4.02539-1.26172-.32618-1.50293-.65137-3.00586-.97754-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.68408 99.543457c-.32519 1.502933-.65137 3.005863-.97754 4.509273-.11328.52344-3.41211 1.08448-4.02539 1.26123.61328.17725 3.91211.7378 4.02539 1.26172.32617 1.50293.65235 3.00635.97754 4.50928.32617-1.50293.65137-3.00635.97754-4.50928.11328-.52392 3.41211-1.08447 4.02539-1.26172-.61328-.17675-3.91211-.73779-4.02539-1.26123-.32617-1.50341-.65137-3.00634-.97754-4.509273"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.71045 131.85547c-.3252 1.50293-.65039 3.00586-.97656 4.50879-.11328.52344-3.41211 1.08496-4.02637 1.26172.61426.17675 3.91309.73828 4.02637 1.26172.32617 1.50293.65136 3.00585.97656 4.50976.32617-1.50391.65234-3.00683.97851-4.50976.11329-.52344 3.41211-1.08497 4.0254-1.26172-.61329-.17676-3.91211-.73828-4.0254-1.26172-.32617-1.50293-.65234-3.00586-.97851-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 163.02832c-.325195 1.50293-.650391 3.00586-.976563 4.50977-.113281.52343-3.412109 1.08398-4.02539 1.26074.613281.17676 3.912109.73828 4.02539 1.26269.326172 1.50196.651368 3.00586.976563 4.50782.326172-1.50196.652344-3.00586.978516-4.50782.113281-.52441 3.412109-1.08593 4.02539-1.26269-.613281-.17676-3.912109-.73731-4.02539-1.26074-.326172-1.50391-.652344-3.00684-.978516-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 163.02832c-.325684 1.50293-.651367 3.00586-.977051 4.50977-.113769.52343-3.412598 1.08398-4.026367 1.26074.613769.17676 3.912598.73828 4.026367 1.26269.325684 1.50196.651367 3.00586.977051 4.50782.326172-1.50196.651855-3.00586.977539-4.50782.11377-.52441 3.412598-1.08593 4.025879-1.26269-.613281-.17676-3.91211-.73731-4.025879-1.26074-.325684-1.50391-.651367-3.00684-.977539-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.67529 163.00098c-.32617 1.5039-.65234 3.00683-.97754 4.50976-.11328.52344-3.41308 1.08399-4.026363 1.26172.613283.17676 3.913083.73828 4.026363 1.26172.3252 1.50293.65137 3.00586.97754 4.50879.32617-1.50293.65137-3.00586.97657-4.50879.11425-.52344 3.4121-1.08496 4.02636-1.26172-.61426-.17773-3.91211-.73828-4.02636-1.26172-.3252-1.50293-.6504-3.00586-.97657-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.697266 163.04395c-.325684 1.50293-.651368 3.00585-.977051 4.50878-.113281.52442-3.41211 1.08497-4.025879 1.26172.613769.17676 3.912598.73731 4.025879 1.26172.325683 1.50293.651367 3.00586.977051 4.50879.326172-1.50293.651855-3.00586.978027-4.50879.113281-.52441 3.412109-1.08496 4.02539-1.26172-.613281-.17675-3.912109-.7373-4.02539-1.26172-.326172-1.50293-.651856-3.00585-.978027-4.50878"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.67334 163.02441c-.32617 1.50391-.65137 3.00586-.97656 4.50977-.11426.52344-3.41309 1.08398-4.02735 1.26172.61426.17578 3.91309.7373 4.02735 1.26172.32519 1.50195.65039 3.00586.97656 4.50781.32617-1.50195.65137-3.00586.97754-4.50781.11328-.52442 3.41211-1.08594 4.02637-1.26172-.61426-.17774-3.91309-.73828-4.02637-1.26172-.32617-1.50391-.65137-3.00586-.97754-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.66357 163.02441c-.32519 1.50391-.65136 3.00586-.97656 4.50977-.11426.52344-3.41211 1.08398-4.02637 1.26172.61426.17578 3.91211.7373 4.02637 1.26172.3252 1.50195.65137 3.00586.97656 4.50781.32618-1.50195.65235-3.00586.97852-4.50781.11328-.52442 3.41211-1.08594 4.02539-1.26172-.61328-.17774-3.91211-.73828-4.02539-1.26172-.32617-1.50391-.65234-3.00586-.97852-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 179.18652c-.325195 1.50293-.650391 3.00586-.976563 4.50879-.113281.52344-3.412109 1.08496-4.02539 1.26172.613281.17676 3.912109.73731 4.02539 1.26172.326172 1.50293.651368 3.00586.976563 4.50879.326172-1.50293.652344-3.00586.978516-4.50879.113281-.52441 3.412109-1.08496 4.02539-1.26172-.613281-.17676-3.912109-.73828-4.02539-1.26172-.326172-1.50293-.652344-3.00586-.978516-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 179.18652c-.325684 1.50293-.651367 3.00586-.977051 4.50879-.113769.52344-3.412598 1.08496-4.026367 1.26172.613769.17676 3.912598.73731 4.026367 1.26172.325684 1.50293.651367 3.00586.977051 4.50879.326172-1.50293.651855-3.00586.977539-4.50879.11377-.52441 3.412598-1.08496 4.025879-1.26172-.613281-.17676-3.91211-.73828-4.025879-1.26172-.325684-1.50293-.651367-3.00586-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.67529 179.15918c-.32617 1.50293-.65234 3.00586-.97754 4.50977-.11328.52343-3.41308 1.08398-4.026363 1.26171.613283.17579 3.913083.73731 4.026363 1.26172.3252 1.50196.65137 3.00586.97754 4.50782.32617-1.50196.65137-3.00586.97657-4.50782.11425-.52441 3.4121-1.08593 4.02636-1.26172-.61426-.17773-3.91211-.73828-4.02636-1.26171-.3252-1.50391-.6504-3.00684-.97657-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.697266 179.20215c-.325684 1.50293-.651368 3.00586-.977051 4.50879-.113281.52344-3.41211 1.08496-4.025879 1.26172.613769.17675 3.912598.7373 4.025879 1.26172.325683 1.50292.651367 3.00585.977051 4.50878.326172-1.50293.651855-3.00586.978027-4.50878.113281-.52442 3.412109-1.08497 4.02539-1.26172-.613281-.17676-3.912109-.73828-4.02539-1.26172-.326172-1.50293-.651856-3.00586-.978027-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.67334 179.18262c-.32617 1.50293-.65137 3.00586-.97656 4.50879-.11426.52441-3.41309 1.08496-4.02735 1.26172.61426.17675 3.91309.73828 4.02735 1.26171.32519 1.50293.65039 3.00586.97656 4.50879.32617-1.50293.65137-3.00586.97754-4.50879.11328-.52343 3.41211-1.08496 4.02637-1.26171-.61426-.17676-3.91309-.73731-4.02637-1.26172-.32617-1.50293-.65137-3.00586-.97754-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.66357 179.18262c-.32519 1.50293-.65136 3.00586-.97656 4.50879-.11426.52441-3.41211 1.08496-4.02637 1.26172.61426.17675 3.91211.73828 4.02637 1.26171.3252 1.50293.65137 3.00586.97656 4.50879.32618-1.50293.65235-3.00586.97852-4.50879.11328-.52343 3.41211-1.08496 4.02539-1.26171-.61328-.17676-3.91211-.73731-4.02539-1.26172-.32617-1.50293-.65234-3.00586-.97852-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 195.34473c-.325195 1.50195-.650391 3.00586-.976563 4.50879-.113281.52343-3.412109 1.08496-4.02539 1.26074.613281.17773 3.912109.73828 4.02539 1.26172.326172 1.5039.651368 3.00586.976563 4.50976.326172-1.5039.652344-3.00586.978516-4.50976.113281-.52344 3.412109-1.08399 4.02539-1.26172-.613281-.17578-3.912109-.73731-4.02539-1.26074-.326172-1.50293-.652344-3.00684-.978516-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 195.34473c-.325684 1.50195-.651367 3.00586-.977051 4.50879-.113769.52343-3.412598 1.08496-4.026367 1.26074.613769.17773 3.912598.73828 4.026367 1.26172.325684 1.5039.651367 3.00586.977051 4.50976.326172-1.5039.651855-3.00586.977539-4.50976.11377-.52344 3.412598-1.08399 4.025879-1.26172-.613281-.17578-3.91211-.73731-4.025879-1.26074-.325684-1.50293-.651367-3.00684-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.67529 195.31738c-.32617 1.50293-.65234 3.00586-.97754 4.50977-.11328.52344-3.41308 1.08398-4.026363 1.26074.613283.17676 3.913083.73731 4.026363 1.26172.3252 1.50293.65137 3.00586.97754 4.50879.32617-1.50293.65137-3.00586.97657-4.50879.11425-.52441 3.4121-1.08496 4.02636-1.26172-.61426-.17676-3.91211-.7373-4.02636-1.26074-.3252-1.50391-.6504-3.00684-.97657-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.697266 195.36035c-.325684 1.50195-.651368 3.00586-.977051 4.50781-.113281.52344-3.41211 1.08497-4.025879 1.26172.613769.17774 3.912598.73828 4.025879 1.26172.325683 1.50391.651367 3.00586.977051 4.50977.326172-1.50391.651855-3.00586.978027-4.50977.113281-.52344 3.412109-1.08398 4.02539-1.26172-.613281-.17675-3.912109-.73828-4.02539-1.26172-.326172-1.50195-.651856-3.00586-.978027-4.50781"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.67334 195.34082c-.32617 1.50195-.65137 3.00586-.97656 4.50879-.11426.52344-3.41309 1.08496-4.02735 1.26172.61426.17676 3.91309.7373 4.02735 1.26074.32519 1.50391.65039 3.00586.97656 4.50977.32617-1.50391.65137-3.00586.97754-4.50977.11328-.52344 3.41211-1.08398 4.02637-1.26074-.61426-.17676-3.91309-.73828-4.02637-1.26172-.32617-1.50293-.65137-3.00684-.97754-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.66357 195.34082c-.32519 1.50195-.65136 3.00586-.97656 4.50879-.11426.52344-3.41211 1.08496-4.02637 1.26172.61426.17676 3.91211.7373 4.02637 1.26074.3252 1.50391.65137 3.00586.97656 4.50977.32618-1.50391.65235-3.00586.97852-4.50977.11328-.52344 3.41211-1.08398 4.02539-1.26074-.61328-.17676-3.91211-.73828-4.02539-1.26172-.32617-1.50293-.65234-3.00684-.97852-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 148.02441c-.325195 1.50391-.650391 3.00586-.976563 4.50977-.113281.52344-3.412109 1.08398-4.02539 1.26172.613281.17676 3.912109.7373 4.02539 1.26172.326172 1.50195.651368 3.00586.976563 4.50781.326172-1.50195.652344-3.00586.978516-4.50781.113281-.52442 3.412109-1.08594 4.02539-1.26172-.613281-.17774-3.912109-.73828-4.02539-1.26172-.326172-1.50391-.652344-3.00586-.978516-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 148.02441c-.325684 1.50391-.651367 3.00586-.977051 4.50977-.113769.52344-3.412598 1.08398-4.026367 1.26172.613769.17578 3.912598.7373 4.026367 1.26172.325684 1.50195.651367 3.00586.977051 4.50781.326172-1.50195.651855-3.00586.977539-4.50781.11377-.52442 3.412598-1.08594 4.025879-1.26172-.613281-.17774-3.91211-.73828-4.025879-1.26172-.325684-1.50391-.651367-3.00586-.977539-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.67529 147.99805c-.32617 1.50293-.65234 3.00586-.97754 4.50879-.11328.52343-3.41308 1.08496-4.026363 1.26171.613283.17676 3.913083.73829 4.026363 1.26172.3252 1.50293.65137 3.00586.97754 4.50879.32617-1.50293.65137-3.00586.97657-4.50879.11425-.52343 3.4121-1.08496 4.02636-1.26172-.61426-.17675-3.91211-.73828-4.02636-1.26171-.3252-1.50293-.6504-3.00586-.97657-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.697266 148.04004c-.325684 1.50293-.651368 3.00586-.977051 4.50976-.113281.52344-3.41211 1.08399-4.025879 1.26075.613769.17675 3.912598.73828 4.025879 1.26269.325683 1.50196.651367 3.00586.977051 4.50781.326172-1.50195.651855-3.00585.978027-4.50781.113281-.52441 3.412109-1.08594 4.02539-1.26269-.613281-.17676-3.912109-.73731-4.02539-1.26075-.326172-1.5039-.651856-3.00683-.978027-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.67334 148.02051c-.32617 1.5039-.65137 3.00586-.97656 4.50976-.11426.52344-3.41309 1.08399-4.02735 1.26172.61426.17676 3.91309.73731 4.02735 1.26172.32519 1.50195.65039 3.00586.97656 4.50879.32617-1.50293.65137-3.00684.97754-4.50879.11328-.52441 3.41211-1.08496 4.02637-1.26172-.61426-.17773-3.91309-.73828-4.02637-1.26172-.32617-1.5039-.65137-3.00586-.97754-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.66357 148.02051c-.32519 1.5039-.65136 3.00586-.97656 4.50976-.11426.52344-3.41211 1.08399-4.02637 1.26172.61426.17676 3.91211.73731 4.02637 1.26172.3252 1.50195.65137 3.00586.97656 4.50879.32618-1.50293.65235-3.00684.97852-4.50879.11328-.52441 3.41211-1.08496 4.02539-1.26172-.61328-.17773-3.91211-.73828-4.02539-1.26172-.32617-1.5039-.65234-3.00586-.97852-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 83.393555c-.325684 1.502929-.651367 3.005859-.977051 4.508789-.113769.523926-3.412598 1.084961-4.026367 1.261719.613769.176757 3.912598.737793 4.026367 1.261718.325684 1.50293.651367 3.00586.977051 4.508789.326172-1.502929.651855-3.005859.977539-4.508789.11377-.523925 3.412598-1.084961 4.025879-1.261718-.613281-.176758-3.91211-.737793-4.025879-1.261719-.325684-1.50293-.651367-3.00586-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.657227 83.393555c-.325684 1.502929-.651368 3.005859-.977051 4.508789-.113281.523926-3.412598 1.084961-4.026367 1.261719.613769.176757 3.913085.737793 4.026367 1.261718.325683 1.50293.651367 3.00586.977051 4.508789.326172-1.502929.651855-3.005859.977539-4.508789.113769-.523925 3.412597-1.084961 4.025879-1.261718-.613282-.176758-3.91211-.737793-4.025879-1.261719-.325684-1.50293-.651368-3.00586-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.68115 83.393555c-.32519 1.502929-.65039 3.005859-.97656 4.508789-.11328.523926-3.41211 1.084961-4.026367 1.261719.614257.176757 3.913087.737793 4.026367 1.261718.32617 1.50293.65137 3.00586.97656 4.508789.32617-1.502929.65235-3.005859.97852-4.508789.11328-.523925 3.41211-1.084961 4.02539-1.261718-.61328-.176758-3.91211-.737793-4.02539-1.261719-.32617-1.50293-.65235-3.00586-.97852-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.669434 83.393555c-.326172 1.502929-.652344 3.005859-.977539 4.508789-.113282.523926-3.41211 1.084961-4.026368 1.261719.614258.176757 3.913086.737793 4.026368 1.261718.325195 1.50293.651367 3.00586.977539 4.508789.326172-1.502929.651367-3.005859.977539-4.508789.113281-.523925 3.412109-1.084961 4.02539-1.261718-.613281-.176758-3.912109-.737793-4.02539-1.261719-.326172-1.50293-.651367-3.00586-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.664551 67.224121c-.325684 1.50293-.651856 3.00586-.977539 4.508789-.11377.523926-3.41211 1.084961-4.025879 1.261719.613769.177246 3.912597.737793 4.025879 1.261719.325683 1.502929.651855 3.005859.977539 4.509277.325683-1.503418.651367-3.006348.977539-4.509277.113281-.523926 3.412109-1.084473 4.02539-1.261719-.613281-.176758-3.912109-.737793-4.02539-1.261719-.326172-1.502929-.651856-3.005859-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 67.235352c-.325684 1.502929-.651367 3.006347-.977051 4.509277-.113769.523926-3.412598 1.084473-4.026367 1.261719.613769.176757 3.912598.737793 4.026367 1.261718.325684 1.50293.651367 3.00586.977051 4.50879.326172-1.50293.651855-3.00586.977539-4.50879.11377-.523925 3.412598-1.08496 4.025879-1.261718-.613281-.177246-3.91211-.737793-4.025879-1.261719-.325684-1.50293-.651367-3.006348-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 67.235352c-.325195 1.502929-.650391 3.006347-.976563 4.509277-.113281.523926-3.412109 1.084473-4.02539 1.261719.613281.176757 3.912109.737793 4.02539 1.261718.326172 1.50293.651368 3.00586.976563 4.50879.326172-1.50293.652344-3.00586.978516-4.50879.113281-.523925 3.412109-1.08496 4.02539-1.261718-.613281-.177246-3.912109-.737793-4.02539-1.261719-.326172-1.50293-.652344-3.006348-.978516-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.68506 67.235352c-.32617 1.502929-.65235 3.006347-.97754 4.509277-.11328.523926-3.41211 1.084473-4.026368 1.261719.614258.176757 3.913088.737793 4.026368 1.261718.32519 1.50293.65137 3.00586.97754 4.50879.32617-1.50293.65137-3.00586.97754-4.50879.11328-.523925 3.41211-1.08496 4.02636-1.261718-.61425-.177246-3.91308-.737793-4.02636-1.261719-.32617-1.50293-.65137-3.006348-.97754-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.68994 83.374023c-.32519 1.50293-.65137 3.00586-.97754 4.509278-.11328.523925-3.41211 1.084472-4.02539 1.26123.61328.177246 3.91211.738281 4.02539 1.261719.32617 1.50293.65235 3.005859.97754 4.509277.3252-1.503418.65137-3.006347.97754-4.509277.11328-.523438 3.41211-1.084473 4.02539-1.261719-.61328-.176758-3.91211-.737305-4.02539-1.26123-.32617-1.503418-.65234-3.006348-.97754-4.509278"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.70361 67.235352c-.32617 1.502929-.65136 3.006347-.97754 4.509277-.11328.523926-3.41211 1.084473-4.02539 1.261719.61328.176757 3.91211.737793 4.02539 1.261718.32618 1.50293.65137 3.00586.97754 4.50879.3252-1.50293.65137-3.00586.97754-4.50879.11328-.523925 3.41211-1.08496 4.02539-1.261718-.61328-.177246-3.91211-.737793-4.02539-1.261719-.32617-1.50293-.65234-3.006348-.97754-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.68115 83.374023c-.32617 1.50293-.65234 3.00586-.97754 4.509278-.11328.523925-3.41211 1.084472-4.02636 1.26123.61425.177246 3.91308.738281 4.02636 1.261719.3252 1.50293.65137 3.005859.97754 4.509277.32617-1.503418.65137-3.006347.97656-4.509277.11426-.523438 3.41309-1.084473 4.02637-1.261719-.61328-.176758-3.91211-.737305-4.02637-1.26123-.32519-1.503418-.65039-3.006348-.97656-4.509278"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.69385 67.235352c-.3252 1.502929-.65137 3.006347-.97754 4.509277-.11328.523926-3.41211 1.084473-4.02539 1.261719.61328.176757 3.91211.737793 4.02539 1.261718.32617 1.50293.65234 3.00586.97754 4.50879.32617-1.50293.65136-3.00586.97754-4.50879.11328-.523925 3.41211-1.08496 4.02539-1.261718-.61328-.177246-3.91211-.737793-4.02539-1.261719-.32618-1.50293-.65137-3.006348-.97754-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 51.077637c-.325684 1.502929-.651367 3.005859-.977051 4.509277-.113769.523438-3.412598 1.084473-4.026367 1.261719.613769.176758 3.912598.737305 4.026367 1.26123.325684 1.50293.651367 3.006348.977051 4.509278.326172-1.50293.651855-3.006348.977539-4.509278.11377-.523925 3.412598-1.084472 4.025879-1.26123-.613281-.177246-3.91211-.738281-4.025879-1.261719-.325684-1.503418-.651367-3.006348-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.657227 51.077637c-.325684 1.502929-.651368 3.005859-.977051 4.509277-.113281.523438-3.412598 1.084473-4.026367 1.261719.613769.176758 3.913085.737305 4.026367 1.26123.325683 1.50293.651367 3.006348.977051 4.509278.326172-1.50293.651855-3.006348.977539-4.509278.113769-.523925 3.412597-1.084472 4.025879-1.26123-.613282-.177246-3.91211-.738281-4.025879-1.261719-.325684-1.503418-.651368-3.006348-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.68115 51.077637c-.32519 1.502929-.65039 3.005859-.97656 4.509277-.11328.523438-3.41211 1.084473-4.026367 1.261719.614257.176758 3.913087.737305 4.026367 1.26123.32617 1.50293.65137 3.006348.97656 4.509278.32617-1.50293.65235-3.006348.97852-4.509278.11328-.523925 3.41211-1.084472 4.02539-1.26123-.61328-.177246-3.91211-.738281-4.02539-1.261719-.32617-1.503418-.65235-3.006348-.97852-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.669434 51.077637c-.326172 1.502929-.652344 3.005859-.977539 4.509277-.113282.523438-3.41211 1.084473-4.026368 1.261719.614258.176758 3.913086.737305 4.026368 1.26123.325195 1.50293.651367 3.006348.977539 4.509278.326172-1.50293.651367-3.006348.977539-4.509278.113281-.523925 3.412109-1.084472 4.02539-1.26123-.613281-.177246-3.912109-.738281-4.02539-1.261719-.326172-1.503418-.651367-3.006348-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m62.664551 34.908203c-.325684 1.50293-.651856 3.00586-.977539 4.508789-.113282.523926-3.41211 1.084961-4.025879 1.261719.613769.177246 3.912109.738281 4.025879 1.261719.325683 1.50293.651855 3.005859.977539 4.508789.325683-1.50293.651367-3.005859.977539-4.508789.113281-.523438 3.412109-1.084473 4.02539-1.261719-.613281-.176758-3.912109-.737793-4.02539-1.261719-.326172-1.502929-.651856-3.005859-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m76.666504 34.919922c-.325684 1.50293-.651367 3.005859-.977051 4.508789-.113769.523926-3.412598 1.084961-4.026367 1.261719.613769.176758 3.912598.737793 4.026367 1.261719.325684 1.502929.651367 3.005859.977051 4.508789.326172-1.50293.651855-3.00586.977539-4.508789.11377-.523926 3.412598-1.084961 4.025879-1.261719-.613281-.176758-3.91211-.737793-4.025879-1.261719-.325684-1.50293-.651367-3.005859-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m90.675293 34.919922c-.325195 1.50293-.650391 3.005859-.976563 4.508789-.113281.523926-3.412109 1.084961-4.02539 1.261719.613281.176758 3.912109.737793 4.02539 1.261719.326172 1.502929.651368 3.005859.976563 4.508789.326172-1.50293.652344-3.00586.978516-4.508789.113281-.523926 3.412109-1.084961 4.02539-1.261719-.613281-.176758-3.912109-.737793-4.02539-1.261719-.326172-1.50293-.652344-3.005859-.978516-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m104.68506 34.919922c-.32617 1.50293-.65235 3.005859-.97754 4.508789-.11328.523926-3.41211 1.084961-4.026368 1.261719.614258.176758 3.913088.737793 4.026368 1.261719.32519 1.502929.65137 3.005859.97754 4.508789.32617-1.50293.65137-3.00586.97754-4.508789.11328-.523926 3.41211-1.084961 4.02636-1.261719-.61425-.176758-3.91308-.737793-4.02636-1.261719-.32617-1.50293-.65137-3.005859-.97754-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.68994 51.058594c-.32519 1.50293-.65137 3.005859-.97754 4.508789-.11328.523926-3.41211 1.084961-4.02539 1.261719.61328.176757 3.91211.737793 4.02539 1.261718.32617 1.50293.65235 3.00586.97754 4.50879.3252-1.50293.65137-3.00586.97754-4.50879.11328-.523925 3.41211-1.08496 4.02539-1.261718-.61328-.176758-3.91211-.737793-4.02539-1.261719-.32617-1.50293-.65234-3.005859-.97754-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m132.70361 34.919922c-.32617 1.50293-.65136 3.005859-.97754 4.508789-.11328.523926-3.41211 1.084961-4.02539 1.261719.61328.176758 3.91211.737793 4.02539 1.261719.32618 1.502929.65137 3.005859.97754 4.508789.3252-1.50293.65137-3.00586.97754-4.508789.11328-.523926 3.41211-1.084961 4.02539-1.261719-.61328-.176758-3.91211-.737793-4.02539-1.261719-.32617-1.50293-.65234-3.005859-.97754-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.68115 51.058594c-.32617 1.50293-.65234 3.005859-.97754 4.508789-.11328.523926-3.41211 1.084961-4.02636 1.261719.61425.176757 3.91308.737793 4.02636 1.261718.3252 1.50293.65137 3.00586.97754 4.50879.32617-1.50293.65137-3.00586.97656-4.50879.11426-.523925 3.41309-1.08496 4.02637-1.261718-.61328-.176758-3.91211-.737793-4.02637-1.261719-.32519-1.50293-.65039-3.005859-.97656-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m118.69385 34.919922c-.3252 1.50293-.65137 3.005859-.97754 4.508789-.11328.523926-3.41211 1.084961-4.02539 1.261719.61328.176758 3.91211.737793 4.02539 1.261719.32617 1.502929.65234 3.005859.97754 4.508789.32617-1.50293.65136-3.00586.97754-4.508789.11328-.523926 3.41211-1.084961 4.02539-1.261719-.61328-.176758-3.91211-.737793-4.02539-1.261719-.32618-1.50293-.65137-3.005859-.97754-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.628906 131.88184c-.325683 1.5039-.651367 3.00586-.977051 4.50976-.113281.52344-3.412109 1.08399-4.025878 1.26172.613769.17676 3.912597.73731 4.025878 1.26172.325684 1.50195.651368 3.00586.977051 4.50879.326172-1.50293.651856-3.00684.977539-4.50879.11377-.52441 3.412598-1.08496 4.025879-1.26172-.613281-.17773-3.912109-.73828-4.025879-1.26172-.325683-1.5039-.651367-3.00586-.977539-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.655762 115.73242c-.325684 1.50293-.651368 3.00586-.977051 4.50879-.113281.52344-3.412109 1.08399-4.025879 1.26172.613769.17676 3.912598.73828 4.025879 1.26172.325683 1.50293.651367 3.00586.977051 4.50879.326172-1.50293.651855-3.00586.978027-4.50879.113281-.52344 3.412109-1.08496 4.025391-1.26172-.613282-.17773-3.91211-.73828-4.025391-1.26172-.326172-1.50293-.651856-3.00586-.978027-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.672363 99.547363c-.325683 1.502927-.651367 3.006347-.97705 4.509277-.11377.52344-3.41211 1.08447-4.025879 1.26172.613769.17676 3.912109.73779 4.025879 1.26172.325683 1.50293.651367 3.00586.97705 4.50879.326172-1.50293.651856-3.00586.978028-4.50879.113281-.52393 3.412109-1.08496 4.02539-1.26172-.613281-.17725-3.912109-.73828-4.02539-1.26172-.326172-1.50293-.651856-3.00635-.978028-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 163.02832c-.325683 1.50293-.651367 3.00586-.977051 4.50977-.113281.52343-3.412597 1.08398-4.026367 1.26074.61377.17676 3.913086.73828 4.026367 1.26269.325684 1.50196.651368 3.00586.977051 4.50782.325684-1.50196.651367-3.00586.977539-4.50782.113282-.52441 3.41211-1.08593 4.025391-1.26269-.613281-.17676-3.912109-.73731-4.025391-1.26074-.326172-1.50391-.651855-3.00684-.977539-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 179.18652c-.325683 1.50293-.651367 3.00586-.977051 4.50879-.113281.52344-3.412597 1.08496-4.026367 1.26172.61377.17676 3.913086.73731 4.026367 1.26172.325684 1.50293.651368 3.00586.977051 4.50879.325684-1.50293.651367-3.00586.977539-4.50879.113282-.52441 3.41211-1.08496 4.025391-1.26172-.613281-.17676-3.912109-.73828-4.025391-1.26172-.326172-1.50293-.651855-3.00586-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 195.34473c-.325683 1.50195-.651367 3.00586-.977051 4.50879-.113281.52343-3.412597 1.08496-4.026367 1.26074.61377.17773 3.913086.73828 4.026367 1.26172.325684 1.5039.651368 3.00586.977051 4.50976.325684-1.5039.651367-3.00586.977539-4.50976.113282-.52344 3.41211-1.08399 4.025391-1.26172-.613281-.17578-3.912109-.73731-4.025391-1.26074-.326172-1.50293-.651855-3.00684-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 148.02441c-.325683 1.50391-.651367 3.00586-.977051 4.50977-.113281.52344-3.412597 1.08398-4.026367 1.26172.61377.17578 3.913086.7373 4.026367 1.26172.325684 1.50195.651368 3.00586.977051 4.50781.325684-1.50195.651367-3.00586.977539-4.50781.113282-.52442 3.41211-1.08496 4.025391-1.26172-.613281-.17774-3.912109-.73828-4.025391-1.26172-.326172-1.50391-.651855-3.00586-.977539-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.649414 83.389648c-.325683 1.50293-.651855 3.00586-.977539 4.50879-.113281.523925-3.412109 1.08496-4.025879 1.261718.61377.176758 3.912109.738282 4.025879 1.261719.325684 1.50293.651856 3.00586.977539 4.508789.325684-1.502929.651367-3.005859.977539-4.508789.113282-.523437 3.41211-1.084961 4.025879-1.261719-.613769-.176758-3.912598-.737793-4.025879-1.261718-.326172-1.50293-.651855-3.00586-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 67.235352c-.325683 1.502929-.651367 3.006347-.977051 4.509277-.113281.523926-3.412597 1.084473-4.026367 1.261719.61377.176757 3.913086.737793 4.026367 1.261718.325684 1.50293.651368 3.00586.977051 4.50879.325684-1.50293.651367-3.00586.977539-4.50879.113282-.523925 3.41211-1.08496 4.025391-1.261718-.613281-.177246-3.912109-.737793-4.025391-1.261719-.326172-1.50293-.651855-3.006348-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.649414 51.073731c-.325683 1.503418-.651855 3.006347-.977539 4.509277-.113281.523437-3.412109 1.084473-4.025879 1.261719.61377.176757 3.912598.737793 4.025879 1.261718.325684 1.50293.651856 3.00586.977539 4.50879.325684-1.50293.651367-3.00586.977539-4.50879.113282-.523925 3.41211-1.08496 4.025879-1.261718-.613769-.177246-3.912598-.738282-4.025879-1.261719-.326172-1.50293-.651855-3.00586-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m34.63916 34.919922c-.325683 1.50293-.651367 3.005859-.977051 4.508789-.113281.523926-3.412597 1.084961-4.026367 1.261719.61377.176758 3.913086.737793 4.026367 1.261719.325684 1.502929.651368 3.005859.977051 4.508789.325684-1.50293.651367-3.00586.977539-4.508789.113282-.523926 3.41211-1.084961 4.025391-1.261719-.613281-.176758-3.912109-.737793-4.025391-1.261719-.326172-1.50293-.651855-3.005859-.977539-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.638184 131.88184c-.325684 1.5039-.651368 3.00586-.977051 4.50976-.11377.52344-3.412598 1.08399-4.026367 1.26172.613769.17676 3.912597.73731 4.026367 1.26172.325683 1.50195.651367 3.00586.977051 4.50879.325683-1.50293.651367-3.00684.977539-4.50879.113281-.52441 3.412597-1.08496 4.025879-1.26172-.613282-.17773-3.912598-.73828-4.025879-1.26172-.326172-1.5039-.651856-3.00586-.977539-4.50976"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.665039 115.73242c-.325683 1.50293-.651367 3.00586-.977051 4.50879-.113769.52344-3.412109 1.08399-4.025879 1.26172.61377.17676 3.91211.73828 4.025879 1.26172.325684 1.50293.651368 3.00586.977051 4.50879.326172-1.50293.651856-3.00586.977539-4.50879.11377-.52344 3.412598-1.08496 4.025879-1.26172-.613281-.17773-3.912109-.73828-4.025879-1.26172-.325683-1.50293-.651367-3.00586-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.681641 99.547363c-.325684 1.502927-.651368 3.006347-.977051 4.509277-.11377.52344-3.412598 1.08447-4.026367 1.26172.613769.17676 3.912597.73779 4.026367 1.26172.325683 1.50293.651367 3.00586.977051 4.50879.325683-1.50293.651855-3.00586.977539-4.50879.113769-.52393 3.412109-1.08496 4.025879-1.26172-.61377-.17725-3.91211-.73828-4.025879-1.26172-.325684-1.50293-.651856-3.00635-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 163.02832c-.325684 1.50293-.651856 3.00586-.97754 4.50977-.113281.52343-3.412109 1.08398-4.025879 1.26074.61377.17676 3.91211.73828 4.025879 1.26269.325684 1.50196.651856 3.00586.97754 4.50782.325683-1.50196.651367-3.00586.97705-4.50782.11377-.52441 3.412598-1.08593 4.026368-1.26269-.61377-.17676-3.912598-.73731-4.026368-1.26074-.325683-1.50391-.651367-3.00684-.97705-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 179.18652c-.325684 1.50293-.651856 3.00586-.97754 4.50879-.113281.52344-3.412109 1.08496-4.025879 1.26172.61377.17676 3.912598.73731 4.025879 1.26172.325684 1.50293.651856 3.00586.97754 4.50879.325683-1.50293.651367-3.00586.97705-4.50879.11377-.52441 3.412598-1.08496 4.026368-1.26172-.61377-.17676-3.912598-.73828-4.026368-1.26172-.325683-1.50293-.651367-3.00586-.97705-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 195.34473c-.325684 1.50195-.651856 3.00586-.97754 4.50879-.113281.52343-3.412109 1.08496-4.025879 1.26074.61377.17773 3.912598.73828 4.025879 1.26172.325684 1.5039.651856 3.00586.97754 4.50976.325683-1.5039.651367-3.00586.97705-4.50976.11377-.52344 3.412598-1.08399 4.026368-1.26172-.61377-.17578-3.912598-.73731-4.026368-1.26074-.325683-1.50293-.651367-3.00684-.97705-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 148.02441c-.325684 1.50391-.651856 3.00586-.97754 4.50977-.113281.52344-3.412109 1.08398-4.025879 1.26172.61377.17676 3.912598.7373 4.025879 1.26172.325684 1.50195.651856 3.00586.97754 4.50781.325683-1.50195.651367-3.00586.97705-4.50781.11377-.52442 3.412598-1.08594 4.026368-1.26172-.61377-.17774-3.912598-.73828-4.026368-1.26172-.325683-1.50391-.651367-3.00586-.97705-4.50977"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.658203 83.389648c-.325683 1.50293-.651367 3.00586-.977051 4.50879-.113281.523925-3.412109 1.08496-4.025879 1.261718.61377.176758 3.912598.738282 4.025879 1.261719.325684 1.50293.651368 3.00586.977051 4.508789.326172-1.502929.651856-3.005859.977539-4.508789.11377-.523437 3.412598-1.084961 4.025879-1.261719-.613281-.176758-3.912109-.737793-4.025879-1.261718-.325683-1.50293-.651367-3.00586-.977539-4.50879"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 67.235352c-.325684 1.502929-.651856 3.006347-.97754 4.509277-.113281.523926-3.412109 1.084473-4.025879 1.261719.61377.176757 3.912598.737793 4.025879 1.261718.325684 1.50293.651856 3.00586.97754 4.50879.325683-1.50293.651367-3.00586.97705-4.50879.11377-.523925 3.412598-1.08496 4.026368-1.261718-.61377-.177246-3.912598-.737793-4.026368-1.261719-.325683-1.50293-.651367-3.006348-.97705-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.658203 51.073731c-.325683 1.503418-.651367 3.006347-.977051 4.509277-.113281.523437-3.412109 1.084473-4.025879 1.261719.61377.176757 3.912598.737793 4.025879 1.261718.325684 1.50293.651368 3.00586.977051 4.50879.326172-1.50293.651856-3.00586.977539-4.50879.11377-.523925 3.412598-1.08496 4.025879-1.261718-.613281-.177246-3.912109-.738282-4.025879-1.261719-.325683-1.50293-.651367-3.00586-.977539-4.509277"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m48.648438 34.919922c-.325684 1.50293-.651856 3.005859-.97754 4.508789-.113281.523926-3.412109 1.084961-4.025879 1.261719.61377.176758 3.912598.737793 4.025879 1.261719.325684 1.502929.651856 3.005859.97754 4.508789.325683-1.50293.651367-3.00586.97705-4.508789.11377-.523926 3.412598-1.084961 4.026368-1.261719-.61377-.176758-3.912598-.737793-4.026368-1.261719-.325683-1.50293-.651367-3.005859-.97705-4.508789"
          fill="var(--theme-background)"
          fillRule="evenodd"
          stroke="var(--theme-background)"
          strokeWidth=".026826"
        />
        <path
          d="m8.3720703 6.6435547c-2.3525391 0-1.5009766 6.4189453-1.5009766 7.7011723v17.585449 58.15625 124.670414 15.49609c0 1.75195-.6660156 5.48633 1.9243164 5.48633h40.0117189 109.202151c2.74804 0 2.21191-2.93653 2.21191-4.91602 0-4.94824 0-9.89648 0-14.8457 0-18.33399 0-36.66992 0-55.00488 0-42.56055 0-85.121586 0-127.682621 0-6.0625 0-12.125976 0-18.188965 0-2.042968.46777-4.718261 0-6.7260738 0-2.9780273-8.45703-1.7314453-10.12402-1.7314453-7.97071 0-15.94043 0-23.91016 0-38.349608 0-76.699705 0-115.049315 0-.921875 0-1.8437497 0-2.7656247 0"
          fill="none"
          stroke="currentColor"
          strokeWidth="1.287663"
        />
      </g>
    </svg>
  );
};

const Card = (props) => {
  let style = {};
  if (props.selectedIndex === props.index) {
    style = { transform: `rotateY(180deg) scale(2)`, zIndex: 1 };
  }

  return (
    <div
      className={styles.face}
      onClick={(e) => {
        e.preventDefault();
        e.stopPropagation();

        if (!props.onClick) {
          return;
        }

        props.onClick();
      }}
      style={style}
    >
      <div className={styles.back}>
        <CardBack width="100%" />
      </div>
      <div className={styles.front} style={{ backgroundImage: `url("${props.src}")` }}></div>
    </div>
  );
};

const CardHandLayout = (props) => {
  const [selectedIndex, setSelectedIndex] = React.useState<number>(-1);

  const { cards } = props;

  const indexMod = (index) => {
    if (index < Math.floor(cards.length / 2)) {
      return index + 1;
    } else {
      return cards.length - index;
    }
  };

  React.useEffect(() => {
    if (props.expanded) {
      return;
    }

    setSelectedIndex(-1);
  }, [props.expanded]);

  let rootStyle = {};
  if (!props.expanded) {
    rootStyle = { paddingLeft: `${cards.length * 96}px` };
  } else {
    rootStyle = { paddingLeft: `0px` };
  }

  return (
    <div className={styles.cards} style={rootStyle}>
      {cards.map((data, index) => {
        let style = {};

        if (props.expanded) {
          const mod = indexMod(index);
          const angle = (index - Math.floor(cards.length / 2)) * 8;
          const translationY = -Math.sin((angle * Math.PI) / 180) * 122 * indexMod(index);
          style = {
            transform: `rotate(${angle}deg) translateY(${translationY}px)`,
          };

          if (index === selectedIndex) {
            style = { transform: ``, zIndex: 1 };
          }
        } else {
          const translationX = -104 * index;
          style = { transform: `translateX(${translationX}px)` };
        }

        return (
          <div key={index} className={styles.card} style={style}>
            <Card
              index={index}
              selectedIndex={selectedIndex}
              expanded={props.expanded}
              onClick={
                props.expanded
                  ? () => setSelectedIndex(index)
                  : () => {
                      props.onExpand();
                      setSelectedIndex(index);
                    }
              }
              src={data}
            />
          </div>
        );
      })}
    </div>
  );
};

export default CardHandLayout;
