/*
 * Use of this source code is governed by the MIT license that can be
 * found in the LICENSE file.
 */

package org.rust.toml.completion

import com.intellij.codeInsight.completion.CompletionContributor
import com.intellij.codeInsight.completion.CompletionType.BASIC
import org.rust.toml.CargoTomlPsiPattern.inDependencyInlineTableVersion
import org.rust.toml.CargoTomlPsiPattern.inDependencyKeyValue
import org.rust.toml.CargoTomlPsiPattern.inDependencyPackageFeatureArray
import org.rust.toml.CargoTomlPsiPattern.inDependencyTableKey
import org.rust.toml.CargoTomlPsiPattern.inFeatureDependencyArray
import org.rust.toml.CargoTomlPsiPattern.inKey
import org.rust.toml.CargoTomlPsiPattern.inSpecificDependencyHeaderKey
import org.rust.toml.CargoTomlPsiPattern.inSpecificDependencyKeyValue
import org.rust.toml.CargoTomlPsiPattern.inValueWithKey
import org.rust.toml.tomlPluginIsAbiCompatible

class CargoTomlCompletionContributor : CompletionContributor() {
    init {
        if (tomlPluginIsAbiCompatible()) {
            extend(BASIC, inKey, CargoTomlKeysCompletionProvider())
            extend(BASIC, inValueWithKey("edition"), CargoTomlKnownValuesCompletionProvider(listOf("2015", "2018", "2021")))
            extend(BASIC, inValueWithKey("license"), CargoTomlKnownValuesCompletionProvider(popularSpdxLicenses))
            extend(BASIC, inFeatureDependencyArray, CargoTomlFeatureDependencyCompletionProvider())
            extend(BASIC, inDependencyPackageFeatureArray, CargoTomlDependencyFeaturesCompletionProvider())
            extend(BASIC, inDependencyTableKey, CargoTomlDependencyKeysCompletionProvider())

            // Available using both Crates.io API & Crates Local Index
            extend(BASIC, inDependencyKeyValue, CargoTomlDependencyCompletionProvider())
            extend(BASIC, inSpecificDependencyHeaderKey, CargoTomlSpecificDependencyHeaderCompletionProvider())
            extend(BASIC, inSpecificDependencyKeyValue, CargoTomlSpecificDependencyVersionCompletionProvider())

            // Available only using Crates Local Index
            extend(BASIC, inDependencyInlineTableVersion, LocalCargoTomlInlineTableVersionCompletionProvider())
        }
    }
}

private val popularSpdxLicenses = listOf(
    "AGPL-3",
    "Apache-2.0",
    "BSD-2",
    "BSD-3",
    "BSL-1",
    "CC0-1",
    "EPL-2",
    "GPL-2",
    "GPL-3",
    "LGPL-2",
    "MIT",
    "MPL-2"
)
