# Fake Grammar-Kit dependencies

We use [Grammar-Kit] to generate Rust parser and PSI classes from BNF-like grammar.
Grammar-Kit decides on how to generate PSI based not only on a `.bnf` grammar file, but also on contents of
Java/Kotlin files referenced in that `.bnf` file. In particular: 

1. Grammar-Kit takes into account super classes of a java class referenced using `expends` property in a BNF 
 rule when deciding on how to generate PSI methods for that BNF rule. If Grammar-Kit finds `CompositePsiElement`
 class in super classes, it uses "mixed AST" style, where single class represents both PSI and AST elements
 (so additional AST node is not allocated). Otherwise, it uses split PSI/AST style where PSI elements wrap 
 AST elements (or stubs).
2. Grammar-Kit takes into account constructor arguments of a java class referenced using `mixin` or `expends`
 property in a BNF rule when deciding on how to generate PSI methods for that BNF rule. In "mixed AST" case,
 Grammar-Kit just mirrors constructors of the `mixin`/`expends` class.

Important point is that Grammar-Kit analyses *compiled* java classes, i.e. classes referenced in a `.bnf` file
have to be compiled prior to Grammar-Kit invocation. Unfortunately, we can't satisfy this requirement because 
our fundamental PSI classes are heavily depends on PSI classes generated by Grammar-Kit, so this is a kind of
chicken-and-egg problem.

This module solved the problem by introducing essential set of **FAKE** PSI classes containing only stuff needed
to Grammar-Kit. These classes are not included to the final plugin `.jar` file and furthermore are not used anywhere 
except in Grammar-Kit.

These hacks will likely become unneeded when [this PR][#316] to Grammar-Kit will be accepted.

[Grammar-Kit]: https://github.com/JetBrains/Grammar-Kit
[#316]: https://github.com/JetBrains/Grammar-Kit/pull/316
