Contributing to Frosted
-----------------

Frosted is a community project with no strong copyright enforcement.
You are free to contribute to the official repository, hosted at 
github.com/insane-adding-machines/frosted.

By contributing to Frosted, you agree that the code you write will be
published and distributed under the term of GNU General Public License,
as specified in LICENSE.

We don't ask to yield any rights to the code you write, except those 
required by the LICENSE.

In order to contribute, fork the project on github, commit in your local repository, submit a PR.
Regular contributors that show interest for the projects are added to the community.

Being part of the community means accepting the Code of Conduct.

Coding style
-----------------

- Indentation is 4 spaces (no tabs)
- no spaces inside parenthesis
- spaces around binary operators
- no trailing spaces
- we place a space after every keyword
- constants and macros are capitalized
- the asterisk in a pointer declaration is adjacent to the symbol name, not its type
- function opening brace is on the next line
- inner blocks opening brace is on the same line
- function/variable case default is `snake_case` and not `CamelCase`
- no typedefs (exceptions must be discussed and approved by the community)
- write short functions with meaningful names
- centralized return point for functions is encouraged. The use of keyword `goto` is allowed to create a centralized return point.

More in general, we appreciate if you follow the same style as the existing kernel code.

