var path = require('path')

/**
 * ResolverPlugin
 *
 * @param plugins
 * @param types
 * @constructor
 */

function ResolverPlugin(plugins, types) {
  if(!Array.isArray(plugins)) plugins = [plugins]
  if(!types) types = ["normal"]
  else if(!Array.isArray(types)) types = [types]

  this.plugins = plugins
  this.types = types
}

module.exports.ResolverPlugin = ResolverPlugin


/**
 * SimpleResolver for testing
 *
 * @param file
 * @param source
 * @constructor
 */

function SimpleResolver(file, source) {
  this.file = file
  this.source = source
}

SimpleResolver.prototype.apply = function (resolver) {

  var file = this.file
  var source = this.source

  resolver.plugin('directory', function (request, done) {

    var absolutePath = path.resolve(request.path, request.request)

    if (absolutePath === source) {
      resolver.doResolve('file', { request: file }, function (error, result) {
        return done(undefined, result || undefined)
      })
    }

    return done()

  })

}

module.exports.SimpleResolver = SimpleResolver
