import { IconType } from '@types';
import { IconSizes } from 'config';

export const ReactIcon = ({ size = 'lg' }: IconType) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={IconSizes[size]} height={IconSizes[size]} fill="none">
    <g clipPath="url(#a)" stroke="currentColor" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round">
      <path d="M6.306 9.21094C3.704 9.93394 2 11.1369 2 12.4999c0 2.21 4.477 4 10 4 .773 0 1.526-.035 2.248-.102" />
      <path d="M17.692 15.789C20.295 15.067 22 13.863 22 12.5c0-2.21-4.477-4-10-4-.773 0-1.526.035-2.25.102" />
      <path d="M6.30633 15.787c-.676 2.615-.485 4.693.695 5.373 1.913 1.105 5.70297-1.877 8.46397-6.66.387-.67.733-1.339 1.036-2M17.695 9.21544c.677-2.616.487-4.696-.694-5.376-1.913-1.105-5.703 1.877-8.464 6.65996-.387.67-.733 1.34-1.037 2" />
      <path d="M12.0013 5.92358c-1.925-1.892-3.81997-2.766-4.99997-2.084-1.913 1.104-1.226 5.877 1.536 10.66002.386.67.793 1.304 1.212 1.896M12 19.0745c1.926 1.893 3.821 2.768 5 2.086 1.913-1.104 1.226-5.877-1.536-10.66-.375-.64998-.78-1.28298-1.212-1.89698M11.4982 13.3666c.1137.0667.2396.1102.3702.1281.1307.0179.2636.0097.3911-.024s.2471-.0923.3518-.1724c.1048-.0801.1927-.1802.2586-.2944.066-.1142.1087-.2403.1257-.3711.017-.1308.0079-.2636-.0266-.3909-.0346-.1273-.094-.2465-.1748-.3507-.0808-.1042-.1814-.1914-.296-.2566-.2296-.1305-.5015-.1649-.7563-.0958-.2548.0692-.472.2364-.604.4651-.132.2287-.1683.5003-.1008.7556.0675.2553.2333.4735.4611.6071Z" />
    </g>
    <defs>
      <clipPath id="a">
        <path fill="currentColor" transform="translate(0 .5)" d="M0 0h24v24H0z" />
      </clipPath>
    </defs>
  </svg>
);
