import { IconType } from '@types';
import { IconSizes } from 'config';

export const CrossCircle = ({ size = 'md', color, style }: IconType) => {
  return (
    <svg
      style={style}
      xmlns="http://www.w3.org/2000/svg"
      width={IconSizes[size]}
      height={IconSizes[size]}
      color={color}
      viewBox="0 0 24 25"
      fill="none"
    >
      <g clipPath="url(#clip0_4893_2683)">
        <path
          d="M17 3.83989C18.5083 4.71075 19.7629 5.96042 20.6398 7.46519C21.5167 8.96997 21.9854 10.6777 21.9994 12.4192C22.0135 14.1608 21.5725 15.8758 20.72 17.3946C19.8676 18.9133 18.6332 20.1831 17.1392 21.0782C15.6452 21.9733 13.9434 22.4627 12.2021 22.498C10.4608 22.5332 8.74055 22.1131 7.21155 21.2791C5.68256 20.4452 4.39787 19.2264 3.48467 17.7434C2.57146 16.2604 2.06141 14.5646 2.005 12.8239L2 12.4999L2.005 12.1759C2.061 10.4489 2.56355 8.76585 3.46364 7.29089C4.36373 5.81592 5.63065 4.59934 7.14089 3.75977C8.65113 2.92021 10.3531 2.48629 12.081 2.50033C13.8089 2.51437 15.5036 2.97589 17 3.83989ZM10.511 9.63989C10.3015 9.51517 10.0536 9.4713 9.81401 9.51652C9.57441 9.56175 9.35959 9.69296 9.20995 9.88547C9.06031 10.078 8.98617 10.3185 9.00146 10.5619C9.01675 10.8052 9.12043 11.0346 9.293 11.2069L10.585 12.4999L9.293 13.7929L9.21 13.8869C9.05459 14.0879 8.98151 14.3405 9.0056 14.5934C9.02969 14.8463 9.14916 15.0806 9.33972 15.2486C9.53029 15.4167 9.77767 15.5059 10.0316 15.4981C10.2856 15.4904 10.527 15.3862 10.707 15.2069L12 13.9149L13.293 15.2069L13.387 15.2899C13.588 15.4453 13.8406 15.5184 14.0935 15.4943C14.3464 15.4702 14.5807 15.3507 14.7488 15.1602C14.9168 14.9696 15.006 14.7222 14.9982 14.4683C14.9905 14.2143 14.8863 13.9728 14.707 13.7929L13.415 12.4999L14.707 11.2069L14.79 11.1129C14.9454 10.9119 15.0185 10.6593 14.9944 10.4064C14.9703 10.1534 14.8508 9.91917 14.6603 9.75114C14.4697 9.58311 14.2223 9.49391 13.9684 9.50166C13.7144 9.50942 13.473 9.61354 13.293 9.79289L12 11.0849L10.707 9.79289L10.613 9.70989L10.511 9.63989Z"
          fill="#E74644"
        />
      </g>
      <defs>
        <clipPath id="clip0_4893_2683">
          <rect width="24" height="24" fill="white" transform="translate(0 0.5)" />
        </clipPath>
      </defs>
    </svg>
  );
};
