import { IconType } from '@types';
import { IconSizes } from 'config';

export const CrossIcon = ({ size = 'sm', color }: IconType) => {
  return (
    <svg
      color={color}
      width={IconSizes[size]}
      height={IconSizes[size]}
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 26 26"
      fill="currentColor"
    >
      <path
        d="M12.0104 2.01099C12.7882 2.01103 13.5393 2.29436 14.1234 2.80799L14.2774 2.95299L14.9754 3.65099C15.167 3.8413 15.4171 3.96144 15.6854 3.99199L15.8204 3.99999H16.8204C17.6376 3.99994 18.4239 4.31256 19.018 4.87373C19.6121 5.4349 19.9689 6.20209 20.0154 7.01799L20.0204 7.19999V8.19999C20.0204 8.46999 20.1124 8.73299 20.2784 8.94299L20.3684 9.04299L21.0654 9.74099C21.6431 10.3154 21.98 11.0886 22.0073 11.9029C22.0346 12.7171 21.7503 13.5111 21.2124 14.123L21.0674 14.277L20.3694 14.975C20.1791 15.1665 20.059 15.4167 20.0284 15.685L20.0204 15.82V16.82C20.0205 17.6372 19.7078 18.4235 19.1467 19.0176C18.5855 19.6116 17.8183 19.9685 17.0024 20.015L16.8204 20.02H15.8204C15.5508 20.0201 15.2891 20.111 15.0774 20.278L14.9774 20.368L14.2794 21.065C13.705 21.6427 12.9318 21.9796 12.1175 22.0069C11.3033 22.0342 10.5093 21.7499 9.89741 21.212L9.74341 21.067L9.04541 20.369C8.85385 20.1787 8.6037 20.0585 8.33541 20.028L8.20041 20.02H7.20041C6.38319 20.02 5.59693 19.7074 5.00284 19.1462C4.40876 18.5851 4.05189 17.8179 4.00541 17.002L4.00041 16.82V15.82C4.00032 15.5504 3.90944 15.2886 3.74241 15.077L3.65241 14.977L2.95541 14.279C2.37769 13.7045 2.04083 12.9314 2.01352 12.1171C1.9862 11.3029 2.27049 10.5089 2.80841 9.89699L2.95341 9.74299L3.65141 9.04499C3.84172 8.85343 3.96187 8.60328 3.99241 8.33499L4.00041 8.19999V7.19999L4.00541 7.01799C4.05006 6.23343 4.38184 5.49274 4.9375 4.93707C5.49316 4.38141 6.23386 4.04964 7.01841 4.00499L7.20041 3.99999H8.20041C8.47003 3.9999 8.73176 3.90901 8.94341 3.74199L9.04341 3.65199L9.74141 2.95499C10.0387 2.65588 10.3923 2.41849 10.7817 2.25649C11.1711 2.09448 11.5887 2.01105 12.0104 2.01099Z"
        fill="#E74644"
      />
      <path
        d="M10.5105 9.13999C10.301 9.01527 10.0531 8.9714 9.81354 9.01662C9.57394 9.06185 9.35912 9.19306 9.20948 9.38557C9.05984 9.57809 8.9857 9.81864 9.00099 10.062C9.01629 10.3053 9.11997 10.5347 9.29253 10.707L10.5845 12L9.29253 13.293L9.20953 13.387C9.05412 13.588 8.98104 13.8406 9.00513 14.0935C9.02923 14.3464 9.14869 14.5807 9.33926 14.7487C9.52982 14.9168 9.7772 15.006 10.0311 14.9982C10.2851 14.9905 10.5266 14.8863 10.7065 14.707L11.9995 13.415L13.2925 14.707L13.3865 14.79C13.5875 14.9454 13.8401 15.0185 14.0931 14.9944C14.346 14.9703 14.5803 14.8508 14.7483 14.6603C14.9163 14.4697 15.0055 14.2223 14.9978 13.9684C14.99 13.7144 14.8859 13.4729 14.7065 13.293L13.4145 12L14.7065 10.707L14.7895 10.613C14.9449 10.412 15.018 10.1594 14.9939 9.90647C14.9698 9.65354 14.8504 9.41927 14.6598 9.25124C14.4692 9.08321 14.2219 8.99401 13.9679 9.00176C13.714 9.00952 13.4725 9.11364 13.2925 9.29299L11.9995 10.585L10.7065 9.29299L10.6125 9.20999L10.5105 9.13999Z"
        fill="#111111"
      />
    </svg>
  );
};
