import { IconType } from '@types';
import { IconSizes } from 'config';

export const CopyIcon = ({ size = 'sm', color, className }: IconType) => {
  return (
    <svg
      width={IconSizes[size]}
      height={IconSizes[size]}
      color={color}
      viewBox="0 0 20 20"
      fill="none"
      className={className}
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M16.9997 0H9.00001C8.20462 0.000837044 7.44207 0.317242 6.87956 0.879558C6.31724 1.44206 6.00082 2.20462 6.00001 3V6.00001H3C2.20462 6.00084 1.44206 6.31725 0.879558 6.87956C0.317229 7.44206 0.000814287 8.20462 0 9.00001V17.0002V17C0.000837044 17.7954 0.317242 18.5579 0.879558 19.1204C1.44206 19.6828 2.20462 19.9992 3 20H11.0002H11C11.7954 19.9992 12.5579 19.6828 13.1204 19.1204C13.6828 18.5579 13.9992 17.7954 14 17V14H17C17.7954 13.9992 18.5579 13.6827 19.1204 13.1204C19.6828 12.5579 19.9992 11.7954 20 11V3.00026C19.9992 2.20488 19.6828 1.44232 19.1204 0.879819C18.5579 0.31749 17.7954 0.00107538 17 0.000261089L16.9997 0ZM12 16.9997C11.9998 17.2649 11.8944 17.5192 11.7069 17.7067C11.5194 17.8942 11.2651 17.9997 10.9999 17.9998H3.00018C2.735 17.9997 2.48071 17.8942 2.29321 17.7067C2.10571 17.5192 2.00024 17.2649 2.00008 16.9997V9.00001C2.00024 8.73483 2.10571 8.48054 2.29321 8.29304C2.48071 8.10554 2.73503 8.00007 3.00018 7.9999H11.0003H11.0002C11.2653 8.00007 11.5196 8.10554 11.7071 8.29304C11.8946 8.48054 12.0001 8.73485 12.0003 9.00001L12 16.9997ZM18 10.9997C17.9999 11.2649 17.8944 11.5192 17.7069 11.7067C17.5194 11.8942 17.2651 11.9997 16.9999 11.9998H13.9999V8.99983C13.9991 8.20444 13.6827 7.44188 13.1204 6.87938C12.5579 6.31706 11.7953 6.00064 10.9999 5.99983H7.9999V2.99982C8.00007 2.73464 8.10554 2.48035 8.29304 2.29285C8.48054 2.10535 8.73485 1.99988 9.00001 1.99972H17.0002H17C17.2652 1.99988 17.5195 2.10535 17.707 2.29285C17.8945 2.48035 17.9999 2.73467 18.0001 2.99982L18 10.9997Z"
        fill="currentColor"
      />
    </svg>
  );
};
