import { IconType } from '@types';
import { IconSizes } from 'config';

export const CalendarIcon = ({ size = 'sm', color }: IconType) => {
  return (
    <svg
      width={IconSizes[size]}
      height={IconSizes[size]}
      color={color}
      viewBox="0 0 17 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M13.3687 1.733H14.2643C15.2463 1.733 16.0424 2.50805 16.0424 3.46076V13.8688C16.0424 14.8232 15.2469 15.5967 14.2643 15.5967H1.77813C0.796077 15.5967 0 14.8217 0 13.8688V3.46076C0 2.50652 0.795532 1.733 1.77813 1.733H2.6737V0.424957C2.6737 0.190286 2.8805 0 3.11942 0C3.36549 0 3.56503 0.186365 3.56503 0.424957V1.733H12.4775V0.424957C12.4775 0.190286 12.6841 0 12.9231 0C13.1692 0 13.3688 0.186365 13.3688 0.424957L13.3687 1.733ZM13.3687 2.59943V3.04093C13.3687 3.27571 13.1619 3.466 12.923 3.466C12.6769 3.466 12.4774 3.27963 12.4774 3.04093V2.59943H3.56497V3.04093C3.56497 3.27571 3.35829 3.466 3.11936 3.466C2.87317 3.466 2.67364 3.27963 2.67364 3.04093V2.59943H1.77807C1.28783 2.59943 0.891128 2.985 0.891128 3.46076V13.8688C0.891128 14.3436 1.28884 14.7303 1.77807 14.7303H14.2642C14.7545 14.7303 15.1512 14.3447 15.1512 13.8688V3.46076C15.1512 2.98609 14.7535 2.59943 14.2642 2.59943H13.3687ZM0.891156 4.33243H15.1511V5.19897H0.891156V4.33243ZM11.5863 7.36935C11.5863 7.12782 11.777 6.93211 12.036 6.93211H12.9189C13.1674 6.93211 13.3688 7.11749 13.3688 7.36935V8.22773C13.3688 8.46925 13.178 8.66497 12.9189 8.66497H12.036C11.7876 8.66497 11.5863 8.47958 11.5863 8.22773V7.36935ZM7.13022 7.36935C7.13022 7.12782 7.32091 6.93211 7.57996 6.93211H8.46286C8.71129 6.93211 8.9126 7.11749 8.9126 7.36935V8.22773C8.9126 8.46925 8.72191 8.66497 8.46286 8.66497H7.57996C7.33153 8.66497 7.13022 8.47958 7.13022 8.22773V7.36935ZM2.67387 7.36935C2.67387 7.12782 2.86467 6.93211 3.12372 6.93211H4.00662C4.25505 6.93211 4.45635 7.11749 4.45635 7.36935V8.22773C4.45635 8.46925 4.26567 8.66497 4.00662 8.66497H3.12372C2.87529 8.66497 2.67387 8.47958 2.67387 8.22773V7.36935ZM2.67387 11.7016C2.67387 11.4601 2.86467 11.2644 3.12372 11.2644H4.00662C4.25505 11.2644 4.45635 11.4498 4.45635 11.7016V12.56C4.45635 12.8015 4.26567 12.9974 4.00662 12.9974H3.12372C2.87529 12.9974 2.67387 12.8119 2.67387 12.56V11.7016ZM7.13022 11.7016C7.13022 11.4601 7.32091 11.2644 7.57996 11.2644H8.46286C8.71129 11.2644 8.9126 11.4498 8.9126 11.7016V12.56C8.9126 12.8015 8.72191 12.9974 8.46286 12.9974H7.57996C7.33153 12.9974 7.13022 12.8119 7.13022 12.56V11.7016ZM11.5863 11.7016C11.5863 11.4601 11.777 11.2644 12.036 11.2644H12.9189C13.1674 11.2644 13.3688 11.4498 13.3688 11.7016V12.56C13.3688 12.8015 13.178 12.9974 12.9189 12.9974H12.036C11.7876 12.9974 11.5863 12.8119 11.5863 12.56V11.7016Z"
        fill="currentColor"
        fillOpacity="0.5"
      />
    </svg>
  );
};
