<?php

declare(strict_types=1);

namespace Imi\Util;

use Imi\App;
use Imi\Bean\BeanFactory;
use Imi\Bean\ReflectionContainer;

class DelayBeanCallable
{
    private ?bool $returnsReference = null;

    private ?object $instance = null;

    public function __construct(private readonly string $beanName, private readonly string $methodName, private readonly array $constructArgs = [])
    {
    }

    public function getBeanName(): string
    {
        return $this->beanName;
    }

    public function getMethodName(): string
    {
        return $this->methodName;
    }

    public function getInstance(): object
    {
        return $this->instance ??= App::getBean($this->beanName, ...$this->constructArgs);
    }

    public function returnsReference(): bool
    {
        return $this->returnsReference ??= ReflectionContainer::getMethodReflection(BeanFactory::getObjectClass($this->getInstance()), $this->methodName)->returnsReference();
    }

    public function &__invoke(mixed ...$args): mixed
    {
        if ($this->returnsReference())
        {
            return $this->getInstance()->{$this->methodName}(...$args);
        }
        else
        {
            $result = $this->getInstance()->{$this->methodName}(...$args);

            return $result;
        }
    }

    public function __serialize(): array
    {
        return [
            'beanName'         => $this->beanName,
            'methodName'       => $this->methodName,
            'constructArgs'    => $this->constructArgs,
        ];
    }

    public function __unserialize(array $data): void
    {
        ['beanName' => $this->beanName, 'methodName' => $this->methodName, 'constructArgs' => $this->constructArgs] = $data;
    }
}
