<?php

declare(strict_types=1);

namespace Imi\Server\UdpServer;

use Imi\RequestContext;
use Imi\Server\UdpServer\Message\IPacketData;

class PacketHandler implements IPacketHandler
{
    /**
     * 当前执行第几个.
     */
    protected int $index = 0;

    /**
     * 构造方法.
     */
    public function __construct(
        /**
         * @var array<string|object> 中间件数组
         */
        protected array $middlewares
    ) {
    }

    /**
     * {@inheritDoc}
     */
    public function handle(IPacketData $data): mixed
    {
        $middlewares = &$this->middlewares;
        $index = &$this->index;
        if (isset($middlewares[$index]))
        {
            $middleware = $middlewares[$index++];
            if (\is_object($middleware))
            {
                $requestHandler = $middleware;
            }
            else
            {
                $requestHandler = RequestContext::getServerBean($middleware);
            }

            return $requestHandler->process($data, $this);
        }
        else
        {
            return null;
        }
    }
}
