<?php

declare(strict_types=1);

namespace Imi\Server\Http\Message\Proxy;

use Imi\RequestContextProxy\BaseRequestContextProxy;

/**
 * @method        \Imi\Server\Http\Message\Contract\IHttpResponse                     redirect(string $url, int $status = 302)
 * @method static \Imi\Server\Http\Message\Contract\IHttpResponse                     redirect(string $url, int $status = 302)
 * @method        \Imi\Server\Http\Message\Contract\IHttpResponse                     send()
 * @method static \Imi\Server\Http\Message\Contract\IHttpResponse                     send()
 * @method        \Imi\Server\Http\Message\Contract\IHttpResponse                     sendFile(string $filename, ?string $contentType = NULL, ?string $outputFileName = NULL, int $offset = 0, int $length = 0)
 * @method static \Imi\Server\Http\Message\Contract\IHttpResponse                     sendFile(string $filename, ?string $contentType = NULL, ?string $outputFileName = NULL, int $offset = 0, int $length = 0)
 * @method        bool                                                                isHeaderWritable()
 * @method static bool                                                                isHeaderWritable()
 * @method        bool                                                                isBodyWritable()
 * @method static bool                                                                isBodyWritable()
 * @method        \Imi\Server\Http\Message\Contract\IHttpResponse                     withResponseBodyEmitter(?\Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter $responseBodyEmitter)
 * @method static \Imi\Server\Http\Message\Contract\IHttpResponse                     withResponseBodyEmitter(?\Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter $responseBodyEmitter)
 * @method        \Imi\Server\Http\Message\Contract\IHttpResponse                     setResponseBodyEmitter(?\Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter $responseBodyEmitter)
 * @method static \Imi\Server\Http\Message\Contract\IHttpResponse                     setResponseBodyEmitter(?\Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter $responseBodyEmitter)
 * @method        \Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter|null getResponseBodyEmitter()
 * @method static \Imi\Server\Http\Message\Emitter\Contract\IResponseBodyEmitter|null getResponseBodyEmitter()
 * @method        \Imi\Util\Http\Contract\IResponse                                   setStatus(int $code, string $reasonPhrase = '')
 * @method static \Imi\Util\Http\Contract\IResponse                                   setStatus(int $code, string $reasonPhrase = '')
 * @method        \Imi\Util\Http\Contract\IResponse                                   withCookie(string $key, string $value, int $expire = 0, string $path = '/', string $domain = '', bool $secure = false, bool $httponly = false)
 * @method static \Imi\Util\Http\Contract\IResponse                                   withCookie(string $key, string $value, int $expire = 0, string $path = '/', string $domain = '', bool $secure = false, bool $httponly = false)
 * @method        \Imi\Util\Http\Contract\IResponse                                   setCookie(string $key, string $value, int $expire = 0, string $path = '/', string $domain = '', bool $secure = false, bool $httponly = false)
 * @method static \Imi\Util\Http\Contract\IResponse                                   setCookie(string $key, string $value, int $expire = 0, string $path = '/', string $domain = '', bool $secure = false, bool $httponly = false)
 * @method        array                                                               getCookieParams()
 * @method static array                                                               getCookieParams()
 * @method        array|null                                                          getCookie(string $name, ?array $default = NULL)
 * @method static array|null                                                          getCookie(string $name, ?array $default = NULL)
 * @method        array                                                               getTrailers()
 * @method static array                                                               getTrailers()
 * @method        bool                                                                hasTrailer(string $name)
 * @method static bool                                                                hasTrailer(string $name)
 * @method        string|null                                                         getTrailer(string $name)
 * @method static string|null                                                         getTrailer(string $name)
 * @method        \Imi\Util\Http\Contract\IResponse                                   withTrailer(string $name, string $value)
 * @method static \Imi\Util\Http\Contract\IResponse                                   withTrailer(string $name, string $value)
 * @method        \Imi\Util\Http\Contract\IResponse                                   setTrailer(string $name, string $value)
 * @method static \Imi\Util\Http\Contract\IResponse                                   setTrailer(string $name, string $value)
 * @method        int                                                                 getStatusCode()
 * @method static int                                                                 getStatusCode()
 * @method        \Psr\Http\Message\ResponseInterface                                 withStatus(int $code, string $reasonPhrase = '')
 * @method static \Psr\Http\Message\ResponseInterface                                 withStatus(int $code, string $reasonPhrase = '')
 * @method        string                                                              getReasonPhrase()
 * @method static string                                                              getReasonPhrase()
 * @method        string                                                              getProtocolVersion()
 * @method static string                                                              getProtocolVersion()
 * @method        \Psr\Http\Message\MessageInterface                                  withProtocolVersion(string $version)
 * @method static \Psr\Http\Message\MessageInterface                                  withProtocolVersion(string $version)
 * @method        string[][]                                                          getHeaders()
 * @method static string[][]                                                          getHeaders()
 * @method        bool                                                                hasHeader(string $name)
 * @method static bool                                                                hasHeader(string $name)
 * @method        string[]                                                            getHeader(string $name)
 * @method static string[]                                                            getHeader(string $name)
 * @method        string                                                              getHeaderLine(string $name)
 * @method static string                                                              getHeaderLine(string $name)
 * @method        \Psr\Http\Message\MessageInterface                                  withHeader(string $name, $value)
 * @method static \Psr\Http\Message\MessageInterface                                  withHeader(string $name, $value)
 * @method        \Psr\Http\Message\MessageInterface                                  withAddedHeader(string $name, $value)
 * @method static \Psr\Http\Message\MessageInterface                                  withAddedHeader(string $name, $value)
 * @method        \Psr\Http\Message\MessageInterface                                  withoutHeader(string $name)
 * @method static \Psr\Http\Message\MessageInterface                                  withoutHeader(string $name)
 * @method        \Psr\Http\Message\StreamInterface                                   getBody()
 * @method static \Psr\Http\Message\StreamInterface                                   getBody()
 * @method        \Psr\Http\Message\MessageInterface                                  withBody(\Psr\Http\Message\StreamInterface $body)
 * @method static \Psr\Http\Message\MessageInterface                                  withBody(\Psr\Http\Message\StreamInterface $body)
 * @method        \Imi\Util\Http\Contract\IMessage                                    setProtocolVersion(string $version)
 * @method static \Imi\Util\Http\Contract\IMessage                                    setProtocolVersion(string $version)
 * @method        \Imi\Util\Http\Contract\IMessage                                    setHeader(string $name, array|string $value)
 * @method static \Imi\Util\Http\Contract\IMessage                                    setHeader(string $name, array|string $value)
 * @method        \Imi\Util\Http\Contract\IMessage                                    addHeader(string $name, array|string $value)
 * @method static \Imi\Util\Http\Contract\IMessage                                    addHeader(string $name, array|string $value)
 * @method        \Imi\Util\Http\Contract\IMessage                                    removeHeader(string $name)
 * @method static \Imi\Util\Http\Contract\IMessage                                    removeHeader(string $name)
 * @method        \Imi\Util\Http\Contract\IMessage                                    setBody(\Psr\Http\Message\StreamInterface $body)
 * @method static \Imi\Util\Http\Contract\IMessage                                    setBody(\Psr\Http\Message\StreamInterface $body)
 */
#[
    \Imi\RequestContextProxy\Annotation\RequestContextProxy(class: \Imi\Server\Http\Message\Contract\IHttpResponse::class, name: 'response')
]
class ResponseProxy extends BaseRequestContextProxy
{
}
