<?php

declare(strict_types=1);

namespace Imi\Server\Http\Message\Proxy;

use Imi\RequestContextProxy\BaseRequestContextProxy;

/**
 * @method        \Imi\Util\Socket\IPEndPoint              getClientAddress()
 * @method static \Imi\Util\Socket\IPEndPoint              getClientAddress()
 * @method        mixed                                    getServerParam(string $name, mixed $default = NULL)
 * @method static mixed                                    getServerParam(string $name, mixed $default = NULL)
 * @method        string|null                              getCookie(string $name, ?string $default = NULL)
 * @method static string|null                              getCookie(string $name, ?string $default = NULL)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setCookieParams(array $cookies)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setCookieParams(array $cookies)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setQueryParams(array $query)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setQueryParams(array $query)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setUploadedFiles(array $uploadedFiles)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setUploadedFiles(array $uploadedFiles)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setParsedBody(object|array|null $data)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setParsedBody(object|array|null $data)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setAttribute(string $name, mixed $value)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setAttribute(string $name, mixed $value)
 * @method        \Imi\Util\Http\Contract\IServerRequest   removeAttribute(string $name)
 * @method static \Imi\Util\Http\Contract\IServerRequest   removeAttribute(string $name)
 * @method        mixed                                    get(?string $name = NULL, mixed $default = NULL)
 * @method static mixed                                    get(?string $name = NULL, mixed $default = NULL)
 * @method        mixed                                    post(?string $name = NULL, mixed $default = NULL)
 * @method static mixed                                    post(?string $name = NULL, mixed $default = NULL)
 * @method        bool                                     hasGet(string $name)
 * @method static bool                                     hasGet(string $name)
 * @method        bool                                     hasPost(string $name)
 * @method static bool                                     hasPost(string $name)
 * @method        mixed                                    request(?string $name = NULL, mixed $default = NULL)
 * @method static mixed                                    request(?string $name = NULL, mixed $default = NULL)
 * @method        bool                                     hasRequest(string $name)
 * @method static bool                                     hasRequest(string $name)
 * @method        \Imi\Util\Http\Contract\IServerRequest   withGet(array $get)
 * @method static \Imi\Util\Http\Contract\IServerRequest   withGet(array $get)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setGet(array $get)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setGet(array $get)
 * @method        \Imi\Util\Http\Contract\IServerRequest   withPost(mixed $post)
 * @method static \Imi\Util\Http\Contract\IServerRequest   withPost(mixed $post)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setPost(mixed $post)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setPost(mixed $post)
 * @method        \Imi\Util\Http\Contract\IServerRequest   withRequest(array $request)
 * @method static \Imi\Util\Http\Contract\IServerRequest   withRequest(array $request)
 * @method        \Imi\Util\Http\Contract\IServerRequest   setRequest(array $request)
 * @method static \Imi\Util\Http\Contract\IServerRequest   setRequest(array $request)
 * @method        array                                    getServerParams()
 * @method static array                                    getServerParams()
 * @method        array                                    getCookieParams()
 * @method static array                                    getCookieParams()
 * @method        \Psr\Http\Message\ServerRequestInterface withCookieParams(array $cookies)
 * @method static \Psr\Http\Message\ServerRequestInterface withCookieParams(array $cookies)
 * @method        array                                    getQueryParams()
 * @method static array                                    getQueryParams()
 * @method        \Psr\Http\Message\ServerRequestInterface withQueryParams(array $query)
 * @method static \Psr\Http\Message\ServerRequestInterface withQueryParams(array $query)
 * @method        array                                    getUploadedFiles()
 * @method static array                                    getUploadedFiles()
 * @method        \Psr\Http\Message\ServerRequestInterface withUploadedFiles(array $uploadedFiles)
 * @method static \Psr\Http\Message\ServerRequestInterface withUploadedFiles(array $uploadedFiles)
 * @method        array|object|null                        getParsedBody()
 * @method static null|array|object                        getParsedBody()
 * @method        \Psr\Http\Message\ServerRequestInterface withParsedBody($data)
 * @method static \Psr\Http\Message\ServerRequestInterface withParsedBody($data)
 * @method        array                                    getAttributes()
 * @method static array                                    getAttributes()
 * @method        mixed                                    getAttribute(string $name, $default = NULL)
 * @method static mixed                                    getAttribute(string $name, $default = NULL)
 * @method        \Psr\Http\Message\ServerRequestInterface withAttribute(string $name, $value)
 * @method static \Psr\Http\Message\ServerRequestInterface withAttribute(string $name, $value)
 * @method        \Psr\Http\Message\ServerRequestInterface withoutAttribute(string $name)
 * @method static \Psr\Http\Message\ServerRequestInterface withoutAttribute(string $name)
 * @method        string                                   getRequestTarget()
 * @method static string                                   getRequestTarget()
 * @method        \Psr\Http\Message\RequestInterface       withRequestTarget(string $requestTarget)
 * @method static \Psr\Http\Message\RequestInterface       withRequestTarget(string $requestTarget)
 * @method        string                                   getMethod()
 * @method static string                                   getMethod()
 * @method        \Psr\Http\Message\RequestInterface       withMethod(string $method)
 * @method static \Psr\Http\Message\RequestInterface       withMethod(string $method)
 * @method        \Psr\Http\Message\UriInterface           getUri()
 * @method static \Psr\Http\Message\UriInterface           getUri()
 * @method        \Psr\Http\Message\RequestInterface       withUri(\Psr\Http\Message\UriInterface $uri, bool $preserveHost = false)
 * @method static \Psr\Http\Message\RequestInterface       withUri(\Psr\Http\Message\UriInterface $uri, bool $preserveHost = false)
 * @method        string                                   getProtocolVersion()
 * @method static string                                   getProtocolVersion()
 * @method        \Psr\Http\Message\MessageInterface       withProtocolVersion(string $version)
 * @method static \Psr\Http\Message\MessageInterface       withProtocolVersion(string $version)
 * @method        string[][]                               getHeaders()
 * @method static string[][]                               getHeaders()
 * @method        bool                                     hasHeader(string $name)
 * @method static bool                                     hasHeader(string $name)
 * @method        string[]                                 getHeader(string $name)
 * @method static string[]                                 getHeader(string $name)
 * @method        string                                   getHeaderLine(string $name)
 * @method static string                                   getHeaderLine(string $name)
 * @method        \Psr\Http\Message\MessageInterface       withHeader(string $name, $value)
 * @method static \Psr\Http\Message\MessageInterface       withHeader(string $name, $value)
 * @method        \Psr\Http\Message\MessageInterface       withAddedHeader(string $name, $value)
 * @method static \Psr\Http\Message\MessageInterface       withAddedHeader(string $name, $value)
 * @method        \Psr\Http\Message\MessageInterface       withoutHeader(string $name)
 * @method static \Psr\Http\Message\MessageInterface       withoutHeader(string $name)
 * @method        \Psr\Http\Message\StreamInterface        getBody()
 * @method static \Psr\Http\Message\StreamInterface        getBody()
 * @method        \Psr\Http\Message\MessageInterface       withBody(\Psr\Http\Message\StreamInterface $body)
 * @method static \Psr\Http\Message\MessageInterface       withBody(\Psr\Http\Message\StreamInterface $body)
 * @method        \Imi\Util\Http\Contract\IRequest         setRequestTarget(string $requestTarget)
 * @method static \Imi\Util\Http\Contract\IRequest         setRequestTarget(string $requestTarget)
 * @method        \Imi\Util\Http\Contract\IRequest         setMethod(string $method)
 * @method static \Imi\Util\Http\Contract\IRequest         setMethod(string $method)
 * @method        \Imi\Util\Http\Contract\IRequest         setUri(\Psr\Http\Message\UriInterface $uri, bool $preserveHost = false)
 * @method static \Imi\Util\Http\Contract\IRequest         setUri(\Psr\Http\Message\UriInterface $uri, bool $preserveHost = false)
 * @method        \Psr\Http\Message\UriInterface           getAppUri(?string $serverName = NULL)
 * @method static \Psr\Http\Message\UriInterface           getAppUri(?string $serverName = NULL)
 */
#[
    \Imi\RequestContextProxy\Annotation\RequestContextProxy(class: \Imi\Server\Http\Message\Contract\IHttpRequest::class, name: 'request')
]
class RequestProxy extends BaseRequestContextProxy
{
}
