<?php

declare(strict_types=1);

namespace Imi\Server\Contract;

use Imi\Bean\Container;
use Imi\Event\IEvent;
use Imi\Util\Socket\IPEndPoint;

/**
 * 服务器接口.
 */
interface IServer extends IEvent
{
    /**
     * 获取服务器名称.
     */
    public function getName(): string;

    /**
     * 获取协议名称.
     */
    public function getProtocol(): string;

    /**
     * 获取配置信息.
     */
    public function getConfig(): array;

    /**
     * 获取容器对象
     */
    public function getContainer(): Container;

    /**
     * 获取Bean对象
     *
     * @template T
     *
     * @param class-string<T> $name
     *
     * @return T
     */
    public function getBean(string $name, mixed ...$params): mixed;

    /**
     * 是否为长连接服务
     */
    public function isLongConnection(): bool;

    /**
     * 是否支持 SSL.
     */
    public function isSSL(): bool;

    /**
     * 开启服务
     */
    public function start(): void;

    /**
     * 终止服务
     */
    public function shutdown(): void;

    /**
     * 重载服务
     */
    public function reload(): void;

    /**
     * 调用服务器方法.
     */
    public function callServerMethod(string $methodName, mixed ...$args): mixed;

    /**
     * 获取客户端地址
     */
    public function getClientAddress(int|string $clientId): IPEndPoint;
}
