<?php

declare(strict_types=1);

namespace Imi\Event;

/**
 * 类事件管理器.
 */
class ClassEventManager
{
    use \Imi\Util\Traits\TStaticClass;

    private static array $map = [];

    public static function getMap(): array
    {
        return self::$map;
    }

    public static function setMap(array $map): void
    {
        self::$map = $map;
    }

    /**
     * 增加映射关系.
     */
    public static function add(string $className, string $eventName, string $listenerClass, int $priority): void
    {
        self::$map[$className][$eventName][$listenerClass] = [
            'priority'  => $priority,
        ];
    }

    /**
     * 获取对象事件定义.
     */
    public static function getByObjectEvent(object $object, string $eventName): array
    {
        $options = [];
        foreach (self::$map as $className => $option)
        {
            if (isset($option[$eventName]) && $object instanceof $className)
            {
                $options[] = $option[$eventName];
            }
        }

        if (isset($options[1]))
        {
            return array_merge(...$options);
        }
        if ($options)
        {
            return $options[0];
        }

        return [];
    }

    public static function getObjectEvents(object $object): array
    {
        $result = [];
        foreach (self::$map as $className => $classEvents)
        {
            if ($object instanceof $className)
            {
                $result[] = $classEvents;
            }
        }

        return $result;
    }
}
