<?php

declare(strict_types=1);

namespace Imi\Core\Component;

use Imi\Main\Helper;

class ComponentManager
{
    use \Imi\Util\Traits\TStaticClass;

    private static array $components = [];

    public static function addComponent(string $name, string $namespace): void
    {
        self::$components[$name] = $namespace;
        Helper::getMain($namespace, $name);
    }

    public static function getComponents(): array
    {
        return self::$components;
    }

    public static function setComponents(array $components): void
    {
        self::$components = $components;
        foreach ($components as $name => $namespace)
        {
            Helper::getMain($namespace, $name);
        }
    }

    public static function has(string $name): bool
    {
        return isset(self::$components[$name]);
    }
}
