<?php

declare(strict_types=1);

namespace Imi\Cache\Annotation;

use Imi\Bean\Annotation\Base;

/**
 * 缓存注解.
 *
 * 方法体执行后，将返回值存入缓存
 */
#[\Attribute(\Attribute::TARGET_METHOD)]
class CachePut extends Base
{
    public function __construct(
        /**
         * 缓存器名称；为null则使用默认缓存器.
         */
        public ?string $name = null,
        /**
         * 缓存键名；支持{id}、{data.name}形式，代入参数；支持{:args}代入所有方法参数的 hash 值；如果为空，则使用类名+方法名+全部参数，序列化后hash.
         */
        public string $key = '',
        /**
         * 写入缓存的值；默认为null时，返回值作为缓存的值；如果为字符串时（如：a.b），则将返回值作为数组或对象，取value->a->b下的值
         */
        public ?string $value = null,
        /**
         * 缓存超时时间，单位：秒.
         */
        public ?int $ttl = null,
        /**
         * 可以指定 hash 方法，默认为：md5.
         */
        public string $hashMethod = 'md5'
    ) {
    }
}
