---
title: سفارشی‌سازی هگزترا
linkTitle: سفارشی‌سازی
---

هگزترا برخی از گزینه‌های سفارشی‌سازی پیش‌فرض را در پرونده `hugo.yaml` برای پیکربندی تم ارائه می‌کند.
 این صفحه گزینه‌های موجود و نحوه سفارشی‌سازی بیشتر تم را توضیح می‌دهد.

<!--more-->

## CSS سفارشی

برای افزودن CSS سفارشی، باید یک پرونده `assets/css/custom.css` در سایت خود ایجاد کنیم. هگزترا به طور خودکار این پرونده را بارگیری خواهد کرد.

### خانواده فونت

خانواده فونت برای محتوا را می‌توانید با استفاده از این سفارشی کنید:

```css {filename="assets/css/custom.css"}
.content {
  font-family: "Times New Roman", Times, serif;
}
```

### عنصر کد درون‌خطی

رنگ متن ترکیب شده با `متن دیگر` را می‌توانید با موارد زیر سفارشی کرد:

```css {filename="assets/css/custom.css"}
.content code:not(.code-block code) {
  color: #c97c2e;
}
```

### رنگ اصلی

رنگ اصلی تم را می‌توانید با تنظیم متغیرهای `--primary-hue` و `--primary-saturation` سفارشی کرد:

```css {filename="assets/css/custom.css"}
:root {
  --primary-hue: 100deg;
  --primary-saturation: 90%;
}
```

### برجسته‌کردن سینتکس

فهرست تم‌های برجسته‌کردن سینتکس در دسترس [گالری Chroma Styles](https://xyproto.github.io/splash/docs/all.html) موجود است. شیوه‌نامه را می‌توانید با استفاده از دستور زیر تولید کرد:

```shell
hugo gen chromastyles --style=github
```

برای نادیده گرفتن طرح زمینه برجسته‌کردن سینتکس پیش‌فرض، می‌توانید استایل‌های تولید شده را به پرونده CSS سفارشی اضافه کنیم.

## اسکریپت‌های سفارشی

با افزودن پرونده زیر می‌توانید اسکریپت‌های سفارشی را برای هر صفحه به انتهای اون اضافه کنید:

```
layouts/partials/custom/head-end.html
```

## طرح‌بندی‌های سفارشی

با ایجاد پرونده‌ای با همین نام در دایرکتوری `layouts` سایت خود، می‌توانید طرح‌های تم را نادیده بگیرید.
 به عنوان مثال، برای لغو طرح‌بندی `single.html` برای مستندات، یک پرونده`layouts/docs/single.html` در سایت خود ایجاد کنید.

برای اطلاعات بیشتر، به [Templateهای هیوگو](https://gohugo.io/templates/) مراجعه کنید.

## سفارشی‌سازی بیشتر

چیزی را که دنبالش بودید پیدا نکردید؟ با خیال راحت [بحثی را باز کنید](https://github.com/imfing/hextra/discussions) یا به موضوع کمک کنید!
