---
linkTitle: "文档"
title: 介绍
---

👋 你好！欢迎来到 Hextra 文档！

<!--more-->

## 什么是 Hextra？

Hextra 是一个现代、快速且功能齐全的 [Hugo][hugo] 主题，基于 [Tailwind CSS][tailwind-css] 构建。专为构建美观的文档、博客和网站而设计，它提供了开箱即用的功能和灵活性，以满足各种需求。

## 特性

- **精美设计** - 灵感源自 Nextra，Hextra 利用 Tailwind CSS 提供现代设计，使您的网站脱颖而出。
- **响应式布局与暗黑模式** - 在所有设备上都能完美呈现，从手机、平板到桌面。暗黑模式也得到支持，以适应不同的光照条件。
- **快速且轻量** - 由 Hugo 驱动，这是一个闪电般快速的静态网站生成器，仅需一个二进制文件，Hextra 保持其占用空间最小。无需 JavaScript 或 Node.js 即可使用。
- **全文搜索** - 内置离线全文搜索，由 FlexSearch 提供支持，无需额外配置。
- **功能齐全** - Markdown、语法高亮、LaTeX 数学公式、图表和 Shortcodes 元素，丰富您的内容。目录、面包屑导航、分页、侧边栏导航等均自动生成。
- **多语言与 SEO 就绪** - 通过 Hugo 的多语言模式轻松创建多语言网站。开箱即用支持 SEO 标签、Open Graph 和 Twitter Cards。

## 有问题或反馈？

{{< callout emoji="❓" >}}
  Hextra 仍在积极开发中。
  有问题或反馈？欢迎[提交问题](https://github.com/imfing/hextra/issues)！
{{< /callout >}}

## 下一步

立即深入以下部分，开始使用：

{{< cards >}}
  {{< card link="getting-started" title="入门指南" icon="document-text" subtitle="学习如何使用 Hextra 创建网站" >}}
{{< /cards >}}

[hugo]: https://gohugo.io/
[flex-search]: https://github.com/nextapps-de/flexsearch
[tailwind-css]: https://tailwindcss.com/
