---
linkTitle: "ドキュメンテーション"
title: イントロダクション
---

👋 こんにちは！Hextraのドキュメンテーションへようこそ！

<!--more-->

## Hextraとは？

Hextraは、[Tailwind CSS][tailwind-css]を使用して構築された、モダンで高速かつ機能豊富な[Hugo][hugo]テーマです。ドキュメンテーション、ブログ、ウェブサイトのための美しいウェブサイトを構築するために設計されており、さまざまな要件に対応するための機能と柔軟性を提供します。

## 特徴

- **美しいデザイン** - Nextraにインスパイアされ、Tailwind CSSを活用してモダンなデザインを提供し、サイトを際立たせます。
- **レスポンシブレイアウトとダークモード** - モバイル、タブレット、デスクトップなど、すべてのデバイスで美しく表示されます。また、ダークモードもサポートされており、さまざまな照明条件に対応します。
- **高速で軽量** - 単一のバイナリファイルに収められた超高速の静的サイトジェネレータであるHugoを採用し、Hextraはそのフットプリントを最小限に抑えています。JavaScriptやNode.jsは必要ありません。
- **全文検索** - FlexSearchを利用したオフライン全文検索が組み込まれており、追加の設定は不要です。
- **機能豊富** - Markdown、シンタックスハイライト、LaTeX数式、ダイアグラム、ショートコード要素など、コンテンツを強化するための機能を提供します。目次、パンくずリスト、ページネーション、サイドバーナビゲーションなどが自動生成されます。
- **多言語対応とSEO対応** - Hugoの多言語モードを使用して、多言語サイトを簡単に作成できます。SEOタグ、Open Graph、Twitter Cardsのサポートも標準で提供されます。

## 質問やフィードバックは？

{{< callout emoji="❓" >}}
  Hextraはまだ活発に開発中です。
  質問やフィードバックがありますか？[issueを開いて](https://github.com/imfing/hextra/issues)お気軽にお知らせください！
{{< /callout >}}

## 次に

以下のセクションに進んで、すぐに始めましょう：

{{< cards >}}
  {{< card link="getting-started" title="はじめに" icon="document-text" subtitle="Hextraを使用してウェブサイトを作成する方法を学ぶ" >}}
{{< /cards >}}

[hugo]: https://gohugo.io/
[flex-search]: https://github.com/nextapps-de/flexsearch
[tailwind-css]: https://tailwindcss.com/