---
title: راهنمای استفاده سینتکس مارک‌داون
date: 2024-03-03
authors:
  - name: imfing
    link: https://github.com/imfing
    image: https://github.com/imfing.png
  - name: Octocat
    link: https://github.com/octocat
    image: https://github.com/octocat.png
  - name: Goudarz Jafari
    link: https://github.com/Goudarz
    image: https://github.com/Goudarz.png
tags:
  - Markdown
  - مثال
  - راهنمای
excludeSearch: true
---

این مقاله نمونه‌ای از سینتکس ابتدایی مارک‌داون را آموزش می‌دهد، که می‌توانید در پرونده‌های محتوای Hugo استفاده کنید.
<!--more-->

## سینتکس ابتدایی

### سرتیترها

```
# سرتیتر ۱
## سرتیتر ۲
### سرتیتر ۳
#### سرتیتر ۴
##### سرتیتر ۵
###### سرتیتر ۶
```

## سرتیتر ۲
### سرتیتر ۳
#### سرتیتر ۴
##### سرتیتر ۵
###### سرتیتر ۶

### تاکید

```text
*این متن کج خواهد بود*
_این متن هم کج خواهد بود_

**این متن توپر خواهد بود**
__این متن هم توپر خواهد بود__

_شما **می‌توانید** آنها را ترکیب کنید_
```

*این متن کج خواهد بود*

_این متن هم کج خواهد بود_

**این متن توپر خواهد بود**

__این متن هم توپر خواهد بود__

_شما **می‌توانید** آنها را ترکیب کنید_

### فهرست‌ها

#### مرتب نشده

```
* مورد ۱
* مورد ۲
  * مورد ۱الف
  * مورد ۲ب
```

* مورد ۱
* مورد ۲
  * مورد ۱الف
  * مورد ۲ب

#### مرتب شده

```
1. مورد ۱
2. مورد ۲
3. مورد ۳
   1. مورد ۳الف
   2. مورد ۳ب
```

1. مورد ۱
2. مورد ۲
3. مورد ۳
   1. مورد ۳الف
   2. مورد ۳ب

### عکس‌ها

```markdown
![آرم گیت‌هاب](https://github.githubassets.com/images/modules/logos_page/GitHub-Mark.png)
```

![آرم گیت‌هاب](https://github.githubassets.com/images/modules/logos_page/GitHub-Mark.png)

### پیوندها

```markdown
[هیوگو](https://gohugo.io)
```

[هیوگو](https://gohugo.io)

### بلوک نقل‌قول

```markdown
همانطور که نیوتن گفت:

> اگر فاصله دورتری را دیده‌ام با ایستادن بر شانه‌های غول‌ها بوده است.
```

> اگر فاصله دورتری را دیده‌ام با ایستادن بر شانه‌های غول‌ها بوده است.

### کد درون‌خطی

```markdown
`کد` درون‌خطی دارای `بک‌-تیک در اطراف` خود است.
```

`کد` درون‌خطی دارای `بک‌-تیک در اطراف` خود است.

### بلوک‌های کد

#### برجسته‌کردن سینتکس(Syntax)

````markdown
```go
func main() {
    fmt.Println("Hello World")
}
```
````

```go
func main() {
    fmt.Println("Hello World")
}
```

### جدول‌ها

```markdown
| عنوان    | توضیحات |
| --------- | ----------- |
| سرتیتر    | عنوان       |
| پاراگراف | متن        |
```

| عنوان    | توضیحات |
| --------- | ----------- |
| سرتیتر    | عنوان       |
| پاراگراف | متن        |

## منابع

- [سینتکس مارک‌داون](https://www.markdownguide.org/basic-syntax/)
- [مارک‌داون هیوگو](https://gohugo.io/content-management/formats/#markdown)
