/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */
/* This file is dual-licensed; see usr/src/contrib/bhyve/LICENSE */

/*
 * Copyright 2014 Pluribus Networks Inc.
 * Copyright 2019 Joyent, Inc.
 * Copyright 2022 Oxide Computer Company
 */

#ifndef _VMM_IMPL_H_
#define	_VMM_IMPL_H_

#include <sys/mutex.h>
#include <sys/queue.h>
#include <sys/varargs.h>
#include <sys/zone.h>
#include <sys/kstat.h>
#include <sys/vmm.h>

#ifdef	_KERNEL

#define	VMM_CTL_MINOR	0

/*
 * Rather than creating whole character devices for devmem mappings, they are
 * available by mmap(2)ing the vmm handle at a specific offset.  These offsets
 * begin just above the maximum allow guest physical address.
 */
#define	VM_DEVMEM_START	(VM_MAXUSER_ADDRESS + 1)

struct vmm_devmem_entry {
	list_node_t	vde_node;
	int		vde_segid;
	char		vde_name[VM_MAX_SEG_NAMELEN];
	size_t		vde_len;
	off_t		vde_off;
};
typedef struct vmm_devmem_entry vmm_devmem_entry_t;

typedef struct vmm_zsd vmm_zsd_t;

enum vmm_softc_state {
	VMM_HELD	= 1,	/* external driver(s) possess hold on the VM */
	VMM_BLOCK_HOOK	= 2,	/* mem hook install temporarily blocked */
	VMM_DESTROY	= 4,	/* VM destruction initiated */
	VMM_IS_OPEN	= 8,	/* VM device is open */
	VMM_AUTODESTROY	= 16,	/* auto-destroy instance on close */
};

struct vmm_softc {
	list_node_t	vmm_node;
	struct vm	*vmm_vm;
	minor_t		vmm_minor;
	char		vmm_name[VM_MAX_NAMELEN];
	list_t		vmm_devmem_list;

	kcondvar_t	vmm_cv;
	list_t		vmm_holds;
	uint_t		vmm_flags;
	uint_t		vmm_destroy_waiters;

	kmutex_t	vmm_lease_lock;
	list_t		vmm_lease_list;
	uint_t		vmm_lease_blocker;
	kcondvar_t	vmm_lease_cv;
	krwlock_t	vmm_rwlock;

	/* For zone specific data */
	list_node_t	vmm_zsd_linkage;
	zone_t		*vmm_zone;
	vmm_zsd_t	*vmm_zsd;

	kstat_t		*vmm_kstat_vm;
	kstat_t		*vmm_kstat_vcpu[VM_MAXCPU];
};
typedef struct vmm_softc vmm_softc_t;

void vmm_zsd_init(void);
void vmm_zsd_fini(void);
int vmm_zsd_add_vm(vmm_softc_t *sc);
void vmm_zsd_rem_vm(vmm_softc_t *sc);
void vmm_zone_vm_destroy(vmm_softc_t *);

#define	VMM_MODULE_NAME	"vmm"

#endif /* _KERNEL */

#endif	/* _VMM_IMPL_H_ */
