/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1983, 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*	Copyright (c) 1983, 1984, 1985, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved	*/

/*
 * University Copyright- Copyright (c) 1982, 1986, 1988
 * The Regents of the University of California
 * All Rights Reserved
 *
 * University Acknowledgment- Portions of this document are derived from
 * software developed by the University of California, Berkeley, and its
 * contributors.
 */

#ifndef _SYS_VM_H
#define	_SYS_VM_H

#include <sys/vmparam.h>
#include <sys/vmsystm.h>
#include <sys/sysmacros.h>

#ifdef	__cplusplus
extern "C" {
#endif

#if defined(_KERNEL)
#include <sys/vnode.h>

void	setupclock(void);
void	pageout(void);
void	cv_signal_pageout(void);
int	queue_io_request(struct vnode *, u_offset_t);

extern	kmutex_t	memavail_lock;
extern	kcondvar_t	memavail_cv;

#define	WAKE_PAGEOUT_SCANNER(tag)			\
	do {						\
		DTRACE_PROBE(schedpage__wake__ ## tag);	\
		cv_broadcast(&proc_pageout->p_cv);	\
	} while (0)

#endif	/* defined(_KERNEL) */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_VM_H */
