/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 * Copyright 2010 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * This file is the sparse registers definition for PMCS firmware forensics
 * The register values are based on 2090556_spc_fw_forensic_appnote_059861.pdf
 */

#ifndef	_PMCS_FWLOG_H
#define	_PMCS_FWLOG_H
#ifdef	__cplusplus
extern "C" {
#endif

#define	PMCS_SPREGS_BLOCK_START			0x0001
#define	PMCS_SPREGS_BLOCK_END			0x0010
#define	PMCS_SSPA_CONTROL_REGISTER_BIT27	0x01000000

typedef struct pmcs_sparse_regs {
	uint32_t shift_addr;
	uint32_t base_addr;
	uint16_t offset_start;
	uint16_t offset_end;
	uint16_t flag;
	const char *desc;
} pmcs_sparse_regs_t;

pmcs_sparse_regs_t hsst_state[] = {
/* follows SM_DEBUG_CNTRL registers */
{0x00030000, 0, 0x30C8, 0x30C8, PMCS_SPREGS_BLOCK_START, "HSST(A) - SM_CNTRL"},
{0x00030000, 0, 0x70C8, 0x70C8, 0, NULL},
{0x00030000, 0, 0xB0C8, 0xB0C8, 0, NULL},
{0x00030000, 0, 0xF0C8, 0xF0C8, 0, NULL},
{0x00040000, 0, 0x30C8, 0x30C8, 0, NULL},
{0x00040000, 0, 0x70C8, 0x70C8, 0, NULL},
{0x00040000, 0, 0xB0C8, 0xB0C8, 0, NULL},
{0x00040000, 0, 0xF0C8, 0xF0C8, 0, NULL},
/* follows SM_STATEMACHE_0 registers */
{0x00030000, 0, 0x30CC, 0x30CC, PMCS_SPREGS_BLOCK_START, "HSST(A) - STATEMA_0"},
{0x00030000, 0, 0x70CC, 0x70CC, 0, NULL},
{0x00030000, 0, 0xB0CC, 0xB0CC, 0, NULL},
{0x00030000, 0, 0xF0CC, 0xF0CC, 0, NULL},
{0x00040000, 0, 0x30CC, 0x30CC, 0, NULL},
{0x00040000, 0, 0x70CC, 0x70CC, 0, NULL},
{0x00040000, 0, 0xB0CC, 0xB0CC, 0, NULL},
{0x00040000, 0, 0xF0CC, 0xF0CC, 0, NULL},
/* follows SM_STATEMACHE_1 registers */
{0x00030000, 0, 0x30D0, 0x30D0, PMCS_SPREGS_BLOCK_START, "HSST(A) - STATEMA_1"},
{0x00030000, 0, 0x70D0, 0x70D0, 0, NULL},
{0x00030000, 0, 0xB0D0, 0xB0D0, 0, NULL},
{0x00030000, 0, 0xF0D0, 0xF0D0, 0, NULL},
{0x00040000, 0, 0x30D0, 0x30D0, 0, NULL},
{0x00040000, 0, 0x70D0, 0x70D0, 0, NULL},
{0x00040000, 0, 0xB0D0, 0xB0D0, 0, NULL},
{0x00040000, 0, 0xF0D0, 0xF0D0, 0, NULL},
};

pmcs_sparse_regs_t sspa_state[] = {
{0x00030000, 0, 0x2000, 0x2000, PMCS_SPREGS_BLOCK_START, "SSPA Control Reg"},
{0x00030000, 0, 0x6000, 0x6000, 0, NULL},
{0x00030000, 0, 0xA000, 0xA000, 0, NULL},
{0x00030000, 0, 0xE000, 0xE000, 0, NULL},
{0x00040000, 0, 0x2000, 0x2000, 0, NULL},
{0x00040000, 0, 0x6000, 0x6000, 0, NULL},
{0x00040000, 0, 0xA000, 0xA000, 0, NULL},
{0x00040000, 0, 0xE000, 0xE000, 0, NULL},
};

pmcs_sparse_regs_t gsm_spregs[] = {
/* follows SRC registers */
{0x00000000, 0xBF800000, 0x0000, 0x00FF, PMCS_SPREGS_BLOCK_START, "SRC"},
{0x00050000, 0xBF850000, 0x0000, 0x002F, PMCS_SPREGS_BLOCK_START, "SRC"},
/* follows BDMA registers */
{0x00010000, 0xBF810000, 0x0000, 0x000B, PMCS_SPREGS_BLOCK_START, "BDMA"},
{0x00010000, 0xBF810000, 0x0010, 0x0010, 0, NULL},
{0x00010000, 0xBF810000, 0x0020, 0x006F, 0, NULL},
{0x00010000, 0xBF810000, 0x0070, 0x0070, 0, NULL},
{0x00010000, 0xBF810000, 0x0084, 0x008B, 0, NULL},
{0x00010000, 0xBF810000, 0x0090, 0x0097, 0, NULL},
{0x00010000, 0xBF810000, 0x009C, 0x00A3, 0, NULL},
{0x00010000, 0xBF810000, 0x00A8, 0x00AF, 0, NULL},
{0x00010000, 0xBF810000, 0x00D0, 0x00D7, 0, NULL},
{0x00010000, 0xBF810000, 0x00F0, 0x00FB, 0, NULL},
{0x00010000, 0xBF810000, 0x0100, 0x010B, 0, NULL},
{0x00010000, 0xBF810000, 0x0110, 0x011B, 0, NULL},
{0x00010000, 0xBF810000, 0x0120, 0x012B, 0, NULL},
{0x00010000, 0xBF810000, 0x0130, 0x013B, 0, NULL},
{0x00010000, 0xBF810000, 0x0140, 0x014B, 0, NULL},
{0x00010000, 0xBF810000, 0x0150, 0x015B, 0, NULL},
{0x00010000, 0xBF810000, 0x0160, 0x016B, 0, NULL},
{0x00010000, 0xBF810000, 0x0200, 0x027F, 0, NULL},
{0x00010000, 0xBF810000, 0x0300, 0x0300, 0, NULL},
{0x00010000, 0xBF810000, 0x0340, 0x0340, 0, NULL},
/* follows PCIe APP registers */
{0x00010000, 0xBF813000, 0x3000, 0x300B, PMCS_SPREGS_BLOCK_START, "PCIe APP"},
{0x00010000, 0xBF813000, 0x3010, 0x304F, 0, NULL},
{0x00010000, 0xBF813000, 0x3060, 0x306B, 0, NULL},
{0x00010000, 0xBF813000, 0x3070, 0x308B, 0, NULL},
{0x00010000, 0xBF813000, 0x3100, 0x317B, 0, NULL},
{0x00010000, 0xBF813000, 0x3200, 0x327B, 0, NULL},
{0x00010000, 0xBF813000, 0x3280, 0x32A3, 0, NULL},
{0x00010000, 0xBF813000, 0x3300, 0x3323, 0, NULL},
{0x00010000, 0xBF813000, 0x3328, 0x339F, 0, NULL},
{0x00010000, 0xBF813000, 0x33C0, 0x33C7, 0, NULL},
{0x00010000, 0xBF813000, 0x3400, 0x34FF, 0, NULL},
{0x00010000, 0xBF813000, 0x3800, 0x3800, 0, NULL},
/* follows PCIe PHY registers */
{0x00010000, 0xBF814000, 0x4000, 0x401B, PMCS_SPREGS_BLOCK_START, "PCIe PHY"},
{0x00010000, 0xBF814000, 0x4020, 0x4027, 0, NULL},
{0x00010000, 0xBF814000, 0x402C, 0x402C, 0, NULL},
{0x00010000, 0xBF814000, 0x4040, 0x4057, 0, NULL},
{0x00010000, 0xBF814000, 0x405C, 0x405C, 0, NULL},
{0x00010000, 0xBF814000, 0x4064, 0x406F, 0, NULL},
{0x00010000, 0xBF814000, 0x40A0, 0x40B3, 0, NULL},
{0x00010000, 0xBF814000, 0x40C0, 0x40DF, 0, NULL},
{0x00010000, 0xBF814000, 0x4100, 0x4127, 0, NULL},
{0x00010000, 0xBF814000, 0x4130, 0x413F, 0, NULL},
{0x00010000, 0xBF814000, 0x4180, 0x4180, 0, NULL},
{0x00010000, 0xBF814000, 0x41B0, 0x41BF, 0, NULL},
{0x00010000, 0xBF814000, 0x41D0, 0x41E7, 0, NULL},
{0x00010000, 0xBF814000, 0x41EC, 0x41EC, 0, NULL},
{0x00010000, 0xBF814000, 0x41F8, 0x4227, 0, NULL},
{0x00010000, 0xBF814000, 0x4230, 0x423F, 0, NULL},
{0x00010000, 0xBF814000, 0x4280, 0x4280, 0, NULL},
{0x00010000, 0xBF814000, 0x42B0, 0x42BF, 0, NULL},
{0x00010000, 0xBF814000, 0x42D0, 0x42E7, 0, NULL},
{0x00010000, 0xBF814000, 0x42EC, 0x42EC, 0, NULL},
{0x00010000, 0xBF814000, 0x42F8, 0x4327, 0, NULL},
{0x00010000, 0xBF814000, 0x4330, 0x433F, 0, NULL},
{0x00010000, 0xBF814000, 0x4380, 0x4380, 0, NULL},
{0x00010000, 0xBF814000, 0x43B0, 0x43BF, 0, NULL},
{0x00010000, 0xBF814000, 0x43D0, 0x43E7, 0, NULL},
{0x00010000, 0xBF814000, 0x43EC, 0x43EC, 0, NULL},
{0x00010000, 0xBF814000, 0x43F8, 0x4427, 0, NULL},
{0x00010000, 0xBF814000, 0x4430, 0x443F, 0, NULL},
{0x00010000, 0xBF814000, 0x4480, 0x4480, 0, NULL},
{0x00010000, 0xBF814000, 0x44B0, 0x44BF, 0, NULL},
{0x00010000, 0xBF814000, 0x44D0, 0x44E7, 0, NULL},
{0x00010000, 0xBF814000, 0x44EC, 0x44EC, 0, NULL},
{0x00010000, 0xBF814000, 0x44F8, 0x4527, 0, NULL},
{0x00010000, 0xBF814000, 0x4530, 0x453F, 0, NULL},
{0x00010000, 0xBF814000, 0x4580, 0x4580, 0, NULL},
{0x00010000, 0xBF814000, 0x45B0, 0x45BF, 0, NULL},
{0x00010000, 0xBF814000, 0x45D0, 0x45E7, 0, NULL},
{0x00010000, 0xBF814000, 0x45EC, 0x45EC, 0, NULL},
{0x00010000, 0xBF814000, 0x45F8, 0x4627, 0, NULL},
{0x00010000, 0xBF814000, 0x4630, 0x463F, 0, NULL},
{0x00010000, 0xBF814000, 0x4680, 0x4680, 0, NULL},
{0x00010000, 0xBF814000, 0x46B0, 0x46BF, 0, NULL},
{0x00010000, 0xBF814000, 0x46D0, 0x46E7, 0, NULL},
{0x00010000, 0xBF814000, 0x46EC, 0x46EC, 0, NULL},
{0x00010000, 0xBF814000, 0x46F8, 0x4727, 0, NULL},
{0x00010000, 0xBF814000, 0x4730, 0x473F, 0, NULL},
{0x00010000, 0xBF814000, 0x4780, 0x4780, 0, NULL},
{0x00010000, 0xBF814000, 0x47B0, 0x47BF, 0, NULL},
{0x00010000, 0xBF814000, 0x47D0, 0x47E7, 0, NULL},
{0x00010000, 0xBF814000, 0x47EC, 0x47EC, 0, NULL},
{0x00010000, 0xBF814000, 0x47F8, 0x4827, 0, NULL},
{0x00010000, 0xBF814000, 0x4830, 0x483F, 0, NULL},
{0x00010000, 0xBF814000, 0x4880, 0x4880, 0, NULL},
{0x00010000, 0xBF814000, 0x48B0, 0x48BF, 0, NULL},
{0x00010000, 0xBF814000, 0x48D0, 0x48E7, 0, NULL},
{0x00010000, 0xBF814000, 0x48EC, 0x48EC, 0, NULL},
{0x00010000, 0xBF814000, 0x48F8, 0x494B, 0, NULL},
/* follows PCIe CORE registers */
{0x00010000, 0xBF818000, 0x8000, 0x8047, PMCS_SPREGS_BLOCK_START, "PCIe CORE"},
{0x00010000, 0xBF818000, 0x8050, 0x805F, 0, NULL},
{0x00010000, 0xBF818000, 0x8070, 0x808B, 0, NULL},
{0x00010000, 0xBF818000, 0x8094, 0x80B7, 0, NULL},
{0x00010000, 0xBF818000, 0x8100, 0x812B, 0, NULL},
{0x00010000, 0xBF818000, 0x9010, 0x9027, 0, NULL},
{0x00010000, 0xBF818000, 0x9030, 0x9030, 0, NULL},
/* follows OSSP registers */
{0x00020000, 0xBF820000, 0x0000, 0x001B, PMCS_SPREGS_BLOCK_START, "OSSP"},
{0x00020000, 0xBF820000, 0x0028, 0x002F, 0, NULL},
{0x00020000, 0xBF820000, 0x003C, 0x0043, 0, NULL},
{0x00020000, 0xBF820000, 0x0050, 0x0057, 0, NULL},
{0x00020000, 0xBF820000, 0x0064, 0x006B, 0, NULL},
{0x00020000, 0xBF820000, 0x0078, 0x007F, 0, NULL},
{0x00020000, 0xBF820000, 0x008C, 0x0093, 0, NULL},
{0x00020000, 0xBF820000, 0x00B0, 0x00DF, 0, NULL},
{0x00020000, 0xBF820000, 0x00F0, 0x00FF, 0, NULL},
{0x00020000, 0xBF820000, 0x0120, 0x0127, 0, NULL},
{0x00020000, 0xBF820000, 0x0220, 0x0227, 0, NULL},
{0x00020000, 0xBF820000, 0x0320, 0x0327, 0, NULL},
{0x00020000, 0xBF820000, 0x0420, 0x0427, 0, NULL},
{0x00020000, 0xBF820000, 0x0520, 0x0527, 0, NULL},
{0x00020000, 0xBF820000, 0x0620, 0x0627, 0, NULL},
{0x00020000, 0xBF820000, 0x0720, 0x0727, 0, NULL},
{0x00020000, 0xBF820000, 0x0820, 0x0827, 0, NULL},
{0x00020000, 0xBF820000, 0x0908, 0x0908, 0, NULL},
{0x00020000, 0xBF820000, 0x0910, 0x0917, 0, NULL},
{0x00020000, 0xBF820000, 0x0920, 0x0927, 0, NULL},
{0x00020000, 0xBF820000, 0x0930, 0x093F, 0, NULL},
/* follows SSPA registers */
{0x00030000, 0xBF832000, 0x2000, 0x2033, PMCS_SPREGS_BLOCK_START, "SSPA"},
{0x00030000, 0xBF832000, 0x2074, 0x20AB, 0, NULL},
{0x00030000, 0xBF832000, 0x20B8, 0x20CF, 0, NULL},
{0x00030000, 0xBF832000, 0x20E0, 0x20E0, 0, NULL},
{0x00030000, 0xBF832000, 0x6000, 0x6033, 0, NULL},
{0x00030000, 0xBF832000, 0x6074, 0x60AB, 0, NULL},
{0x00030000, 0xBF832000, 0x60B8, 0x60CF, 0, NULL},
{0x00030000, 0xBF832000, 0x60E0, 0x60E0, 0, NULL},
{0x00030000, 0xBF832000, 0xA000, 0xA033, 0, NULL},
{0x00030000, 0xBF832000, 0xA074, 0xA0AB, 0, NULL},
{0x00030000, 0xBF832000, 0xA0B8, 0xA0CF, 0, NULL},
{0x00030000, 0xBF832000, 0xA0E0, 0xA0E0, 0, NULL},
{0x00030000, 0xBF832000, 0xE000, 0xE033, 0, NULL},
{0x00030000, 0xBF832000, 0xE074, 0xE0AB, 0, NULL},
{0x00030000, 0xBF832000, 0xE0B8, 0xE0CF, 0, NULL},
{0x00030000, 0xBF832000, 0xE0E0, 0xE0E0, 0, NULL},
/* follows SSPA registers */
{0x00040000, 0xBF842000, 0x2000, 0x2033, PMCS_SPREGS_BLOCK_START, "SSPA"},
{0x00040000, 0xBF842000, 0x2074, 0x20AB, 0, NULL},
{0x00040000, 0xBF842000, 0x20B8, 0x20CF, 0, NULL},
{0x00040000, 0xBF842000, 0x20E0, 0x20E0, 0, NULL},
{0x00040000, 0xBF842000, 0x6000, 0x6033, 0, NULL},
{0x00040000, 0xBF842000, 0x6074, 0x60AB, 0, NULL},
{0x00040000, 0xBF842000, 0x60B8, 0x60CF, 0, NULL},
{0x00040000, 0xBF842000, 0x60E0, 0x60E0, 0, NULL},
{0x00040000, 0xBF842000, 0xA000, 0xA033, 0, NULL},
{0x00040000, 0xBF842000, 0xA074, 0xA0AB, 0, NULL},
{0x00040000, 0xBF842000, 0xA0B8, 0xA0CF, 0, NULL},
{0x00040000, 0xBF842000, 0xA0E0, 0xA0E0, 0, NULL},
{0x00040000, 0xBF842000, 0xE000, 0xE033, 0, NULL},
{0x00040000, 0xBF842000, 0xE074, 0xE0AB, 0, NULL},
{0x00040000, 0xBF842000, 0xE0B8, 0xE0CF, 0, NULL},
{0x00040000, 0xBF842000, 0xE0E0, 0xE0E0, 0, NULL},
/* follows HSST registers */
{0x00020000, 0xBF821000, 0x1000, 0x104B, PMCS_SPREGS_BLOCK_START, "HSST"},
/* follows LMS_DSS(A) registers */
{0x00030000, 0xBF830000, 0x0000, 0x005F, PMCS_SPREGS_BLOCK_START, "LMS_DSS(A)"},
{0x00030000, 0xBF830000, 0x0060, 0x006B, 0, NULL},
{0x00030000, 0xBF830000, 0x4000, 0x406B, 0, NULL},
{0x00030000, 0xBF830000, 0x8000, 0x806B, 0, NULL},
{0x00030000, 0xBF830000, 0xC000, 0xC06B, 0, NULL},
/* follows SSPL_6G registers */
{0x00030000, 0xBF831000, 0x1000, 0x105B, PMCS_SPREGS_BLOCK_START, "SSPL_6G"},
{0x00030000, 0xBF831000, 0x1060, 0x107F, 0, NULL},
{0x00030000, 0xBF831000, 0x10A0, 0x10AB, 0, NULL},
{0x00030000, 0xBF831000, 0x5000, 0x505B, 0, NULL},
{0x00030000, 0xBF831000, 0x5060, 0x507F, 0, NULL},
{0x00030000, 0xBF831000, 0x50A0, 0x50AB, 0, NULL},
{0x00030000, 0xBF831000, 0x9000, 0x905B, 0, NULL},
{0x00030000, 0xBF831000, 0x9060, 0x907F, 0, NULL},
{0x00030000, 0xBF831000, 0x90A0, 0x90AB, 0, NULL},
{0x00030000, 0xBF831000, 0xD000, 0xD05B, 0, NULL},
{0x00030000, 0xBF831000, 0xD060, 0xD06B, 0, NULL},
{0x00030000, 0xBF831000, 0xD06C, 0xD07F, 0, NULL},
{0x00030000, 0xBF831000, 0xD0A0, 0xD0AB, 0, NULL},
/* follows HSST(A) registers */
{0x00030000, 0xBF833000, 0x3000, 0x301B, PMCS_SPREGS_BLOCK_START, "HSST(A)"},
{0x00030000, 0xBF833000, 0x3020, 0x3067, 0, NULL},
{0x00030000, 0xBF833000, 0x3084, 0x30E7, 0, NULL},
{0x00030000, 0xBF833000, 0x7000, 0x701B, 0, NULL},
{0x00030000, 0xBF833000, 0x7020, 0x7067, 0, NULL},
{0x00030000, 0xBF833000, 0x7084, 0x70E7, 0, NULL},
{0x00030000, 0xBF833000, 0xB000, 0xB01B, 0, NULL},
{0x00030000, 0xBF833000, 0xB020, 0xB067, 0, NULL},
{0x00030000, 0xBF833000, 0xB084, 0xB0E7, 0, NULL},
{0x00030000, 0xBF833000, 0xF000, 0xF01B, 0, NULL},
{0x00030000, 0xBF833000, 0xF020, 0xF067, 0, NULL},
{0x00030000, 0xBF833000, 0xF084, 0xF0E7, 0, NULL},
/* follows LMS_DSS(A) registers */
{0x00040000, 0xBF840000, 0x0000, 0x005F, PMCS_SPREGS_BLOCK_START, "LMS_DSS(A)"},
{0x00040000, 0xBF840000, 0x0060, 0x006B, 0, NULL},
{0x00040000, 0xBF840000, 0x4000, 0x406B, 0, NULL},
{0x00040000, 0xBF840000, 0x8000, 0x806B, 0, NULL},
{0x00040000, 0xBF840000, 0xc000, 0xC06B, 0, NULL},
/* follows SSPL_6G registers */
{0x00040000, 0xBF841000, 0x1000, 0x105B, PMCS_SPREGS_BLOCK_START, "SSPL_6G"},
{0x00040000, 0xBF841000, 0x1060, 0x107F, 0, NULL},
{0x00040000, 0xBF841000, 0x10A0, 0x10AB, 0, NULL},
{0x00040000, 0xBF841000, 0x5000, 0x505B, 0, NULL},
{0x00040000, 0xBF841000, 0x5060, 0x507F, 0, NULL},
{0x00040000, 0xBF841000, 0x50A0, 0x50AB, 0, NULL},
{0x00040000, 0xBF841000, 0x9000, 0x905B, 0, NULL},
{0x00040000, 0xBF841000, 0x9060, 0x907F, 0, NULL},
{0x00040000, 0xBF841000, 0x90A0, 0x90AB, 0, NULL},
{0x00040000, 0xBF841000, 0xD000, 0xD05B, 0, NULL},
{0x00040000, 0xBF841000, 0xD060, 0xD06B, 0, NULL},
{0x00040000, 0xBF841000, 0xD06C, 0xD07F, 0, NULL},
{0x00040000, 0xBF841000, 0xD0A0, 0xD0AB, 0, NULL},
/* follows HSST(A) registers */
{0x00040000, 0xBF843000, 0x3000, 0x301B, PMCS_SPREGS_BLOCK_START, "HSST(A)"},
{0x00040000, 0xBF843000, 0x3020, 0x3067, 0, NULL},
{0x00040000, 0xBF843000, 0x3084, 0x30E7, 0, NULL},
{0x00040000, 0xBF843000, 0x7000, 0x701B, 0, NULL},
{0x00040000, 0xBF843000, 0x7020, 0x7067, 0, NULL},
{0x00040000, 0xBF843000, 0x7084, 0x70E7, 0, NULL},
{0x00040000, 0xBF843000, 0xB000, 0xB01B, 0, NULL},
{0x00040000, 0xBF843000, 0xB020, 0xB067, 0, NULL},
{0x00040000, 0xBF843000, 0xB084, 0xB0E7, 0, NULL},
{0x00040000, 0xBF843000, 0xF000, 0xF01B, 0, NULL},
{0x00040000, 0xBF843000, 0xF020, 0xF067, 0, NULL},
{0x00040000, 0xBF843000, 0xF084, 0xF0E7, 0, NULL},
/* follows MBIC IOP registers */
{0x00060000, 0xBF860000, 0x0000, 0x00BB, PMCS_SPREGS_BLOCK_START, "MBIC IOP"},
{0x00060000, 0xBF860000, 0x00C0, 0x00C0, 0, NULL},
{0x00060000, 0xBF860000, 0x00C8, 0x00C8, 0, NULL},
{0x00060000, 0xBF860000, 0x00D0, 0x00D0, 0, NULL},
{0x00060000, 0xBF860000, 0x00D8, 0x00D8, 0, NULL},
{0x00060000, 0xBF860000, 0x00E0, 0x00E0, 0, NULL},
{0x00060000, 0xBF860000, 0x00E8, 0x00E8, 0, NULL},
{0x00060000, 0xBF860000, 0x00F0, 0x00F0, 0, NULL},
{0x00060000, 0xBF860000, 0x00F8, 0x00F8, 0, NULL},
{0x00060000, 0xBF860000, 0x0100, 0x012B, 0, NULL},
{0x00060000, 0xBF860000, 0x0130, 0x0138, 0, NULL},
{0x00060000, 0xBF860000, 0x0140, 0x0167, 0, NULL},
{0x00060000, 0xBF860000, 0x0180, 0x019F, 0, NULL},
{0x00060000, 0xBF860000, 0x0400, 0x040B, 0, NULL},
{0x00060000, 0xBF860000, 0x0410, 0x0507, 0, NULL},
/* follows MBIC AAP1 registers */
{0x00070000, 0xBF870000, 0x0000, 0x00BB, PMCS_SPREGS_BLOCK_START, "MBIC AAP1"},
{0x00070000, 0xBF870000, 0x00C0, 0x00C0, 0, NULL},
{0x00070000, 0xBF870000, 0x00C8, 0x00C8, 0, NULL},
{0x00070000, 0xBF870000, 0x00D0, 0x00D0, 0, NULL},
{0x00070000, 0xBF870000, 0x00D8, 0x00D8, 0, NULL},
{0x00070000, 0xBF870000, 0x00E0, 0x00E0, 0, NULL},
{0x00070000, 0xBF870000, 0x00E8, 0x00E8, 0, NULL},
{0x00070000, 0xBF870000, 0x00F0, 0x00F0, 0, NULL},
{0x00070000, 0xBF870000, 0x00F8, 0x00F8, 0, NULL},
{0x00070000, 0xBF870000, 0x0100, 0x012B, 0, NULL},
{0x00070000, 0xBF870000, 0x0130, 0x013B, 0, NULL},
{0x00070000, 0xBF870000, 0x0140, 0x0167, 0, NULL},
{0x00070000, 0xBF870000, 0x0180, 0x019F, 0, NULL},
{0x00070000, 0xBF870000, 0x0400, 0x040B, 0, NULL},
{0x00070000, 0xBF870000, 0x0410, 0x0507, 0, NULL},

/* follows SPBC registers */
{0x00090000, 0xBF890000, 0x0000, 0x002F, PMCS_SPREGS_BLOCK_START, "SPBC"},
{0x00090000, 0xBF890000, 0x003C, 0x004B, 0, NULL},
{0x00090000, 0xBF890000, 0x005C, 0x005C, 0, NULL},
{0x00090000, 0xBF890000, 0x0060, 0x006F, 0, NULL},
{0x00090000, 0xBF890000, 0x007C, 0x007C, 0, NULL},
{0x00090000, 0xBF890000, 0x0080, 0x008F, 0, NULL},
{0x00090000, 0xBF890000, 0x009C, 0x009C, 0, NULL},
{0x00090000, 0xBF890000, 0x00A0, 0x00AF, 0, NULL},
{0x00090000, 0xBF890000, 0x0100, 0x01A3, 0, NULL},
{0x00090000, 0xBF890000, 0x01C0, 0x024B, 0, NULL},
{0x00090000, 0xBF890000, 0x0290, 0x02BF, 0, NULL},
{0x00090000, 0xBF890000, 0x0260, 0x028F, 0, NULL},
{0x00090000, 0xBF890000, 0x02C0, 0x02EB, 0, NULL},
{0x00090000, 0xBF890000, 0x0360, 0x036B, 0, NULL},
{0x00090000, 0xBF890000, 0x1014, 0x1033, 0, NULL},
{0x00090000, 0xBF890000, 0x1054, 0x1073, 0, NULL},
{0x00090000, 0xBF890000, 0x1094, 0x10A7, 0, NULL},
{0x00090000, 0xBF890000, 0x1400, 0x141F, 0, NULL},
{0x00090000, 0xBF890000, 0x1800, 0x181F, 0, NULL},
/* follows GSM register space */
{0x00700000, 0xBFF00000, 0x0000, 0x0000, PMCS_SPREGS_BLOCK_START, "GSM"},
{0x00700000, 0xBFF00000, 0x0008, 0x0008, 0, NULL},
{0x00700000, 0xBFF00000, 0x0020, 0x0020, 0, NULL},
{0x00700000, 0xBFF00000, 0x0028, 0x0028, 0, NULL},
{0x00700000, 0xBFF00000, 0x0070, 0x0070, 0, NULL},
{0x00700000, 0xBFF00000, 0x0078, 0x0078, 0, NULL},
{0x00700000, 0xBFF00000, 0x0080, 0x0080, 0, NULL},
{0x00700000, 0xBFF00000, 0x0090, 0x0090, 0, NULL},
{0x00700000, 0xBFF00000, 0x0098, 0x0098, 0, NULL},
{0x00700000, 0xBFF00000, 0x00A8, 0x00A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0100, 0x0100, 0, NULL},
{0x00700000, 0xBFF00000, 0x0108, 0x0108, 0, NULL},
{0x00700000, 0xBFF00000, 0x0110, 0x0110, 0, NULL},
{0x00700000, 0xBFF00000, 0x0118, 0x0118, 0, NULL},
{0x00700000, 0xBFF00000, 0x0120, 0x0120, 0, NULL},
{0x00700000, 0xBFF00000, 0x0128, 0x0128, 0, NULL},
{0x00700000, 0xBFF00000, 0x0130, 0x0130, 0, NULL},
{0x00700000, 0xBFF00000, 0x0138, 0x0138, 0, NULL},
{0x00700000, 0xBFF00000, 0x0140, 0x0140, 0, NULL},
{0x00700000, 0xBFF00000, 0x0148, 0x0148, 0, NULL},
{0x00700000, 0xBFF00000, 0x0150, 0x0150, 0, NULL},
{0x00700000, 0xBFF00000, 0x0158, 0x0158, 0, NULL},
{0x00700000, 0xBFF00000, 0x0160, 0x0160, 0, NULL},
{0x00700000, 0xBFF00000, 0x0168, 0x0168, 0, NULL},
{0x00700000, 0xBFF00000, 0x0170, 0x0170, 0, NULL},
{0x00700000, 0xBFF00000, 0x0178, 0x0178, 0, NULL},
{0x00700000, 0xBFF00000, 0x0180, 0x0180, 0, NULL},
{0x00700000, 0xBFF00000, 0x0188, 0x0188, 0, NULL},
{0x00700000, 0xBFF00000, 0x0190, 0x0190, 0, NULL},
{0x00700000, 0xBFF00000, 0x0198, 0x0198, 0, NULL},
{0x00700000, 0xBFF00000, 0x01A0, 0x01A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01A8, 0x01A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x01B0, 0x01B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01B8, 0x01B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x01C0, 0x01C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01C8, 0x01C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x01D0, 0x01D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01D8, 0x01D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x01E0, 0x01E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01E8, 0x01E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x01F0, 0x01F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x01F8, 0x01F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0200, 0x0200, 0, NULL},
{0x00700000, 0xBFF00000, 0x0208, 0x0208, 0, NULL},
{0x00700000, 0xBFF00000, 0x0210, 0x0210, 0, NULL},
{0x00700000, 0xBFF00000, 0x0218, 0x0218, 0, NULL},
{0x00700000, 0xBFF00000, 0x0220, 0x0220, 0, NULL},
{0x00700000, 0xBFF00000, 0x0228, 0x0228, 0, NULL},
{0x00700000, 0xBFF00000, 0x0230, 0x0230, 0, NULL},
{0x00700000, 0xBFF00000, 0x0238, 0x0238, 0, NULL},
{0x00700000, 0xBFF00000, 0x0240, 0x0240, 0, NULL},
{0x00700000, 0xBFF00000, 0x0248, 0x0248, 0, NULL},
{0x00700000, 0xBFF00000, 0x0250, 0x0250, 0, NULL},
{0x00700000, 0xBFF00000, 0x0258, 0x0258, 0, NULL},
{0x00700000, 0xBFF00000, 0x0260, 0x0260, 0, NULL},
{0x00700000, 0xBFF00000, 0x0268, 0x0268, 0, NULL},
{0x00700000, 0xBFF00000, 0x0270, 0x0270, 0, NULL},
{0x00700000, 0xBFF00000, 0x0278, 0x0278, 0, NULL},
{0x00700000, 0xBFF00000, 0x0280, 0x0280, 0, NULL},
{0x00700000, 0xBFF00000, 0x0288, 0x0288, 0, NULL},
{0x00700000, 0xBFF00000, 0x0290, 0x0290, 0, NULL},
{0x00700000, 0xBFF00000, 0x0298, 0x0298, 0, NULL},
{0x00700000, 0xBFF00000, 0x02A0, 0x02A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02A8, 0x02A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x02B0, 0x02B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02B8, 0x02B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x02C0, 0x02C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02C8, 0x02C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x02D0, 0x02D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02D8, 0x02D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x02E0, 0x02E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02E8, 0x02E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x02F0, 0x02F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x02F8, 0x02F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0300, 0x0300, 0, NULL},
{0x00700000, 0xBFF00000, 0x0308, 0x0308, 0, NULL},
{0x00700000, 0xBFF00000, 0x0310, 0x0310, 0, NULL},
{0x00700000, 0xBFF00000, 0x0318, 0x0318, 0, NULL},
{0x00700000, 0xBFF00000, 0x0320, 0x0320, 0, NULL},
{0x00700000, 0xBFF00000, 0x0328, 0x0328, 0, NULL},
{0x00700000, 0xBFF00000, 0x0330, 0x0330, 0, NULL},
{0x00700000, 0xBFF00000, 0x0338, 0x0338, 0, NULL},
{0x00700000, 0xBFF00000, 0x0340, 0x0340, 0, NULL},
{0x00700000, 0xBFF00000, 0x0348, 0x0348, 0, NULL},
{0x00700000, 0xBFF00000, 0x0350, 0x0350, 0, NULL},
{0x00700000, 0xBFF00000, 0x0358, 0x0358, 0, NULL},
{0x00700000, 0xBFF00000, 0x0360, 0x0360, 0, NULL},
{0x00700000, 0xBFF00000, 0x0368, 0x0368, 0, NULL},
{0x00700000, 0xBFF00000, 0x0370, 0x0370, 0, NULL},
{0x00700000, 0xBFF00000, 0x0378, 0x0378, 0, NULL},
{0x00700000, 0xBFF00000, 0x0380, 0x0380, 0, NULL},
{0x00700000, 0xBFF00000, 0x0388, 0x0388, 0, NULL},
{0x00700000, 0xBFF00000, 0x0390, 0x0390, 0, NULL},
{0x00700000, 0xBFF00000, 0x0398, 0x0398, 0, NULL},
{0x00700000, 0xBFF00000, 0x03A0, 0x03A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03A8, 0x03A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x03B0, 0x03B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03B8, 0x03B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x03C0, 0x03C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03C8, 0x03C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x03D0, 0x03D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03D8, 0x03D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x03E0, 0x03E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03E8, 0x03E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x03F0, 0x03F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x03F8, 0x03F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0400, 0x0400, 0, NULL},
{0x00700000, 0xBFF00000, 0x0408, 0x0408, 0, NULL},
{0x00700000, 0xBFF00000, 0x0410, 0x0410, 0, NULL},
{0x00700000, 0xBFF00000, 0x0418, 0x0418, 0, NULL},
{0x00700000, 0xBFF00000, 0x0420, 0x0420, 0, NULL},
{0x00700000, 0xBFF00000, 0x0428, 0x0428, 0, NULL},
{0x00700000, 0xBFF00000, 0x0430, 0x0430, 0, NULL},
{0x00700000, 0xBFF00000, 0x0438, 0x0438, 0, NULL},
{0x00700000, 0xBFF00000, 0x0440, 0x0440, 0, NULL},
{0x00700000, 0xBFF00000, 0x0448, 0x0448, 0, NULL},
{0x00700000, 0xBFF00000, 0x0450, 0x0450, 0, NULL},
{0x00700000, 0xBFF00000, 0x0458, 0x0458, 0, NULL},
{0x00700000, 0xBFF00000, 0x0460, 0x0460, 0, NULL},
{0x00700000, 0xBFF00000, 0x0468, 0x0468, 0, NULL},
{0x00700000, 0xBFF00000, 0x0470, 0x0470, 0, NULL},
{0x00700000, 0xBFF00000, 0x0478, 0x0478, 0, NULL},
{0x00700000, 0xBFF00000, 0x0480, 0x0480, 0, NULL},
{0x00700000, 0xBFF00000, 0x0488, 0x0488, 0, NULL},
{0x00700000, 0xBFF00000, 0x0490, 0x0490, 0, NULL},
{0x00700000, 0xBFF00000, 0x0498, 0x0498, 0, NULL},
{0x00700000, 0xBFF00000, 0x04A0, 0x04A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04A8, 0x04A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x04B0, 0x04B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04B8, 0x04B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x04C0, 0x04C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04C8, 0x04C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x04D0, 0x04D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04D8, 0x04D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x04E0, 0x04E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04E8, 0x04E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x04F0, 0x04F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x04F8, 0x04F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0800, 0x0800, 0, NULL},
{0x00700000, 0xBFF00000, 0x0808, 0x0808, 0, NULL},
{0x00700000, 0xBFF00000, 0x0810, 0x0810, 0, NULL},
{0x00700000, 0xBFF00000, 0x0818, 0x0818, 0, NULL},
{0x00700000, 0xBFF00000, 0x0820, 0x0820, 0, NULL},
{0x00700000, 0xBFF00000, 0x0828, 0x0828, 0, NULL},
{0x00700000, 0xBFF00000, 0x0830, 0x0830, 0, NULL},
{0x00700000, 0xBFF00000, 0x0838, 0x0838, 0, NULL},
{0x00700000, 0xBFF00000, 0x0840, 0x0840, 0, NULL},
{0x00700000, 0xBFF00000, 0x0848, 0x0848, 0, NULL},
{0x00700000, 0xBFF00000, 0x0850, 0x0850, 0, NULL},
{0x00700000, 0xBFF00000, 0x0858, 0x0858, 0, NULL},
{0x00700000, 0xBFF00000, 0x0860, 0x0860, 0, NULL},
{0x00700000, 0xBFF00000, 0x0868, 0x0868, 0, NULL},
{0x00700000, 0xBFF00000, 0x0870, 0x0870, 0, NULL},
{0x00700000, 0xBFF00000, 0x0878, 0x0878, 0, NULL},
{0x00700000, 0xBFF00000, 0x0880, 0x0880, 0, NULL},
{0x00700000, 0xBFF00000, 0x0888, 0x0888, 0, NULL},
{0x00700000, 0xBFF00000, 0x0890, 0x0890, 0, NULL},
{0x00700000, 0xBFF00000, 0x0898, 0x0898, 0, NULL},
{0x00700000, 0xBFF00000, 0x08A0, 0x08A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08A8, 0x08A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x08B0, 0x08B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08B8, 0x08B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x08C0, 0x08C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08C8, 0x08C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x08D0, 0x08D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08D8, 0x08D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x08E0, 0x08E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08E8, 0x08E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x08F0, 0x08F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x08F8, 0x08F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0900, 0x0900, 0, NULL},
{0x00700000, 0xBFF00000, 0x0908, 0x0908, 0, NULL},
{0x00700000, 0xBFF00000, 0x0910, 0x0910, 0, NULL},
{0x00700000, 0xBFF00000, 0x0918, 0x0918, 0, NULL},
{0x00700000, 0xBFF00000, 0x0920, 0x0920, 0, NULL},
{0x00700000, 0xBFF00000, 0x0928, 0x0928, 0, NULL},
{0x00700000, 0xBFF00000, 0x0930, 0x0930, 0, NULL},
{0x00700000, 0xBFF00000, 0x0938, 0x0938, 0, NULL},
{0x00700000, 0xBFF00000, 0x0940, 0x0940, 0, NULL},
{0x00700000, 0xBFF00000, 0x0948, 0x0948, 0, NULL},
{0x00700000, 0xBFF00000, 0x0950, 0x0950, 0, NULL},
{0x00700000, 0xBFF00000, 0x0958, 0x0958, 0, NULL},
{0x00700000, 0xBFF00000, 0x0960, 0x0960, 0, NULL},
{0x00700000, 0xBFF00000, 0x0968, 0x0968, 0, NULL},
{0x00700000, 0xBFF00000, 0x0970, 0x0970, 0, NULL},
{0x00700000, 0xBFF00000, 0x0978, 0x0978, 0, NULL},
{0x00700000, 0xBFF00000, 0x0980, 0x0980, 0, NULL},
{0x00700000, 0xBFF00000, 0x0988, 0x0988, 0, NULL},
{0x00700000, 0xBFF00000, 0x0990, 0x0990, 0, NULL},
{0x00700000, 0xBFF00000, 0x0998, 0x0998, 0, NULL},
{0x00700000, 0xBFF00000, 0x09A0, 0x09A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09A8, 0x09A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x09B0, 0x09B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09B8, 0x09B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x09C0, 0x09C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09C8, 0x09C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x09D0, 0x09D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09D8, 0x09D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x09E0, 0x09E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09E8, 0x09E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x09F0, 0x09F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x09F8, 0x09F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A00, 0x0A00, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A08, 0x0A08, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A10, 0x0A10, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A18, 0x0A18, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A20, 0x0A20, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A28, 0x0A28, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A30, 0x0A30, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A38, 0x0A38, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A40, 0x0A40, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A48, 0x0A48, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A50, 0x0A50, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A58, 0x0A58, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A60, 0x0A60, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A68, 0x0A68, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A70, 0x0A70, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A78, 0x0A78, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A80, 0x0A80, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A88, 0x0A88, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A90, 0x0A90, 0, NULL},
{0x00700000, 0xBFF00000, 0x0A98, 0x0A98, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AA0, 0x0AA0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AA8, 0x0AA8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AB0, 0x0AB0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AB8, 0x0AB8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AC0, 0x0AC0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AC8, 0x0AC8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AD0, 0x0AD0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AD8, 0x0AD8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AE0, 0x0AE0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AE8, 0x0AE8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AF0, 0x0AF0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0AF8, 0x0AF8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B00, 0x0B00, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B08, 0x0B08, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B10, 0x0B10, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B18, 0x0B18, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B20, 0x0B20, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B28, 0x0B28, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B30, 0x0B30, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B38, 0x0B38, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B40, 0x0B40, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B48, 0x0B48, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B50, 0x0B50, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B58, 0x0B58, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B60, 0x0B60, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B68, 0x0B68, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B70, 0x0B70, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B78, 0x0B78, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B80, 0x0B80, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B88, 0x0B88, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B90, 0x0B90, 0, NULL},
{0x00700000, 0xBFF00000, 0x0B98, 0x0B98, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BA0, 0x0BA0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BA8, 0x0BA8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BB0, 0x0BB0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BB8, 0x0BB8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BC0, 0x0BC0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BC8, 0x0BC8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BD0, 0x0BD0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BD8, 0x0BD8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BE0, 0x0BE0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BE8, 0x0BE8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BF0, 0x0BF0, 0, NULL},
{0x00700000, 0xBFF00000, 0x0BF8, 0x0BF8, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C00, 0x0C00, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C08, 0x0C08, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C10, 0x0C10, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C18, 0x0C18, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C20, 0x0C20, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C28, 0x0C28, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C30, 0x0C30, 0, NULL},
{0x00700000, 0xBFF00000, 0x0C38, 0x0C38, 0, NULL},
{0x00700000, 0xBFF00000, 0x1000, 0x1000, 0, NULL},
{0x00700000, 0xBFF00000, 0x1008, 0x1008, 0, NULL},
{0x00700000, 0xBFF00000, 0x1010, 0x1010, 0, NULL},
{0x00700000, 0xBFF00000, 0x1018, 0x1018, 0, NULL},
{0x00700000, 0xBFF00000, 0x1020, 0x1020, 0, NULL},
{0x00700000, 0xBFF00000, 0x1028, 0x1028, 0, NULL},
{0x00700000, 0xBFF00000, 0x1030, 0x1030, 0, NULL},
{0x00700000, 0xBFF00000, 0x1038, 0x1038, 0, NULL},
{0x00700000, 0xBFF00000, 0x1040, 0x1040, 0, NULL},
{0x00700000, 0xBFF00000, 0x1048, 0x1048, 0, NULL},
{0x00700000, 0xBFF00000, 0x1050, 0x1050, 0, NULL},
{0x00700000, 0xBFF00000, 0x1058, 0x1058, 0, NULL},
{0x00700000, 0xBFF00000, 0x1060, 0x1060, 0, NULL},
{0x00700000, 0xBFF00000, 0x1068, 0x1068, 0, NULL},
{0x00700000, 0xBFF00000, 0x1070, 0x1070, 0, NULL},
{0x00700000, 0xBFF00000, 0x1078, 0x1078, 0, NULL},
{0x00700000, 0xBFF00000, 0x1080, 0x1080, 0, NULL},
{0x00700000, 0xBFF00000, 0x1088, 0x1088, 0, NULL},
{0x00700000, 0xBFF00000, 0x1090, 0x1090, 0, NULL},
{0x00700000, 0xBFF00000, 0x1098, 0x1098, 0, NULL},
{0x00700000, 0xBFF00000, 0x10A0, 0x10A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10A8, 0x10A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x10B0, 0x10B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10B8, 0x10B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x10C0, 0x10C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10C8, 0x10C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x10D0, 0x10D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10D8, 0x10D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x10E0, 0x10E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10E8, 0x10E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x10F0, 0x10F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x10F8, 0x10F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1100, 0x1100, 0, NULL},
{0x00700000, 0xBFF00000, 0x1108, 0x1108, 0, NULL},
{0x00700000, 0xBFF00000, 0x1110, 0x1110, 0, NULL},
{0x00700000, 0xBFF00000, 0x1118, 0x1118, 0, NULL},
{0x00700000, 0xBFF00000, 0x1120, 0x1120, 0, NULL},
{0x00700000, 0xBFF00000, 0x1128, 0x1128, 0, NULL},
{0x00700000, 0xBFF00000, 0x1130, 0x1130, 0, NULL},
{0x00700000, 0xBFF00000, 0x1138, 0x1138, 0, NULL},
{0x00700000, 0xBFF00000, 0x1140, 0x1140, 0, NULL},
{0x00700000, 0xBFF00000, 0x1148, 0x1148, 0, NULL},
{0x00700000, 0xBFF00000, 0x1150, 0x1150, 0, NULL},
{0x00700000, 0xBFF00000, 0x1158, 0x1158, 0, NULL},
{0x00700000, 0xBFF00000, 0x1160, 0x1160, 0, NULL},
{0x00700000, 0xBFF00000, 0x1168, 0x1168, 0, NULL},
{0x00700000, 0xBFF00000, 0x1170, 0x1170, 0, NULL},
{0x00700000, 0xBFF00000, 0x1178, 0x1178, 0, NULL},
{0x00700000, 0xBFF00000, 0x1180, 0x1180, 0, NULL},
{0x00700000, 0xBFF00000, 0x1188, 0x1188, 0, NULL},
{0x00700000, 0xBFF00000, 0x1190, 0x1190, 0, NULL},
{0x00700000, 0xBFF00000, 0x1198, 0x1198, 0, NULL},
{0x00700000, 0xBFF00000, 0x11A0, 0x11A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11A8, 0x11A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x11B0, 0x11B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11B8, 0x11B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x11C0, 0x11C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11C8, 0x11C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x11D0, 0x11D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11D8, 0x11D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x11E0, 0x11E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11E8, 0x11E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x11F0, 0x11F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x11F8, 0x11F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1200, 0x1200, 0, NULL},
{0x00700000, 0xBFF00000, 0x1208, 0x1208, 0, NULL},
{0x00700000, 0xBFF00000, 0x1210, 0x1210, 0, NULL},
{0x00700000, 0xBFF00000, 0x1218, 0x1218, 0, NULL},
{0x00700000, 0xBFF00000, 0x1220, 0x1220, 0, NULL},
{0x00700000, 0xBFF00000, 0x1228, 0x1228, 0, NULL},
{0x00700000, 0xBFF00000, 0x1230, 0x1230, 0, NULL},
{0x00700000, 0xBFF00000, 0x1238, 0x1238, 0, NULL},
{0x00700000, 0xBFF00000, 0x1240, 0x1240, 0, NULL},
{0x00700000, 0xBFF00000, 0x1248, 0x1248, 0, NULL},
{0x00700000, 0xBFF00000, 0x1250, 0x1250, 0, NULL},
{0x00700000, 0xBFF00000, 0x1258, 0x1258, 0, NULL},
{0x00700000, 0xBFF00000, 0x1260, 0x1260, 0, NULL},
{0x00700000, 0xBFF00000, 0x1268, 0x1268, 0, NULL},
{0x00700000, 0xBFF00000, 0x1270, 0x1270, 0, NULL},
{0x00700000, 0xBFF00000, 0x1278, 0x1278, 0, NULL},
{0x00700000, 0xBFF00000, 0x1280, 0x1280, 0, NULL},
{0x00700000, 0xBFF00000, 0x1288, 0x1288, 0, NULL},
{0x00700000, 0xBFF00000, 0x1290, 0x1290, 0, NULL},
{0x00700000, 0xBFF00000, 0x1298, 0x1298, 0, NULL},
{0x00700000, 0xBFF00000, 0x12A0, 0x12A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12A8, 0x12A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x12B0, 0x12B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12B8, 0x12B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x12C0, 0x12C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12C8, 0x12C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x12D0, 0x12D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12D8, 0x12D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x12E0, 0x12E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12E8, 0x12E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x12F0, 0x12F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x12F8, 0x12F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1300, 0x1300, 0, NULL},
{0x00700000, 0xBFF00000, 0x1308, 0x1308, 0, NULL},
{0x00700000, 0xBFF00000, 0x1310, 0x1310, 0, NULL},
{0x00700000, 0xBFF00000, 0x1318, 0x1318, 0, NULL},
{0x00700000, 0xBFF00000, 0x1320, 0x1320, 0, NULL},
{0x00700000, 0xBFF00000, 0x1328, 0x1328, 0, NULL},
{0x00700000, 0xBFF00000, 0x1330, 0x1330, 0, NULL},
{0x00700000, 0xBFF00000, 0x1338, 0x1338, 0, NULL},
{0x00700000, 0xBFF00000, 0x1340, 0x1340, 0, NULL},
{0x00700000, 0xBFF00000, 0x1348, 0x1348, 0, NULL},
{0x00700000, 0xBFF00000, 0x1350, 0x1350, 0, NULL},
{0x00700000, 0xBFF00000, 0x1358, 0x1358, 0, NULL},
{0x00700000, 0xBFF00000, 0x1360, 0x1360, 0, NULL},
{0x00700000, 0xBFF00000, 0x1368, 0x1368, 0, NULL},
{0x00700000, 0xBFF00000, 0x1370, 0x1370, 0, NULL},
{0x00700000, 0xBFF00000, 0x1378, 0x1378, 0, NULL},
{0x00700000, 0xBFF00000, 0x1380, 0x1380, 0, NULL},
{0x00700000, 0xBFF00000, 0x1388, 0x1388, 0, NULL},
{0x00700000, 0xBFF00000, 0x1390, 0x1390, 0, NULL},
{0x00700000, 0xBFF00000, 0x1398, 0x1398, 0, NULL},
{0x00700000, 0xBFF00000, 0x13A0, 0x13A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13A8, 0x13A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x13B0, 0x13B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13B8, 0x13B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x13C0, 0x13C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13C8, 0x13C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x13D0, 0x13D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13D8, 0x13D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x13E0, 0x13E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13E8, 0x13E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x13F0, 0x13F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x13F8, 0x13F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1800, 0x1800, 0, NULL},
{0x00700000, 0xBFF00000, 0x1808, 0x1808, 0, NULL},
{0x00700000, 0xBFF00000, 0x1810, 0x1810, 0, NULL},
{0x00700000, 0xBFF00000, 0x1818, 0x1818, 0, NULL},
{0x00700000, 0xBFF00000, 0x1820, 0x1820, 0, NULL},
{0x00700000, 0xBFF00000, 0x1828, 0x1828, 0, NULL},
{0x00700000, 0xBFF00000, 0x1830, 0x1830, 0, NULL},
{0x00700000, 0xBFF00000, 0x1838, 0x1838, 0, NULL},
{0x00700000, 0xBFF00000, 0x1840, 0x1840, 0, NULL},
{0x00700000, 0xBFF00000, 0x1848, 0x1848, 0, NULL},
{0x00700000, 0xBFF00000, 0x1850, 0x1850, 0, NULL},
{0x00700000, 0xBFF00000, 0x1858, 0x1858, 0, NULL},
{0x00700000, 0xBFF00000, 0x1860, 0x1860, 0, NULL},
{0x00700000, 0xBFF00000, 0x1868, 0x1868, 0, NULL},
{0x00700000, 0xBFF00000, 0x1870, 0x1870, 0, NULL},
{0x00700000, 0xBFF00000, 0x1878, 0x1878, 0, NULL},
{0x00700000, 0xBFF00000, 0x1880, 0x1880, 0, NULL},
{0x00700000, 0xBFF00000, 0x1888, 0x1888, 0, NULL},
{0x00700000, 0xBFF00000, 0x1890, 0x1890, 0, NULL},
{0x00700000, 0xBFF00000, 0x1898, 0x1898, 0, NULL},
{0x00700000, 0xBFF00000, 0x18A0, 0x18A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18A8, 0x18A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x18B0, 0x18B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18B8, 0x18B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x18C0, 0x18C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18C8, 0x18C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x18D0, 0x18D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18D8, 0x18D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x18E0, 0x18E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18E8, 0x18E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x18F0, 0x18F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x18F8, 0x18F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1900, 0x1900, 0, NULL},
{0x00700000, 0xBFF00000, 0x1908, 0x1908, 0, NULL},
{0x00700000, 0xBFF00000, 0x1910, 0x1910, 0, NULL},
{0x00700000, 0xBFF00000, 0x1918, 0x1918, 0, NULL},
{0x00700000, 0xBFF00000, 0x1920, 0x1920, 0, NULL},
{0x00700000, 0xBFF00000, 0x1928, 0x1928, 0, NULL},
{0x00700000, 0xBFF00000, 0x1930, 0x1930, 0, NULL},
{0x00700000, 0xBFF00000, 0x1938, 0x1938, 0, NULL},
{0x00700000, 0xBFF00000, 0x1940, 0x1940, 0, NULL},
{0x00700000, 0xBFF00000, 0x1948, 0x1948, 0, NULL},
{0x00700000, 0xBFF00000, 0x1950, 0x1950, 0, NULL},
{0x00700000, 0xBFF00000, 0x1958, 0x1958, 0, NULL},
{0x00700000, 0xBFF00000, 0x1960, 0x1960, 0, NULL},
{0x00700000, 0xBFF00000, 0x1968, 0x1968, 0, NULL},
{0x00700000, 0xBFF00000, 0x1970, 0x1970, 0, NULL},
{0x00700000, 0xBFF00000, 0x1978, 0x1978, 0, NULL},
{0x00700000, 0xBFF00000, 0x1980, 0x1980, 0, NULL},
{0x00700000, 0xBFF00000, 0x1988, 0x1988, 0, NULL},
{0x00700000, 0xBFF00000, 0x1990, 0x1990, 0, NULL},
{0x00700000, 0xBFF00000, 0x1998, 0x1998, 0, NULL},
{0x00700000, 0xBFF00000, 0x19A0, 0x19A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19A8, 0x19A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x19B0, 0x19B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19B8, 0x19B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x19C0, 0x19C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19C8, 0x19C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x19D0, 0x19D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19D8, 0x19D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x19E0, 0x19E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19E8, 0x19E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x19F0, 0x19F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x19F8, 0x19F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A00, 0x1A00, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A08, 0x1A08, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A10, 0x1A10, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A18, 0x1A18, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A20, 0x1A20, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A28, 0x1A28, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A30, 0x1A30, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A38, 0x1A38, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A40, 0x1A40, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A48, 0x1A48, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A50, 0x1A50, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A58, 0x1A58, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A60, 0x1A60, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A68, 0x1A68, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A70, 0x1A70, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A78, 0x1A78, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A80, 0x1A80, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A88, 0x1A88, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A90, 0x1A90, 0, NULL},
{0x00700000, 0xBFF00000, 0x1A98, 0x1A98, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AA0, 0x1AA0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AA8, 0x1AA8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AB0, 0x1AB0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AB8, 0x1AB8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AC0, 0x1AC0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AC8, 0x1AC8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AD0, 0x1AD0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AD8, 0x1AD8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AE0, 0x1AE0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AE8, 0x1AE8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AF0, 0x1AF0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1AF8, 0x1AF8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B00, 0x1B00, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B08, 0x1B08, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B10, 0x1B10, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B18, 0x1B18, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B20, 0x1B20, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B28, 0x1B28, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B30, 0x1B30, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B38, 0x1B38, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B40, 0x1B40, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B48, 0x1B48, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B50, 0x1B50, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B58, 0x1B58, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B60, 0x1B60, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B68, 0x1B68, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B70, 0x1B70, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B78, 0x1B78, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B80, 0x1B80, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B88, 0x1B88, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B90, 0x1B90, 0, NULL},
{0x00700000, 0xBFF00000, 0x1B98, 0x1B98, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BA0, 0x1BA0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BA8, 0x1BA8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BB0, 0x1BB0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BB8, 0x1BB8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BC0, 0x1BC0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BC8, 0x1BC8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BD0, 0x1BD0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BD8, 0x1BD8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BE0, 0x1BE0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BE8, 0x1BE8, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BF0, 0x1BF0, 0, NULL},
{0x00700000, 0xBFF00000, 0x1BF8, 0x1BF8, 0, NULL},
{0x00700000, 0xBFF00000, 0x2000, 0x2000, 0, NULL},
{0x00700000, 0xBFF00000, 0x2008, 0x2008, 0, NULL},
{0x00700000, 0xBFF00000, 0x2010, 0x2010, 0, NULL},
{0x00700000, 0xBFF00000, 0x2018, 0x2018, 0, NULL},
{0x00700000, 0xBFF00000, 0x2020, 0x2020, 0, NULL},
{0x00700000, 0xBFF00000, 0x2028, 0x2028, 0, NULL},
{0x00700000, 0xBFF00000, 0x2030, 0x2030, 0, NULL},
{0x00700000, 0xBFF00000, 0x2038, 0x2038, 0, NULL},
{0x00700000, 0xBFF00000, 0x2040, 0x2040, 0, NULL},
{0x00700000, 0xBFF00000, 0x2048, 0x2048, 0, NULL},
{0x00700000, 0xBFF00000, 0x2050, 0x2050, 0, NULL},
{0x00700000, 0xBFF00000, 0x2058, 0x2058, 0, NULL},
{0x00700000, 0xBFF00000, 0x2060, 0x2060, 0, NULL},
{0x00700000, 0xBFF00000, 0x2068, 0x2068, 0, NULL},
{0x00700000, 0xBFF00000, 0x2070, 0x2070, 0, NULL},
{0x00700000, 0xBFF00000, 0x2078, 0x2078, 0, NULL},
{0x00700000, 0xBFF00000, 0x2080, 0x2080, 0, NULL},
{0x00700000, 0xBFF00000, 0x2088, 0x2088, 0, NULL},
{0x00700000, 0xBFF00000, 0x2090, 0x2090, 0, NULL},
{0x00700000, 0xBFF00000, 0x2098, 0x2098, 0, NULL},
{0x00700000, 0xBFF00000, 0x20A0, 0x20A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20A8, 0x20A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x20B0, 0x20B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20B8, 0x20B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x20C0, 0x20C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20C8, 0x20C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x20D0, 0x20D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20D8, 0x20D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x20E0, 0x20E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20E8, 0x20E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x20F0, 0x20F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x20F8, 0x20F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x2100, 0x2100, 0, NULL},
{0x00700000, 0xBFF00000, 0x2108, 0x2108, 0, NULL},
{0x00700000, 0xBFF00000, 0x2110, 0x2110, 0, NULL},
{0x00700000, 0xBFF00000, 0x2118, 0x2118, 0, NULL},
{0x00700000, 0xBFF00000, 0x2120, 0x2120, 0, NULL},
{0x00700000, 0xBFF00000, 0x2128, 0x2128, 0, NULL},
{0x00700000, 0xBFF00000, 0x2130, 0x2130, 0, NULL},
{0x00700000, 0xBFF00000, 0x2138, 0x2138, 0, NULL},
{0x00700000, 0xBFF00000, 0x2140, 0x2140, 0, NULL},
{0x00700000, 0xBFF00000, 0x2148, 0x2148, 0, NULL},
{0x00700000, 0xBFF00000, 0x2150, 0x2150, 0, NULL},
{0x00700000, 0xBFF00000, 0x2158, 0x2158, 0, NULL},
{0x00700000, 0xBFF00000, 0x2160, 0x2160, 0, NULL},
{0x00700000, 0xBFF00000, 0x2168, 0x2168, 0, NULL},
{0x00700000, 0xBFF00000, 0x2170, 0x2170, 0, NULL},
{0x00700000, 0xBFF00000, 0x2178, 0x2178, 0, NULL},
{0x00700000, 0xBFF00000, 0x2180, 0x2180, 0, NULL},
{0x00700000, 0xBFF00000, 0x2188, 0x2188, 0, NULL},
{0x00700000, 0xBFF00000, 0x2190, 0x2190, 0, NULL},
{0x00700000, 0xBFF00000, 0x2198, 0x2198, 0, NULL},
{0x00700000, 0xBFF00000, 0x21A0, 0x21A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21A8, 0x21A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x21B0, 0x21B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21B8, 0x21B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x21C0, 0x21C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21C8, 0x21C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x21D0, 0x21D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21D8, 0x21D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x21E0, 0x21E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21E8, 0x21E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x21F0, 0x21F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x21F8, 0x21F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x2200, 0x2200, 0, NULL},
{0x00700000, 0xBFF00000, 0x2208, 0x2208, 0, NULL},
{0x00700000, 0xBFF00000, 0x2210, 0x2210, 0, NULL},
{0x00700000, 0xBFF00000, 0x2218, 0x2218, 0, NULL},
{0x00700000, 0xBFF00000, 0x2220, 0x2220, 0, NULL},
{0x00700000, 0xBFF00000, 0x2228, 0x2228, 0, NULL},
{0x00700000, 0xBFF00000, 0x2230, 0x2230, 0, NULL},
{0x00700000, 0xBFF00000, 0x2238, 0x2238, 0, NULL},
{0x00700000, 0xBFF00000, 0x2240, 0x2240, 0, NULL},
{0x00700000, 0xBFF00000, 0x2248, 0x2248, 0, NULL},
{0x00700000, 0xBFF00000, 0x2250, 0x2250, 0, NULL},
{0x00700000, 0xBFF00000, 0x2258, 0x2258, 0, NULL},
{0x00700000, 0xBFF00000, 0x2260, 0x2260, 0, NULL},
{0x00700000, 0xBFF00000, 0x2268, 0x2268, 0, NULL},
{0x00700000, 0xBFF00000, 0x2270, 0x2270, 0, NULL},
{0x00700000, 0xBFF00000, 0x2278, 0x2278, 0, NULL},
{0x00700000, 0xBFF00000, 0x2280, 0x2280, 0, NULL},
{0x00700000, 0xBFF00000, 0x2288, 0x2288, 0, NULL},
{0x00700000, 0xBFF00000, 0x2290, 0x2290, 0, NULL},
{0x00700000, 0xBFF00000, 0x2298, 0x2298, 0, NULL},
{0x00700000, 0xBFF00000, 0x22A0, 0x22A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22A8, 0x22A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x22B0, 0x22B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22B8, 0x22B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x22C0, 0x22C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22C8, 0x22C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x22D0, 0x22D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22D8, 0x22D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x22E0, 0x22E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22E8, 0x22E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x22F0, 0x22F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x22F8, 0x22F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x2300, 0x2300, 0, NULL},
{0x00700000, 0xBFF00000, 0x2308, 0x2308, 0, NULL},
{0x00700000, 0xBFF00000, 0x2310, 0x2310, 0, NULL},
{0x00700000, 0xBFF00000, 0x2318, 0x2318, 0, NULL},
{0x00700000, 0xBFF00000, 0x2320, 0x2320, 0, NULL},
{0x00700000, 0xBFF00000, 0x2328, 0x2328, 0, NULL},
{0x00700000, 0xBFF00000, 0x2330, 0x2330, 0, NULL},
{0x00700000, 0xBFF00000, 0x2338, 0x2338, 0, NULL},
{0x00700000, 0xBFF00000, 0x2340, 0x2340, 0, NULL},
{0x00700000, 0xBFF00000, 0x2348, 0x2348, 0, NULL},
{0x00700000, 0xBFF00000, 0x2350, 0x2350, 0, NULL},
{0x00700000, 0xBFF00000, 0x2358, 0x2358, 0, NULL},
{0x00700000, 0xBFF00000, 0x2360, 0x2360, 0, NULL},
{0x00700000, 0xBFF00000, 0x2368, 0x2368, 0, NULL},
{0x00700000, 0xBFF00000, 0x2370, 0x2370, 0, NULL},
{0x00700000, 0xBFF00000, 0x2378, 0x2378, 0, NULL},
{0x00700000, 0xBFF00000, 0x2380, 0x2380, 0, NULL},
{0x00700000, 0xBFF00000, 0x2388, 0x2388, 0, NULL},
{0x00700000, 0xBFF00000, 0x2390, 0x2390, 0, NULL},
{0x00700000, 0xBFF00000, 0x2398, 0x2398, 0, NULL},
{0x00700000, 0xBFF00000, 0x23A0, 0x23A0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23A8, 0x23A8, 0, NULL},
{0x00700000, 0xBFF00000, 0x23B0, 0x23B0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23B8, 0x23B8, 0, NULL},
{0x00700000, 0xBFF00000, 0x23C0, 0x23C0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23C8, 0x23C8, 0, NULL},
{0x00700000, 0xBFF00000, 0x23D0, 0x23D0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23D8, 0x23D8, 0, NULL},
{0x00700000, 0xBFF00000, 0x23E0, 0x23E0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23E8, 0x23E8, 0, NULL},
{0x00700000, 0xBFF00000, 0x23F0, 0x23F0, 0, NULL},
{0x00700000, 0xBFF00000, 0x23F8, 0x23F8, 0, NULL},
{0x00700000, 0xBFF00000, 0x2000, 0x2000, 0, NULL}
};


#ifdef	__cplusplus
}
#endif
#endif	/* _PMCS_FWLOG_H */
