/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef	_SYS_KICONV_JA_UNICODE_TO_JIS_H
#define	_SYS_KICONV_JA_UNICODE_TO_JIS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/kiconv.h>
#include <sys/kiconv_ja.h>

#ifdef	_KERNEL

/*
 * Unicode to 16bit EUC wide character conversion for kiconv modules
 */

#define	NODEST	KICONV_JA_NODEST

/*
 * Tables
 */

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_00[] = {
	/* 00 */
	0x0000,	0x0001,	0x0002,	0x0003,	0x0004,	0x0005,	0x0006,	0x0007,
	/* 08 */
	0x0008,	0x0009,	0x000a,	0x000b,	0x000c,	0x000d,	0x000e,	0x000f,
	/* 10 */
	0x0010,	0x0011,	0x0012,	0x0013,	0x0014,	0x0015,	0x0016,	0x0017,
	/* 18 */
	0x0018,	0x0019,	0x001a,	0x001b,	0x001c,	0x001d,	0x001e,	0x001f,
	/* 20 */
	0x0020,	0x0021,	0x0022,	0x0023,	0x0024,	0x0025,	0x0026,	0x0027,
	/* 28 */
	0x0028,	0x0029,	0x002a,	0x002b,	0x002c,	0x002d,	0x002e,	0x002f,
	/* 30 */
	0x0030,	0x0031,	0x0032,	0x0033,	0x0034,	0x0035,	0x0036,	0x0037,
	/* 38 */
	0x0038,	0x0039,	0x003a,	0x003b,	0x003c,	0x003d,	0x003e,	0x003f,
	/* 40 */
	0x0040,	0x0041,	0x0042,	0x0043,	0x0044,	0x0045,	0x0046,	0x0047,
	/* 48 */
	0x0048,	0x0049,	0x004a,	0x004b,	0x004c,	0x004d,	0x004e,	0x004f,
	/* 50 */
	0x0050,	0x0051,	0x0052,	0x0053,	0x0054,	0x0055,	0x0056,	0x0057,
	/* 58 */
	0x0058,	0x0059,	0x005a,	0x005b,	0x005c,	0x005d,	0x005e,	0x005f,
	/* 60 */
	0x0060,	0x0061,	0x0062,	0x0063,	0x0064,	0x0065,	0x0066,	0x0067,
	/* 68 */
	0x0068,	0x0069,	0x006a,	0x006b,	0x006c,	0x006d,	0x006e,	0x006f,
	/* 70 */
	0x0070,	0x0071,	0x0072,	0x0073,	0x0074,	0x0075,	0x0076,	0x0077,
	/* 78 */
	0x0078,	0x0079,	0x007a,	0x007b,	0x007c,	0x007d,	0x007e,	0x007f,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	0xa242,	0xa1f1,	0xa1f2,	0xa270,	NODEST,	0xa243,	0xa1f8,
	/* A8 */
	0xa1af,	0xa26d,	0xa26c,	NODEST,	0xa2cc,	NODEST,	0xa26e,	0xa234,
	/* B0 */
	0xa1eb,	0xa1de,	NODEST,	NODEST,	0xa1ad,	NODEST,	0xa2f9,	NODEST,
	/* B8 */
	0xa231,	NODEST,	0xa26b,	NODEST,	NODEST,	NODEST,	NODEST,	0xa244,
	/* C0 */
	0xaa22,	0xaa21,	0xaa24,	0xaa2a,	0xaa23,	0xaa29,	0xa921,	0xaa2e,
	/* C8 */
	0xaa32,	0xaa31,	0xaa34,	0xaa33,	0xaa40,	0xaa3f,	0xaa42,	0xaa41,
	/* D0 */
	NODEST,	0xaa50,	0xaa52,	0xaa51,	0xaa54,	0xaa58,	0xaa53,	0xa1df,
	/* D8 */
	0xa92c,	0xaa63,	0xaa62,	0xaa65,	0xaa64,	0xaa72,	0xa930,	0xa94e,
	/* E0 */
	0xab22,	0xab21,	0xab24,	0xab2a,	0xab23,	0xab29,	0xa941,	0xab2e,
	/* E8 */
	0xab32,	0xab31,	0xab34,	0xab33,	0xab40,	0xab3f,	0xab42,	0xab41,
	/* F0 */
	0xa943,	0xab50,	0xab52,	0xab51,	0xab54,	0xab58,	0xab53,	0xa1e0,
	/* F8 */
	0xa94c,	0xab63,	0xab62,	0xab65,	0xab64,	0xab72,	0xa950,	0xab73,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_01[] = {
	/* 00 */
	0xaa27,	0xab27,	0xaa25,	0xab25,	0xaa28,	0xab28,	0xaa2b,	0xab2b,
	/* 08 */
	0xaa2c,	0xab2c,	0xaa2f,	0xab2f,	0xaa2d,	0xab2d,	0xaa30,	0xab30,
	/* 10 */
	0xa922,	0xa942,	0xaa37,	0xab37,	NODEST,	NODEST,	0xaa36,	0xab36,
	/* 18 */
	0xaa38,	0xab38,	0xaa35,	0xab35,	0xaa3a,	0xab3a,	0xaa3b,	0xab3b,
	/* 20 */
	0xaa3d,	0xab3d,	0xaa3c,	NODEST,	0xaa3e,	0xab3e,	0xa924,	0xa944,
	/* 28 */
	0xaa47,	0xab47,	0xaa45,	0xab45,	NODEST,	NODEST,	0xaa46,	0xab46,
	/* 30 */
	0xaa44,	0xa945,	0xa926,	0xa946,	0xaa48,	0xab48,	0xaa49,	0xab49,
	/* 38 */
	0xa947,	0xaa4a,	0xab4a,	0xaa4c,	0xab4c,	0xaa4b,	0xab4b,	0xa929,
	/* 40 */
	0xa949,	0xa928,	0xa948,	0xaa4d,	0xab4d,	0xaa4f,	0xab4f,	0xaa4e,
	/* 48 */
	0xab4e,	0xa94a,	0xa92b,	0xa94b,	0xaa57,	0xab57,	NODEST,	NODEST,
	/* 50 */
	0xaa56,	0xab56,	0xa92d,	0xa94d,	0xaa59,	0xab59,	0xaa5b,	0xab5b,
	/* 58 */
	0xaa5a,	0xab5a,	0xaa5c,	0xab5c,	0xaa5d,	0xab5d,	0xaa5f,	0xab5f,
	/* 60 */
	0xaa5e,	0xab5e,	0xaa61,	0xab61,	0xaa60,	0xab60,	0xa92f,	0xa94f,
	/* 68 */
	0xaa6c,	0xab6c,	0xaa69,	0xab69,	0xaa66,	0xab66,	0xaa6b,	0xab6b,
	/* 70 */
	0xaa68,	0xab68,	0xaa6a,	0xab6a,	0xaa71,	0xab71,	0xaa74,	0xab74,
	/* 78 */
	0xaa73,	0xaa75,	0xab75,	0xaa77,	0xab77,	0xaa76,	0xab76,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xaa26,	0xab26,	0xaa43,
	/* D0 */
	0xab43,	0xaa55,	0xab55,	0xaa67,	0xab67,	0xaa70,	0xab70,	0xaa6d,
	/* D8 */
	0xab6d,	0xaa6f,	0xab6f,	0xaa6e,	0xab6e,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xab39,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_02[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa230,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	0xa22f,	0xa232,	0xa236,	0xa235,	NODEST,	0xa233,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_03[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xa238,	0xa239,	0xa661,	NODEST,
	/* 88 */
	0xa662,	0xa663,	0xa664,	NODEST,	0xa667,	NODEST,	0xa669,	0xa66c,
	/* 90 */
	0xa676,	0xa6a1,	0xa6a2,	0xa6a3,	0xa6a4,	0xa6a5,	0xa6a6,	0xa6a7,
	/* 98 */
	0xa6a8,	0xa6a9,	0xa6aa,	0xa6ab,	0xa6ac,	0xa6ad,	0xa6ae,	0xa6af,
	/* A0 */
	0xa6b0,	0xa6b1,	NODEST,	0xa6b2,	0xa6b3,	0xa6b4,	0xa6b5,	0xa6b6,
	/* A8 */
	0xa6b7,	0xa6b8,	0xa665,	0xa66a,	0xa671,	0xa672,	0xa673,	0xa674,
	/* B0 */
	0xa67b,	0xa6c1,	0xa6c2,	0xa6c3,	0xa6c4,	0xa6c5,	0xa6c6,	0xa6c7,
	/* B8 */
	0xa6c8,	0xa6c9,	0xa6ca,	0xa6cb,	0xa6cc,	0xa6cd,	0xa6ce,	0xa6cf,
	/* C0 */
	0xa6d0,	0xa6d1,	0xa678,	0xa6d2,	0xa6d3,	0xa6d4,	0xa6d5,	0xa6d6,
	/* C8 */
	0xa6d7,	0xa6d8,	0xa675,	0xa67a,	0xa677,	0xa679,	0xa67c,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_04[] = {
	/* 00 */
	NODEST,	0xa7a7,	0xa742,	0xa743,	0xa744,	0xa745,	0xa746,	0xa747,
	/* 08 */
	0xa748,	0xa749,	0xa74a,	0xa74b,	0xa74c,	NODEST,	0xa74d,	0xa74e,
	/* 10 */
	0xa7a1,	0xa7a2,	0xa7a3,	0xa7a4,	0xa7a5,	0xa7a6,	0xa7a8,	0xa7a9,
	/* 18 */
	0xa7aa,	0xa7ab,	0xa7ac,	0xa7ad,	0xa7ae,	0xa7af,	0xa7b0,	0xa7b1,
	/* 20 */
	0xa7b2,	0xa7b3,	0xa7b4,	0xa7b5,	0xa7b6,	0xa7b7,	0xa7b8,	0xa7b9,
	/* 28 */
	0xa7ba,	0xa7bb,	0xa7bc,	0xa7bd,	0xa7be,	0xa7bf,	0xa7c0,	0xa7c1,
	/* 30 */
	0xa7d1,	0xa7d2,	0xa7d3,	0xa7d4,	0xa7d5,	0xa7d6,	0xa7d8,	0xa7d9,
	/* 38 */
	0xa7da,	0xa7db,	0xa7dc,	0xa7dd,	0xa7de,	0xa7df,	0xa7e0,	0xa7e1,
	/* 40 */
	0xa7e2,	0xa7e3,	0xa7e4,	0xa7e5,	0xa7e6,	0xa7e7,	0xa7e8,	0xa7e9,
	/* 48 */
	0xa7ea,	0xa7eb,	0xa7ec,	0xa7ed,	0xa7ee,	0xa7ef,	0xa7f0,	0xa7f1,
	/* 50 */
	NODEST,	0xa7d7,	0xa772,	0xa773,	0xa774,	0xa775,	0xa776,	0xa777,
	/* 58 */
	0xa778,	0xa779,	0xa77a,	0xa77b,	0xa77c,	NODEST,	0xa77d,	0xa77e,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_20[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	0xa1be,	NODEST,	NODEST,	NODEST,	NODEST,	0xa1bd,	0xa1c2,	NODEST,
	/* 18 */
	0xa1c6,	0xa1c7,	NODEST,	NODEST,	0xa1c8,	0xa1c9,	NODEST,	NODEST,
	/* 20 */
	0xa2f7,	0xa2f8,	NODEST,	NODEST,	NODEST,	0xa1c5,	0xa1c4,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xa2f3,	NODEST,	0xa1ec,	0xa1ed,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	0xa2a8,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_21[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	0xa1ee,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa271,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	0xade4,	0xa26f,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xa2f2,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	0xadb5,	0xadb6,	0xadb7,	0xadb8,	0xadb9,	0xadba,	0xadbb,	0xadbc,
	/* 68 */
	0xadbd,	0xadbe,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xf373,	0xf374,	0xf375,	0xf376,	0xf377,	0xf378,	0xf379,	0xf37a,
	/* 78 */
	0xf37b,	0xf37c,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	0xa2ab,	0xa2ac,	0xa2aa,	0xa2ad,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xa2cd,	NODEST,	0xa2ce,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_22[] = {
	/* 00 */
	0xa2cf,	NODEST,	0xa2df,	0xa2d0,	NODEST,	NODEST,	NODEST,	0xa2e0,
	/* 08 */
	0xa2ba,	NODEST,	NODEST,	0xa2bb,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	0xadf4,	0xa1dd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	0xa2e5,	NODEST,	NODEST,	0xa2e7,	0xa1e7,	0xadf8,
	/* 20 */
	0xa2dc,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa2ca,
	/* 28 */
	0xa2cb,	0xa2c1,	0xa2c0,	0xa2e9,	0xa2ea,	NODEST,	0xadf3,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xa1e8,	0xa2e8,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa2e6,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	0xa2e2,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	0xa1e2,	0xa2e1,	NODEST,	NODEST,	NODEST,	NODEST,	0xa1e5,	0xa1e6,
	/* 68 */
	NODEST,	NODEST,	0xa2e3,	0xa2e4,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	0xa2be,	0xa2bf,	NODEST,	NODEST,	0xa2bc,	0xa2bd,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa2dd,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xadf9,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_23[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	0xa2de,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_24[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	0xada1,	0xada2,	0xada3,	0xada4,	0xada5,	0xada6,	0xada7,	0xada8,
	/* 68 */
	0xada9,	0xadaa,	0xadab,	0xadac,	0xadad,	0xadae,	0xadaf,	0xadb0,
	/* 70 */
	0xadb1,	0xadb2,	0xadb3,	0xadb4,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_25[] = {
	/* 00 */
	0xa8a1,	0xa8ac,	0xa8a2,	0xa8ad,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xa8a3,	NODEST,	NODEST,	0xa8ae,
	/* 10 */
	0xa8a4,	NODEST,	NODEST,	0xa8af,	0xa8a6,	NODEST,	NODEST,	0xa8b1,
	/* 18 */
	0xa8a5,	NODEST,	NODEST,	0xa8b0,	0xa8a7,	0xa8bc,	NODEST,	NODEST,
	/* 20 */
	0xa8b7,	NODEST,	NODEST,	0xa8b2,	0xa8a9,	0xa8be,	NODEST,	NODEST,
	/* 28 */
	0xa8b9,	NODEST,	NODEST,	0xa8b4,	0xa8a8,	NODEST,	NODEST,	0xa8b8,
	/* 30 */
	0xa8bd,	NODEST,	NODEST,	0xa8b3,	0xa8aa,	NODEST,	NODEST,	0xa8ba,
	/* 38 */
	0xa8bf,	NODEST,	NODEST,	0xa8b5,	0xa8ab,	NODEST,	NODEST,	0xa8bb,
	/* 40 */
	NODEST,	NODEST,	0xa8c0,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xa8b6,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	0xa2a3,	0xa2a2,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	0xa2a5,	0xa2a4,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xa2a7,	0xa2a6,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa2a1,	0xa1fe,
	/* C8 */
	NODEST,	NODEST,	NODEST,	0xa1fb,	NODEST,	NODEST,	0xa1fd,	0xa1fc,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa2fe,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_26[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xa1fa,	0xa1f9,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xa1ea,	NODEST,	0xa1e9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	0xa2f6,	NODEST,	NODEST,	0xa2f5,	NODEST,	0xa2f4,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_30[] = {
	/* 00 */
	0xa1a1,	0xa1a2,	0xa1a3,	0xa1b7,	NODEST,	0xa1b9,	0xa1ba,	0xa1bb,
	/* 08 */
	0xa1d2,	0xa1d3,	0xa1d4,	0xa1d5,	0xa1d6,	0xa1d7,	0xa1d8,	0xa1d9,
	/* 10 */
	0xa1da,	0xa1db,	0xa2a9,	0xa2ae,	0xa1cc,	0xa1cd,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xa1c1,	0xade0,	NODEST,	0xade1,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	0xa4a1,	0xa4a2,	0xa4a3,	0xa4a4,	0xa4a5,	0xa4a6,	0xa4a7,
	/* 48 */
	0xa4a8,	0xa4a9,	0xa4aa,	0xa4ab,	0xa4ac,	0xa4ad,	0xa4ae,	0xa4af,
	/* 50 */
	0xa4b0,	0xa4b1,	0xa4b2,	0xa4b3,	0xa4b4,	0xa4b5,	0xa4b6,	0xa4b7,
	/* 58 */
	0xa4b8,	0xa4b9,	0xa4ba,	0xa4bb,	0xa4bc,	0xa4bd,	0xa4be,	0xa4bf,
	/* 60 */
	0xa4c0,	0xa4c1,	0xa4c2,	0xa4c3,	0xa4c4,	0xa4c5,	0xa4c6,	0xa4c7,
	/* 68 */
	0xa4c8,	0xa4c9,	0xa4ca,	0xa4cb,	0xa4cc,	0xa4cd,	0xa4ce,	0xa4cf,
	/* 70 */
	0xa4d0,	0xa4d1,	0xa4d2,	0xa4d3,	0xa4d4,	0xa4d5,	0xa4d6,	0xa4d7,
	/* 78 */
	0xa4d8,	0xa4d9,	0xa4da,	0xa4db,	0xa4dc,	0xa4dd,	0xa4de,	0xa4df,
	/* 80 */
	0xa4e0,	0xa4e1,	0xa4e2,	0xa4e3,	0xa4e4,	0xa4e5,	0xa4e6,	0xa4e7,
	/* 88 */
	0xa4e8,	0xa4e9,	0xa4ea,	0xa4eb,	0xa4ec,	0xa4ed,	0xa4ee,	0xa4ef,
	/* 90 */
	0xa4f0,	0xa4f1,	0xa4f2,	0xa4f3,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	0xa1ab,	0xa1ac,	0xa1b5,	0xa1b6,	NODEST,
	/* A0 */
	NODEST,	0xa5a1,	0xa5a2,	0xa5a3,	0xa5a4,	0xa5a5,	0xa5a6,	0xa5a7,
	/* A8 */
	0xa5a8,	0xa5a9,	0xa5aa,	0xa5ab,	0xa5ac,	0xa5ad,	0xa5ae,	0xa5af,
	/* B0 */
	0xa5b0,	0xa5b1,	0xa5b2,	0xa5b3,	0xa5b4,	0xa5b5,	0xa5b6,	0xa5b7,
	/* B8 */
	0xa5b8,	0xa5b9,	0xa5ba,	0xa5bb,	0xa5bc,	0xa5bd,	0xa5be,	0xa5bf,
	/* C0 */
	0xa5c0,	0xa5c1,	0xa5c2,	0xa5c3,	0xa5c4,	0xa5c5,	0xa5c6,	0xa5c7,
	/* C8 */
	0xa5c8,	0xa5c9,	0xa5ca,	0xa5cb,	0xa5cc,	0xa5cd,	0xa5ce,	0xa5cf,
	/* D0 */
	0xa5d0,	0xa5d1,	0xa5d2,	0xa5d3,	0xa5d4,	0xa5d5,	0xa5d6,	0xa5d7,
	/* D8 */
	0xa5d8,	0xa5d9,	0xa5da,	0xa5db,	0xa5dc,	0xa5dd,	0xa5de,	0xa5df,
	/* E0 */
	0xa5e0,	0xa5e1,	0xa5e2,	0xa5e3,	0xa5e4,	0xa5e5,	0xa5e6,	0xa5e7,
	/* E8 */
	0xa5e8,	0xa5e9,	0xa5ea,	0xa5eb,	0xa5ec,	0xa5ed,	0xa5ee,	0xa5ef,
	/* F0 */
	0xa5f0,	0xa5f1,	0xa5f2,	0xa5f3,	0xa5f4,	0xa5f5,	0xa5f6,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	0xa1a6,	0xa1bc,	0xa1b3,	0xa1b4,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_32[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	0xadea,	0xadeb,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xadec,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xade5,	0xade6,	0xade7,	0xade8,
	/* A8 */
	0xade9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_33[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	0xadc6,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xadca,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xadc1,	NODEST,	NODEST,	NODEST,
	/* 18 */
	0xadc4,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	0xadc2,	0xadcc,	NODEST,	NODEST,	0xadcb,	0xadc5,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xadcd,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xadc7,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	0xadcf,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	0xadc0,	0xadce,	NODEST,	NODEST,	0xadc3,	NODEST,	NODEST,
	/* 50 */
	NODEST,	0xadc8,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xadc9,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	0xaddf,	0xadef,	0xadee,	0xaded,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xadd3,	0xadd4,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xadd0,	0xadd1,	0xadd2,	NODEST,
	/* A0 */
	NODEST,	0xadd6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xadd5,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xade3,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_4E[] = {
	/* 00 */
	0xb0ec,	0xc3fa,	0xb021,	0xbcb7,	0xb022,	0xb023,	NODEST,	0xcbfc,
	/* 08 */
	0xbee6,	0xbbb0,	0xbee5,	0xb2bc,	0xb024,	0xc9d4,	0xcdbf,	NODEST,
	/* 10 */
	0xd0a2,	0xb1af,	0xb025,	NODEST,	0xb3ee,	0xd0a3,	0xc0a4,	0xd2c2,
	/* 18 */
	0xb5d6,	0xcaba,	NODEST,	NODEST,	NODEST,	NODEST,	0xbee7,	0xb026,
	/* 20 */
	NODEST,	0xcebe,	NODEST,	0xb027,	0xb028,	NODEST,	0xcac2,	NODEST,
	/* 28 */
	0xb029,	NODEST,	0xd0a4,	0xb02a,	NODEST,	0xc3e6,	0xb02b,	0xb02c,
	/* 30 */
	0xb02d,	0xd0a5,	0xb6fa,	NODEST,	NODEST,	0xb02e,	0xd0a6,	NODEST,
	/* 38 */
	0xb4dd,	0xc3b0,	NODEST,	0xbce7,	0xd0a7,	NODEST,	NODEST,	0xd0a8,
	/* 40 */
	0xb02f,	0xb030,	0xd0a9,	0xc7b5,	0xb031,	0xb5d7,	NODEST,	0xb032,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xc7b7,	NODEST,	0xc6e3,	0xb8c3,	0xcbb3,
	/* 50 */
	NODEST,	0xb033,	NODEST,	NODEST,	NODEST,	0xe9c9,	0xd0aa,	0xbee8,
	/* 58 */
	0xd0ab,	0xb2b5,	0xb034,	NODEST,	0xb035,	0xb6e5,	0xb8f0,	0xcce9,
	/* 60 */
	NODEST,	NODEST,	0xd6a6,	0xb036,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xb037,	0xb038,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	0xcdf0,	NODEST,	0xc6fd,	0xb039,	0xb03a,	NODEST,	NODEST,
	/* 78 */
	NODEST,	0xb03b,	NODEST,	NODEST,	NODEST,	NODEST,	0xb4a5,	0xb03c,
	/* 80 */
	0xb5b5,	NODEST,	0xd0ac,	NODEST,	NODEST,	0xd0ad,	0xcebb,	NODEST,
	/* 88 */
	0xcdbd,	0xc1e8,	0xd0af,	0xbbf6,	0xc6f3,	0xb03d,	0xd0b2,	NODEST,
	/* 90 */
	NODEST,	0xb1be,	0xb8df,	NODEST,	0xb8de,	0xb0e6,	0xb03e,	0xb03f,
	/* 98 */
	0xcfcb,	0xcfca,	NODEST,	0xbab3,	0xb0a1,	0xb040,	0xd0b3,	0xd0b4,
	/* A0 */
	0xd0b5,	0xcbb4,	0xd0b6,	NODEST,	0xb8f2,	0xb0e7,	0xcbf2,	NODEST,
	/* A8 */
	0xb5fc,	NODEST,	NODEST,	0xb5fd,	0xb5fe,	0xc4e2,	0xcebc,	0xb041,
	/* B0 */
	0xd0b7,	NODEST,	NODEST,	0xd0b8,	NODEST,	NODEST,	0xd0b9,	NODEST,
	/* B8 */
	NODEST,	0xb042,	0xbfcd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	0xbdba,	0xbfce,	0xd0be,	0xb043,	0xd0bc,	NODEST,	0xd0bd,	0xb5d8,
	/* C8 */
	NODEST,	NODEST,	0xbaa3,	0xb2f0,	NODEST,	0xd0bb,	0xd0ba,	0xcaa9,
	/* D0 */
	0xb044,	NODEST,	NODEST,	NODEST,	0xbbc6,	0xbbc5,	0xc2be,	0xd0bf,
	/* D8 */
	0xc9d5,	0xc0e7,	0xb045,	0xb046,	NODEST,	0xa1b8,	0xd0c0,	0xd0c2,
	/* E0 */
	0xb047,	0xb048,	0xb049,	0xc2e5,	0xcee1,	0xb0ca,	NODEST,	NODEST,
	/* E8 */
	0xb04a,	NODEST,	NODEST,	NODEST,	NODEST,	0xd0c1,	0xb2be,	0xb04b,
	/* F0 */
	0xb6c4,	0xb04c,	0xc3e7,	0xb04d,	NODEST,	0xb04e,	0xb7ef,	0xd0c3,
	/* F8 */
	NODEST,	NODEST,	NODEST,	0xc7a4,	0xf42f,	0xb04f,	0xb050,	0xb051,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_4F[] = {
	/* 00 */
	0xb052,	0xb4eb,	0xb053,	0xb054,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	0xb055,	0xd0c4,	0xb0cb,	0xb056,	0xb057,	0xb8e0,	0xb4ec,	0xc9fa,
	/* 10 */
	0xc8b2,	0xb5d9,	0xb058,	NODEST,	NODEST,	0xb059,	0xb05a,	0xb05b,
	/* 18 */
	NODEST,	0xb05c,	0xb2f1,	NODEST,	0xd0e7,	0xc5c1,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb05d,	0xc7ec,
	/* 30 */
	0xd0c6,	0xb05e,	NODEST,	0xb060,	0xc8bc,	0xb061,	0xcee2,	0xb062,
	/* 38 */
	0xbfad,	0xb063,	0xbbc7,	0xb064,	0xbbf7,	0xb2c0,	0xb065,	NODEST,
	/* 40 */
	0xb066,	NODEST,	0xb067,	0xc4d1,	NODEST,	NODEST,	0xc3a2,	0xd0ca,
	/* 48 */
	0xb068,	0xb069,	NODEST,	0xb06a,	0xb06b,	0xb0cc,	0xc4e3,	0xbdbb,
	/* 50 */
	0xbab4,	0xcda4,	0xb06c,	0xc2ce,	0xb06d,	0xb2bf,	0xb06e,	0xd0c9,
	/* 58 */
	0xb06f,	0xcdbe,	0xd0c5,	0xd0c7,	0xbaee,	0xd0c8,	0xd5a4,	0xb070,
	/* 60 */
	0xb05f,	NODEST,	NODEST,	0xb071,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	0xd0d0,	0xb072,	NODEST,	0xb073,	NODEST,	0xb074,	0xd0d3,
	/* 70 */
	0xd0d1,	0xb075,	NODEST,	0xb2c2,	NODEST,	0xcabb,	0xd0cb,	0xb076,
	/* 78 */
	0xb077,	0xb078,	0xb079,	0xd0cf,	0xb8f3,	0xb07a,	0xb07b,	0xbbc8,
	/* 80 */
	NODEST,	0xb07c,	0xb07d,	0xb4a6,	0xb07e,	0xb121,	0xd0d4,	NODEST,
	/* 88 */
	0xd0cc,	0xb122,	0xb123,	0xcee3,	0xb124,	0xbbf8,	0xb125,	0xd0cd,
	/* 90 */
	0xb126,	0xd0d2,	0xb127,	0xb128,	0xb129,	NODEST,	0xd0d5,	0xb12a,
	/* 98 */
	0xd0ce,	0xb12b,	0xb12c,	0xb6a1,	NODEST,	0xb0cd,	0xb12d,	0xb12e,
	/* A0 */
	0xb6a2,	0xb2c1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xd5a5,	NODEST,	0xcbf9,	0xc9ee,	0xb8f4,
	/* B0 */
	NODEST,	NODEST,	0xb12f,	NODEST,	NODEST,	0xbfaf,	0xceb7,	0xb130,
	/* B8 */
	NODEST,	0xb131,	NODEST,	0xb132,	0xb133,	0xb134,	0xb135,	0xcad8,
	/* C0 */
	0xb136,	0xb137,	0xb7b8,	0xc2a5,	0xb2e4,	0xb138,	0xb139,	NODEST,
	/* C8 */
	0xb13a,	0xb13b,	0xbdd3,	0xb13c,	0xb13d,	0xb13e,	0xd0d9,	0xb13f,
	/* D0 */
	0xd0de,	0xd0dc,	0xb140,	NODEST,	0xd0d7,	NODEST,	NODEST,	0xc2af,
	/* D8 */
	0xd0da,	NODEST,	0xd0dd,	0xd0db,	0xb141,	0xcadd,	NODEST,	0xd0d8,
	/* E0 */
	0xb142,	0xbfae,	0xb143,	0xcbf3,	0xd0df,	0xd0e0,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbda4,	0xd0ed,
	/* F0 */
	0xb144,	NODEST,	0xb145,	0xc7d0,	NODEST,	0xc9b6,	0xd0e8,	NODEST,
	/* F8 */
	0xcaf0,	NODEST,	0xb2b6,	NODEST,	0xb146,	0xb147,	0xd0ec,	0xb148,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_50[] = {
	/* 00 */
	0xb149,	0xb14a,	NODEST,	NODEST,	0xb14b,	0xd0e6,	0xd0ef,	0xb14c,
	/* 08 */
	NODEST,	0xc1d2,	0xb14d,	0xb8c4,	0xb14e,	0xc7dc,	0xb14f,	0xe0c7,
	/* 10 */
	0xb150,	0xd0ee,	0xc5dd,	0xb151,	0xd0e3,	NODEST,	0xb8f6,	0xb152,
	/* 18 */
	0xb153,	0xb8f5,	0xd0e1,	0xb154,	0xb155,	0xb156,	0xb157,	0xbcda,
	/* 20 */
	NODEST,	0xd0e9,	0xb158,	0xcaef,	0xc3cd,	0xd0e5,	0xb7f1,	0xb159,
	/* 28 */
	0xd0e2,	0xd0ea,	0xd0e4,	0xced1,	0xd0eb,	0xcfc1,	0xb15a,	NODEST,
	/* 30 */
	0xb15b,	NODEST,	0xb15c,	0xb15d,	NODEST,	0xb15e,	0xb6e6,	NODEST,
	/* 38 */
	NODEST,	0xb7f0,	NODEST,	0xb176,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xb15f,	0xb160,	0xb161,	0xd0f0,	NODEST,	0xb162,	0xb163,	0xd0f1,
	/* 48 */
	0xd0f5,	0xb0ce,	0xb164,	NODEST,	0xb165,	NODEST,	0xb166,	0xcad0,
	/* 50 */
	0xd0f4,	0xb167,	0xb168,	0xb169,	NODEST,	0xd0f3,	0xd0f7,	0xb16a,
	/* 58 */
	NODEST,	0xb16b,	0xd0f6,	NODEST,	0xc4e4,	NODEST,	NODEST,	0xb16c,
	/* 60 */
	0xb16d,	NODEST,	0xb16e,	0xb16f,	NODEST,	0xb7f2,	0xb170,	0xb171,
	/* 68 */
	NODEST,	NODEST,	0xb172,	NODEST,	0xd0f8,	0xb173,	NODEST,	NODEST,
	/* 70 */
	0xb174,	0xb175,	0xbcc5,	NODEST,	0xc2a6,	0xc4e5,	0xb6f6,	NODEST,
	/* 78 */
	0xd0f9,	NODEST,	NODEST,	NODEST,	NODEST,	0xb5b6,	NODEST,	NODEST,
	/* 80 */
	0xd0fa,	0xb177,	NODEST,	0xb178,	0xb179,	0xd0fc,	0xb17a,	NODEST,
	/* 88 */
	NODEST,	NODEST,	0xb17b,	NODEST,	NODEST,	0xcbb5,	0xb17c,	0xb17d,
	/* 90 */
	0xb17e,	0xb7e6,	0xb221,	0xb222,	0xb223,	NODEST,	0xb224,	NODEST,
	/* 98 */
	0xbbb1,	0xc8f7,	0xd0fb,	0xb225,	0xb226,	NODEST,	0xb227,	0xb228,
	/* A0 */
	0xb229,	0xb22a,	0xb22b,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	0xb22c,	NODEST,	0xbac5,	0xcdc3,	NODEST,	0xb22d,
	/* B0 */
	0xb22e,	NODEST,	0xd0fe,	0xd1a3,	0xd0fd,	0xbac4,	NODEST,	0xbdfd,
	/* B8 */
	NODEST,	0xb22f,	0xb230,	NODEST,	NODEST,	0xb231,	0xb7b9,	NODEST,
	/* C0 */
	0xb232,	NODEST,	0xd1a4,	0xb233,	0xb234,	0xb6cf,	NODEST,	0xb235,
	/* C8 */
	NODEST,	0xd1a1,	0xd1a2,	NODEST,	0xb236,	0xc6af,	0xb237,	0xc1fc,
	/* D0 */
	0xb238,	0xb6a3,	NODEST,	0xb239,	0xb23a,	0xcbcd,	0xd1a5,	NODEST,
	/* D8 */
	0xb23b,	NODEST,	0xcebd,	NODEST,	0xb23c,	0xb23d,	0xd1a6,	0xb23e,
	/* E0 */
	NODEST,	NODEST,	0xb23f,	0xd1a9,	0xb240,	0xd1a7,	0xb241,	0xc1ce,
	/* E8 */
	0xb242,	0xb243,	NODEST,	NODEST,	NODEST,	0xd1a8,	0xd1aa,	0xb244,
	/* F0 */
	NODEST,	0xb245,	0xb251,	NODEST,	0xf430,	0xd1ac,	0xb246,	NODEST,
	/* F8 */
	NODEST,	0xd1ab,	0xb247,	0xcac8,	NODEST,	NODEST,	0xb248,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_51[] = {
	/* 00 */
	0xb5b7,	0xd1ae,	0xd1af,	0xb249,	0xb2af,	NODEST,	0xb24a,	0xb24b,
	/* 08 */
	0xb24c,	0xd1ad,	NODEST,	0xb24d,	0xb24e,	0xb24f,	0xb250,	NODEST,
	/* 10 */
	0xb252,	NODEST,	0xbcf4,	NODEST,	0xd1b2,	0xd1b1,	0xd1b0,	0xb253,
	/* 18 */
	0xd0d6,	0xb254,	0xd1b3,	0xb255,	0xb256,	0xb257,	0xb258,	0xbdfe,
	/* 20 */
	NODEST,	0xd1b4,	NODEST,	0xb259,	NODEST,	NODEST,	NODEST,	0xb25a,
	/* 28 */
	0xb25b,	NODEST,	0xcda5,	NODEST,	0xb25c,	0xb25d,	NODEST,	0xb25e,
	/* 30 */
	NODEST,	0xb25f,	0xccd9,	0xb260,	0xb261,	0xb262,	NODEST,	0xd1b6,
	/* 38 */
	0xb263,	0xb264,	0xd1b5,	0xd1b8,	0xd1b7,	NODEST,	NODEST,	0xd1b9,
	/* 40 */
	0xd1ba,	0xb0f4,	0xb265,	0xb8b5,	0xb7bb,	0xbdbc,	0xc3fb,	0xb6a4,
	/* 48 */
	0xc0e8,	0xb8f7,	0xb266,	0xb9ee,	0xd1bc,	0xccc8,	0xc5c6,	0xb267,
	/* 50 */
	0xbbf9,	NODEST,	0xd1bb,	0xb268,	0xd1bd,	0xb269,	NODEST,	0xb26a,
	/* 58 */
	0xb26b,	NODEST,	0xc5de,	NODEST,	0xb3f5,	NODEST,	NODEST,	0xb26c,
	/* 60 */
	NODEST,	NODEST,	0xd1be,	NODEST,	0xb26d,	0xc6fe,	0xb26e,	NODEST,
	/* 68 */
	0xc1b4,	0xd1c0,	0xd1c1,	0xc8ac,	0xb8f8,	0xcfbb,	0xd1c2,	NODEST,
	/* 70 */
	NODEST,	0xb6a6,	NODEST,	NODEST,	NODEST,	0xcabc,	0xc2b6,	0xb6f1,
	/* 78 */
	0xc5b5,	NODEST,	NODEST,	NODEST,	0xb7f3,	NODEST,	0xb26f,	NODEST,
	/* 80 */
	0xd1c3,	NODEST,	0xd1c4,	0xb270,	0xb271,	0xc6e2,	0xb1df,	NODEST,
	/* 88 */
	NODEST,	0xd1c7,	0xbafd,	0xb272,	0xd1c6,	0xbac6,	0xb273,	0xd1c8,
	/* 90 */
	0xe6ee,	0xd1c9,	0xcbc1,	0xd1ca,	NODEST,	0xd1cb,	0xd1cc,	0xbee9,
	/* 98 */
	0xb274,	0xbccc,	NODEST,	NODEST,	NODEST,	0xb275,	NODEST,	NODEST,
	/* A0 */
	0xb4a7,	0xb276,	0xd1cf,	0xb277,	0xd1cd,	0xccbd,	0xd1ce,	NODEST,
	/* A8 */
	0xc9da,	0xd1d0,	0xd1d1,	0xd1d2,	0xc5df,	0xb278,	NODEST,	NODEST,
	/* B0 */
	0xd1d6,	0xd1d4,	0xd1d5,	0xd1d3,	0xbae3,	0xd1d7,	0xccea,	0xcee4,
	/* B8 */
	0xb279,	NODEST,	0xb27a,	NODEST,	0xb27b,	0xd1d8,	0xb27c,	0xb27d,
	/* C0 */
	NODEST,	NODEST,	0xb27e,	NODEST,	0xc0a8,	0xd1d9,	0xbdda,	NODEST,
	/* C8 */
	0xb321,	0xd1da,	NODEST,	0xc3fc,	0xcebf,	0xc5e0,	NODEST,	0xb322,
	/* D0 */
	NODEST,	0xb323,	0xb324,	0xb325,	NODEST,	0xb326,	0xd2c5,	NODEST,
	/* D8 */
	0xb327,	NODEST,	NODEST,	0xd1db,	0xf4a5,	0xb6c5,	0xb328,	NODEST,
	/* E0 */
	0xd1dc,	0xcbde,	0xb329,	NODEST,	NODEST,	0xb32a,	0xbde8,	0xc2fc,
	/* E8 */
	NODEST,	0xd1de,	0xc6e4,	NODEST,	0xf431,	0xd1df,	0xb32b,	NODEST,
	/* F0 */
	0xd1e0,	0xb3ae,	0xb32c,	0xb32d,	0xb32e,	0xd1e1,	0xb6a7,	0xb32f,
	/* F8 */
	0xc6cc,	0xb1fa,	0xbdd0,	NODEST,	NODEST,	0xc8a1,	0xd1e2,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_52[] = {
	/* 00 */
	0xc5e1,	0xb330,	0xb331,	0xbfcf,	0xd1e3,	0xb332,	0xcaac,	0xc0da,
	/* 08 */
	0xb4a2,	NODEST,	0xb4a9,	0xd1e4,	NODEST,	NODEST,	0xd1e6,	NODEST,
	/* 10 */
	NODEST,	0xb7ba,	0xb333,	0xb334,	0xd1e5,	0xb335,	0xb336,	0xcef3,
	/* 18 */
	0xb337,	NODEST,	NODEST,	NODEST,	NODEST,	0xbde9,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	0xb338,	NODEST,	0xc8bd,	0xcacc,	NODEST,	0xd1e7,
	/* 28 */
	0xb339,	0xcdf8,	0xd1e8,	NODEST,	NODEST,	NODEST,	0xd1e9,	NODEST,
	/* 30 */
	0xc5fe,	0xb33a,	0xb33b,	0xd1ea,	NODEST,	0xb33c,	0xc0a9,	0xbafe,
	/* 38 */
	0xb7f4,	0xd1eb,	0xbbc9,	0xb9ef,	0xb33d,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xc4e6,	0xd1ed,	0xb33e,	NODEST,	0xc2a7,
	/* 48 */
	NODEST,	0xb33f,	0xbaef,	0xd1ee,	0xd1ef,	0xc1b0,	NODEST,	0xd1ec,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd1f1,	0xb340,	0xcbb6,	0xb341,
	/* 58 */
	0xb342,	NODEST,	0xb343,	0xb9e4,	0xb344,	NODEST,	0xd1f0,	0xb345,
	/* 60 */
	0xb346,	0xb347,	NODEST,	0xb7f5,	0xbade,	0xc7ed,	0xb348,	NODEST,
	/* 68 */
	NODEST,	0xd1f4,	0xd1f2,	NODEST,	NODEST,	NODEST,	0xb349,	0xc9fb,
	/* 70 */
	0xbeea,	0xd1fb,	0xb3e4,	0xd1f5,	0xd1f3,	0xc1cf,	NODEST,	0xb34a,
	/* 78 */
	0xb34b,	0xb34c,	NODEST,	NODEST,	NODEST,	0xd1f7,	NODEST,	0xd1f6,
	/* 80 */
	0xb34d,	NODEST,	0xb34e,	0xb3c4,	NODEST,	0xb34f,	NODEST,	0xb7e0,
	/* 88 */
	0xd1fc,	0xcead,	0xb350,	NODEST,	0xb351,	0xd1f8,	NODEST,	NODEST,
	/* 90 */
	NODEST,	0xd1fd,	0xd1fa,	0xb352,	0xd1f9,	0xb353,	0xb354,	0xb355,
	/* 98 */
	0xb356,	NODEST,	0xb357,	0xcecf,	0xb358,	NODEST,	NODEST,	0xb8f9,
	/* A0 */
	0xb2c3,	NODEST,	NODEST,	0xcef4,	0xb359,	0xb35a,	0xb35b,	0xb35c,
	/* A8 */
	NODEST,	0xbdf5,	0xc5d8,	0xb9e5,	0xd2a2,	0xd2a3,	NODEST,	0xb35d,
	/* B0 */
	0xb35e,	0xcee5,	NODEST,	NODEST,	0xcfab,	0xd2a5,	0xb35f,	0xb360,
	/* B8 */
	0xb361,	0xb8fa,	0xb362,	0xb363,	0xd2a4,	0xb364,	0xb3af,	NODEST,
	/* C0 */
	0xb365,	0xd2a6,	NODEST,	0xcbd6,	0xb366,	0xc4bc,	0xb367,	0xcda6,
	/* C8 */
	0xb368,	0xcad9,	NODEST,	NODEST,	0xb369,	0xd2a7,	NODEST,	0xb36a,
	/* D0 */
	NODEST,	0xb36b,	0xf0d5,	NODEST,	0xb36c,	0xc6b0,	0xb36d,	0xd2a8,
	/* D8 */
	0xb4aa,	0xccb3,	NODEST,	0xb36e,	0xb36f,	0xbea1,	0xd2a9,	0xcae7,
	/* E0 */
	0xd2ad,	0xb370,	0xc0aa,	0xd2aa,	0xb6d0,	0xb371,	0xd2ab,	0xb4ab,
	/* E8 */
	0xb372,	0xb373,	0xb374,	NODEST,	0xb375,	NODEST,	NODEST,	NODEST,
	/* F0 */
	0xb376,	0xb377,	0xb7ae,	0xd2ae,	0xb378,	0xd2af,	0xb379,	0xb37a,
	/* F8 */
	0xd2b0,	0xd2b1,	0xbcdb,	NODEST,	NODEST,	NODEST,	0xb8fb,	0xccde,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_53[] = {
	/* 00 */
	0xb37b,	0xcce8,	0xc6f7,	0xb37c,	NODEST,	0xcaf1,	0xd2b2,	0xf432,
	/* 08 */
	0xd2b3,	NODEST,	0xb37d,	0xb37e,	0xb421,	0xd2b5,	NODEST,	0xd2b7,
	/* 10 */
	0xd2b6,	0xb422,	NODEST,	0xb423,	NODEST,	0xd2b8,	0xb2bd,	0xcbcc,
	/* 18 */
	0xb424,	0xbafc,	0xd2b9,	0xb425,	0xb426,	0xc1d9,	0xb427,	0xb428,
	/* 20 */
	0xbea2,	0xb6a9,	NODEST,	0xd2ba,	0xf433,	0xb429,	NODEST,	0xb42a,
	/* 28 */
	0xb42b,	0xb42c,	0xc8db,	0xb42d,	0xb42e,	0xb42f,	NODEST,	0xd2bb,
	/* 30 */
	0xb430,	0xd2bc,	0xb431,	0xd2bd,	NODEST,	0xb432,	NODEST,	NODEST,
	/* 38 */
	0xd2be,	0xc9a4,	0xb6e8,	0xb0e5,	0xb433,	0xb434,	0xb435,	0xc6bf,
	/* 40 */
	0xd2bf,	0xbdbd,	0xb436,	0xc0e9,	NODEST,	0xd2c1,	0xd2c0,	0xbea3,
	/* 48 */
	0xb8e1,	0xd2c3,	0xc8be,	0xb438,	0xb437,	0xd2c4,	NODEST,	NODEST,
	/* 50 */
	NODEST,	0xc8dc,	0xc2b4,	0xc2ee,	0xb6a8,	NODEST,	NODEST,	0xc6ee,
	/* 58 */
	0xc3b1,	0xb439,	0xc7ee,	0xb43a,	0xcbce,	NODEST,	0xd2c6,	NODEST,
	/* 60 */
	0xc0ea,	0xb43b,	NODEST,	0xb43c,	NODEST,	0xb43d,	0xb7b5,	NODEST,
	/* 68 */
	NODEST,	0xd2c7,	NODEST,	NODEST,	0xb43e,	0xb43f,	0xd2c8,	0xb1ac,
	/* 70 */
	0xb0f5,	0xb4ed,	0xb440,	0xc2a8,	0xb5d1,	0xcdf1,	NODEST,	0xd2cb,
	/* 78 */
	0xb2b7,	0xb441,	NODEST,	0xd2ca,	NODEST,	NODEST,	0xb442,	0xb6aa,
	/* 80 */
	NODEST,	NODEST,	0xd2cc,	0xb443,	0xccf1,	NODEST,	NODEST,	0xb444,
	/* 88 */
	0xb445,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb446,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	0xb447,	0xb448,	NODEST,	0xd2cd,	NODEST,
	/* 98 */
	0xced2,	0xb449,	0xb8fc,	NODEST,	NODEST,	0xb44a,	NODEST,	0xb8b6,
	/* A0 */
	0xd2ce,	0xb44b,	NODEST,	NODEST,	0xb44c,	0xd2d0,	0xd2cf,	NODEST,
	/* A8 */
	0xbfdf,	0xb1b9,	0xb44d,	0xb44e,	NODEST,	0xb1de,	0xd2d1,	0xb44f,
	/* B0 */
	0xd2d2,	NODEST,	0xb450,	0xb8b7,	0xb451,	0xb452,	0xd2d3,	0xb453,
	/* B8 */
	0xb454,	NODEST,	0xb455,	0xb5ee,	NODEST,	0xb456,	NODEST,	NODEST,
	/* C0 */
	0xb457,	NODEST,	0xbbb2,	0xd2d4,	NODEST,	0xb458,	NODEST,	NODEST,
	/* C8 */
	0xcbf4,	0xbab5,	0xb5da,	0xcda7,	0xc1d0,	0xc8bf,	0xbcfd,	0xb459,
	/* D0 */
	NODEST,	NODEST,	0xb45a,	0xb45b,	0xbdc7,	0xb45c,	0xbce8,	0xbcf5,
	/* D8 */
	NODEST,	0xbdf6,	0xb45d,	0xc8c0,	NODEST,	0xb45e,	0xb45f,	0xd2d7,
	/* E0 */
	0xb460,	0xb1c3,	0xc1d1,	0xb8fd,	0xb8c5,	0xb6e7,	0xb461,	0xb462,
	/* E8 */
	0xd2db,	0xc3a1,	0xc2fe,	0xb6ab,	0xbea4,	0xd2dc,	0xd2da,	0xb2c4,
	/* F0 */
	0xc2e6,	0xbcb8,	0xbbcb,	0xb1a6,	NODEST,	0xb463,	0xb3f0,	0xb9e6,
	/* F8 */
	0xbbca,	NODEST,	0xd2dd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_54[] = {
	/* 00 */
	NODEST,	0xd2de,	0xb464,	0xb5c9,	0xb3c6,	NODEST,	NODEST,	NODEST,
	/* 08 */
	0xb9e7,	0xb5c8,	0xc4df,	0xb1a5,	0xc6b1,	0xccbe,	0xb9a1,	0xcdf9,
	/* 10 */
	0xc5c7,	0xb8fe,	NODEST,	0xb465,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	0xb466,	0xb7af,	NODEST,	0xd2e7,	NODEST,	0xb6e3,
	/* 20 */
	0xcbca,	0xb467,	NODEST,	NODEST,	NODEST,	NODEST,	0xc8dd,	0xb468,
	/* 28 */
	0xb469,	0xd2e6,	0xb46a,	0xb4de,	0xd2e1,	0xd2e2,	0xd2e4,	0xb46b,
	/* 30 */
	NODEST,	0xb46c,	NODEST,	NODEST,	0xb46d,	0xb46e,	0xd2e5,	NODEST,
	/* 38 */
	0xb5db,	0xbfe1,	NODEST,	0xcaad,	0xd2e3,	0xd2df,	0xb8e3,	NODEST,
	/* 40 */
	0xd2e0,	NODEST,	0xcfa4,	0xb46f,	0xb470,	NODEST,	0xcaf2,	0xb471,
	/* 48 */
	0xc4e8,	0xb8e2,	0xb9f0,	NODEST,	NODEST,	0xb472,	0xd2e8,	0xb473,
	/* 50 */
	NODEST,	0xc6dd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb474,	0xd2ec,
	/* 60 */
	NODEST,	NODEST,	0xb475,	NODEST,	0xb476,	NODEST,	0xb477,	0xb478,
	/* 68 */
	0xbcfe,	0xb479,	0xbcf6,	0xb47a,	NODEST,	0xb47b,	0xb47c,	NODEST,
	/* 70 */
	0xd2ef,	0xd2ed,	NODEST,	0xcca3,	0xb47d,	0xd2ea,	0xd2f3,	0xd2ee,
	/* 78 */
	NODEST,	NODEST,	NODEST,	0xd2f1,	0xb8c6,	0xccbf,	NODEST,	0xb47e,
	/* 80 */
	0xd2f2,	0xb521,	NODEST,	0xb522,	0xd2f4,	0xb523,	0xd2f6,	NODEST,
	/* 88 */
	0xb524,	0xb525,	0xf435,	0xbaf0,	0xcfc2,	0xb526,	0xd2eb,	0xd2e9,
	/* 90 */
	0xd2f5,	0xb527,	0xd2f0,	NODEST,	NODEST,	0xb528,	0xb529,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xb52a,	NODEST,	NODEST,	0xb52b,
	/* A0 */
	NODEST,	0xb52c,	0xd2f8,	NODEST,	0xd3a3,	0xd2fa,	0xb52d,	0xb52e,
	/* A8 */
	0xd2fe,	0xb52f,	0xb530,	0xd3a1,	0xd2fb,	0xb531,	0xb532,	0xd3be,
	/* B0 */
	NODEST,	0xb533,	0xbae9,	0xb3b1,	NODEST,	NODEST,	NODEST,	0xb534,
	/* B8 */
	0xd2f9,	0xb535,	0xb536,	0xb537,	0xd3a5,	0xb0f6,	0xd3a4,	0xb538,
	/* C0 */
	0xb0a5,	0xc9ca,	0xd3a2,	NODEST,	0xd2fc,	NODEST,	0xb539,	0xd2f7,
	/* C8 */
	0xd2fd,	0xbac8,	0xb53a,	NODEST,	NODEST,	0xb53b,	0xb53c,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	0xd3a6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	0xb53d,	0xb0f7,	0xd3af,	NODEST,	NODEST,	0xd3a7,	0xd3a8,	NODEST,
	/* E8 */
	0xbea5,	0xcbe9,	0xb53e,	NODEST,	0xb53f,	0xd3ad,	0xd3ac,	0xb540,
	/* F0 */
	NODEST,	NODEST,	0xc5af,	NODEST,	NODEST,	NODEST,	0xb541,	NODEST,
	/* F8 */
	NODEST,	NODEST,	0xd3ae,	NODEST,	0xb542,	0xd3ab,	0xb543,	0xb544,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_55[] = {
	/* 00 */
	0xb545,	0xb546,	NODEST,	NODEST,	0xb1b4,	0xb547,	0xbab6,	0xbfb0,
	/* 08 */
	0xb548,	0xb549,	NODEST,	NODEST,	0xb54a,	0xb54b,	0xb54c,	0xd3a9,
	/* 10 */
	0xc5e2,	NODEST,	NODEST,	NODEST,	0xd3aa,	0xb54d,	0xb0a2,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	0xb54e,	0xb54f,	NODEST,	NODEST,	0xd3b4,	0xcda3,
	/* 30 */
	NODEST,	0xbea7,	0xb550,	0xd3ba,	NODEST,	0xb551,	0xb552,	NODEST,
	/* 38 */
	0xd3b9,	0xd3b0,	NODEST,	0xb553,	0xb554,	0xb555,	0xc2c3,	NODEST,
	/* 40 */
	0xd3b1,	0xb556,	NODEST,	NODEST,	0xc2ef,	0xd3b6,	0xbea6,	0xb557,
	/* 48 */
	NODEST,	0xb558,	0xb559,	NODEST,	0xd3b3,	0xb55a,	NODEST,	0xcce4,
	/* 50 */
	0xb55b,	0xb55c,	NODEST,	0xb7bc,	NODEST,	NODEST,	0xd3b7,	0xd3b8,
	/* 58 */
	0xb55d,	NODEST,	0xb55e,	0xb55f,	0xd3b5,	0xd3bb,	0xb560,	NODEST,
	/* 60 */
	0xb561,	0xb562,	NODEST,	0xd3b2,	0xb563,	NODEST,	0xb564,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	0xd3c1,	0xd3c6,	NODEST,	0xd3c2,	0xb565,
	/* 80 */
	0xd3bd,	0xb566,	0xb567,	0xd3c7,	0xc1b1,	NODEST,	0xb568,	0xd3c9,
	/* 88 */
	0xb569,	0xb9a2,	0xd3bf,	0xc3fd,	NODEST,	NODEST,	0xb56a,	0xb56b,
	/* 90 */
	NODEST,	0xb56c,	0xb56d,	0xb56e,	0xb56f,	NODEST,	NODEST,	0xb570,
	/* 98 */
	0xd3c3,	0xd3bc,	0xb4ad,	NODEST,	0xb4ee,	0xb3e5,	0xd3c4,	0xd3c0,
	/* A0 */
	NODEST,	NODEST,	NODEST,	0xb571,	0xb572,	NODEST,	NODEST,	0xb7f6,
	/* A8 */
	0xd3ca,	0xd3c8,	0xc1d3,	0xb5ca,	0xb6ac,	0xb573,	0xd3c5,	NODEST,
	/* B0 */
	0xb6f4,	NODEST,	0xb574,	NODEST,	NODEST,	NODEST,	0xb1c4,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb575,
	/* C0 */
	NODEST,	0xb576,	NODEST,	0xb577,	0xd3ce,	0xd3cc,	0xb578,	0xd4a7,
	/* C8 */
	NODEST,	0xb579,	NODEST,	0xb57a,	0xb57b,	NODEST,	0xb57c,	NODEST,
	/* D0 */
	NODEST,	0xb57d,	0xb57e,	0xb621,	0xd3d1,	NODEST,	NODEST,	0xb622,
	/* D8 */
	0xb623,	NODEST,	0xd3cb,	0xb624,	0xd3cf,	NODEST,	0xb625,	0xd3cd,
	/* E0 */
	NODEST,	NODEST,	0xb626,	0xbbcc,	0xd3d0,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	0xb627,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb628,	0xd3d3,
	/* F8 */
	NODEST,	0xd3d8,	NODEST,	NODEST,	NODEST,	0xd3d6,	0xd3d5,	0xb629,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_56[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb62a,	0xc3b2,	NODEST,
	/* 08 */
	0xb62b,	0xb2c5,	0xb62c,	NODEST,	NODEST,	0xb62d,	0xb62e,	0xb62f,
	/* 10 */
	0xb630,	0xb631,	0xb632,	NODEST,	0xd3d2,	NODEST,	0xd3d4,	0xbea8,
	/* 18 */
	0xb1b3,	0xb633,	NODEST,	0xd3d7,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	0xb2de,	NODEST,	NODEST,	0xb634,	NODEST,	NODEST,	0xd3e2,
	/* 30 */
	0xb635,	0xbefc,	0xd3de,	0xb636,	0xd3dc,	0xb637,	0xd3dd,	0xb638,
	/* 38 */
	0xd3df,	0xb639,	NODEST,	0xb63a,	0xb63b,	0xb63c,	NODEST,	0xb63d,
	/* 40 */
	0xb63e,	0xb63f,	0xb1bd,	0xb640,	0xb641,	NODEST,	0xb642,	NODEST,
	/* 48 */
	NODEST,	0xb643,	NODEST,	0xb644,	0xc1b9,	0xb645,	0xd3d9,	0xb646,
	/* 50 */
	0xd3da,	NODEST,	NODEST,	NODEST,	0xb647,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	0xb3fa,	NODEST,	NODEST,	0xb648,	NODEST,
	/* 60 */
	0xb649,	0xb64a,	0xb64b,	0xb64c,	0xd3e1,	NODEST,	0xb64d,	NODEST,
	/* 68 */
	0xb4ef,	0xb64e,	0xd3e4,	0xd3e0,	0xd3e3,	0xb64f,	NODEST,	0xb650,
	/* 70 */
	NODEST,	0xb651,	0xb652,	NODEST,	0xcaae,	0xb653,	NODEST,	NODEST,
	/* 78 */
	0xc6d5,	NODEST,	0xc8b8,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	0xd3e6,	NODEST,	NODEST,	NODEST,	0xb654,	0xb655,	0xd3e5,	0xb3c5,
	/* 88 */
	0xb656,	NODEST,	0xd3e7,	0xb657,	0xb658,	NODEST,	NODEST,	0xd3ea,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd3e9,	0xb659,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xb65a,	0xb65b,	NODEST,	NODEST,	0xb65c,	0xb65d,	0xb65e,
	/* A0 */
	0xd3e8,	NODEST,	0xc7b9,	NODEST,	NODEST,	0xd3eb,	0xb65f,	0xb660,
	/* A8 */
	0xb661,	0xb662,	NODEST,	0xb663,	0xb664,	0xb665,	0xd3ec,	NODEST,
	/* B0 */
	NODEST,	0xb666,	NODEST,	0xb667,	0xd3ee,	NODEST,	0xd3ed,	0xb668,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd3f0,	NODEST,	0xb669,	NODEST,
	/* C0 */
	0xd3f3,	0xd3f1,	0xd3ef,	0xd3f2,	NODEST,	0xb66a,	NODEST,	NODEST,
	/* C8 */
	0xd3f4,	0xb66b,	0xb66c,	0xb66d,	0xb670,	0xb671,	0xd3f5,	0xb66e,
	/* D0 */
	0xb66f,	0xd3f6,	NODEST,	0xd3f7,	NODEST,	NODEST,	NODEST,	0xd3f8,
	/* D8 */
	0xd1c5,	0xb672,	0xbcfc,	0xbbcd,	0xb673,	0xb674,	0xb2f3,	0xb675,
	/* E0 */
	0xb0f8,	0xb676,	NODEST,	0xc3c4,	0xb677,	0xb678,	0xb679,	0xb67a,
	/* E8 */
	0xb67b,	NODEST,	NODEST,	0xb67d,	NODEST,	0xb67e,	0xd3f9,	NODEST,
	/* F0 */
	0xbaa4,	0xb67c,	0xb0cf,	0xbfde,	NODEST,	NODEST,	0xb721,	0xb722,
	/* F8 */
	NODEST,	0xd3fa,	0xb8c7,	NODEST,	NODEST,	0xb9f1,	NODEST,	0xd3fc,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_57[] = {
	/* 00 */
	0xd3fb,	0xb723,	0xb724,	0xcae0,	0xd3fd,	NODEST,	NODEST,	0xb725,
	/* 08 */
	0xd4a1,	0xd3fe,	0xb726,	0xd4a2,	0xb727,	0xd4a3,	NODEST,	0xb7f7,
	/* 10 */
	NODEST,	0xb728,	0xb1e0,	0xd4a4,	NODEST,	0xb729,	0xd4a6,	NODEST,
	/* 18 */
	0xd4a5,	NODEST,	0xb72a,	0xb72b,	0xd4a8,	0xb72c,	NODEST,	0xc5da,
	/* 20 */
	0xb72d,	NODEST,	0xb72e,	0xb72f,	0xb730,	0xb731,	0xd4a9,	0xb0b5,
	/* 28 */
	0xbadf,	0xb732,	0xb733,	NODEST,	0xb734,	0xb7bd,	0xb735,	0xb736,
	/* 30 */
	0xc3cf,	NODEST,	NODEST,	0xb737,	0xb738,	NODEST,	NODEST,	0xd4aa,
	/* 38 */
	0xd4ab,	NODEST,	NODEST,	0xd4ad,	NODEST,	0xb739,	0xb73a,	0xb73b,
	/* 40 */
	0xd4ae,	NODEST,	0xbae4,	NODEST,	NODEST,	0xb73c,	0xb73d,	0xb6d1,
	/* 48 */
	NODEST,	NODEST,	0xcbb7,	NODEST,	0xb73e,	0xb73f,	0xd4ac,	0xd4af,
	/* 50 */
	0xbac1,	0xb9a3,	0xb740,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xf436,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	0xd4b3,	0xb741,	NODEST,	0xbaa5,	0xb742,	0xc3b3,	0xb743,
	/* 68 */
	0xb744,	0xd4b0,	0xc4da,	0xb745,	NODEST,	0xb746,	0xb747,	0xb748,
	/* 70 */
	0xb749,	0xb74a,	NODEST,	0xb74b,	0xb74c,	0xb74d,	NODEST,	0xb74e,
	/* 78 */
	NODEST,	0xb74f,	0xb750,	0xb751,	0xb752,	NODEST,	0xb753,	0xd4b4,
	/* 80 */
	NODEST,	0xb754,	0xbfe2,	0xb755,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	0xd4b2,	0xd4b5,	NODEST,	0xb7bf,	0xb756,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	0xd4b6,	0xb757,	0xb760,	NODEST,	0xb758,
	/* 98 */
	NODEST,	0xb759,	0xb75a,	NODEST,	0xb75b,	0xb75c,	0xb75d,	0xb75e,
	/* A0 */
	0xd4b7,	0xb75f,	0xb9a4,	0xb3c0,	0xd4b9,	NODEST,	NODEST,	0xb761,
	/* A8 */
	0xb762,	0xb763,	0xd4ba,	NODEST,	0xb764,	NODEST,	NODEST,	NODEST,
	/* B0 */
	0xd4bb,	NODEST,	NODEST,	0xd4b8,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xb765,	NODEST,	NODEST,	NODEST,	NODEST,	0xb766,	NODEST,	NODEST,
	/* C0 */
	0xd4b1,	NODEST,	NODEST,	0xd4bc,	NODEST,	NODEST,	0xd4bd,	0xb767,
	/* C8 */
	0xb768,	NODEST,	NODEST,	0xcbe4,	0xb769,	NODEST,	0xbeeb,	0xb76a,
	/* D0 */
	NODEST,	NODEST,	0xd4bf,	0xd4c0,	0xd4be,	0xb76b,	0xd4c2,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc7b8,	0xb76c,	0xb76d,	0xb0e8,
	/* E0 */
	0xc9d6,	0xb77e,	NODEST,	0xd4c3,	0xb76e,	NODEST,	0xb76f,	0xb770,
	/* E8 */
	NODEST,	0xb771,	NODEST,	NODEST,	NODEST,	0xb772,	NODEST,	NODEST,
	/* F0 */
	0xb773,	NODEST,	NODEST,	NODEST,	0xbefd,	0xb774,	0xb775,	0xbcb9,
	/* F8 */
	0xb776,	0xc7dd,	0xb4f0,	NODEST,	0xbaeb,	0xb777,	0xb778,	0xb779,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_58[] = {
	/* 00 */
	0xcbd9,	NODEST,	0xc6b2,	0xb77a,	0xb77b,	0xb7f8,	0xc2cf,	NODEST,
	/* 08 */
	0xb77c,	0xb77d,	0xd4c1,	0xd4c4,	0xb821,	0xb822,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc2c4,	NODEST,	NODEST,
	/* 18 */
	NODEST,	0xd4c5,	NODEST,	0xb823,	NODEST,	0xd4c6,	0xb824,	0xb825,
	/* 20 */
	0xb826,	0xd4c8,	NODEST,	NODEST,	0xc4e9,	NODEST,	0xb827,	0xb828,
	/* 28 */
	NODEST,	NODEST,	0xb4ae,	NODEST,	NODEST,	0xb829,	NODEST,	0xf4a1,
	/* 30 */
	0xb1e1,	0xcaf3,	0xb82a,	NODEST,	0xbeec,	0xc5c8,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xb82b,	0xbae6,	NODEST,	NODEST,	0xd4ce,	NODEST,	0xb82c,
	/* 40 */
	0xcabd,	0xcedd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	0xb82d,	0xb2f4,	0xd4ca,	0xb82e,	0xb82f,	NODEST,	0xb830,
	/* 50 */
	0xb831,	0xc1ba,	0xd4cd,	NODEST,	0xc5e3,	0xb832,	NODEST,	0xc5c9,
	/* 58 */
	0xc5e4,	0xc8b9,	0xc4cd,	NODEST,	NODEST,	NODEST,	0xbac9,	0xb833,
	/* 60 */
	NODEST,	0xb834,	0xd4c9,	NODEST,	0xb835,	NODEST,	NODEST,	0xb836,
	/* 68 */
	0xb837,	0xb1f6,	NODEST,	0xc5b6,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xd4cb,	NODEST,	0xd4c7,	NODEST,	NODEST,	0xbfd0,	NODEST,	NODEST,
	/* 78 */
	0xb838,	0xd4cf,	NODEST,	NODEST,	0xb839,	NODEST,	0xbdce,	0xb83a,
	/* 80 */
	0xb83b,	0xb83c,	NODEST,	0xb6ad,	NODEST,	0xd4d0,	NODEST,	0xb83d,
	/* 88 */
	0xb83e,	0xb83f,	0xb840,	NODEST,	0xb841,	0xb842,	NODEST,	0xb843,
	/* 90 */
	0xb844,	NODEST,	NODEST,	0xcae8,	0xb845,	NODEST,	0xb846,	0xc1fd,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc4c6,	0xb847,	0xf439,	0xd4d2,
	/* A0 */
	0xb848,	0xb849,	0xb84a,	NODEST,	NODEST,	NODEST,	0xb84b,	NODEST,
	/* A8 */
	0xcbcf,	0xb84c,	NODEST,	0xd4d3,	NODEST,	NODEST,	0xd4d8,	NODEST,
	/* B0 */
	NODEST,	0xb84d,	0xb84e,	0xcaaf,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xd4d7,	0xd4d1,	0xd4d4,	0xd4d6,	0xb850,	NODEST,	0xbaa6,	NODEST,
	/* C0 */
	NODEST,	0xcac9,	0xb851,	NODEST,	0xb84f,	0xd4d9,	NODEST,	0xc3c5,
	/* C8 */
	0xb852,	NODEST,	0xb2f5,	NODEST,	0xbeed,	0xb853,	0xb854,	NODEST,
	/* D0 */
	0xb855,	0xd4db,	0xb856,	0xd4da,	0xb857,	0xb9e8,	0xb858,	0xd4dc,
	/* D8 */
	0xd4de,	0xd4dd,	0xb859,	NODEST,	0xd4e0,	0xb85a,	0xd4d5,	0xd4e2,
	/* E0 */
	NODEST,	0xb85b,	0xb85c,	NODEST,	0xd4e1,	0xd4df,	NODEST,	NODEST,
	/* E8 */
	NODEST,	0xb85d,	NODEST,	0xbbce,	0xbfd1,	NODEST,	0xc1d4,	0xd4e3,
	/* F0 */
	0xc0bc,	0xb0ed,	0xc7e4,	0xb85e,	NODEST,	NODEST,	NODEST,	0xc4db,
	/* F8 */
	NODEST,	0xd4e5,	0xd4e4,	0xd4e6,	0xd4e7,	0xd4e8,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_59[] = {
	/* 00 */
	NODEST,	NODEST,	0xd4e9,	NODEST,	NODEST,	0xb85f,	0xb860,	NODEST,
	/* 08 */
	NODEST,	0xcad1,	0xd4ea,	0xb861,	0xb862,	NODEST,	NODEST,	0xb2c6,
	/* 10 */
	0xd4eb,	NODEST,	0xb863,	0xb864,	0xb865,	0xcdbc,	0xb3b0,	NODEST,
	/* 18 */
	0xd2c9,	0xbdc8,	0xc2bf,	0xd4ec,	0xcceb,	0xb867,	NODEST,	NODEST,
	/* 20 */
	NODEST,	0xb868,	0xccb4,	0xb869,	0xb86a,	0xd4ee,	NODEST,	0xc2e7,
	/* 28 */
	0xb86b,	0xc5b7,	0xc2c0,	0xc9d7,	0xd4ef,	0xd4f0,	0xb1fb,	0xb86c,
	/* 30 */
	0xb86d,	0xbcba,	0xd4f1,	0xb86e,	NODEST,	0xb86f,	0xb870,	0xb0d0,
	/* 38 */
	0xd4f2,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd4f3,	0xb871,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xb872,	0xb1e2,	NODEST,	0xb873,	0xb4f1,
	/* 48 */
	0xc6e0,	0xcaf4,	NODEST,	NODEST,	NODEST,	NODEST,	0xd4f7,	0xc1d5,
	/* 50 */
	0xd4f6,	0xb7c0,	0xb874,	0xb875,	0xcbdb,	0xd4f5,	NODEST,	0xc5e5,
	/* 58 */
	0xd4f9,	0xb876,	0xd4f8,	0xb877,	NODEST,	0xb878,	0xb879,	0xb87a,
	/* 60 */
	0xd4fb,	0xb87b,	0xd4fa,	0xb87c,	NODEST,	0xb1fc,	NODEST,	0xd4fc,
	/* 68 */
	0xbea9,	0xd4fe,	0xc3a5,	0xb87d,	0xd4fd,	0xb87e,	0xcab3,	0xb921,
	/* 70 */
	NODEST,	NODEST,	0xb922,	0xbdf7,	0xc5db,	0xb923,	0xb924,	NODEST,
	/* 78 */
	0xd5a1,	0xb925,	NODEST,	0xb926,	0xb927,	0xb9a5,	NODEST,	NODEST,
	/* 80 */
	NODEST,	0xd5a2,	0xc7a1,	0xc8de,	0xccd1,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	0xc7a5,	0xb928,	0xb929,	0xd5ab,	0xb92a,	NODEST,
	/* 90 */
	NODEST,	NODEST,	0xb92b,	0xb5b8,	NODEST,	0xb92c,	0xcdc5,	0xb92d,
	/* 98 */
	NODEST,	0xccaf,	NODEST,	0xd6ac,	NODEST,	0xd5a3,	NODEST,	0xb92e,
	/* A0 */
	NODEST,	NODEST,	NODEST,	0xd5a6,	0xb92f,	0xc2c5,	NODEST,	0xb930,
	/* A8 */
	0xcbb8,	NODEST,	NODEST,	NODEST,	0xc5ca,	0xb931,	0xb932,	0xb933,
	/* B0 */
	0xb934,	NODEST,	0xd5a7,	0xb935,	NODEST,	NODEST,	NODEST,	0xb936,
	/* B8 */
	NODEST,	0xcbe5,	0xb937,	0xbaca,	0xb938,	NODEST,	0xbeaa,	NODEST,
	/* C0 */
	NODEST,	0xb939,	NODEST,	0xb93a,	0xb93b,	NODEST,	0xd5a8,	NODEST,
	/* C8 */
	0xb93c,	0xbbd0,	0xb93d,	0xbbcf,	NODEST,	0xb93e,	NODEST,	NODEST,
	/* D0 */
	0xb0b9,	0xb8c8,	0xb93f,	0xc0ab,	0xb0d1,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	0xd5ac,	0xd5ad,	NODEST,	0xd5aa,	0xb940,	0xb941,	0xb942,
	/* E0 */
	NODEST,	NODEST,	NODEST,	0xb943,	0xb944,	0xb1b8,	0xb4af,	0xb945,
	/* E8 */
	0xd5a9,	NODEST,	0xccc5,	0xc9b1,	NODEST,	NODEST,	0xb946,	0xb947,
	/* F0 */
	NODEST,	0xb948,	0xb949,	NODEST,	0xb94a,	NODEST,	0xb0a8,	0xb94b,
	/* F8 */
	NODEST,	NODEST,	NODEST,	0xb0f9,	NODEST,	NODEST,	NODEST,	0xbbd1,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5A[] = {
	/* 00 */
	0xb94c,	0xb0d2,	NODEST,	0xb0a3,	0xb94d,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	0xd5b2,	NODEST,	NODEST,	0xb94e,	0xb94f,	0xb950,	NODEST,
	/* 10 */
	NODEST,	0xd5b0,	0xb951,	0xb952,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	0xccbc,	NODEST,	0xd5b3,	NODEST,	0xd5b1,	NODEST,	0xb953,	0xd5af,
	/* 20 */
	0xbfb1,	NODEST,	NODEST,	0xb954,	0xb955,	0xd5ae,	NODEST,	0xb956,
	/* 28 */
	0xb957,	0xcada,	0xb958,	NODEST,	NODEST,	0xb959,	NODEST,	0xb8e4,
	/* 30 */
	0xb95a,	NODEST,	NODEST,	NODEST,	NODEST,	0xd5b7,	0xd5b8,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xbeab,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xd5b4,	0xcfac,	NODEST,	NODEST,	0xb95b,	0xb95c,	0xc7cc,	0xb95d,
	/* 48 */
	0xb95e,	0xd5b6,	NODEST,	NODEST,	0xb95f,	NODEST,	NODEST,	NODEST,
	/* 50 */
	0xb960,	NODEST,	NODEST,	NODEST,	NODEST,	0xb961,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	0xbaa7,	NODEST,	NODEST,	NODEST,	0xb962,	NODEST,
	/* 60 */
	NODEST,	NODEST,	0xd5b9,	0xb963,	NODEST,	0xb964,	0xc9d8,	0xb965,
	/* 68 */
	NODEST,	NODEST,	0xd5ba,	NODEST,	0xd5b5,	0xb966,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb967,
	/* 78 */
	NODEST,	NODEST,	0xb968,	0xb969,	NODEST,	NODEST,	0xb96a,	0xccbb,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	0xb96b,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	0xb96c,	NODEST,	0xc7de,	0xb96d,	NODEST,	NODEST,	0xb96e,	NODEST,
	/* 98 */
	NODEST,	0xb96f,	0xd5bb,	0xc9b2,	0xb970,	NODEST,	0xb971,	0xb972,
	/* A0 */
	0xb973,	NODEST,	0xb974,	NODEST,	NODEST,	NODEST,	NODEST,	0xb975,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xb976,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xb977,	0xb978,	0xb979,	NODEST,	0xb97a,	NODEST,	NODEST,
	/* B8 */
	0xb97b,	NODEST,	0xb97c,	0xb97d,	0xd5bc,	0xd5c0,	0xd5bd,	0xb97e,
	/* C0 */
	NODEST,	0xb2c7,	0xd5bf,	NODEST,	0xba21,	NODEST,	0xba22,	NODEST,
	/* C8 */
	0xba23,	0xbcbb,	NODEST,	0xd5be,	0xb7f9,	NODEST,	NODEST,	0xba24,
	/* D0 */
	0xd5cc,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd5c5,	0xd5c2,
	/* D8 */
	NODEST,	NODEST,	0xba25,	NODEST,	0xba26,	NODEST,	NODEST,	NODEST,
	/* E0 */
	0xba27,	0xc3e4,	NODEST,	0xd5c1,	NODEST,	0xba28,	0xd5c3,	NODEST,
	/* E8 */
	NODEST,	0xd5c4,	0xba29,	NODEST,	NODEST,	NODEST,	0xba2a,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xba2b,	0xba2c,	NODEST,
	/* F8 */
	NODEST,	NODEST,	0xd5c6,	0xd5c7,	NODEST,	0xba2d,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5B[] = {
	/* 00 */
	0xba2e,	0xba2f,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	0xba30,	0xb4f2,	NODEST,	0xd5c9,	0xd5c8,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd5ca,	0xba31,
	/* 18 */
	NODEST,	0xba33,	NODEST,	0xba34,	NODEST,	0xba35,	NODEST,	NODEST,
	/* 20 */
	NODEST,	0xba36,	0xbeee,	NODEST,	NODEST,	0xba37,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	0xd5cd,	NODEST,	0xc4dc,	0xba38,	NODEST,	NODEST,
	/* 30 */
	0xb1c5,	NODEST,	0xd5cb,	NODEST,	0xba32,	NODEST,	0xd5ce,	NODEST,
	/* 38 */
	0xba39,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd5cf,	NODEST,
	/* 40 */
	0xd5d2,	0xba3a,	NODEST,	0xd5d0,	NODEST,	0xd5d1,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xba3b,	0xba3c,	NODEST,	NODEST,	NODEST,
	/* 50 */
	0xbbd2,	0xd5d3,	0xba3d,	NODEST,	0xb9a6,	0xd5d4,	0xba3e,	0xbbfa,
	/* 58 */
	0xc2b8,	NODEST,	0xd5d5,	0xd5d6,	0xbbda,	0xb9a7,	0xba3f,	0xccd2,
	/* 60 */
	NODEST,	NODEST,	NODEST,	0xb5a8,	0xb8c9,	0xd5d7,	0xb3d8,	NODEST,
	/* 68 */
	0xba40,	0xd5d8,	NODEST,	0xc2b9,	NODEST,	NODEST,	0xba41,	0xba42,
	/* 70 */
	0xd5d9,	0xd6a3,	NODEST,	0xd5da,	NODEST,	0xd5db,	NODEST,	NODEST,
	/* 78 */
	0xd5dc,	NODEST,	0xd5de,	NODEST,	0xba43,	0xba44,	0xba45,	0xba46,
	/* 80 */
	0xd5df,	0xba47,	NODEST,	0xd5e0,	0xba48,	0xc2f0,	0xba49,	0xb1a7,
	/* 88 */
	0xbce9,	0xb0c2,	0xba4a,	0xc1d7,	0xb4b0,	0xbcb5,	0xba4b,	0xb9a8,
	/* 90 */
	0xba4c,	0xba4d,	NODEST,	0xba4e,	0xba4f,	0xc5e6,	0xba50,	0xbda1,
	/* 98 */
	0xb4b1,	0xc3e8,	0xc4ea,	0xb0b8,	0xb5b9,	0xcaf5,	NODEST,	0xbcc2,
	/* A0 */
	NODEST,	NODEST,	0xb5d2,	0xc0eb,	0xbcbc,	0xcda8,	0xd5e1,	NODEST,
	/* A8 */
	0xba51,	0xba52,	NODEST,	NODEST,	0xba53,	0xba54,	0xb5dc,	0xba55,
	/* B0 */
	0xbacb,	0xba56,	0xba57,	0xb3b2,	0xb1e3,	0xbeac,	0xb2c8,	0xba58,
	/* B8 */
	0xd5e2,	0xcdc6,	0xba59,	NODEST,	0xba5a,	NODEST,	NODEST,	0xbdc9,
	/* C0 */
	0xba5b,	0xba5c,	0xbce4,	0xd5e3,	0xb4f3,	0xc6d2,	0xcca9,	0xd5e4,
	/* C8 */
	NODEST,	0xd5e5,	NODEST,	NODEST,	0xc9d9,	0xba5d,	NODEST,	0xba5e,
	/* D0 */
	0xd5e7,	NODEST,	0xb4a8,	0xb6f7,	0xd5e6,	NODEST,	0xba5f,	0xba60,
	/* D8 */
	0xba61,	0xba62,	0xba63,	0xb4b2,	NODEST,	0xbfb2,	0xd5eb,	0xbba1,
	/* E0 */
	0xba64,	0xb2c9,	0xd5ea,	NODEST,	0xd5e8,	0xd5ec,	0xd5e9,	0xc7ab,
	/* E8 */
	0xdccd,	0xbfb3,	NODEST,	0xd5ed,	0xf43a,	NODEST,	0xcec0,	0xba65,
	/* F0 */
	0xd5ee,	0xba66,	NODEST,	0xd5f0,	0xba67,	0xc3fe,	0xd5ef,	NODEST,
	/* F8 */
	0xc0a3,	NODEST,	0xbbfb,	NODEST,	NODEST,	0xba68,	0xc2d0,	0xbcf7,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5C[] = {
	/* 00 */
	NODEST,	0xc9f5,	0xc0ec,	NODEST,	0xbccd,	0xd5f1,	0xbead,	0xd5f2,
	/* 08 */
	0xd5f3,	0xb0d3,	0xc2ba,	0xbfd2,	0xba69,	0xd5f4,	0xc6b3,	0xbeae,
	/* 10 */
	NODEST,	0xbeaf,	NODEST,	0xd5f5,	NODEST,	NODEST,	0xc0ed,	0xba6a,
	/* 18 */
	NODEST,	NODEST,	0xbeb0,	NODEST,	NODEST,	NODEST,	0xba6b,	0xba6c,
	/* 20 */
	0xd5f6,	NODEST,	0xd5f7,	0xba6d,	0xcce0,	NODEST,	0xba6e,	NODEST,
	/* 28 */
	0xd5f8,	0xba6f,	NODEST,	0xba70,	0xba71,	0xb6c6,	0xba72,	NODEST,
	/* 30 */
	0xba73,	0xbda2,	0xba74,	NODEST,	NODEST,	0xba75,	0xba76,	NODEST,
	/* 38 */
	0xd5f9,	0xd5fa,	0xbcdc,	0xbfac,	0xc6f4,	0xbfd4,	0xc8f8,	0xc7a2,
	/* 40 */
	0xb6c9,	0xd5fb,	NODEST,	NODEST,	NODEST,	0xb5ef,	0xd5fc,	NODEST,
	/* 48 */
	0xb6fe,	NODEST,	0xc6cf,	0xb2b0,	NODEST,	0xbbd3,	0xd5fd,	0xd6a2,
	/* 50 */
	0xd6a1,	0xb6fd,	NODEST,	0xd5fe,	NODEST,	0xc5b8,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xba77,	0xba78,	NODEST,	0xba79,	NODEST,	0xc2b0,	NODEST,
	/* 60 */
	0xc5cb,	0xbcc8,	0xba7a,	0xba7b,	0xc1d8,	0xcdfa,	NODEST,	0xba7c,
	/* 68 */
	0xba7d,	0xba7e,	NODEST,	NODEST,	0xd6a4,	0xbb21,	0xd6a5,	0xc6d6,
	/* 70 */
	0xbb22,	0xbbb3,	NODEST,	NODEST,	0xbb23,	0xbb24,	0xd6a7,	NODEST,
	/* 78 */
	NODEST,	0xd6a8,	0xbb25,	0xbb26,	0xbb27,	0xbb28,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbb29,
	/* 88 */
	0xbb2a,	NODEST,	0xbb2b,	NODEST,	0xd6a9,	NODEST,	NODEST,	0xbb2c,
	/* 90 */
	0xb4f4,	0xd6aa,	0xbb2d,	NODEST,	0xd6ab,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbb2e,	NODEST,	0xbb2f,
	/* A0 */
	0xbb30,	0xb2ac,	0xbb31,	0xbb32,	NODEST,	NODEST,	0xbb33,	NODEST,
	/* A8 */
	0xc1bb,	0xb4e4,	0xbb34,	0xd6ad,	0xcca8,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xc2d2,	0xbb35,	0xb3d9,	0xbb36,	0xbb37,	0xd6af,	0xd6b1,
	/* B8 */
	0xb4df,	NODEST,	0xbb38,	0xd6ae,	0xd6b0,	NODEST,	0xd6b3,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd6b2,	NODEST,	0xd6b4,
	/* C8 */
	NODEST,	0xbb39,	NODEST,	0xbb3a,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xbb3b,	NODEST,	NODEST,	NODEST,	NODEST,	0xbb3d,
	/* D8 */
	NODEST,	0xd6b5,	NODEST,	NODEST,	NODEST,	0xbb3c,	NODEST,	NODEST,
	/* E0 */
	0xc6bd,	0xb6ae,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xb2e5,	0xd6b6,	0xd6bb,	NODEST,	NODEST,	0xd6b9,	0xbb3e,	0xcaf7,
	/* F0 */
	0xcaf6,	0xbb3f,	0xbb40,	NODEST,	0xbb41,	0xf43b,	0xc5e7,	NODEST,
	/* F8 */
	NODEST,	NODEST,	0xd6b8,	0xbdd4,	NODEST,	0xd6b7,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5D[] = {
	/* 00 */
	NODEST,	0xbb42,	NODEST,	NODEST,	NODEST,	NODEST,	0xbb43,	0xbff2,
	/* 08 */
	NODEST,	NODEST,	NODEST,	0xd6bc,	NODEST,	0xbb44,	0xbaea,	NODEST,
	/* 10 */
	NODEST,	0xd6c2,	0xbb45,	NODEST,	0xd6c3,	0xd6bd,	0xb3b3,	0xd6be,
	/* 18 */
	0xd6c7,	0xd6c6,	0xd6c5,	0xd6c1,	NODEST,	NODEST,	NODEST,	0xd6c0,
	/* 20 */
	NODEST,	NODEST,	0xd6c4,	0xbb47,	0xbb48,	NODEST,	0xbb49,	0xbb4a,
	/* 28 */
	NODEST,	0xcaf8,	NODEST,	0xbb46,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	0xbb4b,	NODEST,	NODEST,	0xbb4c,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xbb4d,	NODEST,	NODEST,	NODEST,	0xbb4e,	NODEST,	0xbb4f,
	/* 40 */
	NODEST,	NODEST,	0xbb50,	0xbb51,	NODEST,	NODEST,	0xbb52,	NODEST,
	/* 48 */
	0xbb53,	NODEST,	0xbb57,	0xd6cb,	0xd6c8,	NODEST,	0xd6ca,	NODEST,
	/* 50 */
	0xcdf2,	0xbb55,	0xd6c9,	0xf43c,	NODEST,	0xbb54,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xbb56,	NODEST,	NODEST,	0xd6bf,	NODEST,	NODEST,	0xbb58,
	/* 60 */
	0xbb59,	0xbb5a,	0xbb5b,	NODEST,	0xbb5c,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	0xbff3,	0xbb5d,	NODEST,	0xd6cc,	0xbb5e,	NODEST,	0xbab7,
	/* 70 */
	0xbb5f,	NODEST,	NODEST,	0xd6cd,	NODEST,	NODEST,	0xd6ce,	NODEST,
	/* 78 */
	NODEST,	0xbb60,	0xbb61,	NODEST,	NODEST,	NODEST,	0xbb62,	0xbb63,
	/* 80 */
	NODEST,	0xbb64,	0xd6d1,	0xbb65,	0xd6d0,	NODEST,	NODEST,	0xd6cf,
	/* 88 */
	0xbb66,	NODEST,	0xbb67,	0xc5e8,	0xd6ba,	NODEST,	NODEST,	NODEST,
	/* 90 */
	0xd6d7,	NODEST,	0xbb68,	0xbb69,	0xbb6a,	0xbb6b,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xbb6c,	NODEST,	0xbb6d,	NODEST,	0xd6d3,	NODEST,	0xbb6e,
	/* A0 */
	0xbb6f,	NODEST,	0xd6d2,	NODEST,	NODEST,	NODEST,	NODEST,	0xbb70,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xbb71,	0xd6d4,	NODEST,	0xd6d5,	NODEST,
	/* B0 */
	0xbb72,	NODEST,	0xe674,	NODEST,	0xbb73,	NODEST,	NODEST,	0xd6d8,
	/* B8 */
	0xbb74,	0xbb75,	0xcee6,	NODEST,	0xd6d9,	0xd6d6,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xbb76,	NODEST,	NODEST,	NODEST,	0xbb77,
	/* C8 */
	NODEST,	0xd6da,	NODEST,	0xbb78,	0xb4e0,	0xd6db,	0xbb7a,	NODEST,
	/* D0 */
	0xbb79,	NODEST,	0xd6dd,	0xd6dc,	NODEST,	NODEST,	0xd6de,	NODEST,
	/* D8 */
	0xbb7b,	0xbb7c,	NODEST,	0xd6df,	NODEST,	0xc0ee,	0xbda3,	NODEST,
	/* E0 */
	0xbb7d,	0xbde4,	NODEST,	0xc1e3,	0xbb7e,	0xb9a9,	0xbab8,	0xb9aa,
	/* E8 */
	0xb5f0,	0xbc21,	NODEST,	0xd6e0,	NODEST,	NODEST,	0xbab9,	NODEST,
	/* F0 */
	NODEST,	0xb8ca,	0xd6e1,	0xcca6,	0xc7c3,	0xd6e2,	NODEST,	0xb9ab,
	/* F8 */
	0xbc22,	0xbc23,	NODEST,	0xb4ac,	NODEST,	0xc3a7,	0xb6d2,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5E[] = {
	/* 00 */
	0xbc24,	NODEST,	0xbbd4,	0xc9db,	NODEST,	NODEST,	0xc8c1,	0xbc25,
	/* 08 */
	NODEST,	NODEST,	NODEST,	0xd6e3,	0xb4f5,	0xbc26,	NODEST,	NODEST,
	/* 10 */
	NODEST,	0xd6e6,	0xbc27,	NODEST,	0xbc28,	0xbc29,	0xc4a1,	NODEST,
	/* 18 */
	0xbc2a,	0xd6e5,	0xd6e4,	0xd6e7,	NODEST,	0xc4eb,	NODEST,	0xbc2b,
	/* 20 */
	0xbc2c,	NODEST,	NODEST,	NODEST,	NODEST,	0xbfe3,	NODEST,	NODEST,
	/* 28 */
	0xbc2e,	NODEST,	NODEST,	0xbbd5,	NODEST,	0xc0ca,	0xbc2d,	0xc2d3,
	/* 30 */
	0xb5a2,	NODEST,	0xbc2f,	0xc4a2,	NODEST,	0xbc30,	0xd6e8,	0xd6e9,
	/* 38 */
	0xbeef,	NODEST,	NODEST,	NODEST,	NODEST,	0xcbb9,	0xbc31,	NODEST,
	/* 40 */
	0xd6ec,	NODEST,	NODEST,	0xd6eb,	0xd6ea,	0xc9fd,	NODEST,	0xd6f3,
	/* 48 */
	NODEST,	0xbc34,	NODEST,	0xbc32,	0xcbda,	NODEST,	0xd6ed,	NODEST,
	/* 50 */
	0xbc33,	0xbc35,	NODEST,	NODEST,	0xd6ef,	0xcbeb,	0xbc36,	0xd6ee,
	/* 58 */
	0xbc37,	NODEST,	NODEST,	0xbc38,	0xbc39,	NODEST,	0xbc3a,	0xd6f0,
	/* 60 */
	NODEST,	0xc8a8,	0xd6f1,	0xcabe,	0xd6f2,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xbc3b,	NODEST,	0xbc3c,	0xbc3d,	0xbc3e,	0xbc3f,	0xbc40,	NODEST,
	/* 70 */
	0xbc41,	NODEST,	0xb4b3,	0xcabf,	0xc7af,	0xd6f4,	0xd6f5,	NODEST,
	/* 78 */
	0xb9ac,	0xb4b4,	0xd6f6,	0xb8b8,	0xcdc4,	0xcda9,	0xb4f6,	0xd6f8,
	/* 80 */
	0xbc42,	0xc4a3,	NODEST,	0xb9ad,	0xbeb1,	NODEST,	NODEST,	0xc8df,
	/* 88 */
	NODEST,	NODEST,	0xbeb2,	0xbc43,	NODEST,	NODEST,	0xbc44,	0xbdf8,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc4ec,	0xcaf9,	0xc5b9,
	/* 98 */
	NODEST,	NODEST,	0xb9ae,	NODEST,	0xc9dc,	NODEST,	NODEST,	NODEST,
	/* A0 */
	0xd6f9,	NODEST,	0xbc45,	NODEST,	0xbc46,	0xbc47,	0xc5d9,	0xbac2,
	/* A8 */
	0xbc48,	NODEST,	0xbc49,	0xb8cb,	0xbc4a,	0xc4ed,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xbc4b,	NODEST,	0xbc4c,	NODEST,	0xb0c3,	0xbdee,	0xb9af,
	/* B8 */
	0xcdc7,	NODEST,	NODEST,	NODEST,	NODEST,	0xbc4d,	0xbc4e,	0xbc4f,
	/* C0 */
	NODEST,	0xd6fa,	0xd6fb,	0xc7d1,	NODEST,	NODEST,	0xbc50,	NODEST,
	/* C8 */
	0xd6fc,	0xcef7,	0xcfad,	0xbc52,	0xbc51,	NODEST,	0xbc53,	0xd6fe,
	/* D0 */
	0xd6fd,	0xbc54,	0xbc55,	0xb3c7,	0xbc56,	0xbc57,	0xd7a1,	NODEST,
	/* D8 */
	NODEST,	NODEST,	0xd7a4,	0xd7a5,	0xbc58,	0xd7a3,	0xbc59,	0xc9c0,
	/* E0 */
	0xbeb3,	0xd7a7,	0xd7a6,	0xd7a2,	NODEST,	0xbc5a,	NODEST,	NODEST,
	/* E8 */
	0xd7a8,	0xd7a9,	NODEST,	0xbc5b,	0xd7aa,	NODEST,	NODEST,	NODEST,
	/* F0 */
	0xd7ad,	0xd7ab,	NODEST,	0xd7ac,	0xd7ae,	NODEST,	0xb1e4,	0xc4ee,
	/* F8 */
	0xd7af,	NODEST,	0xb7fa,	0xb2f6,	0xc7b6,	NODEST,	0xd7b0,	0xc6fb,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_5F[] = {
	/* 00 */
	NODEST,	0xcadb,	0xbc5c,	0xd7b1,	0xcfae,	NODEST,	0xbc5d,	0xbc5e,
	/* 08 */
	0xbc5f,	0xd7b2,	0xcac0,	0xd7b5,	0xd0a1,	0xd0b1,	0xbc60,	0xbcb0,
	/* 10 */
	0xc6f5,	0xd7b6,	NODEST,	0xb5dd,	0xc4a4,	0xb0fa,	0xd7b7,	0xcaa6,
	/* 18 */
	0xb9b0,	0xbc61,	NODEST,	0xc3d0,	0xbc62,	0xbc63,	NODEST,	0xc4ef,
	/* 20 */
	NODEST,	0xbc64,	0xbc65,	0xbc66,	0xbc67,	0xccef,	0xb8b9,	0xb8cc,
	/* 28 */
	0xbc68,	0xd7b8,	NODEST,	0xbc69,	0xbc6a,	0xd7b9,	0xbc6b,	0xd7bf,
	/* 30 */
	0xbc6c,	0xbce5,	NODEST,	NODEST,	0xbc6d,	0xc4a5,	0xbc6e,	0xb6af,
	/* 38 */
	0xd7ba,	NODEST,	NODEST,	0xbc6f,	0xc9ab,	0xbc70,	0xc3c6,	0xbc71,
	/* 40 */
	0xbc72,	0xd7bb,	NODEST,	NODEST,	0xbc73,	0xbc74,	NODEST,	0xbc75,
	/* 48 */
	0xd7bc,	NODEST,	0xb6b0,	NODEST,	0xd7bd,	0xbc76,	0xd7be,	NODEST,
	/* 50 */
	0xbc77,	0xd7c0,	NODEST,	0xc5f6,	0xbc78,	NODEST,	0xd7c1,	0xd7c2,
	/* 58 */
	0xbc79,	0xd7c3,	NODEST,	0xbc7a,	0xd7b4,	0xd7b3,	NODEST,	NODEST,
	/* 60 */
	0xbc7b,	0xd7c4,	0xb7c1,	0xbc7c,	0xbc7d,	NODEST,	0xc9a7,	0xbc7e,
	/* 68 */
	NODEST,	0xbacc,	0xc9b7,	0xc4a6,	0xc9cb,	0xd7c5,	NODEST,	0xbd21,
	/* 70 */
	0xbeb4,	0xb1c6,	0xbd22,	0xd7c6,	0xbd23,	0xbd24,	NODEST,	0xd7c7,
	/* 78 */
	0xbd25,	0xccf2,	0xbd26,	NODEST,	0xc8e0,	0xbd27,	0xbd28,	0xd7ca,
	/* 80 */
	0xb1fd,	0xc0ac,	0xd7c9,	0xd7c8,	0xb7c2,	0xc2d4,	NODEST,	0xd7ce,
	/* 88 */
	0xd7cc,	0xbd29,	0xd7cb,	0xcea7,	0xb8e5,	0xbd2a,	NODEST,	0xbd2b,
	/* 90 */
	0xbdf9,	0xd7cd,	0xc5cc,	0xbdbe,	NODEST,	NODEST,	0xbd2c,	0xc6c0,
	/* 98 */
	0xd7d1,	0xd7d0,	NODEST,	NODEST,	0xbd2d,	0xbd2e,	0xd7cf,	NODEST,
	/* A0 */
	0xd7d2,	0xb8e6,	0xbd2f,	NODEST,	0xbd32,	NODEST,	NODEST,	0xbd30,
	/* A8 */
	0xd7d3,	0xc9fc,	0xbddb,	0xbd31,	0xbd33,	0xd7d4,	0xc8f9,	0xbd34,
	/* B0 */
	0xbd35,	0xbd36,	NODEST,	0xc6c1,	0xc4a7,	NODEST,	NODEST,	0xf43e,
	/* B8 */
	0xbd37,	0xc5b0,	NODEST,	NODEST,	0xd7d5,	0xb5ab,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xbfb4,	0xbd38,	0xc9ac,	NODEST,	0xbd39,
	/* C8 */
	0xbd3a,	0xbd3b,	NODEST,	0xbd3c,	0xb4f7,	0xc7a6,	NODEST,	NODEST,
	/* D0 */
	0xbd3d,	0xbd3e,	0xbd3f,	0xbd40,	0xbd41,	NODEST,	0xd7d6,	0xbbd6,
	/* D8 */
	0xcbba,	0xcbbb,	NODEST,	NODEST,	0xb1fe,	0xd7db,	0xbd42,	NODEST,
	/* E0 */
	0xc3e9,	0xbd43,	0xbd44,	NODEST,	0xd7d8,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xbd45,	0xbd46,	0xbd47,	0xb2f7,	0xbd48,	0xbd49,	0xbd4a,	0xbd4b,
	/* F0 */
	0xd8ad,	0xd7da,	0xbd4c,	0xbd4d,	NODEST,	0xc7b0,	0xbd4e,	NODEST,
	/* F8 */
	0xd7d9,	NODEST,	0xbd4f,	0xd7d7,	0xbd50,	0xb9fa,	NODEST,	0xd7dd,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_60[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbd51,
	/* 08 */
	NODEST,	NODEST,	0xbd52,	NODEST,	NODEST,	0xbd53,	0xd7e3,	0xd7e9,
	/* 10 */
	0xd7e1,	NODEST,	0xc5dc,	0xbd54,	0xbd55,	0xd7e6,	0xc9dd,	0xbd56,
	/* 18 */
	0xbd57,	0xd7e0,	0xbd58,	0xd7e5,	0xcee7,	0xbbd7,	NODEST,	0xbd59,
	/* 20 */
	0xc2d5,	0xd7de,	NODEST,	NODEST,	0xbd5a,	0xb5de,	0xd7e8,	0xc0ad,
	/* 28 */
	0xb1e5,	0xd7e2,	0xb2f8,	0xd7e7,	NODEST,	0xbd5b,	NODEST,	0xb6b1,
	/* 30 */
	NODEST,	0xd7e4,	NODEST,	0xbd5c,	NODEST,	0xbd5d,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	0xd7ea,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xbd5e,	0xd7ec,	0xd7f6,	0xd7f4,	NODEST,	NODEST,	0xd7f1,	0xbd5f,
	/* 48 */
	0xbd60,	0xbd61,	0xd7f0,	0xcef8,	0xbd62,	0xd7f2,	NODEST,	NODEST,
	/* 50 */
	0xb6b2,	0xbd63,	0xb9b1,	NODEST,	0xbd64,	0xbdfa,	0xbd65,	0xbd66,
	/* 58 */
	NODEST,	0xd7f9,	0xd7eb,	NODEST,	NODEST,	0xbd67,	NODEST,	0xd7ef,
	/* 60 */
	0xd7df,	0xbd68,	0xb2fa,	0xd7f3,	0xd7f5,	0xc3d1,	NODEST,	0xbd69,
	/* 68 */
	0xbaa8,	0xb2b8,	0xd7ed,	0xd7f8,	0xd7f7,	0xb6b3,	NODEST,	0xc2a9,
	/* 70 */
	0xb3e6,	0xbd6a,	NODEST,	NODEST,	NODEST,	0xb7c3,	NODEST,	0xd7ee,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbd6b,	0xbd6c,
	/* 80 */
	NODEST,	0xd7fa,	0xbd6d,	0xd7fd,	0xd8a1,	0xf43f,	0xbd6e,	NODEST,
	/* 88 */
	0xbd6f,	0xbcbd,	0xbd70,	0xd8a7,	0xc4f0,	0xd7fb,	0xbd71,	NODEST,
	/* 90 */
	NODEST,	0xbd72,	0xd8a5,	0xbd73,	0xb2f9,	0xbd74,	0xd8a3,	0xd8a4,
	/* 98 */
	0xbd75,	NODEST,	0xd7fe,	0xd8a2,	NODEST,	0xbd76,	0xbd77,	0xb8e7,
	/* A0 */
	0xcdaa,	NODEST,	0xbd78,	0xb4b5,	0xbd79,	0xbd7a,	0xb1d9,	0xd8a6,
	/* A8 */
	0xbd7b,	0xc7ba,	0xb0ad,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	0xbd7c,	0xbd7d,	0xc8e1,	0xd7dc,	0xd8ac,	0xd8b0,	0xcce5,	0xbd7e,
	/* B8 */
	0xd8a9,	NODEST,	NODEST,	0xbe21,	0xc5e9,	0xd8ae,	0xbe22,	NODEST,
	/* C0 */
	NODEST,	NODEST,	0xbe23,	NODEST,	0xbe24,	0xbef0,	0xd8af,	0xc6d7,
	/* C8 */
	0xbe25,	0xbe26,	0xbe27,	0xbe28,	NODEST,	NODEST,	0xbe29,	0xbe2a,
	/* D0 */
	NODEST,	0xcfc7,	NODEST,	0xd8ab,	0xbe2b,	0xbe2c,	NODEST,	NODEST,
	/* D8 */
	0xd8b1,	0xbe2d,	0xb9fb,	0xbe2e,	0xc0cb,	0xbe2f,	0xbe30,	0xb0d4,
	/* E0 */
	0xd8aa,	0xd8a8,	0xbe31,	0xc1da,	NODEST,	0xbe32,	NODEST,	0xd7fc,
	/* E8 */
	0xbbb4,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	0xc2c6,	0xd8bd,	0xbe33,	0xc1db,	0xd8b8,	0xbe34,	0xd8b5,	0xd8b6,
	/* F8 */
	0xbe35,	0xbce6,	0xd8b9,	0xd8bc,	0xbe36,	0xbe37,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_61[] = {
	/* 00 */
	0xd8b7,	0xbda5,	0xbe38,	0xd8ba,	NODEST,	NODEST,	0xd8b4,	0xbe39,
	/* 08 */
	0xccfc,	0xccfb,	0xbe3a,	NODEST,	0xbe3b,	0xd8be,	0xd8bf,	0xb0d5,
	/* 10 */
	0xbe3c,	0xbe3d,	0xbe3e,	0xbe3f,	0xbe40,	0xd8b3,	0xbe41,	0xbe42,
	/* 18 */
	NODEST,	0xbe43,	0xb6f2,	0xb0a6,	0xbe44,	NODEST,	0xbe45,	0xb4b6,
	/* 20 */
	0xf440,	0xd8bb,	0xbe46,	NODEST,	NODEST,	NODEST,	NODEST,	0xd8c3,
	/* 28 */
	0xd8c2,	NODEST,	0xbe47,	0xbe48,	0xd8c7,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xbe49,	0xbe4a,	NODEST,	NODEST,	0xd8c8,	0xbe4b,	0xbe4c,	0xbe4d,
	/* 38 */
	NODEST,	0xbe4e,	NODEST,	NODEST,	0xd8c6,	0xd8c9,	0xd8c1,	0xd8c5,
	/* 40 */
	NODEST,	0xbe4f,	0xd8ca,	NODEST,	0xd8cb,	0xbe50,	0xbe51,	0xd8c0,
	/* 48 */
	0xbbfc,	0xbe52,	0xd8c4,	0xc2d6,	0xb9b2,	0xd8b2,	0xbfb5,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	0xd8d8,	NODEST,	0xcae9,	NODEST,	NODEST,
	/* 58 */
	0xd8ce,	0xd8cf,	0xd8d0,	NODEST,	NODEST,	0xd8d7,	0xbe53,	0xd8d6,
	/* 60 */
	0xbe54,	NODEST,	0xcbfd,	0xb4b7,	NODEST,	0xd8d4,	NODEST,	0xb7c5,
	/* 68 */
	0xb3b4,	NODEST,	NODEST,	0xd8d1,	0xbe55,	NODEST,	0xceb8,	0xd8d3,
	/* 70 */
	0xb0d6,	0xd8d5,	0xbe56,	0xd8cc,	0xd8d2,	0xd8d9,	0xb7c4,	0xd8cd,
	/* 78 */
	0xbe57,	NODEST,	NODEST,	0xbe58,	0xbe59,	NODEST,	0xcddd,	0xbe5a,
	/* 80 */
	0xbe5b,	0xbe5c,	0xcdab,	0xbe5d,	0xbe5e,	NODEST,	NODEST,	0xd8dc,
	/* 88 */
	NODEST,	NODEST,	0xd8e0,	0xbe5f,	NODEST,	0xbe60,	0xc1fe,	NODEST,
	/* 90 */
	0xcef9,	0xd8e1,	0xbe61,	0xbe62,	0xd8de,	NODEST,	0xd8db,	0xbe63,
	/* 98 */
	0xbe64,	0xd8da,	0xd8df,	NODEST,	0xbe65,	0xbe66,	NODEST,	0xbe67,
	/* A0 */
	0xbe68,	NODEST,	NODEST,	NODEST,	0xcab0,	0xbe69,	NODEST,	0xc6b4,
	/* A8 */
	0xbe6a,	0xb7c6,	0xbe6b,	0xd8e2,	0xd8dd,	0xbe6c,	0xd8e3,	NODEST,
	/* B0 */
	NODEST,	NODEST,	0xb7fb,	NODEST,	NODEST,	NODEST,	0xb2b1,	NODEST,
	/* B8 */
	0xbe6d,	0xbe6e,	0xd8eb,	NODEST,	0xbe6f,	NODEST,	0xb4b8,	NODEST,
	/* C0 */
	0xbe70,	0xbe71,	0xbe72,	0xd8e9,	NODEST,	NODEST,	0xd8ea,	0xbaa9,
	/* C8 */
	0xd8e8,	0xd8e6,	0xd8e5,	0xd8ec,	0xd8e4,	0xd8ee,	0xbe73,	0xbe74,
	/* D0 */
	0xb2fb,	NODEST,	NODEST,	NODEST,	NODEST,	0xbe75,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xbe76,	0xbe77,	0xbe78,	0xbe79,
	/* E0 */
	NODEST,	0xbe7a,	0xbe7b,	0xd8f0,	NODEST,	0xbe7e,	0xd8ef,	0xbe7c,
	/* E8 */
	NODEST,	0xbe7d,	NODEST,	NODEST,	0xbf21,	0xbf22,	NODEST,	0xbf23,
	/* F0 */
	NODEST,	NODEST,	0xc4a8,	NODEST,	0xd8f3,	NODEST,	0xd8f1,	0xd8e7,
	/* F8 */
	0xb7fc,	NODEST,	0xd8f2,	NODEST,	0xd8f6,	0xd8f5,	0xd8f7,	0xd8f4,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_62[] = {
	/* 00 */
	0xd8f8,	0xbf24,	NODEST,	0xbf25,	0xbf26,	NODEST,	NODEST,	0xbf27,
	/* 08 */
	0xd8f9,	0xd8fa,	0xcaea,	NODEST,	0xd8fc,	0xd8fb,	0xbdbf,	NODEST,
	/* 10 */
	0xc0ae,	0xb2e6,	0xb2fc,	0xbf28,	0xd8fd,	0xbf29,	0xb0bf,	NODEST,
	/* 18 */
	NODEST,	NODEST,	0xc0cc,	0xd8fe,	0xbf2a,	0xecc3,	0xd9a1,	0xb7e1,
	/* 20 */
	0xbf2b,	0xd9a2,	0xbf2c,	0xbf2d,	NODEST,	NODEST,	0xc0ef,	0xbf2e,
	/* 28 */
	NODEST,	0xbf2f,	0xd9a3,	0xbf30,	NODEST,	NODEST,	0xd9a4,	0xb5ba,
	/* 30 */
	0xd9a5,	NODEST,	0xd9a6,	0xd9a7,	0xc2d7,	NODEST,	NODEST,	NODEST,
	/* 38 */
	0xb8cd,	0xbf31,	NODEST,	0xcce1,	NODEST,	0xbf32,	NODEST,	0xcbbc,
	/* 40 */
	0xbdea,	0xd9a8,	0xbf33,	0xbf34,	0xbf35,	NODEST,	0xbf36,	0xc0f0,
	/* 48 */
	0xeebd,	0xc8e2,	NODEST,	0xbcea,	0xbf37,	0xbacd,	0xd9a9,	NODEST,
	/* 50 */
	0xbf38,	0xbf39,	0xbf3a,	0xc2c7,	0xbf3b,	0xcaa7,	0xbf3c,	NODEST,
	/* 58 */
	0xc2f1,	NODEST,	0xbf3d,	0xd9ac,	0xbf3e,	NODEST,	0xd9aa,	NODEST,
	/* 60 */
	0xd9ad,	NODEST,	NODEST,	0xd9ab,	0xbf3f,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xd9ae,	NODEST,	NODEST,	NODEST,	NODEST,	0xbf40,	0xcab1,	0xbf41,
	/* 70 */
	NODEST,	0xb0b7,	NODEST,	0xbf42,	NODEST,	NODEST,	0xc9de,	NODEST,
	/* 78 */
	NODEST,	0xc8e3,	0xbf43,	NODEST,	0xd9af,	0xbf44,	0xd9b2,	0xbeb5,
	/* 80 */
	0xb5bb,	NODEST,	0xd9b0,	0xd9b7,	0xbeb6,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	0xd9b1,	0xc7c4,	NODEST,	NODEST,	0xbf45,	0xbf46,	0xbf47,
	/* 90 */
	0xbf48,	0xcdde,	0xd9b3,	0xd9b4,	0xd9b8,	0xc5ea,	0xd9b5,	0xb9b3,
	/* 98 */
	0xc0de,	NODEST,	NODEST,	0xd9c6,	0xc8b4,	NODEST,	0xc2f2,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbf49,	NODEST,
	/* A8 */
	0xbf4a,	NODEST,	NODEST,	0xc8e4,	0xdaad,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xcafa,	NODEST,	0xbf4b,	NODEST,	0xc4f1,	0xbf4c,	0xbf4d,
	/* B8 */
	NODEST,	0xcbf5,	0xbf4e,	0xd9bb,	0xb2a1,	0xc3ea,	0xbf4f,	0xbf50,
	/* C0 */
	NODEST,	NODEST,	0xd9c4,	NODEST,	0xbf51,	0xc3b4,	0xd9be,	0xd9c5,
	/* C8 */
	0xd9c0,	0xd9c7,	0xd9c3,	NODEST,	0xd9c2,	0xc7ef,	0xbf52,	0xd9bc,
	/* D0 */
	0xb2fd,	0xd9ba,	0xb5f1,	0xc2f3,	0xd9b6,	0xbf53,	0xbf54,	0xd9b9,
	/* D8 */
	0xb9b4,	0xc0db,	0xbf55,	0xbeb7,	0xd9c1,	0xc7d2,	NODEST,	NODEST,
	/* E0 */
	0xb5f2,	0xb3c8,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	0xbf56,	NODEST,	0xb3e7,	0xbfa1,	0xd9c9,	0xd9ce,
	/* F0 */
	NODEST,	0xd9ca,	0xbf57,	0xb7fd,	0xbf58,	0xd9cf,	0xbba2,	0xb9e9,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xbf59,	0xbf5a,	0xbda6,	0xd9bd,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_63[] = {
	/* 00 */
	NODEST,	0xbbfd,	0xd9cc,	0xbf5b,	0xbf5c,	NODEST,	NODEST,	0xbbd8,
	/* 08 */
	0xd9cd,	0xb0c4,	0xbf5d,	0xbf5e,	0xd9c8,	0xbf5f,	NODEST,	NODEST,
	/* 10 */
	0xbf60,	0xc4a9,	NODEST,	0xbf61,	NODEST,	NODEST,	0xbf62,	NODEST,
	/* 18 */
	0xbf63,	0xb5f3,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb6b4,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd9cb,
	/* 28 */
	0xb0a7,	0xbf64,	0xbf65,	0xbac3,	NODEST,	0xbf66,	NODEST,	0xbfb6,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbf67,	0xbf68,	NODEST,
	/* 38 */
	NODEST,	0xbf69,	0xc4f2,	NODEST,	0xbf6a,	0xc8d4,	0xd9d1,	0xc1de,
	/* 40 */
	NODEST,	0xbf6b,	0xbf6c,	0xbf6d,	0xbf6e,	NODEST,	0xbf6f,	NODEST,
	/* 48 */
	NODEST,	0xc2aa,	0xbf70,	0xbf71,	0xbbab,	0xd9d2,	0xbf72,	0xd9d4,
	/* 50 */
	0xd9d0,	NODEST,	0xbf73,	0xbf74,	0xbf75,	0xcae1,	NODEST,	0xc4bd,
	/* 58 */
	0xbf76,	NODEST,	NODEST,	0xbf77,	0xc1dc,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbf78,	0xbf79,	0xcafb,
	/* 68 */
	0xbcce,	0xd9e0,	NODEST,	0xd9df,	0xbf7a,	0xbf7b,	0xbff8,	NODEST,
	/* 70 */
	NODEST,	0xbf7c,	0xb7fe,	NODEST,	0xbf7d,	0xbf7e,	0xd9d9,	0xbeb9,
	/* 78 */
	0xc021,	NODEST,	0xc6e8,	0xc7b1,	0xc022,	0xc023,	NODEST,	0xc024,
	/* 80 */
	0xd9d7,	NODEST,	0xc025,	0xc1dd,	0xc026,	NODEST,	NODEST,	0xc027,
	/* 88 */
	0xbcf8,	0xd9dc,	0xc028,	NODEST,	0xbeb8,	NODEST,	0xd9d6,	0xd9db,
	/* 90 */
	0xc029,	NODEST,	0xc7d3,	NODEST,	0xc02a,	0xc02b,	0xd9d5,	NODEST,
	/* 98 */
	0xb7a1,	0xc02c,	0xc02d,	0xb3dd,	NODEST,	NODEST,	0xc02e,	0xd9dd,
	/* A0 */
	0xceab,	0xbace,	0xc3b5,	0xd9da,	0xc02f,	0xc0dc,	0xc030,	0xb9b5,
	/* A8 */
	0xbfe4,	0xb1e6,	0xc1bc,	0xd9d8,	0xb5c5,	0xc031,	0xc032,	0xc033,
	/* B0 */
	NODEST,	NODEST,	0xb7c7,	NODEST,	0xc4cf,	0xd9de,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	0xc1df,	NODEST,	0xc034,	0xd9e1,	NODEST,
	/* C0 */
	0xd9e3,	0xc035,	NODEST,	0xc2b7,	0xd9e9,	0xc036,	0xd9e4,	NODEST,
	/* C8 */
	0xc037,	0xd9e6,	NODEST,	NODEST,	NODEST,	NODEST,	0xc038,	0xc9c1,
	/* D0 */
	0xc4f3,	0xc039,	0xd9e7,	0xc03a,	0xc03b,	0xc03c,	0xcdac,	NODEST,
	/* D8 */
	NODEST,	NODEST,	0xcdc8,	0xb4b9,	0xc03d,	NODEST,	NODEST,	NODEST,
	/* E0 */
	0xc03e,	0xb0ae,	NODEST,	0xd9e5,	NODEST,	0xc03f,	NODEST,	NODEST,
	/* E8 */
	NODEST,	0xd9e2,	0xc040,	NODEST,	0xc041,	NODEST,	0xb4f8,	NODEST,
	/* F0 */
	NODEST,	NODEST,	0xc042,	0xc043,	0xb1e7,	0xc044,	0xd9e8,	NODEST,
	/* F8 */
	0xc045,	0xc046,	0xcdc9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_64[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd9ec,	NODEST,
	/* 08 */
	NODEST,	0xc047,	0xc048,	NODEST,	NODEST,	0xc2bb,	NODEST,	0xd9f3,
	/* 10 */
	0xc049,	NODEST,	0xc04a,	0xd9ed,	0xc04b,	NODEST,	0xd9ea,	0xd9f1,
	/* 18 */
	0xc04c,	NODEST,	NODEST,	NODEST,	0xd9d3,	NODEST,	0xc04d,	NODEST,
	/* 20 */
	0xc04e,	NODEST,	0xc04f,	NODEST,	0xc050,	0xc051,	0xd9ee,	NODEST,
	/* 28 */
	0xd9f2,	0xc052,	0xc053,	NODEST,	0xc8c2,	0xc5eb,	NODEST,	0xc054,
	/* 30 */
	0xc055,	NODEST,	NODEST,	NODEST,	0xd9eb,	0xc056,	0xd9ef,	NODEST,
	/* 38 */
	NODEST,	NODEST,	0xb7c8,	NODEST,	NODEST,	0xc057,	0xbaf1,	0xc058,
	/* 40 */
	NODEST,	NODEST,	0xc0dd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xc059,	NODEST,	NODEST,	0xd9f7,	0xc05a,
	/* 50 */
	NODEST,	0xc05b,	0xc05c,	0xc05d,	0xc05e,	NODEST,	NODEST,	NODEST,
	/* 58 */
	0xc5a6,	NODEST,	0xc05f,	0xc060,	0xc061,	0xc062,	NODEST,	0xc063,
	/* 60 */
	0xc064,	0xc065,	NODEST,	0xc066,	NODEST,	NODEST,	NODEST,	0xd9f4,
	/* 68 */
	NODEST,	0xcbe0,	NODEST,	NODEST,	NODEST,	0xc067,	NODEST,	0xd9f5,
	/* 70 */
	NODEST,	NODEST,	NODEST,	0xc068,	0xc069,	NODEST,	0xd9f6,	NODEST,
	/* 78 */
	0xccce,	NODEST,	0xc0a2,	0xc06a,	NODEST,	0xc06b,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	0xb7e2,	NODEST,	0xc06c,	NODEST,	0xc06d,
	/* 88 */
	0xd9fd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc06e,
	/* 90 */
	0xc06f,	0xc070,	0xbbb5,	0xd9fa,	NODEST,	0xd9f9,	NODEST,	NODEST,
	/* 98 */
	0xc071,	0xc072,	0xc7b2,	0xc073,	NODEST,	0xc074,	0xc6b5,	0xc075,
	/* A0 */
	NODEST,	0xc076,	NODEST,	0xc077,	0xc5b1,	0xd9fb,	0xc078,	NODEST,
	/* A8 */
	0xc079,	0xd9fc,	NODEST,	0xc9ef,	0xc07a,	0xc7c5,	0xbba3,	NODEST,
	/* B0 */
	0xc0f1,	NODEST,	0xcbd0,	0xc07b,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	0xb3c9,	NODEST,	0xdaa5,	0xd9fe,	0xc07c,	0xc07d,	0xc07e,
	/* C0 */
	NODEST,	0xcdca,	0xdaa7,	NODEST,	0xc121,	0xdaa3,	NODEST,	0xdaa4,
	/* C8 */
	NODEST,	0xc122,	0xc123,	0xc124,	0xc125,	0xc1e0,	0xc126,	NODEST,
	/* D0 */
	0xc127,	0xc128,	0xdaa2,	NODEST,	0xd9bf,	0xc129,	NODEST,	0xc12a,
	/* D8 */
	0xdaa6,	NODEST,	0xdaa1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	0xdaab,	0xdaac,	0xc5a7,	0xdaae,	0xc12b,	0xc12c,	0xbba4,	0xdaa9,
	/* E8 */
	NODEST,	0xc12d,	0xc12e,	NODEST,	0xb5bc,	0xc12f,	NODEST,	0xdaaf,
	/* F0 */
	0xc130,	0xdaa8,	0xdab3,	NODEST,	0xdab2,	0xc131,	0xdab1,	0xc132,
	/* F8 */
	NODEST,	NODEST,	0xdab4,	0xc133,	NODEST,	0xdab6,	0xbef1,	0xc134,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_65[] = {
	/* 00 */
	0xdab5,	0xc135,	NODEST,	NODEST,	0xc136,	0xdab9,	NODEST,	NODEST,
	/* 08 */
	0xc137,	0xc138,	0xc139,	NODEST,	NODEST,	NODEST,	NODEST,	0xc13a,
	/* 10 */
	NODEST,	NODEST,	NODEST,	0xc13b,	0xc13c,	NODEST,	0xc13d,	NODEST,
	/* 18 */
	0xdab7,	0xc13e,	NODEST,	0xc13f,	0xdab8,	0xd9f0,	0xc140,	0xc141,
	/* 20 */
	NODEST,	NODEST,	0xc142,	0xdabb,	0xdaba,	NODEST,	0xc143,	NODEST,
	/* 28 */
	NODEST,	0xc144,	0xd9f8,	0xdabc,	0xdab0,	NODEST,	0xc145,	0xbbd9,
	/* 30 */
	NODEST,	0xc146,	NODEST,	NODEST,	0xdabd,	0xdabe,	0xdac0,	0xdabf,
	/* 38 */
	0xdac1,	0xb2fe,	0xc147,	0xb9b6,	0xc148,	0xc149,	0xcafc,	0xc0af,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xc14a,	NODEST,	0xb8ce,	NODEST,	0xc14b,
	/* 48 */
	0xdac3,	0xc14c,	NODEST,	NODEST,	NODEST,	0xdac6,	0xf441,	0xc9d2,
	/* 50 */
	0xc14d,	0xb5df,	0xc14e,	NODEST,	0xc14f,	0xdac5,	0xdac4,	0xc7d4,
	/* 58 */
	0xdac7,	0xb6b5,	NODEST,	NODEST,	NODEST,	0xdac9,	0xdac8,	0xc150,
	/* 60 */
	0xc151,	NODEST,	0xb4ba,	0xbbb6,	NODEST,	NODEST,	0xc6d8,	0xc152,
	/* 68 */
	NODEST,	NODEST,	NODEST,	0xc153,	0xb7c9,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xbff4,	NODEST,	0xdaca,	NODEST,	0xc0b0,	0xc5a8,	NODEST,	0xc9df,
	/* 78 */
	0xdacb,	NODEST,	0xc154,	NODEST,	NODEST,	0xc155,	NODEST,	NODEST,
	/* 80 */
	NODEST,	0xc156,	0xdacc,	0xdacd,	NODEST,	0xc157,	NODEST,	0xcab8,
	/* 88 */
	0xd5dd,	0xc0c6,	0xc158,	NODEST,	0xc9cc,	NODEST,	0xbad8,	NODEST,
	/* 90 */
	0xc8e5,	0xc8c3,	0xc159,	NODEST,	NODEST,	0xc15a,	NODEST,	0xc5cd,
	/* 98 */
	0xc15b,	0xcec1,	NODEST,	0xdacf,	0xbcd0,	0xc15c,	NODEST,	0xdad0,
	/* A0 */
	0xc15d,	0xb0b6,	NODEST,	0xc15e,	0xb6d4,	0xc0cd,	0xc15f,	0xc9e0,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xdad1,	0xbbc2,	0xc3c7,	0xc160,	0xbbdb,
	/* B0 */
	0xbfb7,	NODEST,	0xc161,	0xc162,	0xc163,	NODEST,	NODEST,	0xdad2,
	/* B8 */
	NODEST,	0xcafd,	NODEST,	NODEST,	0xb1f7,	0xbbdc,	NODEST,	0xc164,
	/* C0 */
	NODEST,	0xdad5,	0xc165,	0xdad3,	0xdad6,	0xceb9,	0xdad4,	NODEST,
	/* C8 */
	0xc166,	0xc167,	NODEST,	0xc0fb,	0xdad7,	NODEST,	0xc168,	0xc2b2,
	/* D0 */
	0xc169,	NODEST,	0xdad8,	NODEST,	0xc16a,	NODEST,	0xc16b,	0xb4fa,
	/* D8 */
	0xc16c,	0xdada,	NODEST,	0xdad9,	NODEST,	NODEST,	NODEST,	0xc16d,
	/* E0 */
	0xdadb,	0xdadc,	0xb4fb,	NODEST,	NODEST,	0xc6fc,	0xc3b6,	0xb5ec,
	/* E8 */
	0xbbdd,	0xc1e1,	NODEST,	NODEST,	0xbddc,	0xb0b0,	NODEST,	NODEST,
	/* F0 */
	0xc16e,	0xdadd,	0xc16f,	NODEST,	0xc170,	0xc171,	NODEST,	NODEST,
	/* F8 */
	NODEST,	0xc172,	0xb2a2,	0xdae1,	NODEST,	NODEST,	0xc173,	0xc174,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_66[] = {
	/* 00 */
	0xc175,	NODEST,	0xb9b7,	0xdae0,	0xc176,	NODEST,	0xbaab,	0xbeba,
	/* 08 */
	0xc177,	0xc178,	0xdadf,	NODEST,	0xbebb,	0xc179,	0xccc0,	0xbaaa,
	/* 10 */
	NODEST,	0xc17a,	0xc17b,	0xb0d7,	0xc0ce,	0xc17c,	0xc17d,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xdae6,	0xc17e,	0xc221,	0xc0b1,
	/* 20 */
	0xb1c7,	0xc222,	0xc223,	0xc224,	0xc225,	0xbdd5,	0xc226,	0xcbe6,
	/* 28 */
	0xbaf2,	0xc227,	0xc228,	0xc229,	0xc22a,	0xbebc,	0xc22b,	0xc0a7,
	/* 30 */
	0xc22c,	0xc22d,	NODEST,	0xc22e,	0xdae5,	0xdae3,	0xdae4,	0xc230,
	/* 38 */
	NODEST,	0xc22f,	NODEST,	0xf442,	0xc3eb,	NODEST,	NODEST,	0xdba6,
	/* 40 */
	0xc231,	0xdaea,	0xbbfe,	0xb9b8,	0xdae8,	0xc232,	0xc233,	NODEST,
	/* 48 */
	NODEST,	0xdae9,	0xc234,	0xbfb8,	0xc235,	NODEST,	0xc237,	0xdae7,
	/* 50 */
	NODEST,	0xc236,	0xbbaf,	NODEST,	NODEST,	NODEST,	NODEST,	0xc238,
	/* 58 */
	0xc239,	0xc23a,	NODEST,	0xc23b,	0xc23c,	0xdaec,	0xdaeb,	0xdaf0,
	/* 60 */
	0xc23d,	0xc23e,	0xdaf1,	NODEST,	0xdaed,	0xf443,	0xb3a2,	0xdaee,
	/* 68 */
	0xdaef,	0xc8d5,	0xc240,	0xc241,	0xc242,	NODEST,	0xc9e1,	0xb7ca,
	/* 70 */
	0xdaf2,	NODEST,	NODEST,	0xc244,	0xc0b2,	0xc245,	0xbebd,	0xc247,
	/* 78 */
	0xc248,	0xc249,	0xc3d2,	0xc24a,	0xc24c,	NODEST,	0xc243,	0xc246,
	/* 80 */
	0xc24b,	0xb6c7,	NODEST,	0xdaf3,	0xdaf7,	NODEST,	NODEST,	0xb2cb,
	/* 88 */
	0xdaf4,	0xdaf6,	NODEST,	0xc24d,	0xc24e,	0xc24f,	0xdaf5,	NODEST,
	/* 90 */
	0xc250,	0xbdeb,	0xc251,	NODEST,	NODEST,	NODEST,	0xc3c8,	0xb0c5,
	/* 98 */
	0xdaf8,	0xc252,	0xc253,	0xc254,	0xc255,	0xdaf9,	NODEST,	0xc256,
	/* A0 */
	0xc257,	NODEST,	0xc4aa,	NODEST,	0xc258,	NODEST,	0xcef1,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xbbc3,	NODEST,	0xc259,	0xcaeb,	NODEST,
	/* B0 */
	NODEST,	0xc25a,	0xc25b,	NODEST,	0xcbbd,	0xc25c,	NODEST,	NODEST,
	/* B8 */
	0xdba2,	0xdafb,	NODEST,	0xc25d,	0xdafe,	NODEST,	0xdafd,	0xc25e,
	/* C0 */
	0xc25f,	0xdafa,	0xc260,	0xc261,	0xdba1,	NODEST,	NODEST,	0xc6de,
	/* C8 */
	0xc262,	0xdafc,	NODEST,	NODEST,	0xc263,	NODEST,	0xc264,	0xc265,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc266,	NODEST,	0xdba3,	NODEST,
	/* D8 */
	NODEST,	0xbdec,	0xdba4,	0xc267,	0xcdcb,	0xc7f8,	NODEST,	0xc268,
	/* E0 */
	0xdba5,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdba7,	NODEST,
	/* E8 */
	0xc269,	0xdba8,	NODEST,	0xc26a,	0xc26b,	NODEST,	0xc26c,	NODEST,
	/* F0 */
	0xdba9,	NODEST,	0xb6ca,	0xb1c8,	0xb9b9,	0xdbaa,	NODEST,	0xdbab,
	/* F8 */
	0xbdf1,	0xc1e2,	0xc26d,	0xc23f,	0xd2d8,	0xc1be,	0xc1bd,	0xc2d8,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_67[] = {
	/* 00 */
	0xbac7,	NODEST,	NODEST,	0xd0f2,	NODEST,	0xc26e,	NODEST,	0xc26f,
	/* 08 */
	0xb7ee,	0xcdad,	NODEST,	0xcafe,	NODEST,	0xc9fe,	0xc270,	0xdbac,
	/* 10 */
	NODEST,	NODEST,	NODEST,	0xc271,	0xbaf3,	0xc4bf,	0xdbad,	0xcfaf,
	/* 18 */
	NODEST,	0xc272,	NODEST,	0xcbbe,	0xc273,	0xc4ab,	0xdbae,	0xb4fc,
	/* 20 */
	0xc274,	NODEST,	0xc275,	NODEST,	NODEST,	NODEST,	0xdbaf,	0xdbb0,
	/* 28 */
	0xccda,	NODEST,	0xcca4,	0xcbf6,	0xcbdc,	0xbba5,	0xdbb2,	NODEST,
	/* 30 */
	NODEST,	0xbceb,	NODEST,	0xc276,	0xcbd1,	NODEST,	0xdbb4,	0xdbb7,
	/* 38 */
	0xdbb6,	NODEST,	0xb4f9,	NODEST,	NODEST,	0xb5e0,	0xc277,	0xdbb3,
	/* 40 */
	NODEST,	0xdbb5,	NODEST,	NODEST,	NODEST,	0xc278,	0xdbb8,	0xc279,
	/* 48 */
	0xc27a,	0xbff9,	NODEST,	NODEST,	0xc27b,	NODEST,	0xcdfb,	0xb0c9,
	/* 50 */
	0xbae0,	0xc2bc,	NODEST,	0xbcdd,	0xc27c,	0xc27d,	0xbef3,	NODEST,
	/* 58 */
	NODEST,	0xdbbb,	NODEST,	NODEST,	0xc5ce,	0xc27e,	0xdbb9,	0xc2ab,
	/* 60 */
	0xdbba,	0xbef2,	0xccdd,	0xdbbc,	0xdbbd,	0xcde8,	0xc321,	NODEST,
	/* 68 */
	NODEST,	NODEST,	0xdbc2,	NODEST,	0xc322,	0xb9ba,	0xc323,	0xc7d5,
	/* 70 */
	0xdbbf,	0xc5ec,	0xdade,	0xdae2,	0xc324,	0xb5cf,	0xc325,	0xc7c7,
	/* 78 */
	NODEST,	NODEST,	NODEST,	0xc326,	0xdbc1,	NODEST,	0xbebe,	0xc8c4,
	/* 80 */
	NODEST,	0xc327,	NODEST,	NODEST,	0xc328,	0xdbc7,	NODEST,	0xc8fa,
	/* 88 */
	NODEST,	0xdbbe,	NODEST,	0xdbc4,	0xdbc3,	NODEST,	0xc329,	0xc32a,
	/* 90 */
	0xc0cf,	0xc32b,	NODEST,	0xc32c,	NODEST,	0xcbed,	0xc32d,	0xced3,
	/* 98 */
	0xc32e,	0xc32f,	0xcbe7,	0xc330,	0xb2cc,	0xbbde,	NODEST,	NODEST,
	/* A0 */
	0xcfc8,	0xdbc6,	0xbff5,	NODEST,	NODEST,	NODEST,	0xdbc5,	NODEST,
	/* A8 */
	NODEST,	0xdbc0,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb8cf,
	/* B0 */
	0xc331,	0xc332,	0xc333,	0xdbcc,	0xdbca,	0xc334,	0xb2cd,	0xdbc8,
	/* B8 */
	0xdbce,	0xdbd4,	NODEST,	0xc335,	0xc336,	0xc337,	NODEST,	NODEST,
	/* C0 */
	0xc339,	0xc2c8,	0xc33a,	0xc33b,	0xcac1,	0xc33c,	0xdbd6,	NODEST,
	/* C8 */
	0xc33d,	0xc33e,	0xc9a2,	NODEST,	NODEST,	NODEST,	0xdbd5,	0xc7f0,
	/* D0 */
	0xcbbf,	0xb4bb,	0xc33f,	0xc0f7,	0xbdc0,	NODEST,	NODEST,	0xc340,
	/* D8 */
	0xc4d3,	0xc341,	0xcdae,	NODEST,	0xc342,	0xdbd1,	0xdbd0,	NODEST,
	/* E0 */
	NODEST,	0xc343,	0xdbd2,	NODEST,	0xdbcf,	NODEST,	0xc344,	0xdbd7,
	/* E8 */
	NODEST,	0xdbcd,	NODEST,	NODEST,	0xdbcb,	NODEST,	0xdbd3,	0xdbc9,
	/* F0 */
	0xc345,	0xc3ec,	0xc346,	0xccf8,	0xbcc6,	0xbaf4,	0xc347,	0xc348,
	/* F8 */
	NODEST,	0xc338,	NODEST,	0xbaba,	NODEST,	NODEST,	0xcbef,	0xb3c1,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_68[] = {
	/* 00 */
	NODEST,	0xf446,	0xc4ce,	0xc6ca,	0xb1c9,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	0xc0f2,	0xc34a,	NODEST,	0xc0b4,	0xb7aa,
	/* 18 */
	NODEST,	0xc34b,	NODEST,	NODEST,	NODEST,	0xc34c,	0xdbd9,	0xc34d,
	/* 20 */
	NODEST,	0xb9bb,	0xb3fc,	NODEST,	NODEST,	NODEST,	NODEST,	0xc34f,
	/* 28 */
	0xc34e,	0xdbdb,	0xb3f4,	0xdbe1,	0xc350,	0xc351,	NODEST,	0xc352,
	/* 30 */
	0xc353,	0xc354,	0xdbde,	0xc355,	0xc0f3,	NODEST,	NODEST,	NODEST,
	/* 38 */
	0xb3cb,	0xbaac,	NODEST,	0xc356,	0xb3ca,	0xbacf,	NODEST,	0xc357,
	/* 40 */
	0xdbdc,	0xb7e5,	0xb7cb,	0xc5ed,	0xc358,	0xc359,	0xdbda,	NODEST,
	/* 48 */
	0xb0c6,	NODEST,	0xc35a,	NODEST,	0xc35b,	0xdbdd,	0xdbdf,	NODEST,
	/* 50 */
	0xb6cd,	0xb7ac,	0xc349,	0xb4bc,	0xb5cb,	0xc35c,	NODEST,	0xc35d,
	/* 58 */
	0xc35e,	0xdbe2,	NODEST,	0xc35f,	0xbaf9,	0xcbf1,	NODEST,	0xbbb7,
	/* 60 */
	NODEST,	NODEST,	NODEST,	0xdbe3,	NODEST,	NODEST,	NODEST,	0xc9b0,
	/* 68 */
	NODEST,	NODEST,	NODEST,	0xc360,	NODEST,	NODEST,	0xc361,	0xc362,
	/* 70 */
	0xc363,	0xc364,	0xc365,	NODEST,	0xdbef,	0xc366,	0xb2b3,	0xdbe4,
	/* 78 */
	NODEST,	0xc367,	0xc368,	0xc369,	0xc36a,	NODEST,	0xdbf5,	0xdbe5,
	/* 80 */
	NODEST,	0xcec2,	0xc36b,	0xdbec,	0xc36c,	0xc7df,	0xc36d,	NODEST,
	/* 88 */
	0xc36e,	NODEST,	NODEST,	NODEST,	NODEST,	0xdbf4,	NODEST,	0xdbe7,
	/* 90 */
	NODEST,	NODEST,	NODEST,	0xb0b4,	0xdbe9,	NODEST,	0xc36f,	0xb9bc,
	/* 98 */
	0xc370,	NODEST,	0xc371,	0xdbeb,	0xc372,	0xdbea,	NODEST,	0xdbe6,
	/* A0 */
	0xdbf1,	0xc373,	0xbebf,	0xc374,	NODEST,	0xc375,	0xd4ed,	0xb8e8,
	/* A8 */
	0xcdfc,	0xc376,	0xc377,	NODEST,	NODEST,	0xdbe8,	0xc378,	0xc4f4,
	/* B0 */
	0xb3a3,	0xbaad,	0xc379,	0xdbe0,	NODEST,	0xdbf0,	0xb3e1,	NODEST,
	/* B8 */
	NODEST,	0xdbee,	0xdbf2,	0xc37a,	0xc5ee,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xb4fe,	0xc37b,	0xdcb2,	NODEST,
	/* C8 */
	0xc37c,	0xccc9,	0xdbf7,	0xb4fd,	0xc37d,	0xdbfe,	NODEST,	0xc37e,
	/* D0 */
	0xc421,	0xc422,	0xcbc0,	0xc423,	0xdca1,	0xdca3,	0xc424,	0xdca7,
	/* D8 */
	0xdbf9,	0xc425,	0xc3aa,	NODEST,	0xc426,	0xc427,	NODEST,	0xc5ef,
	/* E0 */
	0xdcab,	0xdbfc,	NODEST,	0xdca8,	NODEST,	0xc428,	NODEST,	0xdca2,
	/* E8 */
	0xc429,	NODEST,	0xc42a,	0xc42b,	0xc42c,	0xc42d,	0xbfb9,	0xdcac,
	/* F0 */
	0xc42e,	0xc42f,	0xc0b3,	NODEST,	NODEST,	0xc430,	0xc431,	NODEST,
	/* F8 */
	NODEST,	0xdcaa,	0xb4bd,	0xc432,	0xc433,	0xc434,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_69[] = {
	/* 00 */
	0xcfd0,	0xdbf6,	NODEST,	NODEST,	0xdca6,	0xb0d8,	0xc435,	NODEST,
	/* 08 */
	0xdbf8,	0xc436,	0xc437,	0xccba,	0xdbfd,	0xbfa2,	0xc4c7,	0xdbf3,
	/* 10 */
	0xc438,	0xc439,	0xdca5,	0xc43a,	NODEST,	NODEST,	0xc43b,	0xc43c,
	/* 18 */
	NODEST,	0xbffa,	0xdcaf,	0xb3f1,	0xb8a1,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	0xdcb1,	0xdbfa,	0xdcb0,	NODEST,	0xdca9,	0xdbfb,	NODEST,
	/* 28 */
	0xdcad,	NODEST,	0xdcae,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xdcbf,	0xc43d,	NODEST,	0xc43e,	0xc6ce,	0xc43f,	0xdca4,	NODEST,
	/* 38 */
	0xc440,	0xdcbb,	NODEST,	0xc441,	NODEST,	0xdcbd,	NODEST,	0xc4d8,
	/* 40 */
	NODEST,	NODEST,	0xc442,	NODEST,	NODEST,	0xc443,	NODEST,	NODEST,
	/* 48 */
	NODEST,	0xc444,	0xcdcc,	NODEST,	NODEST,	NODEST,	0xc445,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	0xc9f6,	0xdcb8,	0xc2ca,	NODEST,	0xc446,
	/* 58 */
	NODEST,	0xdcbe,	0xc1bf,	0xc447,	0xdcb5,	0xdcc2,	0xdcc1,	NODEST,
	/* 60 */
	0xc6ef,	0xdcc0,	0xc6ea,	0xc448,	0xc449,	0xc44a,	0xc44b,	NODEST,
	/* 68 */
	0xc44c,	0xc44d,	0xdcc4,	0xdcb7,	0xc44e,	0xb6c8,	0xdcba,	0xbddd,
	/* 70 */
	0xc44f,	0xc450,	0xc451,	0xc7e0,	0xdcbc,	0xb6cb,	NODEST,	0xdcb4,
	/* 78 */
	0xdcb6,	0xdcb3,	0xc452,	0xc453,	0xcfb0,	0xb3da,	0xdcb9,	0xc454,
	/* 80 */
	0xc455,	0xdcc3,	0xb3b5,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	0xbae7,	NODEST,	NODEST,	0xc456,	0xb1dd,	NODEST,
	/* 90 */
	NODEST,	0xdcd4,	0xc457,	NODEST,	0xcfb1,	0xdcd7,	0xc458,	NODEST,
	/* 98 */
	0xc459,	NODEST,	NODEST,	0xbfba,	0xdcd6,	NODEST,	NODEST,	NODEST,
	/* A0 */
	0xdcd5,	0xc45a,	NODEST,	NODEST,	NODEST,	0xc45b,	0xc45c,	0xdcd2,
	/* A8 */
	0xc45d,	NODEST,	NODEST,	0xc45e,	NODEST,	0xc45f,	0xdcc6,	0xc460,
	/* B0 */
	NODEST,	0xdce3,	0xdcc5,	NODEST,	0xdcd8,	NODEST,	NODEST,	0xc461,
	/* B8 */
	0xc462,	NODEST,	0xc463,	0xdcd0,	0xc464,	NODEST,	0xdccb,	0xdcc8,
	/* C0 */
	NODEST,	0xdcc9,	NODEST,	0xdcd1,	NODEST,	0xc465,	NODEST,	0xf4a2,
	/* C8 */
	0xc466,	NODEST,	0xdcce,	0xb9bd,	0xc4c8,	0xc1e4,	0xdccc,	NODEST,
	/* D0 */
	0xdcc7,	0xc467,	NODEST,	0xdcca,	NODEST,	NODEST,	0xc468,	0xc469,
	/* D8 */
	0xcdcd,	0xcbea,	NODEST,	NODEST,	NODEST,	0xdccf,	0xdcd9,	NODEST,
	/* E0 */
	NODEST,	NODEST,	0xc46a,	NODEST,	NODEST,	0xc46b,	NODEST,	0xdce1,
	/* E8 */
	0xdcda,	NODEST,	NODEST,	0xdce7,	NODEST,	0xdce5,	0xc46c,	0xc46d,
	/* F0 */
	NODEST,	0xc46e,	0xdce0,	0xc46f,	NODEST,	0xc470,	NODEST,	NODEST,
	/* F8 */
	NODEST,	0xdcdf,	NODEST,	0xc4d0,	NODEST,	0xc1e5,	0xc471,	0xdcdd,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6A[] = {
	/* 00 */
	0xc472,	0xc473,	0xdcdb,	0xc474,	NODEST,	0xdce2,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	0xdce8,	0xc8f5,	0xdcee,	NODEST,	NODEST,	0xc475,
	/* 10 */
	NODEST,	0xc476,	0xdce9,	0xdcec,	0xdce6,	0xc477,	NODEST,	0xc3f4,
	/* 18 */
	NODEST,	0xc9b8,	0xc478,	0xdcdc,	NODEST,	0xc479,	0xdce4,	0xbec0,
	/* 20 */
	0xc47a,	0xcccf,	0xdcf8,	0xdceb,	0xc47b,	NODEST,	NODEST,	NODEST,
	/* 28 */
	0xc47c,	0xb8a2,	0xb2a3,	0xb3df,	NODEST,	NODEST,	0xdcd3,	NODEST,
	/* 30 */
	0xc47d,	NODEST,	0xc47e,	NODEST,	0xc521,	0xbec1,	0xdcf0,	0xc522,
	/* 38 */
	0xdcf7,	0xbcf9,	0xb3f2,	0xc523,	NODEST,	0xc3ae,	0xc524,	0xc525,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xdced,	0xc526,	0xc527,	0xdcf2,
	/* 48 */
	0xdcf6,	0xc528,	0xc529,	0xb6b6,	NODEST,	NODEST,	0xc52a,	NODEST,
	/* 50 */
	0xc52b,	0xc52c,	0xc52d,	NODEST,	NODEST,	0xc52e,	0xc52f,	NODEST,
	/* 58 */
	0xb5cc,	0xdcf4,	NODEST,	0xc530,	NODEST,	NODEST,	NODEST,	0xb5a1,
	/* 60 */
	NODEST,	0xc6cb,	0xdcf3,	NODEST,	0xc531,	NODEST,	0xdcf5,	0xc532,
	/* 68 */
	NODEST,	NODEST,	0xc533,	0xf449,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	0xc534,	0xdcef,	0xc535,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	0xdcf1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc536,	0xb3e0,
	/* 80 */
	0xc3c9,	0xc537,	NODEST,	0xc538,	0xdcfc,	NODEST,	0xc539,	0xc53a,
	/* 88 */
	NODEST,	0xc53b,	NODEST,	0xc53c,	NODEST,	0xdcfa,	0xb8e9,	NODEST,
	/* 90 */
	0xdcf9,	0xc53d,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdda1,
	/* 98 */
	NODEST,	NODEST,	NODEST,	0xc53e,	0xdbd8,	0xc53f,	0xc540,	0xc541,
	/* A0 */
	0xdcfb,	NODEST,	0xdcfd,	0xdcfe,	NODEST,	0xc542,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	0xddac,	0xc543,	0xdda8,	NODEST,	0xdbed,	0xc544,
	/* B0 */
	0xc545,	0xc546,	NODEST,	0xdda7,	0xc547,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xdda6,	NODEST,	NODEST,	0xdda3,	NODEST,	0xc548,	0xc549,	0xc54a,
	/* C0 */
	NODEST,	0xdcea,	0xdda5,	0xdda4,	NODEST,	NODEST,	0xc54b,	NODEST,
	/* C8 */
	0xc54d,	0xc54c,	NODEST,	NODEST,	0xc54e,	NODEST,	NODEST,	NODEST,
	/* D0 */
	0xc54f,	0xddaa,	NODEST,	0xcfa6,	0xc550,	0xc551,	0xc552,	NODEST,
	/* D8 */
	NODEST,	NODEST,	0xddad,	0xb6fb,	0xc553,	0xc554,	0xdda9,	0xddab,
	/* E0 */
	NODEST,	NODEST,	0xf44a,	NODEST,	0xc555,	NODEST,	NODEST,	0xc556,
	/* E8 */
	0xc8a7,	NODEST,	0xddae,	NODEST,	0xc557,	NODEST,	NODEST,	NODEST,
	/* F0 */
	0xc558,	0xc559,	0xc55a,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	0xddb2,	0xddaf,	0xc55b,	0xc55c,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6B[] = {
	/* 00 */
	NODEST,	NODEST,	0xc55d,	0xc55e,	0xcdf3,	0xddb0,	0xc55f,	0xc560,
	/* 08 */
	NODEST,	0xc561,	0xdcde,	NODEST,	NODEST,	NODEST,	NODEST,	0xc562,
	/* 10 */
	0xc563,	0xc564,	0xddb3,	NODEST,	NODEST,	NODEST,	0xddb4,	0xc565,
	/* 18 */
	NODEST,	NODEST,	NODEST,	0xc566,	NODEST,	0xb1b5,	0xc567,	0xddb6,
	/* 20 */
	0xb7e7,	0xbca1,	NODEST,	0xb6d5,	0xc568,	NODEST,	NODEST,	0xb2a4,
	/* 28 */
	0xc569,	NODEST,	NODEST,	0xc56a,	0xc56b,	NODEST,	NODEST,	0xc56c,
	/* 30 */
	NODEST,	NODEST,	0xcddf,	NODEST,	NODEST,	0xc56d,	0xc56e,	0xddb8,
	/* 38 */
	0xddb7,	0xddba,	0xb5bd,	0xc56f,	NODEST,	0xb6d6,	0xb4be,	0xc570,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xddbd,	NODEST,	NODEST,	0xc571,	0xddbc,
	/* 48 */
	NODEST,	0xddbe,	0xc572,	NODEST,	0xb2ce,	0xc573,	0xc3b7,	NODEST,
	/* 50 */
	0xddbf,	NODEST,	0xc574,	0xb4bf,	0xddc1,	NODEST,	0xc575,	NODEST,
	/* 58 */
	0xc576,	0xddc0,	NODEST,	0xddc2,	NODEST,	0xc577,	NODEST,	0xddc3,
	/* 60 */
	0xc578,	0xddc4,	0xbbdf,	0xc0b5,	0xbaa1,	NODEST,	0xc9f0,	0xc579,
	/* 68 */
	NODEST,	0xcae2,	0xcfc4,	0xc57a,	NODEST,	NODEST,	0xc57b,	0xbbf5,
	/* 70 */
	0xc57c,	NODEST,	NODEST,	0xbad0,	0xcef2,	0xc57d,	NODEST,	NODEST,
	/* 78 */
	0xddc5,	0xddc6,	NODEST,	0xbbe0,	NODEST,	0xc57e,	0xc621,	0xddc7,
	/* 80 */
	0xddc8,	NODEST,	0xc622,	0xddca,	0xddc9,	0xc623,	0xcbd8,	NODEST,
	/* 88 */
	NODEST,	0xbdde,	0xbcec,	0xbbc4,	NODEST,	0xddcb,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xddcd,	0xbfa3,	0xc624,
	/* 98 */
	0xddcc,	NODEST,	NODEST,	0xc625,	NODEST,	NODEST,	0xddce,	0xc626,
	/* A0 */
	0xc627,	NODEST,	0xc628,	0xc629,	0xddcf,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xc62a,	0xc62b,	0xddd0,	0xddd1,	0xc62c,	0xc62d,	0xc62e,	0xddd2,
	/* B0 */
	0xc62f,	0xddd4,	0xddd3,	0xddd5,	0xb2a5,	0xc3ca,	NODEST,	0xddd6,
	/* B8 */
	0xc630,	0xc631,	0xbba6,	0xb3cc,	0xddd7,	0xc632,	0xc633,	0xc5c2,
	/* C0 */
	0xd4cc,	NODEST,	NODEST,	0xc634,	0xc635,	0xb5a3,	0xddd8,	NODEST,
	/* C8 */
	NODEST,	0xc636,	NODEST,	0xddd9,	0xc637,	0xcaec,	0xcbe8,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xc6c7,	0xddda,	0xc8e6,	NODEST,	0xc638,	NODEST,
	/* D8 */
	0xc8fb,	NODEST,	0xc639,	0xccd3,	NODEST,	NODEST,	NODEST,	0xdddb,
	/* E0 */
	NODEST,	0xc63a,	NODEST,	0xc63b,	NODEST,	NODEST,	0xc63c,	0xc63d,
	/* E8 */
	NODEST,	NODEST,	NODEST,	0xdddd,	0xdddc,	NODEST,	0xc63e,	0xdddf,
	/* F0 */
	NODEST,	0xc63f,	NODEST,	0xddde,	NODEST,	NODEST,	NODEST,	0xc640,
	/* F8 */
	NODEST,	0xc641,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc642,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6C[] = {
	/* 00 */
	NODEST,	NODEST,	0xc643,	NODEST,	0xc644,	0xc645,	NODEST,	NODEST,
	/* 08 */
	0xdde1,	0xc646,	NODEST,	NODEST,	NODEST,	0xc647,	0xc648,	0xbbe1,
	/* 10 */
	0xc649,	0xccb1,	0xc64a,	0xdde2,	0xdde3,	NODEST,	NODEST,	0xb5a4,
	/* 18 */
	NODEST,	0xc64b,	NODEST,	0xdde4,	NODEST,	NODEST,	NODEST,	0xc64c,
	/* 20 */
	NODEST,	NODEST,	NODEST,	0xdde6,	0xdde5,	NODEST,	0xc64d,	0xc64e,
	/* 28 */
	0xc64f,	NODEST,	NODEST,	NODEST,	0xc650,	NODEST,	0xc651,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	0xc652,	0xbfe5,	0xc653,	0xc654,	0xc9b9,
	/* 38 */
	0xb1ca,	NODEST,	0xc655,	0xc656,	NODEST,	NODEST,	0xc8c5,	0xc657,
	/* 40 */
	0xc4f5,	0xbdc1,	0xb5e1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	0xc658,	0xc659,	NODEST,	0xc65a,	0xc8c6,	0xc65b,
	/* 50 */
	0xbcae,	NODEST,	0xc65c,	NODEST,	0xc65d,	0xdde8,	NODEST,	0xb4c0,
	/* 58 */
	NODEST,	0xc65e,	0xb1f8,	0xc65f,	0xc660,	0xc6f2,	0xdde7,	0xb9be,
	/* 60 */
	0xc3d3,	NODEST,	0xdde9,	NODEST,	NODEST,	NODEST,	NODEST,	0xc736,
	/* 68 */
	0xddf1,	NODEST,	0xddea,	0xc661,	NODEST,	0xc662,	NODEST,	0xc663,
	/* 70 */
	0xc2c1,	NODEST,	0xb5e2,	0xddf2,	0xc664,	NODEST,	0xc665,	NODEST,
	/* 78 */
	0xc666,	0xc667,	0xb7e8,	0xc668,	NODEST,	0xb5a5,	0xddf0,	NODEST,
	/* 80 */
	NODEST,	0xddee,	0xddeb,	0xcde0,	NODEST,	0xc669,	0xc66a,	0xc66b,
	/* 88 */
	0xc4c0,	0xc66c,	NODEST,	NODEST,	0xc6d9,	0xddec,	NODEST,	NODEST,
	/* 90 */
	0xddf4,	NODEST,	0xddf3,	0xb7a3,	0xc66d,	0xc66e,	0xb2ad,	0xc66f,
	/* 98 */
	0xc670,	0xbabb,	0xdded,	0xddef,	0xc671,	NODEST,	NODEST,	0xc672,
	/* A0 */
	NODEST,	0xcbd7,	0xc2f4,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xcbf7,	NODEST,	NODEST,	0xddfc,	NODEST,
	/* B0 */
	0xc673,	0xddfd,	0xc674,	0xb2cf,	0xc675,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xcaa8,	0xccfd,	0xdea1,	0xbca3,	0xbec2,	0xddf8,	0xddfe,	0xb1e8,
	/* C0 */
	NODEST,	0xb6b7,	0xc676,	NODEST,	0xddf5,	0xddfa,	0xc677,	NODEST,
	/* C8 */
	NODEST,	0xc0f4,	0xc7f1,	NODEST,	0xc8e7,	0xc678,	NODEST,	0xc679,
	/* D0 */
	0xc67a,	0xc67b,	0xc67c,	0xddf7,	0xc67d,	0xcba1,	0xc67e,	0xddf9,
	/* D8 */
	NODEST,	0xdea4,	0xc721,	0xdea2,	0xc722,	0xddfb,	NODEST,	NODEST,
	/* E0 */
	0xc723,	0xcba2,	0xc7c8,	0xb5e3,	NODEST,	0xc5a5,	NODEST,	0xc724,
	/* E8 */
	0xc3ed,	0xc725,	0xdea5,	0xc726,	0xc727,	NODEST,	0xc728,	0xdea3,
	/* F0 */
	0xc2d9,	0xddf6,	0xc729,	0xb1cb,	0xc72a,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6D[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc72b,	NODEST,	NODEST,	0xc72c,
	/* 08 */
	NODEST,	NODEST,	0xc72d,	0xcdce,	0xdeb0,	NODEST,	0xc72e,	0xc72f,
	/* 10 */
	NODEST,	0xc730,	0xdeaf,	0xc731,	NODEST,	NODEST,	NODEST,	0xc0f6,
	/* 18 */
	NODEST,	0xdeac,	0xc732,	0xcdec,	NODEST,	NODEST,	0xc6b6,	0xdea6,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc4c5,	0xc733,	0xc734,
	/* 28 */
	0xc735,	0xb1cc,	0xb9bf,	0xdea9,	NODEST,	NODEST,	0xc737,	0xc738,
	/* 30 */
	NODEST,	0xc739,	0xbda7,	0xdeae,	NODEST,	0xdead,	0xdea8,	NODEST,
	/* 38 */
	0xdeab,	0xc73a,	NODEST,	0xb3e8,	0xc73b,	0xdeaa,	0xc7c9,	0xc73c,
	/* 40 */
	NODEST,	0xceae,	NODEST,	NODEST,	0xbef4,	0xc0f5,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc73d,
	/* 58 */
	NODEST,	0xdeb6,	0xdeb4,	NODEST,	0xc9cd,	NODEST,	0xc73e,	0xc73f,
	/* 60 */
	NODEST,	0xc740,	NODEST,	0xdeb1,	0xdeb3,	0xc741,	0xb1ba,	0xc742,
	/* 68 */
	NODEST,	0xb9c0,	0xcfb2,	NODEST,	0xb3bd,	NODEST,	0xc9e2,	0xc743,
	/* 70 */
	0xc744,	NODEST,	NODEST,	NODEST,	0xcde1,	NODEST,	NODEST,	0xb3a4,
	/* 78 */
	0xbfbb,	0xdeb5,	NODEST,	NODEST,	0xc745,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	0xc746,	NODEST,	NODEST,	0xdeba,	NODEST,	0xc747,
	/* 88 */
	0xbec3,	NODEST,	NODEST,	NODEST,	0xcdb0,	NODEST,	0xdeb7,	NODEST,
	/* 90 */
	NODEST,	0xc748,	0xc749,	0xdeb2,	0xc74a,	0xdeb8,	0xc74b,	0xc74c,
	/* 98 */
	0xc74d,	0xcede,	NODEST,	0xc5f3,	0xc6c2,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	0xc74e,	NODEST,	0xc74f,	NODEST,	NODEST,	0xb3b6,
	/* B0 */
	NODEST,	NODEST,	0xb1d5,	NODEST,	0xc750,	0xdebe,	NODEST,	0xc751,
	/* B8 */
	0xdec1,	0xc752,	NODEST,	NODEST,	0xcec3,	0xc753,	NODEST,	0xc754,
	/* C0 */
	0xcde4,	NODEST,	NODEST,	NODEST,	0xc755,	0xdec8,	0xdec2,	0xdebf,
	/* C8 */
	0xc756,	NODEST,	0xc757,	0xced4,	0xdec5,	NODEST,	0xc758,	0xc759,
	/* D0 */
	NODEST,	0xbdca,	0xdec7,	NODEST,	NODEST,	0xdecc,	0xc75a,	NODEST,
	/* D8 */
	0xc5f1,	0xdeca,	NODEST,	0xc75b,	NODEST,	0xc75c,	0xdec4,	0xc75d,
	/* E0 */
	0xc75e,	0xc3b8,	0xc75f,	NODEST,	0xdecb,	0xc760,	0xdec0,	NODEST,
	/* E8 */
	0xdec6,	0xc761,	0xdecd,	0xb0fc,	0xdec3,	NODEST,	0xdece,	0xc762,
	/* F0 */
	0xc763,	0xbfbc,	0xf44c,	0xbddf,	0xc764,	0xcaa5,	0xc765,	0xbaae,
	/* F8 */
	0xf44b,	0xdebb,	0xdec9,	0xc5ba,	0xc766,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6E[] = {
	/* 00 */
	0xc767,	NODEST,	NODEST,	NODEST,	0xc768,	0xc0b6,	NODEST,	0xb3e9,
	/* 08 */
	0xbad1,	0xbec4,	0xdebd,	0xbdc2,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	0xb7cc,	NODEST,	0xdebc,	NODEST,	NODEST,
	/* 18 */
	NODEST,	0xded2,	0xbded,	0xb8ba,	NODEST,	0xdee1,	0xc769,	0xdedb,
	/* 20 */
	0xb5f4,	0xc5cf,	0xc76a,	0xded6,	0xdedf,	0xb0af,	0xb1b2,	0xc76b,
	/* 28 */
	NODEST,	0xb2b9,	NODEST,	0xded8,	0xc2ac,	0xdecf,	0xded1,	0xb9c1,
	/* 30 */
	NODEST,	NODEST,	0xc76c,	NODEST,	NODEST,	NODEST,	0xc76d,	NODEST,
	/* 38 */
	0xdee2,	0xc76e,	0xdedd,	0xc76f,	0xc770,	NODEST,	0xded5,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xdedc,	0xc771,	0xc772,	NODEST,	NODEST,
	/* 48 */
	0xc773,	0xc774,	0xccab,	0xc775,	NODEST,	0xdeda,	0xdede,	0xc776,
	/* 50 */
	NODEST,	0xc777,	0xc778,	0xc779,	0xc77a,	NODEST,	0xb8d0,	0xc77b,
	/* 58 */
	0xbec5,	NODEST,	NODEST,	0xc3b9,	0xc77c,	0xc77d,	0xc77e,	0xded4,
	/* 60 */
	NODEST,	NODEST,	0xc821,	0xc822,	NODEST,	NODEST,	NODEST,	0xcdaf,
	/* 68 */
	0xc823,	NODEST,	NODEST,	0xded7,	NODEST,	NODEST,	0xded0,	0xc5f2,
	/* 70 */
	NODEST,	NODEST,	0xded3,	0xc824,	NODEST,	NODEST,	0xded9,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	0xc825,	NODEST,	0xc826,	0xcfd1,	0xbcbe,
	/* 80 */
	0xcbfe,	NODEST,	0xdee3,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc8ae,	0xc827,	NODEST,	0xdeef,
	/* 90 */
	0xb8bb,	NODEST,	NODEST,	0xc828,	NODEST,	NODEST,	0xbde0,	NODEST,
	/* 98 */
	0xdee5,	0xc829,	NODEST,	NODEST,	0xceaf,	0xb9c2,	NODEST,	0xdef2,
	/* A0 */
	0xc82a,	NODEST,	0xb0ee,	NODEST,	NODEST,	0xdef0,	NODEST,	0xc82b,
	/* A8 */
	NODEST,	NODEST,	0xdee4,	NODEST,	NODEST,	0xc82c,	0xc82d,	0xdeea,
	/* B0 */
	NODEST,	0xc82e,	0xdeec,	0xc82f,	NODEST,	NODEST,	0xcdcf,	0xdee7,
	/* B8 */
	NODEST,	NODEST,	0xc5ae,	0xc830,	NODEST,	0xdee9,	NODEST,	0xc831,
	/* C0 */
	0xc832,	0xc833,	0xdef1,	0xc834,	0xdeeb,	0xccc7,	NODEST,	0xc835,
	/* C8 */
	0xc836,	0xdee6,	0xc837,	0xbca2,	0xdefe,	0xc838,	0xc839,	0xc83a,
	/* D0 */
	NODEST,	0xb3ea,	NODEST,	0xdee8,	0xdeed,	0xdeee,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc2ec,	0xc2da,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	0xc83b,	0xdef6,	0xc83c,	0xc83d,	0xdefc,
	/* F0 */
	NODEST,	NODEST,	0xdefa,	NODEST,	0xc5a9,	NODEST,	NODEST,	0xdfa3,
	/* F8 */
	0xdef7,	0xc83e,	NODEST,	0xc83f,	NODEST,	0xc840,	0xdef8,	0xdee0,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_6F[] = {
	/* 00 */
	NODEST,	0xb5f9,	0xc9ba,	NODEST,	0xc841,	NODEST,	0xbcbf,	NODEST,
	/* 08 */
	0xc842,	0xb9f7,	0xc843,	NODEST,	0xc844,	0xc845,	NODEST,	0xcfb3,
	/* 10 */
	NODEST,	0xdef4,	NODEST,	0xdfa2,	0xb1e9,	0xc1e6,	0xc846,	NODEST,
	/* 18 */
	0xc847,	NODEST,	0xc848,	0xc849,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	0xc7f9,	NODEST,	0xb4c1,	0xcefa,	NODEST,	NODEST,	0xc84a,	NODEST,
	/* 28 */
	NODEST,	0xc84b,	0xc84c,	0xcca1,	0xc4d2,	0xc853,	NODEST,	0xc84d,
	/* 30 */
	0xc84e,	0xdefb,	0xdefd,	0xc84f,	NODEST,	NODEST,	0xc850,	NODEST,
	/* 38 */
	0xc1b2,	NODEST,	NODEST,	0xc851,	0xc852,	NODEST,	0xdfa1,	0xdef9,
	/* 40 */
	NODEST,	0xdef3,	NODEST,	NODEST,	NODEST,	0xb4c3,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc854,
	/* 50 */
	NODEST,	0xc855,	0xc856,	0xc857,	0xb7e9,	NODEST,	NODEST,	0xc858,
	/* 58 */
	0xdfaf,	0xc859,	0xc85a,	0xdfaa,	0xc0f8,	0xc85b,	0xc85c,	0xb3e3,
	/* 60 */
	NODEST,	0xc85d,	0xc85e,	NODEST,	0xbde1,	NODEST,	0xdfb3,	NODEST,
	/* 68 */
	0xc85f,	NODEST,	NODEST,	NODEST,	0xc860,	0xdfac,	0xc4ac,	0xdfa9,
	/* 70 */
	0xc4d9,	NODEST,	NODEST,	NODEST,	0xdfcc,	NODEST,	NODEST,	NODEST,
	/* 78 */
	0xdfa6,	NODEST,	0xdfa5,	NODEST,	0xdfae,	0xc861,	0xc862,	NODEST,
	/* 80 */
	0xdfa8,	0xdfa7,	0xdfad,	0xc863,	0xc0a1,	NODEST,	0xdfa4,	0xc864,
	/* 88 */
	0xc865,	NODEST,	NODEST,	0xc866,	0xc867,	0xc868,	0xdfb0,	NODEST,
	/* 90 */
	0xc869,	0xdfb1,	0xc86a,	0xc86b,	0xc86c,	NODEST,	0xc86d,	0xb4c2,
	/* 98 */
	NODEST,	NODEST,	0xc86e,	NODEST,	NODEST,	NODEST,	NODEST,	0xc86f,
	/* A0 */
	0xc870,	0xdfb6,	NODEST,	0xdfb5,	0xdfb7,	0xc871,	0xc872,	0xc873,
	/* A8 */
	0xc874,	NODEST,	0xdfba,	NODEST,	NODEST,	NODEST,	0xc875,	0xc876,
	/* B0 */
	0xc877,	0xc5c3,	NODEST,	0xdfb4,	NODEST,	0xc878,	0xc879,	NODEST,
	/* B8 */
	NODEST,	0xdfb8,	NODEST,	NODEST,	0xc87a,	NODEST,	NODEST,	NODEST,
	/* C0 */
	0xb7e3,	0xc2f9,	0xdfb2,	0xc7bb,	NODEST,	0xc87b,	0xdfb9,	0xc87c,
	/* C8 */
	0xc87d,	NODEST,	0xc87e,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xdfbe,	0xdfbc,	NODEST,	NODEST,
	/* D8 */
	0xdfbf,	NODEST,	0xc921,	0xdfc2,	NODEST,	NODEST,	0xc922,	0xdfbb,
	/* E0 */
	0xb9ea,	0xc7a8,	NODEST,	NODEST,	0xdeb9,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xc923,	0xc924,	NODEST,	0xcdf4,	0xdfbd,	NODEST,	0xdfc1,	0xc2f5,
	/* F0 */
	0xc925,	0xdfc0,	NODEST,	0xdfab,	NODEST,	0xc926,	0xefe9,	NODEST,
	/* F8 */
	NODEST,	0xc927,	0xdfc5,	NODEST,	0xc928,	0xc929,	0xdfc9,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_70[] = {
	/* 00 */
	0xc92a,	0xdfc7,	NODEST,	NODEST,	NODEST,	0xc92b,	0xc92c,	0xc92d,
	/* 08 */
	NODEST,	0xdfc3,	NODEST,	0xdfc4,	NODEST,	0xc92e,	NODEST,	0xdfc8,
	/* 10 */
	NODEST,	0xdfc6,	NODEST,	NODEST,	NODEST,	0xc9ce,	NODEST,	0xc92f,
	/* 18 */
	0xdfce,	NODEST,	0xdfcb,	0xdfca,	NODEST,	0xdfcd,	0xc6d4,	0xdfcf,
	/* 20 */
	0xc930,	NODEST,	NODEST,	0xc931,	NODEST,	NODEST,	0xc3f5,	0xc2ed,
	/* 28 */
	0xf44d,	NODEST,	NODEST,	NODEST,	0xc0a5,	NODEST,	NODEST,	0xc932,
	/* 30 */
	0xdfd0,	NODEST,	0xdfd2,	NODEST,	0xc933,	NODEST,	NODEST,	0xc934,
	/* 38 */
	NODEST,	0xc935,	NODEST,	NODEST,	0xc936,	NODEST,	0xdfd1,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xc937,	0xc938,	NODEST,	NODEST,	NODEST,
	/* 48 */
	0xc939,	0xc93a,	0xc93b,	0xc93c,	0xdef5,	NODEST,	0xc941,	NODEST,
	/* 50 */
	NODEST,	0xdfd3,	NODEST,	NODEST,	0xc93d,	0xc93e,	NODEST,	NODEST,
	/* 58 */
	0xc6e7,	NODEST,	NODEST,	NODEST,	NODEST,	0xc93f,	0xc940,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	0xdfd4,	0xc942,	0xc943,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	0xb2d0,	0xc944,	NODEST,	0xc945,	0xc5f4,
	/* 70 */
	0xb3a5,	NODEST,	NODEST,	NODEST,	NODEST,	0xc946,	0xc947,	NODEST,
	/* 78 */
	0xb5e4,	NODEST,	NODEST,	NODEST,	0xbcde,	0xbad2,	0xc948,	NODEST,
	/* 80 */
	NODEST,	0xc949,	NODEST,	NODEST,	NODEST,	0xc94a,	0xc94b,	NODEST,
	/* 88 */
	NODEST,	0xcfa7,	0xbfe6,	NODEST,	NODEST,	NODEST,	0xb1ea,	NODEST,
	/* 90 */
	NODEST,	NODEST,	0xdfd6,	NODEST,	0xc94c,	0xc94d,	0xc94e,	0xc94f,
	/* 98 */
	0xc950,	0xdfd5,	NODEST,	0xc951,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc952,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xc953,	0xdfd9,	0xc3ba,	0xdfdc,	0xdfd7,
	/* B0 */
	0xc954,	0xc955,	NODEST,	0xdfdb,	0xc956,	NODEST,	NODEST,	0xc957,
	/* B8 */
	0xdfda,	0xc5c0,	0xb0d9,	0xf42e,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	0xcef5,	NODEST,	0xc958,	0xdfde,	NODEST,	NODEST,	NODEST,	0xb1a8,
	/* D0 */
	NODEST,	0xc959,	NODEST,	0xc95a,	0xc95b,	0xc95c,	0xc95d,	NODEST,
	/* D8 */
	0xc95e,	0xdfe0,	NODEST,	NODEST,	0xc95f,	0xdfdf,	NODEST,	0xdfdd,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc960,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	0xdfd8,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	0xcba3,	0xc961,	NODEST,	NODEST,	0xdfe2,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_71[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	0xc962,	0xc963,	0xc964,	0xc965,	0xc966,
	/* 08 */
	NODEST,	0xdfe1,	NODEST,	0xc967,	0xc968,	NODEST,	NODEST,	0xc969,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xb1eb,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	0xdfe4,	0xcab2,	NODEST,	0xdfe3,	NODEST,	0xc96a,	NODEST,
	/* 20 */
	0xc96b,	0xccb5,	NODEST,	NODEST,	NODEST,	NODEST,	0xbec7,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xc96c,	NODEST,	0xc96d,	NODEST,	0xc96e,
	/* 30 */
	0xc96f,	0xc970,	NODEST,	NODEST,	NODEST,	NODEST,	0xc1b3,	NODEST,
	/* 38 */
	0xc971,	NODEST,	NODEST,	NODEST,	0xbec6,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	0xc972,	NODEST,	NODEST,	NODEST,	0xc973,	0xc974,	0xc975,
	/* 48 */
	NODEST,	0xcefb,	0xc976,	0xc977,	0xdfea,	NODEST,	0xc0f9,	NODEST,
	/* 50 */
	0xc978,	NODEST,	0xc979,	NODEST,	NODEST,	0xdfe6,	0xdfeb,	0xc97a,
	/* 58 */
	NODEST,	0xb1ec,	0xc97b,	NODEST,	0xc97c,	NODEST,	0xc97d,	NODEST,
	/* 60 */
	0xc97e,	NODEST,	0xdfe9,	NODEST,	0xc7e1,	0xdfe5,	0xdfe8,	0xbec8,
	/* 68 */
	0xca21,	0xc8d1,	NODEST,	NODEST,	0xdfec,	NODEST,	0xbcd1,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	0xca22,	NODEST,	NODEST,	NODEST,	0xc0fa,	NODEST,	NODEST,
	/* 80 */
	0xca23,	NODEST,	NODEST,	NODEST,	0xdfef,	0xca24,	NODEST,	0xca25,
	/* 88 */
	0xdfe7,	NODEST,	0xb7a7,	NODEST,	0xca26,	NODEST,	NODEST,	0xdfed,
	/* 90 */
	NODEST,	NODEST,	0xca27,	NODEST,	0xcdd0,	0xdff0,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xf4a6,	0xca28,	0xca29,	NODEST,	NODEST,	NODEST,	0xbdcf,
	/* A0 */
	0xca2a,	NODEST,	0xca2b,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xdff1,	NODEST,	NODEST,	NODEST,	0xdff2,	NODEST,	NODEST,	0xca2c,
	/* B0 */
	0xca2d,	0xc7ae,	0xca2e,	0xca2f,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	0xdff4,	0xca30,	NODEST,	NODEST,	NODEST,	0xdff5,	0xca31,
	/* C0 */
	0xca32,	0xca33,	NODEST,	0xc7b3,	0xca34,	NODEST,	NODEST,	NODEST,
	/* C8 */
	0xc5f5,	0xdff7,	NODEST,	0xca35,	0xca36,	NODEST,	0xdff9,	NODEST,
	/* D0 */
	0xced5,	NODEST,	0xdff6,	0xca37,	0xdff8,	0xb1ed,	0xca38,	0xdff3,
	/* D8 */
	NODEST,	0xca39,	0xca3a,	NODEST,	0xca3b,	NODEST,	NODEST,	0xd3db,
	/* E0 */
	0xdffa,	NODEST,	NODEST,	NODEST,	NODEST,	0xc1e7,	0xbbb8,	0xdffc,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xdffb,	0xbfa4,	0xd2d9,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdffd,	NODEST,	NODEST,
	/* F8 */
	0xca3c,	0xe0a1,	NODEST,	0xdfee,	0xdffe,	NODEST,	0xca3d,	0xe0a2,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_72[] = {
	/* 00 */
	0xca3e,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc7fa,	0xca3f,
	/* 08 */
	0xca40,	0xca41,	NODEST,	NODEST,	NODEST,	0xe0a3,	NODEST,	NODEST,
	/* 10 */
	0xe0a4,	NODEST,	NODEST,	0xca42,	NODEST,	NODEST,	NODEST,	0xca43,
	/* 18 */
	NODEST,	NODEST,	0xca44,	0xe0a5,	NODEST,	0xca45,	NODEST,	0xca46,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xca47,	NODEST,	NODEST,	NODEST,
	/* 28 */
	0xe0a6,	NODEST,	0xc4de,	0xca48,	0xe0a8,	0xe0a7,	NODEST,	0xca49,
	/* 30 */
	0xe0a9,	NODEST,	0xe0aa,	NODEST,	0xca4a,	0xbcdf,	0xc9e3,	NODEST,
	/* 38 */
	0xca4b,	0xca4c,	0xccec,	0xe0ab,	0xe0ac,	0xc1d6,	0xbca4,	0xe0ad,
	/* 40 */
	0xe0ae,	0xca4d,	0xca4e,	0xca4f,	NODEST,	0xca50,	0xe0af,	0xcad2,
	/* 48 */
	0xc8c7,	NODEST,	NODEST,	0xe0b0,	0xc7d7,	NODEST,	0xca51,	0xca52,
	/* 50 */
	0xca53,	NODEST,	0xc4ad,	0xca54,	NODEST,	0xca55,	0xca56,	NODEST,
	/* 58 */
	0xe0b1,	0xb2e7,	0xca57,	0xb5ed,	0xca58,	0xccc6,	0xca59,	0xccb6,
	/* 60 */
	0xca5a,	0xb2b4,	0xcfb4,	0xca5b,	NODEST,	NODEST,	NODEST,	0xcbd2,
	/* 68 */
	0xca5c,	0xcaaa,	NODEST,	0xca5d,	NODEST,	NODEST,	0xca5e,	0xca5f,
	/* 70 */
	NODEST,	0xca60,	0xc0b7,	NODEST,	0xe0b2,	NODEST,	NODEST,	0xca61,
	/* 78 */
	0xca62,	0xc6c3,	NODEST,	0xca63,	0xca64,	0xb8a3,	0xe0b3,	0xca65,
	/* 80 */
	0xbad4,	0xe0b5,	0xe0b4,	NODEST,	0xca66,	NODEST,	NODEST,	0xe0b6,
	/* 88 */
	NODEST,	0xca67,	NODEST,	NODEST,	NODEST,	0xca68,	0xca69,	NODEST,
	/* 90 */
	NODEST,	NODEST,	0xe0b7,	0xca6a,	NODEST,	NODEST,	0xe0b8,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	0xca6b,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	0xb5be,	NODEST,	0xe0b9,	NODEST,	NODEST,	NODEST,	NODEST,	0xe0ba,
	/* A8 */
	0xca6c,	NODEST,	NODEST,	NODEST,	0xb8a4,	0xca6d,	0xca6e,	0xc8c8,
	/* B0 */
	NODEST,	0xca6f,	0xe0bc,	NODEST,	0xca70,	NODEST,	0xbef5,	NODEST,
	/* B8 */
	NODEST,	0xe0bb,	NODEST,	NODEST,	NODEST,	NODEST,	0xca71,	NODEST,
	/* C0 */
	NODEST,	0xca72,	0xb6b8,	0xe0bd,	0xe0bf,	NODEST,	0xe0be,	0xca73,
	/* C8 */
	NODEST,	0xca74,	NODEST,	NODEST,	0xca75,	NODEST,	0xe0c0,	NODEST,
	/* D0 */
	0xb8d1,	NODEST,	0xe0c1,	NODEST,	NODEST,	0xca76,	0xca77,	0xb6e9,
	/* D8 */
	0xca78,	0xc1c0,	NODEST,	0xb9fd,	NODEST,	NODEST,	NODEST,	0xca79,
	/* E0 */
	0xe0c3,	0xe0c4,	0xe0c2,	NODEST,	NODEST,	0xca7a,	NODEST,	NODEST,
	/* E8 */
	NODEST,	0xbced,	NODEST,	NODEST,	0xc6c8,	0xb6b9,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	0xca7b,	0xca7c,	NODEST,	NODEST,	0xe0c6,
	/* F8 */
	0xc3ac,	0xe0c5,	0xca7d,	0xca7e,	0xcfb5,	0xc7e2,	0xcb21,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_73[] = {
	/* 00 */
	NODEST,	NODEST,	0xcb22,	NODEST,	0xcb23,	0xcb24,	NODEST,	0xcb25,
	/* 08 */
	NODEST,	NODEST,	0xe0c9,	0xcb26,	NODEST,	0xcb27,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	0xcb28,	0xcb29,	NODEST,	NODEST,	0xe0cb,	0xe0c8,
	/* 18 */
	0xcb2a,	0xcb2b,	NODEST,	0xccd4,	0xe0ca,	0xe0cc,	0xcb2c,	0xcec4,
	/* 20 */
	NODEST,	NODEST,	0xcb2d,	NODEST,	0xcb2e,	0xe0d0,	NODEST,	0xcb2f,
	/* 28 */
	0xcb30,	0xe0cf,	0xc3f6,	0xc7ad,	0xcb31,	NODEST,	0xb8a5,	0xe0ce,
	/* 30 */
	NODEST,	0xcb32,	0xcb33,	NODEST,	0xe0cd,	0xcb34,	0xcdb1,	0xcdb2,
	/* 38 */
	NODEST,	NODEST,	0xcb35,	0xcb36,	NODEST,	0xcb37,	0xe0d1,	0xb1ee,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xcb38,	0xb9f6,	0xbbe2,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xcb39,	0xe0d2,	0xe0d3,
	/* 50 */
	0xcb3a,	NODEST,	0xcb3b,	NODEST,	NODEST,	NODEST,	0xcb3c,	0xe0d5,
	/* 58 */
	0xcb3d,	NODEST,	NODEST,	NODEST,	NODEST,	0xcb3e,	0xcb3f,	0xcb40,
	/* 60 */
	0xcb41,	NODEST,	NODEST,	0xbdc3,	NODEST,	NODEST,	0xcb42,	0xcb43,
	/* 68 */
	0xe0d7,	0xcb44,	0xe0d6,	0xcb45,	0xcb46,	NODEST,	0xcb47,	0xcb48,
	/* 70 */
	0xe0d8,	0xcb49,	0xb3cd,	NODEST,	NODEST,	0xe0da,	NODEST,	0xcb4a,
	/* 78 */
	0xe0d9,	0xcb4b,	0xe0dc,	0xe0db,	0xcb4c,	NODEST,	NODEST,	NODEST,
	/* 80 */
	0xcb4d,	0xcb4e,	NODEST,	0xcb4f,	0xb8bc,	0xcb50,	0xcb51,	0xcea8,
	/* 88 */
	NODEST,	0xb6cc,	NODEST,	0xb2a6,	NODEST,	NODEST,	0xcb52,	NODEST,
	/* 90 */
	0xcb53,	NODEST,	NODEST,	0xcb54,	NODEST,	0xcb55,	0xb6ea,	0xcb56,
	/* 98 */
	0xcb57,	NODEST,	NODEST,	NODEST,	0xcb58,	NODEST,	0xcb59,	0xcb5a,
	/* A0 */
	0xcb5b,	NODEST,	0xcb5c,	NODEST,	NODEST,	0xcb5d,	0xcb5e,	NODEST,
	/* A8 */
	NODEST,	0xb4e1,	0xcb5f,	0xcb60,	NODEST,	0xcb61,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	0xcee8,	0xe0de,	NODEST,	0xcb62,	NODEST,	0xcb63,
	/* B8 */
	NODEST,	0xcb64,	NODEST,	0xe0e0,	0xcb65,	0xcb66,	NODEST,	0xcb67,
	/* C0 */
	0xe0e1,	NODEST,	0xb2d1,	NODEST,	NODEST,	0xcb68,	0xcb69,	NODEST,
	/* C8 */
	0xe0dd,	0xcb6a,	0xbbb9,	0xcb6b,	0xcb6c,	0xc4c1,	0xe0df,	0xcb6d,
	/* D0 */
	NODEST,	NODEST,	0xcb6e,	0xcb6f,	NODEST,	NODEST,	0xcb70,	NODEST,
	/* D8 */
	NODEST,	0xcb71,	NODEST,	NODEST,	NODEST,	0xcb72,	0xe0e4,	NODEST,
	/* E0 */
	0xbcee,	0xcb73,	NODEST,	0xcb74,	NODEST,	0xe0e2,	0xcb75,	0xcb76,
	/* E8 */
	NODEST,	0xcb77,	0xb7be,	NODEST,	NODEST,	0xc8c9,	0xe0e3,	NODEST,
	/* F0 */
	NODEST,	0xe0fe,	NODEST,	NODEST,	0xcb78,	0xcb79,	NODEST,	0xcb7a,
	/* F8 */
	0xe0e9,	0xcb7b,	0xcb7c,	0xcb7d,	NODEST,	0xcb7e,	0xb8bd,	0xcc21,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_74[] = {
	/* 00 */
	0xcc22,	0xcc23,	NODEST,	0xb5e5,	0xcc24,	0xe0e6,	0xcdfd,	0xcc25,
	/* 08 */
	NODEST,	0xceb0,	0xcc26,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	0xcc27,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	0xcc28,	0xcc29,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	0xc2f6,	NODEST,	0xcc2a,	0xe0e8,	0xcc2b,	NODEST,
	/* 28 */
	0xcc2c,	0xcc2d,	0xcc2e,	0xcc2f,	0xcc30,	0xcc31,	0xcc32,	0xcc33,
	/* 30 */
	0xcc34,	0xcc35,	0xe0ea,	0xced6,	0xb6d7,	0xc8fc,	0xc7ca,	NODEST,
	/* 38 */
	NODEST,	0xcc36,	0xe0eb,	NODEST,	NODEST,	NODEST,	NODEST,	0xe0ed,
	/* 40 */
	0xcc37,	0xe0f0,	NODEST,	0xcc38,	0xcc39,	NODEST,	0xcc3a,	0xcc3b,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xcc3c,	NODEST,	0xcc3d,	NODEST,	NODEST,
	/* 50 */
	NODEST,	0xcc3e,	0xcc3f,	NODEST,	NODEST,	0xe0ec,	NODEST,	0xcc40,
	/* 58 */
	NODEST,	0xe0ef,	0xb8ea,	0xb1cd,	0xe0f1,	0xcc41,	0xbff0,	0xe0ee,
	/* 60 */
	0xcedc,	NODEST,	0xcc42,	0xe0f4,	0xf4a4,	NODEST,	0xcc43,	0xcc44,
	/* 68 */
	0xcc45,	0xe0f2,	0xe0f5,	0xcc46,	NODEST,	0xcc47,	0xcc48,	0xe0e7,
	/* 70 */
	0xe0f3,	0xcc49,	0xcc4a,	0xbabc,	NODEST,	NODEST,	0xe0f6,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe0f7,	NODEST,
	/* 80 */
	0xcc4b,	0xcc4c,	NODEST,	0xcdfe,	NODEST,	0xcc4d,	0xcc4e,	0xcc4f,
	/* 88 */
	NODEST,	0xcc50,	NODEST,	0xe0f8,	NODEST,	NODEST,	NODEST,	0xcc51,
	/* 90 */
	0xcc52,	0xcc53,	0xcc54,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	0xcc55,	0xcc56,	0xcc57,	NODEST,	0xcc58,	NODEST,	0xe0f9,	0xcc59,
	/* A0 */
	0xcc5a,	0xcc5b,	0xe0e5,	0xcc5c,	NODEST,	NODEST,	0xcc5d,	0xe0fa,
	/* A8 */
	0xcc5e,	0xcc5f,	0xcc60,	0xcc61,	NODEST,	NODEST,	0xcc62,	0xcc63,
	/* B0 */
	0xb4c4,	0xcc64,	0xcc65,	NODEST,	NODEST,	0xcc66,	NODEST,	NODEST,
	/* B8 */
	NODEST,	0xcc67,	NODEST,	0xcc68,	NODEST,	0xbca5,	NODEST,	0xcc69,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	0xcc6a,	0xcc6b,	0xe0fb,	NODEST,	0xcc6c,	NODEST,	NODEST,	0xe0fc,
	/* D0 */
	0xcc6d,	NODEST,	NODEST,	0xcc6e,	0xe0fd,	NODEST,	NODEST,	NODEST,
	/* D8 */
	0xcc6f,	NODEST,	0xcc70,	0xcc71,	0xb1bb,	NODEST,	0xcc72,	0xcc73,
	/* E0 */
	0xe1a1,	NODEST,	0xc9bb,	0xe1a2,	0xcc74,	NODEST,	0xb4a4,	0xe1a3,
	/* E8 */
	0xcc75,	0xe1a4,	0xcc76,	0xcc77,	NODEST,	NODEST,	0xe1a5,	0xcc78,
	/* F0 */
	0xe1a7,	0xe1a8,	0xe1a6,	NODEST,	0xcc79,	NODEST,	0xc9d3,	0xe1aa,
	/* F8 */
	0xe1a9,	NODEST,	0xcc7a,	0xcc7b,	0xcc7c,	NODEST,	NODEST,	0xcc7d,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_75[] = {
	/* 00 */
	NODEST,	0xf450,	NODEST,	0xe1ac,	0xe1ab,	0xe1ad,	0xcc7e,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xe1ae,	0xe1b0,	0xe1af,	NODEST,
	/* 10 */
	NODEST,	0xb9f9,	0xcd21,	0xe1b2,	NODEST,	0xe1b1,	0xcd22,	0xcd23,
	/* 18 */
	0xb4c5,	NODEST,	0xbfd3,	NODEST,	0xc5bc,	NODEST,	0xe1b3,	0xc0b8,
	/* 20 */
	0xcd24,	0xcd25,	NODEST,	0xbbba,	0xcd26,	0xb1f9,	0xe1b4,	0xcd27,
	/* 28 */
	0xcdd1,	0xcd28,	0xcd29,	0xcae3,	0xe1b5,	NODEST,	NODEST,	0xcd2a,
	/* 30 */
	0xc5c4,	0xcdb3,	0xb9c3,	0xbfbd,	NODEST,	NODEST,	0xcd2b,	0xc3cb,
	/* 38 */
	0xd2b4,	0xcd2c,	0xc4ae,	0xb2e8,	0xe1b6,	0xcd2d,	0xcd2e,	0xcd2f,
	/* 40 */
	0xcd30,	NODEST,	NODEST,	0xcd31,	0xe1b7,	NODEST,	0xe1bc,	0xcd32,
	/* 48 */
	0xcd33,	0xe1ba,	0xe1b9,	0xdac2,	0xb3a6,	0xe1b8,	0xcd34,	0xb0da,
	/* 50 */
	0xcd35,	0xc8aa,	0xcd36,	NODEST,	0xc8ca,	NODEST,	NODEST,	0xcd37,
	/* 58 */
	NODEST,	0xceb1,	0xe1bd,	0xe1bb,	0xc3dc,	0xc0a6,	0xcd38,	0xcd39,
	/* 60 */
	0xc8ab,	0xcd3a,	0xc9ad,	NODEST,	0xe1bf,	0xceac,	0xb7cd,	0xe1c0,
	/* 68 */
	NODEST,	0xe1be,	0xc8d6,	0xe1c1,	NODEST,	0xe1c2,	NODEST,	0xcd3b,
	/* 70 */
	0xb0db,	0xcd3c,	NODEST,	0xbef6,	0xe1c7,	NODEST,	0xe1c4,	0xc6ed,
	/* 78 */
	0xe1c3,	0xcd3d,	0xcd3e,	0xcd3f,	0xcd40,	0xcd41,	0xcd42,	0xb5a6,
	/* 80 */
	NODEST,	0xcd43,	0xe1ca,	NODEST,	NODEST,	0xcd44,	0xe1c5,	0xe1c6,
	/* 88 */
	NODEST,	0xe1c9,	0xe1c8,	0xc9a5,	NODEST,	NODEST,	0xc1c2,	0xc1c1,
	/* 90 */
	0xcd45,	0xb5bf,	0xcd46,	0xcd47,	0xe1cb,	0xcd48,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xcd49,	0xe1cc,	NODEST,	0xcd4a,	0xe1cd,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	0xcd4b,	0xe1cf,	0xcd4c,	0xe1ce,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xb1d6,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xe1d7,	0xc8e8,	0xe1d1,	0xcd4d,	0xe1d3,	NODEST,	NODEST,
	/* B8 */
	0xe1d5,	0xbfbe,	0xcd4e,	NODEST,	0xe1d6,	0xe1d4,	0xbcc0,	0xcd4f,
	/* C0 */
	0xcd50,	0xcd51,	0xe1d0,	0xe1d2,	0xcd52,	0xc9c2,	0xcd53,	0xbec9,
	/* C8 */
	NODEST,	NODEST,	0xe1d9,	NODEST,	0xcd54,	0xe1d8,	0xcd55,	0xcd56,
	/* D0 */
	NODEST,	NODEST,	0xe1da,	NODEST,	0xbca6,	0xbaaf,	NODEST,	0xcd57,
	/* D8 */
	0xc5f7,	0xe1db,	NODEST,	0xc4cb,	0xcd58,	NODEST,	0xe1dd,	0xcd59,
	/* E0 */
	0xcd5a,	0xcd5b,	0xcea1,	0xe1dc,	0xcd5c,	NODEST,	NODEST,	0xcd5d,
	/* E8 */
	NODEST,	0xc1e9,	NODEST,	NODEST,	0xcd5e,	NODEST,	0xcd5f,	0xcd60,
	/* F0 */
	0xe1e2,	0xcd61,	0xe1e4,	0xe1e5,	0xc3d4,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	0xcd62,	0xe1e3,	NODEST,	0xe1e0,	NODEST,	0xe1de,	0xe1df,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_76[] = {
	/* 00 */
	0xcd63,	0xe1e1,	0xcd64,	0xcd65,	0xcd66,	NODEST,	NODEST,	0xcd67,
	/* 08 */
	0xcd68,	0xe1e8,	0xcd69,	0xe1e6,	0xcd6a,	0xe1e7,	NODEST,	0xcd6b,
	/* 10 */
	NODEST,	NODEST,	0xcd6c,	0xcd6d,	NODEST,	0xcd6e,	0xcd6f,	NODEST,
	/* 18 */
	NODEST,	0xcd70,	NODEST,	0xcd71,	0xcd72,	0xcd73,	0xcd74,	0xe1e9,
	/* 20 */
	0xe1eb,	0xe1ec,	0xe1ed,	0xcd75,	0xe1ee,	0xcd76,	0xcd77,	0xe1ea,
	/* 28 */
	NODEST,	0xcd78,	NODEST,	NODEST,	NODEST,	0xcd79,	NODEST,	NODEST,
	/* 30 */
	0xe1f0,	NODEST,	0xcd7a,	0xcd7b,	0xe1ef,	0xcd7c,	NODEST,	NODEST,
	/* 38 */
	0xcd7d,	0xcd7e,	0xce21,	0xe1f1,	0xce22,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xce24,	0xce25,	0xcec5,	0xce26,	0xce27,	0xce28,	0xe1f4,	0xe1f2,
	/* 48 */
	0xe1f3,	0xce29,	0xce23,	0xce2a,	0xb4e2,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	0xccfe,	NODEST,	NODEST,	0xce2b,	0xcaca,	NODEST,
	/* 58 */
	0xe1f6,	0xce2c,	NODEST,	NODEST,	0xe1f5,	NODEST,	NODEST,	0xce2d,
	/* 60 */
	NODEST,	0xe1f7,	0xe1f8,	NODEST,	0xce2e,	0xce2f,	NODEST,	0xe1fc,
	/* 68 */
	0xe1f9,	0xe1fa,	0xe1fb,	NODEST,	0xe1fd,	0xce30,	0xce31,	0xce32,
	/* 70 */
	0xe1fe,	0xce33,	0xe2a1,	NODEST,	0xce34,	NODEST,	0xe2a2,	NODEST,
	/* 78 */
	0xe2a3,	NODEST,	0xc8af,	0xc5d0,	0xe2a4,	0xc7f2,	0xc9b4,	NODEST,
	/* 80 */
	0xe2a5,	0xce35,	0xf451,	0xe2a6,	0xc5aa,	0xce36,	0xb3a7,	0xb9c4,
	/* 88 */
	0xe2a7,	NODEST,	NODEST,	0xe2a8,	0xce37,	0xce38,	0xe2a9,	NODEST,
	/* 90 */
	0xbba9,	NODEST,	NODEST,	0xe2ab,	NODEST,	0xce39,	0xe2aa,	NODEST,
	/* 98 */
	NODEST,	0xe2ac,	0xe2ad,	0xce3a,	0xce3b,	0xce3c,	0xf452,	0xce3d,
	/* A0 */
	0xce3e,	NODEST,	0xce3f,	0xce40,	0xce41,	0xce42,	0xce43,	0xce44,
	/* A8 */
	0xce45,	NODEST,	0xce46,	NODEST,	NODEST,	0xce47,	0xc8e9,	NODEST,
	/* B0 */
	0xe2ae,	NODEST,	NODEST,	NODEST,	0xe2af,	NODEST,	NODEST,	0xf3e9,
	/* B8 */
	0xe2b0,	0xe2b1,	0xe2b2,	NODEST,	NODEST,	0xce48,	NODEST,	0xbbae,
	/* C0 */
	NODEST,	0xce49,	0xe2b3,	0xc7d6,	NODEST,	0xce4a,	0xcbdf,	NODEST,
	/* C8 */
	0xb1ce,	0xce4b,	0xb1d7,	0xce4c,	0xce4d,	0xe2b4,	0xce4e,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xe2b6,	NODEST,	0xce4f,	NODEST,	0xe2b5,	0xc5f0,
	/* D8 */
	NODEST,	0xce50,	NODEST,	0xc0b9,	0xddb9,	NODEST,	0xe2b7,	0xccc1,
	/* E0 */
	0xce51,	0xe2b8,	NODEST,	0xb4c6,	0xc8d7,	0xe2b9,	0xce52,	0xe2ba,
	/* E8 */
	0xce53,	NODEST,	0xe2bb,	NODEST,	0xce54,	NODEST,	0xccdc,	NODEST,
	/* F0 */
	0xce55,	0xce56,	0xccd5,	NODEST,	0xc4be,	NODEST,	0xce57,	NODEST,
	/* F8 */
	0xc1ea,	0xce58,	NODEST,	0xe2bd,	0xce59,	NODEST,	0xbde2,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_77[] = {
	/* 00 */
	0xce5a,	0xbeca,	NODEST,	NODEST,	0xe2c0,	NODEST,	0xce5b,	0xe2bf,
	/* 08 */
	0xe2be,	0xc8fd,	0xce5c,	0xb4c7,	0xb8a9,	NODEST,	0xce5d,	NODEST,
	/* 10 */
	NODEST,	NODEST,	0xce5e,	NODEST,	0xce5f,	0xce60,	NODEST,	0xce61,
	/* 18 */
	NODEST,	0xce62,	0xce63,	0xe2c6,	0xce64,	NODEST,	0xe2c3,	0xbfbf,
	/* 20 */
	0xccb2,	NODEST,	0xce65,	NODEST,	0xe2c2,	0xe2c4,	0xe2c5,	NODEST,
	/* 28 */
	0xce66,	0xe2c1,	NODEST,	NODEST,	NODEST,	0xce67,	0xce68,	0xce69,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xce6a,	0xce6b,	0xce6c,	0xe2c7,
	/* 38 */
	0xe2c8,	0xce6d,	0xc4af,	NODEST,	0xb4e3,	0xce6e,	0xce6f,	NODEST,
	/* 40 */
	0xc3e5,	NODEST,	0xce70,	NODEST,	NODEST,	0xce71,	0xce72,	0xe2c9,
	/* 48 */
	NODEST,	NODEST,	0xce73,	NODEST,	NODEST,	0xce74,	0xce75,	0xce76,
	/* 50 */
	NODEST,	NODEST,	0xce77,	NODEST,	NODEST,	NODEST,	0xce78,	0xce79,
	/* 58 */
	NODEST,	NODEST,	0xe2ca,	0xe2cd,	0xce7a,	NODEST,	0xce7b,	0xce7c,
	/* 60 */
	0xce7d,	0xbfe7,	0xce7e,	0xc6c4,	0xcf21,	0xe2ce,	0xcbd3,	0xcf22,
	/* 68 */
	0xe2cb,	NODEST,	0xcf23,	0xe2cc,	0xcf24,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xcf25,	NODEST,	0xcf26,	0xcf27,	0xcf28,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	0xe2d1,	0xcf29,	NODEST,	NODEST,	0xcf2a,	0xe2d0,	0xe2cf,
	/* 80 */
	0xcf2b,	NODEST,	NODEST,	NODEST,	0xcf2c,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	0xe2d3,	0xcf2d,	0xcf2e,	0xe2d2,	NODEST,
	/* 90 */
	NODEST,	0xe2d4,	NODEST,	NODEST,	0xcf2f,	0xcf30,	0xcf31,	NODEST,
	/* 98 */
	NODEST,	NODEST,	0xcf32,	NODEST,	NODEST,	NODEST,	0xe2d6,	0xcf33,
	/* A0 */
	0xe2d5,	NODEST,	0xcf34,	NODEST,	NODEST,	0xcacd,	NODEST,	0xcf35,
	/* A8 */
	NODEST,	NODEST,	0xcf36,	NODEST,	0xbdd6,	0xcec6,	0xcf37,	0xcf38,
	/* B0 */
	0xe2d7,	0xcf39,	NODEST,	0xc6b7,	NODEST,	0xcf3a,	0xe2d8,	NODEST,
	/* B8 */
	NODEST,	0xe2d9,	NODEST,	0xe2dd,	0xe2db,	0xe2dc,	0xcf3b,	0xe2da,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xcf3c,	NODEST,	NODEST,	NODEST,	0xe2de,
	/* C8 */
	NODEST,	0xcf3d,	NODEST,	NODEST,	NODEST,	0xe2df,	NODEST,	NODEST,
	/* D0 */
	NODEST,	0xcf3e,	0xcf3f,	NODEST,	NODEST,	0xcf40,	NODEST,	0xe2e0,
	/* D8 */
	NODEST,	0xcf41,	0xe2e1,	0xccb7,	0xe2e2,	NODEST,	0xcf42,	0xcf43,
	/* E0 */
	0xcf44,	NODEST,	0xccf0,	0xe2e3,	0xcf45,	0xc3ce,	0xcf46,	0xc7ea,
	/* E8 */
	NODEST,	0xb6eb,	0xcf47,	NODEST,	0xcf48,	0xc3bb,	0xe2e4,	0xb6ba,
	/* F0 */
	0xcf49,	0xcf4a,	NODEST,	0xc0d0,	0xcf4b,	NODEST,	NODEST,	NODEST,
	/* F8 */
	0xcf4c,	NODEST,	NODEST,	0xcf4d,	0xe2e5,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_78[] = {
	/* 00 */
	NODEST,	NODEST,	0xbabd,	NODEST,	NODEST,	0xcf4e,	0xcf4f,	NODEST,
	/* 08 */
	NODEST,	0xcf50,	NODEST,	NODEST,	0xe2e6,	0xcf51,	0xcf52,	NODEST,
	/* 10 */
	NODEST,	0xcf53,	0xe2e7,	NODEST,	0xb8a6,	0xbad5,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xcf54,	NODEST,	NODEST,
	/* 20 */
	0xe2e9,	0xcf55,	0xcf56,	0xcf57,	NODEST,	0xc5d6,	0xbad6,	0xb5ce,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xcf58,	0xcf59,	NODEST,
	/* 30 */
	0xcf5a,	NODEST,	0xcba4,	NODEST,	0xc7cb,	0xcf5b,	NODEST,	0xcf5c,
	/* 38 */
	NODEST,	NODEST,	0xc5d7,	NODEST,	NODEST,	NODEST,	NODEST,	0xb9dc,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xcf5d,	0xcf5e,	0xe2eb,	NODEST,	0xcf5f,
	/* 48 */
	0xcf60,	NODEST,	NODEST,	NODEST,	0xcf61,	NODEST,	0xcf62,	NODEST,
	/* 50 */
	NODEST,	NODEST,	0xcf63,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xcf64,	0xbecb,	0xcf65,	NODEST,
	/* 60 */
	0xcf66,	0xcf67,	NODEST,	0xcf68,	0xcf69,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xcf6a,	NODEST,	0xcf6b,	0xceb2,	0xb9c5,	NODEST,	0xcf6c,	0xb8a7,
	/* 70 */
	NODEST,	NODEST,	0xc8a3,	NODEST,	0xe2ed,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	0xcf6d,	NODEST,	0xe2ef,	NODEST,	0xcf6e,	NODEST,
	/* 80 */
	NODEST,	0xb8eb,	NODEST,	NODEST,	NODEST,	NODEST,	0xe2ee,	0xc4f6,
	/* 88 */
	NODEST,	NODEST,	0xcf6f,	NODEST,	0xe2f1,	0xb3b7,	0xe2ec,	0xcf70,
	/* 90 */
	NODEST,	0xc8ea,	NODEST,	0xb1b0,	0xcf71,	0xbaec,	NODEST,	0xcfd2,
	/* 98 */
	0xcf72,	NODEST,	0xe2f0,	NODEST,	NODEST,	0xcf74,	0xcf75,	0xcf76,
	/* A0 */
	NODEST,	0xcf73,	NODEST,	0xe2f2,	0xcf77,	NODEST,	NODEST,	0xcacb,
	/* A8 */
	0xcf78,	0xc0d9,	0xe2f4,	NODEST,	0xcf79,	0xcf7a,	NODEST,	0xe2f5,
	/* B0 */
	0xcf7b,	0xcf7c,	0xcf7d,	0xcf7e,	NODEST,	0xe2f3,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	0xb3ce,	0xd021,	0xe2fb,	0xd022,	0xe2fa,	0xd023,
	/* C0 */
	NODEST,	0xbca7,	NODEST,	NODEST,	NODEST,	0xe2fc,	0xe2f7,	0xd024,
	/* C8 */
	0xd025,	0xd026,	0xe2fd,	0xe2f8,	0xd027,	NODEST,	0xd028,	NODEST,
	/* D0 */
	0xc8d8,	0xe2f6,	0xd029,	0xd02a,	0xe2f9,	0xd02b,	0xd02c,	NODEST,
	/* D8 */
	NODEST,	NODEST,	0xe3a2,	0xd02e,	NODEST,	NODEST,	NODEST,	0xd02f,
	/* E0 */
	0xd030,	0xd031,	NODEST,	NODEST,	0xd02d,	NODEST,	0xd032,	0xe3a1,
	/* E8 */
	0xcbe1,	NODEST,	0xd033,	NODEST,	0xe2fe,	NODEST,	NODEST,	0xb0eb,
	/* F0 */
	NODEST,	NODEST,	0xd034,	0xd035,	0xe3a4,	NODEST,	0xd037,	0xd038,
	/* F8 */
	NODEST,	NODEST,	0xd039,	0xd03a,	NODEST,	0xe3a3,	NODEST,	0xd03b,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_79[] = {
	/* 00 */
	0xd036,	0xbecc,	NODEST,	NODEST,	NODEST,	NODEST,	0xd03c,	0xe3a5,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd03d,	NODEST,	0xc1c3,	NODEST,
	/* 10 */
	0xd03e,	0xe3a7,	0xe3a6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	0xe3a8,	0xd03f,	NODEST,	0xd040,	NODEST,	0xd041,	0xd042,
	/* 20 */
	0xd043,	NODEST,	NODEST,	NODEST,	NODEST,	0xd044,	0xe2e8,	0xd045,
	/* 28 */
	NODEST,	0xd046,	0xe2ea,	0xe3aa,	0xe3a9,	0xd047,	NODEST,	NODEST,
	/* 30 */
	0xf454,	0xd048,	NODEST,	NODEST,	0xd049,	0xd04a,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	0xbca8,	0xd04b,	0xcee9,	0xd04c,	0xbcd2,	0xd04d,
	/* 40 */
	0xe3ab,	0xb7b7,	NODEST,	NODEST,	0xd04e,	0xd04f,	0xd050,	0xb5c0,
	/* 48 */
	0xb5a7,	0xbbe3,	0xd051,	0xd052,	NODEST,	NODEST,	NODEST,	0xd053,
	/* 50 */
	0xcdb4,	0xd054,	NODEST,	0xe3b1,	0xd055,	0xe3b0,	0xc1c4,	0xe3ad,
	/* 58 */
	0xd056,	NODEST,	0xe3af,	0xd057,	0xd058,	0xbdcb,	0xbfc0,	0xe3ae,
	/* 60 */
	0xe3ac,	NODEST,	0xc7aa,	NODEST,	NODEST,	0xbecd,	NODEST,	0xd059,
	/* 68 */
	0xc9bc,	0xd05a,	NODEST,	0xd05b,	NODEST,	0xbad7,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	0xd05c,	NODEST,	NODEST,	NODEST,	NODEST,	0xc5f8,
	/* 78 */
	NODEST,	0xd05d,	0xe3b2,	0xd05e,	0xd05f,	NODEST,	0xd060,	0xe3b3,
	/* 80 */
	0xe3c9,	0xb6d8,	NODEST,	NODEST,	0xcfbd,	0xc1b5,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	0xe3b4,	0xd061,	0xd062,	0xb2d2,	0xc4f7,	0xcaa1,
	/* 90 */
	NODEST,	0xd063,	NODEST,	0xd064,	0xd065,	0xd066,	0xd067,	NODEST,
	/* 98 */
	0xd068,	NODEST,	NODEST,	0xd069,	0xd06a,	0xe3b5,	NODEST,	NODEST,
	/* A0 */
	NODEST,	0xd06b,	NODEST,	NODEST,	NODEST,	NODEST,	0xb5fa,	0xe3b6,
	/* A8 */
	0xd06c,	0xd06d,	0xe3b8,	0xd06e,	NODEST,	NODEST,	0xe3b9,	0xd06f,
	/* B0 */
	0xc7a9,	0xd070,	NODEST,	0xe3ba,	0xd071,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xd072,	0xe3bb,	0xe3bc,	0xd073,	NODEST,	0xb6d9,	0xb2d3,	0xc6c5,
	/* C0 */
	0xbda8,	0xbbe4,	0xd074,	NODEST,	0xd075,	NODEST,	NODEST,	0xd076,
	/* C8 */
	0xd077,	0xe3bd,	0xd078,	0xbda9,	NODEST,	NODEST,	NODEST,	0xd079,
	/* D0 */
	NODEST,	0xb2ca,	0xc9c3,	NODEST,	0xd07a,	0xe3be,	0xd07b,	NODEST,
	/* D8 */
	0xc8eb,	NODEST,	0xd07c,	NODEST,	NODEST,	0xd07d,	0xd07e,	0xc1c5,
	/* E0 */
	0xd121,	0xe3c1,	0xd122,	0xe3c2,	0xc7e9,	0xd123,	0xbfc1,	0xe3bf,
	/* E8 */
	NODEST,	0xc3e1,	0xd124,	0xd125,	0xe3c0,	0xd126,	NODEST,	NODEST,
	/* F0 */
	0xbece,	0xd127,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	0xd128,	NODEST,	NODEST,	0xb0dc,	0xd129,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7A[] = {
	/* 00 */
	0xb5a9,	NODEST,	0xd12a,	0xd12b,	NODEST,	NODEST,	NODEST,	0xd12c,
	/* 08 */
	0xe3c3,	0xd12d,	0xd12e,	0xc4f8,	0xd12f,	0xe3c4,	0xc0c7,	NODEST,
	/* 10 */
	NODEST,	0xd130,	NODEST,	NODEST,	0xccad,	0xd131,	NODEST,	0xc9a3,
	/* 18 */
	0xe3c5,	0xe3c6,	0xc3d5,	0xd132,	0xcec7,	NODEST,	0xd133,	0xe3c8,
	/* 20 */
	0xe3c7,	0xd134,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd135,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xd136,	NODEST,	0xd137,	0xbcef,	0xd138,
	/* 30 */
	0xd139,	0xe3ca,	0xb0f0,	NODEST,	0xd13a,	0xd13b,	NODEST,	0xe3cd,
	/* 38 */
	0xd13c,	0xd13d,	0xd13e,	0xe3cb,	0xb2d4,	0xb7ce,	0xe3cc,	0xb9c6,
	/* 40 */
	0xb9f2,	NODEST,	0xcae6,	0xe3ce,	0xd13f,	0xd140,	0xcbd4,	0xd141,
	/* 48 */
	0xd142,	0xe3d0,	NODEST,	NODEST,	0xd143,	0xc0d1,	0xb1cf,	0xb2ba,
	/* 50 */
	0xb0ac,	NODEST,	NODEST,	NODEST,	NODEST,	0xd144,	0xd145,	0xe3cf,
	/* 58 */
	NODEST,	0xd146,	NODEST,	NODEST,	0xd147,	0xd148,	NODEST,	0xd149,
	/* 60 */
	0xd14a,	0xe3d1,	0xe3d2,	0xbef7,	NODEST,	0xd14b,	NODEST,	0xd14c,
	/* 68 */
	NODEST,	0xe3d3,	0xd14d,	0xb3cf,	NODEST,	0xd14e,	NODEST,	NODEST,
	/* 70 */
	0xe3d5,	NODEST,	NODEST,	NODEST,	0xb7ea,	0xd14f,	0xb5e6,	NODEST,
	/* 78 */
	0xd150,	0xe3d6,	0xb6f5,	NODEST,	NODEST,	0xe3d7,	0xd151,	0xc0fc,
	/* 80 */
	0xd152,	0xc6cd,	0xd153,	0xc0e0,	0xbaf5,	0xd154,	0xd155,	NODEST,
	/* 88 */
	0xe3d8,	NODEST,	0xd156,	0xd157,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	0xd158,	0xd159,	0xc3e2,	0xc1eb,	0xd15a,	0xe3da,	0xe3dc,	0xe3d9,
	/* 98 */
	0xe3db,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd15b,	0xb7a2,
	/* A0 */
	0xd15c,	NODEST,	NODEST,	0xd15d,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	0xe3dd,	0xb7a6,	NODEST,	0xd15e,	NODEST,	0xb5e7,	0xcdd2,
	/* B0 */
	0xe3df,	NODEST,	NODEST,	0xd15f,	NODEST,	0xd160,	0xe3e0,	NODEST,
	/* B8 */
	NODEST,	0xd161,	0xb1ae,	0xd162,	0xd163,	NODEST,	NODEST,	0xe3e3,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xb3f6,	0xe3e2,	0xe3e1,	0xd164,	0xe3e5,
	/* C8 */
	0xe3de,	0xd165,	0xe3e6,	0xcea9,	0xd166,	0xe3e7,	0xd167,	0xe3e8,
	/* D0 */
	NODEST,	0xd168,	0xd4f4,	0xe3ea,	NODEST,	0xe3e9,	NODEST,	NODEST,
	/* D8 */
	NODEST,	0xe3eb,	0xe3ec,	0xd169,	0xceb5,	0xe3ed,	NODEST,	0xf0ef,
	/* E0 */
	0xbecf,	0xe3ee,	0xe3ef,	0xbdd7,	NODEST,	0xc6b8,	0xe3f0,	0xf459,
	/* E8 */
	0xd16a,	0xd16b,	0xc3a8,	0xd16c,	0xd16d,	0xe3f1,	NODEST,	0xc3bc,
	/* F0 */
	0xe3f2,	0xd16e,	NODEST,	NODEST,	0xd16f,	NODEST,	0xb6a5,	NODEST,
	/* F8 */
	0xd1bf,	0xc3dd,	0xbcb3,	0xd170,	NODEST,	0xd171,	0xd172,	0xb4c8,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7B[] = {
	/* 00 */
	NODEST,	NODEST,	0xe3f3,	NODEST,	0xe4a2,	NODEST,	0xe3f6,	0xd173,
	/* 08 */
	0xb5e8,	NODEST,	0xe3f5,	0xe4a4,	NODEST,	NODEST,	NODEST,	0xe3f4,
	/* 10 */
	NODEST,	0xbed0,	NODEST,	NODEST,	0xd174,	NODEST,	NODEST,	NODEST,
	/* 18 */
	0xe3f8,	0xe3f9,	NODEST,	0xc5ab,	NODEST,	NODEST,	0xe3fa,	0xd175,
	/* 20 */
	0xb3de,	NODEST,	NODEST,	0xd176,	NODEST,	0xbfda,	0xc9e4,	0xd177,
	/* 28 */
	0xe3fc,	0xd178,	0xd179,	0xd17a,	0xc2e8,	0xd17b,	0xd17c,	0xd17d,
	/* 30 */
	0xd17e,	0xd221,	NODEST,	0xe3f7,	0xd222,	0xe3fb,	0xe3fd,	NODEST,
	/* 38 */
	NODEST,	0xbafb,	NODEST,	NODEST,	NODEST,	0xd223,	NODEST,	0xd224,
	/* 40 */
	0xd225,	0xd226,	NODEST,	NODEST,	NODEST,	0xe4a6,	0xc9ae,	0xd227,
	/* 48 */
	0xc8a6,	0xc5f9,	NODEST,	0xb6da,	0xe4a5,	0xe4a3,	0xd228,	0xc8b5,
	/* 50 */
	0xe3fe,	0xc3de,	0xc5fb,	NODEST,	0xc5fa,	0xd229,	0xbaf6,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe4b8,	NODEST,	NODEST,
	/* 60 */
	0xd22a,	NODEST,	NODEST,	NODEST,	0xd22b,	0xe4a8,	0xd22c,	0xe4aa,
	/* 68 */
	NODEST,	0xd22d,	0xd22e,	NODEST,	0xe4ad,	0xd22f,	0xe4ae,	0xd230,
	/* 70 */
	0xe4ab,	0xe4ac,	0xd231,	0xd232,	0xe4a9,	0xe4a7,	NODEST,	0xd233,
	/* 78 */
	NODEST,	NODEST,	0xe4a1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd234,	NODEST,	0xcacf,	0xb2d5,
	/* 88 */
	NODEST,	0xd235,	NODEST,	0xe4b5,	NODEST,	0xe4b2,	0xd236,	0xe4b7,
	/* 90 */
	0xd237,	0xd238,	0xe4b6,	NODEST,	0xc7f3,	0xcca7,	0xd239,	0xbbbb,
	/* 98 */
	0xe4b0,	0xe4b9,	0xe4b4,	0xd23a,	0xe4b3,	0xe4af,	0xd23b,	0xe4b1,
	/* A0 */
	0xd23c,	0xb4c9,	NODEST,	NODEST,	NODEST,	0xd23d,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	0xc3bd,	NODEST,	0xd23e,	0xc0fd,	NODEST,	0xd23f,
	/* B0 */
	0xd240,	0xc8a2,	0xd241,	NODEST,	0xe4be,	0xd242,	0xd243,	NODEST,
	/* B8 */
	0xc8a4,	NODEST,	0xd244,	0xd245,	0xd246,	0xd247,	NODEST,	NODEST,
	/* C0 */
	0xc0e1,	0xe4bb,	0xd248,	NODEST,	0xc8cf,	0xd249,	0xe4bf,	0xcad3,
	/* C8 */
	0xd24a,	0xc3db,	0xd24b,	0xe4ba,	0xe4bc,	NODEST,	NODEST,	0xe4bd,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd24c,	NODEST,	0xd24d,	0xd24e,
	/* D8 */
	NODEST,	0xd24f,	0xd250,	0xd251,	NODEST,	0xe4c0,	NODEST,	NODEST,
	/* E0 */
	0xbcc4,	NODEST,	NODEST,	NODEST,	0xc6c6,	0xe4c5,	0xe4c4,	NODEST,
	/* E8 */
	0xd252,	0xe4c1,	0xd253,	NODEST,	NODEST,	0xcfb6,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	0xd254,	0xe4ca,	0xd255,	0xd256,	0xe4ce,	0xe4cb,
	/* F8 */
	0xd257,	0xd258,	0xd259,	NODEST,	0xd25a,	NODEST,	0xd25b,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7C[] = {
	/* 00 */
	0xe4c7,	0xd25c,	0xd25d,	0xd25e,	0xd25f,	NODEST,	0xd260,	0xe4c8,
	/* 08 */
	NODEST,	0xd261,	NODEST,	0xd262,	0xd263,	0xe4cd,	0xd264,	0xd265,
	/* 10 */
	NODEST,	0xe4c2,	0xd2d5,	0xe4c9,	0xe4c3,	NODEST,	NODEST,	0xe4cc,
	/* 18 */
	NODEST,	0xd266,	NODEST,	0xd267,	NODEST,	NODEST,	NODEST,	0xe4d2,
	/* 20 */
	0xd268,	0xb4ca,	NODEST,	0xe4cf,	NODEST,	0xd269,	0xd26a,	0xe4d0,
	/* 28 */
	0xd26b,	NODEST,	0xe4d1,	0xe4d4,	0xd26c,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	0xd26d,	NODEST,	0xd26e,	0xd26f,	NODEST,	0xd270,	0xe4d3,
	/* 38 */
	0xc8f6,	0xd271,	0xd272,	NODEST,	NODEST,	0xe4d5,	0xcefc,	0xcaed,
	/* 40 */
	0xe4da,	NODEST,	NODEST,	0xe4d7,	NODEST,	NODEST,	0xd273,	NODEST,
	/* 48 */
	NODEST,	NODEST,	0xd274,	NODEST,	0xe4d6,	0xc0d2,	NODEST,	0xe4d9,
	/* 50 */
	0xe4db,	0xd276,	0xd277,	0xd278,	0xe4d8,	0xd275,	0xe4df,	NODEST,
	/* 58 */
	0xe4dc,	0xd279,	0xd27a,	0xd27b,	0xd27c,	0xd27d,	0xd27e,	0xe4dd,
	/* 60 */
	0xe4c6,	0xd321,	NODEST,	0xd322,	0xe4de,	0xe4e0,	NODEST,	0xd323,
	/* 68 */
	NODEST,	0xd324,	NODEST,	NODEST,	0xe4e1,	0xd325,	0xd326,	NODEST,
	/* 70 */
	0xd327,	NODEST,	0xd328,	0xcac6,	NODEST,	0xe4e2,	NODEST,	NODEST,
	/* 78 */
	NODEST,	0xd329,	NODEST,	NODEST,	0xd32a,	0xd32b,	0xcce2,	NODEST,
	/* 80 */
	NODEST,	0xb6ce,	0xb7a9,	0xe4e3,	NODEST,	NODEST,	0xd32c,	0xd32d,
	/* 88 */
	NODEST,	0xcab4,	NODEST,	0xbfe8,	NODEST,	0xccb0,	NODEST,	0xd32e,
	/* 90 */
	0xe4e4,	NODEST,	0xceb3,	NODEST,	0xd32f,	0xc7f4,	NODEST,	0xc1c6,
	/* 98 */
	0xc7b4,	NODEST,	NODEST,	0xbdcd,	NODEST,	NODEST,	0xd330,	0xb0c0,
	/* A0 */
	0xd331,	0xe4e9,	0xe4e7,	NODEST,	0xe4e5,	0xb4a1,	0xd332,	0xbed1,
	/* A8 */
	0xe4ea,	NODEST,	NODEST,	0xe4e8,	NODEST,	0xe4e6,	0xe4ee,	NODEST,
	/* B0 */
	0xd333,	0xe4ed,	0xe4ec,	0xe4eb,	NODEST,	NODEST,	0xd334,	0xd335,
	/* B8 */
	NODEST,	0xe4ef,	0xd336,	0xd337,	0xd338,	0xe4f0,	0xc0ba,	0xd339,
	/* C0 */
	0xe4f1,	NODEST,	0xe4f3,	NODEST,	0xd33a,	0xe4f2,	NODEST,	0xd33b,
	/* C8 */
	0xd33c,	0xd33d,	0xb8d2,	NODEST,	NODEST,	0xd33e,	0xc1b8,	0xd33f,
	/* D0 */
	NODEST,	NODEST,	0xe4f5,	0xd340,	0xd341,	0xd342,	0xc5fc,	0xd343,
	/* D8 */
	0xe4f4,	0xd344,	0xd345,	NODEST,	0xe4f6,	0xd346,	0xcab5,	0xc1ec,
	/* E0 */
	0xb9c7,	NODEST,	0xe4f7,	NODEST,	NODEST,	NODEST,	0xd347,	0xcec8,
	/* E8 */
	NODEST,	0xd348,	NODEST,	0xd349,	NODEST,	NODEST,	NODEST,	0xe4f9,
	/* F0 */
	NODEST,	NODEST,	0xe4fa,	NODEST,	0xe4fb,	0xd34a,	0xe4fc,	NODEST,
	/* F8 */
	0xbbe5,	NODEST,	0xe4fd,	0xb7cf,	NODEST,	NODEST,	0xb5ea,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7D[] = {
	/* 00 */
	0xb5aa,	NODEST,	0xe5a1,	0xd34b,	0xccf3,	0xb9c8,	0xe4fe,	0xd34c,
	/* 08 */
	0xd34d,	0xd34e,	0xe5a4,	0xcce6,	NODEST,	0xc7bc,	NODEST,	0xd34f,
	/* 10 */
	0xc9b3,	0xd350,	0xd351,	0xd352,	0xbde3,	0xe5a3,	0xd353,	0xbcd3,
	/* 18 */
	0xb9c9,	0xbbe6,	0xb5e9,	0xcab6,	0xe5a2,	0xd354,	0xd355,	NODEST,
	/* 20 */
	0xc1c7,	0xcbc2,	0xbaf7,	0xd356,	NODEST,	NODEST,	0xd357,	NODEST,
	/* 28 */
	NODEST,	NODEST,	0xd358,	0xbbe7,	0xc4dd,	0xd359,	0xe5a7,	0xcedf,
	/* 30 */
	0xbad9,	0xd35a,	0xe5a8,	0xbfc2,	NODEST,	0xe5aa,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xbed2,	0xbab0,	NODEST,	0xd35b,	0xd35c,	0xd35d,	0xe5a9,
	/* 40 */
	0xd35e,	0xd35f,	0xbdaa,	0xb8be,	0xc1c8,	0xe5a5,	0xe5ab,	0xd360,
	/* 48 */
	0xd361,	NODEST,	NODEST,	0xe5a6,	0xb7d0,	0xd362,	0xe5ae,	0xe5b2,
	/* 50 */
	0xb7eb,	0xd363,	NODEST,	0xd364,	NODEST,	NODEST,	0xe5ad,	0xd365,
	/* 58 */
	NODEST,	0xd366,	0xd367,	0xe5b6,	0xd368,	0xd369,	0xb9ca,	NODEST,
	/* 60 */
	NODEST,	0xcded,	0xb0bc,	0xe5b3,	NODEST,	0xd36a,	0xb5eb,	0xd36b,
	/* 68 */
	0xe5b0,	NODEST,	0xd36c,	NODEST,	NODEST,	NODEST,	0xe5b1,	NODEST,
	/* 70 */
	0xd36d,	0xc5fd,	0xe5af,	0xe5ac,	NODEST,	0xb3a8,	0xc0e4,	NODEST,
	/* 78 */
	0xd36e,	0xb8a8,	0xd36f,	0xd370,	NODEST,	0xe5b8,	NODEST,	0xd371,
	/* 80 */
	NODEST,	0xd372,	0xd373,	0xd374,	NODEST,	0xd375,	0xd376,	NODEST,
	/* 88 */
	0xd377,	0xe5b5,	NODEST,	0xd378,	0xd379,	0xd37a,	NODEST,	0xe5b7,
	/* 90 */
	NODEST,	0xd37b,	NODEST,	0xe5b4,	NODEST,	NODEST,	0xd37c,	0xd37d,
	/* 98 */
	NODEST,	0xb7d1,	0xc2b3,	0xe5b9,	0xc1ee,	0xd37e,	0xd421,	0xe5c6,
	/* A0 */
	0xf45c,	NODEST,	0xe5c2,	0xe5bc,	NODEST,	NODEST,	0xd422,	0xd423,
	/* A8 */
	NODEST,	NODEST,	0xd424,	0xe5c0,	0xbcfa,	0xb0dd,	0xe5bb,	0xe5c3,
	/* B0 */
	0xe5c7,	0xb9cb,	0xccd6,	0xd425,	0xc4d6,	0xe5bd,	0xd426,	0xd427,
	/* B8 */
	0xe5c5,	0xd428,	0xe5ba,	0xc3be,	NODEST,	0xe5bf,	0xb0bd,	0xccca,
	/* C0 */
	NODEST,	NODEST,	0xd429,	0xd42a,	0xd42b,	0xd42c,	0xd42d,	0xe5be,
	/* C8 */
	NODEST,	NODEST,	0xb6db,	0xc8ec,	0xd42e,	0xd42f,	0xd430,	0xc1ed,
	/* D0 */
	NODEST,	0xced0,	0xbdef,	NODEST,	NODEST,	0xe5ee,	0xf45d,	0xd431,
	/* D8 */
	0xe5c8,	0xd432,	0xc0fe,	NODEST,	0xe5c4,	0xe5c9,	0xe5cb,	NODEST,
	/* E0 */
	0xc4f9,	0xe5ce,	0xd434,	NODEST,	0xe5ca,	0xd435,	0xd436,	NODEST,
	/* E8 */
	0xcad4,	0xb4cb,	0xd437,	0xd438,	0xcccb,	0xd439,	NODEST,	0xb0de,
	/* F0 */
	NODEST,	0xd43a,	0xe5cd,	NODEST,	0xcefd,	0xd43b,	0xd43c,	NODEST,
	/* F8 */
	NODEST,	0xd43d,	0xd43e,	0xe5cc,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7E[] = {
	/* 00 */
	0xd433,	0xb1ef,	NODEST,	NODEST,	0xc6ec,	0xe5cf,	NODEST,	NODEST,
	/* 08 */
	0xd43f,	0xe5d6,	0xe5d0,	0xe5d7,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	0xd440,	0xd441,	0xe5d3,	NODEST,	NODEST,	0xd442,	NODEST,	0xd443,
	/* 18 */
	NODEST,	NODEST,	NODEST,	0xc7fb,	0xd444,	0xd445,	0xbcca,	0xe5d5,
	/* 20 */
	0xd446,	0xe5d2,	0xe5d8,	0xe5d1,	NODEST,	NODEST,	0xbdc4,	0xd447,
	/* 28 */
	0xd448,	NODEST,	NODEST,	0xcba5,	0xd449,	0xd44a,	0xbdcc,	0xd44b,
	/* 30 */
	NODEST,	0xe5d4,	0xe5e0,	0xd44c,	NODEST,	0xe5dc,	0xd44d,	0xe5df,
	/* 38 */
	NODEST,	0xe5dd,	0xe5e1,	0xe5db,	NODEST,	0xe5c1,	0xc0d3,	0xd44e,
	/* 40 */
	NODEST,	0xc8cb,	NODEST,	0xe5de,	0xd44f,	0xd450,	0xe5d9,	0xd451,
	/* 48 */
	NODEST,	NODEST,	0xc1a1,	0xb7d2,	NODEST,	0xbdab,	0xd452,	NODEST,
	/* 50 */
	0xd453,	NODEST,	0xd454,	NODEST,	0xbfa5,	0xc1b6,	0xe5e4,	NODEST,
	/* 58 */
	0xd455,	0xe5e6,	0xe5e7,	NODEST,	NODEST,	0xe5e3,	0xe5e5,	0xd456,
	/* 60 */
	NODEST,	0xd457,	0xd458,	NODEST,	NODEST,	0xd459,	0xe5da,	0xe5e2,
	/* 68 */
	NODEST,	0xe5ea,	0xe5e9,	0xd45a,	NODEST,	0xcbfa,	0xd45b,	0xd45c,
	/* 70 */
	0xb7ab,	NODEST,	NODEST,	0xd45d,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	0xd45e,	0xe5e8,	NODEST,	0xe5ec,	0xe5eb,	0xe5ef,	0xd45f,	0xe5f1,
	/* 80 */
	NODEST,	0xd460,	0xbbbc,	0xe5ed,	NODEST,	NODEST,	0xd461,	0xd462,
	/* 88 */
	0xe5f2,	0xe5f3,	0xd463,	NODEST,	0xe5f4,	0xd464,	0xe5fa,	0xc5bb,
	/* 90 */
	0xe5f6,	0xd465,	0xe5f5,	0xe5f7,	0xe5f8,	0xd466,	0xe5f9,	NODEST,
	/* 98 */
	0xd467,	NODEST,	0xd468,	0xe5fb,	0xe5fc,	0xd469,	0xd46a,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_7F[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb4cc,	NODEST,
	/* 38 */
	0xe5fd,	NODEST,	0xe5fe,	0xd46c,	0xd46b,	0xd46d,	0xd46e,	0xd46f,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xd470,	0xd471,	0xe6a1,	NODEST,	0xd472,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xe6a2,	0xe6a3,	0xe6a4,	0xd473,
	/* 50 */
	0xe6a5,	0xe6a6,	0xd474,	0xd475,	0xe6a8,	0xe6a7,	NODEST,	NODEST,
	/* 58 */
	0xe6a9,	NODEST,	NODEST,	0xd476,	0xd477,	0xd478,	NODEST,	0xe6aa,
	/* 60 */
	0xe6ab,	0xd479,	NODEST,	0xd47a,	0xd47b,	0xd47c,	0xd47d,	0xe6ae,
	/* 68 */
	0xe6ac,	0xe6ad,	0xbae1,	0xb7d3,	NODEST,	0xd47e,	0xc3d6,	NODEST,
	/* 70 */
	0xc8b3,	0xd521,	0xbdf0,	NODEST,	NODEST,	0xc7cd,	NODEST,	0xc8ed,
	/* 78 */
	0xe6af,	0xd8ed,	NODEST,	NODEST,	NODEST,	0xd522,	0xd523,	0xd524,
	/* 80 */
	0xd525,	NODEST,	0xe6b0,	0xe6b2,	NODEST,	0xcde5,	0xe6b1,	0xe6b4,
	/* 88 */
	0xe6b3,	NODEST,	0xcdd3,	0xd526,	0xe6b5,	0xd527,	0xc8fe,	0xd528,
	/* 90 */
	0xd529,	0xd52a,	NODEST,	NODEST,	0xe6b6,	NODEST,	0xd52b,	0xd52c,
	/* 98 */
	NODEST,	NODEST,	0xe6b9,	NODEST,	0xd52d,	0xe6b8,	0xe6b7,	NODEST,
	/* A0 */
	NODEST,	0xd52e,	0xd52f,	0xe6ba,	0xb7b2,	NODEST,	0xd530,	NODEST,
	/* A8 */
	0xc1a2,	0xb5c1,	0xd531,	NODEST,	NODEST,	0xd532,	0xe6be,	0xe6bb,
	/* B0 */
	NODEST,	NODEST,	0xe6bc,	NODEST,	0xd533,	NODEST,	0xe6bf,	NODEST,
	/* B8 */
	0xe6c0,	0xe6bd,	NODEST,	NODEST,	0xd534,	0xb1a9,	NODEST,	0xd535,
	/* C0 */
	0xd536,	0xb2a7,	NODEST,	0xd537,	NODEST,	0xe6c2,	0xe6c3,	NODEST,
	/* C8 */
	0xd538,	NODEST,	0xe6c4,	NODEST,	0xcde2,	NODEST,	0xd539,	0xd53a,
	/* D0 */
	NODEST,	NODEST,	0xbdac,	NODEST,	0xe6c6,	0xe6c5,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	0xd53b,	NODEST,	NODEST,	NODEST,	0xd53c,
	/* E0 */
	0xbfe9,	0xe6c7,	NODEST,	0xd53d,	NODEST,	0xd53e,	0xe6c8,	NODEST,
	/* E8 */
	0xd53f,	0xe6c9,	NODEST,	0xb4e5,	0xd540,	NODEST,	0xd541,	0xd542,
	/* F0 */
	0xb4cd,	NODEST,	0xd543,	0xe6ca,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	0xe6cb,	0xd544,	0xcbdd,	0xcde3,	0xd545,	0xd546,	0xd547,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_80[] = {
	/* 00 */
	0xcdd4,	0xcfb7,	NODEST,	0xb9cd,	0xe6ce,	0xbcd4,	0xe6cd,	0xd548,
	/* 08 */
	0xd549,	NODEST,	0xd54a,	0xe6cf,	0xbca9,	0xd54b,	0xd54c,	0xd54d,
	/* 10 */
	0xc2d1,	0xd54e,	0xe6d0,	0xd54f,	0xd550,	0xb9cc,	0xd551,	0xccd7,
	/* 18 */
	0xe6d1,	0xe6d2,	NODEST,	NODEST,	0xe6d3,	0xd552,	0xd553,	0xd554,
	/* 20 */
	0xd555,	0xe6d4,	NODEST,	NODEST,	0xd556,	NODEST,	0xd557,	NODEST,
	/* 28 */
	0xe6d5,	NODEST,	NODEST,	NODEST,	0xd558,	NODEST,	0xd559,	NODEST,
	/* 30 */
	0xd55a,	NODEST,	NODEST,	0xbcaa,	0xd55b,	0xd55c,	0xcced,	0xd55d,
	/* 38 */
	NODEST,	0xd55e,	0xd55f,	0xe6d7,	0xd560,	0xc3bf,	0xd561,	0xe6d6,
	/* 40 */
	0xd562,	NODEST,	NODEST,	NODEST,	0xd563,	NODEST,	0xe6d9,	NODEST,
	/* 48 */
	NODEST,	NODEST,	0xe6d8,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	0xe6da,	NODEST,	NODEST,	NODEST,	0xc0bb,	NODEST,
	/* 58 */
	0xe6db,	NODEST,	0xe6dc,	NODEST,	NODEST,	NODEST,	0xcab9,	0xe6dd,
	/* 60 */
	0xd564,	0xc1ef,	0xe6de,	NODEST,	0xd565,	NODEST,	0xd566,	NODEST,
	/* 68 */
	0xe6df,	NODEST,	NODEST,	NODEST,	NODEST,	0xd567,	NODEST,	0xcefe,
	/* 70 */
	0xe6e2,	0xd568,	0xe6e1,	0xe6e0,	0xc4b0,	0xd569,	0xe6e3,	0xbfa6,
	/* 78 */
	NODEST,	0xe6e4,	NODEST,	NODEST,	NODEST,	0xe6e5,	0xcfb8,	0xe6e6,
	/* 80 */
	NODEST,	0xd56a,	NODEST,	NODEST,	0xe6e7,	0xe6e9,	0xe6e8,	0xc8a5,
	/* 88 */
	0xd56b,	0xc6f9,	NODEST,	0xcfbe,	0xc8a9,	NODEST,	0xd56c,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	0xe6eb,	NODEST,	NODEST,	0xbed3,	NODEST,
	/* 98 */
	0xc9aa,	NODEST,	0xe6ec,	0xe6ea,	0xd56d,	0xb4ce,	0xd56e,	NODEST,
	/* A0 */
	NODEST,	0xb8d4,	0xbbe8,	NODEST,	NODEST,	0xc8ee,	0xd56f,	0xd570,
	/* A8 */
	NODEST,	0xb8aa,	0xcbc3,	0xd571,	0xe6ef,	0xe6ed,	NODEST,	0xb9ce,
	/* B0 */
	NODEST,	0xb9cf,	0xb0e9,	NODEST,	0xbae8,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xd572,	0xd573,	0xc7d9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xb0df,	0xe6f4,	NODEST,	0xc3c0,	NODEST,
	/* C8 */
	0xd574,	NODEST,	NODEST,	NODEST,	0xc7d8,	0xd575,	0xc2db,	0xd576,
	/* D0 */
	NODEST,	NODEST,	0xd577,	NODEST,	0xd578,	0xd579,	0xe6f6,	0xd57a,
	/* D8 */
	0xd57b,	0xe6f2,	0xe6f5,	0xe6f0,	NODEST,	0xe6f3,	0xcba6,	NODEST,
	/* E0 */
	0xd57c,	0xb8d5,	NODEST,	NODEST,	0xb0fd,	0xe6f1,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd57d,	0xd57e,	0xe6f8,
	/* F0 */
	0xd621,	0xe6f9,	0xd622,	0xd623,	0xc6b9,	NODEST,	0xd624,	NODEST,
	/* F8 */
	0xb6bb,	0xd625,	0xd626,	NODEST,	0xe7a6,	0xc7bd,	0xd627,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_81[] = {
	/* 00 */
	NODEST,	NODEST,	0xbbe9,	0xd628,	NODEST,	0xb6bc,	0xc0c8,	0xcfc6,
	/* 08 */
	0xccae,	0xe6f7,	0xc0d4,	0xd629,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd62a,	0xd62b,
	/* 18 */
	0xd62c,	NODEST,	0xb5d3,	0xe6fa,	0xd62d,	NODEST,	0xd62e,	NODEST,
	/* 20 */
	0xd62f,	NODEST,	NODEST,	0xe6fc,	0xd630,	NODEST,	NODEST,	0xd631,
	/* 28 */
	NODEST,	0xe6fb,	NODEST,	NODEST,	0xd632,	NODEST,	NODEST,	0xe6fd,
	/* 30 */
	0xd633,	0xc3a6,	NODEST,	0xc7be,	NODEST,	0xd634,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xc4b1,	0xd635,	NODEST,	0xd636,	NODEST,	0xe7a3,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd637,	0xe7a2,	0xd638,
	/* 48 */
	NODEST,	NODEST,	0xd639,	0xe6fe,	0xd63a,	NODEST,	0xbfd5,	NODEST,
	/* 50 */
	0xc9e5,	0xe7a5,	0xd63b,	0xe7a4,	0xb9d0,	0xcfd3,	NODEST,	0xd63c,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe7b5,
	/* 60 */
	0xd63d,	0xd63e,	NODEST,	NODEST,	NODEST,	0xe7a9,	0xe7aa,	0xd63f,
	/* 68 */
	0xd640,	0xd641,	NODEST,	0xbcf0,	NODEST,	0xd642,	0xe7a8,	0xd643,
	/* 70 */
	0xb9f8,	0xe7a7,	NODEST,	NODEST,	0xe7ab,	NODEST,	NODEST,	0xd644,
	/* 78 */
	0xc4b2,	0xcaa2,	0xc1a3,	NODEST,	NODEST,	NODEST,	NODEST,	0xc2dc,
	/* 80 */
	0xe7af,	0xd645,	0xe7b0,	0xe7ac,	0xd647,	0xd648,	0xd649,	NODEST,
	/* 88 */
	0xe7ad,	NODEST,	0xe7ae,	0xd64a,	NODEST,	NODEST,	0xd64b,	0xb9d1,
	/* 90 */
	0xd646,	NODEST,	NODEST,	0xe7b6,	NODEST,	0xe7b2,	0xd64c,	NODEST,
	/* 98 */
	0xd64d,	NODEST,	0xc9e6,	0xd64e,	0xcbec,	0xc9a8,	0xd64f,	NODEST,
	/* A0 */
	0xe7b1,	NODEST,	0xd650,	0xe7b4,	0xe7b3,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xcbc4,	0xe7b7,	NODEST,	NODEST,	NODEST,	NODEST,	0xd651,	NODEST,
	/* B0 */
	0xe7b8,	NODEST,	0xd652,	0xc1b7,	0xd653,	0xe7b9,	NODEST,	NODEST,
	/* B8 */
	0xe7bb,	NODEST,	0xe7bf,	0xd654,	NODEST,	0xe7bc,	0xe7ba,	0xc7bf,
	/* C0 */
	0xe7bd,	NODEST,	0xe7be,	0xd656,	NODEST,	0xd657,	0xb2b2,	NODEST,
	/* C8 */
	0xe7c5,	0xe7c0,	0xd658,	0xd655,	NODEST,	0xe7c1,	0xd659,	0xd65a,
	/* D0 */
	NODEST,	0xe7c2,	NODEST,	0xc2a1,	NODEST,	0xd65b,	NODEST,	0xd65c,
	/* D8 */
	0xe7c4,	0xe7c3,	0xe7c6,	0xd65d,	NODEST,	0xd65e,	0xd65f,	0xe7c7,
	/* E0 */
	0xe7c8,	0xd660,	NODEST,	0xbfc3,	0xd661,	0xb2e9,	NODEST,	0xe7c9,
	/* E8 */
	0xced7,	NODEST,	0xbcab,	0xd662,	0xd663,	0xbdad,	NODEST,	NODEST,
	/* F0 */
	0xd664,	0xd665,	0xd666,	0xbbea,	0xc3d7,	0xd667,	0xd668,	NODEST,
	/* F8 */
	0xd669,	0xd66a,	0xe7ca,	0xe7cb,	0xb1b1,	0xd66b,	0xe7cc,	0xd66c,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_82[] = {
	/* 00 */
	0xd66d,	0xe7cd,	0xe7ce,	0xd66e,	NODEST,	0xe7cf,	NODEST,	0xe7d0,
	/* 08 */
	0xb6bd,	0xdaaa,	0xe7d1,	NODEST,	0xc0e5,	0xe7d2,	0xbccb,	0xd66f,
	/* 10 */
	0xe7d3,	NODEST,	0xd0b0,	0xd670,	0xd671,	NODEST,	0xe7d4,	0xcade,
	/* 18 */
	0xb4dc,	0xd672,	0xd673,	0xc1a4,	0xbdd8,	0xd674,	0xc9f1,	0xbdae,
	/* 20 */
	NODEST,	0xd675,	0xd676,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	0xd677,	0xe7d5,	0xb9d2,	0xe7d6,	0xc8cc,	NODEST,	0xe7e4,	NODEST,
	/* 30 */
	NODEST,	NODEST,	0xd678,	0xe7d8,	0xd679,	0xc2c9,	0xc7f5,	0xb8bf,
	/* 38 */
	0xe7d7,	0xc1a5,	0xd67a,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xe7d9,	NODEST,	NODEST,	0xd67b,	0xd67c,	0xd67d,	0xd67e,	0xc4fa,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xd721,	NODEST,	NODEST,	0xd722,	0xd723,
	/* 50 */
	NODEST,	0xd724,	NODEST,	NODEST,	NODEST,	NODEST,	0xd725,	NODEST,
	/* 58 */
	0xe7db,	0xe7da,	0xe7dd,	NODEST,	0xd726,	0xe7dc,	NODEST,	0xe7de,
	/* 60 */
	0xd727,	NODEST,	0xe7e0,	0xd728,	0xe7df,	NODEST,	0xb4cf,	0xd729,
	/* 68 */
	0xe7e1,	NODEST,	0xe7e2,	0xe7e3,	NODEST,	0xd72a,	0xbab1,	0xcec9,
	/* 70 */
	NODEST,	0xe7e5,	0xbfa7,	NODEST,	0xd72b,	NODEST,	0xb1f0,	0xe7e6,
	/* 78 */
	0xe7e7,	NODEST,	NODEST,	0xd72c,	NODEST,	0xd72d,	0xe7e8,	0xd72e,
	/* 80 */
	0xd72f,	0xd730,	NODEST,	0xd731,	0xd732,	NODEST,	NODEST,	0xd733,
	/* 88 */
	NODEST,	0xd734,	0xd735,	0xb0f2,	NODEST,	0xe7e9,	0xd736,	NODEST,
	/* 90 */
	NODEST,	0xd737,	0xe7ea,	NODEST,	0xd738,	NODEST,	0xd739,	NODEST,
	/* 98 */
	0xd73a,	0xc9e7,	0xd73b,	0xd73c,	NODEST,	0xbcc7,	NODEST,	0xe7ec,
	/* A0 */
	0xd73d,	0xd73e,	NODEST,	0xd73f,	0xd740,	0xb3a9,	0xb0b2,	0xd741,
	/* A8 */
	0xd742,	0xd743,	0xd744,	0xe7eb,	0xe7ee,	0xc7ce,	0xd745,	0xbfc4,
	/* B0 */
	0xd746,	0xb2d6,	0xd747,	0xcba7,	0xd748,	NODEST,	NODEST,	0xd749,
	/* B8 */
	0xb7dd,	0xb6dc,	0xd74a,	0xe7ed,	0xd74b,	0xb2ea,	0xd74c,	0xd74d,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xb4a3,	0xd74e,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	0xd74f,	0xb1f1,	0xe7f2,	0xceea,	0xc2dd,	0xd750,	NODEST,	0xc9c4,
	/* D8 */
	NODEST,	0xe7fe,	0xd751,	0xb2d7,	0xe7fc,	NODEST,	0xe7fa,	0xe7f1,
	/* E0 */
	0xd752,	0xe7ef,	0xd753,	0xe7f0,	0xd754,	0xbce3,	0xb6ec,	0xc3f7,
	/* E8 */
	0xd755,	NODEST,	0xd756,	0xc6d1,	NODEST,	0xd757,	NODEST,	0xd758,
	/* F0 */
	NODEST,	0xb1d1,	NODEST,	0xe7f4,	0xe7f3,	NODEST,	0xd759,	0xd75a,
	/* F8 */
	NODEST,	0xe7f9,	0xe7f5,	0xe7f8,	NODEST,	0xd75b,	0xd75c,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_83[] = {
	/* 00 */
	0xd75d,	0xd75e,	0xccd0,	0xe7f7,	0xb2d8,	0xb3fd,	0xe7fb,	0xd75f,
	/* 08 */
	0xd760,	0xe7fd,	0xd761,	0xd762,	NODEST,	NODEST,	0xb7d4,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe8a3,	0xe8ac,
	/* 18 */
	0xe8ad,	NODEST,	NODEST,	0xd764,	0xb0ab,	0xd765,	0xd766,	0xd767,
	/* 20 */
	NODEST,	0xd768,	0xd769,	0xe8b4,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	0xb0f1,	NODEST,	NODEST,	0xe8ab,	0xd76a,	0xd76b,	0xd76c,	0xe8aa,
	/* 30 */
	0xd76d,	0xe8a5,	0xe8a4,	0xd76e,	0xe8a2,	0xe8a1,	0xc3e3,	0xd76f,
	/* 38 */
	0xc2fb,	0xe8a7,	0xd770,	NODEST,	0xd771,	0xd772,	NODEST,	NODEST,
	/* 40 */
	0xe8a6,	NODEST,	0xd773,	0xd774,	0xd775,	0xe8a9,	NODEST,	0xd776,
	/* 48 */
	NODEST,	0xc1f0,	0xb7d5,	NODEST,	NODEST,	0xd777,	0xd778,	0xb1c1,
	/* 50 */
	0xe8a8,	0xd779,	0xb9d3,	0xd83e,	0xd763,	0xd77a,	0xd77b,	0xd77c,
	/* 58 */
	0xc1f1,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	0xf45f,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xd77d,	NODEST,	NODEST,	0xe8ba,	NODEST,	0xe8bb,	NODEST,	0xb2d9,
	/* 78 */
	0xd77e,	NODEST,	NODEST,	0xb2ae,	0xe8b8,	0xd821,	NODEST,	0xd822,
	/* 80 */
	0xd823,	NODEST,	0xd824,	NODEST,	0xd825,	0xe8ae,	0xd826,	0xe8b6,
	/* 88 */
	NODEST,	0xe8bd,	0xe8b7,	NODEST,	NODEST,	0xd827,	0xe8b5,	NODEST,
	/* 90 */
	NODEST,	NODEST,	0xd828,	0xe7f6,	0xd829,	0xd82a,	0xe8b3,	NODEST,
	/* 98 */
	0xd82b,	0xd82c,	0xe8af,	0xd82d,	0xd82e,	0xd82f,	0xb4d0,	0xe8b1,
	/* A0 */
	0xe8bc,	NODEST,	0xe8b2,	NODEST,	NODEST,	NODEST,	0xd830,	0xd831,
	/* A8 */
	0xe8be,	0xd832,	0xe8b0,	0xc7fc,	0xd833,	0xd84c,	NODEST,	NODEST,
	/* B0 */
	NODEST,	0xcde9,	NODEST,	NODEST,	NODEST,	0xe8b9,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe8cf,	0xd834,	0xd835,
	/* C0 */
	0xd836,	0xe8c7,	NODEST,	NODEST,	NODEST,	0xbffb,	NODEST,	0xd837,
	/* C8 */
	NODEST,	0xd838,	0xb5c6,	NODEST,	0xb6dd,	NODEST,	0xe8c2,	0xd839,
	/* D0 */
	0xd83a,	0xd83b,	NODEST,	0xb2db,	0xd83c,	NODEST,	0xbed4,	NODEST,
	/* D8 */
	0xe8c5,	NODEST,	NODEST,	NODEST,	0xbada,	0xd83d,	NODEST,	0xc5d1,
	/* E0 */
	0xe8ca,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xd83f,	0xcaee,	0xd840,	0xe8c1,	NODEST,	NODEST,	NODEST,	0xb2da,
	/* F0 */
	0xb8d6,	0xc9a9,	0xe8cb,	NODEST,	0xe8bf,	NODEST,	0xd841,	0xe8c8,
	/* F8 */
	0xd842,	0xd843,	NODEST,	0xe8d2,	0xd844,	0xe8c3,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_84[] = {
	/* 00 */
	NODEST,	0xd845,	NODEST,	0xe8c4,	0xc6ba,	NODEST,	0xd846,	0xe8c9,
	/* 08 */
	NODEST,	NODEST,	0xd847,	0xe8c6,	0xcba8,	0xe8cc,	0xb0e0,	0xd848,
	/* 10 */
	NODEST,	0xd849,	NODEST,	0xe8c0,	NODEST,	0xd84a,	NODEST,	NODEST,
	/* 18 */
	NODEST,	0xd84b,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	0xe8ce,	NODEST,	0xe8cd,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	0xc7eb,	0xe8d4,	NODEST,	0xe8df,	NODEST,	NODEST,	0xd84d,
	/* 30 */
	NODEST,	0xb3fe,	NODEST,	NODEST,	NODEST,	0xe8e2,	NODEST,	NODEST,
	/* 38 */
	0xe8d0,	0xd84e,	NODEST,	NODEST,	0xe8d5,	0xcdee,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd84f,	0xe8de,	0xd850,
	/* 48 */
	0xd851,	0xcdd5,	0xd852,	NODEST,	NODEST,	0xd853,	0xceaa,	0xd854,
	/* 50 */
	NODEST,	0xd855,	0xd856,	NODEST,	NODEST,	NODEST,	0xd857,	0xc3f8,
	/* 58 */
	0xd858,	0xd859,	0xd85a,	0xb3eb,	0xd85b,	NODEST,	NODEST,	NODEST,
	/* 60 */
	0xd85c,	0xc9f2,	0xe8e4,	0xc6a1,	0xd85d,	0xd85e,	0xb0b1,	0xd85f,
	/* 68 */
	NODEST,	0xe8dd,	0xd860,	0xe8d9,	0xc1f2,	0xe8d3,	0xe8db,	0xe8e0,
	/* 70 */
	0xd861,	0xc7ac,	NODEST,	0xd862,	0xd863,	0xb0aa,	0xd864,	0xe8d8,
	/* 78 */
	0xd865,	0xe8e1,	0xc9f8,	NODEST,	0xd866,	0xd867,	NODEST,	NODEST,
	/* 80 */
	NODEST,	0xd868,	0xe8dc,	NODEST,	0xe8d7,	0xd869,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	0xbed5,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	0xbdaf,	NODEST,	0xd86a,	0xd86b,	0xbcac,	0xd86c,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xccd8,	NODEST,	NODEST,	0xc9c7,	NODEST,	0xd86d,	0xe8e7,
	/* A0 */
	NODEST,	0xe8f0,	NODEST,	NODEST,	NODEST,	NODEST,	0xd86e,	NODEST,
	/* A8 */
	0xd86f,	0xd870,	0xd871,	NODEST,	NODEST,	0xe8da,	NODEST,	0xd872,
	/* B0 */
	NODEST,	0xd873,	0xb3f7,	NODEST,	0xd874,	NODEST,	NODEST,	NODEST,
	/* B8 */
	0xbef8,	0xe8e5,	0xd875,	0xe8ea,	0xc1f3,	0xd876,	0xd877,	0xe8e6,
	/* C0 */
	0xd878,	0xe8ed,	0xd879,	NODEST,	0xc3df,	NODEST,	0xe8ee,	0xd87a,
	/* C8 */
	0xd87b,	0xcdd6,	0xe8e3,	0xb3b8,	0xd87c,	0xe8e9,	NODEST,	0xd87d,
	/* D0 */
	0xe8ec,	0xccac,	NODEST,	0xd87e,	NODEST,	NODEST,	0xe8ef,	NODEST,
	/* D8 */
	NODEST,	0xe8e8,	0xe8eb,	NODEST,	0xd921,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xd922,
	/* E8 */
	NODEST,	NODEST,	0xd923,	NODEST,	0xcba9,	NODEST,	0xcfa1,	0xd924,
	/* F0 */
	0xd925,	0xd926,	0xd927,	NODEST,	0xe8f3,	NODEST,	NODEST,	0xd928,
	/* F8 */
	NODEST,	NODEST,	0xd92a,	0xd92b,	0xe8fa,	0xd92c,	NODEST,	0xe8f2,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_85[] = {
	/* 00 */
	0xbcc3,	NODEST,	0xd92d,	0xd92e,	NODEST,	NODEST,	0xe8d1,	0xd92f,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xd930,	NODEST,	0xd931,	NODEST,
	/* 10 */
	0xd932,	0xcace,	NODEST,	0xcca2,	0xe8f9,	0xe8f8,	NODEST,	0xe8f4,
	/* 18 */
	0xe8f5,	NODEST,	0xb1b6,	NODEST,	0xd933,	NODEST,	0xd934,	0xe8f7,
	/* 20 */
	NODEST,	0xe8f1,	0xd935,	0xd936,	0xd937,	0xd938,	0xc4d5,	0xd939,
	/* 28 */
	NODEST,	NODEST,	0xd93a,	0xd93b,	0xe8f6,	0xb0fe,	NODEST,	0xd93c,
	/* 30 */
	NODEST,	NODEST,	0xd929,	0xd93d,	0xd93e,	0xc2a2,	0xd93f,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xcac3,	NODEST,	0xd940,
	/* 40 */
	0xe8fb,	0xe9a1,	NODEST,	0xc8d9,	NODEST,	NODEST,	0xd941,	NODEST,
	/* 48 */
	0xe8fe,	0xbed6,	0xbcc9,	0xe9a3,	NODEST,	NODEST,	0xb6be,	0xd942,
	/* 50 */
	0xd943,	0xd944,	0xd945,	0xd946,	NODEST,	0xe9a4,	0xd947,	0xc9f9,
	/* 58 */
	0xe8fd,	0xd948,	0xe8d6,	NODEST,	0xd949,	0xd94a,	0xd94b,	0xd94c,
	/* 60 */
	0xd94d,	0xd94e,	0xd94f,	0xe8fc,	0xd950,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xcfcf,	0xc6a2,	0xc9f3,	0xd951,	NODEST,	0xe9ab,	NODEST,	0xd952,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe9b1,
	/* 78 */
	NODEST,	0xd953,	0xd954,	0xd955,	NODEST,	0xd956,	0xe9b2,	0xd957,
	/* 80 */
	0xe9a5,	0xd958,	NODEST,	NODEST,	0xc7f6,	0xd959,	0xd95a,	0xe9af,
	/* 88 */
	0xe9a7,	0xd95b,	0xe9a9,	0xd95c,	0xd95d,	NODEST,	NODEST,	0xd95e,
	/* 90 */
	0xe9b3,	0xe9a8,	NODEST,	0xd95f,	0xe9ac,	NODEST,	NODEST,	0xb1f2,
	/* 98 */
	0xd960,	0xc6e5,	NODEST,	0xe9ad,	0xe9b0,	0xd961,	NODEST,	0xd962,
	/* A0 */
	0xd963,	NODEST,	0xd964,	NODEST,	0xe9a6,	0xd965,	0xc1a6,	0xd966,
	/* A8 */
	0xe9aa,	0xbba7,	0xbfc5,	0xb7b0,	0xccf4,	0xd974,	0xccf9,	0xbdf2,
	/* B0 */
	0xf461,	NODEST,	NODEST,	NODEST,	0xd967,	NODEST,	0xd968,	0xd969,
	/* B8 */
	0xd96a,	0xe9b7,	0xe9b5,	NODEST,	0xd96b,	0xd96c,	0xd96d,	0xd96e,
	/* C0 */
	NODEST,	0xcfce,	0xd96f,	NODEST,	NODEST,	NODEST,	NODEST,	0xd970,
	/* C8 */
	NODEST,	0xe9b4,	0xd971,	0xd972,	NODEST,	0xcdf5,	0xd973,	0xe9b6,
	/* D0 */
	0xe9b8,	NODEST,	NODEST,	NODEST,	NODEST,	0xe9b9,	NODEST,	NODEST,
	/* D8 */
	0xd975,	NODEST,	0xd976,	NODEST,	0xe9bc,	0xe9ba,	NODEST,	0xd977,
	/* E0 */
	0xd978,	NODEST,	NODEST,	NODEST,	0xc6a3,	0xe9bb,	0xd979,	NODEST,
	/* E8 */
	0xd97a,	0xc8cd,	0xe9ae,	NODEST,	NODEST,	0xd97b,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	0xd97c,	NODEST,	NODEST,	0xd97d,	0xbdf3,
	/* F8 */
	NODEST,	0xe9bd,	0xe9c2,	0xc1f4,	0xd97e,	NODEST,	0xe9c1,	0xda21,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_86[] = {
	/* 00 */
	0xda22,	NODEST,	0xe9a2,	NODEST,	0xda23,	0xda24,	0xe9c3,	0xc1c9,
	/* 08 */
	NODEST,	NODEST,	0xe9be,	0xe9c0,	NODEST,	0xda25,	0xda26,	NODEST,
	/* 10 */
	0xda27,	0xda28,	0xda29,	0xe9bf,	NODEST,	NODEST,	0xddb1,	0xdda2,
	/* 18 */
	0xda2a,	0xda2b,	0xe9c5,	0xda2c,	NODEST,	NODEST,	0xda2d,	NODEST,
	/* 20 */
	NODEST,	0xda2e,	0xe9c4,	NODEST,	NODEST,	NODEST,	NODEST,	0xda2f,
	/* 28 */
	NODEST,	0xda30,	NODEST,	NODEST,	NODEST,	0xcdf6,	NODEST,	0xe2bc,
	/* 30 */
	0xe9c6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xda31,	NODEST,
	/* 38 */
	0xda32,	NODEST,	0xda33,	NODEST,	0xda34,	0xda35,	NODEST,	0xe9c7,
	/* 40 */
	0xda36,	0xb866,	0xda37,	NODEST,	NODEST,	NODEST,	0xda38,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe9c8,	0xb8d7,	NODEST,
	/* 50 */
	0xb5d4,	NODEST,	0xda39,	0xda3a,	0xe9ca,	0xd1dd,	0xda3b,	0xda3c,
	/* 58 */
	0xda3d,	0xda3e,	0xb5f5,	NODEST,	0xceba,	0xda3f,	0xb6f3,	0xe9cb,
	/* 60 */
	0xda40,	0xda41,	0xda42,	0xda43,	0xda44,	NODEST,	NODEST,	0xe9cc,
	/* 68 */
	NODEST,	0xda45,	NODEST,	0xc3ee,	0xda46,	NODEST,	NODEST,	0xda47,
	/* 70 */
	NODEST,	0xe9cd,	NODEST,	NODEST,	NODEST,	0xda48,	0xda49,	0xda4a,
	/* 78 */
	NODEST,	0xc6fa,	0xda4b,	0xb0ba,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	0xda6d,	NODEST,	0xb2e3,	0xe9d2,	0xe9d3,	0xda4c,	NODEST,	NODEST,
	/* 90 */
	NODEST,	0xda4d,	NODEST,	0xe9ce,	NODEST,	0xbbbd,	0xda4e,	NODEST,
	/* 98 */
	0xda4f,	NODEST,	0xda50,	NODEST,	0xda51,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	0xda52,	NODEST,	0xe9cf,	0xc7c2,	NODEST,	0xda53,	0xda54,
	/* A8 */
	0xda55,	0xe9d0,	0xe9d1,	0xe9db,	NODEST,	0xda56,	NODEST,	0xe9d5,
	/* B0 */
	0xe9d8,	0xda57,	NODEST,	0xda58,	0xda59,	0xda5a,	0xe9d4,	0xda5b,
	/* B8 */
	0xda5c,	0xda5d,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xda5e,
	/* C0 */
	0xda5f,	0xda60,	NODEST,	0xda61,	0xe9d6,	0xda62,	0xe9d7,	0xbcd8,
	/* C8 */
	NODEST,	0xe9d9,	NODEST,	0xc3c1,	NODEST,	0xb7d6,	0xb3c2,	NODEST,
	/* D0 */
	NODEST,	0xda63,	0xda64,	NODEST,	0xe9dc,	0xda65,	NODEST,	0xda66,
	/* D8 */
	NODEST,	0xb3bf,	0xda67,	0xe9e1,	0xda68,	NODEST,	0xe9dd,	0xe9e0,
	/* E0 */
	0xda69,	NODEST,	NODEST,	0xda6a,	0xc8ba,	0xda6b,	NODEST,	0xda6c,
	/* E8 */
	NODEST,	0xe9de,	NODEST,	NODEST,	0xe9df,	0xc9c8,	0xc8da,	0xe9e2,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	0xc2fd,	0xe9ec,	0xda6e,	0xe9e8,	0xda6f,	0xda70,	0xb2eb,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_87[] = {
	/* 00 */
	0xe9e6,	NODEST,	0xcbaa,	0xe9e7,	0xda71,	0xda72,	0xe9e4,	0xda73,
	/* 08 */
	0xe9e5,	0xe9ea,	0xe9ed,	0xda74,	NODEST,	0xe9eb,	0xda75,	0xda76,
	/* 10 */
	0xda77,	0xe9e9,	0xe9e3,	0xda78,	0xda79,	NODEST,	NODEST,	NODEST,
	/* 18 */
	0xc3d8,	0xda7a,	0xe9f4,	NODEST,	0xccaa,	NODEST,	0xda7b,	0xda7c,
	/* 20 */
	NODEST,	0xda7d,	NODEST,	0xda7e,	NODEST,	0xe9f2,	NODEST,	NODEST,
	/* 28 */
	0xdb21,	0xe9f3,	NODEST,	NODEST,	NODEST,	NODEST,	0xdb22,	0xdb23,
	/* 30 */
	NODEST,	0xdb24,	0xdb25,	NODEST,	0xe9ee,	NODEST,	NODEST,	0xe9f0,
	/* 38 */
	NODEST,	0xdb26,	0xdb27,	0xe9f1,	0xdb28,	0xdb29,	0xdb2a,	0xe9ef,
	/* 40 */
	0xdb2b,	NODEST,	NODEST,	0xdb2c,	NODEST,	0xdb2d,	NODEST,	NODEST,
	/* 48 */
	NODEST,	0xc0e6,	NODEST,	0xcfb9,	0xe9f8,	0xdb2e,	0xe9f9,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	0xeaa1,	NODEST,	0xbfaa,	NODEST,	0xe9fb,
	/* 58 */
	0xdb2f,	0xe9fe,	NODEST,	NODEST,	NODEST,	0xdb30,	NODEST,	0xe9f6,
	/* 60 */
	0xe9f5,	0xdb31,	NODEST,	0xeaa2,	0xdb32,	0xdb33,	0xb2dc,	NODEST,
	/* 68 */
	0xe9fc,	NODEST,	0xeaa3,	NODEST,	NODEST,	NODEST,	0xe9fd,	0xdb34,
	/* 70 */
	NODEST,	0xdb35,	0xdb36,	NODEST,	0xe9fa,	NODEST,	0xc4b3,	NODEST,
	/* 78 */
	0xe9f7,	NODEST,	NODEST,	0xdb37,	NODEST,	NODEST,	NODEST,	0xc7e8,
	/* 80 */
	NODEST,	NODEST,	0xeaa7,	0xdb38,	0xdb39,	0xdb3a,	0xdb3b,	0xdb3c,
	/* 88 */
	0xdb3d,	0xdb3e,	NODEST,	0xdb3f,	0xdb40,	0xcdbb,	NODEST,	NODEST,
	/* 90 */
	0xdb41,	NODEST,	NODEST,	0xdb42,	NODEST,	0xdb43,	NODEST,	0xdb44,
	/* 98 */
	0xdb45,	0xdb46,	NODEST,	NODEST,	NODEST,	NODEST,	0xdb47,	0xeaa6,
	/* A0 */
	0xdb48,	NODEST,	0xeaa5,	0xdb49,	NODEST,	NODEST,	NODEST,	0xdb4a,
	/* A8 */
	NODEST,	NODEST,	NODEST,	0xeaae,	0xdb4b,	0xdb4c,	0xdb4d,	0xeaa8,
	/* B0 */
	NODEST,	0xdb4e,	NODEST,	0xeab0,	NODEST,	0xdb4f,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	0xcde6,	0xeab3,	NODEST,	0xeaaa,	0xdb50,	0xdb51,
	/* C0 */
	0xeaab,	0xdb52,	NODEST,	NODEST,	0xeaaf,	NODEST,	0xeab2,	0xeab1,
	/* C8 */
	0xdb53,	0xdb54,	0xdb55,	0xeaa9,	NODEST,	NODEST,	0xdb56,	NODEST,
	/* D0 */
	0xeaac,	NODEST,	0xeabd,	NODEST,	NODEST,	0xdb57,	0xdb58,	NODEST,
	/* D8 */
	NODEST,	0xdb59,	0xdb5a,	NODEST,	0xdb5b,	NODEST,	NODEST,	0xdb5c,
	/* E0 */
	0xeab6,	NODEST,	0xdb5d,	0xdb5e,	0xdb5f,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	0xdb60,	0xdb61,	NODEST,	0xdb62,	NODEST,	0xeab4,
	/* F0 */
	NODEST,	0xdb63,	0xeab5,	0xdb64,	NODEST,	NODEST,	0xeaba,	0xeabb,
	/* F8 */
	0xdb65,	0xb3aa,	0xdb66,	0xb5c2,	NODEST,	NODEST,	0xeab9,	0xdb67,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_88[] = {
	/* 00 */
	NODEST,	0xdb68,	NODEST,	0xdb69,	NODEST,	0xeaa4,	0xdb6a,	0xf464,
	/* 08 */
	NODEST,	0xdb6b,	0xdb6c,	0xdb6d,	NODEST,	0xeab8,	0xeabc,	0xeab7,
	/* 10 */
	0xdb6e,	0xeabe,	0xdb70,	0xdb71,	0xdb72,	0xeac0,	0xeabf,	NODEST,
	/* 18 */
	0xdb73,	0xdb6f,	0xdb74,	0xdb75,	0xdb76,	NODEST,	0xdb77,	0xdb78,
	/* 20 */
	NODEST,	0xeac2,	0xeac1,	0xe9da,	NODEST,	NODEST,	NODEST,	0xeac6,
	/* 28 */
	0xdb79,	NODEST,	NODEST,	NODEST,	NODEST,	0xdb7a,	0xdb7b,	NODEST,
	/* 30 */
	0xdb7c,	0xeac3,	0xdb7d,	NODEST,	NODEST,	0xdb7e,	0xeac4,	NODEST,
	/* 38 */
	NODEST,	0xeac5,	0xdc21,	0xeac7,	0xdc22,	NODEST,	NODEST,	NODEST,
	/* 40 */
	0xb7ec,	0xdc23,	0xeac9,	0xdc24,	0xeac8,	0xdc25,	0xbdb0,	NODEST,
	/* 48 */
	0xdc26,	0xdc27,	0xdc28,	0xdc29,	0xb9d4,	0xdea7,	0xdc2a,	NODEST,
	/* 50 */
	NODEST,	0xdc2b,	0xeaca,	0xbdd1,	NODEST,	0xdc2c,	0xdc2d,	0xb3b9,
	/* 58 */
	0xdc2e,	0xeacb,	0xdc2f,	0xb1d2,	0xdc30,	0xbed7,	0xeacc,	0xdc31,
	/* 60 */
	0xdc32,	0xb9d5,	0xeacd,	0xb0e1,	0xdc33,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xc9bd,	0xdc34,	NODEST,	0xeace,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	0xbfea,	0xdc35,	0xead5,	NODEST,	NODEST,	0xead2,	NODEST,	0xc3ef,
	/* 78 */
	NODEST,	0xdc36,	NODEST,	0xdc37,	NODEST,	0xead3,	0xead0,	0xb6de,
	/* 80 */
	0xdc38,	0xeacf,	0xead6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	0xb7b6,	NODEST,	NODEST,	0xc2de,	NODEST,	0xeadc,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	0xead8,	NODEST,	NODEST,	NODEST,	0xc2b5,	0xead7,
	/* 98 */
	0xdc39,	0xeada,	0xdc3a,	0xdc3b,	0xdc3c,	NODEST,	0xead1,	0xdc3d,
	/* A0 */
	0xdc3e,	NODEST,	0xeadb,	NODEST,	0xeadd,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xdc3f,	NODEST,	0xdc40,	0xc8ef,	NODEST,	NODEST,	0xead9,	NODEST,
	/* B0 */
	0xeade,	0xeae0,	NODEST,	NODEST,	0xb8d3,	0xead4,	NODEST,	0xb0c1,
	/* B8 */
	NODEST,	NODEST,	0xdc41,	NODEST,	NODEST,	0xdc42,	0xdc43,	0xeadf,
	/* C0 */
	0xdc44,	0xbadb,	0xcef6,	0xeae1,	0xeae2,	0xc1f5,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	0xdc45,	0xdc46,	0xdc47,	0xdc48,	0xdc49,	0xcea2,
	/* D0 */
	NODEST,	0xdc4a,	0xdc4b,	0xdc4c,	0xeae3,	0xcdb5,	NODEST,	NODEST,
	/* D8 */
	0xeae4,	0xeae5,	NODEST,	0xdc4d,	0xcae4,	0xeae6,	0xdc4e,	0xbac0,
	/* E0 */
	NODEST,	0xcea3,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdc4f,
	/* E8 */
	0xeaeb,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdc50,
	/* F0 */
	0xdc51,	0xdc52,	0xeaec,	0xbed8,	0xeaea,	0xdc53,	NODEST,	0xdc54,
	/* F8 */
	0xcde7,	0xeae7,	NODEST,	NODEST,	0xeae9,	0xc0bd,	0xbffe,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_89[] = {
	/* 00 */
	NODEST,	0xdc55,	0xeae8,	NODEST,	0xeaed,	NODEST,	0xdc56,	0xcaa3,
	/* 08 */
	NODEST,	NODEST,	0xeaef,	NODEST,	0xeaee,	0xdc57,	0xdc58,	0xdc59,
	/* 10 */
	0xb3ec,	NODEST,	0xcbab,	0xeaf0,	NODEST,	0xdc5a,	0xdc5b,	NODEST,
	/* 18 */
	0xdc5c,	0xdc5d,	0xdc5e,	NODEST,	0xdc5f,	0xeafc,	0xeaf2,	NODEST,
	/* 20 */
	0xdc60,	NODEST,	NODEST,	NODEST,	NODEST,	0xeaf3,	0xdc61,	0xdc62,
	/* 28 */
	0xdc63,	NODEST,	0xeaf4,	0xeaf5,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xdc64,	0xdc65,	0xdc66,	NODEST,	NODEST,	0xdc67,	0xeaf9,	NODEST,
	/* 38 */
	0xeafa,	0xdc68,	0xdc69,	0xeaf8,	NODEST,	NODEST,	0xdc6a,	NODEST,
	/* 40 */
	0xdc6b,	0xeaf6,	0xdc6c,	0xeaf1,	0xeaf7,	0xdc6d,	0xdc6e,	NODEST,
	/* 48 */
	NODEST,	0xdc6f,	NODEST,	NODEST,	0xeafb,	0xf0b7,	NODEST,	0xdc70,
	/* 50 */
	NODEST,	NODEST,	0xdc71,	NODEST,	NODEST,	NODEST,	0xb2a8,	0xdc72,
	/* 58 */
	NODEST,	NODEST,	0xdc73,	0xdc74,	0xdc75,	NODEST,	0xeafe,	0xb6df,
	/* 60 */
	0xeafd,	0xdc76,	0xdc77,	0xdc78,	0xeba2,	NODEST,	0xeba1,	NODEST,
	/* 68 */
	NODEST,	NODEST,	0xeba4,	0xdc79,	NODEST,	0xeba3,	0xdc7a,	0xeba5,
	/* 70 */
	0xdc7b,	NODEST,	0xbdb1,	0xdc7c,	0xeba6,	0xdc7d,	NODEST,	0xeba7,
	/* 78 */
	NODEST,	NODEST,	0xdc7e,	0xdd21,	0xdd22,	0xdd23,	0xeba8,	0xc0be,
	/* 80 */
	NODEST,	0xcdd7,	NODEST,	0xeba9,	NODEST,	NODEST,	0xcaa4,	0xc7c6,
	/* 88 */
	0xebaa,	0xdd24,	0xebab,	0xb8ab,	NODEST,	0xdd25,	NODEST,	0xb5ac,
	/* 90 */
	0xdd26,	NODEST,	NODEST,	0xebac,	0xdd27,	0xdd28,	0xbbeb,	0xc7c1,
	/* 98 */
	0xebad,	NODEST,	0xb3d0,	0xdd29,	0xdd2a,	NODEST,	NODEST,	0xdd2b,
	/* A0 */
	0xdd2c,	0xebae,	NODEST,	NODEST,	NODEST,	0xdd2d,	0xebb0,	0xcdf7,
	/* A8 */
	NODEST,	0xebaf,	0xbfc6,	NODEST,	0xebb1,	NODEST,	NODEST,	0xebb2,
	/* B0 */
	0xdd2e,	NODEST,	0xebb3,	0xb4d1,	0xdd2f,	0xdd30,	0xdd31,	0xdd32,
	/* B8 */
	NODEST,	NODEST,	0xebb4,	NODEST,	0xdd33,	0xebb5,	NODEST,	0xebb6,
	/* C0 */
	0xebb7,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xb3d1,	NODEST,	0xdd34,	0xdd35,	0xdd36,	0xdd37,
	/* D8 */
	0xdd38,	NODEST,	0xebb8,	NODEST,	0xebb9,	0xebba,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	0xb2f2,	NODEST,	0xdd39,	0xbfa8,	0xebbb,
	/* E8 */
	NODEST,	0xdd3a,	NODEST,	0xdd3b,	NODEST,	0xdd3c,	NODEST,	NODEST,
	/* F0 */
	NODEST,	0xdd3d,	NODEST,	0xdd3e,	0xebbc,	NODEST,	0xdd3f,	NODEST,
	/* F8 */
	0xebbd,	0xdd40,	NODEST,	NODEST,	NODEST,	0xdd41,	NODEST,	0xdd42,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8A[] = {
	/* 00 */
	0xb8c0,	NODEST,	0xc4fb,	0xebbe,	0xdd43,	0xdd44,	NODEST,	0xdd45,
	/* 08 */
	0xb7d7,	NODEST,	0xbfd6,	NODEST,	0xebc1,	NODEST,	0xc6a4,	0xdd46,
	/* 10 */
	0xebc0,	0xdd47,	0xdd48,	0xb7b1,	0xdd49,	0xdd4a,	0xebbf,	0xc2f7,
	/* 18 */
	0xb5ad,	NODEST,	NODEST,	0xebc2,	NODEST,	0xebc3,	0xdd4b,	0xbed9,
	/* 20 */
	0xdd4c,	NODEST,	0xdd4d,	0xb7ed,	0xdd4e,	0xebc4,	0xdd4f,	NODEST,
	/* 28 */
	NODEST,	NODEST,	0xcbac,	0xdd50,	0xdd51,	0xc0df,	NODEST,	0xdd52,
	/* 30 */
	NODEST,	0xb5f6,	NODEST,	0xccf5,	0xc1ca,	0xdd53,	0xebc5,	0xdd54,
	/* 38 */
	NODEST,	NODEST,	0xbfc7,	0xc3f0,	0xbeda,	0xdd55,	0xdd56,	NODEST,
	/* 40 */
	0xdd57,	0xebc6,	NODEST,	0xdd58,	NODEST,	0xdd59,	0xebc9,	0xdd5a,
	/* 48 */
	0xebca,	0xdd5b,	NODEST,	NODEST,	NODEST,	0xdd5c,	0xdd5d,	NODEST,
	/* 50 */
	0xbabe,	0xc2c2,	0xebc8,	0xdd5e,	0xbedb,	0xc9be,	0xdd5f,	0xdd60,
	/* 58 */
	0xdd61,	NODEST,	NODEST,	0xebc7,	0xdd62,	0xdd63,	0xbbec,	NODEST,
	/* 60 */
	0xb1d3,	0xdd64,	0xebce,	0xb7d8,	NODEST,	0xdd65,	0xbbee,	0xdd66,
	/* 68 */
	NODEST,	0xbbed,	NODEST,	0xcfcd,	0xebcd,	0xebcc,	0xc1a7,	NODEST,
	/* 70 */
	0xb5cd,	0xcfc3,	0xb3ba,	0xbedc,	NODEST,	0xdd67,	0xdd68,	0xdd69,
	/* 78 */
	NODEST,	0xdd6a,	0xdd6b,	0xdd6c,	0xebcb,	NODEST,	0xdd6d,	0xdd6e,
	/* 80 */
	0xdd6f,	NODEST,	0xebd0,	0xdd70,	0xebd1,	0xebcf,	0xdd71,	0xb8d8,
	/* 88 */
	NODEST,	0xcdc0,	NODEST,	0xdd72,	0xbbef,	0xc7a7,	NODEST,	0xdd73,
	/* 90 */
	0xdd74,	0xebd4,	0xdd75,	0xc0c0,	NODEST,	0xc3c2,	0xdd76,	0xdd77,
	/* 98 */
	0xcdb6,	0xdd78,	0xebd7,	NODEST,	NODEST,	NODEST,	0xb8ec,	0xdd79,
	/* A0 */
	0xc0bf,	0xebd3,	NODEST,	0xebd8,	0xb8ed,	0xebd5,	0xebd6,	0xdd7a,
	/* A8 */
	0xebd2,	0xdd7b,	NODEST,	NODEST,	0xc0e2,	0xc6c9,	0xdd7c,	0xdd7d,
	/* B0 */
	0xc3af,	NODEST,	0xb2dd,	0xdd7e,	NODEST,	NODEST,	0xde21,	0xde22,
	/* B8 */
	NODEST,	0xc8f0,	NODEST,	0xde23,	0xb5c3,	NODEST,	0xde24,	0xc4b4,
	/* C0 */
	NODEST,	NODEST,	0xebdb,	0xde25,	0xebd9,	NODEST,	0xde26,	0xc3cc,
	/* C8 */
	0xde27,	0xde28,	0xde29,	0xc0c1,	0xb4d2,	0xebda,	NODEST,	0xbfdb,
	/* D0 */
	NODEST,	0xde2a,	0xceca,	0xde2b,	0xde2c,	0xde2d,	0xcfc0,	0xde2e,
	/* D8 */
	NODEST,	NODEST,	0xebdc,	0xebe7,	0xc4b5,	0xde2f,	0xebe6,	0xde30,
	/* E0 */
	0xebe3,	0xebeb,	0xebe4,	NODEST,	0xebe0,	NODEST,	0xc4fc,	0xebdf,
	/* E8 */
	NODEST,	NODEST,	NODEST,	0xebdd,	0xde31,	0xcda1,	0xbbf0,	NODEST,
	/* F0 */
	0xde32,	0xebe1,	NODEST,	0xebde,	0xde33,	0xde34,	0xde35,	0xebe5,
	/* F8 */
	0xbdf4,	NODEST,	0xb8c1,	NODEST,	0xde36,	NODEST,	0xc2fa,	0xde37,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8B[] = {
	/* 00 */
	0xcbc5,	0xb1da,	0xb0e2,	NODEST,	0xc6a5,	0xde38,	0xde39,	0xebe9,
	/* 08 */
	NODEST,	NODEST,	0xde3f,	0xde3a,	0xebe8,	NODEST,	0xc6e6,	NODEST,
	/* 10 */
	0xebed,	0xde3b,	NODEST,	NODEST,	0xebe2,	NODEST,	0xebec,	0xebee,
	/* 18 */
	NODEST,	0xb8ac,	0xebea,	0xb9d6,	0xde3c,	0xbcd5,	0xde3d,	0xde3e,
	/* 20 */
	0xebef,	0xcdd8,	NODEST,	NODEST,	NODEST,	NODEST,	0xebf2,	NODEST,
	/* 28 */
	0xebf5,	NODEST,	NODEST,	0xebf3,	0xc9b5,	0xde40,	NODEST,	NODEST,
	/* 30 */
	0xde41,	NODEST,	NODEST,	0xebf0,	NODEST,	NODEST,	NODEST,	0xde42,
	/* 38 */
	NODEST,	0xb6e0,	NODEST,	NODEST,	0xde43,	NODEST,	0xebf4,	NODEST,
	/* 40 */
	NODEST,	0xebf6,	0xde44,	0xde45,	0xde46,	0xde47,	0xde48,	NODEST,
	/* 48 */
	0xde49,	0xebfa,	NODEST,	NODEST,	0xebf7,	0xde4e,	0xebf9,	0xebf8,
	/* 50 */
	NODEST,	NODEST,	0xde4a,	0xde4b,	0xde4c,	NODEST,	0xebfb,	NODEST,
	/* 58 */
	0xbcb1,	0xde4d,	0xebfd,	0xebfc,	0xc9e8,	NODEST,	0xde4f,	0xeca1,
	/* 60 */
	NODEST,	NODEST,	NODEST,	0xde50,	NODEST,	NODEST,	0xb7d9,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	0xebfe,	0xeca2,	0xde51,	NODEST,	0xeca3,
	/* 70 */
	0xb5c4,	0xe6c1,	0xbef9,	NODEST,	0xeca4,	NODEST,	0xde52,	0xb8ee,
	/* 78 */
	0xde53,	0xde54,	NODEST,	NODEST,	0xde55,	0xeca5,	0xde56,	0xf466,
	/* 80 */
	0xeca6,	0xde57,	NODEST,	0xbbbe,	0xde58,	0xde59,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	0xdace,	0xde5a,	0xeca7,	0xde5b,	0xeca8,	0xde5c,
	/* 90 */
	0xbdb2,	NODEST,	0xeca9,	0xecaa,	0xde5d,	0xde5e,	0xecab,	NODEST,
	/* 98 */
	NODEST,	0xecac,	0xecad,	NODEST,	0xde5f,	NODEST,	0xde60,	0xde61,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8C[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc3ab,
	/* 38 */
	0xde62,	0xde63,	0xecae,	NODEST,	NODEST,	0xde64,	0xde65,	0xecb0,
	/* 40 */
	NODEST,	0xecaf,	NODEST,	NODEST,	NODEST,	0xde66,	0xc6a6,	0xde67,
	/* 48 */
	0xecb1,	0xde68,	0xcbad,	0xde69,	0xecb2,	NODEST,	0xecb3,	0xde6a,
	/* 50 */
	0xecb4,	0xde6b,	NODEST,	0xde6c,	0xde6d,	0xecb5,	NODEST,	0xde6e,
	/* 58 */
	0xde6f,	0xde72,	0xc6da,	0xde70,	NODEST,	0xde71,	NODEST,	NODEST,
	/* 60 */
	NODEST,	0xbedd,	0xecb6,	0xde73,	0xde74,	NODEST,	0xde75,	NODEST,
	/* 68 */
	0xde76,	0xde77,	0xb9eb,	0xd0ae,	0xecb7,	0xde78,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	0xde79,	NODEST,	0xde7a,	0xde7b,	NODEST,
	/* 78 */
	0xecb8,	0xc9bf,	0xecb9,	0xde7c,	0xecc1,	NODEST,	0xde7d,	NODEST,
	/* 80 */
	NODEST,	NODEST,	0xecba,	NODEST,	NODEST,	0xecbc,	0xde7e,	0xdf21,
	/* 88 */
	NODEST,	0xecbb,	0xecbd,	0xdf22,	0xcbc6,	0xecbe,	0xecbf,	NODEST,
	/* 90 */
	0xdf23,	NODEST,	0xdf24,	0xdf25,	0xecc0,	NODEST,	NODEST,	NODEST,
	/* 98 */
	0xecc2,	0xdf26,	NODEST,	0xdf27,	0xdf28,	0xb3ad,	0xc4e7,	NODEST,
	/* A0 */
	0xc9e9,	0xbae2,	0xb9d7,	NODEST,	0xdf29,	NODEST,	NODEST,	0xc9cf,
	/* A8 */
	0xb2df,	0xc8ce,	0xecc5,	0xb4d3,	0xc0d5,	0xecc4,	0xecc9,	0xc3f9,
	/* B0 */
	0xcce3,	NODEST,	0xecc7,	0xecc8,	0xb5ae,	NODEST,	0xecca,	0xc7e3,
	/* B8 */
	0xc2df,	0xdf2a,	0xdf2b,	0xc8f1,	0xc5bd,	0xecc6,	NODEST,	0xcbc7,
	/* C0 */
	0xb2ec,	0xeccc,	0xcfa8,	0xc4c2,	0xcfc5,	0xdf2c,	0xdf2d,	0xbbf1,
	/* C8 */
	0xeccb,	0xdf2e,	0xc2b1,	0xdf2f,	NODEST,	0xecdc,	0xc1a8,	0xdf30,
	/* D0 */
	NODEST,	0xc6f8,	NODEST,	0xc9d0,	NODEST,	0xdf32,	0xdf31,	NODEST,
	/* D8 */
	NODEST,	0xdf33,	0xeccf,	0xbbbf,	0xbbf2,	0xdf34,	0xbede,	NODEST,
	/* E0 */
	0xc7e5,	0xdf35,	0xb8ad,	0xecce,	0xeccd,	NODEST,	0xc9ea,	NODEST,
	/* E8 */
	0xdf36,	NODEST,	0xbcc1,	NODEST,	0xdf37,	0xc5d2,	NODEST,	0xdf38,
	/* F0 */
	0xdf39,	NODEST,	0xdf3a,	NODEST,	0xf467,	0xdf3b,	NODEST,	0xdf3c,
	/* F8 */
	0xdf3d,	NODEST,	0xecd1,	0xecd2,	0xb9d8,	0xecd0,	0xdf3e,	0xdf3f,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8D[] = {
	/* 00 */
	NODEST,	0xdf40,	NODEST,	0xdf41,	0xecd3,	0xecd4,	NODEST,	0xecd6,
	/* 08 */
	0xc2a3,	0xdf42,	0xecd5,	0xb4e6,	NODEST,	0xecd8,	NODEST,	0xecd7,
	/* 10 */
	0xecd9,	NODEST,	0xdf43,	0xecdb,	0xecdd,	NODEST,	0xecde,	0xdf44,
	/* 18 */
	NODEST,	NODEST,	NODEST,	0xdf45,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc0d6,	0xdf46,	0xbccf,	0xecdf,
	/* 68 */
	NODEST,	0xdf47,	NODEST,	0xb3d2,	0xdf48,	0xece0,	0xdf49,	NODEST,
	/* 70 */
	0xc1f6,	0xece1,	NODEST,	0xece2,	0xc9eb,	NODEST,	0xf468,	0xb5af,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xdf4a,
	/* 80 */
	NODEST,	0xece3,	0xdf4b,	NODEST,	0xdf4c,	0xc4b6,	NODEST,	NODEST,
	/* 88 */
	0xdf4d,	NODEST,	0xb1db,	NODEST,	NODEST,	0xdf4e,	NODEST,	NODEST,
	/* 90 */
	0xdf4f,	0xdf50,	NODEST,	NODEST,	NODEST,	0xdf51,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xece4,	NODEST,	NODEST,	NODEST,	NODEST,	0xdf52,	0xdf53,
	/* A0 */
	0xdf54,	NODEST,	NODEST,	0xbcf1,	NODEST,	NODEST,	0xdf55,	NODEST,
	/* A8 */
	0xbff6,	NODEST,	NODEST,	0xdf56,	0xdf57,	NODEST,	NODEST,	0xdf58,
	/* B0 */
	NODEST,	NODEST,	0xdf59,	0xc2ad,	NODEST,	0xdf5a,	NODEST,	0xdf5b,
	/* B8 */
	NODEST,	0xdf5c,	0xece7,	0xdf5d,	0xdf6f,	NODEST,	0xece6,	NODEST,
	/* C0 */
	0xdf5e,	NODEST,	0xece5,	NODEST,	NODEST,	0xdf5f,	0xdf60,	0xdf61,
	/* C8 */
	0xdf62,	NODEST,	0xdf63,	0xeced,	0xeceb,	NODEST,	0xdf64,	0xece8,
	/* D0 */
	NODEST,	0xdf65,	NODEST,	NODEST,	0xdf66,	0xdf67,	0xecea,	0xdf68,
	/* D8 */
	NODEST,	0xdf69,	0xece9,	0xecec,	NODEST,	0xb5f7,	NODEST,	0xecf0,
	/* E0 */
	NODEST,	0xc0d7,	NODEST,	0xecf1,	0xdf6a,	0xdf6b,	NODEST,	0xdf6c,
	/* E8 */
	0xb8d9,	NODEST,	0xecee,	0xecef,	0xdf6d,	NODEST,	NODEST,	0xcfa9,
	/* F0 */
	0xdf6e,	0xdf70,	0xdf71,	0xc4b7,	0xdf72,	0xc1a9,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xecf2,	0xdf73,	NODEST,	0xecf5,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8E[] = {
	/* 00 */
	NODEST,	0xdf74,	NODEST,	NODEST,	0xdf75,	0xdf76,	0xdf77,	NODEST,
	/* 08 */
	0xecf3,	0xecf4,	0xcdd9,	0xdf78,	NODEST,	NODEST,	NODEST,	0xc6a7,
	/* 10 */
	0xecf8,	0xdf79,	NODEST,	NODEST,	0xdf7a,	NODEST,	0xdf7b,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xecf6,	0xecf7,	0xecf9,
	/* 20 */
	0xdf7c,	0xdf7d,	0xdf7e,	0xe021,	NODEST,	NODEST,	0xe022,	0xe023,
	/* 28 */
	NODEST,	NODEST,	0xeda9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xecfc,	0xe024,	NODEST,	0xe025,	0xecfd,	0xecfb,	0xe026,	0xe027,
	/* 38 */
	0xe028,	0xe029,	NODEST,	NODEST,	NODEST,	0xe02a,	NODEST,	NODEST,
	/* 40 */
	0xe02b,	0xe02c,	0xecfa,	NODEST,	0xc4fd,	NODEST,	NODEST,	0xeda1,
	/* 48 */
	0xeda5,	0xeda2,	0xecfe,	0xe02d,	0xeda3,	0xe02e,	0xe02f,	0xe030,
	/* 50 */
	0xeda4,	NODEST,	NODEST,	NODEST,	0xe031,	0xedab,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xeda6,	NODEST,	0xe032,	0xe033,	0xe034,	0xe035,	0xc0d8,
	/* 60 */
	0xeda8,	0xe036,	0xe037,	0xedaa,	0xeda7,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	0xe038,	NODEST,	NODEST,	0xe039,	0xe03a,	NODEST,	0xe03b,
	/* 70 */
	0xe03c,	0xe03d,	0xedad,	NODEST,	0xbdb3,	NODEST,	0xedac,	NODEST,
	/* 78 */
	NODEST,	0xe03e,	0xe03f,	0xe040,	0xedae,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	0xedaf,	0xe041,	0xe042,	0xedb2,	0xedb1,	NODEST,	0xedb0,
	/* 88 */
	NODEST,	0xe043,	0xedb4,	0xedb3,	NODEST,	0xccf6,	NODEST,	NODEST,
	/* 90 */
	0xe044,	0xedb6,	0xe045,	0xedb5,	0xedb7,	0xe046,	NODEST,	NODEST,
	/* 98 */
	NODEST,	0xedb8,	0xe047,	0xe048,	NODEST,	0xe049,	0xe04a,	NODEST,
	/* A0 */
	NODEST,	0xedba,	0xe04b,	NODEST,	NODEST,	NODEST,	NODEST,	0xe04c,
	/* A8 */
	NODEST,	0xe04d,	0xedb9,	0xbfc8,	0xedbb,	0xe04e,	0xe04f,	0xb6ed,
	/* B0 */
	0xedbc,	0xedbe,	NODEST,	0xe050,	NODEST,	0xe051,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	0xe052,	0xe053,	NODEST,	NODEST,	0xedbf,	NODEST,
	/* C0 */
	0xe054,	0xe055,	NODEST,	0xe056,	0xe057,	0xedc0,	0xedbd,	0xe058,
	/* C8 */
	0xedc1,	NODEST,	0xbcd6,	0xedc2,	0xb5b0,	0xb7b3,	NODEST,	0xe059,
	/* D0 */
	NODEST,	0xe05a,	0xb8ae,	NODEST,	0xe05b,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	0xedc3,	0xe05c,	NODEST,	NODEST,	0xc6f0,
	/* E0 */
	NODEST,	NODEST,	0xc5be,	0xedc4,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xe05d,	NODEST,	NODEST,	0xedc7,	NODEST,	0xe064,	0xe05e,	NODEST,
	/* F0 */
	0xe05f,	0xe060,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe061,
	/* F8 */
	0xbcb4,	0xe062,	0xe063,	0xedc6,	0xedc5,	0xb7da,	0xedc8,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_8F[] = {
	/* 00 */
	0xe065,	NODEST,	0xe066,	0xb3d3,	NODEST,	0xedca,	NODEST,	0xe067,
	/* 08 */
	0xe068,	0xbadc,	0xedc9,	NODEST,	0xedd2,	NODEST,	NODEST,	0xe069,
	/* 10 */
	0xe06a,	NODEST,	0xedcc,	0xedce,	0xcae5,	0xedcb,	0xe06b,	0xe06c,
	/* 18 */
	0xe06d,	0xedcd,	NODEST,	0xedd1,	0xedcf,	0xb5b1,	0xe06e,	0xedd0,
	/* 20 */
	0xe06f,	0xe070,	NODEST,	0xe071,	NODEST,	0xe072,	0xedd3,	0xe073,
	/* 28 */
	0xe074,	0xc7da,	0xced8,	NODEST,	0xe075,	0xe076,	0xe077,	0xbdb4,
	/* 30 */
	NODEST,	NODEST,	NODEST,	0xedd4,	0xe078,	0xe079,	0xe07a,	0xe07b,
	/* 38 */
	0xcda2,	0xedd6,	0xe07c,	0xedd5,	NODEST,	NODEST,	0xedd9,	0xcdc1,
	/* 40 */
	0xe07d,	0xe07e,	0xedd8,	0xe121,	0xb3ed,	0xedd7,	0xeddc,	0xe122,
	/* 48 */
	NODEST,	0xeddb,	NODEST,	NODEST,	0xedda,	0xc5b2,	0xeddd,	0xe123,
	/* 50 */
	NODEST,	0xe124,	0xe125,	0xe126,	0xe127,	0xe128,	NODEST,	0xedde,
	/* 58 */
	0xe129,	NODEST,	NODEST,	NODEST,	0xeddf,	0xe12a,	0xe12b,	0xb9ec,
	/* 60 */
	NODEST,	0xb7a5,	0xede0,	0xede1,	0xede2,	0xe12c,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	0xbfc9,	0xede3,	0xe12d,	0xbcad,	0xede4,
	/* A0 */
	0xe12e,	0xe12f,	NODEST,	0xede5,	0xe130,	0xe131,	0xe132,	0xd2a1,
	/* A8 */
	0xd1fe,	NODEST,	NODEST,	NODEST,	NODEST,	0xede6,	0xe5f0,	0xede7,
	/* B0 */
	0xc3a4,	0xbfab,	0xc7c0,	NODEST,	NODEST,	0xe133,	0xe134,	0xede8,
	/* B8 */
	0xe135,	NODEST,	0xcad5,	0xc4d4,	0xb9fe,	NODEST,	0xe136,	0xc3a9,
	/* C0 */
	0xe137,	0xe138,	0xb1aa,	NODEST,	0xcbf8,	0xbfd7,	0xe139,	NODEST,
	/* C8 */
	NODEST,	NODEST,	0xe13a,	0xe13b,	NODEST,	0xe13c,	0xb7de,	NODEST,
	/* D0 */
	0xe13d,	0xb6e1,	0xe13e,	0xe13f,	0xcad6,	0xe140,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	0xede9,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	0xe141,	NODEST,	0xedeb,	0xe142,	0xe143,	0xedea,	0xb2e0,	NODEST,
	/* E8 */
	0xe144,	0xc6f6,	0xedec,	0xc7f7,	NODEST,	0xc5b3,	0xe145,	0xeded,
	/* F0 */
	0xbdd2,	0xe146,	NODEST,	NODEST,	0xedef,	0xe147,	0xe148,	0xccc2,
	/* F8 */
	0xedfe,	0xedf1,	0xedf2,	0xe149,	NODEST,	0xc4c9,	0xe14a,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_90[] = {
	/* 00 */
	0xc2e0,	0xc1f7,	0xe14b,	0xc6a8,	0xe14c,	0xedf0,	0xb5d5,	NODEST,
	/* 08 */
	0xe14d,	NODEST,	NODEST,	0xedf9,	0xe14e,	0xedf6,	0xeea5,	0xc6a9,
	/* 10 */
	0xc3e0,	0xedf3,	NODEST,	0xc4fe,	0xc5d3,	0xedf4,	0xedf8,	0xbfe0,
	/* 18 */
	0xe14f,	0xc7e7,	0xc4cc,	0xe150,	NODEST,	0xc0c2,	0xedf7,	0xc2ae,
	/* 20 */
	0xc2a4,	0xedf5,	0xb0a9,	0xcfa2,	NODEST,	NODEST,	NODEST,	0xedfa,
	/* 28 */
	0xe151,	0xe152,	0xe154,	NODEST,	0xe155,	0xe156,	0xc2e1,	0xe153,
	/* 30 */
	NODEST,	0xbdb5,	0xbfca,	0xe157,	0xe158,	0xedfc,	0xedfb,	0xe159,
	/* 38 */
	0xb0ef,	0xedfd,	NODEST,	NODEST,	0xc9af,	NODEST,	0xeea7,	0xe15a,
	/* 40 */
	NODEST,	0xc6db,	0xbfeb,	0xe15b,	0xe15c,	0xc3d9,	NODEST,	0xb6f8,
	/* 48 */
	NODEST,	0xeea6,	0xcdb7,	0xb1bf,	0xe15d,	0xcad7,	0xb2e1,	0xeea1,
	/* 50 */
	0xeea2,	0xeea3,	0xeea4,	0xc6bb,	0xc3a3,	0xb0e3,	0xeea8,	NODEST,
	/* 58 */
	0xeea9,	0xf4a3,	NODEST,	0xe15e,	0xc2bd,	0xe15f,	0xeeaa,	NODEST,
	/* 60 */
	0xb1f3,	0xc1cc,	0xe160,	0xb8af,	NODEST,	0xcdda,	0xe161,	0xe162,
	/* 68 */
	0xeeab,	0xc5ac,	NODEST,	NODEST,	0xe163,	0xc1f8,	0xbcd7,	0xeeac,
	/* 70 */
	0xe164,	NODEST,	0xeeaf,	NODEST,	0xe165,	0xbde5,	0xeead,	0xc1ab,
	/* 78 */
	0xc1aa,	0xe166,	0xb0e4,	NODEST,	0xcecb,	0xeeb1,	NODEST,	0xc8f2,
	/* 80 */
	0xeeb3,	0xeeb2,	0xeeb0,	0xe3e4,	0xb4d4,	0xe167,	NODEST,	0xedee,
	/* 88 */
	0xe168,	0xeeb5,	0xeeb4,	0xe169,	0xe16a,	NODEST,	0xe16b,	0xeeb6,
	/* 90 */
	0xe16c,	0xcdb8,	NODEST,	NODEST,	NODEST,	0xe16d,	NODEST,	0xe16e,
	/* 98 */
	0xe16f,	0xe170,	NODEST,	0xe171,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	0xe172,	0xe173,	0xe174,	0xc6e1,	NODEST,	0xe175,	0xcbae,	NODEST,
	/* A8 */
	0xeeb7,	NODEST,	0xbcd9,	NODEST,	NODEST,	NODEST,	NODEST,	0xeeb8,
	/* B0 */
	0xe176,	0xeeb9,	0xe177,	0xe178,	0xe179,	0xeeba,	0xe17a,	NODEST,
	/* B8 */
	0xc5a1,	NODEST,	NODEST,	NODEST,	NODEST,	0xe17b,	0xe17d,	NODEST,
	/* C0 */
	NODEST,	0xb0ea,	NODEST,	0xe17e,	0xe221,	0xe222,	NODEST,	0xe223,
	/* C8 */
	0xe224,	NODEST,	0xb9d9,	NODEST,	0xe17c,	NODEST,	0xcfba,	NODEST,
	/* D0 */
	NODEST,	NODEST,	0xe22d,	NODEST,	NODEST,	0xe225,	NODEST,	0xe226,
	/* D8 */
	0xe227,	0xe228,	NODEST,	0xeebe,	0xe229,	0xe22a,	0xf46c,	0xe22b,
	/* E0 */
	NODEST,	0xb7b4,	0xeebb,	NODEST,	0xeebc,	0xe22c,	NODEST,	NODEST,
	/* E8 */
	0xc9f4,	NODEST,	NODEST,	0xe22f,	NODEST,	0xb3d4,	NODEST,	0xe230,
	/* F0 */
	0xe231,	NODEST,	NODEST,	NODEST,	0xe232,	0xcdb9,	0xe22e,	0xb6bf,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc5d4,	0xe233,	0xe234,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_91[] = {
	/* 00 */
	0xe235,	NODEST,	0xeebf,	NODEST,	0xe236,	0xe237,	0xe238,	NODEST,
	/* 08 */
	0xe239,	NODEST,	NODEST,	NODEST,	NODEST,	0xe23a,	NODEST,	NODEST,
	/* 10 */
	0xe23b,	NODEST,	0xeec0,	NODEST,	0xe23c,	0xf46e,	0xe23d,	0xe23e,
	/* 18 */
	0xe23f,	0xeec1,	0xe240,	NODEST,	0xe241,	NODEST,	0xe242,	NODEST,
	/* 20 */
	0xe243,	NODEST,	0xe245,	0xe246,	NODEST,	0xe244,	NODEST,	0xe247,
	/* 28 */
	NODEST,	0xe248,	NODEST,	NODEST,	NODEST,	0xc5a2,	0xe249,	0xe24a,
	/* 30 */
	0xeec3,	0xe24b,	0xeec2,	NODEST,	0xe24c,	NODEST,	0xe24d,	0xe24e,
	/* 38 */
	NODEST,	0xe24f,	0xe250,	NODEST,	0xe251,	0xe252,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	0xe253,	NODEST,	NODEST,	NODEST,	0xe254,
	/* 48 */
	0xe255,	0xc6d3,	0xeec4,	0xbdb6,	0xbce0,	0xc7db,	0xc3f1,	0xe256,
	/* 50 */
	NODEST,	NODEST,	0xbcf2,	0xe257,	0xbfec,	NODEST,	0xeec5,	0xe258,
	/* 58 */
	0xeec6,	0xe259,	0xe25a,	0xe25b,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	0xe25c,	0xbfdd,	0xeec7,	0xe25d,	0xeec8,	NODEST,	0xe25e,
	/* 68 */
	NODEST,	0xeec9,	0xcdef,	NODEST,	0xbdb7,	0xe25f,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	0xeecb,	0xeeca,	0xe260,	0xb9da,	NODEST,	0xb9f3,
	/* 78 */
	0xbbc0,	0xe261,	0xe262,	0xe263,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	0xe264,	0xeece,	0xe265,	NODEST,	0xe266,	0xe267,	0xbde6,
	/* 88 */
	NODEST,	0xeecd,	0xe268,	0xeecc,	NODEST,	0xc2e9,	0xe269,	NODEST,
	/* 90 */
	0xb8ef,	0xe26a,	0xc0c3,	0xe26b,	0xe26c,	0xe26d,	NODEST,	0xc8b0,
	/* 98 */
	0xe26e,	NODEST,	NODEST,	NODEST,	0xbdb9,	NODEST,	0xe26f,	NODEST,
	/* A0 */
	NODEST,	0xe270,	0xeecf,	NODEST,	0xbedf,	NODEST,	0xe271,	NODEST,
	/* A8 */
	0xe272,	NODEST,	0xeed2,	0xeed0,	0xe273,	0xe274,	0xe275,	0xeed1,
	/* B0 */
	0xe276,	0xe277,	0xe278,	0xe279,	0xeed4,	0xeed3,	0xe27a,	NODEST,
	/* B8 */
	0xbefa,	NODEST,	0xeed5,	0xe27b,	0xe27c,	0xe27d,	NODEST,	0xe27e,
	/* C0 */
	0xeed6,	0xeed7,	0xe321,	0xe322,	NODEST,	0xe323,	0xc8d0,	0xbad3,
	/* C8 */
	0xbce1,	0xeed8,	NODEST,	0xeed9,	0xcea4,	0xbdc5,	0xccee,	0xcecc,
	/* D0 */
	0xeeda,	0xb6e2,	NODEST,	0xe324,	0xe325,	NODEST,	0xeedb,	0xe326,
	/* D8 */
	0xc5a3,	0xe327,	0xe328,	0xeede,	0xb3f8,	0xbfcb,	0xe329,	0xeedc,
	/* E0 */
	NODEST,	0xeedd,	NODEST,	0xc4e0,	0xe32a,	0xe32b,	0xcbd5,	0xb6fc,
	/* E8 */
	NODEST,	0xe32c,	0xe32d,	NODEST,	0xe32e,	0xe32f,	0xe330,	0xe331,
	/* F0 */
	0xe332,	0xe333,	NODEST,	NODEST,	NODEST,	0xeee0,	0xeee1,	0xe334,
	/* F8 */
	NODEST,	0xe335,	NODEST,	0xe336,	0xeedf,	0xe337,	NODEST,	0xeee3,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_92[] = {
	/* 00 */
	0xe338,	0xe339,	NODEST,	NODEST,	0xe33a,	0xe33b,	0xe33c,	0xe33d,
	/* 08 */
	NODEST,	0xe33e,	0xe33f,	NODEST,	0xe340,	0xc6df,	0xb3c3,	NODEST,
	/* 10 */
	0xe341,	0xeee7,	0xe342,	0xe343,	0xeee4,	0xeee6,	0xe344,	NODEST,
	/* 18 */
	0xe345,	NODEST,	NODEST,	NODEST,	0xe346,	0xe347,	0xeee2,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	0xe348,	0xe349,	0xe34a,	0xe34b,	NODEST,
	/* 28 */
	0xe34c,	0xefcf,	NODEST,	NODEST,	0xeee5,	NODEST,	0xe34d,	0xe34e,
	/* 30 */
	0xe34f,	NODEST,	NODEST,	0xe350,	0xceeb,	0xe351,	0xe352,	0xb8da,
	/* 38 */
	0xe353,	0xe354,	0xe355,	NODEST,	0xe356,	NODEST,	0xe357,	0xeeef,
	/* 40 */
	0xe358,	NODEST,	0xe359,	0xe35a,	0xc5b4,	0xeeea,	0xe35b,	0xe35c,
	/* 48 */
	0xeeed,	0xeeeb,	0xe35d,	0xeef0,	NODEST,	0xe35e,	0xe35f,	0xe360,
	/* 50 */
	0xeef1,	0xe361,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xeee9,
	/* 58 */
	0xe362,	0xe363,	0xeef6,	0xb1f4,	0xe364,	0xe365,	0xeee8,	NODEST,
	/* 60 */
	0xe366,	0xe367,	0xc8ad,	NODEST,	0xeeec,	0xe368,	0xbee0,	0xe369,
	/* 68 */
	0xe36a,	0xe36b,	NODEST,	NODEST,	NODEST,	NODEST,	0xe36c,	0xe36d,
	/* 70 */
	0xe36e,	0xb9db,	NODEST,	NODEST,	NODEST,	0xe36f,	0xe370,	0xe371,
	/* 78 */
	0xe372,	0xe373,	NODEST,	0xe374,	0xe375,	0xe376,	0xcbc8,	0xe377,
	/* 80 */
	0xb6e4,	NODEST,	NODEST,	0xbdc6,	NODEST,	0xc6bc,	NODEST,	NODEST,
	/* 88 */
	0xe378,	0xe379,	0xe37a,	NODEST,	NODEST,	0xe37b,	0xe37c,	NODEST,
	/* 90 */
	NODEST,	0xc1ad,	0xe37d,	0xeef4,	NODEST,	0xeeee,	0xeef3,	0xe37e,
	/* 98 */
	0xccc3,	0xe421,	0xc4b8,	0xeef5,	0xeef2,	NODEST,	NODEST,	0xe422,
	/* A0 */
	0xe423,	NODEST,	NODEST,	NODEST,	0xe424,	0xe425,	NODEST,	0xe426,
	/* A8 */
	0xe427,	NODEST,	NODEST,	0xe428,	NODEST,	0xc1ac,	NODEST,	0xe429,
	/* B0 */
	NODEST,	NODEST,	0xe42a,	NODEST,	NODEST,	NODEST,	0xe42b,	0xeef9,
	/* B8 */
	0xe42c,	0xeef8,	0xe42d,	0xe42e,	0xe42f,	0xe430,	NODEST,	0xe431,
	/* C0 */
	0xe432,	0xe433,	0xe434,	0xe435,	NODEST,	0xe436,	0xe437,	0xe438,
	/* C8 */
	0xe439,	NODEST,	NODEST,	0xe43a,	0xe43b,	0xe43c,	0xe43d,	0xeef7,
	/* D0 */
	0xe43e,	NODEST,	0xcbaf,	0xe43f,	NODEST,	0xe440,	NODEST,	0xe441,
	/* D8 */
	0xe442,	0xe443,	NODEST,	NODEST,	0xe444,	0xe445,	NODEST,	0xe446,
	/* E0 */
	0xe447,	0xe448,	NODEST,	0xe449,	0xbdfb,	0xe44a,	NODEST,	0xe44b,
	/* E8 */
	0xe44c,	0xeefa,	0xcadf,	NODEST,	0xe44d,	0xb1d4,	0xe44e,	NODEST,
	/* F0 */
	0xe44f,	NODEST,	0xc9c6,	0xc3f2,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	0xb5f8,	0xe450,	0xeefc,	0xe451,	0xb9dd,	NODEST,	NODEST,	0xe452,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_93[] = {
	/* 00 */
	0xe453,	NODEST,	0xe454,	NODEST,	NODEST,	NODEST,	0xbbac,	NODEST,
	/* 08 */
	0xe455,	NODEST,	NODEST,	NODEST,	NODEST,	0xe456,	NODEST,	0xeefb,
	/* 10 */
	0xbfed,	0xe457,	NODEST,	NODEST,	0xe458,	0xe459,	NODEST,	NODEST,
	/* 18 */
	0xbfee,	0xefa1,	0xefa3,	NODEST,	0xe45a,	0xe45b,	0xe45c,	0xe45d,
	/* 20 */
	0xbefb,	0xe45e,	0xefa2,	0xefa4,	0xe45f,	0xe460,	0xb6d3,	0xe461,
	/* 28 */
	0xc9c5,	0xe462,	0xe463,	0xbce2,	0xcfa3,	NODEST,	0xeefe,	0xbaf8,
	/* 30 */
	NODEST,	NODEST,	0xcfbf,	0xe464,	0xe465,	0xefa6,	0xe466,	0xe467,
	/* 38 */
	NODEST,	NODEST,	0xefa5,	0xefa7,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xeefd,	NODEST,	NODEST,	0xe468,
	/* 48 */
	0xe469,	0xe46a,	NODEST,	0xc6e9,	NODEST,	0xc5d5,	NODEST,	NODEST,
	/* 50 */
	0xe46b,	0xe46c,	0xe46d,	NODEST,	0xc4d7,	0xe46e,	0xefac,	0xe46f,
	/* 58 */
	0xe470,	NODEST,	0xe471,	0xc3c3,	0xefa8,	NODEST,	0xe472,	NODEST,
	/* 60 */
	0xefa9,	NODEST,	NODEST,	NODEST,	0xe473,	0xe474,	NODEST,	0xe475,
	/* 68 */
	NODEST,	0xe476,	0xe477,	NODEST,	0xb7ad,	0xe478,	0xefab,	0xe479,
	/* 70 */
	0xe47a,	0xe47b,	NODEST,	0xe47c,	0xe47d,	0xb8b0,	0xe47e,	NODEST,
	/* 78 */
	NODEST,	NODEST,	0xe521,	NODEST,	0xefaa,	0xe522,	0xbee1,	0xe523,
	/* 80 */
	0xe524,	0xe525,	0xe526,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	0xe527,	NODEST,	0xe528,	0xe529,	0xb3f9,	0xe52a,	NODEST,	0xe52b,
	/* 90 */
	NODEST,	NODEST,	0xe52c,	NODEST,	0xefb0,	0xe52d,	0xbabf,	0xc1f9,
	/* 98 */
	0xe52e,	NODEST,	0xc4ca,	0xe52f,	NODEST,	NODEST,	0xe530,	NODEST,
	/* A0 */
	NODEST,	0xe531,	NODEST,	0xe532,	0xe533,	NODEST,	0xe534,	0xb3bb,
	/* A8 */
	0xe535,	0xe53b,	NODEST,	0xe536,	0xefae,	0xefaf,	0xc4c3,	NODEST,
	/* B0 */
	0xefad,	NODEST,	NODEST,	NODEST,	0xe537,	0xe538,	0xe539,	NODEST,
	/* B8 */
	NODEST,	0xefb1,	0xe53a,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	0xe53c,	NODEST,	0xefb7,	0xe53d,	0xe53e,	0xe53f,	0xe540,
	/* C8 */
	0xefba,	0xe541,	0xe542,	0xe543,	0xe544,	0xe545,	NODEST,	NODEST,
	/* D0 */
	0xefb9,	0xc5ad,	NODEST,	0xe546,	NODEST,	NODEST,	0xefb2,	0xefb3,
	/* D8 */
	0xefb6,	0xe547,	NODEST,	NODEST,	0xe548,	0xefb8,	0xe549,	0xe54a,
	/* E0 */
	NODEST,	0xb6c0,	0xe54b,	NODEST,	0xefbb,	0xefb5,	0xe54c,	0xe54d,
	/* E8 */
	0xefb4,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe54f,
	/* F8 */
	0xe550,	0xe54e,	0xe551,	0xe552,	NODEST,	0xe553,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_94[] = {
	/* 00 */
	NODEST,	0xe554,	0xe555,	0xefbf,	0xe556,	NODEST,	NODEST,	0xefc0,
	/* 08 */
	0xe557,	0xe558,	NODEST,	NODEST,	NODEST,	0xe559,	0xe55a,	0xe55b,
	/* 10 */
	0xefc1,	NODEST,	NODEST,	0xefbe,	0xefbd,	0xe55c,	0xe55d,	0xe55e,
	/* 18 */
	0xbee2,	0xc6aa,	0xefbc,	NODEST,	NODEST,	NODEST,	NODEST,	0xe55f,
	/* 20 */
	NODEST,	0xefc5,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xefc3,	NODEST,	NODEST,	0xe560,	0xe561,
	/* 30 */
	NODEST,	0xe562,	0xe563,	0xe564,	0xe565,	0xefc4,	0xefc2,	NODEST,
	/* 38 */
	0xc2f8,	NODEST,	0xefc6,	0xe566,	NODEST,	0xe568,	NODEST,	0xe567,
	/* 40 */
	NODEST,	0xefc7,	NODEST,	0xe569,	0xefc9,	0xe56a,	NODEST,	NODEST,
	/* 48 */
	0xe56b,	NODEST,	0xe56c,	NODEST,	0xe56d,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	0xb4d5,	0xefc8,	0xccfa,	NODEST,	0xe56e,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xe56f,	0xefd4,	0xefca,	0xe570,	NODEST,	0xefcd,	0xe571,
	/* 60 */
	0xefcb,	0xe572,	0xefcc,	0xe573,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	0xe574,	NODEST,	0xefce,	0xe575,	NODEST,	0xe576,	0xe577,	0xe578,
	/* 70 */
	0xefd0,	0xe579,	0xe57a,	NODEST,	NODEST,	0xefd1,	NODEST,	0xefd2,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xefd5,	0xefd3,	0xefd6,	0xefd8,
	/* 80 */
	NODEST,	0xefd7,	NODEST,	0xe57c,	0xe57b,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_95[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc4b9,
	/* 78 */
	0xe57d,	0xe57e,	NODEST,	NODEST,	NODEST,	NODEST,	0xe621,	NODEST,
	/* 80 */
	0xcce7,	NODEST,	0xefd9,	0xc1ae,	0xe622,	NODEST,	NODEST,	0xefda,
	/* 88 */
	0xe623,	0xcac4,	0xefdb,	0xb3ab,	0xe624,	0xe625,	0xe626,	0xb1bc,
	/* 90 */
	NODEST,	0xb4d7,	0xf471,	0xb4d6,	0xefdc,	NODEST,	0xefdd,	NODEST,
	/* 98 */
	0xefde,	0xefdf,	NODEST,	NODEST,	NODEST,	0xe627,	0xe628,	0xe629,
	/* A0 */
	0xefe0,	0xe62a,	0xb4d8,	0xb3d5,	0xb9de,	0xc8b6,	0xe62b,	0xefe2,
	/* A8 */
	0xefe1,	0xe62c,	NODEST,	0xe62d,	0xe62e,	0xefe3,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	0xb1dc,	NODEST,	0xe62f,	NODEST,	0xe630,	NODEST,
	/* B8 */
	NODEST,	0xefe6,	0xe631,	0xefe5,	0xefe4,	0xe632,	0xefe7,	0xe633,
	/* C0 */
	NODEST,	NODEST,	NODEST,	0xefea,	NODEST,	NODEST,	0xe634,	0xb0c7,
	/* C8 */
	0xe635,	0xe636,	0xefe8,	0xe637,	0xefec,	0xefeb,	NODEST,	NODEST,
	/* D0 */
	0xe638,	0xe639,	0xe63a,	0xe63b,	0xefee,	0xefed,	0xefef,	NODEST,
	/* D8 */
	0xc6ae,	0xe63c,	0xe63d,	NODEST,	0xeff0,	0xe63e,	0xe63f,	0xe640,
	/* E0 */
	0xe641,	0xeff1,	0xeff3,	NODEST,	0xe642,	0xeff2,	0xe643,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_96[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xc9ec,	0xe644,	0xe645,	NODEST,
	/* 20 */
	NODEST,	0xeff4,	0xe646,	NODEST,	0xe647,	0xe648,	0xe649,	NODEST,
	/* 28 */
	0xeff5,	NODEST,	0xbae5,	NODEST,	0xe64a,	NODEST,	0xeff6,	0xeff7,
	/* 30 */
	NODEST,	0xe64b,	0xcbc9,	0xe64c,	NODEST,	NODEST,	NODEST,	0xe64d,
	/* 38 */
	0xe64e,	0xe64f,	0xe650,	0xc1cb,	0xe651,	0xe652,	NODEST,	0xb0a4,
	/* 40 */
	0xc2cb,	0xe653,	0xeff8,	NODEST,	0xc9ed,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	0xeffb,	0xeff9,	0xb9df,	NODEST,	0xeffa,
	/* 50 */
	0xb8c2,	NODEST,	0xe654,	NODEST,	0xe655,	NODEST,	0xe656,	0xe657,
	/* 58 */
	0xe658,	NODEST,	NODEST,	0xcac5,	0xeffd,	0xf0a1,	0xeffe,	0xf0a2,
	/* 60 */
	NODEST,	0xe659,	0xb1a1,	0xbfd8,	0xbdfc,	0xb4d9,	0xf0a3,	NODEST,
	/* 68 */
	NODEST,	NODEST,	0xc7e6,	NODEST,	0xf0a5,	NODEST,	0xe65a,	NODEST,
	/* 70 */
	0xb1a2,	NODEST,	0xf0a4,	0xc4c4,	0xe65b,	0xcecd,	0xc6ab,	0xeffc,
	/* 78 */
	0xcea6,	NODEST,	0xb8b1,	0xe65c,	0xe65d,	0xcddb,	0xe65e,	0xe65f,
	/* 80 */
	NODEST,	0xe660,	0xe661,	0xe662,	0xe663,	0xb6f9,	0xceb4,	NODEST,
	/* 88 */
	0xb7a8,	0xe664,	0xc2e2,	0xe7a1,	NODEST,	0xf0a6,	0xb3ac,	0xbfef,
	/* 90 */
	NODEST,	0xe665,	NODEST,	NODEST,	0xb3d6,	0xf0a8,	0xe666,	0xf0a9,
	/* 98 */
	0xf0a7,	0xb7e4,	0xe667,	0xbadd,	0xbee3,	0xe668,	NODEST,	0xe669,
	/* A0 */
	0xb1a3,	NODEST,	NODEST,	0xced9,	0xe66a,	0xe66b,	0xe66c,	0xf0ab,
	/* A8 */
	0xeeae,	0xe66d,	0xf0aa,	NODEST,	NODEST,	NODEST,	0xe66e,	0xe66f,
	/* B0 */
	0xf0ae,	0xf0ac,	0xf0ad,	0xe670,	0xf0af,	NODEST,	0xf0b0,	0xceec,
	/* B8 */
	0xf0b1,	0xf0b2,	0xe671,	0xc0c9,	0xc8bb,	NODEST,	NODEST,	NODEST,
	/* C0 */
	0xbffd,	0xb4e7,	NODEST,	NODEST,	0xcdba,	0xb2ed,	0xbdb8,	0xb8db,
	/* C8 */
	NODEST,	0xf0b5,	0xe672,	0xf0b4,	0xbbf3,	0xf0b6,	0xf0b3,	NODEST,
	/* D0 */
	NODEST,	0xbba8,	0xe673,	NODEST,	NODEST,	0xf0ba,	0xeaad,	NODEST,
	/* D8 */
	0xe675,	0xd2d6,	0xe676,	0xbff7,	0xf0b8,	0xe677,	0xe678,	0xe679,
	/* E0 */
	NODEST,	NODEST,	0xcea5,	0xc6f1,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	0xb1ab,	0xe67a,	0xc0e3,	0xbcb6,	NODEST,	NODEST,	NODEST,	0xe67b,
	/* F0 */
	0xcab7,	0xe67c,	0xb1c0,	NODEST,	NODEST,	NODEST,	0xceed,	0xcdeb,
	/* F8 */
	NODEST,	0xf0bb,	0xe67d,	0xc5c5,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_97[] = {
	/* 00 */
	0xbcfb,	NODEST,	0xe67e,	0xe721,	0xf0bc,	0xe722,	0xf0bd,	0xbfcc,
	/* 08 */
	0xf0be,	0xe723,	0xceee,	NODEST,	NODEST,	0xf0b9,	0xf0c0,	0xf0c2,
	/* 10 */
	NODEST,	0xf0c1,	NODEST,	0xf0bf,	NODEST,	NODEST,	0xf0c3,	NODEST,
	/* 18 */
	NODEST,	0xf0c4,	0xe724,	0xe725,	0xc1fa,	0xe726,	0xb2e2,	NODEST,
	/* 20 */
	NODEST,	0xe727,	0xe728,	0xe729,	0xf0c5,	NODEST,	NODEST,	0xccb8,
	/* 28 */
	0xe72a,	NODEST,	0xf0c6,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	0xf0c7,	0xe72b,	0xcfaa,	0xe72c,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	0xdbb1,	0xf0c8,	NODEST,	0xf474,	NODEST,	0xf0c9,	0xf0ca,	NODEST,
	/* 40 */
	NODEST,	0xe72d,	0xf0ce,	0xe72e,	0xf0cb,	NODEST,	0xf0cc,	NODEST,
	/* 48 */
	0xf0cd,	0xf0cf,	0xe72f,	NODEST,	NODEST,	0xf475,	0xe730,	0xe731,
	/* 50 */
	NODEST,	0xf476,	0xc0c4,	NODEST,	NODEST,	0xe732,	0xccf7,	0xe733,
	/* 58 */
	0xe734,	0xc0c5,	0xe735,	0xe736,	0xf0d0,	NODEST,	0xc8f3,	NODEST,
	/* 60 */
	0xf0d1,	0xf3d3,	0xcccc,	0xe737,	0xf0d2,	NODEST,	0xf0d3,	0xe738,
	/* 68 */
	0xf0d4,	0xb3d7,	0xe739,	0xf0d6,	NODEST,	0xbfd9,	0xe73a,	NODEST,
	/* 70 */
	NODEST,	0xf0d7,	NODEST,	0xe73b,	0xb7a4,	NODEST,	0xe73c,	0xe73d,
	/* 78 */
	0xe73e,	0xf0d8,	0xf0dc,	0xe73f,	0xf0da,	0xe740,	NODEST,	0xe741,
	/* 80 */
	0xe742,	0xf0db,	NODEST,	NODEST,	0xb3f3,	0xf0d9,	0xf0dd,	NODEST,
	/* 88 */
	NODEST,	0xe743,	NODEST,	0xf0de,	NODEST,	0xb0c8,	NODEST,	0xf0df,
	/* 90 */
	0xf0e0,	NODEST,	NODEST,	NODEST,	NODEST,	0xe744,	0xe745,	0xe746,
	/* 98 */
	0xbee4,	0xe747,	0xe748,	NODEST,	0xf0e1,	NODEST,	0xe749,	0xe74a,
	/* A0 */
	0xb5c7,	NODEST,	0xe74b,	0xf0e4,	NODEST,	NODEST,	0xf0e3,	NODEST,
	/* A8 */
	0xf0e2,	NODEST,	NODEST,	0xebf1,	0xe74c,	0xcadc,	0xe74d,	NODEST,
	/* B0 */
	NODEST,	0xe74e,	0xe74f,	0xf0e5,	0xf0e6,	0xe750,	0xe751,	NODEST,
	/* B8 */
	0xe752,	0xe753,	0xe754,	NODEST,	0xe755,	NODEST,	0xe756,	0xe757,
	/* C0 */
	NODEST,	0xe758,	NODEST,	0xf0e7,	0xe759,	0xe75a,	0xf0e8,	0xe75b,
	/* C8 */
	0xf0e9,	0xe75c,	0xe75d,	0xf0ea,	0xe75e,	0xe75f,	0xe760,	NODEST,
	/* D0 */
	0xe761,	0xe762,	NODEST,	0xb4da,	0xe763,	NODEST,	NODEST,	0xe764,
	/* D8 */
	0xe765,	0xe766,	NODEST,	0xe76a,	0xf0eb,	0xe767,	0xe768,	NODEST,
	/* E0 */
	0xe769,	0xe76b,	NODEST,	NODEST,	0xe76c,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xf0ec,	0xc7a3,	0xe76d,
	/* F0 */
	NODEST,	0xe76e,	0xf0ee,	0xb2bb,	0xe76f,	0xf0f1,	0xf0f0,	0xe770,
	/* F8 */
	0xe771,	NODEST,	0xe772,	0xb1a4,	NODEST,	NODEST,	NODEST,	0xb6c1,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_98[] = {
	/* 00 */
	NODEST,	0xcac7,	0xc4ba,	0xbaa2,	NODEST,	0xb9e0,	0xbde7,	0xe773,
	/* 08 */
	0xbfdc,	NODEST,	0xe774,	NODEST,	0xf0f3,	0xe776,	0xe777,	0xf0f2,
	/* 10 */
	0xcdc2,	0xb4e8,	0xc8d2,	0xc6dc,	0xe778,	NODEST,	0xe779,	0xbffc,
	/* 18 */
	0xcece,	0xe775,	0xb7db,	NODEST,	0xe77a,	NODEST,	0xe77b,	NODEST,
	/* 20 */
	0xe77c,	0xf0f6,	NODEST,	0xe77d,	0xf0f5,	0xe828,	0xe77e,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	0xe821,	0xcbcb,	0xc6ac,	0xe822,	0xe823,
	/* 30 */
	0xe824,	NODEST,	0xe825,	0xe826,	0xb1d0,	0xe827,	NODEST,	0xf0f7,
	/* 38 */
	0xf0f4,	NODEST,	NODEST,	0xc9d1,	0xcdea,	0xf0f8,	0xe829,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xe82a,	NODEST,	0xf0f9,	0xe82b,
	/* 48 */
	NODEST,	NODEST,	0xe82c,	0xf0fb,	0xc2ea,	0xb3db,	0xb3dc,	0xf0fa,
	/* 50 */
	NODEST,	0xe82d,	0xe82e,	0xe82f,	0xb4e9,	0xb8b2,	0xe830,	0xe831,
	/* 58 */
	0xb4ea,	0xe832,	0xe833,	0xc5bf,	NODEST,	NODEST,	0xcee0,	NODEST,
	/* 60 */
	NODEST,	NODEST,	0xe834,	0xe835,	NODEST,	0xe836,	0xe837,	0xb8dc,
	/* 68 */
	NODEST,	NODEST,	0xe838,	0xf0fc,	0xe839,	NODEST,	NODEST,	0xf0fd,
	/* 70 */
	0xf0fe,	0xf1a1,	NODEST,	0xf1a3,	0xf1a2,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xc9f7,	NODEST,	0xf1a4,	0xe83a,	NODEST,	0xe83b,	0xe83c,	0xf1a5,
	/* B0 */
	0xe83d,	0xf1a6,	NODEST,	NODEST,	0xe83e,	NODEST,	0xf1a7,	0xe83f,
	/* B8 */
	0xe840,	NODEST,	0xe841,	0xe842,	NODEST,	NODEST,	NODEST,	0xe843,
	/* C0 */
	NODEST,	NODEST,	0xe844,	0xf1a9,	0xf1a8,	0xe845,	0xf1aa,	NODEST,
	/* C8 */
	0xe846,	NODEST,	NODEST,	NODEST,	0xe847,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	0xc8f4,	0xe6cc,	NODEST,	NODEST,	0xbfa9,
	/* E0 */
	NODEST,	0xe848,	0xb5b2,	0xe849,	NODEST,	0xe84a,	0xe84b,	0xe84c,
	/* E8 */
	NODEST,	0xf1ab,	0xe84d,	0xf1ac,	NODEST,	0xd2ac,	0xddbb,	0xc8d3,
	/* F0 */
	NODEST,	NODEST,	0xb0fb,	0xe84e,	0xb0bb,	NODEST,	0xe84f,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xbbf4,	0xcbb0,	0xbefe,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_99[] = {
	/* 00 */
	NODEST,	NODEST,	0xe850,	0xf1ad,	NODEST,	0xccdf,	NODEST,	0xe851,
	/* 08 */
	0xe852,	0xf1ae,	0xcddc,	NODEST,	0xb1c2,	NODEST,	NODEST,	NODEST,
	/* 10 */
	0xbbc1,	0xe853,	0xf1af,	0xb2ee,	0xf1b0,	0xe854,	0xe855,	0xe856,
	/* 18 */
	0xf1b1,	NODEST,	0xe857,	0xe858,	0xe859,	0xf1b3,	0xf1b4,	0xe85a,
	/* 20 */
	0xf1b6,	0xf1b2,	0xe85b,	NODEST,	0xf1b5,	NODEST,	0xe85c,	0xe85d,
	/* 28 */
	0xb4db,	NODEST,	NODEST,	0xe85e,	0xf1b7,	NODEST,	0xf1b8,	NODEST,
	/* 30 */
	NODEST,	0xe85f,	0xe860,	0xe861,	0xe862,	0xe863,	NODEST,	NODEST,
	/* 38 */
	NODEST,	0xe864,	0xe865,	0xe866,	0xe867,	0xf1b9,	0xf1ba,	NODEST,
	/* 40 */
	0xe868,	0xe869,	0xf1bb,	NODEST,	NODEST,	0xf1bd,	0xe86a,	0xe86b,
	/* 48 */
	0xe86c,	0xf1bc,	NODEST,	0xf1bf,	0xf1c2,	0xe86d,	0xe86e,	NODEST,
	/* 50 */
	0xf1be,	0xf1c0,	0xf1c1,	NODEST,	0xe86f,	0xf1c3,	NODEST,	0xb6c2,
	/* 58 */
	0xe870,	0xe871,	NODEST,	0xe872,	0xe873,	NODEST,	0xe874,	0xe875,
	/* 60 */
	0xe876,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xbcf3,	0xf1c4,
	/* 98 */
	0xf1c5,	0xb9e1,	NODEST,	0xe877,	NODEST,	0xe878,	0xf47a,	0xe879,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xf1c6,	0xe87a,	NODEST,
	/* A8 */
	0xb3be,	NODEST,	NODEST,	NODEST,	0xc7cf,	0xf1c7,	0xf1c8,	NODEST,
	/* B0 */
	0xe87b,	0xe87c,	0xe87d,	0xc3da,	0xc6eb,	0xe87e,	NODEST,	NODEST,
	/* B8 */
	NODEST,	0xe921,	0xe922,	NODEST,	0xf1c9,	0xe923,	NODEST,	0xe924,
	/* C0 */
	NODEST,	0xc7fd,	NODEST,	0xe925,	0xc2cc,	0xb1d8,	0xb6ee,	NODEST,
	/* C8 */
	0xb6ef,	0xe926,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	0xc3f3,	0xf1ce,	0xb6f0,	0xe927,	0xe928,	0xb2ef,	NODEST,	NODEST,
	/* D8 */
	0xf1cd,	0xe929,	0xe92a,	0xf1cb,	0xe92b,	0xf1cc,	0xe92c,	0xf1ca,
	/* E0 */
	NODEST,	NODEST,	0xf1d8,	NODEST,	NODEST,	NODEST,	NODEST,	0xe92d,
	/* E8 */
	NODEST,	NODEST,	0xe92e,	0xe92f,	0xe930,	0xf1cf,	0xf1d0,	NODEST,
	/* F0 */
	0xe931,	0xf1d1,	0xf1d2,	NODEST,	0xe932,	0xe933,	NODEST,	NODEST,
	/* F8 */
	0xf1d4,	0xe934,	NODEST,	0xf1d3,	NODEST,	0xe935,	0xe936,	0xbdd9,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9A[] = {
	/* 00 */
	NODEST,	0xf1d5,	0xe937,	0xe938,	0xe939,	0xf1d7,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	0xe93a,	0xe93b,	NODEST,	0xb5b3,	0xf1d6,
	/* 10 */
	0xe93c,	0xe93d,	0xc1fb,	0xb8b3,	NODEST,	NODEST,	0xe93e,	NODEST,
	/* 18 */
	NODEST,	0xf1d9,	NODEST,	NODEST,	NODEST,	NODEST,	0xe93f,	NODEST,
	/* 20 */
	0xe940,	NODEST,	0xe941,	0xe942,	0xe943,	NODEST,	NODEST,	0xe944,
	/* 28 */
	0xc2cd,	NODEST,	NODEST,	0xf1da,	NODEST,	0xe945,	0xe946,	NODEST,
	/* 30 */
	0xc6ad,	NODEST,	NODEST,	0xe947,	NODEST,	0xe948,	0xe949,	0xf1db,
	/* 38 */
	0xe94a,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xf1e0,	NODEST,
	/* 40 */
	0xf1de,	0xe94c,	0xf1dd,	0xf1df,	0xe94d,	0xf1dc,	NODEST,	0xe94b,
	/* 48 */
	NODEST,	NODEST,	0xe94e,	0xe94f,	0xe950,	0xf1e2,	0xe951,	NODEST,
	/* 50 */
	NODEST,	0xe952,	NODEST,	NODEST,	0xe953,	0xf1e1,	0xe954,	0xf1e4,
	/* 58 */
	NODEST,	NODEST,	0xb6c3,	0xf1e3,	NODEST,	0xe955,	NODEST,	0xf1e5,
	/* 60 */
	NODEST,	NODEST,	0xf1e6,	NODEST,	0xf1e8,	0xf1e7,	NODEST,	NODEST,
	/* 68 */
	NODEST,	0xf1e9,	0xf1eb,	0xf1ea,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	0xb9fc,	NODEST,	0xe956,	NODEST,	0xe957,	0xf1ec,	0xe958,	0xe959,
	/* B0 */
	0xf1ed,	NODEST,	0xe95a,	NODEST,	0xe95b,	0xe95c,	0xe95d,	NODEST,
	/* B8 */
	0xb3bc,	0xe95e,	NODEST,	0xe95f,	0xf1ee,	NODEST,	0xe960,	0xe961,
	/* C0 */
	0xf1ef,	0xe962,	NODEST,	0xe963,	0xbff1,	NODEST,	0xe964,	NODEST,
	/* C8 */
	0xe965,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xe966,	0xf1f0,
	/* D0 */
	0xe967,	0xf1f1,	0xe968,	0xf1f2,	0xf1f3,	0xe969,	0xe96a,	0xe96b,
	/* D8 */
	0xb9e2,	0xf47b,	NODEST,	0xe96c,	0xe96d,	NODEST,	0xf1f4,	0xf1f5,
	/* E0 */
	0xe96e,	NODEST,	0xf1f6,	0xf1f7,	0xe96f,	0xe970,	0xf1f8,	0xe971,
	/* E8 */
	NODEST,	0xe972,	0xc8b1,	0xf1fa,	0xe973,	0xc9a6,	0xf1fb,	0xf1f9,
	/* F0 */
	NODEST,	0xf1fd,	0xe974,	0xe975,	0xf1fc,	0xe976,	NODEST,	0xf1fe,
	/* F8 */
	NODEST,	0xe977,	0xe978,	0xf2a1,	NODEST,	0xe979,	NODEST,	0xe97a,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9B[] = {
	/* 00 */
	0xe97b,	0xe97c,	0xe97d,	0xe97e,	0xea21,	0xea22,	0xf2a2,	NODEST,
	/* 08 */
	0xea23,	0xea24,	NODEST,	0xea25,	0xea26,	0xea27,	0xea28,	NODEST,
	/* 10 */
	0xea29,	NODEST,	0xea2a,	NODEST,	NODEST,	NODEST,	0xea2b,	NODEST,
	/* 18 */
	0xf2a3,	0xea2c,	0xf2a4,	0xea2d,	0xea2e,	NODEST,	NODEST,	0xf2a5,
	/* 20 */
	0xea2f,	NODEST,	0xf2a6,	0xf2a7,	NODEST,	0xf2a8,	0xea30,	0xf2a9,
	/* 28 */
	0xf2aa,	0xf2ab,	0xf2ac,	0xea31,	NODEST,	0xea32,	0xf2ad,	0xf2ae,
	/* 30 */
	NODEST,	0xddb5,	0xf2af,	0xea33,	0xea34,	0xea35,	NODEST,	0xea36,
	/* 38 */
	NODEST,	0xea37,	0xea38,	0xe4f8,	0xb5b4,	0xea39,	NODEST,	NODEST,
	/* 40 */
	NODEST,	0xb3a1,	0xbab2,	0xf2b1,	0xf2b0,	0xcca5,	NODEST,	NODEST,
	/* 48 */
	0xea3a,	NODEST,	NODEST,	0xea3b,	0xea3c,	0xf2b3,	0xf2b4,	0xf2b2,
	/* 50 */
	NODEST,	0xf2b5,	NODEST,	NODEST,	0xcbe2,	0xea3d,	0xea3e,	0xea3f,
	/* 58 */
	0xf2b6,	NODEST,	0xb5fb,	0xea40,	NODEST,	NODEST,	0xea41,	NODEST,
	/* 60 */
	NODEST,	0xea42,	NODEST,	0xea43,	NODEST,	0xea44,	0xea45,	NODEST,
	/* 68 */
	0xea46,	NODEST,	0xea47,	0xea48,	0xea49,	0xea4a,	0xea4b,	0xcfa5,
	/* 70 */
	NODEST,	NODEST,	0xf47c,	0xea4c,	0xf2b7,	0xea4d,	NODEST,	0xea4e,
	/* 78 */
	0xea4f,	0xea50,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xea51,
	/* 80 */
	0xea52,	NODEST,	NODEST,	0xf2b9,	0xea53,	0xea54,	0xea55,	0xea56,
	/* 88 */
	NODEST,	0xea57,	0xea58,	0xea59,	NODEST,	0xea5a,	0xb0be,	0xea5b,
	/* 90 */
	0xea5c,	0xf2ba,	0xcaab,	0xf2b8,	0xea5d,	NODEST,	0xf2bb,	0xf2bc,
	/* 98 */
	NODEST,	NODEST,	0xea5e,	NODEST,	NODEST,	0xea5f,	0xea60,	0xf2bd,
	/* A0 */
	0xf2be,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xea61,	0xea62,
	/* A8 */
	0xf2bf,	0xea63,	0xcbee,	0xbbad,	0xea64,	0xbafa,	0xc1af,	NODEST,
	/* B0 */
	0xea65,	0xea66,	0xea67,	NODEST,	0xf2c0,	NODEST,	NODEST,	0xea68,
	/* B8 */
	0xea69,	0xf2c3,	NODEST,	0xea6a,	0xea6b,	NODEST,	0xea6c,	0xea6d,
	/* C0 */
	0xf2c1,	0xea6e,	NODEST,	NODEST,	NODEST,	NODEST,	0xf2c4,	0xea6f,
	/* C8 */
	0xea70,	0xb8f1,	0xf2c2,	NODEST,	NODEST,	NODEST,	0xea71,	0xf2c5,
	/* D0 */
	0xea72,	0xf2c6,	0xf2c7,	NODEST,	0xf2cb,	NODEST,	0xbbaa,	0xea73,
	/* D8 */
	0xea74,	NODEST,	NODEST,	0xc2e4,	NODEST,	0xea75,	NODEST,	0xea76,
	/* E0 */
	NODEST,	0xf2cc,	0xf2c9,	0xf2c8,	0xf2ca,	0xea77,	NODEST,	0xea78,
	/* E8 */
	0xb7df,	NODEST,	0xea79,	0xea7a,	NODEST,	NODEST,	NODEST,	0xea7b,
	/* F0 */
	0xf2d0,	0xf2cf,	0xf2ce,	0xea7c,	NODEST,	0xb0b3,	NODEST,	0xea7d,
	/* F8 */
	0xea7e,	0xeb21,	0xeb22,	NODEST,	NODEST,	0xeb23,	NODEST,	0xeb24,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9C[] = {
	/* 00 */
	0xeb25,	NODEST,	0xeb26,	NODEST,	0xf2da,	NODEST,	0xf2d6,	NODEST,
	/* 08 */
	0xf2d7,	0xf2d3,	0xf2d9,	0xeb27,	0xf2d5,	0xb3e2,	NODEST,	0xeb28,
	/* 10 */
	0xcfcc,	0xeb29,	0xf2d8,	0xf2d4,	0xf2d2,	0xf2d1,	0xeb2a,	NODEST,
	/* 18 */
	0xeb2b,	0xeb2c,	0xeb2d,	0xf2dc,	0xeb2e,	NODEST,	0xeb2f,	NODEST,
	/* 20 */
	NODEST,	0xf2df,	0xeb30,	0xeb31,	0xf2de,	0xf2dd,	0xeb32,	0xeb33,
	/* 28 */
	0xeb34,	0xeb35,	0xeb36,	NODEST,	NODEST,	0xc9c9,	0xf2db,	0xb0f3,
	/* 30 */
	0xf2e0,	0xeb37,	0xf2e2,	NODEST,	NODEST,	0xeb38,	0xeb39,	0xeb3a,
	/* 38 */
	NODEST,	0xb3ef,	0xf2cd,	0xb1b7,	NODEST,	0xeb3b,	0xf2e4,	NODEST,
	/* 40 */
	NODEST,	0xeb3c,	NODEST,	0xeb3d,	0xeb3e,	0xeb3f,	0xf2e3,	0xf2e1,
	/* 48 */
	0xc3ad,	0xeb40,	0xeb41,	NODEST,	NODEST,	NODEST,	0xeb42,	0xeb43,
	/* 50 */
	0xeb44,	NODEST,	0xcbf0,	0xeb45,	0xeb46,	NODEST,	0xeb47,	0xceda,
	/* 58 */
	0xeb48,	NODEST,	0xf2e5,	0xeb49,	0xeb50,	0xeb4a,	0xeb4b,	0xeb4c,
	/* 60 */
	0xf2e6,	NODEST,	NODEST,	0xeb4d,	NODEST,	NODEST,	NODEST,	0xf2e7,
	/* 68 */
	0xeb52,	0xeb4e,	0xeb4f,	0xeb51,	NODEST,	NODEST,	0xeb53,	NODEST,
	/* 70 */
	0xeb54,	NODEST,	0xeb55,	NODEST,	NODEST,	0xeb56,	0xf2e8,	0xeb57,
	/* 78 */
	0xf2e9,	NODEST,	NODEST,	0xeb58,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xc4bb,	0xeb59,	0xf2ea,
	/* E8 */
	NODEST,	0xc8b7,	NODEST,	0xf2ef,	0xf2eb,	NODEST,	NODEST,	NODEST,
	/* F0 */
	0xf2ec,	NODEST,	0xeb5a,	0xcbb1,	0xccc4,	NODEST,	0xc6d0,	0xeb5b,
	/* F8 */
	NODEST,	0xeb5c,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9D[] = {
	/* 00 */
	NODEST,	NODEST,	0xeb5e,	0xf2f0,	NODEST,	NODEST,	0xf2f1,	0xc6be,
	/* 08 */
	0xf2ee,	0xf2ed,	NODEST,	0xeb5d,	NODEST,	NODEST,	0xb2aa,	NODEST,
	/* 10 */
	NODEST,	0xeb5f,	0xf2f9,	NODEST,	NODEST,	0xf2f8,	NODEST,	0xeb60,
	/* 18 */
	0xeb61,	NODEST,	NODEST,	0xb1f5,	0xeb62,	0xeb63,	0xeb64,	0xf2f6,
	/* 20 */
	NODEST,	NODEST,	NODEST,	0xf2f5,	NODEST,	NODEST,	0xf2f3,	NODEST,
	/* 28 */
	0xb3fb,	NODEST,	0xf2f2,	0xbcb2,	0xb2a9,	NODEST,	NODEST,	0xeb65,
	/* 30 */
	0xeb66,	NODEST,	0xeb67,	0xeb68,	0xeb69,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	0xeb6a,	0xb9e3,	0xeb6b,	0xeb6d,	0xf2fc,	0xf2fb,
	/* 40 */
	NODEST,	0xf2fa,	0xeb6e,	0xeb6f,	0xf2f7,	0xeb6c,	0xf2fd,	0xeb70,
	/* 48 */
	0xf2fe,	NODEST,	0xeb71,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	0xf3a5,	0xf3a4,	NODEST,	0xeb72,	0xeb73,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	0xf3a6,	NODEST,	NODEST,	0xb1ad,	0xf3a1,	0xf3a2,	0xeb74,
	/* 60 */
	0xb9f4,	0xccb9,	0xeb76,	0xeb75,	0xf3a3,	0xeb77,	NODEST,	NODEST,
	/* 68 */
	NODEST,	0xeb78,	0xeb79,	0xeb7a,	0xcbb2,	NODEST,	NODEST,	0xf3ab,
	/* 70 */
	0xeb7b,	NODEST,	0xf3a7,	NODEST,	NODEST,	NODEST,	0xeb7c,	0xeb7d,
	/* 78 */
	NODEST,	NODEST,	0xf3ac,	0xeb7e,	0xec21,	NODEST,	0xec22,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	0xec23,	0xec24,	NODEST,	0xec25,	0xf3a9,
	/* 88 */
	NODEST,	0xf3a8,	0xec26,	NODEST,	NODEST,	0xec27,	0xec28,	0xb7dc,
	/* 90 */
	NODEST,	NODEST,	0xec29,	0xec2a,	NODEST,	0xec2b,	0xec2c,	0xec2d,
	/* 98 */
	0xec2e,	NODEST,	0xf3ad,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	0xec2f,	NODEST,	NODEST,	0xf3ae,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	0xf3af,	0xec30,	0xf3aa,	0xec31,	NODEST,	0xec32,	0xf2f4,
	/* B0 */
	NODEST,	0xec33,	0xf3b0,	NODEST,	0xc4e1,	0xec34,	NODEST,	NODEST,
	/* B8 */
	0xf3b4,	0xec35,	0xf3b5,	0xf3b3,	0xec36,	NODEST,	NODEST,	0xec37,
	/* C0 */
	NODEST,	0xf3b2,	0xf3b8,	0xec38,	0xf3b1,	NODEST,	0xf3b6,	0xec39,
	/* C8 */
	NODEST,	0xec3a,	0xec3b,	NODEST,	NODEST,	NODEST,	NODEST,	0xf3b7,
	/* D0 */
	NODEST,	NODEST,	NODEST,	0xf3ba,	0xec3c,	0xec3d,	0xec3e,	0xec3f,
	/* D8 */
	NODEST,	0xf3b9,	0xec40,	NODEST,	NODEST,	NODEST,	0xec41,	0xec42,
	/* E0 */
	0xec43,	NODEST,	NODEST,	NODEST,	NODEST,	0xec44,	0xf3bc,	0xec45,
	/* E8 */
	NODEST,	0xec46,	NODEST,	0xec47,	NODEST,	0xf3bd,	0xec48,	0xf3be,
	/* F0 */
	0xec49,	NODEST,	0xcfc9,	0xec4a,	0xec4b,	NODEST,	NODEST,	NODEST,
	/* F8 */
	0xf3bb,	0xc2eb,	0xbaed,	NODEST,	NODEST,	0xf3bf,	0xec4c,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9E[] = {
	/* 00 */
	NODEST,	NODEST,	0xec4e,	NODEST,	NODEST,	NODEST,	NODEST,	0xec4f,
	/* 08 */
	NODEST,	NODEST,	0xec4d,	NODEST,	NODEST,	NODEST,	0xec50,	NODEST,
	/* 10 */
	0xec51,	0xec52,	0xec53,	NODEST,	NODEST,	0xec54,	0xec55,	NODEST,
	/* 18 */
	NODEST,	0xec56,	0xf3c0,	0xf3c1,	0xec57,	0xec58,	0xf3c2,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xf3c3,	NODEST,	NODEST,
	/* 78 */
	0xb8b4,	0xf3c4,	0xec59,	0xec5a,	0xec5b,	0xf3c5,	NODEST,	0xbcaf,
	/* 80 */
	0xec5c,	0xf3c6,	0xec5d,	0xec5e,	0xec5f,	0xec60,	NODEST,	0xec61,
	/* 88 */
	0xf3c7,	NODEST,	NODEST,	0xf3c8,	0xf3c9,	NODEST,	0xec62,	0xec63,
	/* 90 */
	NODEST,	0xf3cc,	0xf3ca,	0xcfbc,	NODEST,	0xf3cb,	0xec64,	0xceef,
	/* 98 */
	0xec65,	NODEST,	NODEST,	0xec66,	NODEST,	0xf3cd,	0xec67,	0xcedb,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xec68,	0xf3ce,	0xc7fe,	NODEST,
	/* A8 */
	0xec69,	0xf3cf,	0xf3d1,	NODEST,	0xec6a,	0xf3d2,	0xec6b,	0xec6c,
	/* B0 */
	0xec6d,	NODEST,	NODEST,	0xec6e,	0xec6f,	0xec70,	NODEST,	NODEST,
	/* B8 */
	0xf3d0,	0xb9ed,	0xcccd,	0xcbe3,	0xd6f7,	NODEST,	0xdde0,	0xcbfb,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xb2ab,	NODEST,	0xec71,	NODEST,
	/* C8 */
	0xec72,	NODEST,	NODEST,	0xec73,	0xf3d4,	0xb5d0,	0xf3d5,	0xf3d6,
	/* D0 */
	0xf3d7,	0xf47e,	0xb9f5,	NODEST,	0xf3d8,	0xec74,	NODEST,	NODEST,
	/* D8 */
	0xe0d4,	0xccdb,	NODEST,	0xc2e3,	0xf3d9,	0xf3db,	0xf3da,	0xec75,
	/* E0 */
	0xf3dc,	NODEST,	NODEST,	NODEST,	0xec76,	0xf3dd,	NODEST,	0xec77,
	/* E8 */
	0xf3de,	NODEST,	NODEST,	NODEST,	0xec78,	0xec79,	0xec7a,	0xf3df,
	/* F0 */
	0xec7b,	0xec7c,	0xec7d,	NODEST,	0xf3e0,	0xec7e,	0xf3e1,	0xf3e2,
	/* F8 */
	0xed21,	0xf3e3,	NODEST,	0xf3e4,	0xf3e5,	0xf3e6,	NODEST,	0xed22,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_9F[] = {
	/* 00 */
	NODEST,	NODEST,	0xed23,	0xed24,	NODEST,	NODEST,	NODEST,	0xf3e7,
	/* 08 */
	0xf3e8,	0xed25,	NODEST,	NODEST,	NODEST,	NODEST,	0xc5a4,	0xed26,
	/* 10 */
	0xed27,	0xed28,	0xed29,	0xb8dd,	0xed2a,	0xf3ea,	0xed2b,	0xed2c,
	/* 18 */
	NODEST,	0xed2d,	0xed2e,	0xed2f,	NODEST,	NODEST,	NODEST,	0xed30,
	/* 20 */
	0xc1cd,	0xf3eb,	0xed31,	NODEST,	NODEST,	NODEST,	0xed32,	NODEST,
	/* 28 */
	NODEST,	NODEST,	0xed33,	0xed34,	0xf3ec,	NODEST,	NODEST,	0xed35,
	/* 30 */
	NODEST,	0xed36,	0xed37,	NODEST,	0xed38,	NODEST,	NODEST,	0xed39,
	/* 38 */
	NODEST,	0xed3a,	0xed3b,	0xc9a1,	0xed3c,	0xed3d,	0xf3ed,	0xed3e,
	/* 40 */
	NODEST,	0xed3f,	NODEST,	0xed40,	0xed41,	0xed42,	0xed43,	0xed44,
	/* 48 */
	NODEST,	NODEST,	0xf3ee,	0xe3b7,	NODEST,	NODEST,	0xecda,	0xf0ed,
	/* 50 */
	NODEST,	NODEST,	0xf3ef,	0xed45,	0xf3f0,	0xed46,	0xed47,	0xed48,
	/* 58 */
	0xed49,	NODEST,	0xed4a,	NODEST,	NODEST,	0xed4b,	0xed4c,	0xf3f2,
	/* 60 */
	0xf3f3,	0xf3f4,	0xcef0,	0xf3f1,	NODEST,	NODEST,	0xf3f5,	0xf3f6,
	/* 68 */
	0xed4d,	0xed4e,	0xf3f8,	NODEST,	0xf3f7,	0xed4f,	0xed50,	0xed51,
	/* 70 */
	0xed52,	0xed53,	0xf3fa,	0xed54,	NODEST,	0xed55,	0xf3fb,	0xf3f9,
	/* 78 */
	NODEST,	NODEST,	0xed56,	NODEST,	NODEST,	0xed57,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xceb6,	NODEST,	0xed58,
	/* 90 */
	0xed59,	0xed5a,	0xed5b,	NODEST,	0xed5c,	0xf3fc,	0xed5d,	0xed5e,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xf3fd,	0xe3d4,	0xed5f,	NODEST,
	/* A0 */
	0xf3fe,	0xed60,	0xed61,	0xed62,	NODEST,	0xed63,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E0[] = {
	/* 00 */
	0xf5a1,	0xf5a2,	0xf5a3,	0xf5a4,	0xf5a5,	0xf5a6,	0xf5a7,	0xf5a8,
	/* 08 */
	0xf5a9,	0xf5aa,	0xf5ab,	0xf5ac,	0xf5ad,	0xf5ae,	0xf5af,	0xf5b0,
	/* 10 */
	0xf5b1,	0xf5b2,	0xf5b3,	0xf5b4,	0xf5b5,	0xf5b6,	0xf5b7,	0xf5b8,
	/* 18 */
	0xf5b9,	0xf5ba,	0xf5bb,	0xf5bc,	0xf5bd,	0xf5be,	0xf5bf,	0xf5c0,
	/* 20 */
	0xf5c1,	0xf5c2,	0xf5c3,	0xf5c4,	0xf5c5,	0xf5c6,	0xf5c7,	0xf5c8,
	/* 28 */
	0xf5c9,	0xf5ca,	0xf5cb,	0xf5cc,	0xf5cd,	0xf5ce,	0xf5cf,	0xf5d0,
	/* 30 */
	0xf5d1,	0xf5d2,	0xf5d3,	0xf5d4,	0xf5d5,	0xf5d6,	0xf5d7,	0xf5d8,
	/* 38 */
	0xf5d9,	0xf5da,	0xf5db,	0xf5dc,	0xf5dd,	0xf5de,	0xf5df,	0xf5e0,
	/* 40 */
	0xf5e1,	0xf5e2,	0xf5e3,	0xf5e4,	0xf5e5,	0xf5e6,	0xf5e7,	0xf5e8,
	/* 48 */
	0xf5e9,	0xf5ea,	0xf5eb,	0xf5ec,	0xf5ed,	0xf5ee,	0xf5ef,	0xf5f0,
	/* 50 */
	0xf5f1,	0xf5f2,	0xf5f3,	0xf5f4,	0xf5f5,	0xf5f6,	0xf5f7,	0xf5f8,
	/* 58 */
	0xf5f9,	0xf5fa,	0xf5fb,	0xf5fc,	0xf5fd,	0xf5fe,	0xf6a1,	0xf6a2,
	/* 60 */
	0xf6a3,	0xf6a4,	0xf6a5,	0xf6a6,	0xf6a7,	0xf6a8,	0xf6a9,	0xf6aa,
	/* 68 */
	0xf6ab,	0xf6ac,	0xf6ad,	0xf6ae,	0xf6af,	0xf6b0,	0xf6b1,	0xf6b2,
	/* 70 */
	0xf6b3,	0xf6b4,	0xf6b5,	0xf6b6,	0xf6b7,	0xf6b8,	0xf6b9,	0xf6ba,
	/* 78 */
	0xf6bb,	0xf6bc,	0xf6bd,	0xf6be,	0xf6bf,	0xf6c0,	0xf6c1,	0xf6c2,
	/* 80 */
	0xf6c3,	0xf6c4,	0xf6c5,	0xf6c6,	0xf6c7,	0xf6c8,	0xf6c9,	0xf6ca,
	/* 88 */
	0xf6cb,	0xf6cc,	0xf6cd,	0xf6ce,	0xf6cf,	0xf6d0,	0xf6d1,	0xf6d2,
	/* 90 */
	0xf6d3,	0xf6d4,	0xf6d5,	0xf6d6,	0xf6d7,	0xf6d8,	0xf6d9,	0xf6da,
	/* 98 */
	0xf6db,	0xf6dc,	0xf6dd,	0xf6de,	0xf6df,	0xf6e0,	0xf6e1,	0xf6e2,
	/* A0 */
	0xf6e3,	0xf6e4,	0xf6e5,	0xf6e6,	0xf6e7,	0xf6e8,	0xf6e9,	0xf6ea,
	/* A8 */
	0xf6eb,	0xf6ec,	0xf6ed,	0xf6ee,	0xf6ef,	0xf6f0,	0xf6f1,	0xf6f2,
	/* B0 */
	0xf6f3,	0xf6f4,	0xf6f5,	0xf6f6,	0xf6f7,	0xf6f8,	0xf6f9,	0xf6fa,
	/* B8 */
	0xf6fb,	0xf6fc,	0xf6fd,	0xf6fe,	0xf7a1,	0xf7a2,	0xf7a3,	0xf7a4,
	/* C0 */
	0xf7a5,	0xf7a6,	0xf7a7,	0xf7a8,	0xf7a9,	0xf7aa,	0xf7ab,	0xf7ac,
	/* C8 */
	0xf7ad,	0xf7ae,	0xf7af,	0xf7b0,	0xf7b1,	0xf7b2,	0xf7b3,	0xf7b4,
	/* D0 */
	0xf7b5,	0xf7b6,	0xf7b7,	0xf7b8,	0xf7b9,	0xf7ba,	0xf7bb,	0xf7bc,
	/* D8 */
	0xf7bd,	0xf7be,	0xf7bf,	0xf7c0,	0xf7c1,	0xf7c2,	0xf7c3,	0xf7c4,
	/* E0 */
	0xf7c5,	0xf7c6,	0xf7c7,	0xf7c8,	0xf7c9,	0xf7ca,	0xf7cb,	0xf7cc,
	/* E8 */
	0xf7cd,	0xf7ce,	0xf7cf,	0xf7d0,	0xf7d1,	0xf7d2,	0xf7d3,	0xf7d4,
	/* F0 */
	0xf7d5,	0xf7d6,	0xf7d7,	0xf7d8,	0xf7d9,	0xf7da,	0xf7db,	0xf7dc,
	/* F8 */
	0xf7dd,	0xf7de,	0xf7df,	0xf7e0,	0xf7e1,	0xf7e2,	0xf7e3,	0xf7e4,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E1[] = {
	/* 00 */
	0xf7e5,	0xf7e6,	0xf7e7,	0xf7e8,	0xf7e9,	0xf7ea,	0xf7eb,	0xf7ec,
	/* 08 */
	0xf7ed,	0xf7ee,	0xf7ef,	0xf7f0,	0xf7f1,	0xf7f2,	0xf7f3,	0xf7f4,
	/* 10 */
	0xf7f5,	0xf7f6,	0xf7f7,	0xf7f8,	0xf7f9,	0xf7fa,	0xf7fb,	0xf7fc,
	/* 18 */
	0xf7fd,	0xf7fe,	0xf8a1,	0xf8a2,	0xf8a3,	0xf8a4,	0xf8a5,	0xf8a6,
	/* 20 */
	0xf8a7,	0xf8a8,	0xf8a9,	0xf8aa,	0xf8ab,	0xf8ac,	0xf8ad,	0xf8ae,
	/* 28 */
	0xf8af,	0xf8b0,	0xf8b1,	0xf8b2,	0xf8b3,	0xf8b4,	0xf8b5,	0xf8b6,
	/* 30 */
	0xf8b7,	0xf8b8,	0xf8b9,	0xf8ba,	0xf8bb,	0xf8bc,	0xf8bd,	0xf8be,
	/* 38 */
	0xf8bf,	0xf8c0,	0xf8c1,	0xf8c2,	0xf8c3,	0xf8c4,	0xf8c5,	0xf8c6,
	/* 40 */
	0xf8c7,	0xf8c8,	0xf8c9,	0xf8ca,	0xf8cb,	0xf8cc,	0xf8cd,	0xf8ce,
	/* 48 */
	0xf8cf,	0xf8d0,	0xf8d1,	0xf8d2,	0xf8d3,	0xf8d4,	0xf8d5,	0xf8d6,
	/* 50 */
	0xf8d7,	0xf8d8,	0xf8d9,	0xf8da,	0xf8db,	0xf8dc,	0xf8dd,	0xf8de,
	/* 58 */
	0xf8df,	0xf8e0,	0xf8e1,	0xf8e2,	0xf8e3,	0xf8e4,	0xf8e5,	0xf8e6,
	/* 60 */
	0xf8e7,	0xf8e8,	0xf8e9,	0xf8ea,	0xf8eb,	0xf8ec,	0xf8ed,	0xf8ee,
	/* 68 */
	0xf8ef,	0xf8f0,	0xf8f1,	0xf8f2,	0xf8f3,	0xf8f4,	0xf8f5,	0xf8f6,
	/* 70 */
	0xf8f7,	0xf8f8,	0xf8f9,	0xf8fa,	0xf8fb,	0xf8fc,	0xf8fd,	0xf8fe,
	/* 78 */
	0xf9a1,	0xf9a2,	0xf9a3,	0xf9a4,	0xf9a5,	0xf9a6,	0xf9a7,	0xf9a8,
	/* 80 */
	0xf9a9,	0xf9aa,	0xf9ab,	0xf9ac,	0xf9ad,	0xf9ae,	0xf9af,	0xf9b0,
	/* 88 */
	0xf9b1,	0xf9b2,	0xf9b3,	0xf9b4,	0xf9b5,	0xf9b6,	0xf9b7,	0xf9b8,
	/* 90 */
	0xf9b9,	0xf9ba,	0xf9bb,	0xf9bc,	0xf9bd,	0xf9be,	0xf9bf,	0xf9c0,
	/* 98 */
	0xf9c1,	0xf9c2,	0xf9c3,	0xf9c4,	0xf9c5,	0xf9c6,	0xf9c7,	0xf9c8,
	/* A0 */
	0xf9c9,	0xf9ca,	0xf9cb,	0xf9cc,	0xf9cd,	0xf9ce,	0xf9cf,	0xf9d0,
	/* A8 */
	0xf9d1,	0xf9d2,	0xf9d3,	0xf9d4,	0xf9d5,	0xf9d6,	0xf9d7,	0xf9d8,
	/* B0 */
	0xf9d9,	0xf9da,	0xf9db,	0xf9dc,	0xf9dd,	0xf9de,	0xf9df,	0xf9e0,
	/* B8 */
	0xf9e1,	0xf9e2,	0xf9e3,	0xf9e4,	0xf9e5,	0xf9e6,	0xf9e7,	0xf9e8,
	/* C0 */
	0xf9e9,	0xf9ea,	0xf9eb,	0xf9ec,	0xf9ed,	0xf9ee,	0xf9ef,	0xf9f0,
	/* C8 */
	0xf9f1,	0xf9f2,	0xf9f3,	0xf9f4,	0xf9f5,	0xf9f6,	0xf9f7,	0xf9f8,
	/* D0 */
	0xf9f9,	0xf9fa,	0xf9fb,	0xf9fc,	0xf9fd,	0xf9fe,	0xfaa1,	0xfaa2,
	/* D8 */
	0xfaa3,	0xfaa4,	0xfaa5,	0xfaa6,	0xfaa7,	0xfaa8,	0xfaa9,	0xfaaa,
	/* E0 */
	0xfaab,	0xfaac,	0xfaad,	0xfaae,	0xfaaf,	0xfab0,	0xfab1,	0xfab2,
	/* E8 */
	0xfab3,	0xfab4,	0xfab5,	0xfab6,	0xfab7,	0xfab8,	0xfab9,	0xfaba,
	/* F0 */
	0xfabb,	0xfabc,	0xfabd,	0xfabe,	0xfabf,	0xfac0,	0xfac1,	0xfac2,
	/* F8 */
	0xfac3,	0xfac4,	0xfac5,	0xfac6,	0xfac7,	0xfac8,	0xfac9,	0xfaca,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E2[] = {
	/* 00 */
	0xfacb,	0xfacc,	0xfacd,	0xface,	0xfacf,	0xfad0,	0xfad1,	0xfad2,
	/* 08 */
	0xfad3,	0xfad4,	0xfad5,	0xfad6,	0xfad7,	0xfad8,	0xfad9,	0xfada,
	/* 10 */
	0xfadb,	0xfadc,	0xfadd,	0xfade,	0xfadf,	0xfae0,	0xfae1,	0xfae2,
	/* 18 */
	0xfae3,	0xfae4,	0xfae5,	0xfae6,	0xfae7,	0xfae8,	0xfae9,	0xfaea,
	/* 20 */
	0xfaeb,	0xfaec,	0xfaed,	0xfaee,	0xfaef,	0xfaf0,	0xfaf1,	0xfaf2,
	/* 28 */
	0xfaf3,	0xfaf4,	0xfaf5,	0xfaf6,	0xfaf7,	0xfaf8,	0xfaf9,	0xfafa,
	/* 30 */
	0xfafb,	0xfafc,	0xfafd,	0xfafe,	0xfba1,	0xfba2,	0xfba3,	0xfba4,
	/* 38 */
	0xfba5,	0xfba6,	0xfba7,	0xfba8,	0xfba9,	0xfbaa,	0xfbab,	0xfbac,
	/* 40 */
	0xfbad,	0xfbae,	0xfbaf,	0xfbb0,	0xfbb1,	0xfbb2,	0xfbb3,	0xfbb4,
	/* 48 */
	0xfbb5,	0xfbb6,	0xfbb7,	0xfbb8,	0xfbb9,	0xfbba,	0xfbbb,	0xfbbc,
	/* 50 */
	0xfbbd,	0xfbbe,	0xfbbf,	0xfbc0,	0xfbc1,	0xfbc2,	0xfbc3,	0xfbc4,
	/* 58 */
	0xfbc5,	0xfbc6,	0xfbc7,	0xfbc8,	0xfbc9,	0xfbca,	0xfbcb,	0xfbcc,
	/* 60 */
	0xfbcd,	0xfbce,	0xfbcf,	0xfbd0,	0xfbd1,	0xfbd2,	0xfbd3,	0xfbd4,
	/* 68 */
	0xfbd5,	0xfbd6,	0xfbd7,	0xfbd8,	0xfbd9,	0xfbda,	0xfbdb,	0xfbdc,
	/* 70 */
	0xfbdd,	0xfbde,	0xfbdf,	0xfbe0,	0xfbe1,	0xfbe2,	0xfbe3,	0xfbe4,
	/* 78 */
	0xfbe5,	0xfbe6,	0xfbe7,	0xfbe8,	0xfbe9,	0xfbea,	0xfbeb,	0xfbec,
	/* 80 */
	0xfbed,	0xfbee,	0xfbef,	0xfbf0,	0xfbf1,	0xfbf2,	0xfbf3,	0xfbf4,
	/* 88 */
	0xfbf5,	0xfbf6,	0xfbf7,	0xfbf8,	0xfbf9,	0xfbfa,	0xfbfb,	0xfbfc,
	/* 90 */
	0xfbfd,	0xfbfe,	0xfca1,	0xfca2,	0xfca3,	0xfca4,	0xfca5,	0xfca6,
	/* 98 */
	0xfca7,	0xfca8,	0xfca9,	0xfcaa,	0xfcab,	0xfcac,	0xfcad,	0xfcae,
	/* A0 */
	0xfcaf,	0xfcb0,	0xfcb1,	0xfcb2,	0xfcb3,	0xfcb4,	0xfcb5,	0xfcb6,
	/* A8 */
	0xfcb7,	0xfcb8,	0xfcb9,	0xfcba,	0xfcbb,	0xfcbc,	0xfcbd,	0xfcbe,
	/* B0 */
	0xfcbf,	0xfcc0,	0xfcc1,	0xfcc2,	0xfcc3,	0xfcc4,	0xfcc5,	0xfcc6,
	/* B8 */
	0xfcc7,	0xfcc8,	0xfcc9,	0xfcca,	0xfccb,	0xfccc,	0xfccd,	0xfcce,
	/* C0 */
	0xfccf,	0xfcd0,	0xfcd1,	0xfcd2,	0xfcd3,	0xfcd4,	0xfcd5,	0xfcd6,
	/* C8 */
	0xfcd7,	0xfcd8,	0xfcd9,	0xfcda,	0xfcdb,	0xfcdc,	0xfcdd,	0xfcde,
	/* D0 */
	0xfcdf,	0xfce0,	0xfce1,	0xfce2,	0xfce3,	0xfce4,	0xfce5,	0xfce6,
	/* D8 */
	0xfce7,	0xfce8,	0xfce9,	0xfcea,	0xfceb,	0xfcec,	0xfced,	0xfcee,
	/* E0 */
	0xfcef,	0xfcf0,	0xfcf1,	0xfcf2,	0xfcf3,	0xfcf4,	0xfcf5,	0xfcf6,
	/* E8 */
	0xfcf7,	0xfcf8,	0xfcf9,	0xfcfa,	0xfcfb,	0xfcfc,	0xfcfd,	0xfcfe,
	/* F0 */
	0xfda1,	0xfda2,	0xfda3,	0xfda4,	0xfda5,	0xfda6,	0xfda7,	0xfda8,
	/* F8 */
	0xfda9,	0xfdaa,	0xfdab,	0xfdac,	0xfdad,	0xfdae,	0xfdaf,	0xfdb0,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E3[] = {
	/* 00 */
	0xfdb1,	0xfdb2,	0xfdb3,	0xfdb4,	0xfdb5,	0xfdb6,	0xfdb7,	0xfdb8,
	/* 08 */
	0xfdb9,	0xfdba,	0xfdbb,	0xfdbc,	0xfdbd,	0xfdbe,	0xfdbf,	0xfdc0,
	/* 10 */
	0xfdc1,	0xfdc2,	0xfdc3,	0xfdc4,	0xfdc5,	0xfdc6,	0xfdc7,	0xfdc8,
	/* 18 */
	0xfdc9,	0xfdca,	0xfdcb,	0xfdcc,	0xfdcd,	0xfdce,	0xfdcf,	0xfdd0,
	/* 20 */
	0xfdd1,	0xfdd2,	0xfdd3,	0xfdd4,	0xfdd5,	0xfdd6,	0xfdd7,	0xfdd8,
	/* 28 */
	0xfdd9,	0xfdda,	0xfddb,	0xfddc,	0xfddd,	0xfdde,	0xfddf,	0xfde0,
	/* 30 */
	0xfde1,	0xfde2,	0xfde3,	0xfde4,	0xfde5,	0xfde6,	0xfde7,	0xfde8,
	/* 38 */
	0xfde9,	0xfdea,	0xfdeb,	0xfdec,	0xfded,	0xfdee,	0xfdef,	0xfdf0,
	/* 40 */
	0xfdf1,	0xfdf2,	0xfdf3,	0xfdf4,	0xfdf5,	0xfdf6,	0xfdf7,	0xfdf8,
	/* 48 */
	0xfdf9,	0xfdfa,	0xfdfb,	0xfdfc,	0xfdfd,	0xfdfe,	0xfea1,	0xfea2,
	/* 50 */
	0xfea3,	0xfea4,	0xfea5,	0xfea6,	0xfea7,	0xfea8,	0xfea9,	0xfeaa,
	/* 58 */
	0xfeab,	0xfeac,	0xfead,	0xfeae,	0xfeaf,	0xfeb0,	0xfeb1,	0xfeb2,
	/* 60 */
	0xfeb3,	0xfeb4,	0xfeb5,	0xfeb6,	0xfeb7,	0xfeb8,	0xfeb9,	0xfeba,
	/* 68 */
	0xfebb,	0xfebc,	0xfebd,	0xfebe,	0xfebf,	0xfec0,	0xfec1,	0xfec2,
	/* 70 */
	0xfec3,	0xfec4,	0xfec5,	0xfec6,	0xfec7,	0xfec8,	0xfec9,	0xfeca,
	/* 78 */
	0xfecb,	0xfecc,	0xfecd,	0xfece,	0xfecf,	0xfed0,	0xfed1,	0xfed2,
	/* 80 */
	0xfed3,	0xfed4,	0xfed5,	0xfed6,	0xfed7,	0xfed8,	0xfed9,	0xfeda,
	/* 88 */
	0xfedb,	0xfedc,	0xfedd,	0xfede,	0xfedf,	0xfee0,	0xfee1,	0xfee2,
	/* 90 */
	0xfee3,	0xfee4,	0xfee5,	0xfee6,	0xfee7,	0xfee8,	0xfee9,	0xfeea,
	/* 98 */
	0xfeeb,	0xfeec,	0xfeed,	0xfeee,	0xfeef,	0xfef0,	0xfef1,	0xfef2,
	/* A0 */
	0xfef3,	0xfef4,	0xfef5,	0xfef6,	0xfef7,	0xfef8,	0xfef9,	0xfefa,
	/* A8 */
	0xfefb,	0xfefc,	0xfefd,	0xfefe,	0xf521,	0xf522,	0xf523,	0xf524,
	/* B0 */
	0xf525,	0xf526,	0xf527,	0xf528,	0xf529,	0xf52a,	0xf52b,	0xf52c,
	/* B8 */
	0xf52d,	0xf52e,	0xf52f,	0xf530,	0xf531,	0xf532,	0xf533,	0xf534,
	/* C0 */
	0xf535,	0xf536,	0xf537,	0xf538,	0xf539,	0xf53a,	0xf53b,	0xf53c,
	/* C8 */
	0xf53d,	0xf53e,	0xf53f,	0xf540,	0xf541,	0xf542,	0xf543,	0xf544,
	/* D0 */
	0xf545,	0xf546,	0xf547,	0xf548,	0xf549,	0xf54a,	0xf54b,	0xf54c,
	/* D8 */
	0xf54d,	0xf54e,	0xf54f,	0xf550,	0xf551,	0xf552,	0xf553,	0xf554,
	/* E0 */
	0xf555,	0xf556,	0xf557,	0xf558,	0xf559,	0xf55a,	0xf55b,	0xf55c,
	/* E8 */
	0xf55d,	0xf55e,	0xf55f,	0xf560,	0xf561,	0xf562,	0xf563,	0xf564,
	/* F0 */
	0xf565,	0xf566,	0xf567,	0xf568,	0xf569,	0xf56a,	0xf56b,	0xf56c,
	/* F8 */
	0xf56d,	0xf56e,	0xf56f,	0xf570,	0xf571,	0xf572,	0xf573,	0xf574,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E4[] = {
	/* 00 */
	0xf575,	0xf576,	0xf577,	0xf578,	0xf579,	0xf57a,	0xf57b,	0xf57c,
	/* 08 */
	0xf57d,	0xf57e,	0xf621,	0xf622,	0xf623,	0xf624,	0xf625,	0xf626,
	/* 10 */
	0xf627,	0xf628,	0xf629,	0xf62a,	0xf62b,	0xf62c,	0xf62d,	0xf62e,
	/* 18 */
	0xf62f,	0xf630,	0xf631,	0xf632,	0xf633,	0xf634,	0xf635,	0xf636,
	/* 20 */
	0xf637,	0xf638,	0xf639,	0xf63a,	0xf63b,	0xf63c,	0xf63d,	0xf63e,
	/* 28 */
	0xf63f,	0xf640,	0xf641,	0xf642,	0xf643,	0xf644,	0xf645,	0xf646,
	/* 30 */
	0xf647,	0xf648,	0xf649,	0xf64a,	0xf64b,	0xf64c,	0xf64d,	0xf64e,
	/* 38 */
	0xf64f,	0xf650,	0xf651,	0xf652,	0xf653,	0xf654,	0xf655,	0xf656,
	/* 40 */
	0xf657,	0xf658,	0xf659,	0xf65a,	0xf65b,	0xf65c,	0xf65d,	0xf65e,
	/* 48 */
	0xf65f,	0xf660,	0xf661,	0xf662,	0xf663,	0xf664,	0xf665,	0xf666,
	/* 50 */
	0xf667,	0xf668,	0xf669,	0xf66a,	0xf66b,	0xf66c,	0xf66d,	0xf66e,
	/* 58 */
	0xf66f,	0xf670,	0xf671,	0xf672,	0xf673,	0xf674,	0xf675,	0xf676,
	/* 60 */
	0xf677,	0xf678,	0xf679,	0xf67a,	0xf67b,	0xf67c,	0xf67d,	0xf67e,
	/* 68 */
	0xf721,	0xf722,	0xf723,	0xf724,	0xf725,	0xf726,	0xf727,	0xf728,
	/* 70 */
	0xf729,	0xf72a,	0xf72b,	0xf72c,	0xf72d,	0xf72e,	0xf72f,	0xf730,
	/* 78 */
	0xf731,	0xf732,	0xf733,	0xf734,	0xf735,	0xf736,	0xf737,	0xf738,
	/* 80 */
	0xf739,	0xf73a,	0xf73b,	0xf73c,	0xf73d,	0xf73e,	0xf73f,	0xf740,
	/* 88 */
	0xf741,	0xf742,	0xf743,	0xf744,	0xf745,	0xf746,	0xf747,	0xf748,
	/* 90 */
	0xf749,	0xf74a,	0xf74b,	0xf74c,	0xf74d,	0xf74e,	0xf74f,	0xf750,
	/* 98 */
	0xf751,	0xf752,	0xf753,	0xf754,	0xf755,	0xf756,	0xf757,	0xf758,
	/* A0 */
	0xf759,	0xf75a,	0xf75b,	0xf75c,	0xf75d,	0xf75e,	0xf75f,	0xf760,
	/* A8 */
	0xf761,	0xf762,	0xf763,	0xf764,	0xf765,	0xf766,	0xf767,	0xf768,
	/* B0 */
	0xf769,	0xf76a,	0xf76b,	0xf76c,	0xf76d,	0xf76e,	0xf76f,	0xf770,
	/* B8 */
	0xf771,	0xf772,	0xf773,	0xf774,	0xf775,	0xf776,	0xf777,	0xf778,
	/* C0 */
	0xf779,	0xf77a,	0xf77b,	0xf77c,	0xf77d,	0xf77e,	0xf821,	0xf822,
	/* C8 */
	0xf823,	0xf824,	0xf825,	0xf826,	0xf827,	0xf828,	0xf829,	0xf82a,
	/* D0 */
	0xf82b,	0xf82c,	0xf82d,	0xf82e,	0xf82f,	0xf830,	0xf831,	0xf832,
	/* D8 */
	0xf833,	0xf834,	0xf835,	0xf836,	0xf837,	0xf838,	0xf839,	0xf83a,
	/* E0 */
	0xf83b,	0xf83c,	0xf83d,	0xf83e,	0xf83f,	0xf840,	0xf841,	0xf842,
	/* E8 */
	0xf843,	0xf844,	0xf845,	0xf846,	0xf847,	0xf848,	0xf849,	0xf84a,
	/* F0 */
	0xf84b,	0xf84c,	0xf84d,	0xf84e,	0xf84f,	0xf850,	0xf851,	0xf852,
	/* F8 */
	0xf853,	0xf854,	0xf855,	0xf856,	0xf857,	0xf858,	0xf859,	0xf85a,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E5[] = {
	/* 00 */
	0xf85b,	0xf85c,	0xf85d,	0xf85e,	0xf85f,	0xf860,	0xf861,	0xf862,
	/* 08 */
	0xf863,	0xf864,	0xf865,	0xf866,	0xf867,	0xf868,	0xf869,	0xf86a,
	/* 10 */
	0xf86b,	0xf86c,	0xf86d,	0xf86e,	0xf86f,	0xf870,	0xf871,	0xf872,
	/* 18 */
	0xf873,	0xf874,	0xf875,	0xf876,	0xf877,	0xf878,	0xf879,	0xf87a,
	/* 20 */
	0xf87b,	0xf87c,	0xf87d,	0xf87e,	0xf921,	0xf922,	0xf923,	0xf924,
	/* 28 */
	0xf925,	0xf926,	0xf927,	0xf928,	0xf929,	0xf92a,	0xf92b,	0xf92c,
	/* 30 */
	0xf92d,	0xf92e,	0xf92f,	0xf930,	0xf931,	0xf932,	0xf933,	0xf934,
	/* 38 */
	0xf935,	0xf936,	0xf937,	0xf938,	0xf939,	0xf93a,	0xf93b,	0xf93c,
	/* 40 */
	0xf93d,	0xf93e,	0xf93f,	0xf940,	0xf941,	0xf942,	0xf943,	0xf944,
	/* 48 */
	0xf945,	0xf946,	0xf947,	0xf948,	0xf949,	0xf94a,	0xf94b,	0xf94c,
	/* 50 */
	0xf94d,	0xf94e,	0xf94f,	0xf950,	0xf951,	0xf952,	0xf953,	0xf954,
	/* 58 */
	0xf955,	0xf956,	0xf957,	0xf958,	0xf959,	0xf95a,	0xf95b,	0xf95c,
	/* 60 */
	0xf95d,	0xf95e,	0xf95f,	0xf960,	0xf961,	0xf962,	0xf963,	0xf964,
	/* 68 */
	0xf965,	0xf966,	0xf967,	0xf968,	0xf969,	0xf96a,	0xf96b,	0xf96c,
	/* 70 */
	0xf96d,	0xf96e,	0xf96f,	0xf970,	0xf971,	0xf972,	0xf973,	0xf974,
	/* 78 */
	0xf975,	0xf976,	0xf977,	0xf978,	0xf979,	0xf97a,	0xf97b,	0xf97c,
	/* 80 */
	0xf97d,	0xf97e,	0xfa21,	0xfa22,	0xfa23,	0xfa24,	0xfa25,	0xfa26,
	/* 88 */
	0xfa27,	0xfa28,	0xfa29,	0xfa2a,	0xfa2b,	0xfa2c,	0xfa2d,	0xfa2e,
	/* 90 */
	0xfa2f,	0xfa30,	0xfa31,	0xfa32,	0xfa33,	0xfa34,	0xfa35,	0xfa36,
	/* 98 */
	0xfa37,	0xfa38,	0xfa39,	0xfa3a,	0xfa3b,	0xfa3c,	0xfa3d,	0xfa3e,
	/* A0 */
	0xfa3f,	0xfa40,	0xfa41,	0xfa42,	0xfa43,	0xfa44,	0xfa45,	0xfa46,
	/* A8 */
	0xfa47,	0xfa48,	0xfa49,	0xfa4a,	0xfa4b,	0xfa4c,	0xfa4d,	0xfa4e,
	/* B0 */
	0xfa4f,	0xfa50,	0xfa51,	0xfa52,	0xfa53,	0xfa54,	0xfa55,	0xfa56,
	/* B8 */
	0xfa57,	0xfa58,	0xfa59,	0xfa5a,	0xfa5b,	0xfa5c,	0xfa5d,	0xfa5e,
	/* C0 */
	0xfa5f,	0xfa60,	0xfa61,	0xfa62,	0xfa63,	0xfa64,	0xfa65,	0xfa66,
	/* C8 */
	0xfa67,	0xfa68,	0xfa69,	0xfa6a,	0xfa6b,	0xfa6c,	0xfa6d,	0xfa6e,
	/* D0 */
	0xfa6f,	0xfa70,	0xfa71,	0xfa72,	0xfa73,	0xfa74,	0xfa75,	0xfa76,
	/* D8 */
	0xfa77,	0xfa78,	0xfa79,	0xfa7a,	0xfa7b,	0xfa7c,	0xfa7d,	0xfa7e,
	/* E0 */
	0xfb21,	0xfb22,	0xfb23,	0xfb24,	0xfb25,	0xfb26,	0xfb27,	0xfb28,
	/* E8 */
	0xfb29,	0xfb2a,	0xfb2b,	0xfb2c,	0xfb2d,	0xfb2e,	0xfb2f,	0xfb30,
	/* F0 */
	0xfb31,	0xfb32,	0xfb33,	0xfb34,	0xfb35,	0xfb36,	0xfb37,	0xfb38,
	/* F8 */
	0xfb39,	0xfb3a,	0xfb3b,	0xfb3c,	0xfb3d,	0xfb3e,	0xfb3f,	0xfb40,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E6[] = {
	/* 00 */
	0xfb41,	0xfb42,	0xfb43,	0xfb44,	0xfb45,	0xfb46,	0xfb47,	0xfb48,
	/* 08 */
	0xfb49,	0xfb4a,	0xfb4b,	0xfb4c,	0xfb4d,	0xfb4e,	0xfb4f,	0xfb50,
	/* 10 */
	0xfb51,	0xfb52,	0xfb53,	0xfb54,	0xfb55,	0xfb56,	0xfb57,	0xfb58,
	/* 18 */
	0xfb59,	0xfb5a,	0xfb5b,	0xfb5c,	0xfb5d,	0xfb5e,	0xfb5f,	0xfb60,
	/* 20 */
	0xfb61,	0xfb62,	0xfb63,	0xfb64,	0xfb65,	0xfb66,	0xfb67,	0xfb68,
	/* 28 */
	0xfb69,	0xfb6a,	0xfb6b,	0xfb6c,	0xfb6d,	0xfb6e,	0xfb6f,	0xfb70,
	/* 30 */
	0xfb71,	0xfb72,	0xfb73,	0xfb74,	0xfb75,	0xfb76,	0xfb77,	0xfb78,
	/* 38 */
	0xfb79,	0xfb7a,	0xfb7b,	0xfb7c,	0xfb7d,	0xfb7e,	0xfc21,	0xfc22,
	/* 40 */
	0xfc23,	0xfc24,	0xfc25,	0xfc26,	0xfc27,	0xfc28,	0xfc29,	0xfc2a,
	/* 48 */
	0xfc2b,	0xfc2c,	0xfc2d,	0xfc2e,	0xfc2f,	0xfc30,	0xfc31,	0xfc32,
	/* 50 */
	0xfc33,	0xfc34,	0xfc35,	0xfc36,	0xfc37,	0xfc38,	0xfc39,	0xfc3a,
	/* 58 */
	0xfc3b,	0xfc3c,	0xfc3d,	0xfc3e,	0xfc3f,	0xfc40,	0xfc41,	0xfc42,
	/* 60 */
	0xfc43,	0xfc44,	0xfc45,	0xfc46,	0xfc47,	0xfc48,	0xfc49,	0xfc4a,
	/* 68 */
	0xfc4b,	0xfc4c,	0xfc4d,	0xfc4e,	0xfc4f,	0xfc50,	0xfc51,	0xfc52,
	/* 70 */
	0xfc53,	0xfc54,	0xfc55,	0xfc56,	0xfc57,	0xfc58,	0xfc59,	0xfc5a,
	/* 78 */
	0xfc5b,	0xfc5c,	0xfc5d,	0xfc5e,	0xfc5f,	0xfc60,	0xfc61,	0xfc62,
	/* 80 */
	0xfc63,	0xfc64,	0xfc65,	0xfc66,	0xfc67,	0xfc68,	0xfc69,	0xfc6a,
	/* 88 */
	0xfc6b,	0xfc6c,	0xfc6d,	0xfc6e,	0xfc6f,	0xfc70,	0xfc71,	0xfc72,
	/* 90 */
	0xfc73,	0xfc74,	0xfc75,	0xfc76,	0xfc77,	0xfc78,	0xfc79,	0xfc7a,
	/* 98 */
	0xfc7b,	0xfc7c,	0xfc7d,	0xfc7e,	0xfd21,	0xfd22,	0xfd23,	0xfd24,
	/* A0 */
	0xfd25,	0xfd26,	0xfd27,	0xfd28,	0xfd29,	0xfd2a,	0xfd2b,	0xfd2c,
	/* A8 */
	0xfd2d,	0xfd2e,	0xfd2f,	0xfd30,	0xfd31,	0xfd32,	0xfd33,	0xfd34,
	/* B0 */
	0xfd35,	0xfd36,	0xfd37,	0xfd38,	0xfd39,	0xfd3a,	0xfd3b,	0xfd3c,
	/* B8 */
	0xfd3d,	0xfd3e,	0xfd3f,	0xfd40,	0xfd41,	0xfd42,	0xfd43,	0xfd44,
	/* C0 */
	0xfd45,	0xfd46,	0xfd47,	0xfd48,	0xfd49,	0xfd4a,	0xfd4b,	0xfd4c,
	/* C8 */
	0xfd4d,	0xfd4e,	0xfd4f,	0xfd50,	0xfd51,	0xfd52,	0xfd53,	0xfd54,
	/* D0 */
	0xfd55,	0xfd56,	0xfd57,	0xfd58,	0xfd59,	0xfd5a,	0xfd5b,	0xfd5c,
	/* D8 */
	0xfd5d,	0xfd5e,	0xfd5f,	0xfd60,	0xfd61,	0xfd62,	0xfd63,	0xfd64,
	/* E0 */
	0xfd65,	0xfd66,	0xfd67,	0xfd68,	0xfd69,	0xfd6a,	0xfd6b,	0xfd6c,
	/* E8 */
	0xfd6d,	0xfd6e,	0xfd6f,	0xfd70,	0xfd71,	0xfd72,	0xfd73,	0xfd74,
	/* F0 */
	0xfd75,	0xfd76,	0xfd77,	0xfd78,	0xfd79,	0xfd7a,	0xfd7b,	0xfd7c,
	/* F8 */
	0xfd7d,	0xfd7e,	0xfe21,	0xfe22,	0xfe23,	0xfe24,	0xfe25,	0xfe26,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_E7[] = {
	/* 00 */
	0xfe27,	0xfe28,	0xfe29,	0xfe2a,	0xfe2b,	0xfe2c,	0xfe2d,	0xfe2e,
	/* 08 */
	0xfe2f,	0xfe30,	0xfe31,	0xfe32,	0xfe33,	0xfe34,	0xfe35,	0xfe36,
	/* 10 */
	0xfe37,	0xfe38,	0xfe39,	0xfe3a,	0xfe3b,	0xfe3c,	0xfe3d,	0xfe3e,
	/* 18 */
	0xfe3f,	0xfe40,	0xfe41,	0xfe42,	0xfe43,	0xfe44,	0xfe45,	0xfe46,
	/* 20 */
	0xfe47,	0xfe48,	0xfe49,	0xfe4a,	0xfe4b,	0xfe4c,	0xfe4d,	0xfe4e,
	/* 28 */
	0xfe4f,	0xfe50,	0xfe51,	0xfe52,	0xfe53,	0xfe54,	0xfe55,	0xfe56,
	/* 30 */
	0xfe57,	0xfe58,	0xfe59,	0xfe5a,	0xfe5b,	0xfe5c,	0xfe5d,	0xfe5e,
	/* 38 */
	0xfe5f,	0xfe60,	0xfe61,	0xfe62,	0xfe63,	0xfe64,	0xfe65,	0xfe66,
	/* 40 */
	0xfe67,	0xfe68,	0xfe69,	0xfe6a,	0xfe6b,	0xfe6c,	0xfe6d,	0xfe6e,
	/* 48 */
	0xfe6f,	0xfe70,	0xfe71,	0xfe72,	0xfe73,	0xfe74,	0xfe75,	0xfe76,
	/* 50 */
	0xfe77,	0xfe78,	0xfe79,	0xfe7a,	0xfe7b,	0xfe7c,	0xfe7d,	0xfe7e,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_F9[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 18 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 20 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 28 */
	NODEST,	0xf445,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	0xf472,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_FA[] = {
	/* 00 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xf434,	0xf437,
	/* 10 */
	0xf438,	0xf43d,	0xf444,	0xf447,	0xf448,	0xf44e,	0xf44f,	0xf453,
	/* 18 */
	0xf455,	0xf456,	0xf457,	0xf458,	0xf45a,	0xf45b,	0xf45e,	0xf460,
	/* 20 */
	0xf462,	0xf463,	0xf465,	0xf469,	0xf46a,	0xf46b,	0xf46d,	0xf46f,
	/* 28 */
	0xf470,	0xf473,	0xf477,	0xf478,	0xf479,	0xf47d,	NODEST,	NODEST,
	/* 30 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 38 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 40 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 50 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 58 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 60 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 68 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 70 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 88 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 90 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 98 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t kiconv_ja_ucs2_to_euc16_block_FF[] = {
	/* 00 */
	NODEST,	0xa1aa,	0xf42a,	0xa1f4,	0xa1f0,	0xa1f3,	0xa1f5,	0xf429,
	/* 08 */
	0xa1ca,	0xa1cb,	0xa1f6,	0xa1dc,	0xa1a4,	NODEST,	0xa1a5,	0xa1bf,
	/* 10 */
	0xa3b0,	0xa3b1,	0xa3b2,	0xa3b3,	0xa3b4,	0xa3b5,	0xa3b6,	0xa3b7,
	/* 18 */
	0xa3b8,	0xa3b9,	0xa1a7,	0xa1a8,	0xa1e3,	0xa1e1,	0xa1e4,	0xa1a9,
	/* 20 */
	0xa1f7,	0xa3c1,	0xa3c2,	0xa3c3,	0xa3c4,	0xa3c5,	0xa3c6,	0xa3c7,
	/* 28 */
	0xa3c8,	0xa3c9,	0xa3ca,	0xa3cb,	0xa3cc,	0xa3cd,	0xa3ce,	0xa3cf,
	/* 30 */
	0xa3d0,	0xa3d1,	0xa3d2,	0xa3d3,	0xa3d4,	0xa3d5,	0xa3d6,	0xa3d7,
	/* 38 */
	0xa3d8,	0xa3d9,	0xa3da,	0xa1ce,	0xa1c0,	0xa1cf,	0xa1b0,	0xa1b2,
	/* 40 */
	0xa1ae,	0xa3e1,	0xa3e2,	0xa3e3,	0xa3e4,	0xa3e5,	0xa3e6,	0xa3e7,
	/* 48 */
	0xa3e8,	0xa3e9,	0xa3ea,	0xa3eb,	0xa3ec,	0xa3ed,	0xa3ee,	0xa3ef,
	/* 50 */
	0xa3f0,	0xa3f1,	0xa3f2,	0xa3f3,	0xa3f4,	0xa3f5,	0xa3f6,	0xa3f7,
	/* 58 */
	0xa3f8,	0xa3f9,	0xa3fa,	0xa1d0,	0xa1c3,	0xa1d1,	0xa237,	NODEST,
	/* 60 */
	NODEST,	0x00a1,	0x00a2,	0x00a3,	0x00a4,	0x00a5,	0x00a6,	0x00a7,
	/* 68 */
	0x00a8,	0x00a9,	0x00aa,	0x00ab,	0x00ac,	0x00ad,	0x00ae,	0x00af,
	/* 70 */
	0x00b0,	0x00b1,	0x00b2,	0x00b3,	0x00b4,	0x00b5,	0x00b6,	0x00b7,
	/* 78 */
	0x00b8,	0x00b9,	0x00ba,	0x00bb,	0x00bc,	0x00bd,	0x00be,	0x00bf,
	/* 80 */
	0x00c0,	0x00c1,	0x00c2,	0x00c3,	0x00c4,	0x00c5,	0x00c6,	0x00c7,
	/* 88 */
	0x00c8,	0x00c9,	0x00ca,	0x00cb,	0x00cc,	0x00cd,	0x00ce,	0x00cf,
	/* 90 */
	0x00d0,	0x00d1,	0x00d2,	0x00d3,	0x00d4,	0x00d5,	0x00d6,	0x00d7,
	/* 98 */
	0x00d8,	0x00d9,	0x00da,	0x00db,	0x00dc,	0x00dd,	0x00de,	0x00df,
	/* A0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* A8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* B8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* C8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* D8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* E0 */
	NODEST,	NODEST,	NODEST,	0xa1b1,	NODEST,	0xa1ef,	NODEST,	NODEST,
	/* E8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F0 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* F8 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
};

static const kiconv_ja_euc16_t *kiconv_ja_ucs2_to_euc16_index[] = {
	kiconv_ja_ucs2_to_euc16_block_00,
	kiconv_ja_ucs2_to_euc16_block_01,
	kiconv_ja_ucs2_to_euc16_block_02,
	kiconv_ja_ucs2_to_euc16_block_03,
	kiconv_ja_ucs2_to_euc16_block_04,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_05 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_06 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_07 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_08 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_09 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0A eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0B eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0C eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0D eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0E eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_0F eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_10 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_11 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_12 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_13 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_14 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_15 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_16 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_17 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_18 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_19 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1A eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1B eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1C eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1D eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1E eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_1F eliminated */
	kiconv_ja_ucs2_to_euc16_block_20,
	kiconv_ja_ucs2_to_euc16_block_21,
	kiconv_ja_ucs2_to_euc16_block_22,
	kiconv_ja_ucs2_to_euc16_block_23,
	kiconv_ja_ucs2_to_euc16_block_24,
	kiconv_ja_ucs2_to_euc16_block_25,
	kiconv_ja_ucs2_to_euc16_block_26,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_27 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_28 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_29 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2A eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2B eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2C eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2D eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2E eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_2F eliminated */
	kiconv_ja_ucs2_to_euc16_block_30,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_31 eliminated */
	kiconv_ja_ucs2_to_euc16_block_32,
	kiconv_ja_ucs2_to_euc16_block_33,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_34 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_35 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_36 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_37 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_38 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_39 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3A eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3B eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3C eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3D eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3E eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_3F eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_40 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_41 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_42 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_43 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_44 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_45 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_46 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_47 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_48 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_49 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_4A eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_4B eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_4C eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_4D eliminated */
	kiconv_ja_ucs2_to_euc16_block_4E,
	kiconv_ja_ucs2_to_euc16_block_4F,
	kiconv_ja_ucs2_to_euc16_block_50,
	kiconv_ja_ucs2_to_euc16_block_51,
	kiconv_ja_ucs2_to_euc16_block_52,
	kiconv_ja_ucs2_to_euc16_block_53,
	kiconv_ja_ucs2_to_euc16_block_54,
	kiconv_ja_ucs2_to_euc16_block_55,
	kiconv_ja_ucs2_to_euc16_block_56,
	kiconv_ja_ucs2_to_euc16_block_57,
	kiconv_ja_ucs2_to_euc16_block_58,
	kiconv_ja_ucs2_to_euc16_block_59,
	kiconv_ja_ucs2_to_euc16_block_5A,
	kiconv_ja_ucs2_to_euc16_block_5B,
	kiconv_ja_ucs2_to_euc16_block_5C,
	kiconv_ja_ucs2_to_euc16_block_5D,
	kiconv_ja_ucs2_to_euc16_block_5E,
	kiconv_ja_ucs2_to_euc16_block_5F,
	kiconv_ja_ucs2_to_euc16_block_60,
	kiconv_ja_ucs2_to_euc16_block_61,
	kiconv_ja_ucs2_to_euc16_block_62,
	kiconv_ja_ucs2_to_euc16_block_63,
	kiconv_ja_ucs2_to_euc16_block_64,
	kiconv_ja_ucs2_to_euc16_block_65,
	kiconv_ja_ucs2_to_euc16_block_66,
	kiconv_ja_ucs2_to_euc16_block_67,
	kiconv_ja_ucs2_to_euc16_block_68,
	kiconv_ja_ucs2_to_euc16_block_69,
	kiconv_ja_ucs2_to_euc16_block_6A,
	kiconv_ja_ucs2_to_euc16_block_6B,
	kiconv_ja_ucs2_to_euc16_block_6C,
	kiconv_ja_ucs2_to_euc16_block_6D,
	kiconv_ja_ucs2_to_euc16_block_6E,
	kiconv_ja_ucs2_to_euc16_block_6F,
	kiconv_ja_ucs2_to_euc16_block_70,
	kiconv_ja_ucs2_to_euc16_block_71,
	kiconv_ja_ucs2_to_euc16_block_72,
	kiconv_ja_ucs2_to_euc16_block_73,
	kiconv_ja_ucs2_to_euc16_block_74,
	kiconv_ja_ucs2_to_euc16_block_75,
	kiconv_ja_ucs2_to_euc16_block_76,
	kiconv_ja_ucs2_to_euc16_block_77,
	kiconv_ja_ucs2_to_euc16_block_78,
	kiconv_ja_ucs2_to_euc16_block_79,
	kiconv_ja_ucs2_to_euc16_block_7A,
	kiconv_ja_ucs2_to_euc16_block_7B,
	kiconv_ja_ucs2_to_euc16_block_7C,
	kiconv_ja_ucs2_to_euc16_block_7D,
	kiconv_ja_ucs2_to_euc16_block_7E,
	kiconv_ja_ucs2_to_euc16_block_7F,
	kiconv_ja_ucs2_to_euc16_block_80,
	kiconv_ja_ucs2_to_euc16_block_81,
	kiconv_ja_ucs2_to_euc16_block_82,
	kiconv_ja_ucs2_to_euc16_block_83,
	kiconv_ja_ucs2_to_euc16_block_84,
	kiconv_ja_ucs2_to_euc16_block_85,
	kiconv_ja_ucs2_to_euc16_block_86,
	kiconv_ja_ucs2_to_euc16_block_87,
	kiconv_ja_ucs2_to_euc16_block_88,
	kiconv_ja_ucs2_to_euc16_block_89,
	kiconv_ja_ucs2_to_euc16_block_8A,
	kiconv_ja_ucs2_to_euc16_block_8B,
	kiconv_ja_ucs2_to_euc16_block_8C,
	kiconv_ja_ucs2_to_euc16_block_8D,
	kiconv_ja_ucs2_to_euc16_block_8E,
	kiconv_ja_ucs2_to_euc16_block_8F,
	kiconv_ja_ucs2_to_euc16_block_90,
	kiconv_ja_ucs2_to_euc16_block_91,
	kiconv_ja_ucs2_to_euc16_block_92,
	kiconv_ja_ucs2_to_euc16_block_93,
	kiconv_ja_ucs2_to_euc16_block_94,
	kiconv_ja_ucs2_to_euc16_block_95,
	kiconv_ja_ucs2_to_euc16_block_96,
	kiconv_ja_ucs2_to_euc16_block_97,
	kiconv_ja_ucs2_to_euc16_block_98,
	kiconv_ja_ucs2_to_euc16_block_99,
	kiconv_ja_ucs2_to_euc16_block_9A,
	kiconv_ja_ucs2_to_euc16_block_9B,
	kiconv_ja_ucs2_to_euc16_block_9C,
	kiconv_ja_ucs2_to_euc16_block_9D,
	kiconv_ja_ucs2_to_euc16_block_9E,
	kiconv_ja_ucs2_to_euc16_block_9F,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A0 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A1 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A2 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A3 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A4 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A5 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A6 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A7 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A8 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_A9 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AA eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AD eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AE eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_AF eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B0 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B1 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B2 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B3 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B4 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B5 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B6 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B7 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B8 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_B9 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BA eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BD eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BE eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_BF eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C0 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C1 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C2 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C3 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C4 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C5 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C6 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C7 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C8 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_C9 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CA eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CD eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CE eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_CF eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D0 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D1 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D2 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D3 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D4 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D5 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D6 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D7 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D8 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_D9 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DA eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DD eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DE eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_DF eliminated */
	kiconv_ja_ucs2_to_euc16_block_E0,
	kiconv_ja_ucs2_to_euc16_block_E1,
	kiconv_ja_ucs2_to_euc16_block_E2,
	kiconv_ja_ucs2_to_euc16_block_E3,
	kiconv_ja_ucs2_to_euc16_block_E4,
	kiconv_ja_ucs2_to_euc16_block_E5,
	kiconv_ja_ucs2_to_euc16_block_E6,
	kiconv_ja_ucs2_to_euc16_block_E7,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_E8 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_E9 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_EA eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_EB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_EC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_ED eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_EE eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_EF eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F0 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F1 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F2 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F3 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F4 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F5 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F6 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F7 eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_F8 eliminated */
	kiconv_ja_ucs2_to_euc16_block_F9,
	kiconv_ja_ucs2_to_euc16_block_FA,
	NULL, /* kiconv_ja_ucs2_to_euc16_block_FB eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_FC eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_FD eliminated */
	NULL, /* kiconv_ja_ucs2_to_euc16_block_FE eliminated */
	kiconv_ja_ucs2_to_euc16_block_FF,
};

#define	KICONV_JA_CNV_U2_TO_EUCJPMS(id, e, u) \
	(e) = KICONV_JA_NODEST; \
	if ((id) == KICONV_JA_TBLID_EUCJP_MS || \
	    (id) == KICONV_JA_TBLID_CP932) { \
		if ((u) == 0xff5e) { \
			(e) = 0xa1c1; \
		} else if ((u) == 0x2225) { \
			(e) = 0xa1c2; \
		} else if ((u) == 0xff0d) { \
			(e) = 0xa1dd; \
		} else if ((u) == 0xffe0) { \
			(e) = 0xa1f1; \
		} else if ((u) == 0xffe1) { \
			(e) = 0xa1f2; \
		} else if ((u) == 0xffe2) { \
			(e) = 0xa2cc; \
		} else if ((u) == 0xffe4) { \
			(e) = 0xa243; \
		} else if ((u) == 0x2116) { \
			(e) = 0xade2; \
		} \
	} \

#undef NODEST

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_JA_UNICODE_TO_JIS_H */
