/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef	_SYS_KICONV_GB2312_UTF8_H
#define	_SYS_KICONV_GB2312_UTF8_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from GB2312 to UTF-8. */
#define	KICONV_GB2312_UTF8_MAX		(8179)

/* Index = GB2312 - 0x2121. */
static uchar_t kiconv_gb2312_utf8[][3] = {
	{ 0xE3, 0x80, 0x80 },
	{ 0xE3, 0x80, 0x81 },
	{ 0xE3, 0x80, 0x82 },
	{ 0xC2, 0xB7 },
	{ 0xCB, 0x89 },
	{ 0xCB, 0x87 },
	{ 0xC2, 0xA8 },
	{ 0xE3, 0x80, 0x83 },
	{ 0xE3, 0x80, 0x85 },
	{ 0xE2, 0x80, 0x94 },
	{ 0xEF, 0xBD, 0x9E },
	{ 0xE2, 0x80, 0x96 },
	{ 0xE2, 0x80, 0xA6 },
	{ 0xE2, 0x80, 0x98 },
	{ 0xE2, 0x80, 0x99 },
	{ 0xE2, 0x80, 0x9C },
	{ 0xE2, 0x80, 0x9D },
	{ 0xE3, 0x80, 0x94 },
	{ 0xE3, 0x80, 0x95 },
	{ 0xE3, 0x80, 0x88 },
	{ 0xE3, 0x80, 0x89 },
	{ 0xE3, 0x80, 0x8A },
	{ 0xE3, 0x80, 0x8B },
	{ 0xE3, 0x80, 0x8C },
	{ 0xE3, 0x80, 0x8D },
	{ 0xE3, 0x80, 0x8E },
	{ 0xE3, 0x80, 0x8F },
	{ 0xE3, 0x80, 0x96 },
	{ 0xE3, 0x80, 0x97 },
	{ 0xE3, 0x80, 0x90 },
	{ 0xE3, 0x80, 0x91 },
	{ 0xC2, 0xB1 },
	{ 0xC3, 0x97 },
	{ 0xC3, 0xB7 },
	{ 0xE2, 0x88, 0xB6 },
	{ 0xE2, 0x88, 0xA7 },
	{ 0xE2, 0x88, 0xA8 },
	{ 0xE2, 0x88, 0x91 },
	{ 0xE2, 0x88, 0x8F },
	{ 0xE2, 0x88, 0xAA },
	{ 0xE2, 0x88, 0xA9 },
	{ 0xE2, 0x88, 0x88 },
	{ 0xE2, 0x88, 0xB7 },
	{ 0xE2, 0x88, 0x9A },
	{ 0xE2, 0x8A, 0xA5 },
	{ 0xE2, 0x88, 0xA5 },
	{ 0xE2, 0x88, 0xA0 },
	{ 0xE2, 0x8C, 0x92 },
	{ 0xE2, 0x8A, 0x99 },
	{ 0xE2, 0x88, 0xAB },
	{ 0xE2, 0x88, 0xAE },
	{ 0xE2, 0x89, 0xA1 },
	{ 0xE2, 0x89, 0x8C },
	{ 0xE2, 0x89, 0x88 },
	{ 0xE2, 0x88, 0xBD },
	{ 0xE2, 0x88, 0x9D },
	{ 0xE2, 0x89, 0xA0 },
	{ 0xE2, 0x89, 0xAE },
	{ 0xE2, 0x89, 0xAF },
	{ 0xE2, 0x89, 0xA4 },
	{ 0xE2, 0x89, 0xA5 },
	{ 0xE2, 0x88, 0x9E },
	{ 0xE2, 0x88, 0xB5 },
	{ 0xE2, 0x88, 0xB4 },
	{ 0xE2, 0x99, 0x82 },
	{ 0xE2, 0x99, 0x80 },
	{ 0xC2, 0xB0 },
	{ 0xE2, 0x80, 0xB2 },
	{ 0xE2, 0x80, 0xB3 },
	{ 0xE2, 0x84, 0x83 },
	{ 0xEF, 0xBC, 0x84 },
	{ 0xC2, 0xA4 },
	{ 0xEF, 0xBF, 0xA0 },
	{ 0xEF, 0xBF, 0xA1 },
	{ 0xE2, 0x80, 0xB0 },
	{ 0xC2, 0xA7 },
	{ 0xE2, 0x84, 0x96 },
	{ 0xE2, 0x98, 0x86 },
	{ 0xE2, 0x98, 0x85 },
	{ 0xE2, 0x97, 0x8B },
	{ 0xE2, 0x97, 0x8F },
	{ 0xE2, 0x97, 0x8E },
	{ 0xE2, 0x97, 0x87 },
	{ 0xE2, 0x97, 0x86 },
	{ 0xE2, 0x96, 0xA1 },
	{ 0xE2, 0x96, 0xA0 },
	{ 0xE2, 0x96, 0xB3 },
	{ 0xE2, 0x96, 0xB2 },
	{ 0xE2, 0x80, 0xBB },
	{ 0xE2, 0x86, 0x92 },
	{ 0xE2, 0x86, 0x90 },
	{ 0xE2, 0x86, 0x91 },
	{ 0xE2, 0x86, 0x93 },
	{ 0xE3, 0x80, 0x93 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE2, 0x92, 0x88 },
	{ 0xE2, 0x92, 0x89 },
	{ 0xE2, 0x92, 0x8A },
	{ 0xE2, 0x92, 0x8B },
	{ 0xE2, 0x92, 0x8C },
	{ 0xE2, 0x92, 0x8D },
	{ 0xE2, 0x92, 0x8E },
	{ 0xE2, 0x92, 0x8F },
	{ 0xE2, 0x92, 0x90 },
	{ 0xE2, 0x92, 0x91 },
	{ 0xE2, 0x92, 0x92 },
	{ 0xE2, 0x92, 0x93 },
	{ 0xE2, 0x92, 0x94 },
	{ 0xE2, 0x92, 0x95 },
	{ 0xE2, 0x92, 0x96 },
	{ 0xE2, 0x92, 0x97 },
	{ 0xE2, 0x92, 0x98 },
	{ 0xE2, 0x92, 0x99 },
	{ 0xE2, 0x92, 0x9A },
	{ 0xE2, 0x92, 0x9B },
	{ 0xE2, 0x91, 0xB4 },
	{ 0xE2, 0x91, 0xB5 },
	{ 0xE2, 0x91, 0xB6 },
	{ 0xE2, 0x91, 0xB7 },
	{ 0xE2, 0x91, 0xB8 },
	{ 0xE2, 0x91, 0xB9 },
	{ 0xE2, 0x91, 0xBA },
	{ 0xE2, 0x91, 0xBB },
	{ 0xE2, 0x91, 0xBC },
	{ 0xE2, 0x91, 0xBD },
	{ 0xE2, 0x91, 0xBE },
	{ 0xE2, 0x91, 0xBF },
	{ 0xE2, 0x92, 0x80 },
	{ 0xE2, 0x92, 0x81 },
	{ 0xE2, 0x92, 0x82 },
	{ 0xE2, 0x92, 0x83 },
	{ 0xE2, 0x92, 0x84 },
	{ 0xE2, 0x92, 0x85 },
	{ 0xE2, 0x92, 0x86 },
	{ 0xE2, 0x92, 0x87 },
	{ 0xE2, 0x91, 0xA0 },
	{ 0xE2, 0x91, 0xA1 },
	{ 0xE2, 0x91, 0xA2 },
	{ 0xE2, 0x91, 0xA3 },
	{ 0xE2, 0x91, 0xA4 },
	{ 0xE2, 0x91, 0xA5 },
	{ 0xE2, 0x91, 0xA6 },
	{ 0xE2, 0x91, 0xA7 },
	{ 0xE2, 0x91, 0xA8 },
	{ 0xE2, 0x91, 0xA9 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE3, 0x88, 0xA0 },
	{ 0xE3, 0x88, 0xA1 },
	{ 0xE3, 0x88, 0xA2 },
	{ 0xE3, 0x88, 0xA3 },
	{ 0xE3, 0x88, 0xA4 },
	{ 0xE3, 0x88, 0xA5 },
	{ 0xE3, 0x88, 0xA6 },
	{ 0xE3, 0x88, 0xA7 },
	{ 0xE3, 0x88, 0xA8 },
	{ 0xE3, 0x88, 0xA9 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE2, 0x85, 0xA0 },
	{ 0xE2, 0x85, 0xA1 },
	{ 0xE2, 0x85, 0xA2 },
	{ 0xE2, 0x85, 0xA3 },
	{ 0xE2, 0x85, 0xA4 },
	{ 0xE2, 0x85, 0xA5 },
	{ 0xE2, 0x85, 0xA6 },
	{ 0xE2, 0x85, 0xA7 },
	{ 0xE2, 0x85, 0xA8 },
	{ 0xE2, 0x85, 0xA9 },
	{ 0xE2, 0x85, 0xAA },
	{ 0xE2, 0x85, 0xAB },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBC, 0x81 },
	{ 0xEF, 0xBC, 0x82 },
	{ 0xEF, 0xBC, 0x83 },
	{ 0xEF, 0xBF, 0xA5 },
	{ 0xEF, 0xBC, 0x85 },
	{ 0xEF, 0xBC, 0x86 },
	{ 0xEF, 0xBC, 0x87 },
	{ 0xEF, 0xBC, 0x88 },
	{ 0xEF, 0xBC, 0x89 },
	{ 0xEF, 0xBC, 0x8A },
	{ 0xEF, 0xBC, 0x8B },
	{ 0xEF, 0xBC, 0x8C },
	{ 0xEF, 0xBC, 0x8D },
	{ 0xEF, 0xBC, 0x8E },
	{ 0xEF, 0xBC, 0x8F },
	{ 0xEF, 0xBC, 0x90 },
	{ 0xEF, 0xBC, 0x91 },
	{ 0xEF, 0xBC, 0x92 },
	{ 0xEF, 0xBC, 0x93 },
	{ 0xEF, 0xBC, 0x94 },
	{ 0xEF, 0xBC, 0x95 },
	{ 0xEF, 0xBC, 0x96 },
	{ 0xEF, 0xBC, 0x97 },
	{ 0xEF, 0xBC, 0x98 },
	{ 0xEF, 0xBC, 0x99 },
	{ 0xEF, 0xBC, 0x9A },
	{ 0xEF, 0xBC, 0x9B },
	{ 0xEF, 0xBC, 0x9C },
	{ 0xEF, 0xBC, 0x9D },
	{ 0xEF, 0xBC, 0x9E },
	{ 0xEF, 0xBC, 0x9F },
	{ 0xEF, 0xBC, 0xA0 },
	{ 0xEF, 0xBC, 0xA1 },
	{ 0xEF, 0xBC, 0xA2 },
	{ 0xEF, 0xBC, 0xA3 },
	{ 0xEF, 0xBC, 0xA4 },
	{ 0xEF, 0xBC, 0xA5 },
	{ 0xEF, 0xBC, 0xA6 },
	{ 0xEF, 0xBC, 0xA7 },
	{ 0xEF, 0xBC, 0xA8 },
	{ 0xEF, 0xBC, 0xA9 },
	{ 0xEF, 0xBC, 0xAA },
	{ 0xEF, 0xBC, 0xAB },
	{ 0xEF, 0xBC, 0xAC },
	{ 0xEF, 0xBC, 0xAD },
	{ 0xEF, 0xBC, 0xAE },
	{ 0xEF, 0xBC, 0xAF },
	{ 0xEF, 0xBC, 0xB0 },
	{ 0xEF, 0xBC, 0xB1 },
	{ 0xEF, 0xBC, 0xB2 },
	{ 0xEF, 0xBC, 0xB3 },
	{ 0xEF, 0xBC, 0xB4 },
	{ 0xEF, 0xBC, 0xB5 },
	{ 0xEF, 0xBC, 0xB6 },
	{ 0xEF, 0xBC, 0xB7 },
	{ 0xEF, 0xBC, 0xB8 },
	{ 0xEF, 0xBC, 0xB9 },
	{ 0xEF, 0xBC, 0xBA },
	{ 0xEF, 0xBC, 0xBB },
	{ 0xEF, 0xBC, 0xBC },
	{ 0xEF, 0xBC, 0xBD },
	{ 0xEF, 0xBC, 0xBE },
	{ 0xEF, 0xBC, 0xBF },
	{ 0xEF, 0xBD, 0x80 },
	{ 0xEF, 0xBD, 0x81 },
	{ 0xEF, 0xBD, 0x82 },
	{ 0xEF, 0xBD, 0x83 },
	{ 0xEF, 0xBD, 0x84 },
	{ 0xEF, 0xBD, 0x85 },
	{ 0xEF, 0xBD, 0x86 },
	{ 0xEF, 0xBD, 0x87 },
	{ 0xEF, 0xBD, 0x88 },
	{ 0xEF, 0xBD, 0x89 },
	{ 0xEF, 0xBD, 0x8A },
	{ 0xEF, 0xBD, 0x8B },
	{ 0xEF, 0xBD, 0x8C },
	{ 0xEF, 0xBD, 0x8D },
	{ 0xEF, 0xBD, 0x8E },
	{ 0xEF, 0xBD, 0x8F },
	{ 0xEF, 0xBD, 0x90 },
	{ 0xEF, 0xBD, 0x91 },
	{ 0xEF, 0xBD, 0x92 },
	{ 0xEF, 0xBD, 0x93 },
	{ 0xEF, 0xBD, 0x94 },
	{ 0xEF, 0xBD, 0x95 },
	{ 0xEF, 0xBD, 0x96 },
	{ 0xEF, 0xBD, 0x97 },
	{ 0xEF, 0xBD, 0x98 },
	{ 0xEF, 0xBD, 0x99 },
	{ 0xEF, 0xBD, 0x9A },
	{ 0xEF, 0xBD, 0x9B },
	{ 0xEF, 0xBD, 0x9C },
	{ 0xEF, 0xBD, 0x9D },
	{ 0xEF, 0xBF, 0xA3 },
	{ 0xE3, 0x81, 0x81 },
	{ 0xE3, 0x81, 0x82 },
	{ 0xE3, 0x81, 0x83 },
	{ 0xE3, 0x81, 0x84 },
	{ 0xE3, 0x81, 0x85 },
	{ 0xE3, 0x81, 0x86 },
	{ 0xE3, 0x81, 0x87 },
	{ 0xE3, 0x81, 0x88 },
	{ 0xE3, 0x81, 0x89 },
	{ 0xE3, 0x81, 0x8A },
	{ 0xE3, 0x81, 0x8B },
	{ 0xE3, 0x81, 0x8C },
	{ 0xE3, 0x81, 0x8D },
	{ 0xE3, 0x81, 0x8E },
	{ 0xE3, 0x81, 0x8F },
	{ 0xE3, 0x81, 0x90 },
	{ 0xE3, 0x81, 0x91 },
	{ 0xE3, 0x81, 0x92 },
	{ 0xE3, 0x81, 0x93 },
	{ 0xE3, 0x81, 0x94 },
	{ 0xE3, 0x81, 0x95 },
	{ 0xE3, 0x81, 0x96 },
	{ 0xE3, 0x81, 0x97 },
	{ 0xE3, 0x81, 0x98 },
	{ 0xE3, 0x81, 0x99 },
	{ 0xE3, 0x81, 0x9A },
	{ 0xE3, 0x81, 0x9B },
	{ 0xE3, 0x81, 0x9C },
	{ 0xE3, 0x81, 0x9D },
	{ 0xE3, 0x81, 0x9E },
	{ 0xE3, 0x81, 0x9F },
	{ 0xE3, 0x81, 0xA0 },
	{ 0xE3, 0x81, 0xA1 },
	{ 0xE3, 0x81, 0xA2 },
	{ 0xE3, 0x81, 0xA3 },
	{ 0xE3, 0x81, 0xA4 },
	{ 0xE3, 0x81, 0xA5 },
	{ 0xE3, 0x81, 0xA6 },
	{ 0xE3, 0x81, 0xA7 },
	{ 0xE3, 0x81, 0xA8 },
	{ 0xE3, 0x81, 0xA9 },
	{ 0xE3, 0x81, 0xAA },
	{ 0xE3, 0x81, 0xAB },
	{ 0xE3, 0x81, 0xAC },
	{ 0xE3, 0x81, 0xAD },
	{ 0xE3, 0x81, 0xAE },
	{ 0xE3, 0x81, 0xAF },
	{ 0xE3, 0x81, 0xB0 },
	{ 0xE3, 0x81, 0xB1 },
	{ 0xE3, 0x81, 0xB2 },
	{ 0xE3, 0x81, 0xB3 },
	{ 0xE3, 0x81, 0xB4 },
	{ 0xE3, 0x81, 0xB5 },
	{ 0xE3, 0x81, 0xB6 },
	{ 0xE3, 0x81, 0xB7 },
	{ 0xE3, 0x81, 0xB8 },
	{ 0xE3, 0x81, 0xB9 },
	{ 0xE3, 0x81, 0xBA },
	{ 0xE3, 0x81, 0xBB },
	{ 0xE3, 0x81, 0xBC },
	{ 0xE3, 0x81, 0xBD },
	{ 0xE3, 0x81, 0xBE },
	{ 0xE3, 0x81, 0xBF },
	{ 0xE3, 0x82, 0x80 },
	{ 0xE3, 0x82, 0x81 },
	{ 0xE3, 0x82, 0x82 },
	{ 0xE3, 0x82, 0x83 },
	{ 0xE3, 0x82, 0x84 },
	{ 0xE3, 0x82, 0x85 },
	{ 0xE3, 0x82, 0x86 },
	{ 0xE3, 0x82, 0x87 },
	{ 0xE3, 0x82, 0x88 },
	{ 0xE3, 0x82, 0x89 },
	{ 0xE3, 0x82, 0x8A },
	{ 0xE3, 0x82, 0x8B },
	{ 0xE3, 0x82, 0x8C },
	{ 0xE3, 0x82, 0x8D },
	{ 0xE3, 0x82, 0x8E },
	{ 0xE3, 0x82, 0x8F },
	{ 0xE3, 0x82, 0x90 },
	{ 0xE3, 0x82, 0x91 },
	{ 0xE3, 0x82, 0x92 },
	{ 0xE3, 0x82, 0x93 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE3, 0x82, 0xA1 },
	{ 0xE3, 0x82, 0xA2 },
	{ 0xE3, 0x82, 0xA3 },
	{ 0xE3, 0x82, 0xA4 },
	{ 0xE3, 0x82, 0xA5 },
	{ 0xE3, 0x82, 0xA6 },
	{ 0xE3, 0x82, 0xA7 },
	{ 0xE3, 0x82, 0xA8 },
	{ 0xE3, 0x82, 0xA9 },
	{ 0xE3, 0x82, 0xAA },
	{ 0xE3, 0x82, 0xAB },
	{ 0xE3, 0x82, 0xAC },
	{ 0xE3, 0x82, 0xAD },
	{ 0xE3, 0x82, 0xAE },
	{ 0xE3, 0x82, 0xAF },
	{ 0xE3, 0x82, 0xB0 },
	{ 0xE3, 0x82, 0xB1 },
	{ 0xE3, 0x82, 0xB2 },
	{ 0xE3, 0x82, 0xB3 },
	{ 0xE3, 0x82, 0xB4 },
	{ 0xE3, 0x82, 0xB5 },
	{ 0xE3, 0x82, 0xB6 },
	{ 0xE3, 0x82, 0xB7 },
	{ 0xE3, 0x82, 0xB8 },
	{ 0xE3, 0x82, 0xB9 },
	{ 0xE3, 0x82, 0xBA },
	{ 0xE3, 0x82, 0xBB },
	{ 0xE3, 0x82, 0xBC },
	{ 0xE3, 0x82, 0xBD },
	{ 0xE3, 0x82, 0xBE },
	{ 0xE3, 0x82, 0xBF },
	{ 0xE3, 0x83, 0x80 },
	{ 0xE3, 0x83, 0x81 },
	{ 0xE3, 0x83, 0x82 },
	{ 0xE3, 0x83, 0x83 },
	{ 0xE3, 0x83, 0x84 },
	{ 0xE3, 0x83, 0x85 },
	{ 0xE3, 0x83, 0x86 },
	{ 0xE3, 0x83, 0x87 },
	{ 0xE3, 0x83, 0x88 },
	{ 0xE3, 0x83, 0x89 },
	{ 0xE3, 0x83, 0x8A },
	{ 0xE3, 0x83, 0x8B },
	{ 0xE3, 0x83, 0x8C },
	{ 0xE3, 0x83, 0x8D },
	{ 0xE3, 0x83, 0x8E },
	{ 0xE3, 0x83, 0x8F },
	{ 0xE3, 0x83, 0x90 },
	{ 0xE3, 0x83, 0x91 },
	{ 0xE3, 0x83, 0x92 },
	{ 0xE3, 0x83, 0x93 },
	{ 0xE3, 0x83, 0x94 },
	{ 0xE3, 0x83, 0x95 },
	{ 0xE3, 0x83, 0x96 },
	{ 0xE3, 0x83, 0x97 },
	{ 0xE3, 0x83, 0x98 },
	{ 0xE3, 0x83, 0x99 },
	{ 0xE3, 0x83, 0x9A },
	{ 0xE3, 0x83, 0x9B },
	{ 0xE3, 0x83, 0x9C },
	{ 0xE3, 0x83, 0x9D },
	{ 0xE3, 0x83, 0x9E },
	{ 0xE3, 0x83, 0x9F },
	{ 0xE3, 0x83, 0xA0 },
	{ 0xE3, 0x83, 0xA1 },
	{ 0xE3, 0x83, 0xA2 },
	{ 0xE3, 0x83, 0xA3 },
	{ 0xE3, 0x83, 0xA4 },
	{ 0xE3, 0x83, 0xA5 },
	{ 0xE3, 0x83, 0xA6 },
	{ 0xE3, 0x83, 0xA7 },
	{ 0xE3, 0x83, 0xA8 },
	{ 0xE3, 0x83, 0xA9 },
	{ 0xE3, 0x83, 0xAA },
	{ 0xE3, 0x83, 0xAB },
	{ 0xE3, 0x83, 0xAC },
	{ 0xE3, 0x83, 0xAD },
	{ 0xE3, 0x83, 0xAE },
	{ 0xE3, 0x83, 0xAF },
	{ 0xE3, 0x83, 0xB0 },
	{ 0xE3, 0x83, 0xB1 },
	{ 0xE3, 0x83, 0xB2 },
	{ 0xE3, 0x83, 0xB3 },
	{ 0xE3, 0x83, 0xB4 },
	{ 0xE3, 0x83, 0xB5 },
	{ 0xE3, 0x83, 0xB6 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xCE, 0x91 },
	{ 0xCE, 0x92 },
	{ 0xCE, 0x93 },
	{ 0xCE, 0x94 },
	{ 0xCE, 0x95 },
	{ 0xCE, 0x96 },
	{ 0xCE, 0x97 },
	{ 0xCE, 0x98 },
	{ 0xCE, 0x99 },
	{ 0xCE, 0x9A },
	{ 0xCE, 0x9B },
	{ 0xCE, 0x9C },
	{ 0xCE, 0x9D },
	{ 0xCE, 0x9E },
	{ 0xCE, 0x9F },
	{ 0xCE, 0xA0 },
	{ 0xCE, 0xA1 },
	{ 0xCE, 0xA3 },
	{ 0xCE, 0xA4 },
	{ 0xCE, 0xA5 },
	{ 0xCE, 0xA6 },
	{ 0xCE, 0xA7 },
	{ 0xCE, 0xA8 },
	{ 0xCE, 0xA9 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xCE, 0xB1 },
	{ 0xCE, 0xB2 },
	{ 0xCE, 0xB3 },
	{ 0xCE, 0xB4 },
	{ 0xCE, 0xB5 },
	{ 0xCE, 0xB6 },
	{ 0xCE, 0xB7 },
	{ 0xCE, 0xB8 },
	{ 0xCE, 0xB9 },
	{ 0xCE, 0xBA },
	{ 0xCE, 0xBB },
	{ 0xCE, 0xBC },
	{ 0xCE, 0xBD },
	{ 0xCE, 0xBE },
	{ 0xCE, 0xBF },
	{ 0xCF, 0x80 },
	{ 0xCF, 0x81 },
	{ 0xCF, 0x83 },
	{ 0xCF, 0x84 },
	{ 0xCF, 0x85 },
	{ 0xCF, 0x86 },
	{ 0xCF, 0x87 },
	{ 0xCF, 0x88 },
	{ 0xCF, 0x89 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xD0, 0x90 },
	{ 0xD0, 0x91 },
	{ 0xD0, 0x92 },
	{ 0xD0, 0x93 },
	{ 0xD0, 0x94 },
	{ 0xD0, 0x95 },
	{ 0xD0, 0x81 },
	{ 0xD0, 0x96 },
	{ 0xD0, 0x97 },
	{ 0xD0, 0x98 },
	{ 0xD0, 0x99 },
	{ 0xD0, 0x9A },
	{ 0xD0, 0x9B },
	{ 0xD0, 0x9C },
	{ 0xD0, 0x9D },
	{ 0xD0, 0x9E },
	{ 0xD0, 0x9F },
	{ 0xD0, 0xA0 },
	{ 0xD0, 0xA1 },
	{ 0xD0, 0xA2 },
	{ 0xD0, 0xA3 },
	{ 0xD0, 0xA4 },
	{ 0xD0, 0xA5 },
	{ 0xD0, 0xA6 },
	{ 0xD0, 0xA7 },
	{ 0xD0, 0xA8 },
	{ 0xD0, 0xA9 },
	{ 0xD0, 0xAA },
	{ 0xD0, 0xAB },
	{ 0xD0, 0xAC },
	{ 0xD0, 0xAD },
	{ 0xD0, 0xAE },
	{ 0xD0, 0xAF },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xD0, 0xB0 },
	{ 0xD0, 0xB1 },
	{ 0xD0, 0xB2 },
	{ 0xD0, 0xB3 },
	{ 0xD0, 0xB4 },
	{ 0xD0, 0xB5 },
	{ 0xD1, 0x91 },
	{ 0xD0, 0xB6 },
	{ 0xD0, 0xB7 },
	{ 0xD0, 0xB8 },
	{ 0xD0, 0xB9 },
	{ 0xD0, 0xBA },
	{ 0xD0, 0xBB },
	{ 0xD0, 0xBC },
	{ 0xD0, 0xBD },
	{ 0xD0, 0xBE },
	{ 0xD0, 0xBF },
	{ 0xD1, 0x80 },
	{ 0xD1, 0x81 },
	{ 0xD1, 0x82 },
	{ 0xD1, 0x83 },
	{ 0xD1, 0x84 },
	{ 0xD1, 0x85 },
	{ 0xD1, 0x86 },
	{ 0xD1, 0x87 },
	{ 0xD1, 0x88 },
	{ 0xD1, 0x89 },
	{ 0xD1, 0x8A },
	{ 0xD1, 0x8B },
	{ 0xD1, 0x8C },
	{ 0xD1, 0x8D },
	{ 0xD1, 0x8E },
	{ 0xD1, 0x8F },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xC4, 0x81 },
	{ 0xC3, 0xA1 },
	{ 0xC7, 0x8E },
	{ 0xC3, 0xA0 },
	{ 0xC4, 0x93 },
	{ 0xC3, 0xA9 },
	{ 0xC4, 0x9B },
	{ 0xC3, 0xA8 },
	{ 0xC4, 0xAB },
	{ 0xC3, 0xAD },
	{ 0xC7, 0x90 },
	{ 0xC3, 0xAC },
	{ 0xC5, 0x8D },
	{ 0xC3, 0xB3 },
	{ 0xC7, 0x92 },
	{ 0xC3, 0xB2 },
	{ 0xC5, 0xAB },
	{ 0xC3, 0xBA },
	{ 0xC7, 0x94 },
	{ 0xC3, 0xB9 },
	{ 0xC7, 0x96 },
	{ 0xC7, 0x98 },
	{ 0xC7, 0x9A },
	{ 0xC7, 0x9C },
	{ 0xC3, 0xBC },
	{ 0xC3, 0xAA },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE3, 0x84, 0x85 },
	{ 0xE3, 0x84, 0x86 },
	{ 0xE3, 0x84, 0x87 },
	{ 0xE3, 0x84, 0x88 },
	{ 0xE3, 0x84, 0x89 },
	{ 0xE3, 0x84, 0x8A },
	{ 0xE3, 0x84, 0x8B },
	{ 0xE3, 0x84, 0x8C },
	{ 0xE3, 0x84, 0x8D },
	{ 0xE3, 0x84, 0x8E },
	{ 0xE3, 0x84, 0x8F },
	{ 0xE3, 0x84, 0x90 },
	{ 0xE3, 0x84, 0x91 },
	{ 0xE3, 0x84, 0x92 },
	{ 0xE3, 0x84, 0x93 },
	{ 0xE3, 0x84, 0x94 },
	{ 0xE3, 0x84, 0x95 },
	{ 0xE3, 0x84, 0x96 },
	{ 0xE3, 0x84, 0x97 },
	{ 0xE3, 0x84, 0x98 },
	{ 0xE3, 0x84, 0x99 },
	{ 0xE3, 0x84, 0x9A },
	{ 0xE3, 0x84, 0x9B },
	{ 0xE3, 0x84, 0x9C },
	{ 0xE3, 0x84, 0x9D },
	{ 0xE3, 0x84, 0x9E },
	{ 0xE3, 0x84, 0x9F },
	{ 0xE3, 0x84, 0xA0 },
	{ 0xE3, 0x84, 0xA1 },
	{ 0xE3, 0x84, 0xA2 },
	{ 0xE3, 0x84, 0xA3 },
	{ 0xE3, 0x84, 0xA4 },
	{ 0xE3, 0x84, 0xA5 },
	{ 0xE3, 0x84, 0xA6 },
	{ 0xE3, 0x84, 0xA7 },
	{ 0xE3, 0x84, 0xA8 },
	{ 0xE3, 0x84, 0xA9 },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE2, 0x94, 0x80 },
	{ 0xE2, 0x94, 0x81 },
	{ 0xE2, 0x94, 0x82 },
	{ 0xE2, 0x94, 0x83 },
	{ 0xE2, 0x94, 0x84 },
	{ 0xE2, 0x94, 0x85 },
	{ 0xE2, 0x94, 0x86 },
	{ 0xE2, 0x94, 0x87 },
	{ 0xE2, 0x94, 0x88 },
	{ 0xE2, 0x94, 0x89 },
	{ 0xE2, 0x94, 0x8A },
	{ 0xE2, 0x94, 0x8B },
	{ 0xE2, 0x94, 0x8C },
	{ 0xE2, 0x94, 0x8D },
	{ 0xE2, 0x94, 0x8E },
	{ 0xE2, 0x94, 0x8F },
	{ 0xE2, 0x94, 0x90 },
	{ 0xE2, 0x94, 0x91 },
	{ 0xE2, 0x94, 0x92 },
	{ 0xE2, 0x94, 0x93 },
	{ 0xE2, 0x94, 0x94 },
	{ 0xE2, 0x94, 0x95 },
	{ 0xE2, 0x94, 0x96 },
	{ 0xE2, 0x94, 0x97 },
	{ 0xE2, 0x94, 0x98 },
	{ 0xE2, 0x94, 0x99 },
	{ 0xE2, 0x94, 0x9A },
	{ 0xE2, 0x94, 0x9B },
	{ 0xE2, 0x94, 0x9C },
	{ 0xE2, 0x94, 0x9D },
	{ 0xE2, 0x94, 0x9E },
	{ 0xE2, 0x94, 0x9F },
	{ 0xE2, 0x94, 0xA0 },
	{ 0xE2, 0x94, 0xA1 },
	{ 0xE2, 0x94, 0xA2 },
	{ 0xE2, 0x94, 0xA3 },
	{ 0xE2, 0x94, 0xA4 },
	{ 0xE2, 0x94, 0xA5 },
	{ 0xE2, 0x94, 0xA6 },
	{ 0xE2, 0x94, 0xA7 },
	{ 0xE2, 0x94, 0xA8 },
	{ 0xE2, 0x94, 0xA9 },
	{ 0xE2, 0x94, 0xAA },
	{ 0xE2, 0x94, 0xAB },
	{ 0xE2, 0x94, 0xAC },
	{ 0xE2, 0x94, 0xAD },
	{ 0xE2, 0x94, 0xAE },
	{ 0xE2, 0x94, 0xAF },
	{ 0xE2, 0x94, 0xB0 },
	{ 0xE2, 0x94, 0xB1 },
	{ 0xE2, 0x94, 0xB2 },
	{ 0xE2, 0x94, 0xB3 },
	{ 0xE2, 0x94, 0xB4 },
	{ 0xE2, 0x94, 0xB5 },
	{ 0xE2, 0x94, 0xB6 },
	{ 0xE2, 0x94, 0xB7 },
	{ 0xE2, 0x94, 0xB8 },
	{ 0xE2, 0x94, 0xB9 },
	{ 0xE2, 0x94, 0xBA },
	{ 0xE2, 0x94, 0xBB },
	{ 0xE2, 0x94, 0xBC },
	{ 0xE2, 0x94, 0xBD },
	{ 0xE2, 0x94, 0xBE },
	{ 0xE2, 0x94, 0xBF },
	{ 0xE2, 0x95, 0x80 },
	{ 0xE2, 0x95, 0x81 },
	{ 0xE2, 0x95, 0x82 },
	{ 0xE2, 0x95, 0x83 },
	{ 0xE2, 0x95, 0x84 },
	{ 0xE2, 0x95, 0x85 },
	{ 0xE2, 0x95, 0x86 },
	{ 0xE2, 0x95, 0x87 },
	{ 0xE2, 0x95, 0x88 },
	{ 0xE2, 0x95, 0x89 },
	{ 0xE2, 0x95, 0x8A },
	{ 0xE2, 0x95, 0x8B },
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xEF, 0xBF, 0xBD },		/* -1 */
	{ 0xE5, 0x95, 0x8A },
	{ 0xE9, 0x98, 0xBF },
	{ 0xE5, 0x9F, 0x83 },
	{ 0xE6, 0x8C, 0xA8 },
	{ 0xE5, 0x93, 0x8E },
	{ 0xE5, 0x94, 0x89 },
	{ 0xE5, 0x93, 0x80 },
	{ 0xE7, 0x9A, 0x91 },
	{ 0xE7, 0x99, 0x8C },
	{ 0xE8, 0x94, 0xBC },
	{ 0xE7, 0x9F, 0xAE },
	{ 0xE8, 0x89, 0xBE },
	{ 0xE7, 0xA2, 0x8D },
	{ 0xE7, 0x88, 0xB1 },
	{ 0xE9, 0x9A, 0x98 },
	{ 0xE9, 0x9E, 0x8D },
	{ 0xE6, 0xB0, 0xA8 },
	{ 0xE5, 0xAE, 0x89 },
	{ 0xE4, 0xBF, 0xBA },
	{ 0xE6, 0x8C, 0x89 },
	{ 0xE6, 0x9A, 0x97 },
	{ 0xE5, 0xB2, 0xB8 },
	{ 0xE8, 0x83, 0xBA },
	{ 0xE6, 0xA1, 0x88 },
	{ 0xE8, 0x82, 0xAE },
	{ 0xE6, 0x98, 0x82 },
	{ 0xE7, 0x9B, 0x8E },
	{ 0xE5, 0x87, 0xB9 },
	{ 0xE6, 0x95, 0x96 },
	{ 0xE7, 0x86, 0xAC },
	{ 0xE7, 0xBF, 0xB1 },
	{ 0xE8, 0xA2, 0x84 },
	{ 0xE5, 0x82, 0xB2 },
	{ 0xE5, 0xA5, 0xA5 },
	{ 0xE6, 0x87, 0x8A },
	{ 0xE6, 0xBE, 0xB3 },
	{ 0xE8, 0x8A, 0xAD },
	{ 0xE6, 0x8D, 0x8C },
	{ 0xE6, 0x89, 0x92 },
	{ 0xE5, 0x8F, 0xAD },
	{ 0xE5, 0x90, 0xA7 },
	{ 0xE7, 0xAC, 0x86 },
	{ 0xE5, 0x85, 0xAB },
	{ 0xE7, 0x96, 0xA4 },
	{ 0xE5, 0xB7, 0xB4 },
	{ 0xE6, 0x8B, 0x94 },
	{ 0xE8, 0xB7, 0x8B },
	{ 0xE9, 0x9D, 0xB6 },
	{ 0xE6, 0x8A, 0x8A },
	{ 0xE8, 0x80, 0x99 },
	{ 0xE5, 0x9D, 0x9D },
	{ 0xE9, 0x9C, 0xB8 },
	{ 0xE7, 0xBD, 0xA2 },
	{ 0xE7, 0x88, 0xB8 },
	{ 0xE7, 0x99, 0xBD },
	{ 0xE6, 0x9F, 0x8F },
	{ 0xE7, 0x99, 0xBE },
	{ 0xE6, 0x91, 0x86 },
	{ 0xE4, 0xBD, 0xB0 },
	{ 0xE8, 0xB4, 0xA5 },
	{ 0xE6, 0x8B, 0x9C },
	{ 0xE7, 0xA8, 0x97 },
	{ 0xE6, 0x96, 0x91 },
	{ 0xE7, 0x8F, 0xAD },
	{ 0xE6, 0x90, 0xAC },
	{ 0xE6, 0x89, 0xB3 },
	{ 0xE8, 0x88, 0xAC },
	{ 0xE9, 0xA2, 0x81 },
	{ 0xE6, 0x9D, 0xBF },
	{ 0xE7, 0x89, 0x88 },
	{ 0xE6, 0x89, 0xAE },
	{ 0xE6, 0x8B, 0x8C },
	{ 0xE4, 0xBC, 0xB4 },
	{ 0xE7, 0x93, 0xA3 },
	{ 0xE5, 0x8D, 0x8A },
	{ 0xE5, 0x8A, 0x9E },
	{ 0xE7, 0xBB, 0x8A },
	{ 0xE9, 0x82, 0xA6 },
	{ 0xE5, 0xB8, 0xAE },
	{ 0xE6, 0xA2, 0x86 },
	{ 0xE6, 0xA6, 0x9C },
	{ 0xE8, 0x86, 0x80 },
	{ 0xE7, 0xBB, 0x91 },
	{ 0xE6, 0xA3, 0x92 },
	{ 0xE7, 0xA3, 0x85 },
	{ 0xE8, 0x9A, 0x8C },
	{ 0xE9, 0x95, 0x91 },
	{ 0xE5, 0x82, 0x8D },
	{ 0xE8, 0xB0, 0xA4 },
	{ 0xE8, 0x8B, 0x9E },
	{ 0xE8, 0x83, 0x9E },
	{ 0xE5, 0x8C, 0x85 },
	{ 0xE8, 0xA4, 0x92 },
	{ 0xE5, 0x89, 0xA5 },
	{ 0xE8, 0x96, 0x84 },
	{ 0xE9, 0x9B, 0xB9 },
	{ 0xE4, 0xBF, 0x9D },
	{ 0xE5, 0xA0, 0xA1 },
	{ 0xE9, 0xA5, 0xB1 },
	{ 0xE5, 0xAE, 0x9D },
	{ 0xE6, 0x8A, 0xB1 },
	{ 0xE6, 0x8A, 0xA5 },
	{ 0xE6, 0x9A, 0xB4 },
	{ 0xE8, 0xB1, 0xB9 },
	{ 0xE9, 0xB2, 0x8D },
	{ 0xE7, 0x88, 0x86 },
	{ 0xE6, 0x9D, 0xAF },
	{ 0xE7, 0xA2, 0x91 },
	{ 0xE6, 0x82, 0xB2 },
	{ 0xE5, 0x8D, 0x91 },
	{ 0xE5, 0x8C, 0x97 },
	{ 0xE8, 0xBE, 0x88 },
	{ 0xE8, 0x83, 0x8C },
	{ 0xE8, 0xB4, 0x9D },
	{ 0xE9, 0x92, 0xA1 },
	{ 0xE5, 0x80, 0x8D },
	{ 0xE7, 0x8B, 0x88 },
	{ 0xE5, 0xA4, 0x87 },
	{ 0xE6, 0x83, 0xAB },
	{ 0xE7, 0x84, 0x99 },
	{ 0xE8, 0xA2, 0xAB },
	{ 0xE5, 0xA5, 0x94 },
	{ 0xE8, 0x8B, 0xAF },
	{ 0xE6, 0x9C, 0xAC },
	{ 0xE7, 0xAC, 0xA8 },
	{ 0xE5, 0xB4, 0xA9 },
	{ 0xE7, 0xBB, 0xB7 },
	{ 0xE7, 0x94, 0xAD },
	{ 0xE6, 0xB3, 0xB5 },
	{ 0xE8, 0xB9, 0xA6 },
	{ 0xE8, 0xBF, 0xB8 },
	{ 0xE9, 0x80, 0xBC },
	{ 0xE9, 0xBC, 0xBB },
	{ 0xE6, 0xAF, 0x94 },
	{ 0xE9, 0x84, 0x99 },
	{ 0xE7, 0xAC, 0x94 },
	{ 0xE5, 0xBD, 0xBC },
	{ 0xE7, 0xA2, 0xA7 },
	{ 0xE8, 0x93, 0x96 },
	{ 0xE8, 0x94, 0xBD },
	{ 0xE6, 0xAF, 0x95 },
	{ 0xE6, 0xAF, 0x99 },
	{ 0xE6, 0xAF, 0x96 },
	{ 0xE5, 0xB8, 0x81 },
	{ 0xE5, 0xBA, 0x87 },
	{ 0xE7, 0x97, 0xB9 },
	{ 0xE9, 0x97, 0xAD },
	{ 0xE6, 0x95, 0x9D },
	{ 0xE5, 0xBC, 0x8A },
	{ 0xE5, 0xBF, 0x85 },
	{ 0xE8, 0xBE, 0x9F },
	{ 0xE5, 0xA3, 0x81 },
	{ 0xE8, 0x87, 0x82 },
	{ 0xE9, 0x81, 0xBF },
	{ 0xE9, 0x99, 0x9B },
	{ 0xE9, 0x9E, 0xAD },
	{ 0xE8, 0xBE, 0xB9 },
	{ 0xE7, 0xBC, 0x96 },
	{ 0xE8, 0xB4, 0xAC },
	{ 0xE6, 0x89, 0x81 },
	{ 0xE4, 0xBE, 0xBF },
	{ 0xE5, 0x8F, 0x98 },
	{ 0xE5, 0x8D, 0x9E },
	{ 0xE8, 0xBE, 0xA8 },
	{ 0xE8, 0xBE, 0xA9 },
	{ 0xE8, 0xBE, 0xAB },
	{ 0xE9, 0x81, 0x8D },
	{ 0xE6, 0xA0, 0x87 },
	{ 0xE5, 0xBD, 0xAA },
	{ 0xE8, 0x86, 0x98 },
	{ 0xE8, 0xA1, 0xA8 },
	{ 0xE9, 0xB3, 0x96 },
	{ 0xE6, 0x86, 0x8B },
	{ 0xE5, 0x88, 0xAB },
	{ 0xE7, 0x98, 0xAA },
	{ 0xE5, 0xBD, 0xAC },
	{ 0xE6, 0x96, 0x8C },
	{ 0xE6, 0xBF, 0x92 },
	{ 0xE6, 0xBB, 0xA8 },
	{ 0xE5, 0xAE, 0xBE },
	{ 0xE6, 0x91, 0x88 },
	{ 0xE5, 0x85, 0xB5 },
	{ 0xE5, 0x86, 0xB0 },
	{ 0xE6, 0x9F, 0x84 },
	{ 0xE4, 0xB8, 0x99 },
	{ 0xE7, 0xA7, 0x89 },
	{ 0xE9, 0xA5, 0xBC },
	{ 0xE7, 0x82, 0xB3 },
	{ 0xE7, 0x97, 0x85 },
	{ 0xE5, 0xB9, 0xB6 },
	{ 0xE7, 0x8E, 0xBB },
	{ 0xE8, 0x8F, 0xA0 },
	{ 0xE6, 0x92, 0xAD },
	{ 0xE6, 0x8B, 0xA8 },
	{ 0xE9, 0x92, 0xB5 },
	{ 0xE6, 0xB3, 0xA2 },
	{ 0xE5, 0x8D, 0x9A },
	{ 0xE5, 0x8B, 0x83 },
	{ 0xE6, 0x90, 0x8F },
	{ 0xE9, 0x93, 0x82 },
	{ 0xE7, 0xAE, 0x94 },
	{ 0xE4, 0xBC, 0xAF },
	{ 0xE5, 0xB8, 0x9B },
	{ 0xE8, 0x88, 0xB6 },
	{ 0xE8, 0x84, 0x96 },
	{ 0xE8, 0x86, 0x8A },
	{ 0xE6, 0xB8, 0xA4 },
	{ 0xE6, 0xB3, 0x8A },
	{ 0xE9, 0xA9, 0xB3 },
	{ 0xE6, 0x8D, 0x95 },
	{ 0xE5, 0x8D, 0x9C },
	{ 0xE5, 0x93, 0xBA },
	{ 0xE8, 0xA1, 0xA5 },
	{ 0xE5, 0x9F, 0xA0 },
	{ 0xE4, 0xB8, 0x8D },
	{ 0xE5, 0xB8, 0x83 },
	{ 0xE6, 0xAD, 0xA5 },
	{ 0xE7, 0xB0, 0xBF },
	{ 0xE9, 0x83, 0xA8 },
	{ 0xE6, 0x80, 0x96 },
	{ 0xE6, 0x93, 0xA6 },
	{ 0xE7, 0x8C, 0x9C },
	{ 0xE8, 0xA3, 0x81 },
	{ 0xE6, 0x9D, 0x90 },
	{ 0xE6, 0x89, 0x8D },
	{ 0xE8, 0xB4, 0xA2 },
	{ 0xE7, 0x9D, 0xAC },
	{ 0xE8, 0xB8, 0xA9 },
	{ 0xE9, 0x87, 0x87 },
	{ 0xE5, 0xBD, 0xA9 },
	{ 0xE8, 0x8F, 0x9C },
	{ 0xE8, 0x94, 0xA1 },
	{ 0xE9, 0xA4, 0x90 },
	{ 0xE5, 0x8F, 0x82 },
	{ 0xE8, 0x9A, 0x95 },
	{ 0xE6, 0xAE, 0x8B },
	{ 0xE6, 0x83, 0xAD },
	{ 0xE6, 0x83, 0xA8 },
	{ 0xE7, 0x81, 0xBF },
	{ 0xE8, 0x8B, 0x8D },
	{ 0xE8, 0x88, 0xB1 },
	{ 0xE4, 0xBB, 0x93 },
	{ 0xE6, 0xB2, 0xA7 },
	{ 0xE8, 0x97, 0x8F },
	{ 0xE6, 0x93, 0x8D },
	{ 0xE7, 0xB3, 0x99 },
	{ 0xE6, 0xA7, 0xBD },
	{ 0xE6, 0x9B, 0xB9 },
	{ 0xE8, 0x8D, 0x89 },
	{ 0xE5, 0x8E, 0x95 },
	{ 0xE7, 0xAD, 0x96 },
	{ 0xE4, 0xBE, 0xA7 },
	{ 0xE5, 0x86, 0x8C },
	{ 0xE6, 0xB5, 0x8B },
	{ 0xE5, 0xB1, 0x82 },
	{ 0xE8, 0xB9, 0xAD },
	{ 0xE6, 0x8F, 0x92 },
	{ 0xE5, 0x8F, 0x89 },
	{ 0xE8, 0x8C, 0xAC },
	{ 0xE8, 0x8C, 0xB6 },
	{ 0xE6, 0x9F, 0xA5 },
	{ 0xE7, 0xA2, 0xB4 },
	{ 0xE6, 0x90, 0xBD },
	{ 0xE5, 0xAF, 0x9F },
	{ 0xE5, 0xB2, 0x94 },
	{ 0xE5, 0xB7, 0xAE },
	{ 0xE8, 0xAF, 0xA7 },
	{ 0xE6, 0x8B, 0x86 },
	{ 0xE6, 0x9F, 0xB4 },
	{ 0xE8, 0xB1, 0xBA },
	{ 0xE6, 0x90, 0x80 },
	{ 0xE6, 0x8E, 0xBA },
	{ 0xE8, 0x9D, 0x89 },
	{ 0xE9, 0xA6, 0x8B },
	{ 0xE8, 0xB0, 0x97 },
	{ 0xE7, 0xBC, 0xA0 },
	{ 0xE9, 0x93, 0xB2 },
	{ 0xE4, 0xBA, 0xA7 },
	{ 0xE9, 0x98, 0x90 },
	{ 0xE9, 0xA2, 0xA4 },
	{ 0xE6, 0x98, 0x8C },
	{ 0xE7, 0x8C, 0x96 },
	{ 0xE5, 0x9C, 0xBA },
	{ 0xE5, 0xB0, 0x9D },
	{ 0xE5, 0xB8, 0xB8 },
	{ 0xE9, 0x95, 0xBF },
	{ 0xE5, 0x81, 0xBF },
	{ 0xE8, 0x82, 0xA0 },
	{ 0xE5, 0x8E, 0x82 },
	{ 0xE6, 0x95, 0x9E },
	{ 0xE7, 0x95, 0x85 },
	{ 0xE5, 0x94, 0xB1 },
	{ 0xE5, 0x80, 0xA1 },
	{ 0xE8, 0xB6, 0x85 },
	{ 0xE6, 0x8A, 0x84 },
	{ 0xE9, 0x92, 0x9E },
	{ 0xE6, 0x9C, 0x9D },
	{ 0xE5, 0x98, 0xB2 },
	{ 0xE6, 0xBD, 0xAE },
	{ 0xE5, 0xB7, 0xA2 },
	{ 0xE5, 0x90, 0xB5 },
	{ 0xE7, 0x82, 0x92 },
	{ 0xE8, 0xBD, 0xA6 },
	{ 0xE6, 0x89, 0xAF },
	{ 0xE6, 0x92, 0xA4 },
	{ 0xE6, 0x8E, 0xA3 },
	{ 0xE5, 0xBD, 0xBB },
	{ 0xE6, 0xBE, 0x88 },
	{ 0xE9, 0x83, 0xB4 },
	{ 0xE8, 0x87, 0xA3 },
	{ 0xE8, 0xBE, 0xB0 },
	{ 0xE5, 0xB0, 0x98 },
	{ 0xE6, 0x99, 0xA8 },
	{ 0xE5, 0xBF, 0xB1 },
	{ 0xE6, 0xB2, 0x89 },
	{ 0xE9, 0x99, 0x88 },
	{ 0xE8, 0xB6, 0x81 },
	{ 0xE8, 0xA1, 0xAC },
	{ 0xE6, 0x92, 0x91 },
	{ 0xE7, 0xA7, 0xB0 },
	{ 0xE5, 0x9F, 0x8E },
	{ 0xE6, 0xA9, 0x99 },
	{ 0xE6, 0x88, 0x90 },
	{ 0xE5, 0x91, 0x88 },
	{ 0xE4, 0xB9, 0x98 },
	{ 0xE7, 0xA8, 0x8B },
	{ 0xE6, 0x83, 0xA9 },
	{ 0xE6, 0xBE, 0x84 },
	{ 0xE8, 0xAF, 0x9A },
	{ 0xE6, 0x89, 0xBF },
	{ 0xE9, 0x80, 0x9E },
	{ 0xE9, 0xAA, 0x8B },
	{ 0xE7, 0xA7, 0xA4 },
	{ 0xE5, 0x90, 0x83 },
	{ 0xE7, 0x97, 0xB4 },
	{ 0xE6, 0x8C, 0x81 },
	{ 0xE5, 0x8C, 0x99 },
	{ 0xE6, 0xB1, 0xA0 },
	{ 0xE8, 0xBF, 0x9F },
	{ 0xE5, 0xBC, 0x9B },
	{ 0xE9, 0xA9, 0xB0 },
	{ 0xE8, 0x80, 0xBB },
	{ 0xE9, 0xBD, 0xBF },
	{ 0xE4, 0xBE, 0x88 },
	{ 0xE5, 0xB0, 0xBA },
	{ 0xE8, 0xB5, 0xA4 },
	{ 0xE7, 0xBF, 0x85 },
	{ 0xE6, 0x96, 0xA5 },
	{ 0xE7, 0x82, 0xBD },
	{ 0xE5, 0x85, 0x85 },
	{ 0xE5, 0x86, 0xB2 },
	{ 0xE8, 0x99, 0xAB },
	{ 0xE5, 0xB4, 0x87 },
	{ 0xE5, 0xAE, 0xA0 },
	{ 0xE6, 0x8A, 0xBD },
	{ 0xE9, 0x85, 0xAC },
	{ 0xE7, 0x95, 0xB4 },
	{ 0xE8, 0xB8, 0x8C },
	{ 0xE7, 0xA8, 0xA0 },
	{ 0xE6, 0x84, 0x81 },
	{ 0xE7, 0xAD, 0xB9 },
	{ 0xE4, 0xBB, 0x87 },
	{ 0xE7, 0xBB, 0xB8 },
	{ 0xE7, 0x9E, 0x85 },
	{ 0xE4, 0xB8, 0x91 },
	{ 0xE8, 0x87, 0xAD },
	{ 0xE5, 0x88, 0x9D },
	{ 0xE5, 0x87, 0xBA },
	{ 0xE6, 0xA9, 0xB1 },
	{ 0xE5, 0x8E, 0xA8 },
	{ 0xE8, 0xBA, 0x87 },
	{ 0xE9, 0x94, 0x84 },
	{ 0xE9, 0x9B, 0x8F },
	{ 0xE6, 0xBB, 0x81 },
	{ 0xE9, 0x99, 0xA4 },
	{ 0xE6, 0xA5, 0x9A },
	{ 0xE7, 0xA1, 0x80 },
	{ 0xE5, 0x82, 0xA8 },
	{ 0xE7, 0x9F, 0x97 },
	{ 0xE6, 0x90, 0x90 },
	{ 0xE8, 0xA7, 0xA6 },
	{ 0xE5, 0xA4, 0x84 },
	{ 0xE6, 0x8F, 0xA3 },
	{ 0xE5, 0xB7, 0x9D },
	{ 0xE7, 0xA9, 0xBF },
	{ 0xE6, 0xA4, 0xBD },
	{ 0xE4, 0xBC, 0xA0 },
	{ 0xE8, 0x88, 0xB9 },
	{ 0xE5, 0x96, 0x98 },
	{ 0xE4, 0xB8, 0xB2 },
	{ 0xE7, 0x96, 0xAE },
	{ 0xE7, 0xAA, 0x97 },
	{ 0xE5, 0xB9, 0xA2 },
	{ 0xE5, 0xBA, 0x8A },
	{ 0xE9, 0x97, 0xAF },
	{ 0xE5, 0x88, 0x9B },
	{ 0xE5, 0x90, 0xB9 },
	{ 0xE7, 0x82, 0x8A },
	{ 0xE6, 0x8D, 0xB6 },
	{ 0xE9, 0x94, 0xA4 },
	{ 0xE5, 0x9E, 0x82 },
	{ 0xE6, 0x98, 0xA5 },
	{ 0xE6, 0xA4, 0xBF },
	{ 0xE9, 0x86, 0x87 },
	{ 0xE5, 0x94, 0x87 },
	{ 0xE6, 0xB7, 0xB3 },
	{ 0xE7, 0xBA, 0xAF },
	{ 0xE8, 0xA0, 0xA2 },
	{ 0xE6, 0x88, 0xB3 },
	{ 0xE7, 0xBB, 0xB0 },
	{ 0xE7, 0x96, 0xB5 },
	{ 0xE8, 0x8C, 0xA8 },
	{ 0xE7, 0xA3, 0x81 },
	{ 0xE9, 0x9B, 0x8C },
	{ 0xE8, 0xBE, 0x9E },
	{ 0xE6, 0x85, 0x88 },
	{ 0xE7, 0x93, 0xB7 },
	{ 0xE8, 0xAF, 0x8D },
	{ 0xE6, 0xAD, 0xA4 },
	{ 0xE5, 0x88, 0xBA },
	{ 0xE8, 0xB5, 0x90 },
	{ 0xE6, 0xAC, 0xA1 },
	{ 0xE8, 0x81, 0xAA },
	{ 0xE8, 0x91, 0xB1 },
	{ 0xE5, 0x9B, 0xB1 },
	{ 0xE5, 0x8C, 0x86 },
	{ 0xE4, 0xBB, 0x8E },
	{ 0xE4, 0xB8, 0x9B },
	{ 0xE5, 0x87, 0x91 },
	{ 0xE7, 0xB2, 0x97 },
	{ 0xE9, 0x86, 0x8B },
	{ 0xE7, 0xB0, 0x87 },
	{ 0xE4, 0xBF, 0x83 },
	{ 0xE8, 0xB9, 0xBF },
	{ 0xE7, 0xAF, 0xA1 },
	{ 0xE7, 0xAA, 0x9C },
	{ 0xE6, 0x91, 0xA7 },
	{ 0xE5, 0xB4, 0x94 },
	{ 0xE5, 0x82, 0xAC },
	{ 0xE8, 0x84, 0x86 },
	{ 0xE7, 0x98, 0x81 },
	{ 0xE7, 0xB2, 0xB9 },
	{ 0xE6, 0xB7, 0xAC },
	{ 0xE7, 0xBF, 0xA0 },
	{ 0xE6, 0x9D, 0x91 },
	{ 0xE5, 0xAD, 0x98 },
	{ 0xE5, 0xAF, 0xB8 },
	{ 0xE7, 0xA3, 0x8B },
	{ 0xE6, 0x92, 0xAE },
	{ 0xE6, 0x90, 0x93 },
	{ 0xE6, 0x8E, 0xAA },
	{ 0xE6, 0x8C, 0xAB },
	{ 0xE9, 0x94, 0x99 },
	{ 0xE6, 0x90, 0xAD },
	{ 0xE8, 0xBE, 0xBE },
	{ 0xE7, 0xAD, 0x94 },
	{ 0xE7, 0x98, 0xA9 },
	{ 0xE6, 0x89, 0x93 },
	{ 0xE5, 0xA4, 0xA7 },
	{ 0xE5, 0x91, 0x86 },
	{ 0xE6, 0xAD, 0xB9 },
	{ 0xE5, 0x82, 0xA3 },
	{ 0xE6, 0x88, 0xB4 },
	{ 0xE5, 0xB8, 0xA6 },
	{ 0xE6, 0xAE, 0x86 },
	{ 0xE4, 0xBB, 0xA3 },
	{ 0xE8, 0xB4, 0xB7 },
	{ 0xE8, 0xA2, 0x8B },
	{ 0xE5, 0xBE, 0x85 },
	{ 0xE9, 0x80, 0xAE },
	{ 0xE6, 0x80, 0xA0 },
	{ 0xE8, 0x80, 0xBD },
	{ 0xE6, 0x8B, 0x85 },
	{ 0xE4, 0xB8, 0xB9 },
	{ 0xE5, 0x8D, 0x95 },
	{ 0xE9, 0x83, 0xB8 },
	{ 0xE6, 0x8E, 0xB8 },
	{ 0xE8, 0x83, 0x86 },
	{ 0xE6, 0x97, 0xA6 },
	{ 0xE6, 0xB0, 0xAE },
	{ 0xE4, 0xBD, 0x86 },
	{ 0xE6, 0x83, 0xAE },
	{ 0xE6, 0xB7, 0xA1 },
	{ 0xE8, 0xAF, 0x9E },
	{ 0xE5, 0xBC, 0xB9 },
	{ 0xE8, 0x9B, 0x8B },
	{ 0xE5, 0xBD, 0x93 },
	{ 0xE6, 0x8C, 0xA1 },
	{ 0xE5, 0x85, 0x9A },
	{ 0xE8, 0x8D, 0xA1 },
	{ 0xE6, 0xA1, 0xA3 },
	{ 0xE5, 0x88, 0x80 },
	{ 0xE6, 0x8D, 0xA3 },
	{ 0xE8, 0xB9, 0x88 },
	{ 0xE5, 0x80, 0x92 },
	{ 0xE5, 0xB2, 0x9B },
	{ 0xE7, 0xA5, 0xB7 },
	{ 0xE5, 0xAF, 0xBC },
	{ 0xE5, 0x88, 0xB0 },
	{ 0xE7, 0xA8, 0xBB },
	{ 0xE6, 0x82, 0xBC },
	{ 0xE9, 0x81, 0x93 },
	{ 0xE7, 0x9B, 0x97 },
	{ 0xE5, 0xBE, 0xB7 },
	{ 0xE5, 0xBE, 0x97 },
	{ 0xE7, 0x9A, 0x84 },
	{ 0xE8, 0xB9, 0xAC },
	{ 0xE7, 0x81, 0xAF },
	{ 0xE7, 0x99, 0xBB },
	{ 0xE7, 0xAD, 0x89 },
	{ 0xE7, 0x9E, 0xAA },
	{ 0xE5, 0x87, 0xB3 },
	{ 0xE9, 0x82, 0x93 },
	{ 0xE5, 0xA0, 0xA4 },
	{ 0xE4, 0xBD, 0x8E },
	{ 0xE6, 0xBB, 0xB4 },
	{ 0xE8, 0xBF, 0xAA },
	{ 0xE6, 0x95, 0x8C },
	{ 0xE7, 0xAC, 0x9B },
	{ 0xE7, 0x8B, 0x84 },
	{ 0xE6, 0xB6, 0xA4 },
	{ 0xE7, 0xBF, 0x9F },
	{ 0xE5, 0xAB, 0xA1 },
	{ 0xE6, 0x8A, 0xB5 },
	{ 0xE5, 0xBA, 0x95 },
	{ 0xE5, 0x9C, 0xB0 },
	{ 0xE8, 0x92, 0x82 },
	{ 0xE7, 0xAC, 0xAC },
	{ 0xE5, 0xB8, 0x9D },
	{ 0xE5, 0xBC, 0x9F },
	{ 0xE9, 0x80, 0x92 },
	{ 0xE7, 0xBC, 0x94 },
	{ 0xE9, 0xA2, 0xA0 },
	{ 0xE6, 0x8E, 0x82 },
	{ 0xE6, 0xBB, 0x87 },
	{ 0xE7, 0xA2, 0x98 },
	{ 0xE7, 0x82, 0xB9 },
	{ 0xE5, 0x85, 0xB8 },
	{ 0xE9, 0x9D, 0x9B },
	{ 0xE5, 0x9E, 0xAB },
	{ 0xE7, 0x94, 0xB5 },
	{ 0xE4, 0xBD, 0x83 },
	{ 0xE7, 0x94, 0xB8 },
	{ 0xE5, 0xBA, 0x97 },
	{ 0xE6, 0x83, 0xA6 },
	{ 0xE5, 0xA5, 0xA0 },
	{ 0xE6, 0xB7, 0x80 },
	{ 0xE6, 0xAE, 0xBF },
	{ 0xE7, 0xA2, 0x89 },
	{ 0xE5, 0x8F, 0xBC },
	{ 0xE9, 0x9B, 0x95 },
	{ 0xE5, 0x87, 0x8B },
	{ 0xE5, 0x88, 0x81 },
	{ 0xE6, 0x8E, 0x89 },
	{ 0xE5, 0x90, 0x8A },
	{ 0xE9, 0x92, 0x93 },
	{ 0xE8, 0xB0, 0x83 },
	{ 0xE8, 0xB7, 0x8C },
	{ 0xE7, 0x88, 0xB9 },
	{ 0xE7, 0xA2, 0x9F },
	{ 0xE8, 0x9D, 0xB6 },
	{ 0xE8, 0xBF, 0xAD },
	{ 0xE8, 0xB0, 0x8D },
	{ 0xE5, 0x8F, 0xA0 },
	{ 0xE4, 0xB8, 0x81 },
	{ 0xE7, 0x9B, 0xAF },
	{ 0xE5, 0x8F, 0xAE },
	{ 0xE9, 0x92, 0x89 },
	{ 0xE9, 0xA1, 0xB6 },
	{ 0xE9, 0xBC, 0x8E },
	{ 0xE9, 0x94, 0xAD },
	{ 0xE5, 0xAE, 0x9A },
	{ 0xE8, 0xAE, 0xA2 },
	{ 0xE4, 0xB8, 0xA2 },
	{ 0xE4, 0xB8, 0x9C },
	{ 0xE5, 0x86, 0xAC },
	{ 0xE8, 0x91, 0xA3 },
	{ 0xE6, 0x87, 0x82 },
	{ 0xE5, 0x8A, 0xA8 },
	{ 0xE6, 0xA0, 0x8B },
	{ 0xE4, 0xBE, 0x97 },
	{ 0xE6, 0x81, 0xAB },
	{ 0xE5, 0x86, 0xBB },
	{ 0xE6, 0xB4, 0x9E },
	{ 0xE5, 0x85, 0x9C },
	{ 0xE6, 0x8A, 0x96 },
	{ 0xE6, 0x96, 0x97 },
	{ 0xE9, 0x99, 0xA1 },
	{ 0xE8, 0xB1, 0x86 },
	{ 0xE9, 0x80, 0x97 },
	{ 0xE7, 0x97, 0x98 },
	{ 0xE9, 0x83, 0xBD },
	{ 0xE7, 0x9D, 0xA3 },
	{ 0xE6, 0xAF, 0x92 },
	{ 0xE7, 0x8A, 0x8A },
	{ 0xE7, 0x8B, 0xAC },
	{ 0xE8, 0xAF, 0xBB },
	{ 0xE5, 0xA0, 0xB5 },
	{ 0xE7, 0x9D, 0xB9 },
	{ 0xE8, 0xB5, 0x8C },
	{ 0xE6, 0x9D, 0x9C },
	{ 0xE9, 0x95, 0x80 },
	{ 0xE8, 0x82, 0x9A },
	{ 0xE5, 0xBA, 0xA6 },
	{ 0xE6, 0xB8, 0xA1 },
	{ 0xE5, 0xA6, 0x92 },
	{ 0xE7, 0xAB, 0xAF },
	{ 0xE7, 0x9F, 0xAD },
	{ 0xE9, 0x94, 0xBB },
	{ 0xE6, 0xAE, 0xB5 },
	{ 0xE6, 0x96, 0xAD },
	{ 0xE7, 0xBC, 0x8E },
	{ 0xE5, 0xA0, 0x86 },
	{ 0xE5, 0x85, 0x91 },
	{ 0xE9, 0x98, 0x9F },
	{ 0xE5, 0xAF, 0xB9 },
	{ 0xE5, 0xA2, 0xA9 },
	{ 0xE5, 0x90, 0xA8 },
	{ 0xE8, 0xB9, 0xB2 },
	{ 0xE6, 0x95, 0xA6 },
	{ 0xE9, 0xA1, 0xBF },
	{ 0xE5, 0x9B, 0xA4 },
	{ 0xE9, 0x92, 0x9D },
	{ 0xE7, 0x9B, 0xBE },
	{ 0xE9, 0x81, 0x81 },
	{ 0xE6, 0x8E, 0x87 },
	{ 0xE5, 0x93, 0x86 },
	{ 0xE5, 0xA4, 0x9A },
	{ 0xE5, 0xA4, 0xBA },
	{ 0xE5, 0x9E, 0x9B },
	{ 0xE8, 0xBA, 0xB2 },
	{ 0xE6, 0x9C, 0xB5 },
	{ 0xE8, 0xB7, 0xBA },
	{ 0xE8, 0x88, 0xB5 },
	{ 0xE5, 0x89, 0x81 },
	{ 0xE6, 0x83, 0xB0 },
	{ 0xE5, 0xA0, 0x95 },
	{ 0xE8, 0x9B, 0xBE },
	{ 0xE5, 0xB3, 0xA8 },
	{ 0xE9, 0xB9, 0x85 },
	{ 0xE4, 0xBF, 0x84 },
	{ 0xE9, 0xA2, 0x9D },
	{ 0xE8, 0xAE, 0xB9 },
	{ 0xE5, 0xA8, 0xA5 },
	{ 0xE6, 0x81, 0xB6 },
	{ 0xE5, 0x8E, 0x84 },
	{ 0xE6, 0x89, 0xBC },
	{ 0xE9, 0x81, 0x8F },
	{ 0xE9, 0x84, 0x82 },
	{ 0xE9, 0xA5, 0xBF },
	{ 0xE6, 0x81, 0xA9 },
	{ 0xE8, 0x80, 0x8C },
	{ 0xE5, 0x84, 0xBF },
	{ 0xE8, 0x80, 0xB3 },
	{ 0xE5, 0xB0, 0x94 },
	{ 0xE9, 0xA5, 0xB5 },
	{ 0xE6, 0xB4, 0xB1 },
	{ 0xE4, 0xBA, 0x8C },
	{ 0xE8, 0xB4, 0xB0 },
	{ 0xE5, 0x8F, 0x91 },
	{ 0xE7, 0xBD, 0x9A },
	{ 0xE7, 0xAD, 0x8F },
	{ 0xE4, 0xBC, 0x90 },
	{ 0xE4, 0xB9, 0x8F },
	{ 0xE9, 0x98, 0x80 },
	{ 0xE6, 0xB3, 0x95 },
	{ 0xE7, 0x8F, 0x90 },
	{ 0xE8, 0x97, 0xA9 },
	{ 0xE5, 0xB8, 0x86 },
	{ 0xE7, 0x95, 0xAA },
	{ 0xE7, 0xBF, 0xBB },
	{ 0xE6, 0xA8, 0x8A },
	{ 0xE7, 0x9F, 0xBE },
	{ 0xE9, 0x92, 0x92 },
	{ 0xE7, 0xB9, 0x81 },
	{ 0xE5, 0x87, 0xA1 },
	{ 0xE7, 0x83, 0xA6 },
	{ 0xE5, 0x8F, 0x8D },
	{ 0xE8, 0xBF, 0x94 },
	{ 0xE8, 0x8C, 0x83 },
	{ 0xE8, 0xB4, 0xA9 },
	{ 0xE7, 0x8A, 0xAF },
	{ 0xE9, 0xA5, 0xAD },
	{ 0xE6, 0xB3, 0x9B },
	{ 0xE5, 0x9D, 0x8A },
	{ 0xE8, 0x8A, 0xB3 },
	{ 0xE6, 0x96, 0xB9 },
	{ 0xE8, 0x82, 0xAA },
	{ 0xE6, 0x88, 0xBF },
	{ 0xE9, 0x98, 0xB2 },
	{ 0xE5, 0xA6, 0xA8 },
	{ 0xE4, 0xBB, 0xBF },
	{ 0xE8, 0xAE, 0xBF },
	{ 0xE7, 0xBA, 0xBA },
	{ 0xE6, 0x94, 0xBE },
	{ 0xE8, 0x8F, 0xB2 },
	{ 0xE9, 0x9D, 0x9E },
	{ 0xE5, 0x95, 0xA1 },
	{ 0xE9, 0xA3, 0x9E },
	{ 0xE8, 0x82, 0xA5 },
	{ 0xE5, 0x8C, 0xAA },
	{ 0xE8, 0xAF, 0xBD },
	{ 0xE5, 0x90, 0xA0 },
	{ 0xE8, 0x82, 0xBA },
	{ 0xE5, 0xBA, 0x9F },
	{ 0xE6, 0xB2, 0xB8 },
	{ 0xE8, 0xB4, 0xB9 },
	{ 0xE8, 0x8A, 0xAC },
	{ 0xE9, 0x85, 0x9A },
	{ 0xE5, 0x90, 0xA9 },
	{ 0xE6, 0xB0, 0x9B },
	{ 0xE5, 0x88, 0x86 },
	{ 0xE7, 0xBA, 0xB7 },
	{ 0xE5, 0x9D, 0x9F },
	{ 0xE7, 0x84, 0x9A },
	{ 0xE6, 0xB1, 0xBE },
	{ 0xE7, 0xB2, 0x89 },
	{ 0xE5, 0xA5, 0x8B },
	{ 0xE4, 0xBB, 0xBD },
	{ 0xE5, 0xBF, 0xBF },
	{ 0xE6, 0x84, 0xA4 },
	{ 0xE7, 0xB2, 0xAA },
	{ 0xE4, 0xB8, 0xB0 },
	{ 0xE5, 0xB0, 0x81 },
	{ 0xE6, 0x9E, 0xAB },
	{ 0xE8, 0x9C, 0x82 },
	{ 0xE5, 0xB3, 0xB0 },
	{ 0xE9, 0x94, 0x8B },
	{ 0xE9, 0xA3, 0x8E },
	{ 0xE7, 0x96, 0xAF },
	{ 0xE7, 0x83, 0xBD },
	{ 0xE9, 0x80, 0xA2 },
	{ 0xE5, 0x86, 0xAF },
	{ 0xE7, 0xBC, 0x9D },
	{ 0xE8, 0xAE, 0xBD },
	{ 0xE5, 0xA5, 0x89 },
	{ 0xE5, 0x87, 0xA4 },
	{ 0xE4, 0xBD, 0x9B },
	{ 0xE5, 0x90, 0xA6 },
	{ 0xE5, 0xA4, 0xAB },
	{ 0xE6, 0x95, 0xB7 },
	{ 0xE8, 0x82, 0xA4 },
	{ 0xE5, 0xAD, 0xB5 },
	{ 0xE6, 0x89, 0xB6 },
	{ 0xE6, 0x8B, 0x82 },
	{ 0xE8, 0xBE, 0x90 },
	{ 0xE5, 0xB9, 0x85 },
	{ 0xE6, 0xB0, 0x9F },
	{ 0xE7, 0xAC, 0xA6 },
	{ 0xE4, 0xBC, 0x8F },
	{ 0xE4, 0xBF, 0x98 },
	{ 0xE6, 0x9C, 0x8D },
	{ 0xE6, 0xB5, 0xAE },
	{ 0xE6, 0xB6, 0xAA },
	{ 0xE7, 0xA6, 0x8F },
	{ 0xE8, 0xA2, 0xB1 },
	{ 0xE5, 0xBC, 0x97 },
	{ 0xE7, 0x94, 0xAB },
	{ 0xE6, 0x8A, 0x9A },
	{ 0xE8, 0xBE, 0x85 },
	{ 0xE4, 0xBF, 0xAF },
	{ 0xE9, 0x87, 0x9C },
	{ 0xE6, 0x96, 0xA7 },
	{ 0xE8, 0x84, 0xAF },
	{ 0xE8, 0x85, 0x91 },
	{ 0xE5, 0xBA, 0x9C },
	{ 0xE8, 0x85, 0x90 },
	{ 0xE8, 0xB5, 0xB4 },
	{ 0xE5, 0x89, 0xAF },
	{ 0xE8, 0xA6, 0x86 },
	{ 0xE8, 0xB5, 0x8B },
	{ 0xE5, 0xA4, 0x8D },
	{ 0xE5, 0x82, 0x85 },
	{ 0xE4, 0xBB, 0x98 },
	{ 0xE9, 0x98, 0x9C },
	{ 0xE7, 0x88, 0xB6 },
	{ 0xE8, 0x85, 0xB9 },
	{ 0xE8, 0xB4, 0x9F },
	{ 0xE5, 0xAF, 0x8C },
	{ 0xE8, 0xAE, 0xA3 },
	{ 0xE9, 0x99, 0x84 },
	{ 0xE5, 0xA6, 0x87 },
	{ 0xE7, 0xBC, 0x9A },
	{ 0xE5, 0x92, 0x90 },
	{ 0xE5, 0x99, 0xB6 },
	{ 0xE5, 0x98, 0x8E },
	{ 0xE8, 0xAF, 0xA5 },
	{ 0xE6, 0x94, 0xB9 },
	{ 0xE6, 0xA6, 0x82 },
	{ 0xE9, 0x92, 0x99 },
	{ 0xE7, 0x9B, 0x96 },
	{ 0xE6, 0xBA, 0x89 },
	{ 0xE5, 0xB9, 0xB2 },
	{ 0xE7, 0x94, 0x98 },
	{ 0xE6, 0x9D, 0x86 },
	{ 0xE6, 0x9F, 0x91 },
	{ 0xE7, 0xAB, 0xBF },
	{ 0xE8, 0x82, 0x9D },
	{ 0xE8, 0xB5, 0xB6 },
	{ 0xE6, 0x84, 0x9F },
	{ 0xE7, 0xA7, 0x86 },
	{ 0xE6, 0x95, 0xA2 },
	{ 0xE8, 0xB5, 0xA3 },
	{ 0xE5, 0x86, 0x88 },
	{ 0xE5, 0x88, 0x9A },
	{ 0xE9, 0x92, 0xA2 },
	{ 0xE7, 0xBC, 0xB8 },
	{ 0xE8, 0x82, 0x9B },
	{ 0xE7, 0xBA, 0xB2 },
	{ 0xE5, 0xB2, 0x97 },
	{ 0xE6, 0xB8, 0xAF },
	{ 0xE6, 0x9D, 0xA0 },
	{ 0xE7, 0xAF, 0x99 },
	{ 0xE7, 0x9A, 0x8B },
	{ 0xE9, 0xAB, 0x98 },
	{ 0xE8, 0x86, 0x8F },
	{ 0xE7, 0xBE, 0x94 },
	{ 0xE7, 0xB3, 0x95 },
	{ 0xE6, 0x90, 0x9E },
	{ 0xE9, 0x95, 0x90 },
	{ 0xE7, 0xA8, 0xBF },
	{ 0xE5, 0x91, 0x8A },
	{ 0xE5, 0x93, 0xA5 },
	{ 0xE6, 0xAD, 0x8C },
	{ 0xE6, 0x90, 0x81 },
	{ 0xE6, 0x88, 0x88 },
	{ 0xE9, 0xB8, 0xBD },
	{ 0xE8, 0x83, 0xB3 },
	{ 0xE7, 0x96, 0x99 },
	{ 0xE5, 0x89, 0xB2 },
	{ 0xE9, 0x9D, 0xA9 },
	{ 0xE8, 0x91, 0x9B },
	{ 0xE6, 0xA0, 0xBC },
	{ 0xE8, 0x9B, 0xA4 },
	{ 0xE9, 0x98, 0x81 },
	{ 0xE9, 0x9A, 0x94 },
	{ 0xE9, 0x93, 0xAC },
	{ 0xE4, 0xB8, 0xAA },
	{ 0xE5, 0x90, 0x84 },
	{ 0xE7, 0xBB, 0x99 },
	{ 0xE6, 0xA0, 0xB9 },
	{ 0xE8, 0xB7, 0x9F },
	{ 0xE8, 0x80, 0x95 },
	{ 0xE6, 0x9B, 0xB4 },
	{ 0xE5, 0xBA, 0x9A },
	{ 0xE7, 0xBE, 0xB9 },
	{ 0xE5, 0x9F, 0x82 },
	{ 0xE8, 0x80, 0xBF },
	{ 0xE6, 0xA2, 0x97 },
	{ 0xE5, 0xB7, 0xA5 },
	{ 0xE6, 0x94, 0xBB },
	{ 0xE5, 0x8A, 0x9F },
	{ 0xE6, 0x81, 0xAD },
	{ 0xE9, 0xBE, 0x9A },
	{ 0xE4, 0xBE, 0x9B },
	{ 0xE8, 0xBA, 0xAC },
	{ 0xE5, 0x85, 0xAC },
	{ 0xE5, 0xAE, 0xAB },
	{ 0xE5, 0xBC, 0x93 },
	{ 0xE5, 0xB7, 0xA9 },
	{ 0xE6, 0xB1, 0x9E },
	{ 0xE6, 0x8B, 0xB1 },
	{ 0xE8, 0xB4, 0xA1 },
	{ 0xE5, 0x85, 0xB1 },
	{ 0xE9, 0x92, 0xA9 },
	{ 0xE5, 0x8B, 0xBE },
	{ 0xE6, 0xB2, 0x9F },
	{ 0xE8, 0x8B, 0x9F },
	{ 0xE7, 0x8B, 0x97 },
	{ 0xE5, 0x9E, 0xA2 },
	{ 0xE6, 0x9E, 0x84 },
	{ 0xE8, 0xB4, 0xAD },
	{ 0xE5, 0xA4, 0x9F },
	{ 0xE8, 0xBE, 0x9C },
	{ 0xE8, 0x8F, 0x87 },
	{ 0xE5, 0x92, 0x95 },
	{ 0xE7, 0xAE, 0x8D },
	{ 0xE4, 0xBC, 0xB0 },
	{ 0xE6, 0xB2, 0xBD },
	{ 0xE5, 0xAD, 0xA4 },
	{ 0xE5, 0xA7, 0x91 },
	{ 0xE9, 0xBC, 0x93 },
	{ 0xE5, 0x8F, 0xA4 },
	{ 0xE8, 0x9B, 0x8A },
	{ 0xE9, 0xAA, 0xA8 },
	{ 0xE8, 0xB0, 0xB7 },
	{ 0xE8, 0x82, 0xA1 },
	{ 0xE6, 0x95, 0x85 },
	{ 0xE9, 0xA1, 0xBE },
	{ 0xE5, 0x9B, 0xBA },
	{ 0xE9, 0x9B, 0x87 },
	{ 0xE5, 0x88, 0xAE },
	{ 0xE7, 0x93, 0x9C },
	{ 0xE5, 0x89, 0x90 },
	{ 0xE5, 0xAF, 0xA1 },
	{ 0xE6, 0x8C, 0x82 },
	{ 0xE8, 0xA4, 0x82 },
	{ 0xE4, 0xB9, 0x96 },
	{ 0xE6, 0x8B, 0x90 },
	{ 0xE6, 0x80, 0xAA },
	{ 0xE6, 0xA3, 0xBA },
	{ 0xE5, 0x85, 0xB3 },
	{ 0xE5, 0xAE, 0x98 },
	{ 0xE5, 0x86, 0xA0 },
	{ 0xE8, 0xA7, 0x82 },
	{ 0xE7, 0xAE, 0xA1 },
	{ 0xE9, 0xA6, 0x86 },
	{ 0xE7, 0xBD, 0x90 },
	{ 0xE6, 0x83, 0xAF },
	{ 0xE7, 0x81, 0x8C },
	{ 0xE8, 0xB4, 0xAF },
	{ 0xE5, 0x85, 0x89 },
	{ 0xE5, 0xB9, 0xBF },
	{ 0xE9, 0x80, 0x9B },
	{ 0xE7, 0x91, 0xB0 },
	{ 0xE8, 0xA7, 0x84 },
	{ 0xE5, 0x9C, 0xAD },
	{ 0xE7, 0xA1, 0x85 },
	{ 0xE5, 0xBD, 0x92 },
	{ 0xE9, 0xBE, 0x9F },
	{ 0xE9, 0x97, 0xBA },
	{ 0xE8, 0xBD, 0xA8 },
	{ 0xE9, 0xAC, 0xBC },
	{ 0xE8, 0xAF, 0xA1 },
	{ 0xE7, 0x99, 0xB8 },
	{ 0xE6, 0xA1, 0x82 },
	{ 0xE6, 0x9F, 0x9C },
	{ 0xE8, 0xB7, 0xAA },
	{ 0xE8, 0xB4, 0xB5 },
	{ 0xE5, 0x88, 0xBD },
	{ 0xE8, 0xBE, 0x8A },
	{ 0xE6, 0xBB, 0x9A },
	{ 0xE6, 0xA3, 0x8D },
	{ 0xE9, 0x94, 0x85 },
	{ 0xE9, 0x83, 0xAD },
	{ 0xE5, 0x9B, 0xBD },
	{ 0xE6, 0x9E, 0x9C },
	{ 0xE8, 0xA3, 0xB9 },
	{ 0xE8, 0xBF, 0x87 },
	{ 0xE5, 0x93, 0x88 },
	{ 0xE9, 0xAA, 0xB8 },
	{ 0xE5, 0xAD, 0xA9 },
	{ 0xE6, 0xB5, 0xB7 },
	{ 0xE6, 0xB0, 0xA6 },
	{ 0xE4, 0xBA, 0xA5 },
	{ 0xE5, 0xAE, 0xB3 },
	{ 0xE9, 0xAA, 0x87 },
	{ 0xE9, 0x85, 0xA3 },
	{ 0xE6, 0x86, 0xA8 },
	{ 0xE9, 0x82, 0xAF },
	{ 0xE9, 0x9F, 0xA9 },
	{ 0xE5, 0x90, 0xAB },
	{ 0xE6, 0xB6, 0xB5 },
	{ 0xE5, 0xAF, 0x92 },
	{ 0xE5, 0x87, 0xBD },
	{ 0xE5, 0x96, 0x8A },
	{ 0xE7, 0xBD, 0x95 },
	{ 0xE7, 0xBF, 0xB0 },
	{ 0xE6, 0x92, 0xBC },
	{ 0xE6, 0x8D, 0x8D },
	{ 0xE6, 0x97, 0xB1 },
	{ 0xE6, 0x86, 0xBE },
	{ 0xE6, 0x82, 0x8D },
	{ 0xE7, 0x84, 0x8A },
	{ 0xE6, 0xB1, 0x97 },
	{ 0xE6, 0xB1, 0x89 },
	{ 0xE5, 0xA4, 0xAF },
	{ 0xE6, 0x9D, 0xAD },
	{ 0xE8, 0x88, 0xAA },
	{ 0xE5, 0xA3, 0x95 },
	{ 0xE5, 0x9A, 0x8E },
	{ 0xE8, 0xB1, 0xAA },
	{ 0xE6, 0xAF, 0xAB },
	{ 0xE9, 0x83, 0x9D },
	{ 0xE5, 0xA5, 0xBD },
	{ 0xE8, 0x80, 0x97 },
	{ 0xE5, 0x8F, 0xB7 },
	{ 0xE6, 0xB5, 0xA9 },
	{ 0xE5, 0x91, 0xB5 },
	{ 0xE5, 0x96, 0x9D },
	{ 0xE8, 0x8D, 0xB7 },
	{ 0xE8, 0x8F, 0x8F },
	{ 0xE6, 0xA0, 0xB8 },
	{ 0xE7, 0xA6, 0xBE },
	{ 0xE5, 0x92, 0x8C },
	{ 0xE4, 0xBD, 0x95 },
	{ 0xE5, 0x90, 0x88 },
	{ 0xE7, 0x9B, 0x92 },
	{ 0xE8, 0xB2, 0x89 },
	{ 0xE9, 0x98, 0x82 },
	{ 0xE6, 0xB2, 0xB3 },
	{ 0xE6, 0xB6, 0xB8 },
	{ 0xE8, 0xB5, 0xAB },
	{ 0xE8, 0xA4, 0x90 },
	{ 0xE9, 0xB9, 0xA4 },
	{ 0xE8, 0xB4, 0xBA },
	{ 0xE5, 0x98, 0xBF },
	{ 0xE9, 0xBB, 0x91 },
	{ 0xE7, 0x97, 0x95 },
	{ 0xE5, 0xBE, 0x88 },
	{ 0xE7, 0x8B, 0xA0 },
	{ 0xE6, 0x81, 0xA8 },
	{ 0xE5, 0x93, 0xBC },
	{ 0xE4, 0xBA, 0xA8 },
	{ 0xE6, 0xA8, 0xAA },
	{ 0xE8, 0xA1, 0xA1 },
	{ 0xE6, 0x81, 0x92 },
	{ 0xE8, 0xBD, 0xB0 },
	{ 0xE5, 0x93, 0x84 },
	{ 0xE7, 0x83, 0x98 },
	{ 0xE8, 0x99, 0xB9 },
	{ 0xE9, 0xB8, 0xBF },
	{ 0xE6, 0xB4, 0xAA },
	{ 0xE5, 0xAE, 0x8F },
	{ 0xE5, 0xBC, 0x98 },
	{ 0xE7, 0xBA, 0xA2 },
	{ 0xE5, 0x96, 0x89 },
	{ 0xE4, 0xBE, 0xAF },
	{ 0xE7, 0x8C, 0xB4 },
	{ 0xE5, 0x90, 0xBC },
	{ 0xE5, 0x8E, 0x9A },
	{ 0xE5, 0x80, 0x99 },
	{ 0xE5, 0x90, 0x8E },
	{ 0xE5, 0x91, 0xBC },
	{ 0xE4, 0xB9, 0x8E },
	{ 0xE5, 0xBF, 0xBD },
	{ 0xE7, 0x91, 0x9A },
	{ 0xE5, 0xA3, 0xB6 },
	{ 0xE8, 0x91, 0xAB },
	{ 0xE8, 0x83, 0xA1 },
	{ 0xE8, 0x9D, 0xB4 },
	{ 0xE7, 0x8B, 0x90 },
	{ 0xE7, 0xB3, 0x8A },
	{ 0xE6, 0xB9, 0x96 },
	{ 0xE5, 0xBC, 0xA7 },
	{ 0xE8, 0x99, 0x8E },
	{ 0xE5, 0x94, 0xAC },
	{ 0xE6, 0x8A, 0xA4 },
	{ 0xE4, 0xBA, 0x92 },
	{ 0xE6, 0xB2, 0xAA },
	{ 0xE6, 0x88, 0xB7 },
	{ 0xE8, 0x8A, 0xB1 },
	{ 0xE5, 0x93, 0x97 },
	{ 0xE5, 0x8D, 0x8E },
	{ 0xE7, 0x8C, 0xBE },
	{ 0xE6, 0xBB, 0x91 },
	{ 0xE7, 0x94, 0xBB },
	{ 0xE5, 0x88, 0x92 },
	{ 0xE5, 0x8C, 0x96 },
	{ 0xE8, 0xAF, 0x9D },
	{ 0xE6, 0xA7, 0x90 },
	{ 0xE5, 0xBE, 0x8A },
	{ 0xE6, 0x80, 0x80 },
	{ 0xE6, 0xB7, 0xAE },
	{ 0xE5, 0x9D, 0x8F },
	{ 0xE6, 0xAC, 0xA2 },
	{ 0xE7, 0x8E, 0xAF },
	{ 0xE6, 0xA1, 0x93 },
	{ 0xE8, 0xBF, 0x98 },
	{ 0xE7, 0xBC, 0x93 },
	{ 0xE6, 0x8D, 0xA2 },
	{ 0xE6, 0x82, 0xA3 },
	{ 0xE5, 0x94, 0xA4 },
	{ 0xE7, 0x97, 0xAA },
	{ 0xE8, 0xB1, 0xA2 },
	{ 0xE7, 0x84, 0x95 },
	{ 0xE6, 0xB6, 0xA3 },
	{ 0xE5, 0xAE, 0xA6 },
	{ 0xE5, 0xB9, 0xBB },
	{ 0xE8, 0x8D, 0x92 },
	{ 0xE6, 0x85, 0x8C },
	{ 0xE9, 0xBB, 0x84 },
	{ 0xE7, 0xA3, 0xBA },
	{ 0xE8, 0x9D, 0x97 },
	{ 0xE7, 0xB0, 0xA7 },
	{ 0xE7, 0x9A, 0x87 },
	{ 0xE5, 0x87, 0xB0 },
	{ 0xE6, 0x83, 0xB6 },
	{ 0xE7, 0x85, 0x8C },
	{ 0xE6, 0x99, 0x83 },
	{ 0xE5, 0xB9, 0x8C },
	{ 0xE6, 0x81, 0x8D },
	{ 0xE8, 0xB0, 0x8E },
	{ 0xE7, 0x81, 0xB0 },
	{ 0xE6, 0x8C, 0xA5 },
	{ 0xE8, 0xBE, 0x89 },
	{ 0xE5, 0xBE, 0xBD },
	{ 0xE6, 0x81, 0xA2 },
	{ 0xE8, 0x9B, 0x94 },
	{ 0xE5, 0x9B, 0x9E },
	{ 0xE6, 0xAF, 0x81 },
	{ 0xE6, 0x82, 0x94 },
	{ 0xE6, 0x85, 0xA7 },
	{ 0xE5, 0x8D, 0x89 },
	{ 0xE6, 0x83, 0xA0 },
	{ 0xE6, 0x99, 0xA6 },
	{ 0xE8, 0xB4, 0xBF },
	{ 0xE7, 0xA7, 0xBD },
	{ 0xE4, 0xBC, 0x9A },
	{ 0xE7, 0x83, 0xA9 },
	{ 0xE6, 0xB1, 0x87 },
	{ 0xE8, 0xAE, 0xB3 },
	{ 0xE8, 0xAF, 0xB2 },
	{ 0xE7, 0xBB, 0x98 },
	{ 0xE8, 0x8D, 0xA4 },
	{ 0xE6, 0x98, 0x8F },
	{ 0xE5, 0xA9, 0x9A },
	{ 0xE9, 0xAD, 0x82 },
	{ 0xE6, 0xB5, 0x91 },
	{ 0xE6, 0xB7, 0xB7 },
	{ 0xE8, 0xB1, 0x81 },
	{ 0xE6, 0xB4, 0xBB },
	{ 0xE4, 0xBC, 0x99 },
	{ 0xE7, 0x81, 0xAB },
	{ 0xE8, 0x8E, 0xB7 },
	{ 0xE6, 0x88, 0x96 },
	{ 0xE6, 0x83, 0x91 },
	{ 0xE9, 0x9C, 0x8D },
	{ 0xE8, 0xB4, 0xA7 },
	{ 0xE7, 0xA5, 0xB8 },
	{ 0xE5, 0x87, 0xBB },
	{ 0xE5, 0x9C, 0xBE },
	{ 0xE5, 0x9F, 0xBA },
	{ 0xE6, 0x9C, 0xBA },
	{ 0xE7, 0x95, 0xB8 },
	{ 0xE7, 0xA8, 0xBD },
	{ 0xE7, 0xA7, 0xAF },
	{ 0xE7, 0xAE, 0x95 },
	{ 0xE8, 0x82, 0x8C },
	{ 0xE9, 0xA5, 0xA5 },
	{ 0xE8, 0xBF, 0xB9 },
	{ 0xE6, 0xBF, 0x80 },
	{ 0xE8, 0xAE, 0xA5 },
	{ 0xE9, 0xB8, 0xA1 },
	{ 0xE5, 0xA7, 0xAC },
	{ 0xE7, 0xBB, 0xA9 },
	{ 0xE7, 0xBC, 0x89 },
	{ 0xE5, 0x90, 0x89 },
	{ 0xE6, 0x9E, 0x81 },
	{ 0xE6, 0xA3, 0x98 },
	{ 0xE8, 0xBE, 0x91 },
	{ 0xE7, 0xB1, 0x8D },
	{ 0xE9, 0x9B, 0x86 },
	{ 0xE5, 0x8F, 0x8A },
	{ 0xE6, 0x80, 0xA5 },
	{ 0xE7, 0x96, 0xBE },
	{ 0xE6, 0xB1, 0xB2 },
	{ 0xE5, 0x8D, 0xB3 },
	{ 0xE5, 0xAB, 0x89 },
	{ 0xE7, 0xBA, 0xA7 },
	{ 0xE6, 0x8C, 0xA4 },
	{ 0xE5, 0x87, 0xA0 },
	{ 0xE8, 0x84, 0x8A },
	{ 0xE5, 0xB7, 0xB1 },
	{ 0xE8, 0x93, 0x9F },
	{ 0xE6, 0x8A, 0x80 },
	{ 0xE5, 0x86, 0x80 },
	{ 0xE5, 0xAD, 0xA3 },
	{ 0xE4, 0xBC, 0x8E },
	{ 0xE7, 0xA5, 0xAD },
	{ 0xE5, 0x89, 0x82 },
	{ 0xE6, 0x82, 0xB8 },
	{ 0xE6, 0xB5, 0x8E },
	{ 0xE5, 0xAF, 0x84 },
	{ 0xE5, 0xAF, 0x82 },
	{ 0xE8, 0xAE, 0xA1 },
	{ 0xE8, 0xAE, 0xB0 },
	{ 0xE6, 0x97, 0xA2 },
	{ 0xE5, 0xBF, 0x8C },
	{ 0xE9, 0x99, 0x85 },
	{ 0xE5, 0xA6, 0x93 },
	{ 0xE7, 0xBB, 0xA7 },
	{ 0xE7, 0xBA, 0xAA },
	{ 0xE5, 0x98, 0x89 },
	{ 0xE6, 0x9E, 0xB7 },
	{ 0xE5, 0xA4, 0xB9 },
	{ 0xE4, 0xBD, 0xB3 },
	{ 0xE5, 0xAE, 0xB6 },
	{ 0xE5, 0x8A, 0xA0 },
	{ 0xE8, 0x8D, 0x9A },
	{ 0xE9, 0xA2, 0x8A },
	{ 0xE8, 0xB4, 0xBE },
	{ 0xE7, 0x94, 0xB2 },
	{ 0xE9, 0x92, 0xBE },
	{ 0xE5, 0x81, 0x87 },
	{ 0xE7, 0xA8, 0xBC },
	{ 0xE4, 0xBB, 0xB7 },
	{ 0xE6, 0x9E, 0xB6 },
	{ 0xE9, 0xA9, 0xBE },
	{ 0xE5, 0xAB, 0x81 },
	{ 0xE6, 0xAD, 0xBC },
	{ 0xE7, 0x9B, 0x91 },
	{ 0xE5, 0x9D, 0x9A },
	{ 0xE5, 0xB0, 0x96 },
	{ 0xE7, 0xAC, 0xBA },
	{ 0xE9, 0x97, 0xB4 },
	{ 0xE7, 0x85, 0x8E },
	{ 0xE5, 0x85, 0xBC },
	{ 0xE8, 0x82, 0xA9 },
	{ 0xE8, 0x89, 0xB0 },
	{ 0xE5, 0xA5, 0xB8 },
	{ 0xE7, 0xBC, 0x84 },
	{ 0xE8, 0x8C, 0xA7 },
	{ 0xE6, 0xA3, 0x80 },
	{ 0xE6, 0x9F, 0xAC },
	{ 0xE7, 0xA2, 0xB1 },
	{ 0xE7, 0xA1, 0xB7 },
	{ 0xE6, 0x8B, 0xA3 },
	{ 0xE6, 0x8D, 0xA1 },
	{ 0xE7, 0xAE, 0x80 },
	{ 0xE4, 0xBF, 0xAD },
	{ 0xE5, 0x89, 0xAA },
	{ 0xE5, 0x87, 0x8F },
	{ 0xE8, 0x8D, 0x90 },
	{ 0xE6, 0xA7, 0x9B },
	{ 0xE9, 0x89, 0xB4 },
	{ 0xE8, 0xB7, 0xB5 },
	{ 0xE8, 0xB4, 0xB1 },
	{ 0xE8, 0xA7, 0x81 },
	{ 0xE9, 0x94, 0xAE },
	{ 0xE7, 0xAE, 0xAD },
	{ 0xE4, 0xBB, 0xB6 },
	{ 0xE5, 0x81, 0xA5 },
	{ 0xE8, 0x88, 0xB0 },
	{ 0xE5, 0x89, 0x91 },
	{ 0xE9, 0xA5, 0xAF },
	{ 0xE6, 0xB8, 0x90 },
	{ 0xE6, 0xBA, 0x85 },
	{ 0xE6, 0xB6, 0xA7 },
	{ 0xE5, 0xBB, 0xBA },
	{ 0xE5, 0x83, 0xB5 },
	{ 0xE5, 0xA7, 0x9C },
	{ 0xE5, 0xB0, 0x86 },
	{ 0xE6, 0xB5, 0x86 },
	{ 0xE6, 0xB1, 0x9F },
	{ 0xE7, 0x96, 0x86 },
	{ 0xE8, 0x92, 0x8B },
	{ 0xE6, 0xA1, 0xA8 },
	{ 0xE5, 0xA5, 0x96 },
	{ 0xE8, 0xAE, 0xB2 },
	{ 0xE5, 0x8C, 0xA0 },
	{ 0xE9, 0x85, 0xB1 },
	{ 0xE9, 0x99, 0x8D },
	{ 0xE8, 0x95, 0x89 },
	{ 0xE6, 0xA4, 0x92 },
	{ 0xE7, 0xA4, 0x81 },
	{ 0xE7, 0x84, 0xA6 },
	{ 0xE8, 0x83, 0xB6 },
	{ 0xE4, 0xBA, 0xA4 },
	{ 0xE9, 0x83, 0x8A },
	{ 0xE6, 0xB5, 0x87 },
	{ 0xE9, 0xAA, 0x84 },
	{ 0xE5, 0xA8, 0x87 },
	{ 0xE5, 0x9A, 0xBC },
	{ 0xE6, 0x90, 0x85 },
	{ 0xE9, 0x93, 0xB0 },
	{ 0xE7, 0x9F, 0xAB },
	{ 0xE4, 0xBE, 0xA5 },
	{ 0xE8, 0x84, 0x9A },
	{ 0xE7, 0x8B, 0xA1 },
	{ 0xE8, 0xA7, 0x92 },
	{ 0xE9, 0xA5, 0xBA },
	{ 0xE7, 0xBC, 0xB4 },
	{ 0xE7, 0xBB, 0x9E },
	{ 0xE5, 0x89, 0xBF },
	{ 0xE6, 0x95, 0x99 },
	{ 0xE9, 0x85, 0xB5 },
	{ 0xE8, 0xBD, 0xBF },
	{ 0xE8, 0xBE, 0x83 },
	{ 0xE5, 0x8F, 0xAB },
	{ 0xE7, 0xAA, 0x96 },
	{ 0xE6, 0x8F, 0xAD },
	{ 0xE6, 0x8E, 0xA5 },
	{ 0xE7, 0x9A, 0x86 },
	{ 0xE7, 0xA7, 0xB8 },
	{ 0xE8, 0xA1, 0x97 },
	{ 0xE9, 0x98, 0xB6 },
	{ 0xE6, 0x88, 0xAA },
	{ 0xE5, 0x8A, 0xAB },
	{ 0xE8, 0x8A, 0x82 },
	{ 0xE6, 0xA1, 0x94 },
	{ 0xE6, 0x9D, 0xB0 },
	{ 0xE6, 0x8D, 0xB7 },
	{ 0xE7, 0x9D, 0xAB },
	{ 0xE7, 0xAB, 0xAD },
	{ 0xE6, 0xB4, 0x81 },
	{ 0xE7, 0xBB, 0x93 },
	{ 0xE8, 0xA7, 0xA3 },
	{ 0xE5, 0xA7, 0x90 },
	{ 0xE6, 0x88, 0x92 },
	{ 0xE8, 0x97, 0x89 },
	{ 0xE8, 0x8A, 0xA5 },
	{ 0xE7, 0x95, 0x8C },
	{ 0xE5, 0x80, 0x9F },
	{ 0xE4, 0xBB, 0x8B },
	{ 0xE7, 0x96, 0xA5 },
	{ 0xE8, 0xAF, 0xAB },
	{ 0xE5, 0xB1, 0x8A },
	{ 0xE5, 0xB7, 0xBE },
	{ 0xE7, 0xAD, 0x8B },
	{ 0xE6, 0x96, 0xA4 },
	{ 0xE9, 0x87, 0x91 },
	{ 0xE4, 0xBB, 0x8A },
	{ 0xE6, 0xB4, 0xA5 },
	{ 0xE8, 0xA5, 0x9F },
	{ 0xE7, 0xB4, 0xA7 },
	{ 0xE9, 0x94, 0xA6 },
	{ 0xE4, 0xBB, 0x85 },
	{ 0xE8, 0xB0, 0xA8 },
	{ 0xE8, 0xBF, 0x9B },
	{ 0xE9, 0x9D, 0xB3 },
	{ 0xE6, 0x99, 0x8B },
	{ 0xE7, 0xA6, 0x81 },
	{ 0xE8, 0xBF, 0x91 },
	{ 0xE7, 0x83, 0xAC },
	{ 0xE6, 0xB5, 0xB8 },
	{ 0xE5, 0xB0, 0xBD },
	{ 0xE5, 0x8A, 0xB2 },
	{ 0xE8, 0x8D, 0x86 },
	{ 0xE5, 0x85, 0xA2 },
	{ 0xE8, 0x8C, 0x8E },
	{ 0xE7, 0x9D, 0x9B },
	{ 0xE6, 0x99, 0xB6 },
	{ 0xE9, 0xB2, 0xB8 },
	{ 0xE4, 0xBA, 0xAC },
	{ 0xE6, 0x83, 0x8A },
	{ 0xE7, 0xB2, 0xBE },
	{ 0xE7, 0xB2, 0xB3 },
	{ 0xE7, 0xBB, 0x8F },
	{ 0xE4, 0xBA, 0x95 },
	{ 0xE8, 0xAD, 0xA6 },
	{ 0xE6, 0x99, 0xAF },
	{ 0xE9, 0xA2, 0x88 },
	{ 0xE9, 0x9D, 0x99 },
	{ 0xE5, 0xA2, 0x83 },
	{ 0xE6, 0x95, 0xAC },
	{ 0xE9, 0x95, 0x9C },
	{ 0xE5, 0xBE, 0x84 },
	{ 0xE7, 0x97, 0x89 },
	{ 0xE9, 0x9D, 0x96 },
	{ 0xE7, 0xAB, 0x9F },
	{ 0xE7, 0xAB, 0x9E },
	{ 0xE5, 0x87, 0x80 },
	{ 0xE7, 0x82, 0xAF },
	{ 0xE7, 0xAA, 0x98 },
	{ 0xE6, 0x8F, 0xAA },
	{ 0xE7, 0xA9, 0xB6 },
	{ 0xE7, 0xBA, 0xA0 },
	{ 0xE7, 0x8E, 0x96 },
	{ 0xE9, 0x9F, 0xAD },
	{ 0xE4, 0xB9, 0x85 },
	{ 0xE7, 0x81, 0xB8 },
	{ 0xE4, 0xB9, 0x9D },
	{ 0xE9, 0x85, 0x92 },
	{ 0xE5, 0x8E, 0xA9 },
	{ 0xE6, 0x95, 0x91 },
	{ 0xE6, 0x97, 0xA7 },
	{ 0xE8, 0x87, 0xBC },
	{ 0xE8, 0x88, 0x85 },
	{ 0xE5, 0x92, 0x8E },
	{ 0xE5, 0xB0, 0xB1 },
	{ 0xE7, 0x96, 0x9A },
	{ 0xE9, 0x9E, 0xA0 },
	{ 0xE6, 0x8B, 0x98 },
	{ 0xE7, 0x8B, 0x99 },
	{ 0xE7, 0x96, 0xBD },
	{ 0xE5, 0xB1, 0x85 },
	{ 0xE9, 0xA9, 0xB9 },
	{ 0xE8, 0x8F, 0x8A },
	{ 0xE5, 0xB1, 0x80 },
	{ 0xE5, 0x92, 0x80 },
	{ 0xE7, 0x9F, 0xA9 },
	{ 0xE4, 0xB8, 0xBE },
	{ 0xE6, 0xB2, 0xAE },
	{ 0xE8, 0x81, 0x9A },
	{ 0xE6, 0x8B, 0x92 },
	{ 0xE6, 0x8D, 0xAE },
	{ 0xE5, 0xB7, 0xA8 },
	{ 0xE5, 0x85, 0xB7 },
	{ 0xE8, 0xB7, 0x9D },
	{ 0xE8, 0xB8, 0x9E },
	{ 0xE9, 0x94, 0xAF },
	{ 0xE4, 0xBF, 0xB1 },
	{ 0xE5, 0x8F, 0xA5 },
	{ 0xE6, 0x83, 0xA7 },
	{ 0xE7, 0x82, 0xAC },
	{ 0xE5, 0x89, 0xA7 },
	{ 0xE6, 0x8D, 0x90 },
	{ 0xE9, 0xB9, 0x83 },
	{ 0xE5, 0xA8, 0x9F },
	{ 0xE5, 0x80, 0xA6 },
	{ 0xE7, 0x9C, 0xB7 },
	{ 0xE5, 0x8D, 0xB7 },
	{ 0xE7, 0xBB, 0xA2 },
	{ 0xE6, 0x92, 0x85 },
	{ 0xE6, 0x94, 0xAB },
	{ 0xE6, 0x8A, 0x89 },
	{ 0xE6, 0x8E, 0x98 },
	{ 0xE5, 0x80, 0x94 },
	{ 0xE7, 0x88, 0xB5 },
	{ 0xE8, 0xA7, 0x89 },
	{ 0xE5, 0x86, 0xB3 },
	{ 0xE8, 0xAF, 0x80 },
	{ 0xE7, 0xBB, 0x9D },
	{ 0xE5, 0x9D, 0x87 },
	{ 0xE8, 0x8F, 0x8C },
	{ 0xE9, 0x92, 0xA7 },
	{ 0xE5, 0x86, 0x9B },
	{ 0xE5, 0x90, 0x9B },
	{ 0xE5, 0xB3, 0xBB },
	{ 0xE4, 0xBF, 0x8A },
	{ 0xE7, 0xAB, 0xA3 },
	{ 0xE6, 0xB5, 0x9A },
	{ 0xE9, 0x83, 0xA1 },
	{ 0xE9, 0xAA, 0x8F },
	{ 0xE5, 0x96, 0x80 },
	{ 0xE5, 0x92, 0x96 },
	{ 0xE5, 0x8D, 0xA1 },
	{ 0xE5, 0x92, 0xAF },
	{ 0xE5, 0xBC, 0x80 },
	{ 0xE6, 0x8F, 0xA9 },
	{ 0xE6, 0xA5, 0xB7 },
	{ 0xE5, 0x87, 0xAF },
	{ 0xE6, 0x85, 0xA8 },
	{ 0xE5, 0x88, 0x8A },
	{ 0xE5, 0xA0, 0xAA },
	{ 0xE5, 0x8B, 0x98 },
	{ 0xE5, 0x9D, 0x8E },
	{ 0xE7, 0xA0, 0x8D },
	{ 0xE7, 0x9C, 0x8B },
	{ 0xE5, 0xBA, 0xB7 },
	{ 0xE6, 0x85, 0xB7 },
	{ 0xE7, 0xB3, 0xA0 },
	{ 0xE6, 0x89, 0x9B },
	{ 0xE6, 0x8A, 0x97 },
	{ 0xE4, 0xBA, 0xA2 },
	{ 0xE7, 0x82, 0x95 },
	{ 0xE8, 0x80, 0x83 },
	{ 0xE6, 0x8B, 0xB7 },
	{ 0xE7, 0x83, 0xA4 },
	{ 0xE9, 0x9D, 0xA0 },
	{ 0xE5, 0x9D, 0xB7 },
	{ 0xE8, 0x8B, 0x9B },
	{ 0xE6, 0x9F, 0xAF },
	{ 0xE6, 0xA3, 0xB5 },
	{ 0xE7, 0xA3, 0x95 },
	{ 0xE9, 0xA2, 0x97 },
	{ 0xE7, 0xA7, 0x91 },
	{ 0xE5, 0xA3, 0xB3 },
	{ 0xE5, 0x92, 0xB3 },
	{ 0xE5, 0x8F, 0xAF },
	{ 0xE6, 0xB8, 0xB4 },
	{ 0xE5, 0x85, 0x8B },
	{ 0xE5, 0x88, 0xBB },
	{ 0xE5, 0xAE, 0xA2 },
	{ 0xE8, 0xAF, 0xBE },
	{ 0xE8, 0x82, 0xAF },
	{ 0xE5, 0x95, 0x83 },
	{ 0xE5, 0x9E, 0xA6 },
	{ 0xE6, 0x81, 0xB3 },
	{ 0xE5, 0x9D, 0x91 },
	{ 0xE5, 0x90, 0xAD },
	{ 0xE7, 0xA9, 0xBA },
	{ 0xE6, 0x81, 0x90 },
	{ 0xE5, 0xAD, 0x94 },
	{ 0xE6, 0x8E, 0xA7 },
	{ 0xE6, 0x8A, 0xA0 },
	{ 0xE5, 0x8F, 0xA3 },
	{ 0xE6, 0x89, 0xA3 },
	{ 0xE5, 0xAF, 0x87 },
	{ 0xE6, 0x9E, 0xAF },
	{ 0xE5, 0x93, 0xAD },
	{ 0xE7, 0xAA, 0x9F },
	{ 0xE8, 0x8B, 0xA6 },
	{ 0xE9, 0x85, 0xB7 },
	{ 0xE5, 0xBA, 0x93 },
	{ 0xE8, 0xA3, 0xA4 },
	{ 0xE5, 0xA4, 0xB8 },
	{ 0xE5, 0x9E, 0xAE },
	{ 0xE6, 0x8C, 0x8E },
	{ 0xE8, 0xB7, 0xA8 },
	{ 0xE8, 0x83, 0xAF },
	{ 0xE5, 0x9D, 0x97 },
	{ 0xE7, 0xAD, 0xB7 },
	{ 0xE4, 0xBE, 0xA9 },
	{ 0xE5, 0xBF, 0xAB },
	{ 0xE5, 0xAE, 0xBD },
	{ 0xE6, 0xAC, 0xBE },
	{ 0xE5, 0x8C, 0xA1 },
	{ 0xE7, 0xAD, 0x90 },
	{ 0xE7, 0x8B, 0x82 },
	{ 0xE6, 0xA1, 0x86 },
	{ 0xE7, 0x9F, 0xBF },
	{ 0xE7, 0x9C, 0xB6 },
	{ 0xE6, 0x97, 0xB7 },
	{ 0xE5, 0x86, 0xB5 },
	{ 0xE4, 0xBA, 0x8F },
	{ 0xE7, 0x9B, 0x94 },
	{ 0xE5, 0xB2, 0xBF },
	{ 0xE7, 0xAA, 0xA5 },
	{ 0xE8, 0x91, 0xB5 },
	{ 0xE5, 0xA5, 0x8E },
	{ 0xE9, 0xAD, 0x81 },
	{ 0xE5, 0x82, 0x80 },
	{ 0xE9, 0xA6, 0x88 },
	{ 0xE6, 0x84, 0xA7 },
	{ 0xE6, 0xBA, 0x83 },
	{ 0xE5, 0x9D, 0xA4 },
	{ 0xE6, 0x98, 0x86 },
	{ 0xE6, 0x8D, 0x86 },
	{ 0xE5, 0x9B, 0xB0 },
	{ 0xE6, 0x8B, 0xAC },
	{ 0xE6, 0x89, 0xA9 },
	{ 0xE5, 0xBB, 0x93 },
	{ 0xE9, 0x98, 0x94 },
	{ 0xE5, 0x9E, 0x83 },
	{ 0xE6, 0x8B, 0x89 },
	{ 0xE5, 0x96, 0x87 },
	{ 0xE8, 0x9C, 0xA1 },
	{ 0xE8, 0x85, 0x8A },
	{ 0xE8, 0xBE, 0xA3 },
	{ 0xE5, 0x95, 0xA6 },
	{ 0xE8, 0x8E, 0xB1 },
	{ 0xE6, 0x9D, 0xA5 },
	{ 0xE8, 0xB5, 0x96 },
	{ 0xE8, 0x93, 0x9D },
	{ 0xE5, 0xA9, 0xAA },
	{ 0xE6, 0xA0, 0x8F },
	{ 0xE6, 0x8B, 0xA6 },
	{ 0xE7, 0xAF, 0xAE },
	{ 0xE9, 0x98, 0x91 },
	{ 0xE5, 0x85, 0xB0 },
	{ 0xE6, 0xBE, 0x9C },
	{ 0xE8, 0xB0, 0xB0 },
	{ 0xE6, 0x8F, 0xBD },
	{ 0xE8, 0xA7, 0x88 },
	{ 0xE6, 0x87, 0x92 },
	{ 0xE7, 0xBC, 0x86 },
	{ 0xE7, 0x83, 0x82 },
	{ 0xE6, 0xBB, 0xA5 },
	{ 0xE7, 0x90, 0x85 },
	{ 0xE6, 0xA6, 0x94 },
	{ 0xE7, 0x8B, 0xBC },
	{ 0xE5, 0xBB, 0x8A },
	{ 0xE9, 0x83, 0x8E },
	{ 0xE6, 0x9C, 0x97 },
	{ 0xE6, 0xB5, 0xAA },
	{ 0xE6, 0x8D, 0x9E },
	{ 0xE5, 0x8A, 0xB3 },
	{ 0xE7, 0x89, 0xA2 },
	{ 0xE8, 0x80, 0x81 },
	{ 0xE4, 0xBD, 0xAC },
	{ 0xE5, 0xA7, 0xA5 },
	{ 0xE9, 0x85, 0xAA },
	{ 0xE7, 0x83, 0x99 },
	{ 0xE6, 0xB6, 0x9D },
	{ 0xE5, 0x8B, 0x92 },
	{ 0xE4, 0xB9, 0x90 },
	{ 0xE9, 0x9B, 0xB7 },
	{ 0xE9, 0x95, 0xAD },
	{ 0xE8, 0x95, 0xBE },
	{ 0xE7, 0xA3, 0x8A },
	{ 0xE7, 0xB4, 0xAF },
	{ 0xE5, 0x84, 0xA1 },
	{ 0xE5, 0x9E, 0x92 },
	{ 0xE6, 0x93, 0x82 },
	{ 0xE8, 0x82, 0x8B },
	{ 0xE7, 0xB1, 0xBB },
	{ 0xE6, 0xB3, 0xAA },
	{ 0xE6, 0xA3, 0xB1 },
	{ 0xE6, 0xA5, 0x9E },
	{ 0xE5, 0x86, 0xB7 },
	{ 0xE5, 0x8E, 0x98 },
	{ 0xE6, 0xA2, 0xA8 },
	{ 0xE7, 0x8A, 0x81 },
	{ 0xE9, 0xBB, 0x8E },
	{ 0xE7, 0xAF, 0xB1 },
	{ 0xE7, 0x8B, 0xB8 },
	{ 0xE7, 0xA6, 0xBB },
	{ 0xE6, 0xBC, 0x93 },
	{ 0xE7, 0x90, 0x86 },
	{ 0xE6, 0x9D, 0x8E },
	{ 0xE9, 0x87, 0x8C },
	{ 0xE9, 0xB2, 0xA4 },
	{ 0xE7, 0xA4, 0xBC },
	{ 0xE8, 0x8E, 0x89 },
	{ 0xE8, 0x8D, 0x94 },
	{ 0xE5, 0x90, 0x8F },
	{ 0xE6, 0xA0, 0x97 },
	{ 0xE4, 0xB8, 0xBD },
	{ 0xE5, 0x8E, 0x89 },
	{ 0xE5, 0x8A, 0xB1 },
	{ 0xE7, 0xA0, 0xBE },
	{ 0xE5, 0x8E, 0x86 },
	{ 0xE5, 0x88, 0xA9 },
	{ 0xE5, 0x82, 0x88 },
	{ 0xE4, 0xBE, 0x8B },
	{ 0xE4, 0xBF, 0x90 },
	{ 0xE7, 0x97, 0xA2 },
	{ 0xE7, 0xAB, 0x8B },
	{ 0xE7, 0xB2, 0x92 },
	{ 0xE6, 0xB2, 0xA5 },
	{ 0xE9, 0x9A, 0xB6 },
	{ 0xE5, 0x8A, 0x9B },
	{ 0xE7, 0x92, 0x83 },
	{ 0xE5, 0x93, 0xA9 },
	{ 0xE4, 0xBF, 0xA9 },
	{ 0xE8, 0x81, 0x94 },
	{ 0xE8, 0x8E, 0xB2 },
	{ 0xE8, 0xBF, 0x9E },
	{ 0xE9, 0x95, 0xB0 },
	{ 0xE5, 0xBB, 0x89 },
	{ 0xE6, 0x80, 0x9C },
	{ 0xE6, 0xB6, 0x9F },
	{ 0xE5, 0xB8, 0x98 },
	{ 0xE6, 0x95, 0x9B },
	{ 0xE8, 0x84, 0xB8 },
	{ 0xE9, 0x93, 0xBE },
	{ 0xE6, 0x81, 0x8B },
	{ 0xE7, 0x82, 0xBC },
	{ 0xE7, 0xBB, 0x83 },
	{ 0xE7, 0xB2, 0xAE },
	{ 0xE5, 0x87, 0x89 },
	{ 0xE6, 0xA2, 0x81 },
	{ 0xE7, 0xB2, 0xB1 },
	{ 0xE8, 0x89, 0xAF },
	{ 0xE4, 0xB8, 0xA4 },
	{ 0xE8, 0xBE, 0x86 },
	{ 0xE9, 0x87, 0x8F },
	{ 0xE6, 0x99, 0xBE },
	{ 0xE4, 0xBA, 0xAE },
	{ 0xE8, 0xB0, 0x85 },
	{ 0xE6, 0x92, 0xA9 },
	{ 0xE8, 0x81, 0x8A },
	{ 0xE5, 0x83, 0x9A },
	{ 0xE7, 0x96, 0x97 },
	{ 0xE7, 0x87, 0x8E },
	{ 0xE5, 0xAF, 0xA5 },
	{ 0xE8, 0xBE, 0xBD },
	{ 0xE6, 0xBD, 0xA6 },
	{ 0xE4, 0xBA, 0x86 },
	{ 0xE6, 0x92, 0x82 },
	{ 0xE9, 0x95, 0xA3 },
	{ 0xE5, 0xBB, 0x96 },
	{ 0xE6, 0x96, 0x99 },
	{ 0xE5, 0x88, 0x97 },
	{ 0xE8, 0xA3, 0x82 },
	{ 0xE7, 0x83, 0x88 },
	{ 0xE5, 0x8A, 0xA3 },
	{ 0xE7, 0x8C, 0x8E },
	{ 0xE7, 0x90, 0xB3 },
	{ 0xE6, 0x9E, 0x97 },
	{ 0xE7, 0xA3, 0xB7 },
	{ 0xE9, 0x9C, 0x96 },
	{ 0xE4, 0xB8, 0xB4 },
	{ 0xE9, 0x82, 0xBB },
	{ 0xE9, 0xB3, 0x9E },
	{ 0xE6, 0xB7, 0x8B },
	{ 0xE5, 0x87, 0x9B },
	{ 0xE8, 0xB5, 0x81 },
	{ 0xE5, 0x90, 0x9D },
	{ 0xE6, 0x8B, 0x8E },
	{ 0xE7, 0x8E, 0xB2 },
	{ 0xE8, 0x8F, 0xB1 },
	{ 0xE9, 0x9B, 0xB6 },
	{ 0xE9, 0xBE, 0x84 },
	{ 0xE9, 0x93, 0x83 },
	{ 0xE4, 0xBC, 0xB6 },
	{ 0xE7, 0xBE, 0x9A },
	{ 0xE5, 0x87, 0x8C },
	{ 0xE7, 0x81, 0xB5 },
	{ 0xE9, 0x99, 0xB5 },
	{ 0xE5, 0xB2, 0xAD },
	{ 0xE9, 0xA2, 0x86 },
	{ 0xE5, 0x8F, 0xA6 },
	{ 0xE4, 0xBB, 0xA4 },
	{ 0xE6, 0xBA, 0x9C },
	{ 0xE7, 0x90, 0x89 },
	{ 0xE6, 0xA6, 0xB4 },
	{ 0xE7, 0xA1, 0xAB },
	{ 0xE9, 0xA6, 0x8F },
	{ 0xE7, 0x95, 0x99 },
	{ 0xE5, 0x88, 0x98 },
	{ 0xE7, 0x98, 0xA4 },
	{ 0xE6, 0xB5, 0x81 },
	{ 0xE6, 0x9F, 0xB3 },
	{ 0xE5, 0x85, 0xAD },
	{ 0xE9, 0xBE, 0x99 },
	{ 0xE8, 0x81, 0x8B },
	{ 0xE5, 0x92, 0x99 },
	{ 0xE7, 0xAC, 0xBC },
	{ 0xE7, 0xAA, 0xBF },
	{ 0xE9, 0x9A, 0x86 },
	{ 0xE5, 0x9E, 0x84 },
	{ 0xE6, 0x8B, 0xA2 },
	{ 0xE9, 0x99, 0x87 },
	{ 0xE6, 0xA5, 0xBC },
	{ 0xE5, 0xA8, 0x84 },
	{ 0xE6, 0x90, 0x82 },
	{ 0xE7, 0xAF, 0x93 },
	{ 0xE6, 0xBC, 0x8F },
	{ 0xE9, 0x99, 0x8B },
	{ 0xE8, 0x8A, 0xA6 },
	{ 0xE5, 0x8D, 0xA2 },
	{ 0xE9, 0xA2, 0x85 },
	{ 0xE5, 0xBA, 0x90 },
	{ 0xE7, 0x82, 0x89 },
	{ 0xE6, 0x8E, 0xB3 },
	{ 0xE5, 0x8D, 0xA4 },
	{ 0xE8, 0x99, 0x8F },
	{ 0xE9, 0xB2, 0x81 },
	{ 0xE9, 0xBA, 0x93 },
	{ 0xE7, 0xA2, 0x8C },
	{ 0xE9, 0x9C, 0xB2 },
	{ 0xE8, 0xB7, 0xAF },
	{ 0xE8, 0xB5, 0x82 },
	{ 0xE9, 0xB9, 0xBF },
	{ 0xE6, 0xBD, 0x9E },
	{ 0xE7, 0xA6, 0x84 },
	{ 0xE5, 0xBD, 0x95 },
	{ 0xE9, 0x99, 0x86 },
	{ 0xE6, 0x88, 0xAE },
	{ 0xE9, 0xA9, 0xB4 },
	{ 0xE5, 0x90, 0x95 },
	{ 0xE9, 0x93, 0x9D },
	{ 0xE4, 0xBE, 0xA3 },
	{ 0xE6, 0x97, 0x85 },
	{ 0xE5, 0xB1, 0xA5 },
	{ 0xE5, 0xB1, 0xA1 },
	{ 0xE7, 0xBC, 0x95 },
	{ 0xE8, 0x99, 0x91 },
	{ 0xE6, 0xB0, 0xAF },
	{ 0xE5, 0xBE, 0x8B },
	{ 0xE7, 0x8E, 0x87 },
	{ 0xE6, 0xBB, 0xA4 },
	{ 0xE7, 0xBB, 0xBF },
	{ 0xE5, 0xB3, 0xA6 },
	{ 0xE6, 0x8C, 0x9B },
	{ 0xE5, 0xAD, 0xAA },
	{ 0xE6, 0xBB, 0xA6 },
	{ 0xE5, 0x8D, 0xB5 },
	{ 0xE4, 0xB9, 0xB1 },
	{ 0xE6, 0x8E, 0xA0 },
	{ 0xE7, 0x95, 0xA5 },
	{ 0xE6, 0x8A, 0xA1 },
	{ 0xE8, 0xBD, 0xAE },
	{ 0xE4, 0xBC, 0xA6 },
	{ 0xE4, 0xBB, 0x91 },
	{ 0xE6, 0xB2, 0xA6 },
	{ 0xE7, 0xBA, 0xB6 },
	{ 0xE8, 0xAE, 0xBA },
	{ 0xE8, 0x90, 0x9D },
	{ 0xE8, 0x9E, 0xBA },
	{ 0xE7, 0xBD, 0x97 },
	{ 0xE9, 0x80, 0xBB },
	{ 0xE9, 0x94, 0xA3 },
	{ 0xE7, 0xAE, 0xA9 },
	{ 0xE9, 0xAA, 0xA1 },
	{ 0xE8, 0xA3, 0xB8 },
	{ 0xE8, 0x90, 0xBD },
	{ 0xE6, 0xB4, 0x9B },
	{ 0xE9, 0xAA, 0x86 },
	{ 0xE7, 0xBB, 0x9C },
	{ 0xE5, 0xA6, 0x88 },
	{ 0xE9, 0xBA, 0xBB },
	{ 0xE7, 0x8E, 0x9B },
	{ 0xE7, 0xA0, 0x81 },
	{ 0xE8, 0x9A, 0x82 },
	{ 0xE9, 0xA9, 0xAC },
	{ 0xE9, 0xAA, 0x82 },
	{ 0xE5, 0x98, 0x9B },
	{ 0xE5, 0x90, 0x97 },
	{ 0xE5, 0x9F, 0x8B },
	{ 0xE4, 0xB9, 0xB0 },
	{ 0xE9, 0xBA, 0xA6 },
	{ 0xE5, 0x8D, 0x96 },
	{ 0xE8, 0xBF, 0x88 },
	{ 0xE8, 0x84, 0x89 },
	{ 0xE7, 0x9E, 0x92 },
	{ 0xE9, 0xA6, 0x92 },
	{ 0xE8, 0x9B, 0xAE },
	{ 0xE6, 0xBB, 0xA1 },
	{ 0xE8, 0x94, 0x93 },
	{ 0xE6, 0x9B, 0xBC },
	{ 0xE6, 0x85, 0xA2 },
	{ 0xE6, 0xBC, 0xAB },
	{ 0xE8, 0xB0, 0xA9 },
	{ 0xE8, 0x8A, 0x92 },
	{ 0xE8, 0x8C, 0xAB },
	{ 0xE7, 0x9B, 0xB2 },
	{ 0xE6, 0xB0, 0x93 },
	{ 0xE5, 0xBF, 0x99 },
	{ 0xE8, 0x8E, 0xBD },
	{ 0xE7, 0x8C, 0xAB },
	{ 0xE8, 0x8C, 0x85 },
	{ 0xE9, 0x94, 0x9A },
	{ 0xE6, 0xAF, 0x9B },
	{ 0xE7, 0x9F, 0x9B },
	{ 0xE9, 0x93, 0x86 },
	{ 0xE5, 0x8D, 0xAF },
	{ 0xE8, 0x8C, 0x82 },
	{ 0xE5, 0x86, 0x92 },
	{ 0xE5, 0xB8, 0xBD },
	{ 0xE8, 0xB2, 0x8C },
	{ 0xE8, 0xB4, 0xB8 },
	{ 0xE4, 0xB9, 0x88 },
	{ 0xE7, 0x8E, 0xAB },
	{ 0xE6, 0x9E, 0x9A },
	{ 0xE6, 0xA2, 0x85 },
	{ 0xE9, 0x85, 0xB6 },
	{ 0xE9, 0x9C, 0x89 },
	{ 0xE7, 0x85, 0xA4 },
	{ 0xE6, 0xB2, 0xA1 },
	{ 0xE7, 0x9C, 0x89 },
	{ 0xE5, 0xAA, 0x92 },
	{ 0xE9, 0x95, 0x81 },
	{ 0xE6, 0xAF, 0x8F },
	{ 0xE7, 0xBE, 0x8E },
	{ 0xE6, 0x98, 0xA7 },
	{ 0xE5, 0xAF, 0x90 },
	{ 0xE5, 0xA6, 0xB9 },
	{ 0xE5, 0xAA, 0x9A },
	{ 0xE9, 0x97, 0xA8 },
	{ 0xE9, 0x97, 0xB7 },
	{ 0xE4, 0xBB, 0xAC },
	{ 0xE8, 0x90, 0x8C },
	{ 0xE8, 0x92, 0x99 },
	{ 0xE6, 0xAA, 0xAC },
	{ 0xE7, 0x9B, 0x9F },
	{ 0xE9, 0x94, 0xB0 },
	{ 0xE7, 0x8C, 0x9B },
	{ 0xE6, 0xA2, 0xA6 },
	{ 0xE5, 0xAD, 0x9F },
	{ 0xE7, 0x9C, 0xAF },
	{ 0xE9, 0x86, 0x9A },
	{ 0xE9, 0x9D, 0xA1 },
	{ 0xE7, 0xB3, 0x9C },
	{ 0xE8, 0xBF, 0xB7 },
	{ 0xE8, 0xB0, 0x9C },
	{ 0xE5, 0xBC, 0xA5 },
	{ 0xE7, 0xB1, 0xB3 },
	{ 0xE7, 0xA7, 0x98 },
	{ 0xE8, 0xA7, 0x85 },
	{ 0xE6, 0xB3, 0x8C },
	{ 0xE8, 0x9C, 0x9C },
	{ 0xE5, 0xAF, 0x86 },
	{ 0xE5, 0xB9, 0x82 },
	{ 0xE6, 0xA3, 0x89 },
	{ 0xE7, 0x9C, 0xA0 },
	{ 0xE7, 0xBB, 0xB5 },
	{ 0xE5, 0x86, 0x95 },
	{ 0xE5, 0x85, 0x8D },
	{ 0xE5, 0x8B, 0x89 },
	{ 0xE5, 0xA8, 0xA9 },
	{ 0xE7, 0xBC, 0x85 },
	{ 0xE9, 0x9D, 0xA2 },
	{ 0xE8, 0x8B, 0x97 },
	{ 0xE6, 0x8F, 0x8F },
	{ 0xE7, 0x9E, 0x84 },
	{ 0xE8, 0x97, 0x90 },
	{ 0xE7, 0xA7, 0x92 },
	{ 0xE6, 0xB8, 0xBA },
	{ 0xE5, 0xBA, 0x99 },
	{ 0xE5, 0xA6, 0x99 },
	{ 0xE8, 0x94, 0x91 },
	{ 0xE7, 0x81, 0xAD },
	{ 0xE6, 0xB0, 0x91 },
	{ 0xE6, 0x8A, 0xBF },
	{ 0xE7, 0x9A, 0xBF },
	{ 0xE6, 0x95, 0x8F },
	{ 0xE6, 0x82, 0xAF },
	{ 0xE9, 0x97, 0xBD },
	{ 0xE6, 0x98, 0x8E },
	{ 0xE8, 0x9E, 0x9F },
	{ 0xE9, 0xB8, 0xA3 },
	{ 0xE9, 0x93, 0xAD },
	{ 0xE5, 0x90, 0x8D },
	{ 0xE5, 0x91, 0xBD },
	{ 0xE8, 0xB0, 0xAC },
	{ 0xE6, 0x91, 0xB8 },
	{ 0xE6, 0x91, 0xB9 },
	{ 0xE8, 0x98, 0x91 },
	{ 0xE6, 0xA8, 0xA1 },
	{ 0xE8, 0x86, 0x9C },
	{ 0xE7, 0xA3, 0xA8 },
	{ 0xE6, 0x91, 0xA9 },
	{ 0xE9, 0xAD, 0x94 },
	{ 0xE6, 0x8A, 0xB9 },
	{ 0xE6, 0x9C, 0xAB },
	{ 0xE8, 0x8E, 0xAB },
	{ 0xE5, 0xA2, 0xA8 },
	{ 0xE9, 0xBB, 0x98 },
	{ 0xE6, 0xB2, 0xAB },
	{ 0xE6, 0xBC, 0xA0 },
	{ 0xE5, 0xAF, 0x9E },
	{ 0xE9, 0x99, 0x8C },
	{ 0xE8, 0xB0, 0x8B },
	{ 0xE7, 0x89, 0x9F },
	{ 0xE6, 0x9F, 0x90 },
	{ 0xE6, 0x8B, 0x87 },
	{ 0xE7, 0x89, 0xA1 },
	{ 0xE4, 0xBA, 0xA9 },
	{ 0xE5, 0xA7, 0x86 },
	{ 0xE6, 0xAF, 0x8D },
	{ 0xE5, 0xA2, 0x93 },
	{ 0xE6, 0x9A, 0xAE },
	{ 0xE5, 0xB9, 0x95 },
	{ 0xE5, 0x8B, 0x9F },
	{ 0xE6, 0x85, 0x95 },
	{ 0xE6, 0x9C, 0xA8 },
	{ 0xE7, 0x9B, 0xAE },
	{ 0xE7, 0x9D, 0xA6 },
	{ 0xE7, 0x89, 0xA7 },
	{ 0xE7, 0xA9, 0x86 },
	{ 0xE6, 0x8B, 0xBF },
	{ 0xE5, 0x93, 0xAA },
	{ 0xE5, 0x91, 0x90 },
	{ 0xE9, 0x92, 0xA0 },
	{ 0xE9, 0x82, 0xA3 },
	{ 0xE5, 0xA8, 0x9C },
	{ 0xE7, 0xBA, 0xB3 },
	{ 0xE6, 0xB0, 0x96 },
	{ 0xE4, 0xB9, 0x83 },
	{ 0xE5, 0xA5, 0xB6 },
	{ 0xE8, 0x80, 0x90 },
	{ 0xE5, 0xA5, 0x88 },
	{ 0xE5, 0x8D, 0x97 },
	{ 0xE7, 0x94, 0xB7 },
	{ 0xE9, 0x9A, 0xBE },
	{ 0xE5, 0x9B, 0x8A },
	{ 0xE6, 0x8C, 0xA0 },
	{ 0xE8, 0x84, 0x91 },
	{ 0xE6, 0x81, 0xBC },
	{ 0xE9, 0x97, 0xB9 },
	{ 0xE6, 0xB7, 0x96 },
	{ 0xE5, 0x91, 0xA2 },
	{ 0xE9, 0xA6, 0x81 },
	{ 0xE5, 0x86, 0x85 },
	{ 0xE5, 0xAB, 0xA9 },
	{ 0xE8, 0x83, 0xBD },
	{ 0xE5, 0xA6, 0xAE },
	{ 0xE9, 0x9C, 0x93 },
	{ 0xE5, 0x80, 0xAA },
	{ 0xE6, 0xB3, 0xA5 },
	{ 0xE5, 0xB0, 0xBC },
	{ 0xE6, 0x8B, 0x9F },
	{ 0xE4, 0xBD, 0xA0 },
	{ 0xE5, 0x8C, 0xBF },
	{ 0xE8, 0x85, 0xBB },
	{ 0xE9, 0x80, 0x86 },
	{ 0xE6, 0xBA, 0xBA },
	{ 0xE8, 0x94, 0xAB },
	{ 0xE6, 0x8B, 0x88 },
	{ 0xE5, 0xB9, 0xB4 },
	{ 0xE7, 0xA2, 0xBE },
	{ 0xE6, 0x92, 0xB5 },
	{ 0xE6, 0x8D, 0xBB },
	{ 0xE5, 0xBF, 0xB5 },
	{ 0xE5, 0xA8, 0x98 },
	{ 0xE9, 0x85, 0xBF },
	{ 0xE9, 0xB8, 0x9F },
	{ 0xE5, 0xB0, 0xBF },
	{ 0xE6, 0x8D, 0x8F },
	{ 0xE8, 0x81, 0x82 },
	{ 0xE5, 0xAD, 0xBD },
	{ 0xE5, 0x95, 0xAE },
	{ 0xE9, 0x95, 0x8A },
	{ 0xE9, 0x95, 0x8D },
	{ 0xE6, 0xB6, 0x85 },
	{ 0xE6, 0x82, 0xA8 },
	{ 0xE6, 0x9F, 0xA0 },
	{ 0xE7, 0x8B, 0x9E },
	{ 0xE5, 0x87, 0x9D },
	{ 0xE5, 0xAE, 0x81 },
	{ 0xE6, 0x8B, 0xA7 },
	{ 0xE6, 0xB3, 0x9E },
	{ 0xE7, 0x89, 0x9B },
	{ 0xE6, 0x89, 0xAD },
	{ 0xE9, 0x92, 0xAE },
	{ 0xE7, 0xBA, 0xBD },
	{ 0xE8, 0x84, 0x93 },
	{ 0xE6, 0xB5, 0x93 },
	{ 0xE5, 0x86, 0x9C },
	{ 0xE5, 0xBC, 0x84 },
	{ 0xE5, 0xA5, 0xB4 },
	{ 0xE5, 0x8A, 0xAA },
	{ 0xE6, 0x80, 0x92 },
	{ 0xE5, 0xA5, 0xB3 },
	{ 0xE6, 0x9A, 0x96 },
	{ 0xE8, 0x99, 0x90 },
	{ 0xE7, 0x96, 0x9F },
	{ 0xE6, 0x8C, 0xAA },
	{ 0xE6, 0x87, 0xA6 },
	{ 0xE7, 0xB3, 0xAF },
	{ 0xE8, 0xAF, 0xBA },
	{ 0xE5, 0x93, 0xA6 },
	{ 0xE6, 0xAC, 0xA7 },
	{ 0xE9, 0xB8, 0xA5 },
	{ 0xE6, 0xAE, 0xB4 },
	{ 0xE8, 0x97, 0x95 },
	{ 0xE5, 0x91, 0x95 },
	{ 0xE5, 0x81, 0xB6 },
	{ 0xE6, 0xB2, 0xA4 },
	{ 0xE5, 0x95, 0xAA },
	{ 0xE8, 0xB6, 0xB4 },
	{ 0xE7, 0x88, 0xAC },
	{ 0xE5, 0xB8, 0x95 },
	{ 0xE6, 0x80, 0x95 },
	{ 0xE7, 0x90, 0xB6 },
	{ 0xE6, 0x8B, 0x8D },
	{ 0xE6, 0x8E, 0x92 },
	{ 0xE7, 0x89, 0x8C },
	{ 0xE5, 0xBE, 0x98 },
	{ 0xE6, 0xB9, 0x83 },
	{ 0xE6, 0xB4, 0xBE },
	{ 0xE6, 0x94, 0x80 },
	{ 0xE6, 0xBD, 0x98 },
	{ 0xE7, 0x9B, 0x98 },
	{ 0xE7, 0xA3, 0x90 },
	{ 0xE7, 0x9B, 0xBC },
	{ 0xE7, 0x95, 0x94 },
	{ 0xE5, 0x88, 0xA4 },
	{ 0xE5, 0x8F, 0x9B },
	{ 0xE4, 0xB9, 0x93 },
	{ 0xE5, 0xBA, 0x9E },
	{ 0xE6, 0x97, 0x81 },
	{ 0xE8, 0x80, 0xAA },
	{ 0xE8, 0x83, 0x96 },
	{ 0xE6, 0x8A, 0x9B },
	{ 0xE5, 0x92, 0x86 },
	{ 0xE5, 0x88, 0xA8 },
	{ 0xE7, 0x82, 0xAE },
	{ 0xE8, 0xA2, 0x8D },
	{ 0xE8, 0xB7, 0x91 },
	{ 0xE6, 0xB3, 0xA1 },
	{ 0xE5, 0x91, 0xB8 },
	{ 0xE8, 0x83, 0x9A },
	{ 0xE5, 0x9F, 0xB9 },
	{ 0xE8, 0xA3, 0xB4 },
	{ 0xE8, 0xB5, 0x94 },
	{ 0xE9, 0x99, 0xAA },
	{ 0xE9, 0x85, 0x8D },
	{ 0xE4, 0xBD, 0xA9 },
	{ 0xE6, 0xB2, 0x9B },
	{ 0xE5, 0x96, 0xB7 },
	{ 0xE7, 0x9B, 0x86 },
	{ 0xE7, 0xA0, 0xB0 },
	{ 0xE6, 0x8A, 0xA8 },
	{ 0xE7, 0x83, 0xB9 },
	{ 0xE6, 0xBE, 0x8E },
	{ 0xE5, 0xBD, 0xAD },
	{ 0xE8, 0x93, 0xAC },
	{ 0xE6, 0xA3, 0x9A },
	{ 0xE7, 0xA1, 0xBC },
	{ 0xE7, 0xAF, 0xB7 },
	{ 0xE8, 0x86, 0xA8 },
	{ 0xE6, 0x9C, 0x8B },
	{ 0xE9, 0xB9, 0x8F },
	{ 0xE6, 0x8D, 0xA7 },
	{ 0xE7, 0xA2, 0xB0 },
	{ 0xE5, 0x9D, 0xAF },
	{ 0xE7, 0xA0, 0x92 },
	{ 0xE9, 0x9C, 0xB9 },
	{ 0xE6, 0x89, 0xB9 },
	{ 0xE6, 0x8A, 0xAB },
	{ 0xE5, 0x8A, 0x88 },
	{ 0xE7, 0x90, 0xB5 },
	{ 0xE6, 0xAF, 0x97 },
	{ 0xE5, 0x95, 0xA4 },
	{ 0xE8, 0x84, 0xBE },
	{ 0xE7, 0x96, 0xB2 },
	{ 0xE7, 0x9A, 0xAE },
	{ 0xE5, 0x8C, 0xB9 },
	{ 0xE7, 0x97, 0x9E },
	{ 0xE5, 0x83, 0xBB },
	{ 0xE5, 0xB1, 0x81 },
	{ 0xE8, 0xAD, 0xAC },
	{ 0xE7, 0xAF, 0x87 },
	{ 0xE5, 0x81, 0x8F },
	{ 0xE7, 0x89, 0x87 },
	{ 0xE9, 0xAA, 0x97 },
	{ 0xE9, 0xA3, 0x98 },
	{ 0xE6, 0xBC, 0x82 },
	{ 0xE7, 0x93, 0xA2 },
	{ 0xE7, 0xA5, 0xA8 },
	{ 0xE6, 0x92, 0x87 },
	{ 0xE7, 0x9E, 0xA5 },
	{ 0xE6, 0x8B, 0xBC },
	{ 0xE9, 0xA2, 0x91 },
	{ 0xE8, 0xB4, 0xAB },
	{ 0xE5, 0x93, 0x81 },
	{ 0xE8, 0x81, 0x98 },
	{ 0xE4, 0xB9, 0x92 },
	{ 0xE5, 0x9D, 0xAA },
	{ 0xE8, 0x8B, 0xB9 },
	{ 0xE8, 0x90, 0x8D },
	{ 0xE5, 0xB9, 0xB3 },
	{ 0xE5, 0x87, 0xAD },
	{ 0xE7, 0x93, 0xB6 },
	{ 0xE8, 0xAF, 0x84 },
	{ 0xE5, 0xB1, 0x8F },
	{ 0xE5, 0x9D, 0xA1 },
	{ 0xE6, 0xB3, 0xBC },
	{ 0xE9, 0xA2, 0x87 },
	{ 0xE5, 0xA9, 0x86 },
	{ 0xE7, 0xA0, 0xB4 },
	{ 0xE9, 0xAD, 0x84 },
	{ 0xE8, 0xBF, 0xAB },
	{ 0xE7, 0xB2, 0x95 },
	{ 0xE5, 0x89, 0x96 },
	{ 0xE6, 0x89, 0x91 },
	{ 0xE9, 0x93, 0xBA },
	{ 0xE4, 0xBB, 0x86 },
	{ 0xE8, 0x8E, 0x86 },
	{ 0xE8, 0x91, 0xA1 },
	{ 0xE8, 0x8F, 0xA9 },
	{ 0xE8, 0x92, 0xB2 },
	{ 0xE5, 0x9F, 0x94 },
	{ 0xE6, 0x9C, 0xB4 },
	{ 0xE5, 0x9C, 0x83 },
	{ 0xE6, 0x99, 0xAE },
	{ 0xE6, 0xB5, 0xA6 },
	{ 0xE8, 0xB0, 0xB1 },
	{ 0xE6, 0x9B, 0x9D },
	{ 0xE7, 0x80, 0x91 },
	{ 0xE6, 0x9C, 0x9F },
	{ 0xE6, 0xAC, 0xBA },
	{ 0xE6, 0xA0, 0x96 },
	{ 0xE6, 0x88, 0x9A },
	{ 0xE5, 0xA6, 0xBB },
	{ 0xE4, 0xB8, 0x83 },
	{ 0xE5, 0x87, 0x84 },
	{ 0xE6, 0xBC, 0x86 },
	{ 0xE6, 0x9F, 0x92 },
	{ 0xE6, 0xB2, 0x8F },
	{ 0xE5, 0x85, 0xB6 },
	{ 0xE6, 0xA3, 0x8B },
	{ 0xE5, 0xA5, 0x87 },
	{ 0xE6, 0xAD, 0xA7 },
	{ 0xE7, 0x95, 0xA6 },
	{ 0xE5, 0xB4, 0x8E },
	{ 0xE8, 0x84, 0x90 },
	{ 0xE9, 0xBD, 0x90 },
	{ 0xE6, 0x97, 0x97 },
	{ 0xE7, 0xA5, 0x88 },
	{ 0xE7, 0xA5, 0x81 },
	{ 0xE9, 0xAA, 0x91 },
	{ 0xE8, 0xB5, 0xB7 },
	{ 0xE5, 0xB2, 0x82 },
	{ 0xE4, 0xB9, 0x9E },
	{ 0xE4, 0xBC, 0x81 },
	{ 0xE5, 0x90, 0xAF },
	{ 0xE5, 0xA5, 0x91 },
	{ 0xE7, 0xA0, 0x8C },
	{ 0xE5, 0x99, 0xA8 },
	{ 0xE6, 0xB0, 0x94 },
	{ 0xE8, 0xBF, 0x84 },
	{ 0xE5, 0xBC, 0x83 },
	{ 0xE6, 0xB1, 0xBD },
	{ 0xE6, 0xB3, 0xA3 },
	{ 0xE8, 0xAE, 0xAB },
	{ 0xE6, 0x8E, 0x90 },
	{ 0xE6, 0x81, 0xB0 },
	{ 0xE6, 0xB4, 0xBD },
	{ 0xE7, 0x89, 0xB5 },
	{ 0xE6, 0x89, 0xA6 },
	{ 0xE9, 0x92, 0x8E },
	{ 0xE9, 0x93, 0x85 },
	{ 0xE5, 0x8D, 0x83 },
	{ 0xE8, 0xBF, 0x81 },
	{ 0xE7, 0xAD, 0xBE },
	{ 0xE4, 0xBB, 0x9F },
	{ 0xE8, 0xB0, 0xA6 },
	{ 0xE4, 0xB9, 0xBE },
	{ 0xE9, 0xBB, 0x94 },
	{ 0xE9, 0x92, 0xB1 },
	{ 0xE9, 0x92, 0xB3 },
	{ 0xE5, 0x89, 0x8D },
	{ 0xE6, 0xBD, 0x9C },
	{ 0xE9, 0x81, 0xA3 },
	{ 0xE6, 0xB5, 0x85 },
	{ 0xE8, 0xB0, 0xB4 },
	{ 0xE5, 0xA0, 0x91 },
	{ 0xE5, 0xB5, 0x8C },
	{ 0xE6, 0xAC, 0xA0 },
	{ 0xE6, 0xAD, 0x89 },
	{ 0xE6, 0x9E, 0xAA },
	{ 0xE5, 0x91, 0x9B },
	{ 0xE8, 0x85, 0x94 },
	{ 0xE7, 0xBE, 0x8C },
	{ 0xE5, 0xA2, 0x99 },
	{ 0xE8, 0x94, 0xB7 },
	{ 0xE5, 0xBC, 0xBA },
	{ 0xE6, 0x8A, 0xA2 },
	{ 0xE6, 0xA9, 0x87 },
	{ 0xE9, 0x94, 0xB9 },
	{ 0xE6, 0x95, 0xB2 },
	{ 0xE6, 0x82, 0x84 },
	{ 0xE6, 0xA1, 0xA5 },
	{ 0xE7, 0x9E, 0xA7 },
	{ 0xE4, 0xB9, 0x94 },
	{ 0xE4, 0xBE, 0xA8 },
	{ 0xE5, 0xB7, 0xA7 },
	{ 0xE9, 0x9E, 0x98 },
	{ 0xE6, 0x92, 0xAC },
	{ 0xE7, 0xBF, 0x98 },
	{ 0xE5, 0xB3, 0xAD },
	{ 0xE4, 0xBF, 0x8F },
	{ 0xE7, 0xAA, 0x8D },
	{ 0xE5, 0x88, 0x87 },
	{ 0xE8, 0x8C, 0x84 },
	{ 0xE4, 0xB8, 0x94 },
	{ 0xE6, 0x80, 0xAF },
	{ 0xE7, 0xAA, 0x83 },
	{ 0xE9, 0x92, 0xA6 },
	{ 0xE4, 0xBE, 0xB5 },
	{ 0xE4, 0xBA, 0xB2 },
	{ 0xE7, 0xA7, 0xA6 },
	{ 0xE7, 0x90, 0xB4 },
	{ 0xE5, 0x8B, 0xA4 },
	{ 0xE8, 0x8A, 0xB9 },
	{ 0xE6, 0x93, 0x92 },
	{ 0xE7, 0xA6, 0xBD },
	{ 0xE5, 0xAF, 0x9D },
	{ 0xE6, 0xB2, 0x81 },
	{ 0xE9, 0x9D, 0x92 },
	{ 0xE8, 0xBD, 0xBB },
	{ 0xE6, 0xB0, 0xA2 },
	{ 0xE5, 0x80, 0xBE },
	{ 0xE5, 0x8D, 0xBF },
	{ 0xE6, 0xB8, 0x85 },
	{ 0xE6, 0x93, 0x8E },
	{ 0xE6, 0x99, 0xB4 },
	{ 0xE6, 0xB0, 0xB0 },
	{ 0xE6, 0x83, 0x85 },
	{ 0xE9, 0xA1, 0xB7 },
	{ 0xE8, 0xAF, 0xB7 },
	{ 0xE5, 0xBA, 0x86 },
	{ 0xE7, 0x90, 0xBC },
	{ 0xE7, 0xA9, 0xB7 },
	{ 0xE7, 0xA7, 0x8B },
	{ 0xE4, 0xB8, 0x98 },
	{ 0xE9, 0x82, 0xB1 },
	{ 0xE7, 0x90, 0x83 },
	{ 0xE6, 0xB1, 0x82 },
	{ 0xE5, 0x9B, 0x9A },
	{ 0xE9, 0x85, 0x8B },
	{ 0xE6, 0xB3, 0x85 },
	{ 0xE8, 0xB6, 0x8B },
	{ 0xE5, 0x8C, 0xBA },
	{ 0xE8, 0x9B, 0x86 },
	{ 0xE6, 0x9B, 0xB2 },
	{ 0xE8, 0xBA, 0xAF },
	{ 0xE5, 0xB1, 0x88 },
	{ 0xE9, 0xA9, 0xB1 },
	{ 0xE6, 0xB8, 0xA0 },
	{ 0xE5, 0x8F, 0x96 },
	{ 0xE5, 0xA8, 0xB6 },
	{ 0xE9, 0xBE, 0x8B },
	{ 0xE8, 0xB6, 0xA3 },
	{ 0xE5, 0x8E, 0xBB },
	{ 0xE5, 0x9C, 0x88 },
	{ 0xE9, 0xA2, 0xA7 },
	{ 0xE6, 0x9D, 0x83 },
	{ 0xE9, 0x86, 0x9B },
	{ 0xE6, 0xB3, 0x89 },
	{ 0xE5, 0x85, 0xA8 },
	{ 0xE7, 0x97, 0x8A },
	{ 0xE6, 0x8B, 0xB3 },
	{ 0xE7, 0x8A, 0xAC },
	{ 0xE5, 0x88, 0xB8 },
	{ 0xE5, 0x8A, 0x9D },
	{ 0xE7, 0xBC, 0xBA },
	{ 0xE7, 0x82, 0x94 },
	{ 0xE7, 0x98, 0xB8 },
	{ 0xE5, 0x8D, 0xB4 },
	{ 0xE9, 0xB9, 0x8A },
	{ 0xE6, 0xA6, 0xB7 },
	{ 0xE7, 0xA1, 0xAE },
	{ 0xE9, 0x9B, 0x80 },
	{ 0xE8, 0xA3, 0x99 },
	{ 0xE7, 0xBE, 0xA4 },
	{ 0xE7, 0x84, 0xB6 },
	{ 0xE7, 0x87, 0x83 },
	{ 0xE5, 0x86, 0x89 },
	{ 0xE6, 0x9F, 0x93 },
	{ 0xE7, 0x93, 0xA4 },
	{ 0xE5, 0xA3, 0xA4 },
	{ 0xE6, 0x94, 0x98 },
	{ 0xE5, 0x9A, 0xB7 },
	{ 0xE8, 0xAE, 0xA9 },
	{ 0xE9, 0xA5, 0xB6 },
	{ 0xE6, 0x89, 0xB0 },
	{ 0xE7, 0xBB, 0x95 },
	{ 0xE6, 0x83, 0xB9 },
	{ 0xE7, 0x83, 0xAD },
	{ 0xE5, 0xA3, 0xAC },
	{ 0xE4, 0xBB, 0x81 },
	{ 0xE4, 0xBA, 0xBA },
	{ 0xE5, 0xBF, 0x8D },
	{ 0xE9, 0x9F, 0xA7 },
	{ 0xE4, 0xBB, 0xBB },
	{ 0xE8, 0xAE, 0xA4 },
	{ 0xE5, 0x88, 0x83 },
	{ 0xE5, 0xA6, 0x8A },
	{ 0xE7, 0xBA, 0xAB },
	{ 0xE6, 0x89, 0x94 },
	{ 0xE4, 0xBB, 0x8D },
	{ 0xE6, 0x97, 0xA5 },
	{ 0xE6, 0x88, 0x8E },
	{ 0xE8, 0x8C, 0xB8 },
	{ 0xE8, 0x93, 0x89 },
	{ 0xE8, 0x8D, 0xA3 },
	{ 0xE8, 0x9E, 0x8D },
	{ 0xE7, 0x86, 0x94 },
	{ 0xE6, 0xBA, 0xB6 },
	{ 0xE5, 0xAE, 0xB9 },
	{ 0xE7, 0xBB, 0x92 },
	{ 0xE5, 0x86, 0x97 },
	{ 0xE6, 0x8F, 0x89 },
	{ 0xE6, 0x9F, 0x94 },
	{ 0xE8, 0x82, 0x89 },
	{ 0xE8, 0x8C, 0xB9 },
	{ 0xE8, 0xA0, 0x95 },
	{ 0xE5, 0x84, 0x92 },
	{ 0xE5, 0xAD, 0xBA },
	{ 0xE5, 0xA6, 0x82 },
	{ 0xE8, 0xBE, 0xB1 },
	{ 0xE4, 0xB9, 0xB3 },
	{ 0xE6, 0xB1, 0x9D },
	{ 0xE5, 0x85, 0xA5 },
	{ 0xE8, 0xA4, 0xA5 },
	{ 0xE8, 0xBD, 0xAF },
	{ 0xE9, 0x98, 0xAE },
	{ 0xE8, 0x95, 0x8A },
	{ 0xE7, 0x91, 0x9E },
	{ 0xE9, 0x94, 0x90 },
	{ 0xE9, 0x97, 0xB0 },
	{ 0xE6, 0xB6, 0xA6 },
	{ 0xE8, 0x8B, 0xA5 },
	{ 0xE5, 0xBC, 0xB1 },
	{ 0xE6, 0x92, 0x92 },
	{ 0xE6, 0xB4, 0x92 },
	{ 0xE8, 0x90, 0xA8 },
	{ 0xE8, 0x85, 0xAE },
	{ 0xE9, 0xB3, 0x83 },
	{ 0xE5, 0xA1, 0x9E },
	{ 0xE8, 0xB5, 0x9B },
	{ 0xE4, 0xB8, 0x89 },
	{ 0xE5, 0x8F, 0x81 },
	{ 0xE4, 0xBC, 0x9E },
	{ 0xE6, 0x95, 0xA3 },
	{ 0xE6, 0xA1, 0x91 },
	{ 0xE5, 0x97, 0x93 },
	{ 0xE4, 0xB8, 0xA7 },
	{ 0xE6, 0x90, 0x94 },
	{ 0xE9, 0xAA, 0x9A },
	{ 0xE6, 0x89, 0xAB },
	{ 0xE5, 0xAB, 0x82 },
	{ 0xE7, 0x91, 0x9F },
	{ 0xE8, 0x89, 0xB2 },
	{ 0xE6, 0xB6, 0xA9 },
	{ 0xE6, 0xA3, 0xAE },
	{ 0xE5, 0x83, 0xA7 },
	{ 0xE8, 0x8E, 0x8E },
	{ 0xE7, 0xA0, 0x82 },
	{ 0xE6, 0x9D, 0x80 },
	{ 0xE5, 0x88, 0xB9 },
	{ 0xE6, 0xB2, 0x99 },
	{ 0xE7, 0xBA, 0xB1 },
	{ 0xE5, 0x82, 0xBB },
	{ 0xE5, 0x95, 0xA5 },
	{ 0xE7, 0x85, 0x9E },
	{ 0xE7, 0xAD, 0x9B },
	{ 0xE6, 0x99, 0x92 },
	{ 0xE7, 0x8F, 0x8A },
	{ 0xE8, 0x8B, 0xAB },
	{ 0xE6, 0x9D, 0x89 },
	{ 0xE5, 0xB1, 0xB1 },
	{ 0xE5, 0x88, 0xA0 },
	{ 0xE7, 0x85, 0xBD },
	{ 0xE8, 0xA1, 0xAB },
	{ 0xE9, 0x97, 0xAA },
	{ 0xE9, 0x99, 0x95 },
	{ 0xE6, 0x93, 0x85 },
	{ 0xE8, 0xB5, 0xA1 },
	{ 0xE8, 0x86, 0xB3 },
	{ 0xE5, 0x96, 0x84 },
	{ 0xE6, 0xB1, 0x95 },
	{ 0xE6, 0x89, 0x87 },
	{ 0xE7, 0xBC, 0xAE },
	{ 0xE5, 0xA2, 0x92 },
	{ 0xE4, 0xBC, 0xA4 },
	{ 0xE5, 0x95, 0x86 },
	{ 0xE8, 0xB5, 0x8F },
	{ 0xE6, 0x99, 0x8C },
	{ 0xE4, 0xB8, 0x8A },
	{ 0xE5, 0xB0, 0x9A },
	{ 0xE8, 0xA3, 0xB3 },
	{ 0xE6, 0xA2, 0xA2 },
	{ 0xE6, 0x8D, 0x8E },
	{ 0xE7, 0xA8, 0x8D },
	{ 0xE7, 0x83, 0xA7 },
	{ 0xE8, 0x8A, 0x8D },
	{ 0xE5, 0x8B, 0xBA },
	{ 0xE9, 0x9F, 0xB6 },
	{ 0xE5, 0xB0, 0x91 },
	{ 0xE5, 0x93, 0xA8 },
	{ 0xE9, 0x82, 0xB5 },
	{ 0xE7, 0xBB, 0x8D },
	{ 0xE5, 0xA5, 0xA2 },
	{ 0xE8, 0xB5, 0x8A },
	{ 0xE8, 0x9B, 0x87 },
	{ 0xE8, 0x88, 0x8C },
	{ 0xE8, 0x88, 0x8D },
	{ 0xE8, 0xB5, 0xA6 },
	{ 0xE6, 0x91, 0x84 },
	{ 0xE5, 0xB0, 0x84 },
	{ 0xE6, 0x85, 0x91 },
	{ 0xE6, 0xB6, 0x89 },
	{ 0xE7, 0xA4, 0xBE },
	{ 0xE8, 0xAE, 0xBE },
	{ 0xE7, 0xA0, 0xB7 },
	{ 0xE7, 0x94, 0xB3 },
	{ 0xE5, 0x91, 0xBB },
	{ 0xE4, 0xBC, 0xB8 },
	{ 0xE8, 0xBA, 0xAB },
	{ 0xE6, 0xB7, 0xB1 },
	{ 0xE5, 0xA8, 0xA0 },
	{ 0xE7, 0xBB, 0x85 },
	{ 0xE7, 0xA5, 0x9E },
	{ 0xE6, 0xB2, 0x88 },
	{ 0xE5, 0xAE, 0xA1 },
	{ 0xE5, 0xA9, 0xB6 },
	{ 0xE7, 0x94, 0x9A },
	{ 0xE8, 0x82, 0xBE },
	{ 0xE6, 0x85, 0x8E },
	{ 0xE6, 0xB8, 0x97 },
	{ 0xE5, 0xA3, 0xB0 },
	{ 0xE7, 0x94, 0x9F },
	{ 0xE7, 0x94, 0xA5 },
	{ 0xE7, 0x89, 0xB2 },
	{ 0xE5, 0x8D, 0x87 },
	{ 0xE7, 0xBB, 0xB3 },
	{ 0xE7, 0x9C, 0x81 },
	{ 0xE7, 0x9B, 0x9B },
	{ 0xE5, 0x89, 0xA9 },
	{ 0xE8, 0x83, 0x9C },
	{ 0xE5, 0x9C, 0xA3 },
	{ 0xE5, 0xB8, 0x88 },
	{ 0xE5, 0xA4, 0xB1 },
	{ 0xE7, 0x8B, 0xAE },
	{ 0xE6, 0x96, 0xBD },
	{ 0xE6, 0xB9, 0xBF },
	{ 0xE8, 0xAF, 0x97 },
	{ 0xE5, 0xB0, 0xB8 },
	{ 0xE8, 0x99, 0xB1 },
	{ 0xE5, 0x8D, 0x81 },
	{ 0xE7, 0x9F, 0xB3 },
	{ 0xE6, 0x8B, 0xBE },
	{ 0xE6, 0x97, 0xB6 },
	{ 0xE4, 0xBB, 0x80 },
	{ 0xE9, 0xA3, 0x9F },
	{ 0xE8, 0x9A, 0x80 },
	{ 0xE5, 0xAE, 0x9E },
	{ 0xE8, 0xAF, 0x86 },
	{ 0xE5, 0x8F, 0xB2 },
	{ 0xE7, 0x9F, 0xA2 },
	{ 0xE4, 0xBD, 0xBF },
	{ 0xE5, 0xB1, 0x8E },
	{ 0xE9, 0xA9, 0xB6 },
	{ 0xE5, 0xA7, 0x8B },
	{ 0xE5, 0xBC, 0x8F },
	{ 0xE7, 0xA4, 0xBA },
	{ 0xE5, 0xA3, 0xAB },
	{ 0xE4, 0xB8, 0x96 },
	{ 0xE6, 0x9F, 0xBF },
	{ 0xE4, 0xBA, 0x8B },
	{ 0xE6, 0x8B, 0xAD },
	{ 0xE8, 0xAA, 0x93 },
	{ 0xE9, 0x80, 0x9D },
	{ 0xE5, 0x8A, 0xBF },
	{ 0xE6, 0x98, 0xAF },
	{ 0xE5, 0x97, 0x9C },
	{ 0xE5, 0x99, 0xAC },
	{ 0xE9, 0x80, 0x82 },
	{ 0xE4, 0xBB, 0x95 },
	{ 0xE4, 0xBE, 0x8D },
	{ 0xE9, 0x87, 0x8A },
	{ 0xE9, 0xA5, 0xB0 },
	{ 0xE6, 0xB0, 0x8F },
	{ 0xE5, 0xB8, 0x82 },
	{ 0xE6, 0x81, 0x83 },
	{ 0xE5, 0xAE, 0xA4 },
	{ 0xE8, 0xA7, 0x86 },
	{ 0xE8, 0xAF, 0x95 },
	{ 0xE6, 0x94, 0xB6 },
	{ 0xE6, 0x89, 0x8B },
	{ 0xE9, 0xA6, 0x96 },
	{ 0xE5, 0xAE, 0x88 },
	{ 0xE5, 0xAF, 0xBF },
	{ 0xE6, 0x8E, 0x88 },
	{ 0xE5, 0x94, 0xAE },
	{ 0xE5, 0x8F, 0x97 },
	{ 0xE7, 0x98, 0xA6 },
	{ 0xE5, 0x85, 0xBD },
	{ 0xE8, 0x94, 0xAC },
	{ 0xE6, 0x9E, 0xA2 },
	{ 0xE6, 0xA2, 0xB3 },
	{ 0xE6, 0xAE, 0x8A },
	{ 0xE6, 0x8A, 0x92 },
	{ 0xE8, 0xBE, 0x93 },
	{ 0xE5, 0x8F, 0x94 },
	{ 0xE8, 0x88, 0x92 },
	{ 0xE6, 0xB7, 0x91 },
	{ 0xE7, 0x96, 0x8F },
	{ 0xE4, 0xB9, 0xA6 },
	{ 0xE8, 0xB5, 0x8E },
	{ 0xE5, 0xAD, 0xB0 },
	{ 0xE7, 0x86, 0x9F },
	{ 0xE8, 0x96, 0xAF },
	{ 0xE6, 0x9A, 0x91 },
	{ 0xE6, 0x9B, 0x99 },
	{ 0xE7, 0xBD, 0xB2 },
	{ 0xE8, 0x9C, 0x80 },
	{ 0xE9, 0xBB, 0x8D },
	{ 0xE9, 0xBC, 0xA0 },
	{ 0xE5, 0xB1, 0x9E },
	{ 0xE6, 0x9C, 0xAF },
	{ 0xE8, 0xBF, 0xB0 },
	{ 0xE6, 0xA0, 0x91 },
	{ 0xE6, 0x9D, 0x9F },
	{ 0xE6, 0x88, 0x8D },
	{ 0xE7, 0xAB, 0x96 },
	{ 0xE5, 0xA2, 0x85 },
	{ 0xE5, 0xBA, 0xB6 },
	{ 0xE6, 0x95, 0xB0 },
	{ 0xE6, 0xBC, 0xB1 },
	{ 0xE6, 0x81, 0x95 },
	{ 0xE5, 0x88, 0xB7 },
	{ 0xE8, 0x80, 0x8D },
	{ 0xE6, 0x91, 0x94 },
	{ 0xE8, 0xA1, 0xB0 },
	{ 0xE7, 0x94, 0xA9 },
	{ 0xE5, 0xB8, 0x85 },
	{ 0xE6, 0xA0, 0x93 },
	{ 0xE6, 0x8B, 0xB4 },
	{ 0xE9, 0x9C, 0x9C },
	{ 0xE5, 0x8F, 0x8C },
	{ 0xE7, 0x88, 0xBD },
	{ 0xE8, 0xB0, 0x81 },
	{ 0xE6, 0xB0, 0xB4 },
	{ 0xE7, 0x9D, 0xA1 },
	{ 0xE7, 0xA8, 0x8E },
	{ 0xE5, 0x90, 0xAE },
	{ 0xE7, 0x9E, 0xAC },
	{ 0xE9, 0xA1, 0xBA },
	{ 0xE8, 0x88, 0x9C },
	{ 0xE8, 0xAF, 0xB4 },
	{ 0xE7, 0xA1, 0x95 },
	{ 0xE6, 0x9C, 0x94 },
	{ 0xE7, 0x83, 0x81 },
	{ 0xE6, 0x96, 0xAF },
	{ 0xE6, 0x92, 0x95 },
	{ 0xE5, 0x98, 0xB6 },
	{ 0xE6, 0x80, 0x9D },
	{ 0xE7, 0xA7, 0x81 },
	{ 0xE5, 0x8F, 0xB8 },
	{ 0xE4, 0xB8, 0x9D },
	{ 0xE6, 0xAD, 0xBB },
	{ 0xE8, 0x82, 0x86 },
	{ 0xE5, 0xAF, 0xBA },
	{ 0xE5, 0x97, 0xA3 },
	{ 0xE5, 0x9B, 0x9B },
	{ 0xE4, 0xBC, 0xBA },
	{ 0xE4, 0xBC, 0xBC },
	{ 0xE9, 0xA5, 0xB2 },
	{ 0xE5, 0xB7, 0xB3 },
	{ 0xE6, 0x9D, 0xBE },
	{ 0xE8, 0x80, 0xB8 },
	{ 0xE6, 0x80, 0x82 },
	{ 0xE9, 0xA2, 0x82 },
	{ 0xE9, 0x80, 0x81 },
	{ 0xE5, 0xAE, 0x8B },
	{ 0xE8, 0xAE, 0xBC },
	{ 0xE8, 0xAF, 0xB5 },
	{ 0xE6, 0x90, 0x9C },
	{ 0xE8, 0x89, 0x98 },
	{ 0xE6, 0x93, 0x9E },
	{ 0xE5, 0x97, 0xBD },
	{ 0xE8, 0x8B, 0x8F },
	{ 0xE9, 0x85, 0xA5 },
	{ 0xE4, 0xBF, 0x97 },
	{ 0xE7, 0xB4, 0xA0 },
	{ 0xE9, 0x80, 0x9F },
	{ 0xE7, 0xB2, 0x9F },
	{ 0xE5, 0x83, 0xB3 },
	{ 0xE5, 0xA1, 0x91 },
	{ 0xE6, 0xBA, 0xAF },
	{ 0xE5, 0xAE, 0xBF },
	{ 0xE8, 0xAF, 0x89 },
	{ 0xE8, 0x82, 0x83 },
	{ 0xE9, 0x85, 0xB8 },
	{ 0xE8, 0x92, 0x9C },
	{ 0xE7, 0xAE, 0x97 },
	{ 0xE8, 0x99, 0xBD },
	{ 0xE9, 0x9A, 0x8B },
	{ 0xE9, 0x9A, 0x8F },
	{ 0xE7, 0xBB, 0xA5 },
	{ 0xE9, 0xAB, 0x93 },
	{ 0xE7, 0xA2, 0x8E },
	{ 0xE5, 0xB2, 0x81 },
	{ 0xE7, 0xA9, 0x97 },
	{ 0xE9, 0x81, 0x82 },
	{ 0xE9, 0x9A, 0xA7 },
	{ 0xE7, 0xA5, 0x9F },
	{ 0xE5, 0xAD, 0x99 },
	{ 0xE6, 0x8D, 0x9F },
	{ 0xE7, 0xAC, 0x8B },
	{ 0xE8, 0x93, 0x91 },
	{ 0xE6, 0xA2, 0xAD },
	{ 0xE5, 0x94, 0x86 },
	{ 0xE7, 0xBC, 0xA9 },
	{ 0xE7, 0x90, 0x90 },
	{ 0xE7, 0xB4, 0xA2 },
	{ 0xE9, 0x94, 0x81 },
	{ 0xE6, 0x89, 0x80 },
	{ 0xE5, 0xA1, 0x8C },
	{ 0xE4, 0xBB, 0x96 },
	{ 0xE5, 0xAE, 0x83 },
	{ 0xE5, 0xA5, 0xB9 },
	{ 0xE5, 0xA1, 0x94 },
	{ 0xE7, 0x8D, 0xAD },
	{ 0xE6, 0x8C, 0x9E },
	{ 0xE8, 0xB9, 0x8B },
	{ 0xE8, 0xB8, 0x8F },
	{ 0xE8, 0x83, 0x8E },
	{ 0xE8, 0x8B, 0x94 },
	{ 0xE6, 0x8A, 0xAC },
	{ 0xE5, 0x8F, 0xB0 },
	{ 0xE6, 0xB3, 0xB0 },
	{ 0xE9, 0x85, 0x9E },
	{ 0xE5, 0xA4, 0xAA },
	{ 0xE6, 0x80, 0x81 },
	{ 0xE6, 0xB1, 0xB0 },
	{ 0xE5, 0x9D, 0x8D },
	{ 0xE6, 0x91, 0x8A },
	{ 0xE8, 0xB4, 0xAA },
	{ 0xE7, 0x98, 0xAB },
	{ 0xE6, 0xBB, 0xA9 },
	{ 0xE5, 0x9D, 0x9B },
	{ 0xE6, 0xAA, 0x80 },
	{ 0xE7, 0x97, 0xB0 },
	{ 0xE6, 0xBD, 0xAD },
	{ 0xE8, 0xB0, 0xAD },
	{ 0xE8, 0xB0, 0x88 },
	{ 0xE5, 0x9D, 0xA6 },
	{ 0xE6, 0xAF, 0xAF },
	{ 0xE8, 0xA2, 0x92 },
	{ 0xE7, 0xA2, 0xB3 },
	{ 0xE6, 0x8E, 0xA2 },
	{ 0xE5, 0x8F, 0xB9 },
	{ 0xE7, 0x82, 0xAD },
	{ 0xE6, 0xB1, 0xA4 },
	{ 0xE5, 0xA1, 0x98 },
	{ 0xE6, 0x90, 0xAA },
	{ 0xE5, 0xA0, 0x82 },
	{ 0xE6, 0xA3, 0xA0 },
	{ 0xE8, 0x86, 0x9B },
	{ 0xE5, 0x94, 0x90 },
	{ 0xE7, 0xB3, 0x96 },
	{ 0xE5, 0x80, 0x98 },
	{ 0xE8, 0xBA, 0xBA },
	{ 0xE6, 0xB7, 0x8C },
	{ 0xE8, 0xB6, 0x9F },
	{ 0xE7, 0x83, 0xAB },
	{ 0xE6, 0x8E, 0x8F },
	{ 0xE6, 0xB6, 0x9B },
	{ 0xE6, 0xBB, 0x94 },
	{ 0xE7, 0xBB, 0xA6 },
	{ 0xE8, 0x90, 0x84 },
	{ 0xE6, 0xA1, 0x83 },
	{ 0xE9, 0x80, 0x83 },
	{ 0xE6, 0xB7, 0x98 },
	{ 0xE9, 0x99, 0xB6 },
	{ 0xE8, 0xAE, 0xA8 },
	{ 0xE5, 0xA5, 0x97 },
	{ 0xE7, 0x89, 0xB9 },
	{ 0xE8, 0x97, 0xA4 },
	{ 0xE8, 0x85, 0xBE },
	{ 0xE7, 0x96, 0xBC },
	{ 0xE8, 0xAA, 0x8A },
	{ 0xE6, 0xA2, 0xAF },
	{ 0xE5, 0x89, 0x94 },
	{ 0xE8, 0xB8, 0xA2 },
	{ 0xE9, 0x94, 0x91 },
	{ 0xE6, 0x8F, 0x90 },
	{ 0xE9, 0xA2, 0x98 },
	{ 0xE8, 0xB9, 0x84 },
	{ 0xE5, 0x95, 0xBC },
	{ 0xE4, 0xBD, 0x93 },
	{ 0xE6, 0x9B, 0xBF },
	{ 0xE5, 0x9A, 0x8F },
	{ 0xE6, 0x83, 0x95 },
	{ 0xE6, 0xB6, 0x95 },
	{ 0xE5, 0x89, 0x83 },
	{ 0xE5, 0xB1, 0x89 },
	{ 0xE5, 0xA4, 0xA9 },
	{ 0xE6, 0xB7, 0xBB },
	{ 0xE5, 0xA1, 0xAB },
	{ 0xE7, 0x94, 0xB0 },
	{ 0xE7, 0x94, 0x9C },
	{ 0xE6, 0x81, 0xAC },
	{ 0xE8, 0x88, 0x94 },
	{ 0xE8, 0x85, 0x86 },
	{ 0xE6, 0x8C, 0x91 },
	{ 0xE6, 0x9D, 0xA1 },
	{ 0xE8, 0xBF, 0xA2 },
	{ 0xE7, 0x9C, 0xBA },
	{ 0xE8, 0xB7, 0xB3 },
	{ 0xE8, 0xB4, 0xB4 },
	{ 0xE9, 0x93, 0x81 },
	{ 0xE5, 0xB8, 0x96 },
	{ 0xE5, 0x8E, 0x85 },
	{ 0xE5, 0x90, 0xAC },
	{ 0xE7, 0x83, 0x83 },
	{ 0xE6, 0xB1, 0x80 },
	{ 0xE5, 0xBB, 0xB7 },
	{ 0xE5, 0x81, 0x9C },
	{ 0xE4, 0xBA, 0xAD },
	{ 0xE5, 0xBA, 0xAD },
	{ 0xE6, 0x8C, 0xBA },
	{ 0xE8, 0x89, 0x87 },
	{ 0xE9, 0x80, 0x9A },
	{ 0xE6, 0xA1, 0x90 },
	{ 0xE9, 0x85, 0xAE },
	{ 0xE7, 0x9E, 0xB3 },
	{ 0xE5, 0x90, 0x8C },
	{ 0xE9, 0x93, 0x9C },
	{ 0xE5, 0xBD, 0xA4 },
	{ 0xE7, 0xAB, 0xA5 },
	{ 0xE6, 0xA1, 0xB6 },
	{ 0xE6, 0x8D, 0x85 },
	{ 0xE7, 0xAD, 0x92 },
	{ 0xE7, 0xBB, 0x9F },
	{ 0xE7, 0x97, 0x9B },
	{ 0xE5, 0x81, 0xB7 },
	{ 0xE6, 0x8A, 0x95 },
	{ 0xE5, 0xA4, 0xB4 },
	{ 0xE9, 0x80, 0x8F },
	{ 0xE5, 0x87, 0xB8 },
	{ 0xE7, 0xA7, 0x83 },
	{ 0xE7, 0xAA, 0x81 },
	{ 0xE5, 0x9B, 0xBE },
	{ 0xE5, 0xBE, 0x92 },
	{ 0xE9, 0x80, 0x94 },
	{ 0xE6, 0xB6, 0x82 },
	{ 0xE5, 0xB1, 0xA0 },
	{ 0xE5, 0x9C, 0x9F },
	{ 0xE5, 0x90, 0x90 },
	{ 0xE5, 0x85, 0x94 },
	{ 0xE6, 0xB9, 0x8D },
	{ 0xE5, 0x9B, 0xA2 },
	{ 0xE6, 0x8E, 0xA8 },
	{ 0xE9, 0xA2, 0x93 },
	{ 0xE8, 0x85, 0xBF },
	{ 0xE8, 0x9C, 0x95 },
	{ 0xE8, 0xA4, 0xAA },
	{ 0xE9, 0x80, 0x80 },
	{ 0xE5, 0x90, 0x9E },
	{ 0xE5, 0xB1, 0xAF },
	{ 0xE8, 0x87, 0x80 },
	{ 0xE6, 0x8B, 0x96 },
	{ 0xE6, 0x89, 0x98 },
	{ 0xE8, 0x84, 0xB1 },
	{ 0xE9, 0xB8, 0xB5 },
	{ 0xE9, 0x99, 0x80 },
	{ 0xE9, 0xA9, 0xAE },
	{ 0xE9, 0xA9, 0xBC },
	{ 0xE6, 0xA4, 0xAD },
	{ 0xE5, 0xA6, 0xA5 },
	{ 0xE6, 0x8B, 0x93 },
	{ 0xE5, 0x94, 0xBE },
	{ 0xE6, 0x8C, 0x96 },
	{ 0xE5, 0x93, 0x87 },
	{ 0xE8, 0x9B, 0x99 },
	{ 0xE6, 0xB4, 0xBC },
	{ 0xE5, 0xA8, 0x83 },
	{ 0xE7, 0x93, 0xA6 },
	{ 0xE8, 0xA2, 0x9C },
	{ 0xE6, 0xAD, 0xAA },
	{ 0xE5, 0xA4, 0x96 },
	{ 0xE8, 0xB1, 0x8C },
	{ 0xE5, 0xBC, 0xAF },
	{ 0xE6, 0xB9, 0xBE },
	{ 0xE7, 0x8E, 0xA9 },
	{ 0xE9, 0xA1, 0xBD },
	{ 0xE4, 0xB8, 0xB8 },
	{ 0xE7, 0x83, 0xB7 },
	{ 0xE5, 0xAE, 0x8C },
	{ 0xE7, 0xA2, 0x97 },
	{ 0xE6, 0x8C, 0xBD },
	{ 0xE6, 0x99, 0x9A },
	{ 0xE7, 0x9A, 0x96 },
	{ 0xE6, 0x83, 0x8B },
	{ 0xE5, 0xAE, 0x9B },
	{ 0xE5, 0xA9, 0x89 },
	{ 0xE4, 0xB8, 0x87 },
	{ 0xE8, 0x85, 0x95 },
	{ 0xE6, 0xB1, 0xAA },
	{ 0xE7, 0x8E, 0x8B },
	{ 0xE4, 0xBA, 0xA1 },
	{ 0xE6, 0x9E, 0x89 },
	{ 0xE7, 0xBD, 0x91 },
	{ 0xE5, 0xBE, 0x80 },
	{ 0xE6, 0x97, 0xBA },
	{ 0xE6, 0x9C, 0x9B },
	{ 0xE5, 0xBF, 0x98 },
	{ 0xE5, 0xA6, 0x84 },
	{ 0xE5, 0xA8, 0x81 },
	{ 0xE5, 0xB7, 0x8D },
	{ 0xE5, 0xBE, 0xAE },
	{ 0xE5, 0x8D, 0xB1 },
	{ 0xE9, 0x9F, 0xA6 },
	{ 0xE8, 0xBF, 0x9D },
	{ 0xE6, 0xA1, 0x85 },
	{ 0xE5, 0x9B, 0xB4 },
	{ 0xE5, 0x94, 0xAF },
	{ 0xE6, 0x83, 0x9F },
	{ 0xE4, 0xB8, 0xBA },
	{ 0xE6, 0xBD, 0x8D },
	{ 0xE7, 0xBB, 0xB4 },
	{ 0xE8, 0x8B, 0x87 },
	{ 0xE8, 0x90, 0x8E },
	{ 0xE5, 0xA7, 0x94 },
	{ 0xE4, 0xBC, 0x9F },
	{ 0xE4, 0xBC, 0xAA },
	{ 0xE5, 0xB0, 0xBE },
	{ 0xE7, 0xBA, 0xAC },
	{ 0xE6, 0x9C, 0xAA },
	{ 0xE8, 0x94, 0x9A },
	{ 0xE5, 0x91, 0xB3 },
	{ 0xE7, 0x95, 0x8F },
	{ 0xE8, 0x83, 0x83 },
	{ 0xE5, 0x96, 0x82 },
	{ 0xE9, 0xAD, 0x8F },
	{ 0xE4, 0xBD, 0x8D },
	{ 0xE6, 0xB8, 0xAD },
	{ 0xE8, 0xB0, 0x93 },
	{ 0xE5, 0xB0, 0x89 },
	{ 0xE6, 0x85, 0xB0 },
	{ 0xE5, 0x8D, 0xAB },
	{ 0xE7, 0x98, 0x9F },
	{ 0xE6, 0xB8, 0xA9 },
	{ 0xE8, 0x9A, 0x8A },
	{ 0xE6, 0x96, 0x87 },
	{ 0xE9, 0x97, 0xBB },
	{ 0xE7, 0xBA, 0xB9 },
	{ 0xE5, 0x90, 0xBB },
	{ 0xE7, 0xA8, 0xB3 },
	{ 0xE7, 0xB4, 0x8A },
	{ 0xE9, 0x97, 0xAE },
	{ 0xE5, 0x97, 0xA1 },
	{ 0xE7, 0xBF, 0x81 },
	{ 0xE7, 0x93, 0xAE },
	{ 0xE6, 0x8C, 0x9D },
	{ 0xE8, 0x9C, 0x97 },
	{ 0xE6, 0xB6, 0xA1 },
	{ 0xE7, 0xAA, 0x9D },
	{ 0xE6, 0x88, 0x91 },
	{ 0xE6, 0x96, 0xA1 },
	{ 0xE5, 0x8D, 0xA7 },
	{ 0xE6, 0x8F, 0xA1 },
	{ 0xE6, 0xB2, 0x83 },
	{ 0xE5, 0xB7, 0xAB },
	{ 0xE5, 0x91, 0x9C },
	{ 0xE9, 0x92, 0xA8 },
	{ 0xE4, 0xB9, 0x8C },
	{ 0xE6, 0xB1, 0xA1 },
	{ 0xE8, 0xAF, 0xAC },
	{ 0xE5, 0xB1, 0x8B },
	{ 0xE6, 0x97, 0xA0 },
	{ 0xE8, 0x8A, 0x9C },
	{ 0xE6, 0xA2, 0xA7 },
	{ 0xE5, 0x90, 0xBE },
	{ 0xE5, 0x90, 0xB4 },
	{ 0xE6, 0xAF, 0x8B },
	{ 0xE6, 0xAD, 0xA6 },
	{ 0xE4, 0xBA, 0x94 },
	{ 0xE6, 0x8D, 0x82 },
	{ 0xE5, 0x8D, 0x88 },
	{ 0xE8, 0x88, 0x9E },
	{ 0xE4, 0xBC, 0x8D },
	{ 0xE4, 0xBE, 0xAE },
	{ 0xE5, 0x9D, 0x9E },
	{ 0xE6, 0x88, 0x8A },
	{ 0xE9, 0x9B, 0xBE },
	{ 0xE6, 0x99, 0xA4 },
	{ 0xE7, 0x89, 0xA9 },
	{ 0xE5, 0x8B, 0xBF },
	{ 0xE5, 0x8A, 0xA1 },
	{ 0xE6, 0x82, 0x9F },
	{ 0xE8, 0xAF, 0xAF },
	{ 0xE6, 0x98, 0x94 },
	{ 0xE7, 0x86, 0x99 },
	{ 0xE6, 0x9E, 0x90 },
	{ 0xE8, 0xA5, 0xBF },
	{ 0xE7, 0xA1, 0x92 },
	{ 0xE7, 0x9F, 0xBD },
	{ 0xE6, 0x99, 0xB0 },
	{ 0xE5, 0x98, 0xBB },
	{ 0xE5, 0x90, 0xB8 },
	{ 0xE9, 0x94, 0xA1 },
	{ 0xE7, 0x89, 0xBA },
	{ 0xE7, 0xA8, 0x80 },
	{ 0xE6, 0x81, 0xAF },
	{ 0xE5, 0xB8, 0x8C },
	{ 0xE6, 0x82, 0x89 },
	{ 0xE8, 0x86, 0x9D },
	{ 0xE5, 0xA4, 0x95 },
	{ 0xE6, 0x83, 0x9C },
	{ 0xE7, 0x86, 0x84 },
	{ 0xE7, 0x83, 0xAF },
	{ 0xE6, 0xBA, 0xAA },
	{ 0xE6, 0xB1, 0x90 },
	{ 0xE7, 0x8A, 0x80 },
	{ 0xE6, 0xAA, 0x84 },
	{ 0xE8, 0xA2, 0xAD },
	{ 0xE5, 0xB8, 0xAD },
	{ 0xE4, 0xB9, 0xA0 },
	{ 0xE5, 0xAA, 0xB3 },
	{ 0xE5, 0x96, 0x9C },
	{ 0xE9, 0x93, 0xA3 },
	{ 0xE6, 0xB4, 0x97 },
	{ 0xE7, 0xB3, 0xBB },
	{ 0xE9, 0x9A, 0x99 },
	{ 0xE6, 0x88, 0x8F },
	{ 0xE7, 0xBB, 0x86 },
	{ 0xE7, 0x9E, 0x8E },
	{ 0xE8, 0x99, 0xBE },
	{ 0xE5, 0x8C, 0xA3 },
	{ 0xE9, 0x9C, 0x9E },
	{ 0xE8, 0xBE, 0x96 },
	{ 0xE6, 0x9A, 0x87 },
	{ 0xE5, 0xB3, 0xA1 },
	{ 0xE4, 0xBE, 0xA0 },
	{ 0xE7, 0x8B, 0xAD },
	{ 0xE4, 0xB8, 0x8B },
	{ 0xE5, 0x8E, 0xA6 },
	{ 0xE5, 0xA4, 0x8F },
	{ 0xE5, 0x90, 0x93 },
	{ 0xE6, 0x8E, 0x80 },
	{ 0xE9, 0x94, 0xA8 },
	{ 0xE5, 0x85, 0x88 },
	{ 0xE4, 0xBB, 0x99 },
	{ 0xE9, 0xB2, 0x9C },
	{ 0xE7, 0xBA, 0xA4 },
	{ 0xE5, 0x92, 0xB8 },
	{ 0xE8, 0xB4, 0xA4 },
	{ 0xE8, 0xA1, 0x94 },
	{ 0xE8, 0x88, 0xB7 },
	{ 0xE9, 0x97, 0xB2 },
	{ 0xE6, 0xB6, 0x8E },
	{ 0xE5, 0xBC, 0xA6 },
	{ 0xE5, 0xAB, 0x8C },
	{ 0xE6, 0x98, 0xBE },
	{ 0xE9, 0x99, 0xA9 },
	{ 0xE7, 0x8E, 0xB0 },
	{ 0xE7, 0x8C, 0xAE },
	{ 0xE5, 0x8E, 0xBF },
	{ 0xE8, 0x85, 0xBA },
	{ 0xE9, 0xA6, 0x85 },
	{ 0xE7, 0xBE, 0xA1 },
	{ 0xE5, 0xAE, 0xAA },
	{ 0xE9, 0x99, 0xB7 },
	{ 0xE9, 0x99, 0x90 },
	{ 0xE7, 0xBA, 0xBF },
	{ 0xE7, 0x9B, 0xB8 },
	{ 0xE5, 0x8E, 0xA2 },
	{ 0xE9, 0x95, 0xB6 },
	{ 0xE9, 0xA6, 0x99 },
	{ 0xE7, 0xAE, 0xB1 },
	{ 0xE8, 0xA5, 0x84 },
	{ 0xE6, 0xB9, 0x98 },
	{ 0xE4, 0xB9, 0xA1 },
	{ 0xE7, 0xBF, 0x94 },
	{ 0xE7, 0xA5, 0xA5 },
	{ 0xE8, 0xAF, 0xA6 },
	{ 0xE6, 0x83, 0xB3 },
	{ 0xE5, 0x93, 0x8D },
	{ 0xE4, 0xBA, 0xAB },
	{ 0xE9, 0xA1, 0xB9 },
	{ 0xE5, 0xB7, 0xB7 },
	{ 0xE6, 0xA9, 0xA1 },
	{ 0xE5, 0x83, 0x8F },
	{ 0xE5, 0x90, 0x91 },
	{ 0xE8, 0xB1, 0xA1 },
	{ 0xE8, 0x90, 0xA7 },
	{ 0xE7, 0xA1, 0x9D },
	{ 0xE9, 0x9C, 0x84 },
	{ 0xE5, 0x89, 0x8A },
	{ 0xE5, 0x93, 0xAE },
	{ 0xE5, 0x9A, 0xA3 },
	{ 0xE9, 0x94, 0x80 },
	{ 0xE6, 0xB6, 0x88 },
	{ 0xE5, 0xAE, 0xB5 },
	{ 0xE6, 0xB7, 0x86 },
	{ 0xE6, 0x99, 0x93 },
	{ 0xE5, 0xB0, 0x8F },
	{ 0xE5, 0xAD, 0x9D },
	{ 0xE6, 0xA0, 0xA1 },
	{ 0xE8, 0x82, 0x96 },
	{ 0xE5, 0x95, 0xB8 },
	{ 0xE7, 0xAC, 0x91 },
	{ 0xE6, 0x95, 0x88 },
	{ 0xE6, 0xA5, 0x94 },
	{ 0xE4, 0xBA, 0x9B },
	{ 0xE6, 0xAD, 0x87 },
	{ 0xE8, 0x9D, 0x8E },
	{ 0xE9, 0x9E, 0x8B },
	{ 0xE5, 0x8D, 0x8F },
	{ 0xE6, 0x8C, 0x9F },
	{ 0xE6, 0x90, 0xBA },
	{ 0xE9, 0x82, 0xAA },
	{ 0xE6, 0x96, 0x9C },
	{ 0xE8, 0x83, 0x81 },
	{ 0xE8, 0xB0, 0x90 },
	{ 0xE5, 0x86, 0x99 },
	{ 0xE6, 0xA2, 0xB0 },
	{ 0xE5, 0x8D, 0xB8 },
	{ 0xE8, 0x9F, 0xB9 },
	{ 0xE6, 0x87, 0x88 },
	{ 0xE6, 0xB3, 0x84 },
	{ 0xE6, 0xB3, 0xBB },
	{ 0xE8, 0xB0, 0xA2 },
	{ 0xE5, 0xB1, 0x91 },
	{ 0xE8, 0x96, 0xAA },
	{ 0xE8, 0x8A, 0xAF },
	{ 0xE9, 0x94, 0x8C },
	{ 0xE6, 0xAC, 0xA3 },
	{ 0xE8, 0xBE, 0x9B },
	{ 0xE6, 0x96, 0xB0 },
	{ 0xE5, 0xBF, 0xBB },
	{ 0xE5, 0xBF, 0x83 },
	{ 0xE4, 0xBF, 0xA1 },
	{ 0xE8, 0xA1, 0x85 },
	{ 0xE6, 0x98, 0x9F },
	{ 0xE8, 0x85, 0xA5 },
	{ 0xE7, 0x8C, 0xA9 },
	{ 0xE6, 0x83, 0xBA },
	{ 0xE5, 0x85, 0xB4 },
	{ 0xE5, 0x88, 0x91 },
	{ 0xE5, 0x9E, 0x8B },
	{ 0xE5, 0xBD, 0xA2 },
	{ 0xE9, 0x82, 0xA2 },
	{ 0xE8, 0xA1, 0x8C },
	{ 0xE9, 0x86, 0x92 },
	{ 0xE5, 0xB9, 0xB8 },
	{ 0xE6, 0x9D, 0x8F },
	{ 0xE6, 0x80, 0xA7 },
	{ 0xE5, 0xA7, 0x93 },
	{ 0xE5, 0x85, 0x84 },
	{ 0xE5, 0x87, 0xB6 },
	{ 0xE8, 0x83, 0xB8 },
	{ 0xE5, 0x8C, 0x88 },
	{ 0xE6, 0xB1, 0xB9 },
	{ 0xE9, 0x9B, 0x84 },
	{ 0xE7, 0x86, 0x8A },
	{ 0xE4, 0xBC, 0x91 },
	{ 0xE4, 0xBF, 0xAE },
	{ 0xE7, 0xBE, 0x9E },
	{ 0xE6, 0x9C, 0xBD },
	{ 0xE5, 0x97, 0x85 },
	{ 0xE9, 0x94, 0x88 },
	{ 0xE7, 0xA7, 0x80 },
	{ 0xE8, 0xA2, 0x96 },
	{ 0xE7, 0xBB, 0xA3 },
	{ 0xE5, 0xA2, 0x9F },
	{ 0xE6, 0x88, 0x8C },
	{ 0xE9, 0x9C, 0x80 },
	{ 0xE8, 0x99, 0x9A },
	{ 0xE5, 0x98, 0x98 },
	{ 0xE9, 0xA1, 0xBB },
	{ 0xE5, 0xBE, 0x90 },
	{ 0xE8, 0xAE, 0xB8 },
	{ 0xE8, 0x93, 0x84 },
	{ 0xE9, 0x85, 0x97 },
	{ 0xE5, 0x8F, 0x99 },
	{ 0xE6, 0x97, 0xAD },
	{ 0xE5, 0xBA, 0x8F },
	{ 0xE7, 0x95, 0x9C },
	{ 0xE6, 0x81, 0xA4 },
	{ 0xE7, 0xB5, 0xAE },
	{ 0xE5, 0xA9, 0xBF },
	{ 0xE7, 0xBB, 0xAA },
	{ 0xE7, 0xBB, 0xAD },
	{ 0xE8, 0xBD, 0xA9 },
	{ 0xE5, 0x96, 0xA7 },
	{ 0xE5, 0xAE, 0xA3 },
	{ 0xE6, 0x82, 0xAC },
	{ 0xE6, 0x97, 0x8B },
	{ 0xE7, 0x8E, 0x84 },
	{ 0xE9, 0x80, 0x89 },
	{ 0xE7, 0x99, 0xA3 },
	{ 0xE7, 0x9C, 0xA9 },
	{ 0xE7, 0xBB, 0x9A },
	{ 0xE9, 0x9D, 0xB4 },
	{ 0xE8, 0x96, 0x9B },
	{ 0xE5, 0xAD, 0xA6 },
	{ 0xE7, 0xA9, 0xB4 },
	{ 0xE9, 0x9B, 0xAA },
	{ 0xE8, 0xA1, 0x80 },
	{ 0xE5, 0x8B, 0x8B },
	{ 0xE7, 0x86, 0x8F },
	{ 0xE5, 0xBE, 0xAA },
	{ 0xE6, 0x97, 0xAC },
	{ 0xE8, 0xAF, 0xA2 },
	{ 0xE5, 0xAF, 0xBB },
	{ 0xE9, 0xA9, 0xAF },
	{ 0xE5, 0xB7, 0xA1 },
	{ 0xE6, 0xAE, 0x89 },
	{ 0xE6, 0xB1, 0x9B },
	{ 0xE8, 0xAE, 0xAD },
	{ 0xE8, 0xAE, 0xAF },
	{ 0xE9, 0x80, 0x8A },
	{ 0xE8, 0xBF, 0x85 },
	{ 0xE5, 0x8E, 0x8B },
	{ 0xE6, 0x8A, 0xBC },
	{ 0xE9, 0xB8, 0xA6 },
	{ 0xE9, 0xB8, 0xAD },
	{ 0xE5, 0x91, 0x80 },
	{ 0xE4, 0xB8, 0xAB },
	{ 0xE8, 0x8A, 0xBD },
	{ 0xE7, 0x89, 0x99 },
	{ 0xE8, 0x9A, 0x9C },
	{ 0xE5, 0xB4, 0x96 },
	{ 0xE8, 0xA1, 0x99 },
	{ 0xE6, 0xB6, 0xAF },
	{ 0xE9, 0x9B, 0x85 },
	{ 0xE5, 0x93, 0x91 },
	{ 0xE4, 0xBA, 0x9A },
	{ 0xE8, 0xAE, 0xB6 },
	{ 0xE7, 0x84, 0x89 },
	{ 0xE5, 0x92, 0xBD },
	{ 0xE9, 0x98, 0x89 },
	{ 0xE7, 0x83, 0x9F },
	{ 0xE6, 0xB7, 0xB9 },
	{ 0xE7, 0x9B, 0x90 },
	{ 0xE4, 0xB8, 0xA5 },
	{ 0xE7, 0xA0, 0x94 },
	{ 0xE8, 0x9C, 0x92 },
	{ 0xE5, 0xB2, 0xA9 },
	{ 0xE5, 0xBB, 0xB6 },
	{ 0xE8, 0xA8, 0x80 },
	{ 0xE9, 0xA2, 0x9C },
	{ 0xE9, 0x98, 0x8E },
	{ 0xE7, 0x82, 0x8E },
	{ 0xE6, 0xB2, 0xBF },
	{ 0xE5, 0xA5, 0x84 },
	{ 0xE6, 0x8E, 0xA9 },
	{ 0xE7, 0x9C, 0xBC },
	{ 0xE8, 0xA1, 0x8D },
	{ 0xE6, 0xBC, 0x94 },
	{ 0xE8, 0x89, 0xB3 },
	{ 0xE5, 0xA0, 0xB0 },
	{ 0xE7, 0x87, 0x95 },
	{ 0xE5, 0x8E, 0x8C },
	{ 0xE7, 0xA0, 0x9A },
	{ 0xE9, 0x9B, 0x81 },
	{ 0xE5, 0x94, 0x81 },
	{ 0xE5, 0xBD, 0xA6 },
	{ 0xE7, 0x84, 0xB0 },
	{ 0xE5, 0xAE, 0xB4 },
	{ 0xE8, 0xB0, 0x9A },
	{ 0xE9, 0xAA, 0x8C },
	{ 0xE6, 0xAE, 0x83 },
	{ 0xE5, 0xA4, 0xAE },
	{ 0xE9, 0xB8, 0xAF },
	{ 0xE7, 0xA7, 0xA7 },
	{ 0xE6, 0x9D, 0xA8 },
	{ 0xE6, 0x89, 0xAC },
	{ 0xE4, 0xBD, 0xAF },
	{ 0xE7, 0x96, 0xA1 },
	{ 0xE7, 0xBE, 0x8A },
	{ 0xE6, 0xB4, 0x8B },
	{ 0xE9, 0x98, 0xB3 },
	{ 0xE6, 0xB0, 0xA7 },
	{ 0xE4, 0xBB, 0xB0 },
	{ 0xE7, 0x97, 0x92 },
	{ 0xE5, 0x85, 0xBB },
	{ 0xE6, 0xA0, 0xB7 },
	{ 0xE6, 0xBC, 0xBE },
	{ 0xE9, 0x82, 0x80 },
	{ 0xE8, 0x85, 0xB0 },
	{ 0xE5, 0xA6, 0x96 },
	{ 0xE7, 0x91, 0xB6 },
	{ 0xE6, 0x91, 0x87 },
	{ 0xE5, 0xB0, 0xA7 },
	{ 0xE9, 0x81, 0xA5 },
	{ 0xE7, 0xAA, 0x91 },
	{ 0xE8, 0xB0, 0xA3 },
	{ 0xE5, 0xA7, 0x9A },
	{ 0xE5, 0x92, 0xAC },
	{ 0xE8, 0x88, 0x80 },
	{ 0xE8, 0x8D, 0xAF },
	{ 0xE8, 0xA6, 0x81 },
	{ 0xE8, 0x80, 0x80 },
	{ 0xE6, 0xA4, 0xB0 },
	{ 0xE5, 0x99, 0x8E },
	{ 0xE8, 0x80, 0xB6 },
	{ 0xE7, 0x88, 0xB7 },
	{ 0xE9, 0x87, 0x8E },
	{ 0xE5, 0x86, 0xB6 },
	{ 0xE4, 0xB9, 0x9F },
	{ 0xE9, 0xA1, 0xB5 },
	{ 0xE6, 0x8E, 0x96 },
	{ 0xE4, 0xB8, 0x9A },
	{ 0xE5, 0x8F, 0xB6 },
	{ 0xE6, 0x9B, 0xB3 },
	{ 0xE8, 0x85, 0x8B },
	{ 0xE5, 0xA4, 0x9C },
	{ 0xE6, 0xB6, 0xB2 },
	{ 0xE4, 0xB8, 0x80 },
	{ 0xE5, 0xA3, 0xB9 },
	{ 0xE5, 0x8C, 0xBB },
	{ 0xE6, 0x8F, 0x96 },
	{ 0xE9, 0x93, 0xB1 },
	{ 0xE4, 0xBE, 0x9D },
	{ 0xE4, 0xBC, 0x8A },
	{ 0xE8, 0xA1, 0xA3 },
	{ 0xE9, 0xA2, 0x90 },
	{ 0xE5, 0xA4, 0xB7 },
	{ 0xE9, 0x81, 0x97 },
	{ 0xE7, 0xA7, 0xBB },
	{ 0xE4, 0xBB, 0xAA },
	{ 0xE8, 0x83, 0xB0 },
	{ 0xE7, 0x96, 0x91 },
	{ 0xE6, 0xB2, 0x82 },
	{ 0xE5, 0xAE, 0x9C },
	{ 0xE5, 0xA7, 0xA8 },
	{ 0xE5, 0xBD, 0x9D },
	{ 0xE6, 0xA4, 0x85 },
	{ 0xE8, 0x9A, 0x81 },
	{ 0xE5, 0x80, 0x9A },
	{ 0xE5, 0xB7, 0xB2 },
	{ 0xE4, 0xB9, 0x99 },
	{ 0xE7, 0x9F, 0xA3 },
	{ 0xE4, 0xBB, 0xA5 },
	{ 0xE8, 0x89, 0xBA },
	{ 0xE6, 0x8A, 0x91 },
	{ 0xE6, 0x98, 0x93 },
	{ 0xE9, 0x82, 0x91 },
	{ 0xE5, 0xB1, 0xB9 },
	{ 0xE4, 0xBA, 0xBF },
	{ 0xE5, 0xBD, 0xB9 },
	{ 0xE8, 0x87, 0x86 },
	{ 0xE9, 0x80, 0xB8 },
	{ 0xE8, 0x82, 0x84 },
	{ 0xE7, 0x96, 0xAB },
	{ 0xE4, 0xBA, 0xA6 },
	{ 0xE8, 0xA3, 0x94 },
	{ 0xE6, 0x84, 0x8F },
	{ 0xE6, 0xAF, 0x85 },
	{ 0xE5, 0xBF, 0x86 },
	{ 0xE4, 0xB9, 0x89 },
	{ 0xE7, 0x9B, 0x8A },
	{ 0xE6, 0xBA, 0xA2 },
	{ 0xE8, 0xAF, 0xA3 },
	{ 0xE8, 0xAE, 0xAE },
	{ 0xE8, 0xB0, 0x8A },
	{ 0xE8, 0xAF, 0x91 },
	{ 0xE5, 0xBC, 0x82 },
	{ 0xE7, 0xBF, 0xBC },
	{ 0xE7, 0xBF, 0x8C },
	{ 0xE7, 0xBB, 0x8E },
	{ 0xE8, 0x8C, 0xB5 },
	{ 0xE8, 0x8D, 0xAB },
	{ 0xE5, 0x9B, 0xA0 },
	{ 0xE6, 0xAE, 0xB7 },
	{ 0xE9, 0x9F, 0xB3 },
	{ 0xE9, 0x98, 0xB4 },
	{ 0xE5, 0xA7, 0xBB },
	{ 0xE5, 0x90, 0x9F },
	{ 0xE9, 0x93, 0xB6 },
	{ 0xE6, 0xB7, 0xAB },
	{ 0xE5, 0xAF, 0x85 },
	{ 0xE9, 0xA5, 0xAE },
	{ 0xE5, 0xB0, 0xB9 },
	{ 0xE5, 0xBC, 0x95 },
	{ 0xE9, 0x9A, 0x90 },
	{ 0xE5, 0x8D, 0xB0 },
	{ 0xE8, 0x8B, 0xB1 },
	{ 0xE6, 0xA8, 0xB1 },
	{ 0xE5, 0xA9, 0xB4 },
	{ 0xE9, 0xB9, 0xB0 },
	{ 0xE5, 0xBA, 0x94 },
	{ 0xE7, 0xBC, 0xA8 },
	{ 0xE8, 0x8E, 0xB9 },
	{ 0xE8, 0x90, 0xA4 },
	{ 0xE8, 0x90, 0xA5 },
	{ 0xE8, 0x8D, 0xA7 },
	{ 0xE8, 0x9D, 0x87 },
	{ 0xE8, 0xBF, 0x8E },
	{ 0xE8, 0xB5, 0xA2 },
	{ 0xE7, 0x9B, 0x88 },
	{ 0xE5, 0xBD, 0xB1 },
	{ 0xE9, 0xA2, 0x96 },
	{ 0xE7, 0xA1, 0xAC },
	{ 0xE6, 0x98, 0xA0 },
	{ 0xE5, 0x93, 0x9F },
	{ 0xE6, 0x8B, 0xA5 },
	{ 0xE4, 0xBD, 0xA3 },
	{ 0xE8, 0x87, 0x83 },
	{ 0xE7, 0x97, 0x88 },
	{ 0xE5, 0xBA, 0xB8 },
	{ 0xE9, 0x9B, 0x8D },
	{ 0xE8, 0xB8, 0x8A },
	{ 0xE8, 0x9B, 0xB9 },
	{ 0xE5, 0x92, 0x8F },
	{ 0xE6, 0xB3, 0xB3 },
	{ 0xE6, 0xB6, 0x8C },
	{ 0xE6, 0xB0, 0xB8 },
	{ 0xE6, 0x81, 0xBF },
	{ 0xE5, 0x8B, 0x87 },
	{ 0xE7, 0x94, 0xA8 },
	{ 0xE5, 0xB9, 0xBD },
	{ 0xE4, 0xBC, 0x98 },
	{ 0xE6, 0x82, 0xA0 },
	{ 0xE5, 0xBF, 0xA7 },
	{ 0xE5, 0xB0, 0xA4 },
	{ 0xE7, 0x94, 0xB1 },
	{ 0xE9, 0x82, 0xAE },
	{ 0xE9, 0x93, 0x80 },
	{ 0xE7, 0x8A, 0xB9 },
	{ 0xE6, 0xB2, 0xB9 },
	{ 0xE6, 0xB8, 0xB8 },
	{ 0xE9, 0x85, 0x89 },
	{ 0xE6, 0x9C, 0x89 },
	{ 0xE5, 0x8F, 0x8B },
	{ 0xE5, 0x8F, 0xB3 },
	{ 0xE4, 0xBD, 0x91 },
	{ 0xE9, 0x87, 0x89 },
	{ 0xE8, 0xAF, 0xB1 },
	{ 0xE5, 0x8F, 0x88 },
	{ 0xE5, 0xB9, 0xBC },
	{ 0xE8, 0xBF, 0x82 },
	{ 0xE6, 0xB7, 0xA4 },
	{ 0xE4, 0xBA, 0x8E },
	{ 0xE7, 0x9B, 0x82 },
	{ 0xE6, 0xA6, 0x86 },
	{ 0xE8, 0x99, 0x9E },
	{ 0xE6, 0x84, 0x9A },
	{ 0xE8, 0x88, 0x86 },
	{ 0xE4, 0xBD, 0x99 },
	{ 0xE4, 0xBF, 0x9E },
	{ 0xE9, 0x80, 0xBE },
	{ 0xE9, 0xB1, 0xBC },
	{ 0xE6, 0x84, 0x89 },
	{ 0xE6, 0xB8, 0x9D },
	{ 0xE6, 0xB8, 0x94 },
	{ 0xE9, 0x9A, 0x85 },
	{ 0xE4, 0xBA, 0x88 },
	{ 0xE5, 0xA8, 0xB1 },
	{ 0xE9, 0x9B, 0xA8 },
	{ 0xE4, 0xB8, 0x8E },
	{ 0xE5, 0xB1, 0xBF },
	{ 0xE7, 0xA6, 0xB9 },
	{ 0xE5, 0xAE, 0x87 },
	{ 0xE8, 0xAF, 0xAD },
	{ 0xE7, 0xBE, 0xBD },
	{ 0xE7, 0x8E, 0x89 },
	{ 0xE5, 0x9F, 0x9F },
	{ 0xE8, 0x8A, 0x8B },
	{ 0xE9, 0x83, 0x81 },
	{ 0xE5, 0x90, 0x81 },
	{ 0xE9, 0x81, 0x87 },
	{ 0xE5, 0x96, 0xBB },
	{ 0xE5, 0xB3, 0xAA },
	{ 0xE5, 0xBE, 0xA1 },
	{ 0xE6, 0x84, 0x88 },
	{ 0xE6, 0xAC, 0xB2 },
	{ 0xE7, 0x8B, 0xB1 },
	{ 0xE8, 0x82, 0xB2 },
	{ 0xE8, 0xAA, 0x89 },
	{ 0xE6, 0xB5, 0xB4 },
	{ 0xE5, 0xAF, 0x93 },
	{ 0xE8, 0xA3, 0x95 },
	{ 0xE9, 0xA2, 0x84 },
	{ 0xE8, 0xB1, 0xAB },
	{ 0xE9, 0xA9, 0xAD },
	{ 0xE9, 0xB8, 0xB3 },
	{ 0xE6, 0xB8, 0x8A },
	{ 0xE5, 0x86, 0xA4 },
	{ 0xE5, 0x85, 0x83 },
	{ 0xE5, 0x9E, 0xA3 },
	{ 0xE8, 0xA2, 0x81 },
	{ 0xE5, 0x8E, 0x9F },
	{ 0xE6, 0x8F, 0xB4 },
	{ 0xE8, 0xBE, 0x95 },
	{ 0xE5, 0x9B, 0xAD },
	{ 0xE5, 0x91, 0x98 },
	{ 0xE5, 0x9C, 0x86 },
	{ 0xE7, 0x8C, 0xBF },
	{ 0xE6, 0xBA, 0x90 },
	{ 0xE7, 0xBC, 0x98 },
	{ 0xE8, 0xBF, 0x9C },
	{ 0xE8, 0x8B, 0x91 },
	{ 0xE6, 0x84, 0xBF },
	{ 0xE6, 0x80, 0xA8 },
	{ 0xE9, 0x99, 0xA2 },
	{ 0xE6, 0x9B, 0xB0 },
	{ 0xE7, 0xBA, 0xA6 },
	{ 0xE8, 0xB6, 0x8A },
	{ 0xE8, 0xB7, 0x83 },
	{ 0xE9, 0x92, 0xA5 },
	{ 0xE5, 0xB2, 0xB3 },
	{ 0xE7, 0xB2, 0xA4 },
	{ 0xE6, 0x9C, 0x88 },
	{ 0xE6, 0x82, 0xA6 },
	{ 0xE9, 0x98, 0x85 },
	{ 0xE8, 0x80, 0x98 },
	{ 0xE4, 0xBA, 0x91 },
	{ 0xE9, 0x83, 0xA7 },
	{ 0xE5, 0x8C, 0x80 },
	{ 0xE9, 0x99, 0xA8 },
	{ 0xE5, 0x85, 0x81 },
	{ 0xE8, 0xBF, 0x90 },
	{ 0xE8, 0x95, 0xB4 },
	{ 0xE9, 0x85, 0x9D },
	{ 0xE6, 0x99, 0x95 },
	{ 0xE9, 0x9F, 0xB5 },
	{ 0xE5, 0xAD, 0x95 },
	{ 0xE5, 0x8C, 0x9D },
	{ 0xE7, 0xA0, 0xB8 },
	{ 0xE6, 0x9D, 0x82 },
	{ 0xE6, 0xA0, 0xBD },
	{ 0xE5, 0x93, 0x89 },
	{ 0xE7, 0x81, 0xBE },
	{ 0xE5, 0xAE, 0xB0 },
	{ 0xE8, 0xBD, 0xBD },
	{ 0xE5, 0x86, 0x8D },
	{ 0xE5, 0x9C, 0xA8 },
	{ 0xE5, 0x92, 0xB1 },
	{ 0xE6, 0x94, 0x92 },
	{ 0xE6, 0x9A, 0x82 },
	{ 0xE8, 0xB5, 0x9E },
	{ 0xE8, 0xB5, 0x83 },
	{ 0xE8, 0x84, 0x8F },
	{ 0xE8, 0x91, 0xAC },
	{ 0xE9, 0x81, 0xAD },
	{ 0xE7, 0xB3, 0x9F },
	{ 0xE5, 0x87, 0xBF },
	{ 0xE8, 0x97, 0xBB },
	{ 0xE6, 0x9E, 0xA3 },
	{ 0xE6, 0x97, 0xA9 },
	{ 0xE6, 0xBE, 0xA1 },
	{ 0xE8, 0x9A, 0xA4 },
	{ 0xE8, 0xBA, 0x81 },
	{ 0xE5, 0x99, 0xAA },
	{ 0xE9, 0x80, 0xA0 },
	{ 0xE7, 0x9A, 0x82 },
	{ 0xE7, 0x81, 0xB6 },
	{ 0xE7, 0x87, 0xA5 },
	{ 0xE8, 0xB4, 0xA3 },
	{ 0xE6, 0x8B, 0xA9 },
	{ 0xE5, 0x88, 0x99 },
	{ 0xE6, 0xB3, 0xBD },
	{ 0xE8, 0xB4, 0xBC },
	{ 0xE6, 0x80, 0x8E },
	{ 0xE5, 0xA2, 0x9E },
	{ 0xE6, 0x86, 0x8E },
	{ 0xE6, 0x9B, 0xBE },
	{ 0xE8, 0xB5, 0xA0 },
	{ 0xE6, 0x89, 0x8E },
	{ 0xE5, 0x96, 0xB3 },
	{ 0xE6, 0xB8, 0xA3 },
	{ 0xE6, 0x9C, 0xAD },
	{ 0xE8, 0xBD, 0xA7 },
	{ 0xE9, 0x93, 0xA1 },
	{ 0xE9, 0x97, 0xB8 },
	{ 0xE7, 0x9C, 0xA8 },
	{ 0xE6, 0xA0, 0x85 },
	{ 0xE6, 0xA6, 0xA8 },
	{ 0xE5, 0x92, 0x8B },
	{ 0xE4, 0xB9, 0x8D },
	{ 0xE7, 0x82, 0xB8 },
	{ 0xE8, 0xAF, 0x88 },
	{ 0xE6, 0x91, 0x98 },
	{ 0xE6, 0x96, 0x8B },
	{ 0xE5, 0xAE, 0x85 },
	{ 0xE7, 0xAA, 0x84 },
	{ 0xE5, 0x80, 0xBA },
	{ 0xE5, 0xAF, 0xA8 },
	{ 0xE7, 0x9E, 0xBB },
	{ 0xE6, 0xAF, 0xA1 },
	{ 0xE8, 0xA9, 0xB9 },
	{ 0xE7, 0xB2, 0x98 },
	{ 0xE6, 0xB2, 0xBE },
	{ 0xE7, 0x9B, 0x8F },
	{ 0xE6, 0x96, 0xA9 },
	{ 0xE8, 0xBE, 0x97 },
	{ 0xE5, 0xB4, 0xAD },
	{ 0xE5, 0xB1, 0x95 },
	{ 0xE8, 0x98, 0xB8 },
	{ 0xE6, 0xA0, 0x88 },
	{ 0xE5, 0x8D, 0xA0 },
	{ 0xE6, 0x88, 0x98 },
	{ 0xE7, 0xAB, 0x99 },
	{ 0xE6, 0xB9, 0x9B },
	{ 0xE7, 0xBB, 0xBD },
	{ 0xE6, 0xA8, 0x9F },
	{ 0xE7, 0xAB, 0xA0 },
	{ 0xE5, 0xBD, 0xB0 },
	{ 0xE6, 0xBC, 0xB3 },
	{ 0xE5, 0xBC, 0xA0 },
	{ 0xE6, 0x8E, 0x8C },
	{ 0xE6, 0xB6, 0xA8 },
	{ 0xE6, 0x9D, 0x96 },
	{ 0xE4, 0xB8, 0x88 },
	{ 0xE5, 0xB8, 0x90 },
	{ 0xE8, 0xB4, 0xA6 },
	{ 0xE4, 0xBB, 0x97 },
	{ 0xE8, 0x83, 0x80 },
	{ 0xE7, 0x98, 0xB4 },
	{ 0xE9, 0x9A, 0x9C },
	{ 0xE6, 0x8B, 0x9B },
	{ 0xE6, 0x98, 0xAD },
	{ 0xE6, 0x89, 0xBE },
	{ 0xE6, 0xB2, 0xBC },
	{ 0xE8, 0xB5, 0xB5 },
	{ 0xE7, 0x85, 0xA7 },
	{ 0xE7, 0xBD, 0xA9 },
	{ 0xE5, 0x85, 0x86 },
	{ 0xE8, 0x82, 0x87 },
	{ 0xE5, 0x8F, 0xAC },
	{ 0xE9, 0x81, 0xAE },
	{ 0xE6, 0x8A, 0x98 },
	{ 0xE5, 0x93, 0xB2 },
	{ 0xE8, 0x9B, 0xB0 },
	{ 0xE8, 0xBE, 0x99 },
	{ 0xE8, 0x80, 0x85 },
	{ 0xE9, 0x94, 0x97 },
	{ 0xE8, 0x94, 0x97 },
	{ 0xE8, 0xBF, 0x99 },
	{ 0xE6, 0xB5, 0x99 },
	{ 0xE7, 0x8F, 0x8D },
	{ 0xE6, 0x96, 0x9F },
	{ 0xE7, 0x9C, 0x9F },
	{ 0xE7, 0x94, 0x84 },
	{ 0xE7, 0xA0, 0xA7 },
	{ 0xE8, 0x87, 0xBB },
	{ 0xE8, 0xB4, 0x9E },
	{ 0xE9, 0x92, 0x88 },
	{ 0xE4, 0xBE, 0xA6 },
	{ 0xE6, 0x9E, 0x95 },
	{ 0xE7, 0x96, 0xB9 },
	{ 0xE8, 0xAF, 0x8A },
	{ 0xE9, 0x9C, 0x87 },
	{ 0xE6, 0x8C, 0xAF },
	{ 0xE9, 0x95, 0x87 },
	{ 0xE9, 0x98, 0xB5 },
	{ 0xE8, 0x92, 0xB8 },
	{ 0xE6, 0x8C, 0xA3 },
	{ 0xE7, 0x9D, 0x81 },
	{ 0xE5, 0xBE, 0x81 },
	{ 0xE7, 0x8B, 0xB0 },
	{ 0xE4, 0xBA, 0x89 },
	{ 0xE6, 0x80, 0x94 },
	{ 0xE6, 0x95, 0xB4 },
	{ 0xE6, 0x8B, 0xAF },
	{ 0xE6, 0xAD, 0xA3 },
	{ 0xE6, 0x94, 0xBF },
	{ 0xE5, 0xB8, 0xA7 },
	{ 0xE7, 0x97, 0x87 },
	{ 0xE9, 0x83, 0x91 },
	{ 0xE8, 0xAF, 0x81 },
	{ 0xE8, 0x8A, 0x9D },
	{ 0xE6, 0x9E, 0x9D },
	{ 0xE6, 0x94, 0xAF },
	{ 0xE5, 0x90, 0xB1 },
	{ 0xE8, 0x9C, 0x98 },
	{ 0xE7, 0x9F, 0xA5 },
	{ 0xE8, 0x82, 0xA2 },
	{ 0xE8, 0x84, 0x82 },
	{ 0xE6, 0xB1, 0x81 },
	{ 0xE4, 0xB9, 0x8B },
	{ 0xE7, 0xBB, 0x87 },
	{ 0xE8, 0x81, 0x8C },
	{ 0xE7, 0x9B, 0xB4 },
	{ 0xE6, 0xA4, 0x8D },
	{ 0xE6, 0xAE, 0x96 },
	{ 0xE6, 0x89, 0xA7 },
	{ 0xE5, 0x80, 0xBC },
	{ 0xE4, 0xBE, 0x84 },
	{ 0xE5, 0x9D, 0x80 },
	{ 0xE6, 0x8C, 0x87 },
	{ 0xE6, 0xAD, 0xA2 },
	{ 0xE8, 0xB6, 0xBE },
	{ 0xE5, 0x8F, 0xAA },
	{ 0xE6, 0x97, 0xA8 },
	{ 0xE7, 0xBA, 0xB8 },
	{ 0xE5, 0xBF, 0x97 },
	{ 0xE6, 0x8C, 0x9A },
	{ 0xE6, 0x8E, 0xB7 },
	{ 0xE8, 0x87, 0xB3 },
	{ 0xE8, 0x87, 0xB4 },
	{ 0xE7, 0xBD, 0xAE },
	{ 0xE5, 0xB8, 0x9C },
	{ 0xE5, 0xB3, 0x99 },
	{ 0xE5, 0x88, 0xB6 },
	{ 0xE6, 0x99, 0xBA },
	{ 0xE7, 0xA7, 0xA9 },
	{ 0xE7, 0xA8, 0x9A },
	{ 0xE8, 0xB4, 0xA8 },
	{ 0xE7, 0x82, 0x99 },
	{ 0xE7, 0x97, 0x94 },
	{ 0xE6, 0xBB, 0x9E },
	{ 0xE6, 0xB2, 0xBB },
	{ 0xE7, 0xAA, 0x92 },
	{ 0xE4, 0xB8, 0xAD },
	{ 0xE7, 0x9B, 0x85 },
	{ 0xE5, 0xBF, 0xA0 },
	{ 0xE9, 0x92, 0x9F },
	{ 0xE8, 0xA1, 0xB7 },
	{ 0xE7, 0xBB, 0x88 },
	{ 0xE7, 0xA7, 0x8D },
	{ 0xE8, 0x82, 0xBF },
	{ 0xE9, 0x87, 0x8D },
	{ 0xE4, 0xBB, 0xB2 },
	{ 0xE4, 0xBC, 0x97 },
	{ 0xE8, 0x88, 0x9F },
	{ 0xE5, 0x91, 0xA8 },
	{ 0xE5, 0xB7, 0x9E },
	{ 0xE6, 0xB4, 0xB2 },
	{ 0xE8, 0xAF, 0x8C },
	{ 0xE7, 0xB2, 0xA5 },
	{ 0xE8, 0xBD, 0xB4 },
	{ 0xE8, 0x82, 0x98 },
	{ 0xE5, 0xB8, 0x9A },
	{ 0xE5, 0x92, 0x92 },
	{ 0xE7, 0x9A, 0xB1 },
	{ 0xE5, 0xAE, 0x99 },
	{ 0xE6, 0x98, 0xBC },
	{ 0xE9, 0xAA, 0xA4 },
	{ 0xE7, 0x8F, 0xA0 },
	{ 0xE6, 0xA0, 0xAA },
	{ 0xE8, 0x9B, 0x9B },
	{ 0xE6, 0x9C, 0xB1 },
	{ 0xE7, 0x8C, 0xAA },
	{ 0xE8, 0xAF, 0xB8 },
	{ 0xE8, 0xAF, 0x9B },
	{ 0xE9, 0x80, 0x90 },
	{ 0xE7, 0xAB, 0xB9 },
	{ 0xE7, 0x83, 0x9B },
	{ 0xE7, 0x85, 0xAE },
	{ 0xE6, 0x8B, 0x84 },
	{ 0xE7, 0x9E, 0xA9 },
	{ 0xE5, 0x98, 0xB1 },
	{ 0xE4, 0xB8, 0xBB },
	{ 0xE8, 0x91, 0x97 },
	{ 0xE6, 0x9F, 0xB1 },
	{ 0xE5, 0x8A, 0xA9 },
	{ 0xE8, 0x9B, 0x80 },
	{ 0xE8, 0xB4, 0xAE },
	{ 0xE9, 0x93, 0xB8 },
	{ 0xE7, 0xAD, 0x91 },
	{ 0xE4, 0xBD, 0x8F },
	{ 0xE6, 0xB3, 0xA8 },
	{ 0xE7, 0xA5, 0x9D },
	{ 0xE9, 0xA9, 0xBB },
	{ 0xE6, 0x8A, 0x93 },
	{ 0xE7, 0x88, 0xAA },
	{ 0xE6, 0x8B, 0xBD },
	{ 0xE4, 0xB8, 0x93 },
	{ 0xE7, 0xA0, 0x96 },
	{ 0xE8, 0xBD, 0xAC },
	{ 0xE6, 0x92, 0xB0 },
	{ 0xE8, 0xB5, 0x9A },
	{ 0xE7, 0xAF, 0x86 },
	{ 0xE6, 0xA1, 0xA9 },
	{ 0xE5, 0xBA, 0x84 },
	{ 0xE8, 0xA3, 0x85 },
	{ 0xE5, 0xA6, 0x86 },
	{ 0xE6, 0x92, 0x9E },
	{ 0xE5, 0xA3, 0xAE },
	{ 0xE7, 0x8A, 0xB6 },
	{ 0xE6, 0xA4, 0x8E },
	{ 0xE9, 0x94, 0xA5 },
	{ 0xE8, 0xBF, 0xBD },
	{ 0xE8, 0xB5, 0x98 },
	{ 0xE5, 0x9D, 0xA0 },
	{ 0xE7, 0xBC, 0x80 },
	{ 0xE8, 0xB0, 0x86 },
	{ 0xE5, 0x87, 0x86 },
	{ 0xE6, 0x8D, 0x89 },
	{ 0xE6, 0x8B, 0x99 },
	{ 0xE5, 0x8D, 0x93 },
	{ 0xE6, 0xA1, 0x8C },
	{ 0xE7, 0x90, 0xA2 },
	{ 0xE8, 0x8C, 0x81 },
	{ 0xE9, 0x85, 0x8C },
	{ 0xE5, 0x95, 0x84 },
	{ 0xE7, 0x9D, 0x80 },
	{ 0xE7, 0x81, 0xBC },
	{ 0xE6, 0xB5, 0x8A },
	{ 0xE5, 0x85, 0xB9 },
	{ 0xE5, 0x92, 0xA8 },
	{ 0xE8, 0xB5, 0x84 },
	{ 0xE5, 0xA7, 0xBF },
	{ 0xE6, 0xBB, 0x8B },
	{ 0xE6, 0xB7, 0x84 },
	{ 0xE5, 0xAD, 0x9C },
	{ 0xE7, 0xB4, 0xAB },
	{ 0xE4, 0xBB, 0x94 },
	{ 0xE7, 0xB1, 0xBD },
	{ 0xE6, 0xBB, 0x93 },
	{ 0xE5, 0xAD, 0x90 },
	{ 0xE8, 0x87, 0xAA },
	{ 0xE6, 0xB8, 0x8D },
	{ 0xE5, 0xAD, 0x97 },
	{ 0xE9, 0xAC, 0x83 },
	{ 0xE6, 0xA3, 0x95 },
	{ 0xE8, 0xB8, 0xAA },
	{ 0xE5, 0xAE, 0x97 },
	{ 0xE7, 0xBB, 0xBC },
	{ 0xE6, 0x80, 0xBB },
	{ 0xE7, 0xBA, 0xB5 },
	{ 0xE9, 0x82, 0xB9 },
	{ 0xE8, 0xB5, 0xB0 },
	{ 0xE5, 0xA5, 0x8F },
	{ 0xE6, 0x8F, 0x8D },
	{ 0xE7, 0xA7, 0x9F },
	{ 0xE8, 0xB6, 0xB3 },
	{ 0xE5, 0x8D, 0x92 },
	{ 0xE6, 0x97, 0x8F },
	{ 0xE7, 0xA5, 0x96 },
	{ 0xE8, 0xAF, 0x85 },
	{ 0xE9, 0x98, 0xBB },
	{ 0xE7, 0xBB, 0x84 },
	{ 0xE9, 0x92, 0xBB },
	{ 0xE7, 0xBA, 0x82 },
	{ 0xE5, 0x98, 0xB4 },
	{ 0xE9, 0x86, 0x89 },
	{ 0xE6, 0x9C, 0x80 },
	{ 0xE7, 0xBD, 0xAA },
	{ 0xE5, 0xB0, 0x8A },
	{ 0xE9, 0x81, 0xB5 },
	{ 0xE6, 0x98, 0xA8 },
	{ 0xE5, 0xB7, 0xA6 },
	{ 0xE4, 0xBD, 0x90 },
	{ 0xE6, 0x9F, 0x9E },
	{ 0xE5, 0x81, 0x9A },
	{ 0xE4, 0xBD, 0x9C },
	{ 0xE5, 0x9D, 0x90 },
	{ 0xE5, 0xBA, 0xA7 },
	{ 0xEE, 0xA0, 0x90 },
	{ 0xEE, 0xA0, 0x91 },
	{ 0xEE, 0xA0, 0x92 },
	{ 0xEE, 0xA0, 0x93 },
	{ 0xEE, 0xA0, 0x94 },
	{ 0xE4, 0xBA, 0x8D },
	{ 0xE4, 0xB8, 0x8C },
	{ 0xE5, 0x85, 0x80 },
	{ 0xE4, 0xB8, 0x90 },
	{ 0xE5, 0xBB, 0xBF },
	{ 0xE5, 0x8D, 0x85 },
	{ 0xE4, 0xB8, 0x95 },
	{ 0xE4, 0xBA, 0x98 },
	{ 0xE4, 0xB8, 0x9E },
	{ 0xE9, 0xAC, 0xB2 },
	{ 0xE5, 0xAD, 0xAC },
	{ 0xE5, 0x99, 0xA9 },
	{ 0xE4, 0xB8, 0xA8 },
	{ 0xE7, 0xA6, 0xBA },
	{ 0xE4, 0xB8, 0xBF },
	{ 0xE5, 0x8C, 0x95 },
	{ 0xE4, 0xB9, 0x87 },
	{ 0xE5, 0xA4, 0xAD },
	{ 0xE7, 0x88, 0xBB },
	{ 0xE5, 0x8D, 0xAE },
	{ 0xE6, 0xB0, 0x90 },
	{ 0xE5, 0x9B, 0x9F },
	{ 0xE8, 0x83, 0xA4 },
	{ 0xE9, 0xA6, 0x97 },
	{ 0xE6, 0xAF, 0x93 },
	{ 0xE7, 0x9D, 0xBE },
	{ 0xE9, 0xBC, 0x97 },
	{ 0xE4, 0xB8, 0xB6 },
	{ 0xE4, 0xBA, 0x9F },
	{ 0xE9, 0xBC, 0x90 },
	{ 0xE4, 0xB9, 0x9C },
	{ 0xE4, 0xB9, 0xA9 },
	{ 0xE4, 0xBA, 0x93 },
	{ 0xE8, 0x8A, 0x88 },
	{ 0xE5, 0xAD, 0x9B },
	{ 0xE5, 0x95, 0xAC },
	{ 0xE5, 0x98, 0x8F },
	{ 0xE4, 0xBB, 0x84 },
	{ 0xE5, 0x8E, 0x8D },
	{ 0xE5, 0x8E, 0x9D },
	{ 0xE5, 0x8E, 0xA3 },
	{ 0xE5, 0x8E, 0xA5 },
	{ 0xE5, 0x8E, 0xAE },
	{ 0xE9, 0x9D, 0xA5 },
	{ 0xE8, 0xB5, 0x9D },
	{ 0xE5, 0x8C, 0x9A },
	{ 0xE5, 0x8F, 0xB5 },
	{ 0xE5, 0x8C, 0xA6 },
	{ 0xE5, 0x8C, 0xAE },
	{ 0xE5, 0x8C, 0xBE },
	{ 0xE8, 0xB5, 0x9C },
	{ 0xE5, 0x8D, 0xA6 },
	{ 0xE5, 0x8D, 0xA3 },
	{ 0xE5, 0x88, 0x82 },
	{ 0xE5, 0x88, 0x88 },
	{ 0xE5, 0x88, 0x8E },
	{ 0xE5, 0x88, 0xAD },
	{ 0xE5, 0x88, 0xB3 },
	{ 0xE5, 0x88, 0xBF },
	{ 0xE5, 0x89, 0x80 },
	{ 0xE5, 0x89, 0x8C },
	{ 0xE5, 0x89, 0x9E },
	{ 0xE5, 0x89, 0xA1 },
	{ 0xE5, 0x89, 0x9C },
	{ 0xE8, 0x92, 0xAF },
	{ 0xE5, 0x89, 0xBD },
	{ 0xE5, 0x8A, 0x82 },
	{ 0xE5, 0x8A, 0x81 },
	{ 0xE5, 0x8A, 0x90 },
	{ 0xE5, 0x8A, 0x93 },
	{ 0xE5, 0x86, 0x82 },
	{ 0xE7, 0xBD, 0x94 },
	{ 0xE4, 0xBA, 0xBB },
	{ 0xE4, 0xBB, 0x83 },
	{ 0xE4, 0xBB, 0x89 },
	{ 0xE4, 0xBB, 0x82 },
	{ 0xE4, 0xBB, 0xA8 },
	{ 0xE4, 0xBB, 0xA1 },
	{ 0xE4, 0xBB, 0xAB },
	{ 0xE4, 0xBB, 0x9E },
	{ 0xE4, 0xBC, 0x9B },
	{ 0xE4, 0xBB, 0xB3 },
	{ 0xE4, 0xBC, 0xA2 },
	{ 0xE4, 0xBD, 0xA4 },
	{ 0xE4, 0xBB, 0xB5 },
	{ 0xE4, 0xBC, 0xA5 },
	{ 0xE4, 0xBC, 0xA7 },
	{ 0xE4, 0xBC, 0x89 },
	{ 0xE4, 0xBC, 0xAB },
	{ 0xE4, 0xBD, 0x9E },
	{ 0xE4, 0xBD, 0xA7 },
	{ 0xE6, 0x94, 0xB8 },
	{ 0xE4, 0xBD, 0x9A },
	{ 0xE4, 0xBD, 0x9D },
	{ 0xE4, 0xBD, 0x9F },
	{ 0xE4, 0xBD, 0x97 },
	{ 0xE4, 0xBC, 0xB2 },
	{ 0xE4, 0xBC, 0xBD },
	{ 0xE4, 0xBD, 0xB6 },
	{ 0xE4, 0xBD, 0xB4 },
	{ 0xE4, 0xBE, 0x91 },
	{ 0xE4, 0xBE, 0x89 },
	{ 0xE4, 0xBE, 0x83 },
	{ 0xE4, 0xBE, 0x8F },
	{ 0xE4, 0xBD, 0xBE },
	{ 0xE4, 0xBD, 0xBB },
	{ 0xE4, 0xBE, 0xAA },
	{ 0xE4, 0xBD, 0xBC },
	{ 0xE4, 0xBE, 0xAC },
	{ 0xE4, 0xBE, 0x94 },
	{ 0xE4, 0xBF, 0xA6 },
	{ 0xE4, 0xBF, 0xA8 },
	{ 0xE4, 0xBF, 0xAA },
	{ 0xE4, 0xBF, 0x85 },
	{ 0xE4, 0xBF, 0x9A },
	{ 0xE4, 0xBF, 0xA3 },
	{ 0xE4, 0xBF, 0x9C },
	{ 0xE4, 0xBF, 0x91 },
	{ 0xE4, 0xBF, 0x9F },
	{ 0xE4, 0xBF, 0xB8 },
	{ 0xE5, 0x80, 0xA9 },
	{ 0xE5, 0x81, 0x8C },
	{ 0xE4, 0xBF, 0xB3 },
	{ 0xE5, 0x80, 0xAC },
	{ 0xE5, 0x80, 0x8F },
	{ 0xE5, 0x80, 0xAE },
	{ 0xE5, 0x80, 0xAD },
	{ 0xE4, 0xBF, 0xBE },
	{ 0xE5, 0x80, 0x9C },
	{ 0xE5, 0x80, 0x8C },
	{ 0xE5, 0x80, 0xA5 },
	{ 0xE5, 0x80, 0xA8 },
	{ 0xE5, 0x81, 0xBE },
	{ 0xE5, 0x81, 0x83 },
	{ 0xE5, 0x81, 0x95 },
	{ 0xE5, 0x81, 0x88 },
	{ 0xE5, 0x81, 0x8E },
	{ 0xE5, 0x81, 0xAC },
	{ 0xE5, 0x81, 0xBB },
	{ 0xE5, 0x82, 0xA5 },
	{ 0xE5, 0x82, 0xA7 },
	{ 0xE5, 0x82, 0xA9 },
	{ 0xE5, 0x82, 0xBA },
	{ 0xE5, 0x83, 0x96 },
	{ 0xE5, 0x84, 0x86 },
	{ 0xE5, 0x83, 0xAD },
	{ 0xE5, 0x83, 0xAC },
	{ 0xE5, 0x83, 0xA6 },
	{ 0xE5, 0x83, 0xAE },
	{ 0xE5, 0x84, 0x87 },
	{ 0xE5, 0x84, 0x8B },
	{ 0xE4, 0xBB, 0x9D },
	{ 0xE6, 0xB0, 0xBD },
	{ 0xE4, 0xBD, 0x98 },
	{ 0xE4, 0xBD, 0xA5 },
	{ 0xE4, 0xBF, 0x8E },
	{ 0xE9, 0xBE, 0xA0 },
	{ 0xE6, 0xB1, 0x86 },
	{ 0xE7, 0xB1, 0xB4 },
	{ 0xE5, 0x85, 0xAE },
	{ 0xE5, 0xB7, 0xBD },
	{ 0xE9, 0xBB, 0x89 },
	{ 0xE9, 0xA6, 0x98 },
	{ 0xE5, 0x86, 0x81 },
	{ 0xE5, 0xA4, 0x94 },
	{ 0xE5, 0x8B, 0xB9 },
	{ 0xE5, 0x8C, 0x8D },
	{ 0xE8, 0xA8, 0x87 },
	{ 0xE5, 0x8C, 0x90 },
	{ 0xE5, 0x87, 0xAB },
	{ 0xE5, 0xA4, 0x99 },
	{ 0xE5, 0x85, 0x95 },
	{ 0xE4, 0xBA, 0xA0 },
	{ 0xE5, 0x85, 0x96 },
	{ 0xE4, 0xBA, 0xB3 },
	{ 0xE8, 0xA1, 0xAE },
	{ 0xE8, 0xA2, 0xA4 },
	{ 0xE4, 0xBA, 0xB5 },
	{ 0xE8, 0x84, 0x94 },
	{ 0xE8, 0xA3, 0x92 },
	{ 0xE7, 0xA6, 0x80 },
	{ 0xE5, 0xAC, 0xB4 },
	{ 0xE8, 0xA0, 0x83 },
	{ 0xE7, 0xBE, 0xB8 },
	{ 0xE5, 0x86, 0xAB },
	{ 0xE5, 0x86, 0xB1 },
	{ 0xE5, 0x86, 0xBD },
	{ 0xE5, 0x86, 0xBC },
	{ 0xE5, 0x87, 0x87 },
	{ 0xE5, 0x86, 0x96 },
	{ 0xE5, 0x86, 0xA2 },
	{ 0xE5, 0x86, 0xA5 },
	{ 0xE8, 0xAE, 0xA0 },
	{ 0xE8, 0xAE, 0xA6 },
	{ 0xE8, 0xAE, 0xA7 },
	{ 0xE8, 0xAE, 0xAA },
	{ 0xE8, 0xAE, 0xB4 },
	{ 0xE8, 0xAE, 0xB5 },
	{ 0xE8, 0xAE, 0xB7 },
	{ 0xE8, 0xAF, 0x82 },
	{ 0xE8, 0xAF, 0x83 },
	{ 0xE8, 0xAF, 0x8B },
	{ 0xE8, 0xAF, 0x8F },
	{ 0xE8, 0xAF, 0x8E },
	{ 0xE8, 0xAF, 0x92 },
	{ 0xE8, 0xAF, 0x93 },
	{ 0xE8, 0xAF, 0x94 },
	{ 0xE8, 0xAF, 0x96 },
	{ 0xE8, 0xAF, 0x98 },
	{ 0xE8, 0xAF, 0x99 },
	{ 0xE8, 0xAF, 0x9C },
	{ 0xE8, 0xAF, 0x9F },
	{ 0xE8, 0xAF, 0xA0 },
	{ 0xE8, 0xAF, 0xA4 },
	{ 0xE8, 0xAF, 0xA8 },
	{ 0xE8, 0xAF, 0xA9 },
	{ 0xE8, 0xAF, 0xAE },
	{ 0xE8, 0xAF, 0xB0 },
	{ 0xE8, 0xAF, 0xB3 },
	{ 0xE8, 0xAF, 0xB6 },
	{ 0xE8, 0xAF, 0xB9 },
	{ 0xE8, 0xAF, 0xBC },
	{ 0xE8, 0xAF, 0xBF },
	{ 0xE8, 0xB0, 0x80 },
	{ 0xE8, 0xB0, 0x82 },
	{ 0xE8, 0xB0, 0x84 },
	{ 0xE8, 0xB0, 0x87 },
	{ 0xE8, 0xB0, 0x8C },
	{ 0xE8, 0xB0, 0x8F },
	{ 0xE8, 0xB0, 0x91 },
	{ 0xE8, 0xB0, 0x92 },
	{ 0xE8, 0xB0, 0x94 },
	{ 0xE8, 0xB0, 0x95 },
	{ 0xE8, 0xB0, 0x96 },
	{ 0xE8, 0xB0, 0x99 },
	{ 0xE8, 0xB0, 0x9B },
	{ 0xE8, 0xB0, 0x98 },
	{ 0xE8, 0xB0, 0x9D },
	{ 0xE8, 0xB0, 0x9F },
	{ 0xE8, 0xB0, 0xA0 },
	{ 0xE8, 0xB0, 0xA1 },
	{ 0xE8, 0xB0, 0xA5 },
	{ 0xE8, 0xB0, 0xA7 },
	{ 0xE8, 0xB0, 0xAA },
	{ 0xE8, 0xB0, 0xAB },
	{ 0xE8, 0xB0, 0xAE },
	{ 0xE8, 0xB0, 0xAF },
	{ 0xE8, 0xB0, 0xB2 },
	{ 0xE8, 0xB0, 0xB3 },
	{ 0xE8, 0xB0, 0xB5 },
	{ 0xE8, 0xB0, 0xB6 },
	{ 0xE5, 0x8D, 0xA9 },
	{ 0xE5, 0x8D, 0xBA },
	{ 0xE9, 0x98, 0x9D },
	{ 0xE9, 0x98, 0xA2 },
	{ 0xE9, 0x98, 0xA1 },
	{ 0xE9, 0x98, 0xB1 },
	{ 0xE9, 0x98, 0xAA },
	{ 0xE9, 0x98, 0xBD },
	{ 0xE9, 0x98, 0xBC },
	{ 0xE9, 0x99, 0x82 },
	{ 0xE9, 0x99, 0x89 },
	{ 0xE9, 0x99, 0x94 },
	{ 0xE9, 0x99, 0x9F },
	{ 0xE9, 0x99, 0xA7 },
	{ 0xE9, 0x99, 0xAC },
	{ 0xE9, 0x99, 0xB2 },
	{ 0xE9, 0x99, 0xB4 },
	{ 0xE9, 0x9A, 0x88 },
	{ 0xE9, 0x9A, 0x8D },
	{ 0xE9, 0x9A, 0x97 },
	{ 0xE9, 0x9A, 0xB0 },
	{ 0xE9, 0x82, 0x97 },
	{ 0xE9, 0x82, 0x9B },
	{ 0xE9, 0x82, 0x9D },
	{ 0xE9, 0x82, 0x99 },
	{ 0xE9, 0x82, 0xAC },
	{ 0xE9, 0x82, 0xA1 },
	{ 0xE9, 0x82, 0xB4 },
	{ 0xE9, 0x82, 0xB3 },
	{ 0xE9, 0x82, 0xB6 },
	{ 0xE9, 0x82, 0xBA },
	{ 0xE9, 0x82, 0xB8 },
	{ 0xE9, 0x82, 0xB0 },
	{ 0xE9, 0x83, 0x8F },
	{ 0xE9, 0x83, 0x85 },
	{ 0xE9, 0x82, 0xBE },
	{ 0xE9, 0x83, 0x90 },
	{ 0xE9, 0x83, 0x84 },
	{ 0xE9, 0x83, 0x87 },
	{ 0xE9, 0x83, 0x93 },
	{ 0xE9, 0x83, 0xA6 },
	{ 0xE9, 0x83, 0xA2 },
	{ 0xE9, 0x83, 0x9C },
	{ 0xE9, 0x83, 0x97 },
	{ 0xE9, 0x83, 0x9B },
	{ 0xE9, 0x83, 0xAB },
	{ 0xE9, 0x83, 0xAF },
	{ 0xE9, 0x83, 0xBE },
	{ 0xE9, 0x84, 0x84 },
	{ 0xE9, 0x84, 0xA2 },
	{ 0xE9, 0x84, 0x9E },
	{ 0xE9, 0x84, 0xA3 },
	{ 0xE9, 0x84, 0xB1 },
	{ 0xE9, 0x84, 0xAF },
	{ 0xE9, 0x84, 0xB9 },
	{ 0xE9, 0x85, 0x83 },
	{ 0xE9, 0x85, 0x86 },
	{ 0xE5, 0x88, 0x8D },
	{ 0xE5, 0xA5, 0x82 },
	{ 0xE5, 0x8A, 0xA2 },
	{ 0xE5, 0x8A, 0xAC },
	{ 0xE5, 0x8A, 0xAD },
	{ 0xE5, 0x8A, 0xBE },
	{ 0xE5, 0x93, 0xBF },
	{ 0xE5, 0x8B, 0x90 },
	{ 0xE5, 0x8B, 0x96 },
	{ 0xE5, 0x8B, 0xB0 },
	{ 0xE5, 0x8F, 0x9F },
	{ 0xE7, 0x87, 0xAE },
	{ 0xE7, 0x9F, 0x8D },
	{ 0xE5, 0xBB, 0xB4 },
	{ 0xE5, 0x87, 0xB5 },
	{ 0xE5, 0x87, 0xBC },
	{ 0xE9, 0xAC, 0xAF },
	{ 0xE5, 0x8E, 0xB6 },
	{ 0xE5, 0xBC, 0x81 },
	{ 0xE7, 0x95, 0x9A },
	{ 0xE5, 0xB7, 0xAF },
	{ 0xE5, 0x9D, 0x8C },
	{ 0xE5, 0x9E, 0xA9 },
	{ 0xE5, 0x9E, 0xA1 },
	{ 0xE5, 0xA1, 0xBE },
	{ 0xE5, 0xA2, 0xBC },
	{ 0xE5, 0xA3, 0x85 },
	{ 0xE5, 0xA3, 0x91 },
	{ 0xE5, 0x9C, 0xA9 },
	{ 0xE5, 0x9C, 0xAC },
	{ 0xE5, 0x9C, 0xAA },
	{ 0xE5, 0x9C, 0xB3 },
	{ 0xE5, 0x9C, 0xB9 },
	{ 0xE5, 0x9C, 0xAE },
	{ 0xE5, 0x9C, 0xAF },
	{ 0xE5, 0x9D, 0x9C },
	{ 0xE5, 0x9C, 0xBB },
	{ 0xE5, 0x9D, 0x82 },
	{ 0xE5, 0x9D, 0xA9 },
	{ 0xE5, 0x9E, 0x85 },
	{ 0xE5, 0x9D, 0xAB },
	{ 0xE5, 0x9E, 0x86 },
	{ 0xE5, 0x9D, 0xBC },
	{ 0xE5, 0x9D, 0xBB },
	{ 0xE5, 0x9D, 0xA8 },
	{ 0xE5, 0x9D, 0xAD },
	{ 0xE5, 0x9D, 0xB6 },
	{ 0xE5, 0x9D, 0xB3 },
	{ 0xE5, 0x9E, 0xAD },
	{ 0xE5, 0x9E, 0xA4 },
	{ 0xE5, 0x9E, 0x8C },
	{ 0xE5, 0x9E, 0xB2 },
	{ 0xE5, 0x9F, 0x8F },
	{ 0xE5, 0x9E, 0xA7 },
	{ 0xE5, 0x9E, 0xB4 },
	{ 0xE5, 0x9E, 0x93 },
	{ 0xE5, 0x9E, 0xA0 },
	{ 0xE5, 0x9F, 0x95 },
	{ 0xE5, 0x9F, 0x98 },
	{ 0xE5, 0x9F, 0x9A },
	{ 0xE5, 0x9F, 0x99 },
	{ 0xE5, 0x9F, 0x92 },
	{ 0xE5, 0x9E, 0xB8 },
	{ 0xE5, 0x9F, 0xB4 },
	{ 0xE5, 0x9F, 0xAF },
	{ 0xE5, 0x9F, 0xB8 },
	{ 0xE5, 0x9F, 0xA4 },
	{ 0xE5, 0x9F, 0x9D },
	{ 0xE5, 0xA0, 0x8B },
	{ 0xE5, 0xA0, 0x8D },
	{ 0xE5, 0x9F, 0xBD },
	{ 0xE5, 0x9F, 0xAD },
	{ 0xE5, 0xA0, 0x80 },
	{ 0xE5, 0xA0, 0x9E },
	{ 0xE5, 0xA0, 0x99 },
	{ 0xE5, 0xA1, 0x84 },
	{ 0xE5, 0xA0, 0xA0 },
	{ 0xE5, 0xA1, 0xA5 },
	{ 0xE5, 0xA1, 0xAC },
	{ 0xE5, 0xA2, 0x81 },
	{ 0xE5, 0xA2, 0x89 },
	{ 0xE5, 0xA2, 0x9A },
	{ 0xE5, 0xA2, 0x80 },
	{ 0xE9, 0xA6, 0xA8 },
	{ 0xE9, 0xBC, 0x99 },
	{ 0xE6, 0x87, 0xBF },
	{ 0xE8, 0x89, 0xB9 },
	{ 0xE8, 0x89, 0xBD },
	{ 0xE8, 0x89, 0xBF },
	{ 0xE8, 0x8A, 0x8F },
	{ 0xE8, 0x8A, 0x8A },
	{ 0xE8, 0x8A, 0xA8 },
	{ 0xE8, 0x8A, 0x84 },
	{ 0xE8, 0x8A, 0x8E },
	{ 0xE8, 0x8A, 0x91 },
	{ 0xE8, 0x8A, 0x97 },
	{ 0xE8, 0x8A, 0x99 },
	{ 0xE8, 0x8A, 0xAB },
	{ 0xE8, 0x8A, 0xB8 },
	{ 0xE8, 0x8A, 0xBE },
	{ 0xE8, 0x8A, 0xB0 },
	{ 0xE8, 0x8B, 0x88 },
	{ 0xE8, 0x8B, 0x8A },
	{ 0xE8, 0x8B, 0xA3 },
	{ 0xE8, 0x8A, 0x98 },
	{ 0xE8, 0x8A, 0xB7 },
	{ 0xE8, 0x8A, 0xAE },
	{ 0xE8, 0x8B, 0x8B },
	{ 0xE8, 0x8B, 0x8C },
	{ 0xE8, 0x8B, 0x81 },
	{ 0xE8, 0x8A, 0xA9 },
	{ 0xE8, 0x8A, 0xB4 },
	{ 0xE8, 0x8A, 0xA1 },
	{ 0xE8, 0x8A, 0xAA },
	{ 0xE8, 0x8A, 0x9F },
	{ 0xE8, 0x8B, 0x84 },
	{ 0xE8, 0x8B, 0x8E },
	{ 0xE8, 0x8A, 0xA4 },
	{ 0xE8, 0x8B, 0xA1 },
	{ 0xE8, 0x8C, 0x89 },
	{ 0xE8, 0x8B, 0xB7 },
	{ 0xE8, 0x8B, 0xA4 },
	{ 0xE8, 0x8C, 0x8F },
	{ 0xE8, 0x8C, 0x87 },
	{ 0xE8, 0x8B, 0x9C },
	{ 0xE8, 0x8B, 0xB4 },
	{ 0xE8, 0x8B, 0x92 },
	{ 0xE8, 0x8B, 0x98 },
	{ 0xE8, 0x8C, 0x8C },
	{ 0xE8, 0x8B, 0xBB },
	{ 0xE8, 0x8B, 0x93 },
	{ 0xE8, 0x8C, 0x91 },
	{ 0xE8, 0x8C, 0x9A },
	{ 0xE8, 0x8C, 0x86 },
	{ 0xE8, 0x8C, 0x94 },
	{ 0xE8, 0x8C, 0x95 },
	{ 0xE8, 0x8B, 0xA0 },
	{ 0xE8, 0x8B, 0x95 },
	{ 0xE8, 0x8C, 0x9C },
	{ 0xE8, 0x8D, 0x91 },
	{ 0xE8, 0x8D, 0x9B },
	{ 0xE8, 0x8D, 0x9C },
	{ 0xE8, 0x8C, 0x88 },
	{ 0xE8, 0x8E, 0x92 },
	{ 0xE8, 0x8C, 0xBC },
	{ 0xE8, 0x8C, 0xB4 },
	{ 0xE8, 0x8C, 0xB1 },
	{ 0xE8, 0x8E, 0x9B },
	{ 0xE8, 0x8D, 0x9E },
	{ 0xE8, 0x8C, 0xAF },
	{ 0xE8, 0x8D, 0x8F },
	{ 0xE8, 0x8D, 0x87 },
	{ 0xE8, 0x8D, 0x83 },
	{ 0xE8, 0x8D, 0x9F },
	{ 0xE8, 0x8D, 0x80 },
	{ 0xE8, 0x8C, 0x97 },
	{ 0xE8, 0x8D, 0xA0 },
	{ 0xE8, 0x8C, 0xAD },
	{ 0xE8, 0x8C, 0xBA },
	{ 0xE8, 0x8C, 0xB3 },
	{ 0xE8, 0x8D, 0xA6 },
	{ 0xE8, 0x8D, 0xA5 },
	{ 0xE8, 0x8D, 0xA8 },
	{ 0xE8, 0x8C, 0x9B },
	{ 0xE8, 0x8D, 0xA9 },
	{ 0xE8, 0x8D, 0xAC },
	{ 0xE8, 0x8D, 0xAA },
	{ 0xE8, 0x8D, 0xAD },
	{ 0xE8, 0x8D, 0xAE },
	{ 0xE8, 0x8E, 0xB0 },
	{ 0xE8, 0x8D, 0xB8 },
	{ 0xE8, 0x8E, 0xB3 },
	{ 0xE8, 0x8E, 0xB4 },
	{ 0xE8, 0x8E, 0xA0 },
	{ 0xE8, 0x8E, 0xAA },
	{ 0xE8, 0x8E, 0x93 },
	{ 0xE8, 0x8E, 0x9C },
	{ 0xE8, 0x8E, 0x85 },
	{ 0xE8, 0x8D, 0xBC },
	{ 0xE8, 0x8E, 0xB6 },
	{ 0xE8, 0x8E, 0xA9 },
	{ 0xE8, 0x8D, 0xBD },
	{ 0xE8, 0x8E, 0xB8 },
	{ 0xE8, 0x8D, 0xBB },
	{ 0xE8, 0x8E, 0x98 },
	{ 0xE8, 0x8E, 0x9E },
	{ 0xE8, 0x8E, 0xA8 },
	{ 0xE8, 0x8E, 0xBA },
	{ 0xE8, 0x8E, 0xBC },
	{ 0xE8, 0x8F, 0x81 },
	{ 0xE8, 0x90, 0x81 },
	{ 0xE8, 0x8F, 0xA5 },
	{ 0xE8, 0x8F, 0x98 },
	{ 0xE5, 0xA0, 0x87 },
	{ 0xE8, 0x90, 0x98 },
	{ 0xE8, 0x90, 0x8B },
	{ 0xE8, 0x8F, 0x9D },
	{ 0xE8, 0x8F, 0xBD },
	{ 0xE8, 0x8F, 0x96 },
	{ 0xE8, 0x90, 0x9C },
	{ 0xE8, 0x90, 0xB8 },
	{ 0xE8, 0x90, 0x91 },
	{ 0xE8, 0x90, 0x86 },
	{ 0xE8, 0x8F, 0x94 },
	{ 0xE8, 0x8F, 0x9F },
	{ 0xE8, 0x90, 0x8F },
	{ 0xE8, 0x90, 0x83 },
	{ 0xE8, 0x8F, 0xB8 },
	{ 0xE8, 0x8F, 0xB9 },
	{ 0xE8, 0x8F, 0xAA },
	{ 0xE8, 0x8F, 0x85 },
	{ 0xE8, 0x8F, 0x80 },
	{ 0xE8, 0x90, 0xA6 },
	{ 0xE8, 0x8F, 0xB0 },
	{ 0xE8, 0x8F, 0xA1 },
	{ 0xE8, 0x91, 0x9C },
	{ 0xE8, 0x91, 0x91 },
	{ 0xE8, 0x91, 0x9A },
	{ 0xE8, 0x91, 0x99 },
	{ 0xE8, 0x91, 0xB3 },
	{ 0xE8, 0x92, 0x87 },
	{ 0xE8, 0x92, 0x88 },
	{ 0xE8, 0x91, 0xBA },
	{ 0xE8, 0x92, 0x89 },
	{ 0xE8, 0x91, 0xB8 },
	{ 0xE8, 0x90, 0xBC },
	{ 0xE8, 0x91, 0x86 },
	{ 0xE8, 0x91, 0xA9 },
	{ 0xE8, 0x91, 0xB6 },
	{ 0xE8, 0x92, 0x8C },
	{ 0xE8, 0x92, 0x8E },
	{ 0xE8, 0x90, 0xB1 },
	{ 0xE8, 0x91, 0xAD },
	{ 0xE8, 0x93, 0x81 },
	{ 0xE8, 0x93, 0x8D },
	{ 0xE8, 0x93, 0x90 },
	{ 0xE8, 0x93, 0xA6 },
	{ 0xE8, 0x92, 0xBD },
	{ 0xE8, 0x93, 0x93 },
	{ 0xE8, 0x93, 0x8A },
	{ 0xE8, 0x92, 0xBF },
	{ 0xE8, 0x92, 0xBA },
	{ 0xE8, 0x93, 0xA0 },
	{ 0xE8, 0x92, 0xA1 },
	{ 0xE8, 0x92, 0xB9 },
	{ 0xE8, 0x92, 0xB4 },
	{ 0xE8, 0x92, 0x97 },
	{ 0xE8, 0x93, 0xA5 },
	{ 0xE8, 0x93, 0xA3 },
	{ 0xE8, 0x94, 0x8C },
	{ 0xE7, 0x94, 0x8D },
	{ 0xE8, 0x94, 0xB8 },
	{ 0xE8, 0x93, 0xB0 },
	{ 0xE8, 0x94, 0xB9 },
	{ 0xE8, 0x94, 0x9F },
	{ 0xE8, 0x94, 0xBA },
	{ 0xE8, 0x95, 0x96 },
	{ 0xE8, 0x94, 0xBB },
	{ 0xE8, 0x93, 0xBF },
	{ 0xE8, 0x93, 0xBC },
	{ 0xE8, 0x95, 0x99 },
	{ 0xE8, 0x95, 0x88 },
	{ 0xE8, 0x95, 0xA8 },
	{ 0xE8, 0x95, 0xA4 },
	{ 0xE8, 0x95, 0x9E },
	{ 0xE8, 0x95, 0xBA },
	{ 0xE7, 0x9E, 0xA2 },
	{ 0xE8, 0x95, 0x83 },
	{ 0xE8, 0x95, 0xB2 },
	{ 0xE8, 0x95, 0xBB },
	{ 0xE8, 0x96, 0xA4 },
	{ 0xE8, 0x96, 0xA8 },
	{ 0xE8, 0x96, 0x87 },
	{ 0xE8, 0x96, 0x8F },
	{ 0xE8, 0x95, 0xB9 },
	{ 0xE8, 0x96, 0xAE },
	{ 0xE8, 0x96, 0x9C },
	{ 0xE8, 0x96, 0x85 },
	{ 0xE8, 0x96, 0xB9 },
	{ 0xE8, 0x96, 0xB7 },
	{ 0xE8, 0x96, 0xB0 },
	{ 0xE8, 0x97, 0x93 },
	{ 0xE8, 0x97, 0x81 },
	{ 0xE8, 0x97, 0x9C },
	{ 0xE8, 0x97, 0xBF },
	{ 0xE8, 0x98, 0xA7 },
	{ 0xE8, 0x98, 0x85 },
	{ 0xE8, 0x98, 0xA9 },
	{ 0xE8, 0x98, 0x96 },
	{ 0xE8, 0x98, 0xBC },
	{ 0xE5, 0xBB, 0xBE },
	{ 0xE5, 0xBC, 0x88 },
	{ 0xE5, 0xA4, 0xBC },
	{ 0xE5, 0xA5, 0x81 },
	{ 0xE8, 0x80, 0xB7 },
	{ 0xE5, 0xA5, 0x95 },
	{ 0xE5, 0xA5, 0x9A },
	{ 0xE5, 0xA5, 0x98 },
	{ 0xE5, 0x8C, 0x8F },
	{ 0xE5, 0xB0, 0xA2 },
	{ 0xE5, 0xB0, 0xA5 },
	{ 0xE5, 0xB0, 0xAC },
	{ 0xE5, 0xB0, 0xB4 },
	{ 0xE6, 0x89, 0x8C },
	{ 0xE6, 0x89, 0xAA },
	{ 0xE6, 0x8A, 0x9F },
	{ 0xE6, 0x8A, 0xBB },
	{ 0xE6, 0x8B, 0x8A },
	{ 0xE6, 0x8B, 0x9A },
	{ 0xE6, 0x8B, 0x97 },
	{ 0xE6, 0x8B, 0xAE },
	{ 0xE6, 0x8C, 0xA2 },
	{ 0xE6, 0x8B, 0xB6 },
	{ 0xE6, 0x8C, 0xB9 },
	{ 0xE6, 0x8D, 0x8B },
	{ 0xE6, 0x8D, 0x83 },
	{ 0xE6, 0x8E, 0xAD },
	{ 0xE6, 0x8F, 0xB6 },
	{ 0xE6, 0x8D, 0xB1 },
	{ 0xE6, 0x8D, 0xBA },
	{ 0xE6, 0x8E, 0x8E },
	{ 0xE6, 0x8E, 0xB4 },
	{ 0xE6, 0x8D, 0xAD },
	{ 0xE6, 0x8E, 0xAC },
	{ 0xE6, 0x8E, 0x8A },
	{ 0xE6, 0x8D, 0xA9 },
	{ 0xE6, 0x8E, 0xAE },
	{ 0xE6, 0x8E, 0xBC },
	{ 0xE6, 0x8F, 0xB2 },
	{ 0xE6, 0x8F, 0xB8 },
	{ 0xE6, 0x8F, 0xA0 },
	{ 0xE6, 0x8F, 0xBF },
	{ 0xE6, 0x8F, 0x84 },
	{ 0xE6, 0x8F, 0x9E },
	{ 0xE6, 0x8F, 0x8E },
	{ 0xE6, 0x91, 0x92 },
	{ 0xE6, 0x8F, 0x86 },
	{ 0xE6, 0x8E, 0xBE },
	{ 0xE6, 0x91, 0x85 },
	{ 0xE6, 0x91, 0x81 },
	{ 0xE6, 0x90, 0x8B },
	{ 0xE6, 0x90, 0x9B },
	{ 0xE6, 0x90, 0xA0 },
	{ 0xE6, 0x90, 0x8C },
	{ 0xE6, 0x90, 0xA6 },
	{ 0xE6, 0x90, 0xA1 },
	{ 0xE6, 0x91, 0x9E },
	{ 0xE6, 0x92, 0x84 },
	{ 0xE6, 0x91, 0xAD },
	{ 0xE6, 0x92, 0x96 },
	{ 0xE6, 0x91, 0xBA },
	{ 0xE6, 0x92, 0xB7 },
	{ 0xE6, 0x92, 0xB8 },
	{ 0xE6, 0x92, 0x99 },
	{ 0xE6, 0x92, 0xBA },
	{ 0xE6, 0x93, 0x80 },
	{ 0xE6, 0x93, 0x90 },
	{ 0xE6, 0x93, 0x97 },
	{ 0xE6, 0x93, 0xA4 },
	{ 0xE6, 0x93, 0xA2 },
	{ 0xE6, 0x94, 0x89 },
	{ 0xE6, 0x94, 0xA5 },
	{ 0xE6, 0x94, 0xAE },
	{ 0xE5, 0xBC, 0x8B },
	{ 0xE5, 0xBF, 0x92 },
	{ 0xE7, 0x94, 0x99 },
	{ 0xE5, 0xBC, 0x91 },
	{ 0xE5, 0x8D, 0x9F },
	{ 0xE5, 0x8F, 0xB1 },
	{ 0xE5, 0x8F, 0xBD },
	{ 0xE5, 0x8F, 0xA9 },
	{ 0xE5, 0x8F, 0xA8 },
	{ 0xE5, 0x8F, 0xBB },
	{ 0xE5, 0x90, 0x92 },
	{ 0xE5, 0x90, 0x96 },
	{ 0xE5, 0x90, 0x86 },
	{ 0xE5, 0x91, 0x8B },
	{ 0xE5, 0x91, 0x92 },
	{ 0xE5, 0x91, 0x93 },
	{ 0xE5, 0x91, 0x94 },
	{ 0xE5, 0x91, 0x96 },
	{ 0xE5, 0x91, 0x83 },
	{ 0xE5, 0x90, 0xA1 },
	{ 0xE5, 0x91, 0x97 },
	{ 0xE5, 0x91, 0x99 },
	{ 0xE5, 0x90, 0xA3 },
	{ 0xE5, 0x90, 0xB2 },
	{ 0xE5, 0x92, 0x82 },
	{ 0xE5, 0x92, 0x94 },
	{ 0xE5, 0x91, 0xB7 },
	{ 0xE5, 0x91, 0xB1 },
	{ 0xE5, 0x91, 0xA4 },
	{ 0xE5, 0x92, 0x9A },
	{ 0xE5, 0x92, 0x9B },
	{ 0xE5, 0x92, 0x84 },
	{ 0xE5, 0x91, 0xB6 },
	{ 0xE5, 0x91, 0xA6 },
	{ 0xE5, 0x92, 0x9D },
	{ 0xE5, 0x93, 0x90 },
	{ 0xE5, 0x92, 0xAD },
	{ 0xE5, 0x93, 0x82 },
	{ 0xE5, 0x92, 0xB4 },
	{ 0xE5, 0x93, 0x92 },
	{ 0xE5, 0x92, 0xA7 },
	{ 0xE5, 0x92, 0xA6 },
	{ 0xE5, 0x93, 0x93 },
	{ 0xE5, 0x93, 0x94 },
	{ 0xE5, 0x91, 0xB2 },
	{ 0xE5, 0x92, 0xA3 },
	{ 0xE5, 0x93, 0x95 },
	{ 0xE5, 0x92, 0xBB },
	{ 0xE5, 0x92, 0xBF },
	{ 0xE5, 0x93, 0x8C },
	{ 0xE5, 0x93, 0x99 },
	{ 0xE5, 0x93, 0x9A },
	{ 0xE5, 0x93, 0x9C },
	{ 0xE5, 0x92, 0xA9 },
	{ 0xE5, 0x92, 0xAA },
	{ 0xE5, 0x92, 0xA4 },
	{ 0xE5, 0x93, 0x9D },
	{ 0xE5, 0x93, 0x8F },
	{ 0xE5, 0x93, 0x9E },
	{ 0xE5, 0x94, 0x9B },
	{ 0xE5, 0x93, 0xA7 },
	{ 0xE5, 0x94, 0xA0 },
	{ 0xE5, 0x93, 0xBD },
	{ 0xE5, 0x94, 0x94 },
	{ 0xE5, 0x93, 0xB3 },
	{ 0xE5, 0x94, 0xA2 },
	{ 0xE5, 0x94, 0xA3 },
	{ 0xE5, 0x94, 0x8F },
	{ 0xE5, 0x94, 0x91 },
	{ 0xE5, 0x94, 0xA7 },
	{ 0xE5, 0x94, 0xAA },
	{ 0xE5, 0x95, 0xA7 },
	{ 0xE5, 0x96, 0x8F },
	{ 0xE5, 0x96, 0xB5 },
	{ 0xE5, 0x95, 0x89 },
	{ 0xE5, 0x95, 0xAD },
	{ 0xE5, 0x95, 0x81 },
	{ 0xE5, 0x95, 0x95 },
	{ 0xE5, 0x94, 0xBF },
	{ 0xE5, 0x95, 0x90 },
	{ 0xE5, 0x94, 0xBC },
	{ 0xE5, 0x94, 0xB7 },
	{ 0xE5, 0x95, 0x96 },
	{ 0xE5, 0x95, 0xB5 },
	{ 0xE5, 0x95, 0xB6 },
	{ 0xE5, 0x95, 0xB7 },
	{ 0xE5, 0x94, 0xB3 },
	{ 0xE5, 0x94, 0xB0 },
	{ 0xE5, 0x95, 0x9C },
	{ 0xE5, 0x96, 0x8B },
	{ 0xE5, 0x97, 0x92 },
	{ 0xE5, 0x96, 0x83 },
	{ 0xE5, 0x96, 0xB1 },
	{ 0xE5, 0x96, 0xB9 },
	{ 0xE5, 0x96, 0x88 },
	{ 0xE5, 0x96, 0x81 },
	{ 0xE5, 0x96, 0x9F },
	{ 0xE5, 0x95, 0xBE },
	{ 0xE5, 0x97, 0x96 },
	{ 0xE5, 0x96, 0x91 },
	{ 0xE5, 0x95, 0xBB },
	{ 0xE5, 0x97, 0x9F },
	{ 0xE5, 0x96, 0xBD },
	{ 0xE5, 0x96, 0xBE },
	{ 0xE5, 0x96, 0x94 },
	{ 0xE5, 0x96, 0x99 },
	{ 0xE5, 0x97, 0xAA },
	{ 0xE5, 0x97, 0xB7 },
	{ 0xE5, 0x97, 0x89 },
	{ 0xE5, 0x98, 0x9F },
	{ 0xE5, 0x97, 0x91 },
	{ 0xE5, 0x97, 0xAB },
	{ 0xE5, 0x97, 0xAC },
	{ 0xE5, 0x97, 0x94 },
	{ 0xE5, 0x97, 0xA6 },
	{ 0xE5, 0x97, 0x9D },
	{ 0xE5, 0x97, 0x84 },
	{ 0xE5, 0x97, 0xAF },
	{ 0xE5, 0x97, 0xA5 },
	{ 0xE5, 0x97, 0xB2 },
	{ 0xE5, 0x97, 0xB3 },
	{ 0xE5, 0x97, 0x8C },
	{ 0xE5, 0x97, 0x8D },
	{ 0xE5, 0x97, 0xA8 },
	{ 0xE5, 0x97, 0xB5 },
	{ 0xE5, 0x97, 0xA4 },
	{ 0xE8, 0xBE, 0x94 },
	{ 0xE5, 0x98, 0x9E },
	{ 0xE5, 0x98, 0x88 },
	{ 0xE5, 0x98, 0x8C },
	{ 0xE5, 0x98, 0x81 },
	{ 0xE5, 0x98, 0xA4 },
	{ 0xE5, 0x98, 0xA3 },
	{ 0xE5, 0x97, 0xBE },
	{ 0xE5, 0x98, 0x80 },
	{ 0xE5, 0x98, 0xA7 },
	{ 0xE5, 0x98, 0xAD },
	{ 0xE5, 0x99, 0x98 },
	{ 0xE5, 0x98, 0xB9 },
	{ 0xE5, 0x99, 0x97 },
	{ 0xE5, 0x98, 0xAC },
	{ 0xE5, 0x99, 0x8D },
	{ 0xE5, 0x99, 0xA2 },
	{ 0xE5, 0x99, 0x99 },
	{ 0xE5, 0x99, 0x9C },
	{ 0xE5, 0x99, 0x8C },
	{ 0xE5, 0x99, 0x94 },
	{ 0xE5, 0x9A, 0x86 },
	{ 0xE5, 0x99, 0xA4 },
	{ 0xE5, 0x99, 0xB1 },
	{ 0xE5, 0x99, 0xAB },
	{ 0xE5, 0x99, 0xBB },
	{ 0xE5, 0x99, 0xBC },
	{ 0xE5, 0x9A, 0x85 },
	{ 0xE5, 0x9A, 0x93 },
	{ 0xE5, 0x9A, 0xAF },
	{ 0xE5, 0x9B, 0x94 },
	{ 0xE5, 0x9B, 0x97 },
	{ 0xE5, 0x9B, 0x9D },
	{ 0xE5, 0x9B, 0xA1 },
	{ 0xE5, 0x9B, 0xB5 },
	{ 0xE5, 0x9B, 0xAB },
	{ 0xE5, 0x9B, 0xB9 },
	{ 0xE5, 0x9B, 0xBF },
	{ 0xE5, 0x9C, 0x84 },
	{ 0xE5, 0x9C, 0x8A },
	{ 0xE5, 0x9C, 0x89 },
	{ 0xE5, 0x9C, 0x9C },
	{ 0xE5, 0xB8, 0x8F },
	{ 0xE5, 0xB8, 0x99 },
	{ 0xE5, 0xB8, 0x94 },
	{ 0xE5, 0xB8, 0x91 },
	{ 0xE5, 0xB8, 0xB1 },
	{ 0xE5, 0xB8, 0xBB },
	{ 0xE5, 0xB8, 0xBC },
	{ 0xE5, 0xB8, 0xB7 },
	{ 0xE5, 0xB9, 0x84 },
	{ 0xE5, 0xB9, 0x94 },
	{ 0xE5, 0xB9, 0x9B },
	{ 0xE5, 0xB9, 0x9E },
	{ 0xE5, 0xB9, 0xA1 },
	{ 0xE5, 0xB2, 0x8C },
	{ 0xE5, 0xB1, 0xBA },
	{ 0xE5, 0xB2, 0x8D },
	{ 0xE5, 0xB2, 0x90 },
	{ 0xE5, 0xB2, 0x96 },
	{ 0xE5, 0xB2, 0x88 },
	{ 0xE5, 0xB2, 0x98 },
	{ 0xE5, 0xB2, 0x99 },
	{ 0xE5, 0xB2, 0x91 },
	{ 0xE5, 0xB2, 0x9A },
	{ 0xE5, 0xB2, 0x9C },
	{ 0xE5, 0xB2, 0xB5 },
	{ 0xE5, 0xB2, 0xA2 },
	{ 0xE5, 0xB2, 0xBD },
	{ 0xE5, 0xB2, 0xAC },
	{ 0xE5, 0xB2, 0xAB },
	{ 0xE5, 0xB2, 0xB1 },
	{ 0xE5, 0xB2, 0xA3 },
	{ 0xE5, 0xB3, 0x81 },
	{ 0xE5, 0xB2, 0xB7 },
	{ 0xE5, 0xB3, 0x84 },
	{ 0xE5, 0xB3, 0x92 },
	{ 0xE5, 0xB3, 0xA4 },
	{ 0xE5, 0xB3, 0x8B },
	{ 0xE5, 0xB3, 0xA5 },
	{ 0xE5, 0xB4, 0x82 },
	{ 0xE5, 0xB4, 0x83 },
	{ 0xE5, 0xB4, 0xA7 },
	{ 0xE5, 0xB4, 0xA6 },
	{ 0xE5, 0xB4, 0xAE },
	{ 0xE5, 0xB4, 0xA4 },
	{ 0xE5, 0xB4, 0x9E },
	{ 0xE5, 0xB4, 0x86 },
	{ 0xE5, 0xB4, 0x9B },
	{ 0xE5, 0xB5, 0x98 },
	{ 0xE5, 0xB4, 0xBE },
	{ 0xE5, 0xB4, 0xB4 },
	{ 0xE5, 0xB4, 0xBD },
	{ 0xE5, 0xB5, 0xAC },
	{ 0xE5, 0xB5, 0x9B },
	{ 0xE5, 0xB5, 0xAF },
	{ 0xE5, 0xB5, 0x9D },
	{ 0xE5, 0xB5, 0xAB },
	{ 0xE5, 0xB5, 0x8B },
	{ 0xE5, 0xB5, 0x8A },
	{ 0xE5, 0xB5, 0xA9 },
	{ 0xE5, 0xB5, 0xB4 },
	{ 0xE5, 0xB6, 0x82 },
	{ 0xE5, 0xB6, 0x99 },
	{ 0xE5, 0xB6, 0x9D },
	{ 0xE8, 0xB1, 0xB3 },
	{ 0xE5, 0xB6, 0xB7 },
	{ 0xE5, 0xB7, 0x85 },
	{ 0xE5, 0xBD, 0xB3 },
	{ 0xE5, 0xBD, 0xB7 },
	{ 0xE5, 0xBE, 0x82 },
	{ 0xE5, 0xBE, 0x87 },
	{ 0xE5, 0xBE, 0x89 },
	{ 0xE5, 0xBE, 0x8C },
	{ 0xE5, 0xBE, 0x95 },
	{ 0xE5, 0xBE, 0x99 },
	{ 0xE5, 0xBE, 0x9C },
	{ 0xE5, 0xBE, 0xA8 },
	{ 0xE5, 0xBE, 0xAD },
	{ 0xE5, 0xBE, 0xB5 },
	{ 0xE5, 0xBE, 0xBC },
	{ 0xE8, 0xA1, 0xA2 },
	{ 0xE5, 0xBD, 0xA1 },
	{ 0xE7, 0x8A, 0xAD },
	{ 0xE7, 0x8A, 0xB0 },
	{ 0xE7, 0x8A, 0xB4 },
	{ 0xE7, 0x8A, 0xB7 },
	{ 0xE7, 0x8A, 0xB8 },
	{ 0xE7, 0x8B, 0x83 },
	{ 0xE7, 0x8B, 0x81 },
	{ 0xE7, 0x8B, 0x8E },
	{ 0xE7, 0x8B, 0x8D },
	{ 0xE7, 0x8B, 0x92 },
	{ 0xE7, 0x8B, 0xA8 },
	{ 0xE7, 0x8B, 0xAF },
	{ 0xE7, 0x8B, 0xA9 },
	{ 0xE7, 0x8B, 0xB2 },
	{ 0xE7, 0x8B, 0xB4 },
	{ 0xE7, 0x8B, 0xB7 },
	{ 0xE7, 0x8C, 0x81 },
	{ 0xE7, 0x8B, 0xB3 },
	{ 0xE7, 0x8C, 0x83 },
	{ 0xE7, 0x8B, 0xBA },
	{ 0xE7, 0x8B, 0xBB },
	{ 0xE7, 0x8C, 0x97 },
	{ 0xE7, 0x8C, 0x93 },
	{ 0xE7, 0x8C, 0xA1 },
	{ 0xE7, 0x8C, 0x8A },
	{ 0xE7, 0x8C, 0x9E },
	{ 0xE7, 0x8C, 0x9D },
	{ 0xE7, 0x8C, 0x95 },
	{ 0xE7, 0x8C, 0xA2 },
	{ 0xE7, 0x8C, 0xB9 },
	{ 0xE7, 0x8C, 0xA5 },
	{ 0xE7, 0x8C, 0xAC },
	{ 0xE7, 0x8C, 0xB8 },
	{ 0xE7, 0x8C, 0xB1 },
	{ 0xE7, 0x8D, 0x90 },
	{ 0xE7, 0x8D, 0x8D },
	{ 0xE7, 0x8D, 0x97 },
	{ 0xE7, 0x8D, 0xA0 },
	{ 0xE7, 0x8D, 0xAC },
	{ 0xE7, 0x8D, 0xAF },
	{ 0xE7, 0x8D, 0xBE },
	{ 0xE8, 0x88, 0x9B },
	{ 0xE5, 0xA4, 0xA5 },
	{ 0xE9, 0xA3, 0xA7 },
	{ 0xE5, 0xA4, 0xA4 },
	{ 0xE5, 0xA4, 0x82 },
	{ 0xE9, 0xA5, 0xA3 },
	{ 0xE9, 0xA5, 0xA7 },
	{ 0xE9, 0xA5, 0xA8 },
	{ 0xE9, 0xA5, 0xA9 },
	{ 0xE9, 0xA5, 0xAA },
	{ 0xE9, 0xA5, 0xAB },
	{ 0xE9, 0xA5, 0xAC },
	{ 0xE9, 0xA5, 0xB4 },
	{ 0xE9, 0xA5, 0xB7 },
	{ 0xE9, 0xA5, 0xBD },
	{ 0xE9, 0xA6, 0x80 },
	{ 0xE9, 0xA6, 0x84 },
	{ 0xE9, 0xA6, 0x87 },
	{ 0xE9, 0xA6, 0x8A },
	{ 0xE9, 0xA6, 0x8D },
	{ 0xE9, 0xA6, 0x90 },
	{ 0xE9, 0xA6, 0x91 },
	{ 0xE9, 0xA6, 0x93 },
	{ 0xE9, 0xA6, 0x94 },
	{ 0xE9, 0xA6, 0x95 },
	{ 0xE5, 0xBA, 0x80 },
	{ 0xE5, 0xBA, 0x91 },
	{ 0xE5, 0xBA, 0x8B },
	{ 0xE5, 0xBA, 0x96 },
	{ 0xE5, 0xBA, 0xA5 },
	{ 0xE5, 0xBA, 0xA0 },
	{ 0xE5, 0xBA, 0xB9 },
	{ 0xE5, 0xBA, 0xB5 },
	{ 0xE5, 0xBA, 0xBE },
	{ 0xE5, 0xBA, 0xB3 },
	{ 0xE8, 0xB5, 0x93 },
	{ 0xE5, 0xBB, 0x92 },
	{ 0xE5, 0xBB, 0x91 },
	{ 0xE5, 0xBB, 0x9B },
	{ 0xE5, 0xBB, 0xA8 },
	{ 0xE5, 0xBB, 0xAA },
	{ 0xE8, 0x86, 0xBA },
	{ 0xE5, 0xBF, 0x84 },
	{ 0xE5, 0xBF, 0x89 },
	{ 0xE5, 0xBF, 0x96 },
	{ 0xE5, 0xBF, 0x8F },
	{ 0xE6, 0x80, 0x83 },
	{ 0xE5, 0xBF, 0xAE },
	{ 0xE6, 0x80, 0x84 },
	{ 0xE5, 0xBF, 0xA1 },
	{ 0xE5, 0xBF, 0xA4 },
	{ 0xE5, 0xBF, 0xBE },
	{ 0xE6, 0x80, 0x85 },
	{ 0xE6, 0x80, 0x86 },
	{ 0xE5, 0xBF, 0xAA },
	{ 0xE5, 0xBF, 0xAD },
	{ 0xE5, 0xBF, 0xB8 },
	{ 0xE6, 0x80, 0x99 },
	{ 0xE6, 0x80, 0xB5 },
	{ 0xE6, 0x80, 0xA6 },
	{ 0xE6, 0x80, 0x9B },
	{ 0xE6, 0x80, 0x8F },
	{ 0xE6, 0x80, 0x8D },
	{ 0xE6, 0x80, 0xA9 },
	{ 0xE6, 0x80, 0xAB },
	{ 0xE6, 0x80, 0x8A },
	{ 0xE6, 0x80, 0xBF },
	{ 0xE6, 0x80, 0xA1 },
	{ 0xE6, 0x81, 0xB8 },
	{ 0xE6, 0x81, 0xB9 },
	{ 0xE6, 0x81, 0xBB },
	{ 0xE6, 0x81, 0xBA },
	{ 0xE6, 0x81, 0x82 },
	{ 0xE6, 0x81, 0xAA },
	{ 0xE6, 0x81, 0xBD },
	{ 0xE6, 0x82, 0x96 },
	{ 0xE6, 0x82, 0x9A },
	{ 0xE6, 0x82, 0xAD },
	{ 0xE6, 0x82, 0x9D },
	{ 0xE6, 0x82, 0x83 },
	{ 0xE6, 0x82, 0x92 },
	{ 0xE6, 0x82, 0x8C },
	{ 0xE6, 0x82, 0x9B },
	{ 0xE6, 0x83, 0xAC },
	{ 0xE6, 0x82, 0xBB },
	{ 0xE6, 0x82, 0xB1 },
	{ 0xE6, 0x83, 0x9D },
	{ 0xE6, 0x83, 0x98 },
	{ 0xE6, 0x83, 0x86 },
	{ 0xE6, 0x83, 0x9A },
	{ 0xE6, 0x82, 0xB4 },
	{ 0xE6, 0x84, 0xA0 },
	{ 0xE6, 0x84, 0xA6 },
	{ 0xE6, 0x84, 0x95 },
	{ 0xE6, 0x84, 0xA3 },
	{ 0xE6, 0x83, 0xB4 },
	{ 0xE6, 0x84, 0x80 },
	{ 0xE6, 0x84, 0x8E },
	{ 0xE6, 0x84, 0xAB },
	{ 0xE6, 0x85, 0x8A },
	{ 0xE6, 0x85, 0xB5 },
	{ 0xE6, 0x86, 0xAC },
	{ 0xE6, 0x86, 0x94 },
	{ 0xE6, 0x86, 0xA7 },
	{ 0xE6, 0x86, 0xB7 },
	{ 0xE6, 0x87, 0x94 },
	{ 0xE6, 0x87, 0xB5 },
	{ 0xE5, 0xBF, 0x9D },
	{ 0xE9, 0x9A, 0xB3 },
	{ 0xE9, 0x97, 0xA9 },
	{ 0xE9, 0x97, 0xAB },
	{ 0xE9, 0x97, 0xB1 },
	{ 0xE9, 0x97, 0xB3 },
	{ 0xE9, 0x97, 0xB5 },
	{ 0xE9, 0x97, 0xB6 },
	{ 0xE9, 0x97, 0xBC },
	{ 0xE9, 0x97, 0xBE },
	{ 0xE9, 0x98, 0x83 },
	{ 0xE9, 0x98, 0x84 },
	{ 0xE9, 0x98, 0x86 },
	{ 0xE9, 0x98, 0x88 },
	{ 0xE9, 0x98, 0x8A },
	{ 0xE9, 0x98, 0x8B },
	{ 0xE9, 0x98, 0x8C },
	{ 0xE9, 0x98, 0x8D },
	{ 0xE9, 0x98, 0x8F },
	{ 0xE9, 0x98, 0x92 },
	{ 0xE9, 0x98, 0x95 },
	{ 0xE9, 0x98, 0x96 },
	{ 0xE9, 0x98, 0x97 },
	{ 0xE9, 0x98, 0x99 },
	{ 0xE9, 0x98, 0x9A },
	{ 0xE4, 0xB8, 0xAC },
	{ 0xE7, 0x88, 0xBF },
	{ 0xE6, 0x88, 0x95 },
	{ 0xE6, 0xB0, 0xB5 },
	{ 0xE6, 0xB1, 0x94 },
	{ 0xE6, 0xB1, 0x9C },
	{ 0xE6, 0xB1, 0x8A },
	{ 0xE6, 0xB2, 0xA3 },
	{ 0xE6, 0xB2, 0x85 },
	{ 0xE6, 0xB2, 0x90 },
	{ 0xE6, 0xB2, 0x94 },
	{ 0xE6, 0xB2, 0x8C },
	{ 0xE6, 0xB1, 0xA8 },
	{ 0xE6, 0xB1, 0xA9 },
	{ 0xE6, 0xB1, 0xB4 },
	{ 0xE6, 0xB1, 0xB6 },
	{ 0xE6, 0xB2, 0x86 },
	{ 0xE6, 0xB2, 0xA9 },
	{ 0xE6, 0xB3, 0x90 },
	{ 0xE6, 0xB3, 0x94 },
	{ 0xE6, 0xB2, 0xAD },
	{ 0xE6, 0xB3, 0xB7 },
	{ 0xE6, 0xB3, 0xB8 },
	{ 0xE6, 0xB3, 0xB1 },
	{ 0xE6, 0xB3, 0x97 },
	{ 0xE6, 0xB2, 0xB2 },
	{ 0xE6, 0xB3, 0xA0 },
	{ 0xE6, 0xB3, 0x96 },
	{ 0xE6, 0xB3, 0xBA },
	{ 0xE6, 0xB3, 0xAB },
	{ 0xE6, 0xB3, 0xAE },
	{ 0xE6, 0xB2, 0xB1 },
	{ 0xE6, 0xB3, 0x93 },
	{ 0xE6, 0xB3, 0xAF },
	{ 0xE6, 0xB3, 0xBE },
	{ 0xE6, 0xB4, 0xB9 },
	{ 0xE6, 0xB4, 0xA7 },
	{ 0xE6, 0xB4, 0x8C },
	{ 0xE6, 0xB5, 0x83 },
	{ 0xE6, 0xB5, 0x88 },
	{ 0xE6, 0xB4, 0x87 },
	{ 0xE6, 0xB4, 0x84 },
	{ 0xE6, 0xB4, 0x99 },
	{ 0xE6, 0xB4, 0x8E },
	{ 0xE6, 0xB4, 0xAB },
	{ 0xE6, 0xB5, 0x8D },
	{ 0xE6, 0xB4, 0xAE },
	{ 0xE6, 0xB4, 0xB5 },
	{ 0xE6, 0xB4, 0x9A },
	{ 0xE6, 0xB5, 0x8F },
	{ 0xE6, 0xB5, 0x92 },
	{ 0xE6, 0xB5, 0x94 },
	{ 0xE6, 0xB4, 0xB3 },
	{ 0xE6, 0xB6, 0x91 },
	{ 0xE6, 0xB5, 0xAF },
	{ 0xE6, 0xB6, 0x9E },
	{ 0xE6, 0xB6, 0xA0 },
	{ 0xE6, 0xB5, 0x9E },
	{ 0xE6, 0xB6, 0x93 },
	{ 0xE6, 0xB6, 0x94 },
	{ 0xE6, 0xB5, 0x9C },
	{ 0xE6, 0xB5, 0xA0 },
	{ 0xE6, 0xB5, 0xBC },
	{ 0xE6, 0xB5, 0xA3 },
	{ 0xE6, 0xB8, 0x9A },
	{ 0xE6, 0xB7, 0x87 },
	{ 0xE6, 0xB7, 0x85 },
	{ 0xE6, 0xB7, 0x9E },
	{ 0xE6, 0xB8, 0x8E },
	{ 0xE6, 0xB6, 0xBF },
	{ 0xE6, 0xB7, 0xA0 },
	{ 0xE6, 0xB8, 0x91 },
	{ 0xE6, 0xB7, 0xA6 },
	{ 0xE6, 0xB7, 0x9D },
	{ 0xE6, 0xB7, 0x99 },
	{ 0xE6, 0xB8, 0x96 },
	{ 0xE6, 0xB6, 0xAB },
	{ 0xE6, 0xB8, 0x8C },
	{ 0xE6, 0xB6, 0xAE },
	{ 0xE6, 0xB8, 0xAB },
	{ 0xE6, 0xB9, 0xAE },
	{ 0xE6, 0xB9, 0x8E },
	{ 0xE6, 0xB9, 0xAB },
	{ 0xE6, 0xBA, 0xB2 },
	{ 0xE6, 0xB9, 0x9F },
	{ 0xE6, 0xBA, 0x86 },
	{ 0xE6, 0xB9, 0x93 },
	{ 0xE6, 0xB9, 0x94 },
	{ 0xE6, 0xB8, 0xB2 },
	{ 0xE6, 0xB8, 0xA5 },
	{ 0xE6, 0xB9, 0x84 },
	{ 0xE6, 0xBB, 0x9F },
	{ 0xE6, 0xBA, 0xB1 },
	{ 0xE6, 0xBA, 0x98 },
	{ 0xE6, 0xBB, 0xA0 },
	{ 0xE6, 0xBC, 0xAD },
	{ 0xE6, 0xBB, 0xA2 },
	{ 0xE6, 0xBA, 0xA5 },
	{ 0xE6, 0xBA, 0xA7 },
	{ 0xE6, 0xBA, 0xBD },
	{ 0xE6, 0xBA, 0xBB },
	{ 0xE6, 0xBA, 0xB7 },
	{ 0xE6, 0xBB, 0x97 },
	{ 0xE6, 0xBA, 0xB4 },
	{ 0xE6, 0xBB, 0x8F },
	{ 0xE6, 0xBA, 0x8F },
	{ 0xE6, 0xBB, 0x82 },
	{ 0xE6, 0xBA, 0x9F },
	{ 0xE6, 0xBD, 0xA2 },
	{ 0xE6, 0xBD, 0x86 },
	{ 0xE6, 0xBD, 0x87 },
	{ 0xE6, 0xBC, 0xA4 },
	{ 0xE6, 0xBC, 0x95 },
	{ 0xE6, 0xBB, 0xB9 },
	{ 0xE6, 0xBC, 0xAF },
	{ 0xE6, 0xBC, 0xB6 },
	{ 0xE6, 0xBD, 0x8B },
	{ 0xE6, 0xBD, 0xB4 },
	{ 0xE6, 0xBC, 0xAA },
	{ 0xE6, 0xBC, 0x89 },
	{ 0xE6, 0xBC, 0xA9 },
	{ 0xE6, 0xBE, 0x89 },
	{ 0xE6, 0xBE, 0x8D },
	{ 0xE6, 0xBE, 0x8C },
	{ 0xE6, 0xBD, 0xB8 },
	{ 0xE6, 0xBD, 0xB2 },
	{ 0xE6, 0xBD, 0xBC },
	{ 0xE6, 0xBD, 0xBA },
	{ 0xE6, 0xBF, 0x91 },
	{ 0xE6, 0xBF, 0x89 },
	{ 0xE6, 0xBE, 0xA7 },
	{ 0xE6, 0xBE, 0xB9 },
	{ 0xE6, 0xBE, 0xB6 },
	{ 0xE6, 0xBF, 0x82 },
	{ 0xE6, 0xBF, 0xA1 },
	{ 0xE6, 0xBF, 0xAE },
	{ 0xE6, 0xBF, 0x9E },
	{ 0xE6, 0xBF, 0xA0 },
	{ 0xE6, 0xBF, 0xAF },
	{ 0xE7, 0x80, 0x9A },
	{ 0xE7, 0x80, 0xA3 },
	{ 0xE7, 0x80, 0x9B },
	{ 0xE7, 0x80, 0xB9 },
	{ 0xE7, 0x80, 0xB5 },
	{ 0xE7, 0x81, 0x8F },
	{ 0xE7, 0x81, 0x9E },
	{ 0xE5, 0xAE, 0x80 },
	{ 0xE5, 0xAE, 0x84 },
	{ 0xE5, 0xAE, 0x95 },
	{ 0xE5, 0xAE, 0x93 },
	{ 0xE5, 0xAE, 0xA5 },
	{ 0xE5, 0xAE, 0xB8 },
	{ 0xE7, 0x94, 0xAF },
	{ 0xE9, 0xAA, 0x9E },
	{ 0xE6, 0x90, 0xB4 },
	{ 0xE5, 0xAF, 0xA4 },
	{ 0xE5, 0xAF, 0xAE },
	{ 0xE8, 0xA4, 0xB0 },
	{ 0xE5, 0xAF, 0xB0 },
	{ 0xE8, 0xB9, 0x87 },
	{ 0xE8, 0xAC, 0x87 },
	{ 0xE8, 0xBE, 0xB6 },
	{ 0xE8, 0xBF, 0x93 },
	{ 0xE8, 0xBF, 0x95 },
	{ 0xE8, 0xBF, 0xA5 },
	{ 0xE8, 0xBF, 0xAE },
	{ 0xE8, 0xBF, 0xA4 },
	{ 0xE8, 0xBF, 0xA9 },
	{ 0xE8, 0xBF, 0xA6 },
	{ 0xE8, 0xBF, 0xB3 },
	{ 0xE8, 0xBF, 0xA8 },
	{ 0xE9, 0x80, 0x85 },
	{ 0xE9, 0x80, 0x84 },
	{ 0xE9, 0x80, 0x8B },
	{ 0xE9, 0x80, 0xA6 },
	{ 0xE9, 0x80, 0x91 },
	{ 0xE9, 0x80, 0x8D },
	{ 0xE9, 0x80, 0x96 },
	{ 0xE9, 0x80, 0xA1 },
	{ 0xE9, 0x80, 0xB5 },
	{ 0xE9, 0x80, 0xB6 },
	{ 0xE9, 0x80, 0xAD },
	{ 0xE9, 0x80, 0xAF },
	{ 0xE9, 0x81, 0x84 },
	{ 0xE9, 0x81, 0x91 },
	{ 0xE9, 0x81, 0x92 },
	{ 0xE9, 0x81, 0x90 },
	{ 0xE9, 0x81, 0xA8 },
	{ 0xE9, 0x81, 0x98 },
	{ 0xE9, 0x81, 0xA2 },
	{ 0xE9, 0x81, 0x9B },
	{ 0xE6, 0x9A, 0xB9 },
	{ 0xE9, 0x81, 0xB4 },
	{ 0xE9, 0x81, 0xBD },
	{ 0xE9, 0x82, 0x82 },
	{ 0xE9, 0x82, 0x88 },
	{ 0xE9, 0x82, 0x83 },
	{ 0xE9, 0x82, 0x8B },
	{ 0xE5, 0xBD, 0x90 },
	{ 0xE5, 0xBD, 0x97 },
	{ 0xE5, 0xBD, 0x96 },
	{ 0xE5, 0xBD, 0x98 },
	{ 0xE5, 0xB0, 0xBB },
	{ 0xE5, 0x92, 0xAB },
	{ 0xE5, 0xB1, 0x90 },
	{ 0xE5, 0xB1, 0x99 },
	{ 0xE5, 0xAD, 0xB1 },
	{ 0xE5, 0xB1, 0xA3 },
	{ 0xE5, 0xB1, 0xA6 },
	{ 0xE7, 0xBE, 0xBC },
	{ 0xE5, 0xBC, 0xAA },
	{ 0xE5, 0xBC, 0xA9 },
	{ 0xE5, 0xBC, 0xAD },
	{ 0xE8, 0x89, 0xB4 },
	{ 0xE5, 0xBC, 0xBC },
	{ 0xE9, 0xAC, 0xBB },
	{ 0xE5, 0xB1, 0xAE },
	{ 0xE5, 0xA6, 0x81 },
	{ 0xE5, 0xA6, 0x83 },
	{ 0xE5, 0xA6, 0x8D },
	{ 0xE5, 0xA6, 0xA9 },
	{ 0xE5, 0xA6, 0xAA },
	{ 0xE5, 0xA6, 0xA3 },
	{ 0xE5, 0xA6, 0x97 },
	{ 0xE5, 0xA7, 0x8A },
	{ 0xE5, 0xA6, 0xAB },
	{ 0xE5, 0xA6, 0x9E },
	{ 0xE5, 0xA6, 0xA4 },
	{ 0xE5, 0xA7, 0x92 },
	{ 0xE5, 0xA6, 0xB2 },
	{ 0xE5, 0xA6, 0xAF },
	{ 0xE5, 0xA7, 0x97 },
	{ 0xE5, 0xA6, 0xBE },
	{ 0xE5, 0xA8, 0x85 },
	{ 0xE5, 0xA8, 0x86 },
	{ 0xE5, 0xA7, 0x9D },
	{ 0xE5, 0xA8, 0x88 },
	{ 0xE5, 0xA7, 0xA3 },
	{ 0xE5, 0xA7, 0x98 },
	{ 0xE5, 0xA7, 0xB9 },
	{ 0xE5, 0xA8, 0x8C },
	{ 0xE5, 0xA8, 0x89 },
	{ 0xE5, 0xA8, 0xB2 },
	{ 0xE5, 0xA8, 0xB4 },
	{ 0xE5, 0xA8, 0x91 },
	{ 0xE5, 0xA8, 0xA3 },
	{ 0xE5, 0xA8, 0x93 },
	{ 0xE5, 0xA9, 0x80 },
	{ 0xE5, 0xA9, 0xA7 },
	{ 0xE5, 0xA9, 0x8A },
	{ 0xE5, 0xA9, 0x95 },
	{ 0xE5, 0xA8, 0xBC },
	{ 0xE5, 0xA9, 0xA2 },
	{ 0xE5, 0xA9, 0xB5 },
	{ 0xE8, 0x83, 0xAC },
	{ 0xE5, 0xAA, 0xAA },
	{ 0xE5, 0xAA, 0x9B },
	{ 0xE5, 0xA9, 0xB7 },
	{ 0xE5, 0xA9, 0xBA },
	{ 0xE5, 0xAA, 0xBE },
	{ 0xE5, 0xAB, 0xAB },
	{ 0xE5, 0xAA, 0xB2 },
	{ 0xE5, 0xAB, 0x92 },
	{ 0xE5, 0xAB, 0x94 },
	{ 0xE5, 0xAA, 0xB8 },
	{ 0xE5, 0xAB, 0xA0 },
	{ 0xE5, 0xAB, 0xA3 },
	{ 0xE5, 0xAB, 0xB1 },
	{ 0xE5, 0xAB, 0x96 },
	{ 0xE5, 0xAB, 0xA6 },
	{ 0xE5, 0xAB, 0x98 },
	{ 0xE5, 0xAB, 0x9C },
	{ 0xE5, 0xAC, 0x89 },
	{ 0xE5, 0xAC, 0x97 },
	{ 0xE5, 0xAC, 0x96 },
	{ 0xE5, 0xAC, 0xB2 },
	{ 0xE5, 0xAC, 0xB7 },
	{ 0xE5, 0xAD, 0x80 },
	{ 0xE5, 0xB0, 0x95 },
	{ 0xE5, 0xB0, 0x9C },
	{ 0xE5, 0xAD, 0x9A },
	{ 0xE5, 0xAD, 0xA5 },
	{ 0xE5, 0xAD, 0xB3 },
	{ 0xE5, 0xAD, 0x91 },
	{ 0xE5, 0xAD, 0x93 },
	{ 0xE5, 0xAD, 0xA2 },
	{ 0xE9, 0xA9, 0xB5 },
	{ 0xE9, 0xA9, 0xB7 },
	{ 0xE9, 0xA9, 0xB8 },
	{ 0xE9, 0xA9, 0xBA },
	{ 0xE9, 0xA9, 0xBF },
	{ 0xE9, 0xA9, 0xBD },
	{ 0xE9, 0xAA, 0x80 },
	{ 0xE9, 0xAA, 0x81 },
	{ 0xE9, 0xAA, 0x85 },
	{ 0xE9, 0xAA, 0x88 },
	{ 0xE9, 0xAA, 0x8A },
	{ 0xE9, 0xAA, 0x90 },
	{ 0xE9, 0xAA, 0x92 },
	{ 0xE9, 0xAA, 0x93 },
	{ 0xE9, 0xAA, 0x96 },
	{ 0xE9, 0xAA, 0x98 },
	{ 0xE9, 0xAA, 0x9B },
	{ 0xE9, 0xAA, 0x9C },
	{ 0xE9, 0xAA, 0x9D },
	{ 0xE9, 0xAA, 0x9F },
	{ 0xE9, 0xAA, 0xA0 },
	{ 0xE9, 0xAA, 0xA2 },
	{ 0xE9, 0xAA, 0xA3 },
	{ 0xE9, 0xAA, 0xA5 },
	{ 0xE9, 0xAA, 0xA7 },
	{ 0xE7, 0xBA, 0x9F },
	{ 0xE7, 0xBA, 0xA1 },
	{ 0xE7, 0xBA, 0xA3 },
	{ 0xE7, 0xBA, 0xA5 },
	{ 0xE7, 0xBA, 0xA8 },
	{ 0xE7, 0xBA, 0xA9 },
	{ 0xE7, 0xBA, 0xAD },
	{ 0xE7, 0xBA, 0xB0 },
	{ 0xE7, 0xBA, 0xBE },
	{ 0xE7, 0xBB, 0x80 },
	{ 0xE7, 0xBB, 0x81 },
	{ 0xE7, 0xBB, 0x82 },
	{ 0xE7, 0xBB, 0x89 },
	{ 0xE7, 0xBB, 0x8B },
	{ 0xE7, 0xBB, 0x8C },
	{ 0xE7, 0xBB, 0x90 },
	{ 0xE7, 0xBB, 0x94 },
	{ 0xE7, 0xBB, 0x97 },
	{ 0xE7, 0xBB, 0x9B },
	{ 0xE7, 0xBB, 0xA0 },
	{ 0xE7, 0xBB, 0xA1 },
	{ 0xE7, 0xBB, 0xA8 },
	{ 0xE7, 0xBB, 0xAB },
	{ 0xE7, 0xBB, 0xAE },
	{ 0xE7, 0xBB, 0xAF },
	{ 0xE7, 0xBB, 0xB1 },
	{ 0xE7, 0xBB, 0xB2 },
	{ 0xE7, 0xBC, 0x8D },
	{ 0xE7, 0xBB, 0xB6 },
	{ 0xE7, 0xBB, 0xBA },
	{ 0xE7, 0xBB, 0xBB },
	{ 0xE7, 0xBB, 0xBE },
	{ 0xE7, 0xBC, 0x81 },
	{ 0xE7, 0xBC, 0x82 },
	{ 0xE7, 0xBC, 0x83 },
	{ 0xE7, 0xBC, 0x87 },
	{ 0xE7, 0xBC, 0x88 },
	{ 0xE7, 0xBC, 0x8B },
	{ 0xE7, 0xBC, 0x8C },
	{ 0xE7, 0xBC, 0x8F },
	{ 0xE7, 0xBC, 0x91 },
	{ 0xE7, 0xBC, 0x92 },
	{ 0xE7, 0xBC, 0x97 },
	{ 0xE7, 0xBC, 0x99 },
	{ 0xE7, 0xBC, 0x9C },
	{ 0xE7, 0xBC, 0x9B },
	{ 0xE7, 0xBC, 0x9F },
	{ 0xE7, 0xBC, 0xA1 },
	{ 0xE7, 0xBC, 0xA2 },
	{ 0xE7, 0xBC, 0xA3 },
	{ 0xE7, 0xBC, 0xA4 },
	{ 0xE7, 0xBC, 0xA5 },
	{ 0xE7, 0xBC, 0xA6 },
	{ 0xE7, 0xBC, 0xA7 },
	{ 0xE7, 0xBC, 0xAA },
	{ 0xE7, 0xBC, 0xAB },
	{ 0xE7, 0xBC, 0xAC },
	{ 0xE7, 0xBC, 0xAD },
	{ 0xE7, 0xBC, 0xAF },
	{ 0xE7, 0xBC, 0xB0 },
	{ 0xE7, 0xBC, 0xB1 },
	{ 0xE7, 0xBC, 0xB2 },
	{ 0xE7, 0xBC, 0xB3 },
	{ 0xE7, 0xBC, 0xB5 },
	{ 0xE5, 0xB9, 0xBA },
	{ 0xE7, 0x95, 0xBF },
	{ 0xE5, 0xB7, 0x9B },
	{ 0xE7, 0x94, 0xBE },
	{ 0xE9, 0x82, 0x95 },
	{ 0xE7, 0x8E, 0x8E },
	{ 0xE7, 0x8E, 0x91 },
	{ 0xE7, 0x8E, 0xAE },
	{ 0xE7, 0x8E, 0xA2 },
	{ 0xE7, 0x8E, 0x9F },
	{ 0xE7, 0x8F, 0x8F },
	{ 0xE7, 0x8F, 0x82 },
	{ 0xE7, 0x8F, 0x91 },
	{ 0xE7, 0x8E, 0xB7 },
	{ 0xE7, 0x8E, 0xB3 },
	{ 0xE7, 0x8F, 0x80 },
	{ 0xE7, 0x8F, 0x89 },
	{ 0xE7, 0x8F, 0x88 },
	{ 0xE7, 0x8F, 0xA5 },
	{ 0xE7, 0x8F, 0x99 },
	{ 0xE9, 0xA1, 0xBC },
	{ 0xE7, 0x90, 0x8A },
	{ 0xE7, 0x8F, 0xA9 },
	{ 0xE7, 0x8F, 0xA7 },
	{ 0xE7, 0x8F, 0x9E },
	{ 0xE7, 0x8E, 0xBA },
	{ 0xE7, 0x8F, 0xB2 },
	{ 0xE7, 0x90, 0x8F },
	{ 0xE7, 0x90, 0xAA },
	{ 0xE7, 0x91, 0x9B },
	{ 0xE7, 0x90, 0xA6 },
	{ 0xE7, 0x90, 0xA5 },
	{ 0xE7, 0x90, 0xA8 },
	{ 0xE7, 0x90, 0xB0 },
	{ 0xE7, 0x90, 0xAE },
	{ 0xE7, 0x90, 0xAC },
	{ 0xE7, 0x90, 0x9B },
	{ 0xE7, 0x90, 0x9A },
	{ 0xE7, 0x91, 0x81 },
	{ 0xE7, 0x91, 0x9C },
	{ 0xE7, 0x91, 0x97 },
	{ 0xE7, 0x91, 0x95 },
	{ 0xE7, 0x91, 0x99 },
	{ 0xE7, 0x91, 0xB7 },
	{ 0xE7, 0x91, 0xAD },
	{ 0xE7, 0x91, 0xBE },
	{ 0xE7, 0x92, 0x9C },
	{ 0xE7, 0x92, 0x8E },
	{ 0xE7, 0x92, 0x80 },
	{ 0xE7, 0x92, 0x81 },
	{ 0xE7, 0x92, 0x87 },
	{ 0xE7, 0x92, 0x8B },
	{ 0xE7, 0x92, 0x9E },
	{ 0xE7, 0x92, 0xA8 },
	{ 0xE7, 0x92, 0xA9 },
	{ 0xE7, 0x92, 0x90 },
	{ 0xE7, 0x92, 0xA7 },
	{ 0xE7, 0x93, 0x92 },
	{ 0xE7, 0x92, 0xBA },
	{ 0xE9, 0x9F, 0xAA },
	{ 0xE9, 0x9F, 0xAB },
	{ 0xE9, 0x9F, 0xAC },
	{ 0xE6, 0x9D, 0x8C },
	{ 0xE6, 0x9D, 0x93 },
	{ 0xE6, 0x9D, 0x9E },
	{ 0xE6, 0x9D, 0x88 },
	{ 0xE6, 0x9D, 0xA9 },
	{ 0xE6, 0x9E, 0xA5 },
	{ 0xE6, 0x9E, 0x87 },
	{ 0xE6, 0x9D, 0xAA },
	{ 0xE6, 0x9D, 0xB3 },
	{ 0xE6, 0x9E, 0x98 },
	{ 0xE6, 0x9E, 0xA7 },
	{ 0xE6, 0x9D, 0xB5 },
	{ 0xE6, 0x9E, 0xA8 },
	{ 0xE6, 0x9E, 0x9E },
	{ 0xE6, 0x9E, 0xAD },
	{ 0xE6, 0x9E, 0x8B },
	{ 0xE6, 0x9D, 0xB7 },
	{ 0xE6, 0x9D, 0xBC },
	{ 0xE6, 0x9F, 0xB0 },
	{ 0xE6, 0xA0, 0x89 },
	{ 0xE6, 0x9F, 0x98 },
	{ 0xE6, 0xA0, 0x8A },
	{ 0xE6, 0x9F, 0xA9 },
	{ 0xE6, 0x9E, 0xB0 },
	{ 0xE6, 0xA0, 0x8C },
	{ 0xE6, 0x9F, 0x99 },
	{ 0xE6, 0x9E, 0xB5 },
	{ 0xE6, 0x9F, 0x9A },
	{ 0xE6, 0x9E, 0xB3 },
	{ 0xE6, 0x9F, 0x9D },
	{ 0xE6, 0xA0, 0x80 },
	{ 0xE6, 0x9F, 0x83 },
	{ 0xE6, 0x9E, 0xB8 },
	{ 0xE6, 0x9F, 0xA2 },
	{ 0xE6, 0xA0, 0x8E },
	{ 0xE6, 0x9F, 0x81 },
	{ 0xE6, 0x9F, 0xBD },
	{ 0xE6, 0xA0, 0xB2 },
	{ 0xE6, 0xA0, 0xB3 },
	{ 0xE6, 0xA1, 0xA0 },
	{ 0xE6, 0xA1, 0xA1 },
	{ 0xE6, 0xA1, 0x8E },
	{ 0xE6, 0xA1, 0xA2 },
	{ 0xE6, 0xA1, 0x84 },
	{ 0xE6, 0xA1, 0xA4 },
	{ 0xE6, 0xA2, 0x83 },
	{ 0xE6, 0xA0, 0x9D },
	{ 0xE6, 0xA1, 0x95 },
	{ 0xE6, 0xA1, 0xA6 },
	{ 0xE6, 0xA1, 0x81 },
	{ 0xE6, 0xA1, 0xA7 },
	{ 0xE6, 0xA1, 0x80 },
	{ 0xE6, 0xA0, 0xBE },
	{ 0xE6, 0xA1, 0x8A },
	{ 0xE6, 0xA1, 0x89 },
	{ 0xE6, 0xA0, 0xA9 },
	{ 0xE6, 0xA2, 0xB5 },
	{ 0xE6, 0xA2, 0x8F },
	{ 0xE6, 0xA1, 0xB4 },
	{ 0xE6, 0xA1, 0xB7 },
	{ 0xE6, 0xA2, 0x93 },
	{ 0xE6, 0xA1, 0xAB },
	{ 0xE6, 0xA3, 0x82 },
	{ 0xE6, 0xA5, 0xAE },
	{ 0xE6, 0xA3, 0xBC },
	{ 0xE6, 0xA4, 0x9F },
	{ 0xE6, 0xA4, 0xA0 },
	{ 0xE6, 0xA3, 0xB9 },
	{ 0xE6, 0xA4, 0xA4 },
	{ 0xE6, 0xA3, 0xB0 },
	{ 0xE6, 0xA4, 0x8B },
	{ 0xE6, 0xA4, 0x81 },
	{ 0xE6, 0xA5, 0x97 },
	{ 0xE6, 0xA3, 0xA3 },
	{ 0xE6, 0xA4, 0x90 },
	{ 0xE6, 0xA5, 0xB1 },
	{ 0xE6, 0xA4, 0xB9 },
	{ 0xE6, 0xA5, 0xA0 },
	{ 0xE6, 0xA5, 0x82 },
	{ 0xE6, 0xA5, 0x9D },
	{ 0xE6, 0xA6, 0x84 },
	{ 0xE6, 0xA5, 0xAB },
	{ 0xE6, 0xA6, 0x80 },
	{ 0xE6, 0xA6, 0x98 },
	{ 0xE6, 0xA5, 0xB8 },
	{ 0xE6, 0xA4, 0xB4 },
	{ 0xE6, 0xA7, 0x8C },
	{ 0xE6, 0xA6, 0x87 },
	{ 0xE6, 0xA6, 0x88 },
	{ 0xE6, 0xA7, 0x8E },
	{ 0xE6, 0xA6, 0x89 },
	{ 0xE6, 0xA5, 0xA6 },
	{ 0xE6, 0xA5, 0xA3 },
	{ 0xE6, 0xA5, 0xB9 },
	{ 0xE6, 0xA6, 0x9B },
	{ 0xE6, 0xA6, 0xA7 },
	{ 0xE6, 0xA6, 0xBB },
	{ 0xE6, 0xA6, 0xAB },
	{ 0xE6, 0xA6, 0xAD },
	{ 0xE6, 0xA7, 0x94 },
	{ 0xE6, 0xA6, 0xB1 },
	{ 0xE6, 0xA7, 0x81 },
	{ 0xE6, 0xA7, 0x8A },
	{ 0xE6, 0xA7, 0x9F },
	{ 0xE6, 0xA6, 0x95 },
	{ 0xE6, 0xA7, 0xA0 },
	{ 0xE6, 0xA6, 0x8D },
	{ 0xE6, 0xA7, 0xBF },
	{ 0xE6, 0xA8, 0xAF },
	{ 0xE6, 0xA7, 0xAD },
	{ 0xE6, 0xA8, 0x97 },
	{ 0xE6, 0xA8, 0x98 },
	{ 0xE6, 0xA9, 0xA5 },
	{ 0xE6, 0xA7, 0xB2 },
	{ 0xE6, 0xA9, 0x84 },
	{ 0xE6, 0xA8, 0xBE },
	{ 0xE6, 0xAA, 0xA0 },
	{ 0xE6, 0xA9, 0x90 },
	{ 0xE6, 0xA9, 0x9B },
	{ 0xE6, 0xA8, 0xB5 },
	{ 0xE6, 0xAA, 0x8E },
	{ 0xE6, 0xA9, 0xB9 },
	{ 0xE6, 0xA8, 0xBD },
	{ 0xE6, 0xA8, 0xA8 },
	{ 0xE6, 0xA9, 0x98 },
	{ 0xE6, 0xA9, 0xBC },
	{ 0xE6, 0xAA, 0x91 },
	{ 0xE6, 0xAA, 0x90 },
	{ 0xE6, 0xAA, 0xA9 },
	{ 0xE6, 0xAA, 0x97 },
	{ 0xE6, 0xAA, 0xAB },
	{ 0xE7, 0x8C, 0xB7 },
	{ 0xE7, 0x8D, 0x92 },
	{ 0xE6, 0xAE, 0x81 },
	{ 0xE6, 0xAE, 0x82 },
	{ 0xE6, 0xAE, 0x87 },
	{ 0xE6, 0xAE, 0x84 },
	{ 0xE6, 0xAE, 0x92 },
	{ 0xE6, 0xAE, 0x93 },
	{ 0xE6, 0xAE, 0x8D },
	{ 0xE6, 0xAE, 0x9A },
	{ 0xE6, 0xAE, 0x9B },
	{ 0xE6, 0xAE, 0xA1 },
	{ 0xE6, 0xAE, 0xAA },
	{ 0xE8, 0xBD, 0xAB },
	{ 0xE8, 0xBD, 0xAD },
	{ 0xE8, 0xBD, 0xB1 },
	{ 0xE8, 0xBD, 0xB2 },
	{ 0xE8, 0xBD, 0xB3 },
	{ 0xE8, 0xBD, 0xB5 },
	{ 0xE8, 0xBD, 0xB6 },
	{ 0xE8, 0xBD, 0xB8 },
	{ 0xE8, 0xBD, 0xB7 },
	{ 0xE8, 0xBD, 0xB9 },
	{ 0xE8, 0xBD, 0xBA },
	{ 0xE8, 0xBD, 0xBC },
	{ 0xE8, 0xBD, 0xBE },
	{ 0xE8, 0xBE, 0x81 },
	{ 0xE8, 0xBE, 0x82 },
	{ 0xE8, 0xBE, 0x84 },
	{ 0xE8, 0xBE, 0x87 },
	{ 0xE8, 0xBE, 0x8B },
	{ 0xE8, 0xBE, 0x8D },
	{ 0xE8, 0xBE, 0x8E },
	{ 0xE8, 0xBE, 0x8F },
	{ 0xE8, 0xBE, 0x98 },
	{ 0xE8, 0xBE, 0x9A },
	{ 0xE8, 0xBB, 0x8E },
	{ 0xE6, 0x88, 0x8B },
	{ 0xE6, 0x88, 0x97 },
	{ 0xE6, 0x88, 0x9B },
	{ 0xE6, 0x88, 0x9F },
	{ 0xE6, 0x88, 0xA2 },
	{ 0xE6, 0x88, 0xA1 },
	{ 0xE6, 0x88, 0xA5 },
	{ 0xE6, 0x88, 0xA4 },
	{ 0xE6, 0x88, 0xAC },
	{ 0xE8, 0x87, 0xA7 },
	{ 0xE7, 0x93, 0xAF },
	{ 0xE7, 0x93, 0xB4 },
	{ 0xE7, 0x93, 0xBF },
	{ 0xE7, 0x94, 0x8F },
	{ 0xE7, 0x94, 0x91 },
	{ 0xE7, 0x94, 0x93 },
	{ 0xE6, 0x94, 0xB4 },
	{ 0xE6, 0x97, 0xAE },
	{ 0xE6, 0x97, 0xAF },
	{ 0xE6, 0x97, 0xB0 },
	{ 0xE6, 0x98, 0x8A },
	{ 0xE6, 0x98, 0x99 },
	{ 0xE6, 0x9D, 0xB2 },
	{ 0xE6, 0x98, 0x83 },
	{ 0xE6, 0x98, 0x95 },
	{ 0xE6, 0x98, 0x80 },
	{ 0xE7, 0x82, 0x85 },
	{ 0xE6, 0x9B, 0xB7 },
	{ 0xE6, 0x98, 0x9D },
	{ 0xE6, 0x98, 0xB4 },
	{ 0xE6, 0x98, 0xB1 },
	{ 0xE6, 0x98, 0xB6 },
	{ 0xE6, 0x98, 0xB5 },
	{ 0xE8, 0x80, 0x86 },
	{ 0xE6, 0x99, 0x9F },
	{ 0xE6, 0x99, 0x94 },
	{ 0xE6, 0x99, 0x81 },
	{ 0xE6, 0x99, 0x8F },
	{ 0xE6, 0x99, 0x96 },
	{ 0xE6, 0x99, 0xA1 },
	{ 0xE6, 0x99, 0x97 },
	{ 0xE6, 0x99, 0xB7 },
	{ 0xE6, 0x9A, 0x84 },
	{ 0xE6, 0x9A, 0x8C },
	{ 0xE6, 0x9A, 0xA7 },
	{ 0xE6, 0x9A, 0x9D },
	{ 0xE6, 0x9A, 0xBE },
	{ 0xE6, 0x9B, 0x9B },
	{ 0xE6, 0x9B, 0x9C },
	{ 0xE6, 0x9B, 0xA6 },
	{ 0xE6, 0x9B, 0xA9 },
	{ 0xE8, 0xB4, 0xB2 },
	{ 0xE8, 0xB4, 0xB3 },
	{ 0xE8, 0xB4, 0xB6 },
	{ 0xE8, 0xB4, 0xBB },
	{ 0xE8, 0xB4, 0xBD },
	{ 0xE8, 0xB5, 0x80 },
	{ 0xE8, 0xB5, 0x85 },
	{ 0xE8, 0xB5, 0x86 },
	{ 0xE8, 0xB5, 0x88 },
	{ 0xE8, 0xB5, 0x89 },
	{ 0xE8, 0xB5, 0x87 },
	{ 0xE8, 0xB5, 0x8D },
	{ 0xE8, 0xB5, 0x95 },
	{ 0xE8, 0xB5, 0x99 },
	{ 0xE8, 0xA7, 0x87 },
	{ 0xE8, 0xA7, 0x8A },
	{ 0xE8, 0xA7, 0x8B },
	{ 0xE8, 0xA7, 0x8C },
	{ 0xE8, 0xA7, 0x8E },
	{ 0xE8, 0xA7, 0x8F },
	{ 0xE8, 0xA7, 0x90 },
	{ 0xE8, 0xA7, 0x91 },
	{ 0xE7, 0x89, 0xAE },
	{ 0xE7, 0x8A, 0x9F },
	{ 0xE7, 0x89, 0x9D },
	{ 0xE7, 0x89, 0xA6 },
	{ 0xE7, 0x89, 0xAF },
	{ 0xE7, 0x89, 0xBE },
	{ 0xE7, 0x89, 0xBF },
	{ 0xE7, 0x8A, 0x84 },
	{ 0xE7, 0x8A, 0x8B },
	{ 0xE7, 0x8A, 0x8D },
	{ 0xE7, 0x8A, 0x8F },
	{ 0xE7, 0x8A, 0x92 },
	{ 0xE6, 0x8C, 0x88 },
	{ 0xE6, 0x8C, 0xB2 },
	{ 0xE6, 0x8E, 0xB0 },
	{ 0xE6, 0x90, 0xBF },
	{ 0xE6, 0x93, 0x98 },
	{ 0xE8, 0x80, 0x84 },
	{ 0xE6, 0xAF, 0xAA },
	{ 0xE6, 0xAF, 0xB3 },
	{ 0xE6, 0xAF, 0xBD },
	{ 0xE6, 0xAF, 0xB5 },
	{ 0xE6, 0xAF, 0xB9 },
	{ 0xE6, 0xB0, 0x85 },
	{ 0xE6, 0xB0, 0x87 },
	{ 0xE6, 0xB0, 0x86 },
	{ 0xE6, 0xB0, 0x8D },
	{ 0xE6, 0xB0, 0x95 },
	{ 0xE6, 0xB0, 0x98 },
	{ 0xE6, 0xB0, 0x99 },
	{ 0xE6, 0xB0, 0x9A },
	{ 0xE6, 0xB0, 0xA1 },
	{ 0xE6, 0xB0, 0xA9 },
	{ 0xE6, 0xB0, 0xA4 },
	{ 0xE6, 0xB0, 0xAA },
	{ 0xE6, 0xB0, 0xB2 },
	{ 0xE6, 0x94, 0xB5 },
	{ 0xE6, 0x95, 0x95 },
	{ 0xE6, 0x95, 0xAB },
	{ 0xE7, 0x89, 0x8D },
	{ 0xE7, 0x89, 0x92 },
	{ 0xE7, 0x89, 0x96 },
	{ 0xE7, 0x88, 0xB0 },
	{ 0xE8, 0x99, 0xA2 },
	{ 0xE5, 0x88, 0x96 },
	{ 0xE8, 0x82, 0x9F },
	{ 0xE8, 0x82, 0x9C },
	{ 0xE8, 0x82, 0x93 },
	{ 0xE8, 0x82, 0xBC },
	{ 0xE6, 0x9C, 0x8A },
	{ 0xE8, 0x82, 0xBD },
	{ 0xE8, 0x82, 0xB1 },
	{ 0xE8, 0x82, 0xAB },
	{ 0xE8, 0x82, 0xAD },
	{ 0xE8, 0x82, 0xB4 },
	{ 0xE8, 0x82, 0xB7 },
	{ 0xE8, 0x83, 0xA7 },
	{ 0xE8, 0x83, 0xA8 },
	{ 0xE8, 0x83, 0xA9 },
	{ 0xE8, 0x83, 0xAA },
	{ 0xE8, 0x83, 0x9B },
	{ 0xE8, 0x83, 0x82 },
	{ 0xE8, 0x83, 0x84 },
	{ 0xE8, 0x83, 0x99 },
	{ 0xE8, 0x83, 0x8D },
	{ 0xE8, 0x83, 0x97 },
	{ 0xE6, 0x9C, 0x90 },
	{ 0xE8, 0x83, 0x9D },
	{ 0xE8, 0x83, 0xAB },
	{ 0xE8, 0x83, 0xB1 },
	{ 0xE8, 0x83, 0xB4 },
	{ 0xE8, 0x83, 0xAD },
	{ 0xE8, 0x84, 0x8D },
	{ 0xE8, 0x84, 0x8E },
	{ 0xE8, 0x83, 0xB2 },
	{ 0xE8, 0x83, 0xBC },
	{ 0xE6, 0x9C, 0x95 },
	{ 0xE8, 0x84, 0x92 },
	{ 0xE8, 0xB1, 0x9A },
	{ 0xE8, 0x84, 0xB6 },
	{ 0xE8, 0x84, 0x9E },
	{ 0xE8, 0x84, 0xAC },
	{ 0xE8, 0x84, 0x98 },
	{ 0xE8, 0x84, 0xB2 },
	{ 0xE8, 0x85, 0x88 },
	{ 0xE8, 0x85, 0x8C },
	{ 0xE8, 0x85, 0x93 },
	{ 0xE8, 0x85, 0xB4 },
	{ 0xE8, 0x85, 0x99 },
	{ 0xE8, 0x85, 0x9A },
	{ 0xE8, 0x85, 0xB1 },
	{ 0xE8, 0x85, 0xA0 },
	{ 0xE8, 0x85, 0xA9 },
	{ 0xE8, 0x85, 0xBC },
	{ 0xE8, 0x85, 0xBD },
	{ 0xE8, 0x85, 0xAD },
	{ 0xE8, 0x85, 0xA7 },
	{ 0xE5, 0xA1, 0x8D },
	{ 0xE5, 0xAA, 0xB5 },
	{ 0xE8, 0x86, 0x88 },
	{ 0xE8, 0x86, 0x82 },
	{ 0xE8, 0x86, 0x91 },
	{ 0xE6, 0xBB, 0x95 },
	{ 0xE8, 0x86, 0xA3 },
	{ 0xE8, 0x86, 0xAA },
	{ 0xE8, 0x87, 0x8C },
	{ 0xE6, 0x9C, 0xA6 },
	{ 0xE8, 0x87, 0x8A },
	{ 0xE8, 0x86, 0xBB },
	{ 0xE8, 0x87, 0x81 },
	{ 0xE8, 0x86, 0xA6 },
	{ 0xE6, 0xAC, 0xA4 },
	{ 0xE6, 0xAC, 0xB7 },
	{ 0xE6, 0xAC, 0xB9 },
	{ 0xE6, 0xAD, 0x83 },
	{ 0xE6, 0xAD, 0x86 },
	{ 0xE6, 0xAD, 0x99 },
	{ 0xE9, 0xA3, 0x91 },
	{ 0xE9, 0xA3, 0x92 },
	{ 0xE9, 0xA3, 0x93 },
	{ 0xE9, 0xA3, 0x95 },
	{ 0xE9, 0xA3, 0x99 },
	{ 0xE9, 0xA3, 0x9A },
	{ 0xE6, 0xAE, 0xB3 },
	{ 0xE5, 0xBD, 0x80 },
	{ 0xE6, 0xAF, 0x82 },
	{ 0xE8, 0xA7, 0xB3 },
	{ 0xE6, 0x96, 0x90 },
	{ 0xE9, 0xBD, 0x91 },
	{ 0xE6, 0x96, 0x93 },
	{ 0xE6, 0x96, 0xBC },
	{ 0xE6, 0x97, 0x86 },
	{ 0xE6, 0x97, 0x84 },
	{ 0xE6, 0x97, 0x83 },
	{ 0xE6, 0x97, 0x8C },
	{ 0xE6, 0x97, 0x8E },
	{ 0xE6, 0x97, 0x92 },
	{ 0xE6, 0x97, 0x96 },
	{ 0xE7, 0x82, 0x80 },
	{ 0xE7, 0x82, 0x9C },
	{ 0xE7, 0x82, 0x96 },
	{ 0xE7, 0x82, 0x9D },
	{ 0xE7, 0x82, 0xBB },
	{ 0xE7, 0x83, 0x80 },
	{ 0xE7, 0x82, 0xB7 },
	{ 0xE7, 0x82, 0xAB },
	{ 0xE7, 0x82, 0xB1 },
	{ 0xE7, 0x83, 0xA8 },
	{ 0xE7, 0x83, 0x8A },
	{ 0xE7, 0x84, 0x90 },
	{ 0xE7, 0x84, 0x93 },
	{ 0xE7, 0x84, 0x96 },
	{ 0xE7, 0x84, 0xAF },
	{ 0xE7, 0x84, 0xB1 },
	{ 0xE7, 0x85, 0xB3 },
	{ 0xE7, 0x85, 0x9C },
	{ 0xE7, 0x85, 0xA8 },
	{ 0xE7, 0x85, 0x85 },
	{ 0xE7, 0x85, 0xB2 },
	{ 0xE7, 0x85, 0x8A },
	{ 0xE7, 0x85, 0xB8 },
	{ 0xE7, 0x85, 0xBA },
	{ 0xE7, 0x86, 0x98 },
	{ 0xE7, 0x86, 0xB3 },
	{ 0xE7, 0x86, 0xB5 },
	{ 0xE7, 0x86, 0xA8 },
	{ 0xE7, 0x86, 0xA0 },
	{ 0xE7, 0x87, 0xA0 },
	{ 0xE7, 0x87, 0x94 },
	{ 0xE7, 0x87, 0xA7 },
	{ 0xE7, 0x87, 0xB9 },
	{ 0xE7, 0x88, 0x9D },
	{ 0xE7, 0x88, 0xA8 },
	{ 0xE7, 0x81, 0xAC },
	{ 0xE7, 0x84, 0x98 },
	{ 0xE7, 0x85, 0xA6 },
	{ 0xE7, 0x86, 0xB9 },
	{ 0xE6, 0x88, 0xBE },
	{ 0xE6, 0x88, 0xBD },
	{ 0xE6, 0x89, 0x83 },
	{ 0xE6, 0x89, 0x88 },
	{ 0xE6, 0x89, 0x89 },
	{ 0xE7, 0xA4, 0xBB },
	{ 0xE7, 0xA5, 0x80 },
	{ 0xE7, 0xA5, 0x86 },
	{ 0xE7, 0xA5, 0x89 },
	{ 0xE7, 0xA5, 0x9B },
	{ 0xE7, 0xA5, 0x9C },
	{ 0xE7, 0xA5, 0x93 },
	{ 0xE7, 0xA5, 0x9A },
	{ 0xE7, 0xA5, 0xA2 },
	{ 0xE7, 0xA5, 0x97 },
	{ 0xE7, 0xA5, 0xA0 },
	{ 0xE7, 0xA5, 0xAF },
	{ 0xE7, 0xA5, 0xA7 },
	{ 0xE7, 0xA5, 0xBA },
	{ 0xE7, 0xA6, 0x85 },
	{ 0xE7, 0xA6, 0x8A },
	{ 0xE7, 0xA6, 0x9A },
	{ 0xE7, 0xA6, 0xA7 },
	{ 0xE7, 0xA6, 0xB3 },
	{ 0xE5, 0xBF, 0x91 },
	{ 0xE5, 0xBF, 0x90 },
	{ 0xE6, 0x80, 0xBC },
	{ 0xE6, 0x81, 0x9D },
	{ 0xE6, 0x81, 0x9A },
	{ 0xE6, 0x81, 0xA7 },
	{ 0xE6, 0x81, 0x81 },
	{ 0xE6, 0x81, 0x99 },
	{ 0xE6, 0x81, 0xA3 },
	{ 0xE6, 0x82, 0xAB },
	{ 0xE6, 0x84, 0x86 },
	{ 0xE6, 0x84, 0x8D },
	{ 0xE6, 0x85, 0x9D },
	{ 0xE6, 0x86, 0xA9 },
	{ 0xE6, 0x86, 0x9D },
	{ 0xE6, 0x87, 0x8B },
	{ 0xE6, 0x87, 0x91 },
	{ 0xE6, 0x88, 0x86 },
	{ 0xE8, 0x82, 0x80 },
	{ 0xE8, 0x81, 0xBF },
	{ 0xE6, 0xB2, 0x93 },
	{ 0xE6, 0xB3, 0xB6 },
	{ 0xE6, 0xB7, 0xBC },
	{ 0xE7, 0x9F, 0xB6 },
	{ 0xE7, 0x9F, 0xB8 },
	{ 0xE7, 0xA0, 0x80 },
	{ 0xE7, 0xA0, 0x89 },
	{ 0xE7, 0xA0, 0x97 },
	{ 0xE7, 0xA0, 0x98 },
	{ 0xE7, 0xA0, 0x91 },
	{ 0xE6, 0x96, 0xAB },
	{ 0xE7, 0xA0, 0xAD },
	{ 0xE7, 0xA0, 0x9C },
	{ 0xE7, 0xA0, 0x9D },
	{ 0xE7, 0xA0, 0xB9 },
	{ 0xE7, 0xA0, 0xBA },
	{ 0xE7, 0xA0, 0xBB },
	{ 0xE7, 0xA0, 0x9F },
	{ 0xE7, 0xA0, 0xBC },
	{ 0xE7, 0xA0, 0xA5 },
	{ 0xE7, 0xA0, 0xAC },
	{ 0xE7, 0xA0, 0xA3 },
	{ 0xE7, 0xA0, 0xA9 },
	{ 0xE7, 0xA1, 0x8E },
	{ 0xE7, 0xA1, 0xAD },
	{ 0xE7, 0xA1, 0x96 },
	{ 0xE7, 0xA1, 0x97 },
	{ 0xE7, 0xA0, 0xA6 },
	{ 0xE7, 0xA1, 0x90 },
	{ 0xE7, 0xA1, 0x87 },
	{ 0xE7, 0xA1, 0x8C },
	{ 0xE7, 0xA1, 0xAA },
	{ 0xE7, 0xA2, 0x9B },
	{ 0xE7, 0xA2, 0x93 },
	{ 0xE7, 0xA2, 0x9A },
	{ 0xE7, 0xA2, 0x87 },
	{ 0xE7, 0xA2, 0x9C },
	{ 0xE7, 0xA2, 0xA1 },
	{ 0xE7, 0xA2, 0xA3 },
	{ 0xE7, 0xA2, 0xB2 },
	{ 0xE7, 0xA2, 0xB9 },
	{ 0xE7, 0xA2, 0xA5 },
	{ 0xE7, 0xA3, 0x94 },
	{ 0xE7, 0xA3, 0x99 },
	{ 0xE7, 0xA3, 0x89 },
	{ 0xE7, 0xA3, 0xAC },
	{ 0xE7, 0xA3, 0xB2 },
	{ 0xE7, 0xA4, 0x85 },
	{ 0xE7, 0xA3, 0xB4 },
	{ 0xE7, 0xA4, 0x93 },
	{ 0xE7, 0xA4, 0xA4 },
	{ 0xE7, 0xA4, 0x9E },
	{ 0xE7, 0xA4, 0xB4 },
	{ 0xE9, 0xBE, 0x9B },
	{ 0xE9, 0xBB, 0xB9 },
	{ 0xE9, 0xBB, 0xBB },
	{ 0xE9, 0xBB, 0xBC },
	{ 0xE7, 0x9B, 0xB1 },
	{ 0xE7, 0x9C, 0x84 },
	{ 0xE7, 0x9C, 0x8D },
	{ 0xE7, 0x9B, 0xB9 },
	{ 0xE7, 0x9C, 0x87 },
	{ 0xE7, 0x9C, 0x88 },
	{ 0xE7, 0x9C, 0x9A },
	{ 0xE7, 0x9C, 0xA2 },
	{ 0xE7, 0x9C, 0x99 },
	{ 0xE7, 0x9C, 0xAD },
	{ 0xE7, 0x9C, 0xA6 },
	{ 0xE7, 0x9C, 0xB5 },
	{ 0xE7, 0x9C, 0xB8 },
	{ 0xE7, 0x9D, 0x90 },
	{ 0xE7, 0x9D, 0x91 },
	{ 0xE7, 0x9D, 0x87 },
	{ 0xE7, 0x9D, 0x83 },
	{ 0xE7, 0x9D, 0x9A },
	{ 0xE7, 0x9D, 0xA8 },
	{ 0xE7, 0x9D, 0xA2 },
	{ 0xE7, 0x9D, 0xA5 },
	{ 0xE7, 0x9D, 0xBF },
	{ 0xE7, 0x9E, 0x8D },
	{ 0xE7, 0x9D, 0xBD },
	{ 0xE7, 0x9E, 0x80 },
	{ 0xE7, 0x9E, 0x8C },
	{ 0xE7, 0x9E, 0x91 },
	{ 0xE7, 0x9E, 0x9F },
	{ 0xE7, 0x9E, 0xA0 },
	{ 0xE7, 0x9E, 0xB0 },
	{ 0xE7, 0x9E, 0xB5 },
	{ 0xE7, 0x9E, 0xBD },
	{ 0xE7, 0x94, 0xBA },
	{ 0xE7, 0x95, 0x80 },
	{ 0xE7, 0x95, 0x8E },
	{ 0xE7, 0x95, 0x8B },
	{ 0xE7, 0x95, 0x88 },
	{ 0xE7, 0x95, 0x9B },
	{ 0xE7, 0x95, 0xB2 },
	{ 0xE7, 0x95, 0xB9 },
	{ 0xE7, 0x96, 0x83 },
	{ 0xE7, 0xBD, 0x98 },
	{ 0xE7, 0xBD, 0xA1 },
	{ 0xE7, 0xBD, 0x9F },
	{ 0xE8, 0xA9, 0x88 },
	{ 0xE7, 0xBD, 0xA8 },
	{ 0xE7, 0xBD, 0xB4 },
	{ 0xE7, 0xBD, 0xB1 },
	{ 0xE7, 0xBD, 0xB9 },
	{ 0xE7, 0xBE, 0x81 },
	{ 0xE7, 0xBD, 0xBE },
	{ 0xE7, 0x9B, 0x8D },
	{ 0xE7, 0x9B, 0xA5 },
	{ 0xE8, 0xA0, 0xB2 },
	{ 0xE9, 0x92, 0x85 },
	{ 0xE9, 0x92, 0x86 },
	{ 0xE9, 0x92, 0x87 },
	{ 0xE9, 0x92, 0x8B },
	{ 0xE9, 0x92, 0x8A },
	{ 0xE9, 0x92, 0x8C },
	{ 0xE9, 0x92, 0x8D },
	{ 0xE9, 0x92, 0x8F },
	{ 0xE9, 0x92, 0x90 },
	{ 0xE9, 0x92, 0x94 },
	{ 0xE9, 0x92, 0x97 },
	{ 0xE9, 0x92, 0x95 },
	{ 0xE9, 0x92, 0x9A },
	{ 0xE9, 0x92, 0x9B },
	{ 0xE9, 0x92, 0x9C },
	{ 0xE9, 0x92, 0xA3 },
	{ 0xE9, 0x92, 0xA4 },
	{ 0xE9, 0x92, 0xAB },
	{ 0xE9, 0x92, 0xAA },
	{ 0xE9, 0x92, 0xAD },
	{ 0xE9, 0x92, 0xAC },
	{ 0xE9, 0x92, 0xAF },
	{ 0xE9, 0x92, 0xB0 },
	{ 0xE9, 0x92, 0xB2 },
	{ 0xE9, 0x92, 0xB4 },
	{ 0xE9, 0x92, 0xB6 },
	{ 0xE9, 0x92, 0xB7 },
	{ 0xE9, 0x92, 0xB8 },
	{ 0xE9, 0x92, 0xB9 },
	{ 0xE9, 0x92, 0xBA },
	{ 0xE9, 0x92, 0xBC },
	{ 0xE9, 0x92, 0xBD },
	{ 0xE9, 0x92, 0xBF },
	{ 0xE9, 0x93, 0x84 },
	{ 0xE9, 0x93, 0x88 },
	{ 0xE9, 0x93, 0x89 },
	{ 0xE9, 0x93, 0x8A },
	{ 0xE9, 0x93, 0x8B },
	{ 0xE9, 0x93, 0x8C },
	{ 0xE9, 0x93, 0x8D },
	{ 0xE9, 0x93, 0x8E },
	{ 0xE9, 0x93, 0x90 },
	{ 0xE9, 0x93, 0x91 },
	{ 0xE9, 0x93, 0x92 },
	{ 0xE9, 0x93, 0x95 },
	{ 0xE9, 0x93, 0x96 },
	{ 0xE9, 0x93, 0x97 },
	{ 0xE9, 0x93, 0x99 },
	{ 0xE9, 0x93, 0x98 },
	{ 0xE9, 0x93, 0x9B },
	{ 0xE9, 0x93, 0x9E },
	{ 0xE9, 0x93, 0x9F },
	{ 0xE9, 0x93, 0xA0 },
	{ 0xE9, 0x93, 0xA2 },
	{ 0xE9, 0x93, 0xA4 },
	{ 0xE9, 0x93, 0xA5 },
	{ 0xE9, 0x93, 0xA7 },
	{ 0xE9, 0x93, 0xA8 },
	{ 0xE9, 0x93, 0xAA },
	{ 0xE9, 0x93, 0xA9 },
	{ 0xE9, 0x93, 0xAB },
	{ 0xE9, 0x93, 0xAE },
	{ 0xE9, 0x93, 0xAF },
	{ 0xE9, 0x93, 0xB3 },
	{ 0xE9, 0x93, 0xB4 },
	{ 0xE9, 0x93, 0xB5 },
	{ 0xE9, 0x93, 0xB7 },
	{ 0xE9, 0x93, 0xB9 },
	{ 0xE9, 0x93, 0xBC },
	{ 0xE9, 0x93, 0xBD },
	{ 0xE9, 0x93, 0xBF },
	{ 0xE9, 0x94, 0x83 },
	{ 0xE9, 0x94, 0x82 },
	{ 0xE9, 0x94, 0x86 },
	{ 0xE9, 0x94, 0x87 },
	{ 0xE9, 0x94, 0x89 },
	{ 0xE9, 0x94, 0x8A },
	{ 0xE9, 0x94, 0x8D },
	{ 0xE9, 0x94, 0x8E },
	{ 0xE9, 0x94, 0x8F },
	{ 0xE9, 0x94, 0x92 },
	{ 0xE9, 0x94, 0x93 },
	{ 0xE9, 0x94, 0x94 },
	{ 0xE9, 0x94, 0x95 },
	{ 0xE9, 0x94, 0x96 },
	{ 0xE9, 0x94, 0x98 },
	{ 0xE9, 0x94, 0x9B },
	{ 0xE9, 0x94, 0x9D },
	{ 0xE9, 0x94, 0x9E },
	{ 0xE9, 0x94, 0x9F },
	{ 0xE9, 0x94, 0xA2 },
	{ 0xE9, 0x94, 0xAA },
	{ 0xE9, 0x94, 0xAB },
	{ 0xE9, 0x94, 0xA9 },
	{ 0xE9, 0x94, 0xAC },
	{ 0xE9, 0x94, 0xB1 },
	{ 0xE9, 0x94, 0xB2 },
	{ 0xE9, 0x94, 0xB4 },
	{ 0xE9, 0x94, 0xB6 },
	{ 0xE9, 0x94, 0xB7 },
	{ 0xE9, 0x94, 0xB8 },
	{ 0xE9, 0x94, 0xBC },
	{ 0xE9, 0x94, 0xBE },
	{ 0xE9, 0x94, 0xBF },
	{ 0xE9, 0x95, 0x82 },
	{ 0xE9, 0x94, 0xB5 },
	{ 0xE9, 0x95, 0x84 },
	{ 0xE9, 0x95, 0x85 },
	{ 0xE9, 0x95, 0x86 },
	{ 0xE9, 0x95, 0x89 },
	{ 0xE9, 0x95, 0x8C },
	{ 0xE9, 0x95, 0x8E },
	{ 0xE9, 0x95, 0x8F },
	{ 0xE9, 0x95, 0x92 },
	{ 0xE9, 0x95, 0x93 },
	{ 0xE9, 0x95, 0x94 },
	{ 0xE9, 0x95, 0x96 },
	{ 0xE9, 0x95, 0x97 },
	{ 0xE9, 0x95, 0x98 },
	{ 0xE9, 0x95, 0x99 },
	{ 0xE9, 0x95, 0x9B },
	{ 0xE9, 0x95, 0x9E },
	{ 0xE9, 0x95, 0x9F },
	{ 0xE9, 0x95, 0x9D },
	{ 0xE9, 0x95, 0xA1 },
	{ 0xE9, 0x95, 0xA2 },
	{ 0xE9, 0x95, 0xA4 },
	{ 0xE9, 0x95, 0xA5 },
	{ 0xE9, 0x95, 0xA6 },
	{ 0xE9, 0x95, 0xA7 },
	{ 0xE9, 0x95, 0xA8 },
	{ 0xE9, 0x95, 0xA9 },
	{ 0xE9, 0x95, 0xAA },
	{ 0xE9, 0x95, 0xAB },
	{ 0xE9, 0x95, 0xAC },
	{ 0xE9, 0x95, 0xAF },
	{ 0xE9, 0x95, 0xB1 },
	{ 0xE9, 0x95, 0xB2 },
	{ 0xE9, 0x95, 0xB3 },
	{ 0xE9, 0x94, 0xBA },
	{ 0xE7, 0x9F, 0xA7 },
	{ 0xE7, 0x9F, 0xAC },
	{ 0xE9, 0x9B, 0x89 },
	{ 0xE7, 0xA7, 0x95 },
	{ 0xE7, 0xA7, 0xAD },
	{ 0xE7, 0xA7, 0xA3 },
	{ 0xE7, 0xA7, 0xAB },
	{ 0xE7, 0xA8, 0x86 },
	{ 0xE5, 0xB5, 0x87 },
	{ 0xE7, 0xA8, 0x83 },
	{ 0xE7, 0xA8, 0x82 },
	{ 0xE7, 0xA8, 0x9E },
	{ 0xE7, 0xA8, 0x94 },
	{ 0xE7, 0xA8, 0xB9 },
	{ 0xE7, 0xA8, 0xB7 },
	{ 0xE7, 0xA9, 0x91 },
	{ 0xE9, 0xBB, 0x8F },
	{ 0xE9, 0xA6, 0xA5 },
	{ 0xE7, 0xA9, 0xB0 },
	{ 0xE7, 0x9A, 0x88 },
	{ 0xE7, 0x9A, 0x8E },
	{ 0xE7, 0x9A, 0x93 },
	{ 0xE7, 0x9A, 0x99 },
	{ 0xE7, 0x9A, 0xA4 },
	{ 0xE7, 0x93, 0x9E },
	{ 0xE7, 0x93, 0xA0 },
	{ 0xE7, 0x94, 0xAC },
	{ 0xE9, 0xB8, 0xA0 },
	{ 0xE9, 0xB8, 0xA2 },
	{ 0xE9, 0xB8, 0xA8 },
	{ 0xE9, 0xB8, 0xA9 },
	{ 0xE9, 0xB8, 0xAA },
	{ 0xE9, 0xB8, 0xAB },
	{ 0xE9, 0xB8, 0xAC },
	{ 0xE9, 0xB8, 0xB2 },
	{ 0xE9, 0xB8, 0xB1 },
	{ 0xE9, 0xB8, 0xB6 },
	{ 0xE9, 0xB8, 0xB8 },
	{ 0xE9, 0xB8, 0xB7 },
	{ 0xE9, 0xB8, 0xB9 },
	{ 0xE9, 0xB8, 0xBA },
	{ 0xE9, 0xB8, 0xBE },
	{ 0xE9, 0xB9, 0x81 },
	{ 0xE9, 0xB9, 0x82 },
	{ 0xE9, 0xB9, 0x84 },
	{ 0xE9, 0xB9, 0x86 },
	{ 0xE9, 0xB9, 0x87 },
	{ 0xE9, 0xB9, 0x88 },
	{ 0xE9, 0xB9, 0x89 },
	{ 0xE9, 0xB9, 0x8B },
	{ 0xE9, 0xB9, 0x8C },
	{ 0xE9, 0xB9, 0x8E },
	{ 0xE9, 0xB9, 0x91 },
	{ 0xE9, 0xB9, 0x95 },
	{ 0xE9, 0xB9, 0x97 },
	{ 0xE9, 0xB9, 0x9A },
	{ 0xE9, 0xB9, 0x9B },
	{ 0xE9, 0xB9, 0x9C },
	{ 0xE9, 0xB9, 0x9E },
	{ 0xE9, 0xB9, 0xA3 },
	{ 0xE9, 0xB9, 0xA6 },
	{ 0xE9, 0xB9, 0xA7 },
	{ 0xE9, 0xB9, 0xA8 },
	{ 0xE9, 0xB9, 0xA9 },
	{ 0xE9, 0xB9, 0xAA },
	{ 0xE9, 0xB9, 0xAB },
	{ 0xE9, 0xB9, 0xAC },
	{ 0xE9, 0xB9, 0xB1 },
	{ 0xE9, 0xB9, 0xAD },
	{ 0xE9, 0xB9, 0xB3 },
	{ 0xE7, 0x96, 0x92 },
	{ 0xE7, 0x96, 0x94 },
	{ 0xE7, 0x96, 0x96 },
	{ 0xE7, 0x96, 0xA0 },
	{ 0xE7, 0x96, 0x9D },
	{ 0xE7, 0x96, 0xAC },
	{ 0xE7, 0x96, 0xA3 },
	{ 0xE7, 0x96, 0xB3 },
	{ 0xE7, 0x96, 0xB4 },
	{ 0xE7, 0x96, 0xB8 },
	{ 0xE7, 0x97, 0x84 },
	{ 0xE7, 0x96, 0xB1 },
	{ 0xE7, 0x96, 0xB0 },
	{ 0xE7, 0x97, 0x83 },
	{ 0xE7, 0x97, 0x82 },
	{ 0xE7, 0x97, 0x96 },
	{ 0xE7, 0x97, 0x8D },
	{ 0xE7, 0x97, 0xA3 },
	{ 0xE7, 0x97, 0xA8 },
	{ 0xE7, 0x97, 0xA6 },
	{ 0xE7, 0x97, 0xA4 },
	{ 0xE7, 0x97, 0xAB },
	{ 0xE7, 0x97, 0xA7 },
	{ 0xE7, 0x98, 0x83 },
	{ 0xE7, 0x97, 0xB1 },
	{ 0xE7, 0x97, 0xBC },
	{ 0xE7, 0x97, 0xBF },
	{ 0xE7, 0x98, 0x90 },
	{ 0xE7, 0x98, 0x80 },
	{ 0xE7, 0x98, 0x85 },
	{ 0xE7, 0x98, 0x8C },
	{ 0xE7, 0x98, 0x97 },
	{ 0xE7, 0x98, 0x8A },
	{ 0xE7, 0x98, 0xA5 },
	{ 0xE7, 0x98, 0x98 },
	{ 0xE7, 0x98, 0x95 },
	{ 0xE7, 0x98, 0x99 },
	{ 0xE7, 0x98, 0x9B },
	{ 0xE7, 0x98, 0xBC },
	{ 0xE7, 0x98, 0xA2 },
	{ 0xE7, 0x98, 0xA0 },
	{ 0xE7, 0x99, 0x80 },
	{ 0xE7, 0x98, 0xAD },
	{ 0xE7, 0x98, 0xB0 },
	{ 0xE7, 0x98, 0xBF },
	{ 0xE7, 0x98, 0xB5 },
	{ 0xE7, 0x99, 0x83 },
	{ 0xE7, 0x98, 0xBE },
	{ 0xE7, 0x98, 0xB3 },
	{ 0xE7, 0x99, 0x8D },
	{ 0xE7, 0x99, 0x9E },
	{ 0xE7, 0x99, 0x94 },
	{ 0xE7, 0x99, 0x9C },
	{ 0xE7, 0x99, 0x96 },
	{ 0xE7, 0x99, 0xAB },
	{ 0xE7, 0x99, 0xAF },
	{ 0xE7, 0xBF, 0x8A },
	{ 0xE7, 0xAB, 0xA6 },
	{ 0xE7, 0xA9, 0xB8 },
	{ 0xE7, 0xA9, 0xB9 },
	{ 0xE7, 0xAA, 0x80 },
	{ 0xE7, 0xAA, 0x86 },
	{ 0xE7, 0xAA, 0x88 },
	{ 0xE7, 0xAA, 0x95 },
	{ 0xE7, 0xAA, 0xA6 },
	{ 0xE7, 0xAA, 0xA0 },
	{ 0xE7, 0xAA, 0xAC },
	{ 0xE7, 0xAA, 0xA8 },
	{ 0xE7, 0xAA, 0xAD },
	{ 0xE7, 0xAA, 0xB3 },
	{ 0xE8, 0xA1, 0xA4 },
	{ 0xE8, 0xA1, 0xA9 },
	{ 0xE8, 0xA1, 0xB2 },
	{ 0xE8, 0xA1, 0xBD },
	{ 0xE8, 0xA1, 0xBF },
	{ 0xE8, 0xA2, 0x82 },
	{ 0xE8, 0xA2, 0xA2 },
	{ 0xE8, 0xA3, 0x86 },
	{ 0xE8, 0xA2, 0xB7 },
	{ 0xE8, 0xA2, 0xBC },
	{ 0xE8, 0xA3, 0x89 },
	{ 0xE8, 0xA3, 0xA2 },
	{ 0xE8, 0xA3, 0x8E },
	{ 0xE8, 0xA3, 0xA3 },
	{ 0xE8, 0xA3, 0xA5 },
	{ 0xE8, 0xA3, 0xB1 },
	{ 0xE8, 0xA4, 0x9A },
	{ 0xE8, 0xA3, 0xBC },
	{ 0xE8, 0xA3, 0xA8 },
	{ 0xE8, 0xA3, 0xBE },
	{ 0xE8, 0xA3, 0xB0 },
	{ 0xE8, 0xA4, 0xA1 },
	{ 0xE8, 0xA4, 0x99 },
	{ 0xE8, 0xA4, 0x93 },
	{ 0xE8, 0xA4, 0x9B },
	{ 0xE8, 0xA4, 0x8A },
	{ 0xE8, 0xA4, 0xB4 },
	{ 0xE8, 0xA4, 0xAB },
	{ 0xE8, 0xA4, 0xB6 },
	{ 0xE8, 0xA5, 0x81 },
	{ 0xE8, 0xA5, 0xA6 },
	{ 0xE8, 0xA5, 0xBB },
	{ 0xE7, 0x96, 0x8B },
	{ 0xE8, 0x83, 0xA5 },
	{ 0xE7, 0x9A, 0xB2 },
	{ 0xE7, 0x9A, 0xB4 },
	{ 0xE7, 0x9F, 0x9C },
	{ 0xE8, 0x80, 0x92 },
	{ 0xE8, 0x80, 0x94 },
	{ 0xE8, 0x80, 0x96 },
	{ 0xE8, 0x80, 0x9C },
	{ 0xE8, 0x80, 0xA0 },
	{ 0xE8, 0x80, 0xA2 },
	{ 0xE8, 0x80, 0xA5 },
	{ 0xE8, 0x80, 0xA6 },
	{ 0xE8, 0x80, 0xA7 },
	{ 0xE8, 0x80, 0xA9 },
	{ 0xE8, 0x80, 0xA8 },
	{ 0xE8, 0x80, 0xB1 },
	{ 0xE8, 0x80, 0x8B },
	{ 0xE8, 0x80, 0xB5 },
	{ 0xE8, 0x81, 0x83 },
	{ 0xE8, 0x81, 0x86 },
	{ 0xE8, 0x81, 0x8D },
	{ 0xE8, 0x81, 0x92 },
	{ 0xE8, 0x81, 0xA9 },
	{ 0xE8, 0x81, 0xB1 },
	{ 0xE8, 0xA6, 0x83 },
	{ 0xE9, 0xA1, 0xB8 },
	{ 0xE9, 0xA2, 0x80 },
	{ 0xE9, 0xA2, 0x83 },
	{ 0xE9, 0xA2, 0x89 },
	{ 0xE9, 0xA2, 0x8C },
	{ 0xE9, 0xA2, 0x8D },
	{ 0xE9, 0xA2, 0x8F },
	{ 0xE9, 0xA2, 0x94 },
	{ 0xE9, 0xA2, 0x9A },
	{ 0xE9, 0xA2, 0x9B },
	{ 0xE9, 0xA2, 0x9E },
	{ 0xE9, 0xA2, 0x9F },
	{ 0xE9, 0xA2, 0xA1 },
	{ 0xE9, 0xA2, 0xA2 },
	{ 0xE9, 0xA2, 0xA5 },
	{ 0xE9, 0xA2, 0xA6 },
	{ 0xE8, 0x99, 0x8D },
	{ 0xE8, 0x99, 0x94 },
	{ 0xE8, 0x99, 0xAC },
	{ 0xE8, 0x99, 0xAE },
	{ 0xE8, 0x99, 0xBF },
	{ 0xE8, 0x99, 0xBA },
	{ 0xE8, 0x99, 0xBC },
	{ 0xE8, 0x99, 0xBB },
	{ 0xE8, 0x9A, 0xA8 },
	{ 0xE8, 0x9A, 0x8D },
	{ 0xE8, 0x9A, 0x8B },
	{ 0xE8, 0x9A, 0xAC },
	{ 0xE8, 0x9A, 0x9D },
	{ 0xE8, 0x9A, 0xA7 },
	{ 0xE8, 0x9A, 0xA3 },
	{ 0xE8, 0x9A, 0xAA },
	{ 0xE8, 0x9A, 0x93 },
	{ 0xE8, 0x9A, 0xA9 },
	{ 0xE8, 0x9A, 0xB6 },
	{ 0xE8, 0x9B, 0x84 },
	{ 0xE8, 0x9A, 0xB5 },
	{ 0xE8, 0x9B, 0x8E },
	{ 0xE8, 0x9A, 0xB0 },
	{ 0xE8, 0x9A, 0xBA },
	{ 0xE8, 0x9A, 0xB1 },
	{ 0xE8, 0x9A, 0xAF },
	{ 0xE8, 0x9B, 0x89 },
	{ 0xE8, 0x9B, 0x8F },
	{ 0xE8, 0x9A, 0xB4 },
	{ 0xE8, 0x9B, 0xA9 },
	{ 0xE8, 0x9B, 0xB1 },
	{ 0xE8, 0x9B, 0xB2 },
	{ 0xE8, 0x9B, 0xAD },
	{ 0xE8, 0x9B, 0xB3 },
	{ 0xE8, 0x9B, 0x90 },
	{ 0xE8, 0x9C, 0x93 },
	{ 0xE8, 0x9B, 0x9E },
	{ 0xE8, 0x9B, 0xB4 },
	{ 0xE8, 0x9B, 0x9F },
	{ 0xE8, 0x9B, 0x98 },
	{ 0xE8, 0x9B, 0x91 },
	{ 0xE8, 0x9C, 0x83 },
	{ 0xE8, 0x9C, 0x87 },
	{ 0xE8, 0x9B, 0xB8 },
	{ 0xE8, 0x9C, 0x88 },
	{ 0xE8, 0x9C, 0x8A },
	{ 0xE8, 0x9C, 0x8D },
	{ 0xE8, 0x9C, 0x89 },
	{ 0xE8, 0x9C, 0xA3 },
	{ 0xE8, 0x9C, 0xBB },
	{ 0xE8, 0x9C, 0x9E },
	{ 0xE8, 0x9C, 0xA5 },
	{ 0xE8, 0x9C, 0xAE },
	{ 0xE8, 0x9C, 0x9A },
	{ 0xE8, 0x9C, 0xBE },
	{ 0xE8, 0x9D, 0x88 },
	{ 0xE8, 0x9C, 0xB4 },
	{ 0xE8, 0x9C, 0xB1 },
	{ 0xE8, 0x9C, 0xA9 },
	{ 0xE8, 0x9C, 0xB7 },
	{ 0xE8, 0x9C, 0xBF },
	{ 0xE8, 0x9E, 0x82 },
	{ 0xE8, 0x9C, 0xA2 },
	{ 0xE8, 0x9D, 0xBD },
	{ 0xE8, 0x9D, 0xBE },
	{ 0xE8, 0x9D, 0xBB },
	{ 0xE8, 0x9D, 0xA0 },
	{ 0xE8, 0x9D, 0xB0 },
	{ 0xE8, 0x9D, 0x8C },
	{ 0xE8, 0x9D, 0xAE },
	{ 0xE8, 0x9E, 0x8B },
	{ 0xE8, 0x9D, 0x93 },
	{ 0xE8, 0x9D, 0xA3 },
	{ 0xE8, 0x9D, 0xBC },
	{ 0xE8, 0x9D, 0xA4 },
	{ 0xE8, 0x9D, 0x99 },
	{ 0xE8, 0x9D, 0xA5 },
	{ 0xE8, 0x9E, 0x93 },
	{ 0xE8, 0x9E, 0xAF },
	{ 0xE8, 0x9E, 0xA8 },
	{ 0xE8, 0x9F, 0x92 },
	{ 0xE8, 0x9F, 0x86 },
	{ 0xE8, 0x9E, 0x88 },
	{ 0xE8, 0x9E, 0x85 },
	{ 0xE8, 0x9E, 0xAD },
	{ 0xE8, 0x9E, 0x97 },
	{ 0xE8, 0x9E, 0x83 },
	{ 0xE8, 0x9E, 0xAB },
	{ 0xE8, 0x9F, 0xA5 },
	{ 0xE8, 0x9E, 0xAC },
	{ 0xE8, 0x9E, 0xB5 },
	{ 0xE8, 0x9E, 0xB3 },
	{ 0xE8, 0x9F, 0x8B },
	{ 0xE8, 0x9F, 0x93 },
	{ 0xE8, 0x9E, 0xBD },
	{ 0xE8, 0x9F, 0x91 },
	{ 0xE8, 0x9F, 0x80 },
	{ 0xE8, 0x9F, 0x8A },
	{ 0xE8, 0x9F, 0x9B },
	{ 0xE8, 0x9F, 0xAA },
	{ 0xE8, 0x9F, 0xA0 },
	{ 0xE8, 0x9F, 0xAE },
	{ 0xE8, 0xA0, 0x96 },
	{ 0xE8, 0xA0, 0x93 },
	{ 0xE8, 0x9F, 0xBE },
	{ 0xE8, 0xA0, 0x8A },
	{ 0xE8, 0xA0, 0x9B },
	{ 0xE8, 0xA0, 0xA1 },
	{ 0xE8, 0xA0, 0xB9 },
	{ 0xE8, 0xA0, 0xBC },
	{ 0xE7, 0xBC, 0xB6 },
	{ 0xE7, 0xBD, 0x82 },
	{ 0xE7, 0xBD, 0x84 },
	{ 0xE7, 0xBD, 0x85 },
	{ 0xE8, 0x88, 0x90 },
	{ 0xE7, 0xAB, 0xBA },
	{ 0xE7, 0xAB, 0xBD },
	{ 0xE7, 0xAC, 0x88 },
	{ 0xE7, 0xAC, 0x83 },
	{ 0xE7, 0xAC, 0x84 },
	{ 0xE7, 0xAC, 0x95 },
	{ 0xE7, 0xAC, 0x8A },
	{ 0xE7, 0xAC, 0xAB },
	{ 0xE7, 0xAC, 0x8F },
	{ 0xE7, 0xAD, 0x87 },
	{ 0xE7, 0xAC, 0xB8 },
	{ 0xE7, 0xAC, 0xAA },
	{ 0xE7, 0xAC, 0x99 },
	{ 0xE7, 0xAC, 0xAE },
	{ 0xE7, 0xAC, 0xB1 },
	{ 0xE7, 0xAC, 0xA0 },
	{ 0xE7, 0xAC, 0xA5 },
	{ 0xE7, 0xAC, 0xA4 },
	{ 0xE7, 0xAC, 0xB3 },
	{ 0xE7, 0xAC, 0xBE },
	{ 0xE7, 0xAC, 0x9E },
	{ 0xE7, 0xAD, 0x98 },
	{ 0xE7, 0xAD, 0x9A },
	{ 0xE7, 0xAD, 0x85 },
	{ 0xE7, 0xAD, 0xB5 },
	{ 0xE7, 0xAD, 0x8C },
	{ 0xE7, 0xAD, 0x9D },
	{ 0xE7, 0xAD, 0xA0 },
	{ 0xE7, 0xAD, 0xAE },
	{ 0xE7, 0xAD, 0xBB },
	{ 0xE7, 0xAD, 0xA2 },
	{ 0xE7, 0xAD, 0xB2 },
	{ 0xE7, 0xAD, 0xB1 },
	{ 0xE7, 0xAE, 0x90 },
	{ 0xE7, 0xAE, 0xA6 },
	{ 0xE7, 0xAE, 0xA7 },
	{ 0xE7, 0xAE, 0xB8 },
	{ 0xE7, 0xAE, 0xAC },
	{ 0xE7, 0xAE, 0x9D },
	{ 0xE7, 0xAE, 0xA8 },
	{ 0xE7, 0xAE, 0x85 },
	{ 0xE7, 0xAE, 0xAA },
	{ 0xE7, 0xAE, 0x9C },
	{ 0xE7, 0xAE, 0xA2 },
	{ 0xE7, 0xAE, 0xAB },
	{ 0xE7, 0xAE, 0xB4 },
	{ 0xE7, 0xAF, 0x91 },
	{ 0xE7, 0xAF, 0x81 },
	{ 0xE7, 0xAF, 0x8C },
	{ 0xE7, 0xAF, 0x9D },
	{ 0xE7, 0xAF, 0x9A },
	{ 0xE7, 0xAF, 0xA5 },
	{ 0xE7, 0xAF, 0xA6 },
	{ 0xE7, 0xAF, 0xAA },
	{ 0xE7, 0xB0, 0x8C },
	{ 0xE7, 0xAF, 0xBE },
	{ 0xE7, 0xAF, 0xBC },
	{ 0xE7, 0xB0, 0x8F },
	{ 0xE7, 0xB0, 0x96 },
	{ 0xE7, 0xB0, 0x8B },
	{ 0xE7, 0xB0, 0x9F },
	{ 0xE7, 0xB0, 0xAA },
	{ 0xE7, 0xB0, 0xA6 },
	{ 0xE7, 0xB0, 0xB8 },
	{ 0xE7, 0xB1, 0x81 },
	{ 0xE7, 0xB1, 0x80 },
	{ 0xE8, 0x87, 0xBE },
	{ 0xE8, 0x88, 0x81 },
	{ 0xE8, 0x88, 0x82 },
	{ 0xE8, 0x88, 0x84 },
	{ 0xE8, 0x87, 0xAC },
	{ 0xE8, 0xA1, 0x84 },
	{ 0xE8, 0x88, 0xA1 },
	{ 0xE8, 0x88, 0xA2 },
	{ 0xE8, 0x88, 0xA3 },
	{ 0xE8, 0x88, 0xAD },
	{ 0xE8, 0x88, 0xAF },
	{ 0xE8, 0x88, 0xA8 },
	{ 0xE8, 0x88, 0xAB },
	{ 0xE8, 0x88, 0xB8 },
	{ 0xE8, 0x88, 0xBB },
	{ 0xE8, 0x88, 0xB3 },
	{ 0xE8, 0x88, 0xB4 },
	{ 0xE8, 0x88, 0xBE },
	{ 0xE8, 0x89, 0x84 },
	{ 0xE8, 0x89, 0x89 },
	{ 0xE8, 0x89, 0x8B },
	{ 0xE8, 0x89, 0x8F },
	{ 0xE8, 0x89, 0x9A },
	{ 0xE8, 0x89, 0x9F },
	{ 0xE8, 0x89, 0xA8 },
	{ 0xE8, 0xA1, 0xBE },
	{ 0xE8, 0xA2, 0x85 },
	{ 0xE8, 0xA2, 0x88 },
	{ 0xE8, 0xA3, 0x98 },
	{ 0xE8, 0xA3, 0x9F },
	{ 0xE8, 0xA5, 0x9E },
	{ 0xE7, 0xBE, 0x9D },
	{ 0xE7, 0xBE, 0x9F },
	{ 0xE7, 0xBE, 0xA7 },
	{ 0xE7, 0xBE, 0xAF },
	{ 0xE7, 0xBE, 0xB0 },
	{ 0xE7, 0xBE, 0xB2 },
	{ 0xE7, 0xB1, 0xBC },
	{ 0xE6, 0x95, 0x89 },
	{ 0xE7, 0xB2, 0x91 },
	{ 0xE7, 0xB2, 0x9D },
	{ 0xE7, 0xB2, 0x9C },
	{ 0xE7, 0xB2, 0x9E },
	{ 0xE7, 0xB2, 0xA2 },
	{ 0xE7, 0xB2, 0xB2 },
	{ 0xE7, 0xB2, 0xBC },
	{ 0xE7, 0xB2, 0xBD },
	{ 0xE7, 0xB3, 0x81 },
	{ 0xE7, 0xB3, 0x87 },
	{ 0xE7, 0xB3, 0x8C },
	{ 0xE7, 0xB3, 0x8D },
	{ 0xE7, 0xB3, 0x88 },
	{ 0xE7, 0xB3, 0x85 },
	{ 0xE7, 0xB3, 0x97 },
	{ 0xE7, 0xB3, 0xA8 },
	{ 0xE8, 0x89, 0xAE },
	{ 0xE6, 0x9A, 0xA8 },
	{ 0xE7, 0xBE, 0xBF },
	{ 0xE7, 0xBF, 0x8E },
	{ 0xE7, 0xBF, 0x95 },
	{ 0xE7, 0xBF, 0xA5 },
	{ 0xE7, 0xBF, 0xA1 },
	{ 0xE7, 0xBF, 0xA6 },
	{ 0xE7, 0xBF, 0xA9 },
	{ 0xE7, 0xBF, 0xAE },
	{ 0xE7, 0xBF, 0xB3 },
	{ 0xE7, 0xB3, 0xB8 },
	{ 0xE7, 0xB5, 0xB7 },
	{ 0xE7, 0xB6, 0xA6 },
	{ 0xE7, 0xB6, 0xAE },
	{ 0xE7, 0xB9, 0x87 },
	{ 0xE7, 0xBA, 0x9B },
	{ 0xE9, 0xBA, 0xB8 },
	{ 0xE9, 0xBA, 0xB4 },
	{ 0xE8, 0xB5, 0xB3 },
	{ 0xE8, 0xB6, 0x84 },
	{ 0xE8, 0xB6, 0x94 },
	{ 0xE8, 0xB6, 0x91 },
	{ 0xE8, 0xB6, 0xB1 },
	{ 0xE8, 0xB5, 0xA7 },
	{ 0xE8, 0xB5, 0xAD },
	{ 0xE8, 0xB1, 0x87 },
	{ 0xE8, 0xB1, 0x89 },
	{ 0xE9, 0x85, 0x8A },
	{ 0xE9, 0x85, 0x90 },
	{ 0xE9, 0x85, 0x8E },
	{ 0xE9, 0x85, 0x8F },
	{ 0xE9, 0x85, 0xA4 },
	{ 0xE9, 0x85, 0xA2 },
	{ 0xE9, 0x85, 0xA1 },
	{ 0xE9, 0x85, 0xB0 },
	{ 0xE9, 0x85, 0xA9 },
	{ 0xE9, 0x85, 0xAF },
	{ 0xE9, 0x85, 0xBD },
	{ 0xE9, 0x85, 0xBE },
	{ 0xE9, 0x85, 0xB2 },
	{ 0xE9, 0x85, 0xB4 },
	{ 0xE9, 0x85, 0xB9 },
	{ 0xE9, 0x86, 0x8C },
	{ 0xE9, 0x86, 0x85 },
	{ 0xE9, 0x86, 0x90 },
	{ 0xE9, 0x86, 0x8D },
	{ 0xE9, 0x86, 0x91 },
	{ 0xE9, 0x86, 0xA2 },
	{ 0xE9, 0x86, 0xA3 },
	{ 0xE9, 0x86, 0xAA },
	{ 0xE9, 0x86, 0xAD },
	{ 0xE9, 0x86, 0xAE },
	{ 0xE9, 0x86, 0xAF },
	{ 0xE9, 0x86, 0xB5 },
	{ 0xE9, 0x86, 0xB4 },
	{ 0xE9, 0x86, 0xBA },
	{ 0xE8, 0xB1, 0x95 },
	{ 0xE9, 0xB9, 0xBE },
	{ 0xE8, 0xB6, 0xB8 },
	{ 0xE8, 0xB7, 0xAB },
	{ 0xE8, 0xB8, 0x85 },
	{ 0xE8, 0xB9, 0x99 },
	{ 0xE8, 0xB9, 0xA9 },
	{ 0xE8, 0xB6, 0xB5 },
	{ 0xE8, 0xB6, 0xBF },
	{ 0xE8, 0xB6, 0xBC },
	{ 0xE8, 0xB6, 0xBA },
	{ 0xE8, 0xB7, 0x84 },
	{ 0xE8, 0xB7, 0x96 },
	{ 0xE8, 0xB7, 0x97 },
	{ 0xE8, 0xB7, 0x9A },
	{ 0xE8, 0xB7, 0x9E },
	{ 0xE8, 0xB7, 0x8E },
	{ 0xE8, 0xB7, 0x8F },
	{ 0xE8, 0xB7, 0x9B },
	{ 0xE8, 0xB7, 0x86 },
	{ 0xE8, 0xB7, 0xAC },
	{ 0xE8, 0xB7, 0xB7 },
	{ 0xE8, 0xB7, 0xB8 },
	{ 0xE8, 0xB7, 0xA3 },
	{ 0xE8, 0xB7, 0xB9 },
	{ 0xE8, 0xB7, 0xBB },
	{ 0xE8, 0xB7, 0xA4 },
	{ 0xE8, 0xB8, 0x89 },
	{ 0xE8, 0xB7, 0xBD },
	{ 0xE8, 0xB8, 0x94 },
	{ 0xE8, 0xB8, 0x9D },
	{ 0xE8, 0xB8, 0x9F },
	{ 0xE8, 0xB8, 0xAC },
	{ 0xE8, 0xB8, 0xAE },
	{ 0xE8, 0xB8, 0xA3 },
	{ 0xE8, 0xB8, 0xAF },
	{ 0xE8, 0xB8, 0xBA },
	{ 0xE8, 0xB9, 0x80 },
	{ 0xE8, 0xB8, 0xB9 },
	{ 0xE8, 0xB8, 0xB5 },
	{ 0xE8, 0xB8, 0xBD },
	{ 0xE8, 0xB8, 0xB1 },
	{ 0xE8, 0xB9, 0x89 },
	{ 0xE8, 0xB9, 0x81 },
	{ 0xE8, 0xB9, 0x82 },
	{ 0xE8, 0xB9, 0x91 },
	{ 0xE8, 0xB9, 0x92 },
	{ 0xE8, 0xB9, 0x8A },
	{ 0xE8, 0xB9, 0xB0 },
	{ 0xE8, 0xB9, 0xB6 },
	{ 0xE8, 0xB9, 0xBC },
	{ 0xE8, 0xB9, 0xAF },
	{ 0xE8, 0xB9, 0xB4 },
	{ 0xE8, 0xBA, 0x85 },
	{ 0xE8, 0xBA, 0x8F },
	{ 0xE8, 0xBA, 0x94 },
	{ 0xE8, 0xBA, 0x90 },
	{ 0xE8, 0xBA, 0x9C },
	{ 0xE8, 0xBA, 0x9E },
	{ 0xE8, 0xB1, 0xB8 },
	{ 0xE8, 0xB2, 0x82 },
	{ 0xE8, 0xB2, 0x8A },
	{ 0xE8, 0xB2, 0x85 },
	{ 0xE8, 0xB2, 0x98 },
	{ 0xE8, 0xB2, 0x94 },
	{ 0xE6, 0x96, 0x9B },
	{ 0xE8, 0xA7, 0x96 },
	{ 0xE8, 0xA7, 0x9E },
	{ 0xE8, 0xA7, 0x9A },
	{ 0xE8, 0xA7, 0x9C },
	{ 0xE8, 0xA7, 0xA5 },
	{ 0xE8, 0xA7, 0xAB },
	{ 0xE8, 0xA7, 0xAF },
	{ 0xE8, 0xA8, 0xBE },
	{ 0xE8, 0xAC, 0xA6 },
	{ 0xE9, 0x9D, 0x93 },
	{ 0xE9, 0x9B, 0xA9 },
	{ 0xE9, 0x9B, 0xB3 },
	{ 0xE9, 0x9B, 0xAF },
	{ 0xE9, 0x9C, 0x86 },
	{ 0xE9, 0x9C, 0x81 },
	{ 0xE9, 0x9C, 0x88 },
	{ 0xE9, 0x9C, 0x8F },
	{ 0xE9, 0x9C, 0x8E },
	{ 0xE9, 0x9C, 0xAA },
	{ 0xE9, 0x9C, 0xAD },
	{ 0xE9, 0x9C, 0xB0 },
	{ 0xE9, 0x9C, 0xBE },
	{ 0xE9, 0xBE, 0x80 },
	{ 0xE9, 0xBE, 0x83 },
	{ 0xE9, 0xBE, 0x85 },
	{ 0xE9, 0xBE, 0x86 },
	{ 0xE9, 0xBE, 0x87 },
	{ 0xE9, 0xBE, 0x88 },
	{ 0xE9, 0xBE, 0x89 },
	{ 0xE9, 0xBE, 0x8A },
	{ 0xE9, 0xBE, 0x8C },
	{ 0xE9, 0xBB, 0xBE },
	{ 0xE9, 0xBC, 0x8B },
	{ 0xE9, 0xBC, 0x8D },
	{ 0xE9, 0x9A, 0xB9 },
	{ 0xE9, 0x9A, 0xBC },
	{ 0xE9, 0x9A, 0xBD },
	{ 0xE9, 0x9B, 0x8E },
	{ 0xE9, 0x9B, 0x92 },
	{ 0xE7, 0x9E, 0xBF },
	{ 0xE9, 0x9B, 0xA0 },
	{ 0xE9, 0x8A, 0x8E },
	{ 0xE9, 0x8A, 0xAE },
	{ 0xE9, 0x8B, 0x88 },
	{ 0xE9, 0x8C, 0xBE },
	{ 0xE9, 0x8D, 0xAA },
	{ 0xE9, 0x8F, 0x8A },
	{ 0xE9, 0x8E, 0x8F },
	{ 0xE9, 0x90, 0xBE },
	{ 0xE9, 0x91, 0xAB },
	{ 0xE9, 0xB1, 0xBF },
	{ 0xE9, 0xB2, 0x82 },
	{ 0xE9, 0xB2, 0x85 },
	{ 0xE9, 0xB2, 0x86 },
	{ 0xE9, 0xB2, 0x87 },
	{ 0xE9, 0xB2, 0x88 },
	{ 0xE7, 0xA8, 0xA3 },
	{ 0xE9, 0xB2, 0x8B },
	{ 0xE9, 0xB2, 0x8E },
	{ 0xE9, 0xB2, 0x90 },
	{ 0xE9, 0xB2, 0x91 },
	{ 0xE9, 0xB2, 0x92 },
	{ 0xE9, 0xB2, 0x94 },
	{ 0xE9, 0xB2, 0x95 },
	{ 0xE9, 0xB2, 0x9A },
	{ 0xE9, 0xB2, 0x9B },
	{ 0xE9, 0xB2, 0x9E },
	{ 0xE9, 0xB2, 0x9F },
	{ 0xE9, 0xB2, 0xA0 },
	{ 0xE9, 0xB2, 0xA1 },
	{ 0xE9, 0xB2, 0xA2 },
	{ 0xE9, 0xB2, 0xA3 },
	{ 0xE9, 0xB2, 0xA5 },
	{ 0xE9, 0xB2, 0xA6 },
	{ 0xE9, 0xB2, 0xA7 },
	{ 0xE9, 0xB2, 0xA8 },
	{ 0xE9, 0xB2, 0xA9 },
	{ 0xE9, 0xB2, 0xAB },
	{ 0xE9, 0xB2, 0xAD },
	{ 0xE9, 0xB2, 0xAE },
	{ 0xE9, 0xB2, 0xB0 },
	{ 0xE9, 0xB2, 0xB1 },
	{ 0xE9, 0xB2, 0xB2 },
	{ 0xE9, 0xB2, 0xB3 },
	{ 0xE9, 0xB2, 0xB4 },
	{ 0xE9, 0xB2, 0xB5 },
	{ 0xE9, 0xB2, 0xB6 },
	{ 0xE9, 0xB2, 0xB7 },
	{ 0xE9, 0xB2, 0xBA },
	{ 0xE9, 0xB2, 0xBB },
	{ 0xE9, 0xB2, 0xBC },
	{ 0xE9, 0xB2, 0xBD },
	{ 0xE9, 0xB3, 0x84 },
	{ 0xE9, 0xB3, 0x85 },
	{ 0xE9, 0xB3, 0x86 },
	{ 0xE9, 0xB3, 0x87 },
	{ 0xE9, 0xB3, 0x8A },
	{ 0xE9, 0xB3, 0x8B },
	{ 0xE9, 0xB3, 0x8C },
	{ 0xE9, 0xB3, 0x8D },
	{ 0xE9, 0xB3, 0x8E },
	{ 0xE9, 0xB3, 0x8F },
	{ 0xE9, 0xB3, 0x90 },
	{ 0xE9, 0xB3, 0x93 },
	{ 0xE9, 0xB3, 0x94 },
	{ 0xE9, 0xB3, 0x95 },
	{ 0xE9, 0xB3, 0x97 },
	{ 0xE9, 0xB3, 0x98 },
	{ 0xE9, 0xB3, 0x99 },
	{ 0xE9, 0xB3, 0x9C },
	{ 0xE9, 0xB3, 0x9D },
	{ 0xE9, 0xB3, 0x9F },
	{ 0xE9, 0xB3, 0xA2 },
	{ 0xE9, 0x9D, 0xBC },
	{ 0xE9, 0x9E, 0x85 },
	{ 0xE9, 0x9E, 0x91 },
	{ 0xE9, 0x9E, 0x92 },
	{ 0xE9, 0x9E, 0x94 },
	{ 0xE9, 0x9E, 0xAF },
	{ 0xE9, 0x9E, 0xAB },
	{ 0xE9, 0x9E, 0xA3 },
	{ 0xE9, 0x9E, 0xB2 },
	{ 0xE9, 0x9E, 0xB4 },
	{ 0xE9, 0xAA, 0xB1 },
	{ 0xE9, 0xAA, 0xB0 },
	{ 0xE9, 0xAA, 0xB7 },
	{ 0xE9, 0xB9, 0x98 },
	{ 0xE9, 0xAA, 0xB6 },
	{ 0xE9, 0xAA, 0xBA },
	{ 0xE9, 0xAA, 0xBC },
	{ 0xE9, 0xAB, 0x81 },
	{ 0xE9, 0xAB, 0x80 },
	{ 0xE9, 0xAB, 0x85 },
	{ 0xE9, 0xAB, 0x82 },
	{ 0xE9, 0xAB, 0x8B },
	{ 0xE9, 0xAB, 0x8C },
	{ 0xE9, 0xAB, 0x91 },
	{ 0xE9, 0xAD, 0x85 },
	{ 0xE9, 0xAD, 0x83 },
	{ 0xE9, 0xAD, 0x87 },
	{ 0xE9, 0xAD, 0x89 },
	{ 0xE9, 0xAD, 0x88 },
	{ 0xE9, 0xAD, 0x8D },
	{ 0xE9, 0xAD, 0x91 },
	{ 0xE9, 0xA3, 0xA8 },
	{ 0xE9, 0xA4, 0x8D },
	{ 0xE9, 0xA4, 0xAE },
	{ 0xE9, 0xA5, 0x95 },
	{ 0xE9, 0xA5, 0x94 },
	{ 0xE9, 0xAB, 0x9F },
	{ 0xE9, 0xAB, 0xA1 },
	{ 0xE9, 0xAB, 0xA6 },
	{ 0xE9, 0xAB, 0xAF },
	{ 0xE9, 0xAB, 0xAB },
	{ 0xE9, 0xAB, 0xBB },
	{ 0xE9, 0xAB, 0xAD },
	{ 0xE9, 0xAB, 0xB9 },
	{ 0xE9, 0xAC, 0x88 },
	{ 0xE9, 0xAC, 0x8F },
	{ 0xE9, 0xAC, 0x93 },
	{ 0xE9, 0xAC, 0x9F },
	{ 0xE9, 0xAC, 0xA3 },
	{ 0xE9, 0xBA, 0xBD },
	{ 0xE9, 0xBA, 0xBE },
	{ 0xE7, 0xB8, 0xBB },
	{ 0xE9, 0xBA, 0x82 },
	{ 0xE9, 0xBA, 0x87 },
	{ 0xE9, 0xBA, 0x88 },
	{ 0xE9, 0xBA, 0x8B },
	{ 0xE9, 0xBA, 0x92 },
	{ 0xE9, 0x8F, 0x96 },
	{ 0xE9, 0xBA, 0x9D },
	{ 0xE9, 0xBA, 0x9F },
	{ 0xE9, 0xBB, 0x9B },
	{ 0xE9, 0xBB, 0x9C },
	{ 0xE9, 0xBB, 0x9D },
	{ 0xE9, 0xBB, 0xA0 },
	{ 0xE9, 0xBB, 0x9F },
	{ 0xE9, 0xBB, 0xA2 },
	{ 0xE9, 0xBB, 0xA9 },
	{ 0xE9, 0xBB, 0xA7 },
	{ 0xE9, 0xBB, 0xA5 },
	{ 0xE9, 0xBB, 0xAA },
	{ 0xE9, 0xBB, 0xAF },
	{ 0xE9, 0xBC, 0xA2 },
	{ 0xE9, 0xBC, 0xAC },
	{ 0xE9, 0xBC, 0xAF },
	{ 0xE9, 0xBC, 0xB9 },
	{ 0xE9, 0xBC, 0xB7 },
	{ 0xE9, 0xBC, 0xBD },
	{ 0xE9, 0xBC, 0xBE },
	{ 0xE9, 0xBD, 0x84 },
	{ 0xEF, 0xBF, 0xBD },	/* Hold entry for non-identical convsersion. */
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_GB2312_UTF8_H */
